/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.sessionsxml;

import org.eclipse.persistence.sequencing.NativeSequence;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.factories.SessionManager;
import org.eclipse.persistence.sessions.factories.XMLSessionConfigLoader;
import org.eclipse.persistence.sessions.server.ConnectionPool;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;

public class SessionsXMLSchemaDefaultValueTest
extends AutoVerifyTestCase {
    DatabaseSession employeeSession;
    ServerSession serverSession;

    public SessionsXMLSchemaDefaultValueTest() {
        this.setDescription("Test default values from the XML schema.");
    }

    public void reset() {
        if (this.employeeSession != null && this.employeeSession.isConnected()) {
            this.employeeSession.logout();
            SessionManager.getManager().getSessions().remove(this.employeeSession);
            this.employeeSession = null;
        }
    }

    public void test() {
        XMLSessionConfigLoader loader = new XMLSessionConfigLoader("org/eclipse/persistence/testing/models/sessionsxml/XMLSchemaSessionNoDefaultedTagsAllowed.xml");
        this.employeeSession = (DatabaseSession)SessionManager.getManager().getSession(loader, "EmployeeSession", ((Object)((Object)this)).getClass().getClassLoader(), false, true);
        this.serverSession = (ServerSession)SessionManager.getManager().getSession(loader, "ServerSession", ((Object)((Object)this)).getClass().getClassLoader(), false, true);
    }

    protected void verify() {
        if (this.employeeSession == null) {
            throw new TestErrorException("Employee session is null");
        }
        if (!this.employeeSession.getDatasourceLogin().getPlatform().getSequenceTableName().equals(this.employeeSession.getPlatform().getDefaultSequenceTableName())) {
            throw new TestErrorException("The sequence table had the wrong default value");
        }
        if (!this.employeeSession.getDatasourceLogin().getPlatform().getSequenceCounterFieldName().equals("SEQ_COUNT")) {
            throw new TestErrorException("The sequence counter field name had the wrong default value");
        }
        if (!this.employeeSession.getDatasourceLogin().getPlatform().getSequenceNameFieldName().equals("SEQ_NAME")) {
            throw new TestErrorException("The sequence name field name had the wrong default value");
        }
        if (this.employeeSession.getDatasourceLogin().getPlatform().getSequencePreallocationSize() != 50) {
            throw new TestErrorException("The sequence preallocation size had the wrong default value");
        }
        if (this.employeeSession.getDatasourceLogin().getPlatform().getDefaultSequence() instanceof NativeSequence) {
            throw new TestErrorException("usesNativeSequencing status did not match the default setting");
        }
        if (this.employeeSession.getDatasourceLogin().getPlatform().getMaxBatchWritingSize() != 32000) {
            throw new TestErrorException("The max batch writing had the wrong default value");
        }
        if (this.employeeSession.getDatasourceLogin().getPlatform().usesNativeSQL()) {
            throw new TestErrorException("usesNativeSQL status did not match the default setting");
        }
        if (this.employeeSession.getDatasourceLogin().getPlatform().usesBatchWriting()) {
            throw new TestErrorException("usesBatchWriting status did not match the default setting");
        }
        if (!this.employeeSession.getDatasourceLogin().getPlatform().usesJDBCBatchWriting()) {
            throw new TestErrorException("usesJDBCBatchWriting status did not match the default setting");
        }
        if (this.employeeSession.getDatasourceLogin().getPlatform().usesNativeSQL()) {
            throw new TestErrorException("usesNativeSQL status did not match the default setting");
        }
        if (this.employeeSession.getDatasourceLogin().getPlatform().usesStringBinding()) {
            throw new TestErrorException("usesStringBinding status did not match the default setting");
        }
        if (this.employeeSession.getDatasourceLogin().getPlatform().usesStreamsForBinding()) {
            throw new TestErrorException("usesStreamsForBinding status did not match the default setting");
        }
        if (!this.employeeSession.getDatasourceLogin().getPlatform().usesByteArrayBinding()) {
            throw new TestErrorException("usesByteArrayBinding status did not match the default setting");
        }
        if (!this.employeeSession.getDatasourceLogin().getPlatform().shouldBindAllParameters()) {
            throw new TestErrorException("shouldBindAllParameters status did not match the default setting");
        }
        if (this.employeeSession.getDatasourceLogin().getPlatform().shouldCacheAllStatements()) {
            throw new TestErrorException("shouldCacheAllStatements status did not match the default setting");
        }
        if (this.employeeSession.getDatasourceLogin().getPlatform().shouldForceFieldNamesToUpperCase()) {
            throw new TestErrorException("shouldForceFieldNamesToUpperCase status did not match the default setting");
        }
        if (!this.employeeSession.getDatasourceLogin().getPlatform().shouldTrimStrings()) {
            throw new TestErrorException("shouldTrimStrings status did not match the default setting");
        }
        if (!this.employeeSession.getDatasourceLogin().getPlatform().shouldOptimizeDataConversion()) {
            throw new TestErrorException("shouldOptimizeDataConversion status did not match the default setting");
        }
        if (this.employeeSession.getDatasourceLogin().shouldUseExternalConnectionPooling()) {
            throw new TestErrorException("shouldUseExternalConnectionPooling status did not match the default setting");
        }
        if (this.employeeSession.getDatasourceLogin().shouldUseExternalTransactionController()) {
            throw new TestErrorException("shouldUseExternalTransactionController status did not match the default setting");
        }
        String logLevel = null;
        switch (this.employeeSession.getLogLevel()) {
            case 8: {
                logLevel = "off";
                break;
            }
            case 7: {
                logLevel = "severe";
                break;
            }
            case 6: {
                logLevel = "warning";
                break;
            }
            case 5: {
                logLevel = "info";
                break;
            }
            case 4: {
                logLevel = "config";
                logLevel = "config";
                break;
            }
            case 3: {
                logLevel = "fine";
                logLevel = "fine";
                break;
            }
            case 2: {
                logLevel = "finer";
                logLevel = "finer";
                break;
            }
            case 1: {
                logLevel = "finest";
                logLevel = "finest";
                break;
            }
            case 0: {
                logLevel = "all";
                logLevel = "all";
            }
        }
        if (!logLevel.equals("info")) {
            throw new TestErrorException("The log level had the wrong default value");
        }
        if (this.serverSession == null) {
            throw new TestErrorException("Server session is null");
        }
        if (!this.serverSession.getCommandManager().shouldPropagateAsynchronously()) {
            throw new TestErrorException("The initial context factory name had the wrong default value");
        }
        if (!this.serverSession.getCommandManager().getChannel().equals("TopLinkCommandChannel")) {
            throw new TestErrorException("The channel the wrong default value");
        }
        if (!this.serverSession.getCommandManager().getTransportManager().getUserName().equals("admin")) {
            throw new TestErrorException("The user name had the wrong default value");
        }
        if (!this.serverSession.getCommandManager().getTransportManager().getPassword().equals("password")) {
            throw new TestErrorException("The password had the wrong default value");
        }
        if (!this.serverSession.getCommandManager().getTransportManager().getInitialContextFactoryName().equals("weblogic.jndi.WLInitialContextFactory")) {
            throw new TestErrorException("The initial context factory name had the wrong default value");
        }
        if (!"226.10.12.64".equals("226.10.12.64")) {
            throw new TestErrorException("The multicast group address had the wrong default value");
        }
        ConnectionPool readConnPool = this.serverSession.getConnectionPool("ReadConnectionPool");
        ConnectionPool writeConnPool = this.serverSession.getConnectionPool("WriteConnectionPool");
        ConnectionPool seqConnPool = this.serverSession.getConnectionPool("SequenceConnectionPool");
    }
}

