/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.simultaneous;

import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.QueryResultsCachePolicy;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.simultaneous.MultithreadTestCase;
import org.eclipse.persistence.testing.tests.simultaneous.QueryCacheTest;

public class QueryCacheMultithreadedTest
extends MultithreadTestCase {
    public static final String CACHING_QUERY_NAME = "multithreadedCachedResultsQuery";

    public QueryCacheMultithreadedTest() {
        this.setDescription("Ensure query caching works with multithreading turned on.");
        Vector<QueryCacheTest> tests = new Vector<QueryCacheTest>();
        tests.add(new QueryCacheTest(1));
        tests.add(new QueryCacheTest(2));
        tests.add(new QueryCacheTest(3));
        tests.add(new QueryCacheTest(1));
        tests.add(new QueryCacheTest(2));
        tests.add(new QueryCacheTest(3));
        tests.add(new QueryCacheTest(1));
        tests.add(new QueryCacheTest(2));
        tests.add(new QueryCacheTest(3));
        tests.add(new QueryCacheTest(1));
        tests.add(new QueryCacheTest(2));
        tests.add(new QueryCacheTest(3));
        this.setTests(tests);
    }

    @Override
    public void setup() {
        super.setup();
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        ReadAllQuery testQuery = new ReadAllQuery(Employee.class);
        ExpressionBuilder employees = new ExpressionBuilder();
        Expression exp = employees.get("firstName").like(employees.getParameter("firstName"));
        testQuery.setSelectionCriteria(exp);
        testQuery.addArgument("firstName");
        testQuery.setQueryResultsCachePolicy(new QueryResultsCachePolicy());
        this.getSession().addQuery(CACHING_QUERY_NAME, (DatabaseQuery)testQuery);
    }

    @Override
    public void reset() {
        super.reset();
        this.getSession().removeQuery(CACHING_QUERY_NAME);
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }
}

