/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.transparentindirection;

import java.util.Stack;
import org.eclipse.persistence.queries.CursoredStream;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ValueReadQuery;
import org.eclipse.persistence.sessions.DataRecord;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestProblemException;

public class RemoteDataReadQueryTest
extends AutoVerifyTestCase {
    Stack stack;

    public RemoteDataReadQueryTest() {
        this.setDescription("Remote data read queries with various container policies");
    }

    public DataReadQuery buildNewQuery() {
        return new DataReadQuery("select ID, CUSTNAME from ORD");
    }

    protected void setup() {
        if (!this.getSession().isRemoteSession()) {
            throw new TestProblemException("session should be a remote session");
        }
    }

    public void test() {
        this.testStackContainerPolicy();
        this.testCursoredStreamPolicy();
    }

    public void testCursoredStreamPolicy() {
        ValueReadQuery sizeQuery = new ValueReadQuery("select count(*) from ORD");
        DataReadQuery query = this.buildNewQuery();
        query.useCursoredStream(5, 5, sizeQuery);
        CursoredStream stream = (CursoredStream)this.getSession().executeQuery((DatabaseQuery)query);
        int count = 0;
        while (stream.hasMoreElements()) {
            ++count;
            DataRecord row = (DataRecord)stream.nextElement();
            if (row.get((Object)"CUSTNAME") != null) continue;
            throw new TestErrorException("missing data");
        }
        if (count != this.stack.size()) {
            throw new TestErrorException("stream does not match stack - expected: " + this.stack.size() + " actual: " + count);
        }
    }

    public void testStackContainerPolicy() {
        DataReadQuery query = this.buildNewQuery();
        query.useCollectionClass(Stack.class);
        this.stack = (Stack)this.getSession().executeQuery((DatabaseQuery)query);
        DataRecord row = (DataRecord)this.stack.peek();
        if (row.get((Object)"CUSTNAME") == null) {
            throw new TestErrorException("missing data");
        }
    }
}

