/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import java.io.Serializable;
import java.math.BigDecimal;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.testing.tests.unitofwork.MailAddress;
import org.eclipse.persistence.testing.tests.unitofwork.Person;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;

public class Contact
implements Serializable {
    public BigDecimal id;
    public String type;
    public MailAddress mailAddress;
    public Person person;

    public static RelationalDescriptor descriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        OneToOneMapping addressMapping = new OneToOneMapping();
        OneToOneMapping employeeMapping = new OneToOneMapping();
        descriptor.setJavaClass(Contact.class);
        descriptor.setTableName("U_CON");
        descriptor.setPrimaryKeyFieldName("ID");
        descriptor.setSequenceNumberName("SEQ");
        descriptor.setSequenceNumberFieldName("ID");
        descriptor.addDirectMapping("id", "ID");
        descriptor.addDirectMapping("type", "TYPE");
        addressMapping.setAttributeName("mailAddress");
        addressMapping.setReferenceClass(MailAddress.class);
        addressMapping.addForeignKeyFieldName("ADDRESS", "ID");
        addressMapping.dontUseIndirection();
        descriptor.addMapping((DatabaseMapping)addressMapping);
        employeeMapping.setAttributeName("person");
        employeeMapping.setReferenceClass(Person.class);
        employeeMapping.addForeignKeyFieldName("EMP_ID", "ID");
        employeeMapping.dontUseIndirection();
        descriptor.addMapping((DatabaseMapping)employeeMapping);
        return descriptor;
    }

    public static Contact example1(Person person) {
        Contact example = new Contact();
        example.type = "Home";
        example.mailAddress = MailAddress.example1();
        example.person = person;
        return example;
    }

    public static Contact example2(Person person) {
        Contact example = new Contact();
        example.type = "Office";
        example.mailAddress = MailAddress.example2();
        example.person = person;
        return example;
    }

    public static Contact example3(Person person) {
        Contact example = new Contact();
        example.type = "Email";
        example.mailAddress = MailAddress.example3();
        example.person = person;
        return example;
    }

    public static Contact example4(Person person) {
        Contact example = new Contact();
        example.type = "Home";
        example.mailAddress = MailAddress.example4();
        example.person = person;
        return example;
    }

    public MailAddress getMailAddress() {
        return this.mailAddress;
    }

    public void setAddress(MailAddress mailAddress) {
        this.mailAddress = mailAddress;
    }

    public static TableDefinition tableDefinition() {
        TableDefinition definition = new TableDefinition();
        definition.setName("U_CON");
        definition.addIdentityField("ID", BigDecimal.class, 15);
        definition.addField("TYPE", String.class, 15);
        definition.addField("ADDRESS", BigDecimal.class, 15);
        definition.addField("EMP_ID", BigDecimal.class, 15);
        return definition;
    }
}

