/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestProblemException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class GetObjectFromIdentityMapTest
extends TestCase {
    protected Expression expression = null;
    protected Employee employee = null;

    public GetObjectFromIdentityMapTest() {
        this.setDescription("Test UnitOfWorkIdentityMapAccessor to ensure it goes to the parent session to get objects not in the UOW cache..");
    }

    public void setup() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        ExpressionBuilder employees = new ExpressionBuilder();
        this.employee = (Employee)this.getSession().readObject(Employee.class);
        if (this.employee == null) {
            throw new TestProblemException("No employees available");
        }
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.employee = (Employee)uow.getIdentityMapAccessor().getFromIdentityMap((Object)this.employee);
    }

    public void verify() {
        if (this.employee == null) {
            throw new TestErrorException("UnitOfWork did not look in its parents cache for an object when calling getFromIdentityMap(Object)");
        }
    }

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }
}

