/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork.writechanges;

import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class WriteChanges_OLReadQuery_TestCase
extends AutoVerifyTestCase {
    protected Employee employee;

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        try {
            this.employee = (Employee)uow.readObject(Employee.class);
            this.employee.setFirstName("Stephen");
            uow.writeChanges();
            ReadObjectQuery query = new ReadObjectQuery(Employee.class);
            query.setSelectionCriteria(new ExpressionBuilder().get("firstName").equal((Object)"Stephen"));
            this.employee = (Employee)uow.executeQuery((DatabaseQuery)query);
        }
        finally {
            uow.release();
        }
    }

    public void verify() {
        Employee localEmp;
        if (this.employee != null && (localEmp = (Employee)this.getAbstractSession().getIdentityMapAccessor().getFromIdentityMap((Object)this.employee)) != null && this.getAbstractSession().compareObjects((Object)this.employee, (Object)localEmp)) {
            throw new TestErrorException("The object in the UOW and the object in the Shared cache match post writeChanges.  This should not be the case");
        }
    }

    public void reset() {
    }
}

