/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.validation;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.IntegrityChecker;
import org.eclipse.persistence.internal.indirection.IndirectionPolicy;
import org.eclipse.persistence.internal.indirection.TransparentIndirectionPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.validation.ExceptionTest;

public class InvalidUseOfTransparentIndirectionTest_extractPrimaryKeyForReferenceObject
extends ExceptionTest {
    Employee employee;
    ClassDescriptor descriptor;
    OneToOneMapping mapping;
    IndirectionPolicy orgIndirectionPolicy;
    IntegrityChecker orgIntegrityChecker;

    public InvalidUseOfTransparentIndirectionTest_extractPrimaryKeyForReferenceObject() {
        this.setDescription("This tests Invalid Use Of Transparent Indirection (extractPrimaryKeyForReferenceObject) (TL-ERROR 144) ");
    }

    protected void setup() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.employee = (Employee)this.getSession().readObject(Employee.class);
        this.expectedException = DescriptorException.invalidUseOfTransparentIndirection(null);
        this.descriptor = this.getSession().getDescriptor(Employee.class);
        this.mapping = (OneToOneMapping)this.descriptor.getMappingForAttributeName("address");
        this.orgIndirectionPolicy = this.mapping.getIndirectionPolicy();
        this.mapping.setIndirectionPolicy((IndirectionPolicy)new TransparentIndirectionPolicy());
        this.orgIntegrityChecker = this.getSession().getIntegrityChecker();
        this.getSession().setIntegrityChecker(new IntegrityChecker());
        this.getSession().getIntegrityChecker().dontCatchExceptions();
    }

    @Override
    public void reset() {
        this.mapping.setIndirectionPolicy(this.orgIndirectionPolicy);
        this.getSession().setIntegrityChecker(this.orgIntegrityChecker);
    }

    public void test() {
        try {
            this.mapping.getIndirectionPolicy().extractPrimaryKeyForReferenceObject((Object)this.employee.getAddress(), (AbstractSession)this.getSession());
        }
        catch (EclipseLinkException exception) {
            this.caughtException = exception;
        }
    }
}

