/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.sessionbroker;

import junit.framework.Test;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.broker.SessionBroker;
import org.eclipse.persistence.testing.framework.InsertObjectTest;
import org.eclipse.persistence.testing.framework.OracleDBPlatformHelper;
import org.eclipse.persistence.testing.framework.ReadAllTest;
import org.eclipse.persistence.testing.framework.ReadObjectTest;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.framework.WriteObjectTest;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.EmployeePopulator;
import org.eclipse.persistence.testing.models.employee.domain.LargeProject;
import org.eclipse.persistence.testing.models.employee.domain.SmallProject;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeSystem;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeTableCreator;
import org.eclipse.persistence.testing.tests.employee.EmployeeDeleteTest;
import org.eclipse.persistence.testing.tests.employee.ProjectDeleteTest;
import org.eclipse.persistence.testing.tests.sessionbroker.BatchWritingWithSessionBrokerTest;
import org.eclipse.persistence.testing.tests.sessionbroker.EmployeeProject1;
import org.eclipse.persistence.testing.tests.sessionbroker.EmployeeProject2;
import org.eclipse.persistence.testing.tests.sessionbroker.ExternalTransactionControllerInitializationTest;
import org.eclipse.persistence.testing.tests.sessionbroker.ServerBrokerTestModel;
import org.eclipse.persistence.tools.schemaframework.PopulationManager;
import org.eclipse.persistence.tools.schemaframework.SchemaManager;

public class BrokerTestModel
extends TestModel {
    public Session oldSession;

    public BrokerTestModel() {
        this.setDescription("This model tests reading/writing/deleting using the session broker with the employee demo.");
    }

    public void addTests() {
        this.addTest((Test)BrokerTestModel.getInitializationTestSuite());
        this.addTest((Test)BrokerTestModel.getReadObjectTestSuite());
        this.addTest((Test)BrokerTestModel.getUpdateObjectTestSuite());
        this.addTest((Test)BrokerTestModel.getReadAllTestSuite());
        this.addTest((Test)BrokerTestModel.getInsertObjectTestSuite());
        this.addTest((Test)BrokerTestModel.getDeleteObjectTestSuite());
    }

    public SessionBroker buildBroker() {
        SessionBroker broker = new SessionBroker();
        DatabaseSessionImpl session1 = new DatabaseSessionImpl((Login)BrokerTestModel.getLogin1());
        DatabaseSessionImpl session2 = new DatabaseSessionImpl((Login)BrokerTestModel.getLogin2());
        session1.addDescriptors((Project)new EmployeeProject1());
        session2.addDescriptors((Project)new EmployeeProject2());
        broker.registerSession("broker1", (Session)session1);
        broker.registerSession("broker2", (Session)session2);
        broker.setSessionLog(this.oldSession.getSessionLog());
        broker.login();
        ((ManyToManyMapping)session1.getDescriptor(Employee.class).getObjectBuilder().getMappingForAttributeName("projects")).setSessionName("broker2");
        ((OneToOneMapping)session1.getDescriptor(Employee.class).getObjectBuilder().getMappingForAttributeName("address")).setShouldVerifyDelete(false);
        EmployeeTableCreator tables = new EmployeeTableCreator();
        tables.replaceTables((DatabaseSession)session1);
        tables.replaceTables((DatabaseSession)session2);
        tables.dropConstraints((DatabaseSession)session1);
        tables.dropConstraints((DatabaseSession)session2);
        new SchemaManager((DatabaseSession)session1).createSequences();
        new SchemaManager((DatabaseSession)session2).createSequences();
        new EmployeeSystem().populate((DatabaseSession)broker);
        return broker;
    }

    public static TestSuite getDeleteObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("BrokerDeleteObjectTestSuite");
        suite.setDescription("This suite tests delete SQL.");
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new EmployeeDeleteTest(manager.getObject(Employee.class, "0001")));
        suite.addTest((Test)new EmployeeDeleteTest(manager.getObject(Employee.class, "0002")));
        suite.addTest((Test)new ProjectDeleteTest(manager.getObject(LargeProject.class, "0001")));
        suite.addTest((Test)new ProjectDeleteTest(manager.getObject(SmallProject.class, "0002")));
        return suite;
    }

    public static TestSuite getInitializationTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("BrokerInitializationTestSuite");
        suite.setDescription("This suite tests Session Broker initialization.");
        suite.addTest((Test)new ExternalTransactionControllerInitializationTest());
        return suite;
    }

    public static TestSuite getInsertObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("BrokerInsertObjectTestSuite");
        suite.setDescription("This suite tests insert SQL.");
        EmployeePopulator system = new EmployeePopulator();
        suite.addTest((Test)new InsertObjectTest((Object)system.basicEmployeeExample4()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicEmployeeExample5()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicSmallProjectExample5()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicLargeProjectExample5()));
        return suite;
    }

    public static DatabaseLogin getLogin1() {
        DatabaseLogin login = new DatabaseLogin();
        try {
            login.usePlatform((DatabasePlatform)OracleDBPlatformHelper.getInstance().getOracle9Platform());
        }
        catch (Exception exception) {
            // empty catch block
        }
        login.useOracleThinJDBCDriver();
        login.setDatabaseURL("ottvm028.ca.oracle.com:1521:toplink");
        login.setUserName("QA7");
        login.setPassword("password");
        login.useNativeSequencing();
        login.getDefaultSequence().setPreallocationSize(1);
        return login;
    }

    public static DatabaseLogin getLogin2() {
        return ServerBrokerTestModel.getLogin2();
    }

    public static TestSuite getReadAllTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("BrokerReadAllTestSuite");
        suite.setDescription("This suite tests read all sql.");
        suite.addTest((Test)new ReadAllTest(Employee.class, 12));
        suite.addTest((Test)new ReadAllTest(org.eclipse.persistence.testing.models.employee.domain.Project.class, 15));
        suite.addTest((Test)new ReadAllTest(LargeProject.class, 5));
        suite.addTest((Test)new ReadAllTest(SmallProject.class, 10));
        return suite;
    }

    public static TestSuite getReadObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("BrokerReadObjectTestSuite");
        suite.setDescription("This suite test read sql.");
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new ReadObjectTest(manager.getObject(Employee.class, "0001")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(Employee.class, "0004")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(LargeProject.class, "0001")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(SmallProject.class, "0004")));
        return suite;
    }

    public static TestSuite getUpdateObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("BrokerUpdateObjectTestSuite");
        suite.setDescription("This suite tests update sql.");
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new WriteObjectTest(manager.getObject(Employee.class, "0001")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(Employee.class, "0005")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(SmallProject.class, "0001")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(LargeProject.class, "0005")));
        suite.addTest((Test)new BatchWritingWithSessionBrokerTest());
        return suite;
    }

    public void reset() {
        try {
            if (this.getExecutor().getSession() instanceof SessionBroker) {
                ((DatabaseSession)this.getExecutor().getSession()).logout();
            }
        }
        finally {
            this.getExecutor().setSession(this.oldSession);
        }
    }

    public void setup() {
        this.oldSession = this.getSession();
        this.getExecutor().setSession((Session)this.buildBroker());
    }
}

