/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.validation;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.IntegrityChecker;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.models.employee.domain.LargeProject;
import org.eclipse.persistence.testing.tests.validation.ExceptionTest;

public class ParentDescriptorNotSpecifiedTest
extends ExceptionTest {
    ClassDescriptor orgDescriptor;
    IntegrityChecker orgIntegrityChecker;

    public ParentDescriptorNotSpecifiedTest() {
        this.setDescription("This tests Parent Descriptor Not Specified (TL-ERROR 73) ");
    }

    protected void setup() {
        this.expectedException = DescriptorException.parentDescriptorNotSpecified(null, null);
        this.orgDescriptor = this.getSession().getDescriptor(LargeProject.class);
        this.orgIntegrityChecker = this.getSession().getIntegrityChecker();
    }

    @Override
    public void reset() {
        this.getSession().getDescriptors().remove(LargeProject.class);
        if (this.orgDescriptor != null) {
            ((DatabaseSession)this.getSession()).addDescriptor(this.orgDescriptor);
        }
        if (this.orgIntegrityChecker != null) {
            this.getSession().setIntegrityChecker(this.orgIntegrityChecker);
        }
    }

    public void test() {
        try {
            this.getSession().setIntegrityChecker(new IntegrityChecker());
            this.getSession().getIntegrityChecker().dontCatchExceptions();
            ((DatabaseSession)this.getSession()).addDescriptor((ClassDescriptor)this.buildLargeProjectDescriptor());
        }
        catch (EclipseLinkException exception) {
            this.caughtException = exception;
        }
    }

    public RelationalDescriptor buildLargeProjectDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(LargeProject.class);
        descriptor.addTableName("LPROJECT");
        descriptor.getInheritancePolicy().setParentClass(ParentDescriptorNotSpecifiedTest.class);
        descriptor.getInheritancePolicy().dontReadSubclassesOnQueries();
        descriptor.getInheritancePolicy().setClassIndicatorFieldName("PROJECT.PROJ_TYPE");
        descriptor.getInheritancePolicy().setShouldUseClassNameAsIndicator(true);
        descriptor.getInterfacePolicy().addParentInterface(org.eclipse.persistence.testing.models.employee.interfaces.LargeProject.class);
        descriptor.getQueryManager().checkCacheForDoesExist();
        descriptor.addTableName("PROJECT");
        descriptor.addPrimaryKeyFieldName("PROJECT.PROJ_ID");
        DirectToFieldMapping budgetMapping = new DirectToFieldMapping();
        budgetMapping.setAttributeName("budget");
        budgetMapping.setFieldName("LPROJECT.BUDGET");
        descriptor.addMapping((DatabaseMapping)budgetMapping);
        DirectToFieldMapping milestoneVersionMapping = new DirectToFieldMapping();
        milestoneVersionMapping.setAttributeName("milestoneVersion");
        milestoneVersionMapping.setFieldName("LPROJECT.MILESTONE");
        descriptor.addMapping((DatabaseMapping)milestoneVersionMapping);
        return descriptor;
    }
}

