/*
 * Copyright (c) 1998, 2020 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */

// Contributors:
//     Matt MacIvor - October 2011 - 2.4
package org.eclipse.persistence.testing.jaxb.jaxbelement.subclass;

import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.annotation.XmlElementDecl;
import jakarta.xml.bind.annotation.XmlRegistry;
import javax.xml.namespace.QName;

import org.eclipse.persistence.testing.jaxb.jaxbelement.enumeration.Coin;

@XmlRegistry
public class ObjectFactoryEnum {
/*
     @XmlElementDecl(name="root2")
        public JAXBElement<Coin> createSubClass2(Coin theCoin) {
            return new JAXBElement(new QName("root"), Coin.class, theCoin);
        }
    */
    @XmlElementDecl(name="root")
    public SubClassEnum createSubClass(Coin theCoin) {
        return new SubClassEnum(new QName("root"), Coin.class, theCoin);
    }
}
