/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.exceptions;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.i18n.ExceptionMessageGenerator;
import org.eclipse.persistence.internal.identitymaps.IdentityMap;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.sessions.Connector;
import org.eclipse.persistence.sessions.Project;

public class ValidationException
extends EclipseLinkException {
    public static final int LOGIN_BEFORE_ALLOCATING_CLIENT_SESSIONS = 7001;
    public static final int POOL_NAME_DOES_NOT_EXIST = 7002;
    public static final int MAX_SIZE_LESS_THAN_MIN_SIZE = 7003;
    public static final int POOLS_MUST_BE_CONFIGURED_BEFORE_LOGIN = 7004;
    public static final int JAVA_TYPE_IS_NOT_A_VALID_DATABASE_TYPE = 7008;
    public static final int MISSING_DESCRIPTOR = 7009;
    public static final int START_INDEX_OUT_OF_RANGE = 7010;
    public static final int STOP_INDEX_OUT_OF_RANGE = 7011;
    public static final int FATAL_ERROR_OCCURRED = 7012;
    public static final int NO_PROPERTIES_FILE_FOUND = 7013;
    public static final int CHILD_DESCRIPTORS_DO_NOT_HAVE_IDENTITY_MAP = 7017;
    public static final int FILE_ERROR = 7018;
    public static final int INCORRECT_LOGIN_INSTANCE_PROVIDED = 7023;
    public static final int INVALID_MERGE_POLICY = 7024;
    public static final int ONLY_FIELDS_ARE_VALID_KEYS_FOR_DATABASE_ROWS = 7025;
    public static final int SEQUENCE_SETUP_INCORRECTLY = 7027;
    public static final int WRITE_OBJECT_NOT_ALLOWED_IN_UNIT_OF_WORK = 7028;
    public static final int CANNOT_SET_READ_POOL_SIZE_AFTER_LOGIN = 7030;
    public static final int CANNOT_ADD_DESCRIPTORS_TO_SESSION_BROKER = 7031;
    public static final int NO_SESSION_REGISTERED_FOR_CLASS = 7032;
    public static final int NO_SESSION_REGISTERED_FOR_NAME = 7033;
    public static final int CANNOT_ADD_DESCRIPTORS_TO_SESSION = 7034;
    public static final int CANNOT_LOGIN_TO_A_SESSION = 7035;
    public static final int CANNOT_LOGOUT_OF_A_SESSION = 7036;
    public static final int CANNOT_MODIFY_SCHEMA_IN_SESSION = 7037;
    public static final int LOG_IO_ERROR = 7038;
    public static final int CANNOT_REMOVE_FROM_READ_ONLY_CLASSES_IN_NESTED_UNIT_OF_WORK = 7039;
    public static final int CANNOT_MODIFY_READ_ONLY_CLASSES_SET_AFTER_USING_UNIT_OF_WORK = 7040;
    public static final int INVALID_READ_ONLY_CLASS_STRUCTURE_IN_UNIT_OF_WORK = 7041;
    public static final int PLATFORM_CLASS_NOT_FOUND = 7042;
    public static final int NO_TABLES_TO_CREATE = 7043;
    public static final int ILLEGAL_CONTAINER_CLASS = 7044;
    public static final int CONTAINER_POLICY_DOES_NOT_USE_KEYS = 7047;
    public static final int MAP_KEY_NOT_DECLARED_IN_ITEM_CLASS = 7048;
    public static final int MISSING_MAPPING = 7051;
    public static final int ILLEGAL_USE_OF_MAP_IN_DIRECTCOLLECTION = 7052;
    public static final int CANNOT_RELEASE_NON_CLIENTSESSION = 7053;
    public static final int CANNOT_ACQUIRE_CLIENTSESSION_FROM_SESSION = 7054;
    public static final int OPTIMISTIC_LOCKING_NOT_SUPPORTED = 7055;
    public static final int WRONG_OBJECT_REGISTERED = 7056;
    public static final int KEYS_MUST_MATCH = 7057;
    public static final int INVALID_CONNECTOR = 7058;
    public static final int INVALID_DATA_SOURCE_NAME = 7059;
    public static final int CANNOT_ACQUIRE_DATA_SOURCE = 7060;
    public static final int JTS_EXCEPTION_RAISED = 7061;
    public static final int FIELD_LEVEL_LOCKING_NOTSUPPORTED_OUTSIDE_A_UNIT_OF_WORK = 7062;
    public static final int EJB_CONTAINER_EXCEPTION_RAISED = 7063;
    public static final int EJB_PRIMARY_KEY_REFLECTION_EXCEPTION = 7064;
    public static final int EJB_CANNOT_LOAD_REMOTE_CLASS = 7065;
    public static final int EJB_MUST_BE_IN_TRANSACTION = 7066;
    public static final int EJB_INVALID_PROJECT_CLASS = 7068;
    public static final int PROJECT_AMENDMENT_EXCEPTION_OCCURED = 7069;
    public static final int EJB_TOPLINK_PROPERTIES_NOT_FOUND = 7070;
    public static final int CANT_HAVE_UNBOUND_IN_OUTPUT_ARGUMENTS = 7071;
    public static final int EJB_INVALID_PLATFORM_CLASS = 7072;
    public static final int ORACLE_OBJECT_TYPE_NOT_DEFINED = 7073;
    public static final int ORACLE_OBJECT_TYPE_NAME_NOT_DEFINED = 7074;
    public static final int ORACLE_VARRAY_MAXIMIM_SIZE_NOT_DEFINED = 7075;
    public static final int DESCRIPTOR_MUST_NOT_BE_INITIALIZED = 7076;
    public static final int EJB_INVALID_FINDER_ON_HOME = 7077;
    public static final int EJB_NO_SUCH_SESSION_SPECIFIED_IN_PROPERTIES = 7078;
    public static final int EJB_DESCRIPTOR_NOT_FOUND_IN_SESSION = 7079;
    public static final int EJB_FINDER_EXCEPTION = 7080;
    public static final int CANNOT_REGISTER_AGGREGATE_OBJECT_IN_UNIT_OF_WORK = 7081;
    public static final int MULTIPLE_PROJECTS_SPECIFIED_IN_PROPERTIES = 7082;
    public static final int NO_PROJECT_SPECIFIED_IN_PROPERTIES = 7083;
    public static final int INVALID_FILE_TYPE = 7084;
    public static final int SUB_SESSION_NOT_DEFINED_FOR_BROKER = 7085;
    public static final int EJB_INVALID_SESSION_TYPE_CLASS = 7086;
    public static final int EJB_SESSION_TYPE_CLASS_NOT_FOUND = 7087;
    public static final int CANNOT_CREATE_EXTERNAL_TRANSACTION_CONTROLLER = 7088;
    public static final int SESSION_AMENDMENT_EXCEPTION_OCCURED = 7089;
    public static final int SET_LISTENER_CLASSES_EXCEPTION = 7091;
    public static final int EXISTING_QUERY_TYPE_CONFLICT = 7092;
    public static final int QUERY_ARGUMENT_TYPE_NOT_FOUND = 7093;
    public static final int ERROR_IN_SESSION_XML = 7094;
    public static final int NO_SESSIONS_XML_FOUND = 7095;
    public static final int CANNOT_COMMIT_UOW_AGAIN = 7096;
    public static final int OPERATION_NOT_SUPPORTED = 7097;
    public static final int PROJECT_XML_NOT_FOUND = 7099;
    public static final int NO_SESSION_FOUND = 7100;
    public static final int NO_TOPLINK_EJB_JAR_XML_FOUND = 7101;
    public static final int NULL_CACHE_KEY_FOUND_ON_REMOVAL = 7102;
    public static final int NULL_UNDERLYING_VALUEHOLDER_VALUE = 7103;
    public static final int INVALID_SEQUENCING_LOGIN = 7104;
    public static final int INVALID_ENCRYPTION_CLASS = 7105;
    public static final int ERROR_ENCRYPTING_PASSWORD = 7106;
    public static final int ERROR_DECRYPTING_PASSWORD = 7107;
    public static final int NOT_SUPPORTED_FOR_DATASOURCE = 7108;
    public static final int PROJECT_LOGIN_IS_NULL = 7109;
    public static final int HISTORICAL_SESSION_ONLY_SUPPORTED_ON_ORACLE = 7110;
    public static final int CANNOT_ACQUIRE_HISTORICAL_SESSION = 7111;
    public static final int FEATURE_NOT_SUPPORTED_IN_JDK_VERSION = 7112;
    public static final int PLATFORM_DOES_NOT_SUPPORT_CALL_WITH_RETURNING = 7113;
    public static final int ISOLATED_DATA_NOT_SUPPORTED_IN_CLIENTSESSIONBROKER = 7114;
    public static final int CLIENT_SESSION_CANNOT_USE_EXCLUSIVE_CONNECTION = 7115;
    public static final int INVALID_METHOD_ARGUMENTS = 7116;
    public static final int MULTIPLE_CURSORS_NOT_SUPPORTED = 7117;
    public static final int WRONG_USAGE_OF_SET_CUSTOM_SQL_ARGUMENT_TYPE_METOD = 7118;
    public static final int CANNOT_TRANSLATE_UNPREPARED_CALL = 7119;
    public static final int CANNOT_SET_CURSOR_FOR_PARAMETER_TYPE_OTHER_THAN_OUT = 7120;
    public static final int PLATFORM_DOES_NOT_SUPPORT_STORED_FUNCTIONS = 7121;
    public static final int EXCLUSIVE_CONNECTION_NO_LONGER_AVAILABLE = 7122;
    public static final int UNIT_OF_WORK_IN_TRANSACTION_COMMIT_PENDING = 7123;
    public static final int UNIT_OF_WORK_AFTER_WRITE_CHANGES_FAILED = 7124;
    public static final int INACTIVE_UNIT_OF_WORK = 7125;
    public static final int CANNOT_WRITE_CHANGES_ON_NESTED_UNIT_OF_WORK = 7126;
    public static final int CANNOT_WRITE_CHANGES_TWICE = 7127;
    public static final int ALREADY_LOGGED_IN = 7128;
    public static final int INVALID_NULL_METHOD_ARGUMENTS = 7129;
    public static final int NESTED_UOW_NOT_SUPPORTED_FOR_ATTRIBUTE_TRACKING = 7130;
    public static final int WRONG_COLLECTION_CHANGE_EVENT_TYPE = 7131;
    public static final int WRONG_CHANGE_EVENT = 7132;
    public static final int OLD_COMMIT_NOT_SUPPORTED_FOR_ATTRIBUTE_TRACKING = 7133;
    public static final int SERVER_PLATFORM_IS_READ_ONLY_AFTER_LOGIN = 7134;
    public static final int CANNOT_COMMIT_AND_RESUME_UOW_WITH_MODIFY_ALL_QUERIES = 7135;
    public static final int NESTED_UOW_NOT_SUPPORTED_FOR_MODIFY_ALL_QUERY = 7136;
    public static final int UNFETCHED_ATTRIBUTE_NOT_EDITABLE = 7137;
    public static final int OBJECT_NEED_IMPL_TRACKER_FOR_FETCH_GROUP_USAGE = 7138;
    public static final int MODIFY_ALL_QUERIES_NOT_SUPPORTED_WITH_OTHER_WRITES = 7139;
    public static final int WRONG_SEQUENCE_TYPE = 7140;
    public static final int CANNOT_SET_DEFAULT_SEQUENCE_AS_DEFAULT = 7141;
    public static final int DEFAULT_SEQUENCE_NAME_ALREADY_USED_BY_SEQUENCE = 7142;
    public static final int SEQUENCE_NAME_ALREADY_USED_BY_DEFAULT_SEQUENCE = 7143;
    public static final int PLATFORM_DOES_NOT_SUPPORT_SEQUENCE = 7144;
    public static final int SEQUENCE_CANNOT_BE_CONNECTED_TO_TWO_PLATFORMS = 7145;
    public static final int QUERY_SEQUENCE_DOES_NOT_HAVE_SELECT_QUERY = 7146;
    public static final int CREATE_PLATFORM_DEFAULT_SEQUENCE_UNDEFINED = 7147;
    public static final int CANNOT_RESUME_SYNCHRONIZED_UOW = 7148;
    public static final int INVALID_COMPOSITE_PK_ATTRIBUTE = 7149;
    public static final int INVALID_COMPOSITE_PK_SPECIFICATION = 7150;
    public static final int INVALID_TYPE_FOR_ENUMERATED_ATTRIBUTE = 7151;
    public static final int MAPPING_ANNOTATIONS_APPLIED_TO_TRANSIENT_ATTRIBUTE = 7153;
    public static final int NO_MAPPED_BY_ATTRIBUTE_FOUND = 7154;
    public static final int INVALID_TYPE_FOR_SERIALIZED_ATTRIBUTE = 7155;
    public static final int UNABLE_TO_LOAD_CLASS = 7156;
    public static final int INVALID_COLUMN_ANNOTATION_ON_RELATIONSHIP = 7157;
    public static final int ERROR_PROCESSING_NAMED_QUERY = 7158;
    public static final int COULD_NOT_FIND_MAP_KEY = 7159;
    public static final int UNI_DIRECTIONAL_ONE_TO_MANY_HAS_JOINCOLUMN_ANNOTATIONS = 7160;
    public static final int NO_PK_ANNOTATIONS_FOUND = 7161;
    public static final int MULTIPLE_EMBEDDED_ID_ANNOTATIONS_FOUND = 7162;
    public static final int EMBEDDED_ID_AND_ID_ANNOTATIONS_FOUND = 7163;
    public static final int INVALID_TYPE_FOR_LOB_ATTRIBUTE = 7164;
    public static final int INVALID_TYPE_FOR_TEMPORAL_ATTRIBUTE = 7165;
    public static final int TABLE_GENERATOR_RESERVED_NAME = 7166;
    public static final int SEQUENCE_GENERATOR_RESERVED_NAME = 7167;
    public static final int INVALID_TYPE_FOR_VERSION_ATTRIBUTE = 7168;
    public static final int ONLY_ONE_GENERATED_VALURE_IS_ALLOWED = 7169;
    public static final int ERROR_INSTANTIATING_CLASS = 7172;
    public static final int WRONG_PROPERTY_NAME_IN_CHANGE_EVENT = 7173;
    public static final int NO_CORRESPONDING_SETTER_METHOD_DEFINED = 7174;
    public static final int UNSUPPORTED_CASCADE_LOCKING_MAPPING = 7175;
    public static final int UNSUPPORTED_CASCADE_LOCKING_MAPPING_WITH_CUSTOM_QUERY = 7176;
    public static final int UNSUPPORTED_CASCADE_LOCKING_DESCRIPTOR = 7177;
    public static final int ORACLEOCIPROXYCONNECTOR_REQUIRES_ORACLEOCICONNECTIONPOOL = 7178;
    public static final int ORACLEJDBC10_1_0_2PROXYCONNECTOR_REQUIRES_ORACLECONNECTION = 7179;
    public static final int ORACLEJDBC10_1_0_2PROXYCONNECTOR_REQUIRES_ORACLECONNECTION_VERSION = 7180;
    public static final int ORACLEJDBC10_1_0_2PROXYCONNECTOR_REQUIRES_INT_PROXYTYPE = 7181;
    public static final int COULD_NOT_FIND_DRIVER_CLASS = 7182;
    public static final int ERROR_CLOSING_PERSISTENCE_XML = 7183;
    public static final int CONFIG_FACTORY_NAME_PROPERTY_NOT_SPECIFIED = 7184;
    public static final int CONFIG_FACTORY_NAME_PROPERTY_NOT_FOUND = 7185;
    public static final int CANNOT_INVOKE_METHOD_ON_CONFIG_CLASS = 7186;
    public static final int CONFIG_METHOD_NOT_DEFINED = 7187;
    public static final int CLASS_LIST_MUST_NOT_BE_NULL = 7188;
    public static final int CURRENT_LOADER_NOT_VALID = 7189;
    public static final int METHOD_FAILED = 7190;
    public static final int ENTITY_CLASS_NOT_FOUND = 7191;
    public static final int CLASS_FILE_TRANSFORMER_THROWS_EXCEPTION = 7192;
    public static final int JAR_FILES_IN_PERSISTENCE_XML_NOT_SUPPORTED = 7193;
    public static final int COULD_NOT_BIND_JNDI = 7194;
    public static final int EXCEPTION_CONFIGURING_EM_FACTORY = 7195;
    public static final int NULL_PK_IN_UOW_CLONE = 7197;
    public static final int CANNOT_CAST_TO_CLASS = 7196;
    public static final int CLASS_NOT_FOUND_WHILE_CONVERTING_CLASSNAMES = 7198;
    public static final int PRIMARY_TABLE_NOT_DEFINED_FOR_RELATIONSHIP = 7199;
    public static final int INVALID_EMBEDDABLE_ATTRIBUTE = 7200;
    public static final int INVALID_ENTITY_MAPPINGS_DOCUMENT = 7201;
    public static final int INVALID_ATTRIBUTE_OVERRIDE_NAME = 7202;
    public static final int INVALID_COLLECTION_TYPE_FOR_RELATIONSHIP = 7203;
    public static final int INVALID_CLASS_TYPE_FOR_BLOB_ATTRIBUTE = 7207;
    public static final int INVALID_CLASS_TYPE_FOR_CLOB_ATTRIBUTE = 7208;
    public static final int MAPPING_METADATA_APPLIED_TO_INVALID_ATTRIBUTE = 7211;
    public static final int NO_TEMPORAL_TYPE_SPECIFIED = 7212;
    public static final int CIRCULAR_MAPPED_BY_REFERENCES = 7213;
    public static final int UNABLE_TO_DETERMINE_TARGET_ENTITY = 7214;
    public static final int INVALID_FIELD_FOR_CLASS = 7215;
    public static final int INVALID_PROPERTY_FOR_CLASS = 7216;
    public static final int INVALID_ORDER_BY_VALUE = 7217;
    public static final int PLATFORM_DOES_NOT_OVERRIDE_GETCREATETEMPTABLESQLPREFIX = 7218;
    public static final int MAPPING_DOES_NOT_OVERRIDE_VALUEFROMROWINTERNALWITHJOIN = 7219;
    public static final int INCOMPLETE_JOIN_COLUMNS_SPECIFIED = 7220;
    public static final int INCOMPLETE_PRIMARY_KEY_JOIN_COLUMNS_SPECIFIED = 7222;
    public static final int EXCESSIVE_PRIMARY_KEY_JOIN_COLUMNS_SPECIFIED = 7223;
    public static final int INVALID_CALLBACK_METHOD = 7224;
    public static final int INVALID_CALLBACK_METHOD_NAME = 7225;
    public static final int INVALID_CALLBACK_METHOD_MODIFIER = 7226;
    public static final int MULTIPLE_CALLBACK_METHODS_DEFINED = 7227;
    public static final int INVALID_ENTITY_CALLBACK_METHOD_ARGUMENTS = 7228;
    public static final int INVALID_ENTITY_LISTENER_CALLBACK_METHOD_ARGUMENTS = 7229;
    public static final int CANNOT_PERSIST_MANAGED_OBJECT = 7231;
    public static final int UNSPECIFIED_COMPOSITE_PK_NOT_SUPPORTED = 7232;
    public static final int MAPPING_METADATA_APPLIED_TO_METHOD_WITH_ARGUMENTS = 7233;
    public static final int MISSING_FIELD_TYPE_FOR_DDL_GENERATION_OF_CLASS_TRANSFORMATION_ = 7234;
    public static final int MISSING_TRANSFORMER_METHOD_FOR_DDL_GENERATION_OF_CLASS_TRANSFORMATION = 7235;
    public static final int NON_UNIQUE_ENTITY_NAME = 7237;
    public static final int CONFLICTING_SEQUENCE_AND_TABLE_GENERATORS_SPECIFIED = 7238;
    public static final int CONFLICTING_SEQUENCE_NAME_AND_TABLE_PK_COLUMN_VALUE_SPECIFIED = 7240;
    public static final int INSTANTIATING_VALUEHOLDER_WITH_NULL_SESSION = 7242;
    public static final int CLASS_NOT_LISTED_IN_PERSISTENCE_UNIT = 7243;
    public static final int INVALID_MAPPING = 7244;
    public static final int CONFLICTNG_ACCESS_TYPE_FOR_EMBEDDABLE = 7245;
    public static final int INVALID_EMBEDDED_ATTRIBUTE = 7246;
    public static final int EMBEDDED_ID_CLASS_HAS_NO_ATTRIBUTES = 7249;
    public static final int NON_ENTITY_AS_TARGET_IN_RELATIONSHIP = 7250;
    public static final int PRIMARY_KEY_UPDATE_DISALLOWED = 7251;
    public static final int NON_UNIQUE_MAPPING_FILE_NAME = 7252;
    public static final int MAPPING_FILE_NOT_FOUND = 7253;
    public static final int MULTIPLE_OBJECT_VALUES_FOR_DATA_VALUE = 7254;
    public static final int INVALID_MAPPING_FOR_CONVERTER = 7255;
    public static final int CONVERTER_NOT_FOUND = 7256;
    public static final int ERROR_INSTANTIATING_CONVERSION_VALUE_DATA = 7257;
    public static final int ERROR_INSTANTIATING_CONVERSION_VALUE_OBJECT = 7258;
    public static final int NO_CONVERTER_DATA_TYPE_SPECIFIED = 7259;
    public static final int NO_CONVERTER_OBJECT_TYPE_SPECIFIED = 7260;
    public static final int INVALID_TYPE_FOR_BASIC_COLLECTION_ATTRIBUTE = 7261;
    public static final int INVALID_TYPE_FOR_BASIC_MAP_ATTRIBUTE = 7262;
    public static final int OPTIMISTIC_LOCKING_SELECTED_COLUMN_NAMES_NOT_SPECIFIED = 7263;
    public static final int OPTIMISTIC_LOCKING_VERSION_ELEMENT_NOT_SPECIFIED = 7264;
    public static final int CACHE_NOT_SUPPORTED_WITH_EMBEDDABLE = 7265;
    public static final int CACHE_EXPIRY_AND_EXPIRY_TIME_OF_DAY_BOTH_SPECIFIED = 7266;
    public static final int INVALID_EXCEPTIONHANDLER_CLASS = 7267;
    public static final int INVALID_SESSIONEVENTLISTENER_CLASS = 7268;
    public static final int INVALID_CACHESTATEMENTS_SIZE_VALUE = 7270;
    public static final int INVALID_BOOLEAN_VALUE_FOR_SETTING_NATIVESQL = 7271;
    public static final int INVALID_BOOLEAN_VALUE_FOR_ENABLESTATMENTSCACHED = 7272;
    public static final int INVALID_BOOLEAN_VALUE_FOR_ADDINGNAMEDQUERIES = 7273;
    public static final int INVALID_LOGGING_FILE = 7274;
    public static final int CANNOT_INSTANTIATE_EXCEPTIONHANDLER_CLASS = 7275;
    public static final int CANNOT_INSTANTIATE_SESSIONEVENTLISTENER_CLASS = 7276;
    public static final int LOGGING_FILE_NAME_CANNOT_BE_EMPTY = 7277;
    public static final int INVALID_BOOLEAN_VALUE_FOR_PROPERTY = 7278;
    public static final int INVALID_VALUE_FOR_PROPERTY = 7308;
    public static final int INVALID_MAPPING_FOR_STRUCT_CONVERTER = 7282;
    public static final int TWO_STRUCT_CONVERTERS_ADDED_FOR_SAME_CLASS = 7283;
    public static final int INVALID_COMPARATOR_CLASS = 7284;
    public static final int INVALID_PROFILER_CLASS = 7285;
    public static final int CANNOT_INSTANTIATE_PROFILER_CLASS = 7286;
    public static final int READ_TRANSFORMER_CLASS_DOESNT_IMPLEMENT_ATTRIBUTE_TRANSFORMER = 7287;
    public static final int READ_TRANSFORMER_HAS_BOTH_CLASS_AND_METHOD = 7288;
    public static final int READ_TRANSFORMER_HAS_NEITHER_CLASS_NOR_METHOD = 7289;
    public static final int WRITE_TRANSFORMER_CLASS_DOESNT_IMPLEMENT_FIELD_TRANSFORMER = 7290;
    public static final int WRITE_TRANSFORMER_HAS_BOTH_CLASS_AND_METHOD = 7291;
    public static final int WRITE_TRANSFORMER_HAS_NEITHER_CLASS_NOR_METHOD = 7292;
    public static final int WRITE_TRANSFORMER_HAS_NO_COLUMN_NAME = 7293;
    public static final int MULTIPLE_CLASSES_FOR_THE_SAME_DISCRIMINATOR = 7294;
    public static final int COPY_POLICY_MUST_SPECIFY_METHOD_OR_WORKING_COPY_METHOD = 7295;
    public static final int MULTIPLE_COPY_POLICY_ANNOTATIONS_ON_SAME_CLASS = 7296;
    public static final int REFLECTIVE_EXCEPTION_WHILE_CREATING_CLASS_INSTANCE = 7297;
    public static final int INVALID_MAPPING_FOR_EMBEDDED_ID = 7298;
    public static final int CONFLICTING_NAMED_ANNOTATIONS = 7299;
    public static final int CONFLICTING_NAMED_XML_ELEMENTS = 7300;
    public static final int CONFLICTING_ANNOTATIONS = 7301;
    public static final int CONFLICTING_XML_ELEMENTS = 7302;
    public static final int EXPECTED_PROXY_PROPERTY_NOT_FOUND = 7303;
    public static final int UNKNOWN_PROXY_TYPE = 7304;
    public static final int ERROR_PARSING_MAPPING_FILE = 7305;
    public static final int INVALID_EXPLICIT_ACCESS_TYPE = 7306;
    public static final int MISSING_CONTEXT_STRING_FOR_CONTEXT = 7307;

    public ValidationException() {
    }

    protected ValidationException(String theMessage) {
        super(theMessage);
    }

    protected ValidationException(String message, Exception internalException) {
        super(message, internalException);
    }

    public static ValidationException alreadyLoggedIn(String sessionName) {
        Object[] args = new Object[]{sessionName};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7128, args));
        validationException.setErrorCode(7128);
        return validationException;
    }

    public static ValidationException cacheExpiryAndExpiryTimeOfDayBothSpecified(Class javaClass) {
        Object[] args = new Object[]{javaClass};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7266, args));
        validationException.setErrorCode(7266);
        return validationException;
    }

    public static ValidationException cacheNotSupportedWithEmbeddable(Class embeddableClass) {
        Object[] args = new Object[]{embeddableClass};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7265, args));
        validationException.setErrorCode(7265);
        return validationException;
    }

    public static ValidationException cannotAcquireClientSessionFromSession() {
        Object[] args = new Object[]{};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7054, args));
        validationException.setErrorCode(7054);
        return validationException;
    }

    public static ValidationException cannotAcquireDataSource(Object name, Exception exception) {
        Object[] args = new Object[]{name};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7060, args), exception);
        validationException.setErrorCode(7060);
        return validationException;
    }

    public static ValidationException cannotAcquireHistoricalSession() {
        Object[] args = new Object[]{};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7111, args));
        validationException.setErrorCode(7111);
        return validationException;
    }

    public static ValidationException cannotAddDescriptorsToSessionBroker() {
        Object[] args = new Object[]{};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7031, args));
        validationException.setErrorCode(7031);
        return validationException;
    }

    public static ValidationException cannotCastToClass(Object ob, Class objectClass, Class castClass) {
        Object[] args = new Object[]{ob, objectClass, castClass};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7196, args));
        validationException.setErrorCode(7196);
        return validationException;
    }

    public static ValidationException cannotCommitAndResumeSynchronizedUOW(UnitOfWorkImpl uow) {
        Object[] args = new Object[]{};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7148, args));
        validationException.setErrorCode(7148);
        validationException.setSession(uow);
        return validationException;
    }

    public static ValidationException cannotCommitAndResumeUOWWithModifyAllQueries() {
        Object[] args = new Object[]{};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7135, args));
        validationException.setErrorCode(7135);
        return validationException;
    }

    public static ValidationException cannotCommitUOWAgain() {
        Object[] args = new Object[]{};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7096, args));
        validationException.setErrorCode(7096);
        return validationException;
    }

    public static ValidationException cannotCreateExternalTransactionController(String externalTransactionControllerName) {
        Object[] args = new Object[]{externalTransactionControllerName};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7088, args));
        validationException.setErrorCode(7088);
        return validationException;
    }

    public static ValidationException notSupportedForDatasource() {
        Object[] args = new Object[]{};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7108, args));
        validationException.setErrorCode(7108);
        return validationException;
    }

    public static ValidationException cannotSetListenerClasses(Exception exception) {
        Object[] args = new Object[]{};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7091, args), exception);
        validationException.setErrorCode(7091);
        return validationException;
    }

    public static ValidationException cannotHaveUnboundInOutputArguments() {
        Object[] args = new Object[]{};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7071, args));
        validationException.setErrorCode(7071);
        return validationException;
    }

    public static ValidationException cannotModifyReadOnlyClassesSetAfterUsingUnitOfWork() {
        Object[] args = new Object[]{CR};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7040, args));
        validationException.setErrorCode(7040);
        return validationException;
    }

    public static ValidationException cannotRegisterAggregateObjectInUnitOfWork(Class type) {
        Object[] args = new Object[]{type};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7081, args));
        validationException.setErrorCode(7081);
        return validationException;
    }

    public static ValidationException cannotReleaseNonClientSession() {
        Object[] args = new Object[]{};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7053, args));
        validationException.setErrorCode(7053);
        return validationException;
    }

    public static ValidationException cannotRemoveFromReadOnlyClassesInNestedUnitOfWork() {
        Object[] args = new Object[]{CR};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7039, args));
        validationException.setErrorCode(7039);
        return validationException;
    }

    public static ValidationException cannotSetReadPoolSizeAfterLogin() {
        Object[] args = new Object[]{};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7030, args));
        validationException.setErrorCode(7030);
        return validationException;
    }

    public static ValidationException childDescriptorsDoNotHaveIdentityMap() {
        Object[] args = new Object[]{};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7017, args));
        validationException.setErrorCode(7017);
        return validationException;
    }

    public static ValidationException circularMappedByReferences(Class cls1, String attributeName1, Class cls2, String attributeName2) {
        Object[] args = new Object[]{cls1, attributeName1, cls2, attributeName2};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7213, args));
        validationException.setErrorCode(7213);
        return validationException;
    }

    public static ValidationException clientSessionCanNotUseExclusiveConnection() {
        Object[] args = new Object[]{};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7115, args));
        validationException.setErrorCode(7115);
        return validationException;
    }

    public static ValidationException containerPolicyDoesNotUseKeys(ContainerPolicy aPolicy, String methodName) {
        Object[] args = new Object[]{aPolicy.getContainerClass().toString(), methodName};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7047, args));
        validationException.setErrorCode(7047);
        return validationException;
    }

    public static ValidationException converterNotFound(Class cls, String converterName, Object element) {
        Object[] args = new Object[]{cls, converterName, element};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7256, args));
        validationException.setErrorCode(7256);
        return validationException;
    }

    public static ValidationException descriptorMustBeNotInitialized(ClassDescriptor descriptor) {
        Object[] args = new Object[]{descriptor, CR};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7076, args));
        validationException.setErrorCode(7076);
        return validationException;
    }

    public static ValidationException ejbCannotLoadRemoteClass(Exception exception, Class beanClass, String remoteClass) {
        Object[] args = new Object[]{beanClass, remoteClass, CR};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7065, args), exception);
        validationException.setErrorCode(7065);
        return validationException;
    }

    public static ValidationException ejbContainerExceptionRaised(Exception exception) {
        Object[] args = new Object[]{};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7063, args), exception);
        validationException.setErrorCode(7063);
        return validationException;
    }

    public static ValidationException ejbDescriptorNotFoundInSession(Class beanClass, String sessionName) {
        Object[] args = new Object[]{beanClass.getName(), sessionName};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7079, args));
        validationException.setErrorCode(7079);
        return validationException;
    }

    public static ValidationException ejbFinderException(Object bean, Throwable finderException, Vector primaryKey) {
        Object[] args = new Object[]{bean, bean.getClass(), primaryKey};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7080, args));
        validationException.setErrorCode(7080);
        return validationException;
    }

    public static ValidationException ejbInvalidHomeInterfaceClass(Class homeClassName) {
        Object[] args = new Object[]{homeClassName.toString()};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7077, args));
        validationException.setErrorCode(7077);
        return validationException;
    }

    public static ValidationException ejbInvalidPlatformClass(String platformName, String projectName) {
        Object[] args = new Object[]{platformName, projectName};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7072, args));
        validationException.setErrorCode(7072);
        return validationException;
    }

    public static ValidationException ejbInvalidProjectClass(String projectClassName, String projectName, Throwable aThrowable) {
        Object[] args = new Object[]{projectClassName, projectName};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7068, args));
        validationException.setInternalException(aThrowable);
        validationException.setErrorCode(7068);
        return validationException;
    }

    public static ValidationException ejbInvalidSessionTypeClass(String sessionType, String sessionName) {
        Object[] args = new Object[]{sessionType, sessionName};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7086, args));
        validationException.setErrorCode(7086);
        return validationException;
    }

    public static ValidationException ejbMustBeInTransaction(Object bean) {
        Object[] args = new Object[]{bean, CR};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7066, args));
        validationException.setErrorCode(7066);
        return validationException;
    }

    public static ValidationException ejbNoSuchSessionSpecifiedInProperties(String sessionName, Class beanClass) {
        Object[] args = new Object[]{sessionName, beanClass};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7078, args));
        validationException.setErrorCode(7078);
        return validationException;
    }

    public static ValidationException ejbPrimaryKeyReflectionException(Exception exception, Object primaryKey, Object bean) {
        Object[] args = new Object[]{primaryKey, bean, CR};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7064, args), exception);
        validationException.setErrorCode(7064);
        return validationException;
    }

    public static ValidationException ejbSessionTypeClassNotFound(String sessionType, String sessionName, Throwable exception) {
        Object[] args = new Object[]{sessionType, sessionName};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7087, args));
        validationException.setErrorCode(7087);
        validationException.setInternalException(exception);
        return validationException;
    }

    public static ValidationException ejbPersistenceUnitPropertiesNotFound(Exception exception) {
        Object[] args = new Object[]{};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7070, args));
        validationException.setInternalException(exception);
        validationException.setErrorCode(7070);
        return validationException;
    }

    public static ValidationException errorParsingMappingFile(URL mappingFileURL, Exception exception) {
        Object[] args = new Object[]{mappingFileURL};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7305, args), exception);
        validationException.setErrorCode(7305);
        return validationException;
    }

    public static ValidationException errorProcessingNamedQuery(Class entityClass, String namedQuery, Exception exception) {
        Object[] args = new Object[]{entityClass, namedQuery};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7158, args), exception);
        validationException.setErrorCode(7158);
        return validationException;
    }

    public static ValidationException errorInSessionsXML(String translatedExceptions) {
        ValidationException validationException = new ValidationException(translatedExceptions);
        validationException.setErrorCode(7094);
        return validationException;
    }

    public static ValidationException errorInstantiatingClass(Class cls, Exception exception) {
        Object[] args = new Object[]{cls};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7172, args), exception);
        validationException.setErrorCode(7172);
        return validationException;
    }

    public static ValidationException errorInstantiatingConversionValueData(String converterName, String value, Class type, Exception exception) {
        Object[] args = new Object[]{converterName, value, type};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7257, args), exception);
        validationException.setErrorCode(7257);
        return validationException;
    }

    public static ValidationException errorInstantiatingConversionValueObject(String converterName, String value, Class type, Exception exception) {
        Object[] args = new Object[]{converterName, value, type};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7258, args), exception);
        validationException.setErrorCode(7258);
        return validationException;
    }

    public static ValidationException noPropertiesFileFound(Exception exception) {
        Object[] args = new Object[]{};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7013, args), exception);
        validationException.setErrorCode(7013);
        return validationException;
    }

    public static ValidationException noSessionsXMLFound(String resourceName) {
        Object[] args = new Object[]{resourceName};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7095, args));
        validationException.setErrorCode(7095);
        return validationException;
    }

    public static ValidationException errorEncryptingPassword(Exception exception) {
        Object[] args = new Object[]{};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7106, args), exception);
        validationException.setErrorCode(7106);
        return validationException;
    }

    public static ValidationException embeddedIdAndIdAnnotationFound(Class entityClass, String embeddedIdAttributeName, String idAttributeName) {
        Object[] args = new Object[]{entityClass, embeddedIdAttributeName, idAttributeName};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7163, args));
        validationException.setErrorCode(7163);
        return validationException;
    }

    public static ValidationException errorDecryptingPassword(Exception exception) {
        Object[] args = new Object[]{};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7107, args), exception);
        validationException.setErrorCode(7107);
        return validationException;
    }

    public static ValidationException invalidEncryptionClass(String className, Throwable throwableError) {
        Object[] args = new Object[]{className};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7105, args));
        validationException.setErrorCode(7105);
        validationException.setInternalException(throwableError);
        return validationException;
    }

    public static ValidationException invalidEntityCallbackMethodArguments(Class entityClass, String methodName) {
        Object[] args = new Object[]{entityClass, methodName};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7228, args));
        validationException.setErrorCode(7228);
        return validationException;
    }

    public static ValidationException invalidEntityListenerCallbackMethodArguments(Class entityClass, Class parameterClass, Class entityListener, String methodName) {
        Object[] args = new Object[]{entityClass, parameterClass, entityListener, methodName};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7229, args));
        validationException.setErrorCode(7229);
        return validationException;
    }

    public static ValidationException noTopLinkEjbJarXMLFound() {
        Object[] args = new Object[]{};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7101, args));
        validationException.setErrorCode(7101);
        return validationException;
    }

    public static ValidationException excusiveConnectionIsNoLongerAvailable(DatabaseQuery query, AbstractSession session) {
        Object[] args = new Object[]{query.getReferenceClass().getName()};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7122, args));
        validationException.setErrorCode(7122);
        validationException.setSession(session);
        return validationException;
    }

    public static ValidationException existingQueryTypeConflict(DatabaseQuery newQuery, DatabaseQuery existingQuery) {
        Object[] args = new Object[]{newQuery, newQuery.getName(), newQuery.getArgumentTypes(), existingQuery, existingQuery.getName(), existingQuery.getArgumentTypes()};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7092, args));
        validationException.setErrorCode(7092);
        return validationException;
    }

    public static ValidationException fatalErrorOccurred(Exception exception) {
        Object[] args = new Object[]{};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7012, args), exception);
        validationException.setErrorCode(7012);
        return validationException;
    }

    public static ValidationException featureIsNotAvailableInRunningJDKVersion(String feature) {
        Object[] args = new Object[]{feature, System.getProperty("java.version")};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7112, args));
        validationException.setErrorCode(7112);
        return validationException;
    }

    public static ValidationException fieldLevelLockingNotSupportedWithoutUnitOfWork() {
        Object[] args = new Object[]{};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7062, args));
        validationException.setErrorCode(7062);
        return validationException;
    }

    public static ValidationException invalidOrderByValue(String referenceAttribute, Class referenceClass, String entityAttribute, Class entityClass) {
        Object[] args = new Object[]{referenceAttribute, referenceClass, entityAttribute, entityClass};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7217, args));
        validationException.setErrorCode(7217);
        return validationException;
    }

    public static ValidationException fileError(IOException exception) {
        Object[] args = new Object[]{};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7018, args), exception);
        validationException.setErrorCode(7018);
        return validationException;
    }

    public static ValidationException illegalContainerClass(Class aClass) {
        Object[] args = new Object[]{aClass.toString()};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7044, args));
        validationException.setErrorCode(7044);
        return validationException;
    }

    public static ValidationException illegalUseOfMapInDirectCollection(DirectCollectionMapping directCollectionMapping, Class aMapClass, String keyMethodName) {
        Object[] args = new Object[]{directCollectionMapping, keyMethodName};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7052, args));
        validationException.setErrorCode(7052);
        return validationException;
    }

    public static ValidationException incorrectLoginInstanceProvided() {
        Object[] args = new Object[]{};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7023, args));
        validationException.setErrorCode(7023);
        return validationException;
    }

    public static ValidationException instantiatingValueholderWithNullSession() {
        Object[] args = new Object[]{};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7242, args));
        validationException.setErrorCode(7242);
        return validationException;
    }

    public static ValidationException invalidAttributeOverrideName(String columnName, Class embeddableClass) {
        Object[] args = new Object[]{columnName, embeddableClass};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7202, args));
        validationException.setErrorCode(7202);
        return validationException;
    }

    public static ValidationException invalidCallbackMethod(Class listenerClass, String methodName) {
        Object[] args = new Object[]{listenerClass, methodName};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7224, args));
        validationException.setErrorCode(7224);
        return validationException;
    }

    public static ValidationException invalidCallbackMethodModifier(Class listenerClass, String methodName) {
        Object[] args = new Object[]{listenerClass, methodName};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7226, args));
        validationException.setErrorCode(7226);
        return validationException;
    }

    public static ValidationException invalidCallbackMethodName(Class listenerClass, String methodName) {
        Object[] args = new Object[]{listenerClass, methodName};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7225, args));
        validationException.setErrorCode(7225);
        return validationException;
    }

    public static ValidationException invalidClassTypeForBLOBAttribute(Class entityClass, String attributeName) {
        Object[] args = new Object[]{entityClass, attributeName};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7207, args));
        validationException.setErrorCode(7207);
        return validationException;
    }

    public static ValidationException invalidClassTypeForCLOBAttribute(Class entityClass, String attributeName) {
        Object[] args = new Object[]{entityClass, attributeName};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7208, args));
        validationException.setErrorCode(7208);
        return validationException;
    }

    public static ValidationException invalidTypeForBasicCollectionAttribute(String attributeName, Class targetClass, Class entityClass) {
        Object[] args = new Object[]{attributeName, targetClass, entityClass};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7261, args));
        validationException.setErrorCode(7261);
        return validationException;
    }

    public static ValidationException invalidTypeForBasicMapAttribute(String attributeName, Class targetClass, Class entityClass) {
        Object[] args = new Object[]{attributeName, targetClass, entityClass};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7262, args));
        validationException.setErrorCode(7262);
        return validationException;
    }

    public static ValidationException invalidTypeForEnumeratedAttribute(String attributeName, Class targetClass, Class entityClass) {
        Object[] args = new Object[]{attributeName, targetClass, entityClass};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7151, args));
        validationException.setErrorCode(7151);
        return validationException;
    }

    public static ValidationException invalidTypeForLOBAttribute(String attributeName, Class targetClass, Class entityClass) {
        Object[] args = new Object[]{attributeName, targetClass, entityClass};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7164, args));
        validationException.setErrorCode(7164);
        return validationException;
    }

    public static ValidationException invalidTypeForSerializedAttribute(String attributeName, Class targetClass, Class entityClass) {
        Object[] args = new Object[]{attributeName, targetClass, entityClass};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7155, args));
        validationException.setErrorCode(7155);
        return validationException;
    }

    public static ValidationException invalidTypeForTemporalAttribute(String attributeName, Class targetClass, Class entityClass) {
        Object[] args = new Object[]{attributeName, targetClass, entityClass};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7165, args));
        validationException.setErrorCode(7165);
        return validationException;
    }

    public static ValidationException invalidTypeForVersionAttribute(String attributeName, Class lockingType, Class entityClass) {
        Object[] args = new Object[]{attributeName, lockingType, entityClass};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7168, args));
        validationException.setErrorCode(7168);
        return validationException;
    }

    public static ValidationException invalidCollectionTypeForRelationship(Class cls, Class rawClass, Object element) {
        Object[] args = new Object[]{rawClass, element, cls};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7203, args));
        validationException.setErrorCode(7203);
        return validationException;
    }

    public static ValidationException invalidColumnAnnotationOnRelationship(Class entityClass, String attributeName) {
        Object[] args = new Object[]{entityClass, attributeName};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7157, args));
        validationException.setErrorCode(7157);
        return validationException;
    }

    public static ValidationException invalidCompositePKAttribute(Class entityClass, String pkClassName, String attributeName, Type expectedType, Type actualType) {
        Object[] args = new Object[]{entityClass, pkClassName, attributeName, expectedType, actualType};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7149, args));
        validationException.setErrorCode(7149);
        return validationException;
    }

    public static ValidationException invalidCompositePKSpecification(Class entityClass, String pkClassName) {
        Object[] args = new Object[]{entityClass, pkClassName};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7150, args));
        validationException.setErrorCode(7150);
        return validationException;
    }

    public static ValidationException invalidConnector(Connector connector) {
        Object[] args = new Object[]{connector};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7058, args));
        validationException.setErrorCode(7058);
        return validationException;
    }

    public static ValidationException invalidDataSourceName(String name, Exception exception) {
        Object[] args = new Object[]{name};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7059, args), exception);
        validationException.setErrorCode(7059);
        return validationException;
    }

    public static ValidationException invalidEmbeddableAttribute(Class aggregateClass, String aggregateAttributeName, Class owningClass, String owningAttributeName) {
        Object[] args = new Object[]{aggregateClass, aggregateAttributeName, owningClass, owningAttributeName};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7200, args));
        validationException.setErrorCode(7200);
        return validationException;
    }

    public static ValidationException invalidEntityMappingsDocument(String fileName, Exception exception) {
        Object[] args = new Object[]{fileName};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7201, args), exception);
        validationException.setErrorCode(7201);
        return validationException;
    }

    public static ValidationException invalidFileName(String fileName) {
        Object[] args = new Object[]{fileName};
        ValidationException exception = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7084, args));
        exception.setErrorCode(7084);
        return exception;
    }

    public static ValidationException invalidMapping(Class entityClass, Class targetClass) {
        Object[] args = new Object[]{entityClass, targetClass};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7244, args));
        validationException.setErrorCode(7244);
        return validationException;
    }

    public static ValidationException invalidMappingForConverter(Class entityClass, Object annotatedElement) {
        Object[] args = new Object[]{entityClass, annotatedElement};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7255, args));
        validationException.setErrorCode(7255);
        return validationException;
    }

    public static ValidationException invalidMappingForEmbeddedId(String sourceAttributeName, Class sourceClass, String embeddedAttributeName, Class embeddedIdClass) {
        Object[] args = new Object[]{sourceAttributeName, sourceClass, embeddedAttributeName, embeddedIdClass};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7298, args));
        validationException.setErrorCode(7298);
        return validationException;
    }

    public static ValidationException invalidMergePolicy() {
        Object[] args = new Object[]{};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7024, args));
        validationException.setErrorCode(7024);
        return validationException;
    }

    public static ValidationException javaTypeIsNotAValidDatabaseType(Class javaClass) {
        Object[] args = new Object[]{javaClass};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7008, args));
        validationException.setErrorCode(7008);
        return validationException;
    }

    public static ValidationException jtsExceptionRaised(Exception exception) {
        Object[] args = new Object[]{};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7061, args), exception);
        validationException.setErrorCode(7061);
        return validationException;
    }

    public static ValidationException loginBeforeAllocatingClientSessions() {
        Object[] args = new Object[]{};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7001, args));
        validationException.setErrorCode(7001);
        return validationException;
    }

    public static ValidationException logIOError(IOException exception) {
        Object[] args = new Object[]{};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7038, args), exception);
        validationException.setErrorCode(7038);
        return validationException;
    }

    public static ValidationException mapKeyNotDeclaredInItemClass(String keyName, Class aClass) {
        Object[] args = new Object[]{keyName, aClass};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7048, args));
        validationException.setErrorCode(7048);
        return validationException;
    }

    public static ValidationException maxSizeLessThanMinSize() {
        Object[] args = new Object[]{};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7003, args));
        validationException.setErrorCode(7003);
        return validationException;
    }

    public static ValidationException noMappedByAttributeFound(Class ownerClass, String mappedByAttributeName, Class entityClass, String attributeName) {
        Object[] args = new Object[]{ownerClass, mappedByAttributeName, entityClass, attributeName};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7154, args));
        validationException.setErrorCode(7154);
        return validationException;
    }

    public static ValidationException nonEntityTargetInRelationship(Class javaClass, Class targetEntity, AnnotatedElement annotatedElement) {
        Object[] args = new Object[]{javaClass, targetEntity, annotatedElement};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7250, args));
        validationException.setErrorCode(7250);
        return validationException;
    }

    public static ValidationException nonUniqueEntityName(String clsName1, String clsName2, String name) {
        Object[] args = new Object[]{name, clsName1, clsName2, CR};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7237, args));
        validationException.setErrorCode(7237);
        return validationException;
    }

    public static ValidationException nonUniqueMappingFileName(String puName, String mf) {
        Object[] args = new Object[]{puName, mf};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7252, args));
        validationException.setErrorCode(7252);
        return validationException;
    }

    public static ValidationException noPrimaryKeyAnnotationsFound(Class entityClass) {
        Object[] args = new Object[]{entityClass};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7161, args));
        validationException.setErrorCode(7161);
        return validationException;
    }

    public static ValidationException noProjectSpecifiedInProperties(String bundleName, String serverName) {
        Object[] args = new Object[]{bundleName, serverName};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7083, args));
        validationException.setErrorCode(7083);
        return validationException;
    }

    public static ValidationException noSessionFound(String sessionName, String resourceName) {
        Object[] args = new Object[]{sessionName, resourceName};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7100, args));
        validationException.setErrorCode(7100);
        return validationException;
    }

    public static ValidationException noSessionRegisteredForClass(Class domainClass) {
        Object[] args = new Object[]{domainClass};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7032, args));
        validationException.setErrorCode(7032);
        return validationException;
    }

    public static ValidationException noSessionRegisteredForName(String sessionName) {
        Object[] args = new Object[]{sessionName};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7033, args));
        validationException.setErrorCode(7033);
        return validationException;
    }

    public static ValidationException noTablesToCreate(Project project) {
        Object[] args = new Object[]{project};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7043, args));
        validationException.setErrorCode(7043);
        return validationException;
    }

    public static ValidationException noTemporalTypeSpecified(String attributeName, Class entityClass) {
        Object[] args = new Object[]{attributeName, entityClass};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7212, args));
        validationException.setErrorCode(7212);
        return validationException;
    }

    public static ValidationException nullPrimaryKeyInUnitOfWorkClone(Object clone) {
        Object[] args = new Object[]{clone};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7197, args));
        validationException.setErrorCode(7197);
        return validationException;
    }

    public static ValidationException uniDirectionalOneToManyHasJoinColumnAnnotations(String attributeName, Class entityClass) {
        Object[] args = new Object[]{entityClass, attributeName};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7160, args));
        validationException.setErrorCode(7160);
        return validationException;
    }

    public static ValidationException onlyFieldsAreValidKeysForDatabaseRows() {
        Object[] args = new Object[]{};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7025, args));
        validationException.setErrorCode(7025);
        return validationException;
    }

    public static ValidationException operationNotSupported(String methodName) {
        Object[] args = new Object[]{methodName};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7097, args));
        validationException.setErrorCode(7097);
        return validationException;
    }

    public static ValidationException optimisticLockingNotSupportedWithStoredProcedureGeneration() {
        Object[] args = new Object[]{};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7055, args));
        validationException.setErrorCode(7055);
        return validationException;
    }

    public static ValidationException optimisticLockingSelectedColumnNamesNotSpecified(Class entityClass) {
        Object[] args = new Object[]{entityClass};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7263, args));
        validationException.setErrorCode(7263);
        return validationException;
    }

    public static ValidationException optimisticLockingVersionElementNotSpecified(Class entityClass) {
        Object[] args = new Object[]{entityClass};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7264, args));
        validationException.setErrorCode(7264);
        return validationException;
    }

    public static ValidationException oracleObjectTypeIsNotDefined(String typeName) {
        Object[] args = new Object[]{typeName};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7073, args));
        validationException.setErrorCode(7073);
        return validationException;
    }

    public static ValidationException oracleObjectTypeNameIsNotDefined(Class type) {
        Object[] args = new Object[]{type};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7074, args));
        validationException.setErrorCode(7074);
        return validationException;
    }

    public static ValidationException oracleVarrayMaximumSizeNotDefined(String typeName) {
        Object[] args = new Object[]{typeName};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7075, args));
        validationException.setErrorCode(7075);
        return validationException;
    }

    public static ValidationException platformClassNotFound(Exception exception, String className) {
        Object[] args = new Object[]{className};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7042, args), exception);
        validationException.setErrorCode(7042);
        return validationException;
    }

    public static ValidationException poolNameDoesNotExist(String poolName) {
        Object[] args = new Object[]{poolName};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7002, args));
        validationException.setErrorCode(7002);
        return validationException;
    }

    public static ValidationException poolsMustBeConfiguredBeforeLogin() {
        Object[] args = new Object[]{};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7004, args));
        validationException.setErrorCode(7004);
        return validationException;
    }

    public static ValidationException primaryTableNotDefined(Class javaClass, String instanceDocName) {
        Object[] args = new Object[]{javaClass, instanceDocName};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7199, args));
        validationException.setErrorCode(7199);
        return validationException;
    }

    public static ValidationException projectAmendmentExceptionOccured(Exception exception, String amendmentMethod, String amendmentClass) {
        Object[] args = new Object[]{amendmentMethod, amendmentClass};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7069, args));
        validationException.setInternalException(exception);
        validationException.setErrorCode(7069);
        return validationException;
    }

    public static ValidationException projectXMLNotFound(String projectXMLFile, Exception exception) {
        Object[] args = new Object[]{projectXMLFile};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7099, args));
        validationException.setInternalException(exception);
        validationException.setErrorCode(7099);
        return validationException;
    }

    public static ValidationException queryArgumentTypeNotFound(DatabaseQuery query, String argumentName, String typeAsString, Exception exception) {
        Object[] args = new Object[]{query.getName(), argumentName, typeAsString};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7093, args));
        validationException.setInternalException(exception);
        validationException.setErrorCode(7093);
        return validationException;
    }

    public static ValidationException sequenceSetupIncorrectly(String sequenceName) {
        Object[] args = new Object[]{sequenceName};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7027, args));
        validationException.setErrorCode(7027);
        return validationException;
    }

    public static ValidationException serverPlatformIsReadOnlyAfterLogin(String serverPlatformClassName) {
        Object[] args = new Object[]{serverPlatformClassName};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7134, args));
        validationException.setErrorCode(7134);
        return validationException;
    }

    public static ValidationException sessionAmendmentExceptionOccured(Exception exception, String amendmentMethod, String amendmentClass, Class[] parameters) {
        StringBuffer buf = new StringBuffer(30);
        for (int i = 0; i < parameters.length - 1; ++i) {
            buf.append(parameters[i].getName());
            if (i == parameters.length - 1) continue;
            buf.append(", ");
        }
        buf.append(parameters[parameters.length - 1].getName());
        Object[] args = new Object[]{amendmentClass, amendmentMethod, buf.toString()};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7089, args));
        validationException.setInternalException(exception);
        validationException.setErrorCode(7089);
        return validationException;
    }

    public static ValidationException startIndexOutOfRange() {
        Object[] args = new Object[]{};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7010, args));
        validationException.setErrorCode(7010);
        return validationException;
    }

    public static ValidationException stopIndexOutOfRange() {
        Object[] args = new Object[]{};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7011, args));
        validationException.setErrorCode(7011);
        return validationException;
    }

    public static ValidationException subSessionsNotDefinedForBroker(String brokerName) {
        Object[] args = new Object[]{brokerName};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7085, args));
        validationException.setErrorCode(7085);
        return validationException;
    }

    public static ValidationException writeObjectNotAllowedInUnitOfWork() {
        Object[] args = new Object[]{};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7028, args));
        validationException.setErrorCode(7028);
        return validationException;
    }

    public static ValidationException wrongObjectRegistered(Object registered, Object parent) {
        Object[] args = new Object[]{registered, parent};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7056, args));
        validationException.setErrorCode(7056);
        return validationException;
    }

    public static ValidationException cannotIssueModifyAllQueryWithOtherWritesWithinUOW() {
        Object[] args = new Object[]{};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7139, args));
        validationException.setErrorCode(7139);
        return validationException;
    }

    public static ValidationException nullCacheKeyFoundOnRemoval(IdentityMap map, Class clazz) {
        Object[] args = new Object[]{map, clazz, CR};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7102, args));
        validationException.setErrorCode(7102);
        return validationException;
    }

    public static ValidationException nullUnderlyingValueHolderValue(String methodName) {
        Object[] args = new Object[]{methodName, CR};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7103, args));
        validationException.setErrorCode(7103);
        return validationException;
    }

    public static ValidationException invalidSequencingLogin() {
        Object[] args = new Object[]{};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7104, args));
        validationException.setErrorCode(7104);
        return validationException;
    }

    public static ValidationException isolatedDataNotSupportedInSessionBroker(String sessionName) {
        Object[] args = new Object[]{sessionName};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7114, args));
        validationException.setErrorCode(7114);
        return validationException;
    }

    public static ValidationException projectLoginIsNull(AbstractSession session) {
        Object[] args = new Object[]{};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7109, args));
        validationException.setErrorCode(7109);
        return validationException;
    }

    public static ValidationException historicalSessionOnlySupportedOnOracle() {
        Object[] args = new Object[]{};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7110, args));
        validationException.setErrorCode(7110);
        return validationException;
    }

    public static ValidationException platformDoesNotSupportCallWithReturning(String platformTypeName) {
        Object[] args = new Object[]{platformTypeName};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7113, args));
        validationException.setErrorCode(7113);
        return validationException;
    }

    public static ValidationException invalidNullMethodArguments() {
        Object[] args = new Object[]{};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7129, args));
        validationException.setErrorCode(7129);
        return validationException;
    }

    public static ValidationException invalidMethodArguments() {
        Object[] args = new Object[]{};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7116, args));
        validationException.setErrorCode(7116);
        return validationException;
    }

    public static ValidationException wrongUsageOfSetCustomArgumentTypeMethod(String callString) {
        Object[] args = new Object[]{callString};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7118, args));
        validationException.setErrorCode(7118);
        return validationException;
    }

    public static ValidationException cannotTranslateUnpreparedCall(String callString) {
        Object[] args = new Object[]{callString};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7119, args));
        validationException.setErrorCode(7119);
        return validationException;
    }

    public static ValidationException cannotSetCursorForParameterTypeOtherThanOut(String fieldName, String callString) {
        Object[] args = new Object[]{fieldName, callString};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7120, args));
        validationException.setErrorCode(7120);
        return validationException;
    }

    public static ValidationException platformDoesNotSupportStoredFunctions(String platformTypeName) {
        Object[] args = new Object[]{platformTypeName};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7121, args));
        validationException.setErrorCode(7121);
        return validationException;
    }

    public static ValidationException illegalOperationForUnitOfWorkLifecycle(int lifecycle, String operation) {
        switch (lifecycle) {
            case 2: {
                return ValidationException.unitOfWorkInTransactionCommitPending(operation);
            }
            case 3: {
                return ValidationException.unitOfWorkAfterWriteChangesFailed(operation);
            }
        }
        return ValidationException.inActiveUnitOfWork(operation);
    }

    public static ValidationException unitOfWorkInTransactionCommitPending(String operation) {
        Object[] args = new Object[]{operation};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7123, args));
        validationException.setErrorCode(7123);
        return validationException;
    }

    public static ValidationException unspecifiedCompositePKNotSupported(Class entityClass) {
        Object[] args = new Object[]{entityClass};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7232, args));
        validationException.setErrorCode(7232);
        return validationException;
    }

    public static ValidationException unsupportedCascadeLockingDescriptor(ClassDescriptor descriptor) {
        Object[] args = new Object[]{descriptor};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7177, args));
        validationException.setErrorCode(7177);
        return validationException;
    }

    public static ValidationException unsupportedCascadeLockingMapping(DatabaseMapping mapping) {
        Object[] args = new Object[]{mapping};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7175, args));
        validationException.setErrorCode(7175);
        return validationException;
    }

    public static ValidationException unsupportedCascadeLockingMappingWithCustomQuery(DatabaseMapping mapping) {
        Object[] args = new Object[]{mapping};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7176, args));
        validationException.setErrorCode(7176);
        return validationException;
    }

    public static ValidationException unitOfWorkAfterWriteChangesFailed(String operation) {
        Object[] args = new Object[]{operation};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7124, args));
        validationException.setErrorCode(7124);
        return validationException;
    }

    public static ValidationException inActiveUnitOfWork(String operation) {
        Object[] args = new Object[]{operation};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7125, args));
        validationException.setErrorCode(7125);
        return validationException;
    }

    public static ValidationException incompleteJoinColumnsSpecified(Object annotatedElement, Class javaClass) {
        Object[] args = new Object[]{annotatedElement, javaClass};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7220, args));
        validationException.setErrorCode(7220);
        return validationException;
    }

    public static ValidationException incompletePrimaryKeyJoinColumnsSpecified(Object annotatedElement) {
        Object[] args = new Object[]{annotatedElement};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7222, args));
        validationException.setErrorCode(7222);
        return validationException;
    }

    public static ValidationException unitOfWorkInTransactionCommitPending() {
        Object[] args = new Object[]{};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7123, args));
        validationException.setErrorCode(7123);
        return validationException;
    }

    public static ValidationException writeChangesOnNestedUnitOfWork() {
        Object[] args = new Object[]{};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7126, args));
        validationException.setErrorCode(7126);
        return validationException;
    }

    public static ValidationException cannotWriteChangesTwice() {
        Object[] args = new Object[]{};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7127, args));
        validationException.setErrorCode(7127);
        return validationException;
    }

    public static ValidationException nestedUOWNotSupportedForAttributeTracking() {
        Object[] args = new Object[]{};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7130, args));
        validationException.setErrorCode(7130);
        return validationException;
    }

    public static ValidationException nestedUOWNotSupportedForModifyAllQuery() {
        Object[] args = new Object[]{};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7136, args));
        validationException.setErrorCode(7136);
        return validationException;
    }

    public static ValidationException noConverterDataTypeSpecified(Class entityClass, String attributeName, String converterName) {
        Object[] args = new Object[]{entityClass, attributeName, converterName};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7259, args));
        validationException.setErrorCode(7259);
        return validationException;
    }

    public static ValidationException noConverterObjectTypeSpecified(Class entityClass, String attributeName, String converterName) {
        Object[] args = new Object[]{entityClass, attributeName, converterName};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7260, args));
        validationException.setErrorCode(7260);
        return validationException;
    }

    public static ValidationException noCorrespondingSetterMethodDefined(Class entityClass, Method method) {
        Object[] args = new Object[]{entityClass, method};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7174, args));
        validationException.setErrorCode(7174);
        return validationException;
    }

    public static ValidationException wrongCollectionChangeEventType(int eveType) {
        Object[] args = new Object[]{new Integer(eveType)};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7131, args));
        validationException.setErrorCode(7131);
        return validationException;
    }

    public static ValidationException wrongChangeEvent(Class eveClass) {
        Object[] args = new Object[]{eveClass};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7132, args));
        validationException.setErrorCode(7132);
        return validationException;
    }

    public static ValidationException oldCommitNotSupportedForAttributeTracking() {
        Object[] args = new Object[]{};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7133, args));
        validationException.setErrorCode(7133);
        return validationException;
    }

    public static ValidationException unableToDetermineTargetEntity(String attributeName, Class entityClass) {
        Object[] args = new Object[]{attributeName, entityClass};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7214, args));
        validationException.setErrorCode(7214);
        return validationException;
    }

    public static ValidationException unableToLoadClass(String classname, Exception exception) {
        Object[] args = new Object[]{classname};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7156, args), exception);
        validationException.setErrorCode(7156);
        return validationException;
    }

    public static ValidationException unfetchedAttributeNotEditable(String attributeName) {
        Object[] args = new Object[]{attributeName};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7137, args));
        validationException.setErrorCode(7137);
        return validationException;
    }

    public static ValidationException objectNeedImplTrackerForFetchGroupUsage(String className) {
        Object[] args = new Object[]{className};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 7138, args));
        queryException.setErrorCode(7138);
        return queryException;
    }

    public static ValidationException wrongSequenceType(String typeName, String methodName) {
        Object[] args = new Object[]{typeName, methodName};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7140, args));
        validationException.setErrorCode(7140);
        return validationException;
    }

    public static ValidationException cannotSetDefaultSequenceAsDefault(String seqName) {
        Object[] args = new Object[]{seqName};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7141, args));
        validationException.setErrorCode(7141);
        return validationException;
    }

    public static ValidationException defaultSequenceNameAlreadyUsedBySequence(String seqName) {
        Object[] args = new Object[]{seqName};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7142, args));
        validationException.setErrorCode(7142);
        return validationException;
    }

    public static ValidationException sequenceNameAlreadyUsedByDefaultSequence(String seqName) {
        Object[] args = new Object[]{seqName};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7143, args));
        validationException.setErrorCode(7143);
        return validationException;
    }

    public static ValidationException platformDoesNotSupportSequence(String seqName, String platformTypeName, String sequenceTypeName) {
        Object[] args = new Object[]{seqName, platformTypeName, sequenceTypeName};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7144, args));
        validationException.setErrorCode(7144);
        return validationException;
    }

    public static ValidationException sequenceCannotBeConnectedToTwoPlatforms(String seqName, String ownerPlatformName, String otherPlatformName) {
        Object[] args = new Object[]{seqName, ownerPlatformName, otherPlatformName};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7145, args));
        validationException.setErrorCode(7145);
        return validationException;
    }

    public static ValidationException querySequenceDoesNotHaveSelectQuery(String seqName) {
        Object[] args = new Object[]{seqName};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7146, args));
        validationException.setErrorCode(7146);
        return validationException;
    }

    public static ValidationException createPlatformDefaultSequenceUndefined(String platformTypeName) {
        Object[] args = new Object[]{platformTypeName};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7147, args));
        validationException.setErrorCode(7147);
        return validationException;
    }

    public static ValidationException sequenceGeneratorUsingAReservedName(String reservedName, Object location) {
        Object[] args = new Object[]{reservedName, location};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7167, args));
        validationException.setErrorCode(7167);
        return validationException;
    }

    public static ValidationException tableGeneratorUsingAReservedName(String reservedName, Object location) {
        Object[] args = new Object[]{reservedName, location};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7166, args));
        validationException.setErrorCode(7166);
        return validationException;
    }

    public static ValidationException onlyOneGeneratedValueIsAllowed(Class cls, String field1, String field2) {
        Object[] args = new Object[]{cls, field1, field2};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7169, args));
        validationException.setErrorCode(7169);
        return validationException;
    }

    public static ValidationException wrongPropertyNameInChangeEvent(Class objectClass, String propertyName) {
        Object[] args = new Object[]{objectClass, propertyName};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7173, args));
        validationException.setErrorCode(7173);
        return validationException;
    }

    public static ValidationException oracleOCIProxyConnectorRequiresOracleOCIConnectionPool() {
        Object[] args = new Object[]{};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7178, args));
        validationException.setErrorCode(7178);
        return validationException;
    }

    public static ValidationException oracleJDBC10_1_0_2ProxyConnectorRequiresOracleConnection() {
        Object[] args = new Object[]{};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7179, args));
        validationException.setErrorCode(7179);
        return validationException;
    }

    public static ValidationException oracleJDBC10_1_0_2ProxyConnectorRequiresOracleConnectionVersion() {
        Object[] args = new Object[]{};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7180, args));
        validationException.setErrorCode(7180);
        return validationException;
    }

    public static ValidationException oracleJDBC10_1_0_2ProxyConnectorRequiresIntProxytype() {
        Object[] args = new Object[]{};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7181, args));
        validationException.setErrorCode(7181);
        return validationException;
    }

    public static ValidationException couldNotFindDriverClass(Object driver, Exception ex) {
        Object[] args = new Object[]{driver};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7182, args), ex);
        validationException.setErrorCode(7182);
        return validationException;
    }

    public static ValidationException couldNotFindMapKey(String attributeName, Class entityClass, DatabaseMapping mapping) {
        Object[] args = new Object[]{attributeName, entityClass, mapping};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7159, args));
        validationException.setErrorCode(7159);
        return validationException;
    }

    public static ValidationException errorClosingPersistenceXML(Exception ex) {
        Object[] args = new Object[]{};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7183, args), ex);
        validationException.setErrorCode(7183);
        return validationException;
    }

    public static ValidationException configFactoryNamePropertyNotSpecified(String configFactory) {
        Object[] args = new Object[]{configFactory};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7184, args));
        validationException.setErrorCode(7184);
        return validationException;
    }

    public static ValidationException configFactoryNamePropertyNotFound(String configClass, String configFactory, Exception ex) {
        Object[] args = new Object[]{configClass, configFactory};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7185, args), ex);
        validationException.setErrorCode(7185);
        return validationException;
    }

    public static ValidationException cannotInvokeMethodOnConfigClass(String configMethod, String configClass, String configFactory, Exception ex) {
        Object[] args = new Object[]{configMethod, configClass, configFactory};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7186, args), ex);
        validationException.setErrorCode(7186);
        return validationException;
    }

    public static ValidationException configMethodNotDefined(String configClass, String configMethod) {
        Object[] args = new Object[]{configClass, configMethod};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7187, args));
        validationException.setErrorCode(7187);
        return validationException;
    }

    public static ValidationException conflictingNamedAnnotations(String name, Annotation annotation1, Object location1, Annotation annotation2, Object location2) {
        Object[] args = new Object[]{name, annotation1, location1, annotation2, location2};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7299, args));
        validationException.setErrorCode(7299);
        return validationException;
    }

    public static ValidationException conflictingNamedXMLElements(String name, String xmlElement, Object location1, Object location2) {
        Object[] args = new Object[]{name, xmlElement, location1, location2};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7300, args));
        validationException.setErrorCode(7300);
        return validationException;
    }

    public static ValidationException conflictingAnnotations(Annotation annotation1, Object location1, Annotation annotation2, Object location2) {
        Object[] args = new Object[]{annotation1, location1, annotation2, location2};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7301, args));
        validationException.setErrorCode(7301);
        return validationException;
    }

    public static ValidationException conflictingXMLElements(String xmlElement, Object element, Object location1, Object location2) {
        Object[] args = new Object[]{xmlElement, element, location1, location2};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7302, args));
        validationException.setErrorCode(7302);
        return validationException;
    }

    public static ValidationException conflictingSequenceAndTableGeneratorsSpecified(String name, Object sequenceGeneratorLocation, Object tableGeneratorLocation) {
        Object[] args = new Object[]{name, sequenceGeneratorLocation, tableGeneratorLocation};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7238, args));
        validationException.setErrorCode(7238);
        return validationException;
    }

    public static ValidationException conflictingSequenceNameAndTablePkColumnValueSpecified(String name, Object sequenceGeneratorLocation, Object tableGeneratorLocation) {
        Object[] args = new Object[]{name, sequenceGeneratorLocation, tableGeneratorLocation};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7240, args));
        validationException.setErrorCode(7240);
        return validationException;
    }

    public static ValidationException classListMustNotBeNull() {
        Object[] args = new Object[]{};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7188, args));
        validationException.setErrorCode(7188);
        return validationException;
    }

    public static ValidationException currentLoaderNotValid(ClassLoader loader) {
        Object[] args = new Object[]{loader};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7189, args));
        validationException.setErrorCode(7189);
        return validationException;
    }

    public static ValidationException methodFailed(String methodName, Exception ex) {
        Object[] args = new Object[]{methodName};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7190, args), ex);
        validationException.setErrorCode(7190);
        return validationException;
    }

    public static ValidationException missingDescriptor(String className) {
        Object[] args = new Object[]{className};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7009, args));
        validationException.setErrorCode(7009);
        return validationException;
    }

    public static ValidationException missingContextStringForContext(String context) {
        Object[] args = new Object[]{context};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7307, args));
        validationException.setErrorCode(7307);
        return validationException;
    }

    public static ValidationException missingMappingForAttribute(ClassDescriptor descriptor, String attributeName, String source) {
        Object[] args = new Object[]{descriptor, attributeName, source};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7051, args));
        validationException.setErrorCode(7051);
        return validationException;
    }

    public static ValidationException missingFieldTypeForDDLGenerationOfClassTransformation(ClassDescriptor descriptor, String attributeName, String methodName) {
        Object[] args = new Object[]{descriptor, attributeName, methodName};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7234, args));
        validationException.setErrorCode(7234);
        return validationException;
    }

    public static ValidationException missingTransformerMethodForDDLGenerationOfClassTransformation(ClassDescriptor descriptor, String attributeName, String methodName) {
        Object[] args = new Object[]{descriptor, attributeName, methodName};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7235, args));
        validationException.setErrorCode(7235);
        return validationException;
    }

    public static ValidationException multipleCursorsNotSupported(String callString) {
        Object[] args = new Object[]{callString};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7117, args));
        validationException.setErrorCode(7117);
        return validationException;
    }

    public static ValidationException multipleEmbeddedIdAnnotationsFound(Class entityClass, String attributeName1, String attributeName2) {
        Object[] args = new Object[]{entityClass, attributeName1, attributeName2};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7162, args));
        validationException.setErrorCode(7162);
        return validationException;
    }

    public static ValidationException multipleLifecycleCallbackMethodsForSameLifecycleEvent(Class listenerClass, Method method1, Method method2) {
        Object[] args = new Object[]{listenerClass, method1, method2};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7227, args));
        validationException.setErrorCode(7227);
        return validationException;
    }

    public static ValidationException multipleObjectValuesForDataValue(Class javaClass, String converterName, String dataValue) {
        Object[] args = new Object[]{javaClass, converterName, dataValue};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7254, args));
        validationException.setErrorCode(7254);
        return validationException;
    }

    public static ValidationException multipleProjectsSpecifiedInProperties(String bundleName, String serverName) {
        Object[] args = new Object[]{bundleName, serverName};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7082, args));
        validationException.setErrorCode(7082);
        return validationException;
    }

    public static ValidationException entityClassNotFound(String entityClass, ClassLoader loader, Exception ex) {
        Object[] args = new Object[]{entityClass, loader};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7191, args), ex);
        validationException.setErrorCode(7191);
        return validationException;
    }

    public static ValidationException classFileTransformerThrowsException(Object transformer, String className, Exception ex) {
        Object[] args = new Object[]{transformer, className};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7192, args), ex);
        validationException.setErrorCode(7192);
        return validationException;
    }

    public static ValidationException jarFilesInPersistenceXmlNotSupported() {
        Object[] args = new Object[]{};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7193, args));
        validationException.setErrorCode(7193);
        return validationException;
    }

    public static ValidationException couldNotBindJndi(String bindName, Object bindValue, Exception ex) {
        Object[] args = new Object[]{bindName, bindValue};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7194, args), ex);
        validationException.setErrorCode(7194);
        return validationException;
    }

    public static ValidationException exceptionConfiguringEMFactory(Exception ex) {
        Object[] args = new Object[]{};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7195, args), ex);
        validationException.setErrorCode(7195);
        return validationException;
    }

    public static ValidationException excessivePrimaryKeyJoinColumnsSpecified(Object annotatedElement) {
        Object[] args = new Object[]{annotatedElement};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7223, args));
        validationException.setErrorCode(7223);
        return validationException;
    }

    public static ValidationException classNotFoundWhileConvertingClassNames(String className, Exception exception) {
        Object[] args = new Object[]{className};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7198, args), exception);
        validationException.setErrorCode(7198);
        return validationException;
    }

    public static ValidationException platformDoesNotOverrideGetCreateTempTableSqlPrefix(String className) {
        Object[] args = new Object[]{className};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7218, args));
        validationException.setErrorCode(7218);
        return validationException;
    }

    public static ValidationException mappingAnnotationsAppliedToTransientAttribute(Object annotatedElement) {
        Object[] args = new Object[]{annotatedElement};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7153, args));
        validationException.setErrorCode(7153);
        return validationException;
    }

    public static ValidationException mappingDoesNotOverrideValueFromRowInternalWithJoin(String className) {
        Object[] args = new Object[]{className};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7219, args));
        validationException.setErrorCode(7219);
        return validationException;
    }

    public static ValidationException mappingFileNotFound(String puName, String mf) {
        Object[] args = new Object[]{puName, mf};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7253, args));
        validationException.setErrorCode(7253);
        return validationException;
    }

    public static ValidationException mappingMetadataAppliedToInvalidAttribute(Object element, Class cls) {
        Object[] args = new Object[]{element, cls};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7211, args));
        validationException.setErrorCode(7211);
        return validationException;
    }

    public static ValidationException mappingMetadataAppliedToMethodWithArguments(Object element, Class cls) {
        Object[] args = new Object[]{element, cls};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7233, args));
        validationException.setErrorCode(7233);
        return validationException;
    }

    public static ValidationException cannotPersistExistingObject(Object registeredObject, AbstractSession session) {
        Vector key = new Vector();
        if (session != null) {
            key = session.keyFromObject(registeredObject);
        }
        Object[] args = new Object[]{registeredObject, registeredObject.getClass().getName(), key, CR};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7231, args));
        validationException.setErrorCode(7231);
        return validationException;
    }

    public static ValidationException classNotListedInPersistenceUnit(String className) {
        Object[] args = new Object[]{className};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7243, args));
        validationException.setErrorCode(7243);
        return validationException;
    }

    public static ValidationException conflictingAccessTypeForEmbeddable(Class embeddableClass, boolean embeddableAccessType, Class descriptorClass, boolean descriptorAccessType) {
        Object[] args = new Object[]{embeddableClass, embeddableAccessType, descriptorClass, descriptorAccessType};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7245, args));
        validationException.setErrorCode(7245);
        return validationException;
    }

    public static ValidationException invalidEmbeddedAttribute(Class javaClass, String attributeName, Class embeddableClass) {
        Object[] args = new Object[]{javaClass, attributeName, embeddableClass};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7246, args));
        validationException.setErrorCode(7246);
        return validationException;
    }

    public static ValidationException embeddedIdHasNoAttributes(Class entityClass, Class embeddableClass, String accessType) {
        Object[] args = new Object[]{entityClass, embeddableClass, accessType};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7249, args));
        validationException.setErrorCode(7249);
        return validationException;
    }

    public static ValidationException primaryKeyUpdateDisallowed(String className, String attributeName) {
        Object[] args = new Object[]{className, attributeName};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7251, args));
        validationException.setErrorCode(7251);
        return validationException;
    }

    public static ValidationException cannotInstantiateExceptionHandlerClass(String className, Exception e) {
        Object[] args = new Object[]{className};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7267, args), e);
        validationException.setErrorCode(7275);
        return validationException;
    }

    public static ValidationException cannotInstantiateProfilerClass(String className, Exception e) {
        Object[] args = new Object[]{className};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7286, args), e);
        validationException.setErrorCode(7286);
        return validationException;
    }

    public static ValidationException cannotInstantiateSessionEventListenerClass(String className, Exception e) {
        Object[] args = new Object[]{className};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7267, args), e);
        validationException.setErrorCode(7276);
        return validationException;
    }

    public static ValidationException invalidExceptionHandlerClass(String className) {
        Object[] args = new Object[]{className};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7267, args));
        validationException.setErrorCode(7267);
        return validationException;
    }

    public static ValidationException invalidExplicitAccessTypeSpecified(AnnotatedElement annotatedElement, Class javaClass, String expectedAccessType) {
        Object[] args = new Object[]{annotatedElement, javaClass, expectedAccessType};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7306, args));
        validationException.setErrorCode(7306);
        return validationException;
    }

    public static ValidationException invalidSessionEventListenerClass(String className) {
        Object[] args = new Object[]{className};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7268, args));
        validationException.setErrorCode(7268);
        return validationException;
    }

    public static ValidationException invalidCacheStatementsSize(String cacheStatementsSize, String errorMessage) {
        Object[] args = new Object[]{cacheStatementsSize, errorMessage};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7270, args));
        validationException.setErrorCode(7270);
        return validationException;
    }

    public static ValidationException invalidBooleanValueForSettingNativeSQL(String specifiedBooleanValue) {
        Object[] args = new Object[]{specifiedBooleanValue};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7271, args));
        validationException.setErrorCode(7271);
        return validationException;
    }

    public static ValidationException invalidBooleanValueForEnableStatmentsCached(String specifiedBooleanValue) {
        Object[] args = new Object[]{specifiedBooleanValue};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7272, args));
        validationException.setErrorCode(7272);
        return validationException;
    }

    public static ValidationException invalidBooleanValueForProperty(String specifiedBooleanValue, String property) {
        Object[] args = new Object[]{specifiedBooleanValue, property};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7278, args));
        validationException.setErrorCode(7278);
        return validationException;
    }

    public static ValidationException invalidValueForProperty(String specifiedValue, String property, Exception error) {
        Object[] args = new Object[]{specifiedValue, property, error.toString()};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7308, args), error);
        validationException.setErrorCode(7308);
        return validationException;
    }

    public static ValidationException invalidBooleanValueForAddingNamedQueries(String specifiedBooleanValue) {
        Object[] args = new Object[]{specifiedBooleanValue};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7273, args));
        validationException.setErrorCode(7273);
        return validationException;
    }

    public static ValidationException invalidLoggingFile() {
        Object[] args = new Object[]{};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7277, args));
        validationException.setErrorCode(7277);
        return validationException;
    }

    public static ValidationException invalidLoggingFile(String loggingFile, Exception e) {
        Object[] args = new Object[]{loggingFile, e};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7274, args), e);
        validationException.setErrorCode(7274);
        return validationException;
    }

    public static ValidationException multipleClassesForTheSameDiscriminator(String discriminator, String attributeName) {
        Object[] args = new Object[]{discriminator, attributeName};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7294, args));
        validationException.setErrorCode(7294);
        return validationException;
    }

    public static ValidationException invalidMappingForStructConverter(String name, DatabaseMapping mapping) {
        Object[] args = new Object[]{name, mapping};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7282, args));
        validationException.setErrorCode(7282);
        return validationException;
    }

    public static ValidationException twoStructConvertersAddedForSameClass(String className) {
        Object[] args = new Object[]{className};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7283, args));
        validationException.setErrorCode(7283);
        return validationException;
    }

    public static ValidationException invalidComparatorClass(String className) {
        Object[] args = new Object[]{className};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7284, args));
        validationException.setErrorCode(7284);
        return validationException;
    }

    public static ValidationException invalidProfilerClass(String className) {
        Object[] args = new Object[]{className};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7285, args));
        validationException.setErrorCode(7285);
        return validationException;
    }

    public static ValidationException invalidFieldForClass(String fieldName, Class entityClass) {
        Object[] args = new Object[]{fieldName, entityClass};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7215, args));
        validationException.setErrorCode(7215);
        return validationException;
    }

    public static ValidationException invalidPropertyForClass(String propertyName, Class entityClass) {
        Object[] args = new Object[]{propertyName, entityClass};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7216, args));
        validationException.setErrorCode(7216);
        return validationException;
    }

    public static ValidationException readTransformerClassDoesntImplementAttributeTransformer(String annotatedElement) {
        Object[] args = new Object[]{annotatedElement};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7287, args));
        validationException.setErrorCode(7287);
        return validationException;
    }

    public static ValidationException readTransformerHasBothClassAndMethod(String annotatedElement) {
        Object[] args = new Object[]{annotatedElement};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7288, args));
        validationException.setErrorCode(7288);
        return validationException;
    }

    public static ValidationException readTransformerHasNeitherClassNorMethod(String annotatedElement) {
        Object[] args = new Object[]{annotatedElement};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7289, args));
        validationException.setErrorCode(7289);
        return validationException;
    }

    public static ValidationException writeTransformerClassDoesntImplementFieldTransformer(String annotatedElement, String columnName) {
        Object[] args = new Object[]{annotatedElement, columnName};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7290, args));
        validationException.setErrorCode(7290);
        return validationException;
    }

    public static ValidationException writeTransformerHasBothClassAndMethod(String annotatedElement, String columnName) {
        Object[] args = new Object[]{annotatedElement, columnName};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7291, args));
        validationException.setErrorCode(7291);
        return validationException;
    }

    public static ValidationException writeTransformerHasNeitherClassNorMethod(String annotatedElement, String columnName) {
        Object[] args = new Object[]{annotatedElement, columnName};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7292, args));
        validationException.setErrorCode(7292);
        return validationException;
    }

    public static ValidationException writeTransformerHasNoColumnName(String annotatedElement) {
        Object[] args = new Object[]{annotatedElement};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7293, args));
        validationException.setErrorCode(7293);
        return validationException;
    }

    public static ValidationException copyPolicyMustSpecifyEitherMethodOrWorkingCopyMethod(Object location) {
        Object[] args = new Object[]{location};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7295, args));
        validationException.setErrorCode(7295);
        return validationException;
    }

    public static ValidationException multipleCopyPolicyAnnotationsOnSameClass(String className) {
        Object[] args = new Object[]{className};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7296, args));
        validationException.setErrorCode(7296);
        return validationException;
    }

    public static ValidationException reflectiveExceptionWhileCreatingClassInstance(String className, Exception exception) {
        Object[] args = new Object[]{className};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7297, args), exception);
        validationException.setErrorCode(7297);
        return validationException;
    }

    public static ValidationException expectedProxyPropertyNotFound(String proxyType, String proxyPropertyNotFound) {
        Object[] args = new Object[]{proxyType, proxyPropertyNotFound};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7303, args));
        validationException.setErrorCode(7303);
        return validationException;
    }

    public static ValidationException unknownProxyType(int unknownProxyType, String knownProxyType1, String knownProxyType2, String knownProxyType3) {
        Object[] args = new Object[]{unknownProxyType, knownProxyType1, knownProxyType2, knownProxyType3};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(ValidationException.class, 7304, args));
        validationException.setErrorCode(7304);
        return validationException;
    }
}

