/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.DeferrableChangeRecord;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;

public class DirectCollectionChangeRecord
extends DeferrableChangeRecord
implements org.eclipse.persistence.sessions.changesets.DirectCollectionChangeRecord {
    protected HashMap addObjectMap;
    protected HashMap removeObjectMap;
    protected HashMap commitAddMap;
    public static final NULL Null = new NULL();

    public DirectCollectionChangeRecord() {
    }

    public DirectCollectionChangeRecord(ObjectChangeSet owner) {
        this.owner = owner;
    }

    public void addAdditionChange(HashMap additions, HashMap databaseCount) {
        for (Object object : additions.keySet()) {
            if (databaseCount.containsKey(object)) {
                this.getCommitAddMap().put(object, databaseCount.get(object));
            }
            this.addAdditionChange(object, (Integer)additions.get(object));
        }
    }

    public void addAdditionChange(Object key, Integer count) {
        int addValue;
        if (this.getRemoveObjectMap().containsKey(key)) {
            int addition;
            int removeValue = (Integer)this.getRemoveObjectMap().get(key);
            int result = removeValue - (addition = count.intValue());
            if (result > 0) {
                this.getRemoveObjectMap().put(key, new Integer(result));
            } else if (result < 0) {
                this.getRemoveObjectMap().remove(key);
                this.getAddObjectMap().put(key, new Integer(Math.abs(result)));
            } else {
                this.getRemoveObjectMap().remove(key);
            }
        } else if (this.getAddObjectMap().containsKey(key)) {
            addValue = (Integer)this.getAddObjectMap().get(key);
            this.getAddObjectMap().put(key, new Integer(addValue += count.intValue()));
        } else {
            this.getAddObjectMap().put(key, count);
        }
        addValue = count;
        int commitValue = 0;
        if (this.getCommitAddMap().containsKey(key)) {
            commitValue = (Integer)this.getCommitAddMap().get(key);
        }
        this.getCommitAddMap().put(key, new Integer(addValue + commitValue));
    }

    public void addRemoveChange(HashMap additions, HashMap databaseCount) {
        for (Object object : additions.keySet()) {
            if (databaseCount.containsKey(object)) {
                this.getCommitAddMap().put(object, databaseCount.get(object));
            }
            this.addRemoveChange(object, (Integer)additions.get(object));
        }
    }

    public void addRemoveChange(Object key, Integer count) {
        int removeValue;
        if (this.getAddObjectMap().containsKey(key)) {
            int addition;
            removeValue = (Integer)this.getAddObjectMap().get(key);
            int result = removeValue - (addition = count.intValue());
            if (result > 0) {
                this.getAddObjectMap().put(key, new Integer(result));
            } else if (result < 0) {
                this.getAddObjectMap().remove(key);
                this.getRemoveObjectMap().put(key, new Integer(Math.abs(result)));
            } else {
                this.getAddObjectMap().remove(key);
            }
        } else if (this.getRemoveObjectMap().containsKey(key)) {
            int addValue = (Integer)this.getRemoveObjectMap().get(key);
            this.getRemoveObjectMap().put(key, new Integer(addValue += count.intValue()));
        } else {
            this.getRemoveObjectMap().put(key, count);
        }
        removeValue = count;
        int commitValue = 0;
        if (this.getCommitAddMap().containsKey(key)) {
            commitValue = (Integer)this.getCommitAddMap().get(key);
        }
        this.getCommitAddMap().put(key, new Integer(commitValue - removeValue));
    }

    public void setCommitAddition(Hashtable additions) {
        Enumeration enumtr = additions.keys();
        while (enumtr.hasMoreElements()) {
            Object object = enumtr.nextElement();
            this.getCommitAddMap().put(object, additions.get(object));
        }
    }

    public void storeDatabaseCounts(Object collection, ContainerPolicy containerPolicy, AbstractSession session) {
        Object iterator = containerPolicy.iteratorFor(collection);
        while (containerPolicy.hasNext(iterator)) {
            Object object = containerPolicy.next(iterator, session);
            if (this.getCommitAddMap().containsKey(object)) {
                int count = (Integer)this.getCommitAddMap().get(object);
                this.getCommitAddMap().put(object, new Integer(++count));
                continue;
            }
            this.getCommitAddMap().put(object, new Integer(1));
        }
    }

    public Vector getAddObjectList() {
        Vector vector = new Vector();
        for (Object object : this.getAddObjectMap().keySet()) {
            for (int count = ((Integer)this.getAddObjectMap().get(object)).intValue(); count > 0; --count) {
                vector.add(object);
            }
        }
        return vector;
    }

    public HashMap getAddObjectMap() {
        if (this.addObjectMap == null) {
            this.addObjectMap = new HashMap(1);
        }
        return this.addObjectMap;
    }

    public HashMap getCommitAddMap() {
        if (this.commitAddMap == null) {
            this.commitAddMap = new HashMap(1);
        }
        return this.commitAddMap;
    }

    public Vector getRemoveObjectList() {
        Vector vector = new Vector();
        for (Object object : this.getRemoveObjectMap().keySet()) {
            for (int count = ((Integer)this.getRemoveObjectMap().get(object)).intValue(); count > 0; --count) {
                vector.add(object);
            }
        }
        return vector;
    }

    public HashMap getRemoveObjectMap() {
        if (this.removeObjectMap == null) {
            this.removeObjectMap = new HashMap(1);
        }
        return this.removeObjectMap;
    }

    public boolean hasChanges() {
        return this.addObjectMap != null && !this.addObjectMap.isEmpty() || this.removeObjectMap != null && !this.removeObjectMap.isEmpty() || this.getOwner().isNew();
    }

    public void mergeRecord(ChangeRecord mergeFromRecord, UnitOfWorkChangeSet mergeToChangeSet, UnitOfWorkChangeSet mergeFromChangeSet) {
        HashMap addMapToMerge = ((DirectCollectionChangeRecord)mergeFromRecord).getAddObjectMap();
        HashMap removeMapToMerge = ((DirectCollectionChangeRecord)mergeFromRecord).getRemoveObjectMap();
        for (Object added : addMapToMerge.keySet()) {
            if (!((DirectCollectionChangeRecord)mergeFromRecord).getCommitAddMap().containsKey(added)) {
                this.getCommitAddMap().put(added, ((DirectCollectionChangeRecord)mergeFromRecord).getCommitAddMap().get(added));
            }
            this.addAdditionChange(added, (Integer)addMapToMerge.get(added));
        }
        for (Object removed : removeMapToMerge.keySet()) {
            if (!((DirectCollectionChangeRecord)mergeFromRecord).getCommitAddMap().containsKey(removed)) {
                this.getCommitAddMap().put(removed, ((DirectCollectionChangeRecord)mergeFromRecord).getCommitAddMap().get(removed));
            }
            this.addRemoveChange(removed, (Integer)removeMapToMerge.get(removed));
        }
    }

    public void updateReferences(UnitOfWorkChangeSet mergeToChangeSet, UnitOfWorkChangeSet mergeFromChangeSet) {
    }

    public static class NULL {
        public boolean equals(Object object) {
            return object instanceof NULL;
        }
    }
}

