/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.AggregateCollectionChangeRecord;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.RelationalMapping;
import org.eclipse.persistence.mappings.foundation.MapComponentMapping;
import org.eclipse.persistence.queries.ComplexQueryResult;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteAllQuery;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.InsertObjectQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.UpdateObjectQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.remote.DistributedSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregateCollectionMapping
extends CollectionMapping
implements RelationalMapping,
MapComponentMapping {
    protected transient Vector<DatabaseField> targetForeignKeyFields;
    protected transient Vector<DatabaseField> sourceKeyFields;
    protected transient Map<DatabaseField, DatabaseField> targetForeignKeyToSourceKeys = new HashMap<DatabaseField, DatabaseField>(5);
    protected transient Map<String, String> aggregateToSourceFieldNames;
    protected transient Map<String, Map<String, String>> nestedAggregateToSourceFieldNames;
    protected ClassDescriptor remoteReferenceDescriptor;

    public AggregateCollectionMapping() {
        this.sourceKeyFields = NonSynchronizedVector.newInstance(1);
        this.targetForeignKeyFields = NonSynchronizedVector.newInstance(1);
        this.deleteAllQuery = new DeleteAllQuery();
        this.setCascadeAll(true);
    }

    @Override
    public boolean isRelationalMapping() {
        return true;
    }

    public void addFieldNameTranslation(String sourceFieldName, String aggregateFieldName) {
        if (this.aggregateToSourceFieldNames == null) {
            this.aggregateToSourceFieldNames = new HashMap<String, String>(5);
        }
        this.aggregateToSourceFieldNames.put(aggregateFieldName, sourceFieldName);
    }

    public void addFieldNameTranslations(Map<String, String> map) {
        if (this.aggregateToSourceFieldNames == null) {
            this.aggregateToSourceFieldNames = map;
        } else {
            this.aggregateToSourceFieldNames.putAll(map);
        }
    }

    public void addNestedFieldNameTranslation(String attributeName, String sourceFieldName, String aggregateFieldName) {
        Map<String, String> attributeFieldNameTranslation;
        if (this.nestedAggregateToSourceFieldNames == null) {
            this.nestedAggregateToSourceFieldNames = new HashMap<String, Map<String, String>>(5);
        }
        if ((attributeFieldNameTranslation = this.nestedAggregateToSourceFieldNames.get(attributeName)) == null) {
            attributeFieldNameTranslation = new HashMap<String, String>(5);
            this.nestedAggregateToSourceFieldNames.put(attributeName, attributeFieldNameTranslation);
        }
        attributeFieldNameTranslation.put(aggregateFieldName, sourceFieldName);
    }

    public void addNestedFieldNameTranslations(String attributeName, Map<String, String> map) {
        Map<String, String> attributeFieldNameTranslation;
        if (this.nestedAggregateToSourceFieldNames == null) {
            this.nestedAggregateToSourceFieldNames = new HashMap<String, Map<String, String>>(5);
        }
        if ((attributeFieldNameTranslation = this.nestedAggregateToSourceFieldNames.get(attributeName)) == null) {
            this.nestedAggregateToSourceFieldNames.put(attributeName, map);
        } else {
            attributeFieldNameTranslation.putAll(map);
        }
    }

    public void addTargetForeignKeyFieldName(String targetForeignKey, String sourceKey) {
        this.getTargetForeignKeyFields().addElement(new DatabaseField(targetForeignKey));
        this.getSourceKeyFields().addElement(new DatabaseField(sourceKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object buildBackupCloneForPartObject(Object attributeValue, Object clone, Object backup, UnitOfWorkImpl unitOfWork) {
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        if (attributeValue == null) {
            return containerPolicy.containerInstance(1);
        }
        Object clonedAttributeValue = containerPolicy.containerInstance(containerPolicy.sizeFor(attributeValue));
        Object object = attributeValue;
        synchronized (object) {
            Object valuesIterator = containerPolicy.iteratorFor(attributeValue);
            while (containerPolicy.hasNext(valuesIterator)) {
                Object cloneValue = this.buildElementBackupClone(containerPolicy.next(valuesIterator, unitOfWork), unitOfWork);
                containerPolicy.addInto(cloneValue, clonedAttributeValue, unitOfWork);
            }
        }
        return clonedAttributeValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object buildCloneForPartObject(Object attributeValue, Object original, Object clone, UnitOfWorkImpl unitOfWork, boolean isExisting) {
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        if (attributeValue == null) {
            return containerPolicy.containerInstance(1);
        }
        Object clonedAttributeValue = containerPolicy.containerInstance(containerPolicy.sizeFor(attributeValue));
        Object temporaryCollection = null;
        Object object = attributeValue;
        synchronized (object) {
            temporaryCollection = containerPolicy.cloneFor(attributeValue);
        }
        Object valuesIterator = containerPolicy.iteratorFor(temporaryCollection);
        while (containerPolicy.hasNext(valuesIterator)) {
            Object originalElement = containerPolicy.next(valuesIterator, unitOfWork);
            if (unitOfWork.isOriginalNewObject(original)) {
                unitOfWork.addNewAggregate(originalElement);
            }
            Object cloneValue = this.buildElementClone(originalElement, unitOfWork, isExisting);
            containerPolicy.addInto(cloneValue, clonedAttributeValue, unitOfWork);
        }
        return clonedAttributeValue;
    }

    protected Object buildElementBackupClone(Object element, UnitOfWorkImpl unitOfWork) {
        if (unitOfWork.isClassReadOnly(element.getClass(), this.getReferenceDescriptor())) {
            return element;
        }
        ClassDescriptor aggregateDescriptor = this.getReferenceDescriptor(element.getClass(), unitOfWork);
        Object clonedElement = aggregateDescriptor.getObjectBuilder().buildBackupClone(element, unitOfWork);
        return clonedElement;
    }

    @Override
    protected Object buildElementClone(Object element, UnitOfWorkImpl unitOfWork, boolean isExisting) {
        if (unitOfWork.isClassReadOnly(element.getClass(), this.getReferenceDescriptor())) {
            return element;
        }
        ClassDescriptor aggregateDescriptor = this.getReferenceDescriptor(element.getClass(), unitOfWork);
        Object clonedElement = aggregateDescriptor.getObjectBuilder().instantiateWorkingCopyClone(element, unitOfWork);
        aggregateDescriptor.getObjectBuilder().populateAttributesForClone(element, clonedElement, unitOfWork);
        unitOfWork.getCloneToOriginals().put(clonedElement, element);
        return clonedElement;
    }

    @Override
    public void cascadeDiscoverAndPersistUnregisteredNewObjects(Object object, Map newObjects, Map unregisteredExistingObjects, Map visitedObjects, UnitOfWorkImpl uow) {
        Object cloneAttribute = null;
        cloneAttribute = this.getAttributeValueFromObject(object);
        if (cloneAttribute == null || !this.getIndirectionPolicy().objectIsInstantiated(cloneAttribute)) {
            return;
        }
        ObjectBuilder builder = null;
        ContainerPolicy cp = this.getContainerPolicy();
        Object cloneObjectCollection = null;
        cloneObjectCollection = this.getRealCollectionAttributeValueFromObject(object, uow);
        Object cloneIter = cp.iteratorFor(cloneObjectCollection);
        while (cp.hasNext(cloneIter)) {
            Object nextObject = cp.next(cloneIter, uow);
            if (nextObject == null) continue;
            builder = this.getReferenceDescriptor(nextObject.getClass(), uow).getObjectBuilder();
            builder.cascadeDiscoverAndPersistUnregisteredNewObjects(nextObject, newObjects, unregisteredExistingObjects, visitedObjects, uow);
        }
    }

    @Override
    public void cascadeRegisterNewIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
        Object cloneAttribute = null;
        cloneAttribute = this.getAttributeValueFromObject(object);
        if (cloneAttribute == null || !this.getIndirectionPolicy().objectIsInstantiated(cloneAttribute)) {
            return;
        }
        ObjectBuilder builder = null;
        ContainerPolicy cp = this.getContainerPolicy();
        Object cloneObjectCollection = null;
        cloneObjectCollection = this.getRealCollectionAttributeValueFromObject(object, uow);
        Object cloneIter = cp.iteratorFor(cloneObjectCollection);
        while (cp.hasNext(cloneIter)) {
            Object nextObject = cp.next(cloneIter, uow);
            if (nextObject == null || visitedObjects.containsKey(nextObject)) continue;
            visitedObjects.put(nextObject, nextObject);
            builder = this.getReferenceDescriptor(nextObject.getClass(), uow).getObjectBuilder();
            builder.cascadeRegisterNewForCreate(nextObject, uow, visitedObjects);
        }
    }

    @Override
    public void cascadePerformRemoveIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
        Object cloneAttribute = null;
        cloneAttribute = this.getAttributeValueFromObject(object);
        if (cloneAttribute == null) {
            return;
        }
        ObjectBuilder builder = null;
        ContainerPolicy cp = this.getContainerPolicy();
        Object cloneObjectCollection = null;
        cloneObjectCollection = this.getRealCollectionAttributeValueFromObject(object, uow);
        Object cloneIter = cp.iteratorFor(cloneObjectCollection);
        while (cp.hasNext(cloneIter)) {
            Object nextObject = cp.next(cloneIter, uow);
            if (nextObject == null || visitedObjects.containsKey(nextObject)) continue;
            visitedObjects.put(nextObject, nextObject);
            builder = this.getReferenceDescriptor(nextObject.getClass(), uow).getObjectBuilder();
            builder.cascadePerformRemove(nextObject, uow, visitedObjects);
        }
    }

    @Override
    public void cascadePerformRemovePrivateOwnedObjectFromChangeSetIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
        Object attributeValue = this.getAttributeValueFromObject(object);
        if (attributeValue != null && this.getIndirectionPolicy().objectIsInstantiated(attributeValue)) {
            Object cloneObjectCollection = this.getRealCollectionAttributeValueFromObject(object, uow);
            ContainerPolicy cp = this.getContainerPolicy();
            Object cloneIter = cp.iteratorFor(cloneObjectCollection);
            while (cp.hasNext(cloneIter)) {
                Object referencedObject = cp.next(cloneIter, uow);
                if (referencedObject == null || visitedObjects.containsKey(referencedObject)) continue;
                visitedObjects.put(referencedObject, referencedObject);
                ObjectBuilder builder = this.getReferenceDescriptor(referencedObject.getClass(), uow).getObjectBuilder();
                builder.cascadePerformRemovePrivateOwnedObjectFromChangeSet(referencedObject, uow, visitedObjects);
            }
        }
    }

    @Override
    public Object clone() {
        AggregateCollectionMapping mappingObject = (AggregateCollectionMapping)super.clone();
        mappingObject.setTargetForeignKeyToSourceKeys(new HashMap<DatabaseField, DatabaseField>(this.getTargetForeignKeyToSourceKeys()));
        mappingObject.setSourceKeyFields(NonSynchronizedVector.newInstance(this.getSourceKeyFields()));
        mappingObject.setTargetForeignKeyFields(NonSynchronizedVector.newInstance(this.getTargetForeignKeyFields()));
        return mappingObject;
    }

    @Override
    public ChangeRecord compareForChange(Object clone, Object backUp, ObjectChangeSet owner, AbstractSession session) {
        Object cloneAttribute = null;
        Object backUpAttribute = null;
        cloneAttribute = this.getAttributeValueFromObject(clone);
        if (cloneAttribute != null && !this.getIndirectionPolicy().objectIsInstantiated(cloneAttribute)) {
            return null;
        }
        if (!owner.isNew()) {
            backUpAttribute = this.getAttributeValueFromObject(backUp);
            if (backUpAttribute == null && cloneAttribute == null) {
                return null;
            }
            ContainerPolicy cp = this.getContainerPolicy();
            Object backupCollection = null;
            Object cloneCollection = null;
            cloneCollection = this.getRealCollectionAttributeValueFromObject(clone, session);
            backupCollection = this.getRealCollectionAttributeValueFromObject(backUp, session);
            if (cp.sizeFor(backupCollection) != cp.sizeFor(cloneCollection)) {
                return this.convertToChangeRecord(cloneCollection, owner, session);
            }
            Object cloneIterator = cp.iteratorFor(cloneCollection);
            Object backUpIterator = cp.iteratorFor(backupCollection);
            boolean change = false;
            UnitOfWorkChangeSet uowComparisonChangeSet = new UnitOfWorkChangeSet(session);
            while (cp.hasNext(cloneIterator)) {
                Object cloneObject = cp.next(cloneIterator, session);
                if (cloneObject == null) {
                    change = true;
                    break;
                }
                Object backUpObject = null;
                if (!cp.hasNext(backUpIterator)) {
                    change = true;
                    break;
                }
                backUpObject = cp.next(backUpIterator, session);
                if (cloneObject.getClass().equals(backUpObject.getClass())) {
                    ObjectBuilder builder = this.getReferenceDescriptor(cloneObject.getClass(), session).getObjectBuilder();
                    ObjectChangeSet initialChanges = builder.createObjectChangeSet(cloneObject, uowComparisonChangeSet, owner.isNew(), session);
                    ObjectChangeSet changes = builder.compareForChange(cloneObject, backUpObject, uowComparisonChangeSet, session);
                    if (changes == null) continue;
                    change = true;
                    break;
                }
                change = true;
                break;
            }
            if (change || cp.hasNext(backUpIterator)) {
                return this.convertToChangeRecord(cloneCollection, owner, session);
            }
            return null;
        }
        return this.convertToChangeRecord(this.getRealCollectionAttributeValueFromObject(clone, session), owner, session);
    }

    @Override
    public boolean compareObjects(Object firstObject, Object secondObject, AbstractSession session) {
        Object firstCollection = this.getRealCollectionAttributeValueFromObject(firstObject, session);
        Object secondCollection = this.getRealCollectionAttributeValueFromObject(secondObject, session);
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        if (containerPolicy.sizeFor(firstCollection) != containerPolicy.sizeFor(secondCollection)) {
            return false;
        }
        if (containerPolicy.sizeFor(firstCollection) == 0) {
            return true;
        }
        Object iterFirst = containerPolicy.iteratorFor(firstCollection);
        block0: while (containerPolicy.hasNext(iterFirst)) {
            Object firstAggregateObject = containerPolicy.next(iterFirst, session);
            Object iterSecond = containerPolicy.iteratorFor(secondCollection);
            do {
                Object secondAggregateObject = containerPolicy.next(iterSecond, session);
                if (this.getReferenceDescriptor().getObjectBuilder().compareObjects(firstAggregateObject, secondAggregateObject, session)) continue block0;
            } while (containerPolicy.hasNext(iterSecond));
            return false;
        }
        return true;
    }

    protected ChangeRecord convertToChangeRecord(Object cloneCollection, ObjectChangeSet owner, AbstractSession session) {
        ContainerPolicy cp = this.getContainerPolicy();
        Object cloneIter = cp.iteratorFor(cloneCollection);
        Vector<ObjectChangeSet> collectionChanges = new Vector<ObjectChangeSet>(2);
        while (cp.hasNext(cloneIter)) {
            Object aggregateObject = cp.next(cloneIter, session);
            if (aggregateObject == null) continue;
            ObjectChangeSet changes = this.getReferenceDescriptor(aggregateObject.getClass(), session).getObjectBuilder().compareForChange(aggregateObject, null, (UnitOfWorkChangeSet)owner.getUOWChangeSet(), session);
            collectionChanges.addElement(changes);
        }
        AggregateCollectionChangeRecord changeRecord = new AggregateCollectionChangeRecord(owner);
        changeRecord.setAttribute(this.getAttributeName());
        changeRecord.setMapping(this);
        changeRecord.setChangedValues(collectionChanges);
        return changeRecord;
    }

    protected void deleteAll(DeleteObjectQuery query, Object elements) throws DatabaseException {
        ((DeleteAllQuery)this.getDeleteAllQuery()).executeDeleteAll(query.getSession().getSessionForClass(this.getReferenceClass()), query.getTranslationRow(), this.getContainerPolicy().vectorFor(elements, query.getSession()));
    }

    protected void executeEvent(int eventCode, ObjectLevelModifyQuery query) {
        ClassDescriptor referenceDescriptor = this.getReferenceDescriptor(query.getObject().getClass(), query.getSession());
        if (referenceDescriptor.getEventManager().hasAnyEventListeners()) {
            referenceDescriptor.getEventManager().executeEvent(new DescriptorEvent(eventCode, query));
        }
    }

    protected Vector extractKeyFromTargetRow(AbstractRecord row, AbstractSession session) {
        Vector<Object> key = new Vector<Object>(this.getTargetForeignKeyFields().size());
        for (int index = 0; index < this.getTargetForeignKeyFields().size(); ++index) {
            DatabaseField targetField = this.getTargetForeignKeyFields().elementAt(index);
            DatabaseField sourceField = this.getSourceKeyFields().elementAt(index);
            Object value = row.get(targetField);
            try {
                value = session.getDatasourcePlatform().getConversionManager().convertObject(value, this.getDescriptor().getObjectBuilder().getFieldClassification(sourceField));
            }
            catch (ConversionException e) {
                throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), e);
            }
            key.addElement(value);
        }
        return key;
    }

    protected Vector extractPrimaryKeyFromRow(AbstractRecord row, AbstractSession session) {
        Vector<Object> key = new Vector<Object>(this.getSourceKeyFields().size());
        Enumeration<DatabaseField> fieldEnum = this.getSourceKeyFields().elements();
        while (fieldEnum.hasMoreElements()) {
            DatabaseField field = fieldEnum.nextElement();
            Object value = row.get(field);
            try {
                value = session.getDatasourcePlatform().getConversionManager().convertObject(value, this.getDescriptor().getObjectBuilder().getFieldClassification(field));
            }
            catch (ConversionException e) {
                throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), e);
            }
            key.addElement(value);
        }
        return key;
    }

    @Override
    protected void postPrepareNestedBatchQuery(ReadQuery batchQuery, ReadAllQuery query) {
        ReadAllQuery aggregateBatchQuery = (ReadAllQuery)batchQuery;
        aggregateBatchQuery.setShouldIncludeData(true);
        Enumeration<DatabaseField> relationFieldsEnum = this.getTargetForeignKeyFields().elements();
        while (relationFieldsEnum.hasMoreElements()) {
            aggregateBatchQuery.getAdditionalFields().addElement(relationFieldsEnum.nextElement());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object extractResultFromBatchQuery(DatabaseQuery query, AbstractRecord databaseRow, AbstractSession session, AbstractRecord argumentRow) {
        Hashtable<CacheKey, Object> referenceObjectsByKey = null;
        ContainerPolicy mappingContainerPolicy = this.getContainerPolicy();
        DatabaseQuery databaseQuery = query;
        synchronized (databaseQuery) {
            mappingContainerPolicy = this.getContainerPolicy();
            referenceObjectsByKey = this.getBatchReadObjects(query, session);
            if (referenceObjectsByKey == null) {
                ReadAllQuery batchQuery = (ReadAllQuery)query;
                ComplexQueryResult complexResult = null;
                complexResult = (ComplexQueryResult)session.executeQuery(query, argumentRow);
                Object results = complexResult.getResult();
                referenceObjectsByKey = new Hashtable<CacheKey, Object>();
                Enumeration rowsEnum = ((Vector)complexResult.getData()).elements();
                ContainerPolicy queryContainerPolicy = batchQuery.getContainerPolicy();
                Object elementsIterator = queryContainerPolicy.iteratorFor(results);
                while (queryContainerPolicy.hasNext(elementsIterator)) {
                    Object eachReferenceObject = queryContainerPolicy.next(elementsIterator, session);
                    CacheKey eachReferenceKey = new CacheKey(this.extractKeyFromTargetRow((AbstractRecord)rowsEnum.nextElement(), session));
                    if (!referenceObjectsByKey.containsKey(eachReferenceKey)) {
                        referenceObjectsByKey.put(eachReferenceKey, mappingContainerPolicy.containerInstance());
                    }
                    mappingContainerPolicy.addInto(eachReferenceObject, referenceObjectsByKey.get(eachReferenceKey), session);
                }
                this.setBatchReadObjects(referenceObjectsByKey, query, session);
            }
        }
        Object result = referenceObjectsByKey.get(new CacheKey(this.extractPrimaryKeyFromRow(databaseRow, session)));
        if (result == null) {
            return mappingContainerPolicy.containerInstance();
        }
        return result;
    }

    public AbstractRecord getAggregateRow(ObjectLevelModifyQuery query, Object object) {
        Vector referenceObjectKeys = this.getReferenceObjectKeys(query);
        DatabaseRecord aggregateRow = new DatabaseRecord();
        Vector<DatabaseField> keys = this.getTargetForeignKeyFields();
        for (int keyIndex = 0; keyIndex < keys.size(); ++keyIndex) {
            ((AbstractRecord)aggregateRow).put((Object)keys.elementAt(keyIndex), referenceObjectKeys.elementAt(keyIndex));
        }
        this.getReferenceDescriptor(object.getClass(), query.getSession()).getObjectBuilder().buildRow(aggregateRow, object, query.getSession());
        return aggregateRow;
    }

    protected Expression getDeleteAllCriteria(AbstractSession session) {
        Expression criteria = null;
        ExpressionBuilder builder = new ExpressionBuilder();
        for (DatabaseField targetForeignKey : this.getTargetForeignKeyToSourceKeys().keySet()) {
            DatabaseField sourceKey = this.getTargetForeignKeyToSourceKeys().get(targetForeignKey);
            Expression expression = ((Expression)builder).getField(targetForeignKey).equal(builder.getParameter(sourceKey));
            criteria = expression.and(criteria);
        }
        return criteria;
    }

    @Override
    public ClassDescriptor getReferenceDescriptor() {
        if (this.referenceDescriptor == null) {
            this.referenceDescriptor = this.remoteReferenceDescriptor;
        }
        return this.referenceDescriptor;
    }

    public ClassDescriptor getReferenceDescriptor(Class theClass, AbstractSession session) {
        if (this.getReferenceDescriptor().getJavaClass().equals(theClass)) {
            return this.getReferenceDescriptor();
        }
        ClassDescriptor subDescriptor = this.getReferenceDescriptor().getInheritancePolicy().getSubclassDescriptor(theClass);
        if (subDescriptor == null) {
            throw DescriptorException.noSubClassMatch(theClass, this);
        }
        return subDescriptor;
    }

    public Vector getReferenceObjectKeys(ObjectLevelModifyQuery query) throws DatabaseException, OptimisticLockException {
        Vector<Object> referenceObjectKeys = new Vector<Object>(this.getSourceKeyFields().size());
        AbstractRecord translationRow = query.getTranslationRow();
        Enumeration<DatabaseField> sourcekeys = this.getSourceKeyFields().elements();
        while (sourcekeys.hasMoreElements()) {
            DatabaseField sourceKey = sourcekeys.nextElement();
            Object referenceKey = null;
            referenceKey = translationRow != null && translationRow.containsKey(sourceKey) ? translationRow.get(sourceKey) : this.getDescriptor().getObjectBuilder().extractValueFromObjectForField(query.getObject(), sourceKey, query.getSession());
            referenceObjectKeys.addElement(referenceKey);
        }
        return referenceObjectKeys;
    }

    public Vector getSourceKeyFieldNames() {
        Vector<String> fieldNames = new Vector<String>(this.getSourceKeyFields().size());
        Enumeration<DatabaseField> fieldsEnum = this.getSourceKeyFields().elements();
        while (fieldsEnum.hasMoreElements()) {
            fieldNames.addElement(fieldsEnum.nextElement().getQualifiedName());
        }
        return fieldNames;
    }

    public Vector<DatabaseField> getSourceKeyFields() {
        return this.sourceKeyFields;
    }

    public Vector getTargetForeignKeyFieldNames() {
        Vector<String> fieldNames = new Vector<String>(this.getTargetForeignKeyFields().size());
        Enumeration<DatabaseField> fieldsEnum = this.getTargetForeignKeyFields().elements();
        while (fieldsEnum.hasMoreElements()) {
            fieldNames.addElement(fieldsEnum.nextElement().getQualifiedName());
        }
        return fieldNames;
    }

    public Vector<DatabaseField> getTargetForeignKeyFields() {
        return this.targetForeignKeyFields;
    }

    public Map<DatabaseField, DatabaseField> getTargetForeignKeyToSourceKeys() {
        return this.targetForeignKeyToSourceKeys;
    }

    @Override
    public void initialize(AbstractSession session) throws DescriptorException {
        super.initialize(session);
        if (!this.getReferenceDescriptor().isAggregateCollectionDescriptor()) {
            session.getIntegrityChecker().handleError(DescriptorException.referenceDescriptorIsNotAggregateCollection(this.getReferenceClass().getName(), this));
        }
        if (this.shouldInitializeSelectionCriteria()) {
            if (this.isSourceKeySpecified()) {
                this.initializeTargetForeignKeyToSourceKeys(session);
            } else {
                this.initializeTargetForeignKeyToSourceKeysWithDefaults(session);
            }
            this.initializeSelectionCriteria(session);
        }
        this.getSelectionQuery().setShouldMaintainCache(false);
        this.initializeDeleteAllQuery(session);
    }

    @Override
    protected void initializeReferenceDescriptor(AbstractSession session) throws DescriptorException {
        super.initializeReferenceDescriptor(session);
        HashMap<DatabaseField, DatabaseField> fieldTranslation = null;
        HashMap<DatabaseTable, DatabaseTable> tableTranslation = null;
        Object newTables = null;
        int nAggregateTables = 0;
        if (this.getReferenceDescriptor().getTables() != null) {
            nAggregateTables = this.getReferenceDescriptor().getTables().size();
        }
        if (this.aggregateToSourceFieldNames != null) {
            DatabaseTable aggregateDefaultTable = null;
            aggregateDefaultTable = nAggregateTables != 0 ? this.getReferenceDescriptor().getTables().get(0) : new DatabaseTable();
            tableTranslation = new HashMap<DatabaseTable, DatabaseTable>();
            fieldTranslation = new HashMap<DatabaseField, DatabaseField>();
            for (Map.Entry<String, String> entry : this.aggregateToSourceFieldNames.entrySet()) {
                DatabaseField sourceField;
                DatabaseField aggregateField = new DatabaseField(entry.getKey());
                if (!aggregateField.hasTableName()) {
                    aggregateField.setTable(aggregateDefaultTable);
                }
                if (!(sourceField = new DatabaseField(entry.getValue())).hasTableName()) {
                    // empty if block
                }
                DatabaseTable sourceTable = sourceField.getTable();
                DatabaseTable savedSourceTable = tableTranslation.get(aggregateField.getTable());
                if (savedSourceTable == null) {
                    tableTranslation.put(aggregateField.getTable(), sourceTable);
                } else if (!sourceTable.equals(savedSourceTable)) {
                    // empty if block
                }
                fieldTranslation.put(aggregateField, sourceField);
            }
        } else if (nAggregateTables == 0) {
            // empty if block
        }
        ClassDescriptor clonedDescriptor = (ClassDescriptor)this.getReferenceDescriptor().clone();
        if (fieldTranslation != null) {
            AggregateCollectionMapping.translateTablesAndFields(clonedDescriptor, fieldTranslation, tableTranslation);
        }
        if (this.nestedAggregateToSourceFieldNames != null) {
            this.updateNestedAggregateCollectionMappings(clonedDescriptor);
        }
        if (clonedDescriptor.isChildDescriptor()) {
            ClassDescriptor parentDescriptor = session.getDescriptor(clonedDescriptor.getInheritancePolicy().getParentClass());
            this.initializeParentInheritance(parentDescriptor, clonedDescriptor, session, fieldTranslation, tableTranslation);
        }
        if (clonedDescriptor.isAggregateDescriptor()) {
            clonedDescriptor.descriptorIsAggregateCollection();
        }
        this.setReferenceDescriptor(clonedDescriptor);
        clonedDescriptor.preInitialize(session);
        clonedDescriptor.initialize(session);
        if (clonedDescriptor.hasInheritance() && clonedDescriptor.getInheritancePolicy().hasChildren()) {
            this.initializeChildInheritance(clonedDescriptor, session, fieldTranslation, tableTranslation);
        }
    }

    protected static void translateTablesAndFields(ClassDescriptor descriptor, HashMap<DatabaseField, DatabaseField> fieldTranslation, HashMap<DatabaseTable, DatabaseTable> tableTranslation) {
        int nTables = 0;
        if (descriptor.getTables() != null) {
            nTables = descriptor.getTables().size();
        }
        DatabaseTable defaultAggregateTable = null;
        if (nTables == 0) {
            defaultAggregateTable = new DatabaseTable();
            DatabaseTable defaultSourceTable = tableTranslation.get(defaultAggregateTable);
            if (defaultSourceTable == null) {
                // empty if block
            }
            descriptor.addTable(defaultSourceTable);
        } else {
            defaultAggregateTable = descriptor.getTables().get(0);
            NonSynchronizedVector newTables = NonSynchronizedVector.newInstance(nTables);
            for (int i = 0; i < nTables; ++i) {
                DatabaseTable table = tableTranslation.get(descriptor.getTables().get(i));
                if (table == null) {
                    // empty if block
                }
                if (newTables.contains(table)) continue;
                ((Vector)newTables).add(table);
            }
            descriptor.setTables(newTables);
        }
        int nPrimaryKeyFields = 0;
        if (descriptor.getPrimaryKeyFields() != null) {
            nPrimaryKeyFields = descriptor.getPrimaryKeyFields().size();
        }
        if (nPrimaryKeyFields > 0) {
            ArrayList<DatabaseField> newPrimaryKeyFields = new ArrayList<DatabaseField>(nPrimaryKeyFields);
            for (int i = 0; i < nPrimaryKeyFields; ++i) {
                DatabaseField field;
                DatabaseField pkField = descriptor.getPrimaryKeyFields().get(i);
                if (!pkField.hasTableName() && nTables > 0) {
                    pkField = new DatabaseField(pkField.getName(), defaultAggregateTable);
                }
                if ((field = fieldTranslation.get(pkField)) == null) {
                    // empty if block
                }
                newPrimaryKeyFields.add(field);
            }
            descriptor.setPrimaryKeyFields(newPrimaryKeyFields);
        }
        descriptor.getObjectBuilder().getFieldsMap().putAll(fieldTranslation);
    }

    protected void updateNestedAggregateCollectionMappings(ClassDescriptor descriptor) {
        for (Map.Entry<String, Map<String, String>> entry : this.nestedAggregateToSourceFieldNames.entrySet()) {
            DatabaseMapping mapping;
            String attribute = entry.getKey();
            String nestedAttribute = null;
            int indexOfDot = attribute.indexOf(46);
            if (indexOfDot >= 0) {
                nestedAttribute = attribute.substring(indexOfDot + 1, attribute.length());
                attribute = attribute.substring(0, indexOfDot);
            }
            if ((mapping = descriptor.getMappingForAttributeName(attribute)) == null) continue;
            if (!mapping.isAggregateCollectionMapping()) {
                // empty if block
            }
            AggregateCollectionMapping nestedAggregateCollectionMapping = (AggregateCollectionMapping)mapping;
            if (nestedAttribute == null) {
                nestedAggregateCollectionMapping.addFieldNameTranslations(entry.getValue());
                continue;
            }
            nestedAggregateCollectionMapping.addNestedFieldNameTranslations(nestedAttribute, entry.getValue());
        }
    }

    protected void translateFields(ClassDescriptor clonedDescriptor, AbstractSession session) {
        if (this.aggregateToSourceFieldNames != null) {
            Enumeration<DatabaseField> entry = clonedDescriptor.getFields().elements();
            while (entry.hasMoreElements()) {
                DatabaseField field = entry.nextElement();
                String nameInAggregate = field.getName();
                String nameInSource = this.aggregateToSourceFieldNames.get(nameInAggregate);
                if (nameInSource == null) continue;
                DatabaseField fieldInSource = new DatabaseField(nameInSource);
                if (fieldInSource.getName().equals(nameInSource)) {
                    field.setName(nameInSource);
                    continue;
                }
                field.setName(fieldInSource.getName());
                field.setTable(clonedDescriptor.getTable(fieldInSource.getTable().getName()));
            }
            clonedDescriptor.rehashFieldDependancies(session);
        }
    }

    public void initializeChildInheritance(ClassDescriptor parentDescriptor, AbstractSession session, HashMap<DatabaseField, DatabaseField> fieldTranslation, HashMap<DatabaseTable, DatabaseTable> tableTranslation) throws DescriptorException {
        if (parentDescriptor.getInheritancePolicy().hasChildren()) {
            Vector childDescriptors = parentDescriptor.getInheritancePolicy().getChildDescriptors();
            NonSynchronizedVector cloneChildDescriptors = NonSynchronizedVector.newInstance();
            Enumeration enumtr = childDescriptors.elements();
            while (enumtr.hasMoreElements()) {
                ClassDescriptor clonedChildDescriptor = (ClassDescriptor)((ClassDescriptor)enumtr.nextElement()).clone();
                if (fieldTranslation != null) {
                    AggregateCollectionMapping.translateTablesAndFields(clonedChildDescriptor, fieldTranslation, tableTranslation);
                }
                if (this.nestedAggregateToSourceFieldNames != null) {
                    this.updateNestedAggregateCollectionMappings(clonedChildDescriptor);
                }
                if (clonedChildDescriptor.isAggregateDescriptor()) {
                    clonedChildDescriptor.descriptorIsAggregateCollection();
                }
                if (!clonedChildDescriptor.isAggregateCollectionDescriptor()) {
                    session.getIntegrityChecker().handleError(DescriptorException.referenceDescriptorIsNotAggregate(clonedChildDescriptor.getJavaClass().getName(), this));
                }
                clonedChildDescriptor.getInheritancePolicy().setParentDescriptor(parentDescriptor);
                clonedChildDescriptor.preInitialize(session);
                clonedChildDescriptor.initialize(session);
                ((Vector)cloneChildDescriptors).addElement(clonedChildDescriptor);
                this.initializeChildInheritance(clonedChildDescriptor, session, fieldTranslation, tableTranslation);
            }
            parentDescriptor.getInheritancePolicy().setChildDescriptors(cloneChildDescriptors);
        }
    }

    protected void initializeDeleteAllQuery(AbstractSession session) {
        DeleteAllQuery query = (DeleteAllQuery)this.getDeleteAllQuery();
        query.setReferenceClass(this.getReferenceClass());
        query.setDescriptor(this.getReferenceDescriptor());
        query.setShouldMaintainCache(false);
        if (!this.hasCustomDeleteAllQuery()) {
            if (this.getSelectionCriteria() == null) {
                query.setSelectionCriteria(this.getDeleteAllCriteria(session));
            } else {
                query.setSelectionCriteria(this.getSelectionCriteria());
            }
        }
    }

    public void initializeParentInheritance(ClassDescriptor parentDescriptor, ClassDescriptor childDescriptor, AbstractSession session, HashMap<DatabaseField, DatabaseField> fieldTranslation, HashMap<DatabaseTable, DatabaseTable> tableTranslation) throws DescriptorException {
        ClassDescriptor clonedParentDescriptor = (ClassDescriptor)parentDescriptor.clone();
        if (clonedParentDescriptor.isAggregateDescriptor()) {
            clonedParentDescriptor.descriptorIsAggregateCollection();
        }
        if (!clonedParentDescriptor.isAggregateCollectionDescriptor()) {
            session.getIntegrityChecker().handleError(DescriptorException.referenceDescriptorIsNotAggregateCollection(parentDescriptor.getJavaClass().getName(), this));
        }
        if (fieldTranslation != null) {
            AggregateCollectionMapping.translateTablesAndFields(clonedParentDescriptor, fieldTranslation, tableTranslation);
        }
        if (this.nestedAggregateToSourceFieldNames != null) {
            this.updateNestedAggregateCollectionMappings(clonedParentDescriptor);
        }
        if (clonedParentDescriptor.getInheritancePolicy().isChildDescriptor()) {
            ClassDescriptor parentToParentDescriptor = session.getDescriptor(clonedParentDescriptor.getJavaClass());
            this.initializeParentInheritance(parentToParentDescriptor, parentDescriptor, session, fieldTranslation, tableTranslation);
        }
        NonSynchronizedVector children = NonSynchronizedVector.newInstance(1);
        ((Vector)children).addElement(childDescriptor);
        clonedParentDescriptor.getInheritancePolicy().setChildDescriptors(children);
        clonedParentDescriptor.preInitialize(session);
        clonedParentDescriptor.initialize(session);
    }

    protected void initializeSelectionCriteria(AbstractSession session) {
        ExpressionBuilder builder = new ExpressionBuilder();
        for (DatabaseField targetForeignKey : this.getTargetForeignKeyToSourceKeys().keySet()) {
            DatabaseField sourceKey = this.getTargetForeignKeyToSourceKeys().get(targetForeignKey);
            Expression expression = ((Expression)builder).getField(targetForeignKey).equal(builder.getParameter(sourceKey));
            Expression criteria = expression.and(this.getSelectionCriteria());
            this.setSelectionCriteria(criteria);
        }
    }

    protected void initializeTargetForeignKeyToSourceKeys(AbstractSession session) throws DescriptorException {
        int index;
        if (this.getTargetForeignKeyFields().isEmpty()) {
            throw DescriptorException.noTargetForeignKeysSpecified(this);
        }
        for (index = 0; index < this.getTargetForeignKeyFields().size(); ++index) {
            DatabaseField foreignKeyfield = this.getTargetForeignKeyFields().get(index);
            foreignKeyfield = this.getReferenceDescriptor().buildField(foreignKeyfield);
            this.getTargetForeignKeyFields().set(index, foreignKeyfield);
        }
        for (index = 0; index < this.getSourceKeyFields().size(); ++index) {
            DatabaseField sourceKeyfield = this.getSourceKeyFields().get(index);
            sourceKeyfield = this.getDescriptor().buildField(sourceKeyfield);
            this.getSourceKeyFields().set(index, sourceKeyfield);
        }
        if (this.getTargetForeignKeyFields().size() != this.getSourceKeyFields().size()) {
            throw DescriptorException.targetForeignKeysSizeMismatch(this);
        }
        Iterator<DatabaseField> targetForeignKeysEnum = this.getTargetForeignKeyFields().iterator();
        Iterator<DatabaseField> sourceKeysEnum = this.getSourceKeyFields().iterator();
        while (targetForeignKeysEnum.hasNext()) {
            this.getTargetForeignKeyToSourceKeys().put(targetForeignKeysEnum.next(), sourceKeysEnum.next());
        }
    }

    protected void initializeTargetForeignKeyToSourceKeysWithDefaults(AbstractSession session) throws DescriptorException {
        int index;
        if (this.getTargetForeignKeyFields().isEmpty()) {
            throw DescriptorException.noTargetForeignKeysSpecified(this);
        }
        List<DatabaseField> sourceKeys = this.getDescriptor().getPrimaryKeyFields();
        this.setSourceKeyFields(NonSynchronizedVector.newInstance(sourceKeys));
        for (index = 0; index < this.getTargetForeignKeyFields().size(); ++index) {
            DatabaseField foreignKeyfield = this.getTargetForeignKeyFields().get(index);
            foreignKeyfield = this.getReferenceDescriptor().buildField(foreignKeyfield);
            this.getTargetForeignKeyFields().set(index, foreignKeyfield);
        }
        if (this.getTargetForeignKeyFields().size() != sourceKeys.size()) {
            throw DescriptorException.targetForeignKeysSizeMismatch(this);
        }
        for (index = 0; index < this.getTargetForeignKeyFields().size(); ++index) {
            this.getTargetForeignKeyToSourceKeys().put(this.getTargetForeignKeyFields().get(index), sourceKeys.get(index));
        }
    }

    @Override
    public void iterateOnElement(DescriptorIterator iterator, Object element) {
        if (element != null) {
            iterator.iterateForAggregateMapping(element, this, this.getReferenceDescriptor(element.getClass(), iterator.getSession()));
        }
    }

    @Override
    public boolean isAggregateCollectionMapping() {
        return true;
    }

    @Override
    public boolean isJoiningSupported() {
        return true;
    }

    @Override
    public boolean isPrivateOwned() {
        return true;
    }

    protected boolean isSourceKeySpecified() {
        return !this.getSourceKeyFields().isEmpty();
    }

    @Override
    public void mergeChangesIntoObject(Object target, ChangeRecord changeRecord, Object source, MergeManager mergeManager) {
        if (!this.isAttributeValueInstantiatedOrChanged(target)) {
            return;
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        AbstractSession session = mergeManager.getSession();
        Object valueOfTarget = null;
        Object sourceAggregate = null;
        if (mergeManager.shouldMergeChangesIntoDistributedCache()) {
            ClassDescriptor descriptor = this.getDescriptor();
            AbstractRecord parentRow = descriptor.getObjectBuilder().extractPrimaryKeyRowFromObject(target, session);
            Object result = this.getIndirectionPolicy().valueFromQuery(this.getSelectionQuery(), parentRow, session);
            this.setAttributeValueInObject(target, result);
            return;
        }
        Vector aggregateObjects = ((AggregateCollectionChangeRecord)changeRecord).getChangedValues();
        valueOfTarget = containerPolicy.containerInstance();
        ObjectChangeSet objectChanges = null;
        for (int i = 0; i < aggregateObjects.size(); ++i) {
            objectChanges = (ObjectChangeSet)aggregateObjects.elementAt(i);
            Class localClassType = objectChanges.getClassType(session);
            sourceAggregate = objectChanges.getUnitOfWorkClone();
            Object targetAggregate = ((UnitOfWorkImpl)mergeManager.getSession()).getCloneToOriginals().get(sourceAggregate);
            if (targetAggregate == null) {
                targetAggregate = this.getReferenceDescriptor(localClassType, session).getObjectBuilder().buildNewInstance();
            }
            this.getReferenceDescriptor(localClassType, session).getObjectBuilder().mergeChangesIntoObject(targetAggregate, objectChanges, sourceAggregate, mergeManager);
            containerPolicy.addInto(targetAggregate, valueOfTarget, session);
        }
        this.setRealAttributeValueInObject(target, valueOfTarget);
    }

    @Override
    public void mergeIntoObject(Object target, boolean isTargetUnInitialized, Object source, MergeManager mergeManager) {
        if (isTargetUnInitialized && mergeManager.shouldMergeWorkingCopyIntoOriginal() && !this.isAttributeValueInstantiatedOrChanged(source)) {
            this.setAttributeValueInObject(target, this.getIndirectionPolicy().getOriginalIndirectionObject(this.getAttributeValueFromObject(source), mergeManager.getSession()));
            return;
        }
        if (!this.shouldMergeCascadeReference(mergeManager)) {
            return;
        }
        if (mergeManager.shouldRefreshRemoteObject() && this.shouldMergeCascadeParts(mergeManager) && this.usesIndirection()) {
            this.mergeRemoteValueHolder(target, source, mergeManager);
            return;
        }
        if (mergeManager.shouldMergeOriginalIntoWorkingCopy() ? !this.isAttributeValueInstantiatedOrChanged(target) : !this.isAttributeValueInstantiatedOrChanged(source)) {
            return;
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object valueOfSource = this.getRealCollectionAttributeValueFromObject(source, mergeManager.getSession());
        Object valueOfTarget = containerPolicy.containerInstance(containerPolicy.sizeFor(valueOfSource));
        Object sourceValuesIterator = containerPolicy.iteratorFor(valueOfSource);
        while (containerPolicy.hasNext(sourceValuesIterator)) {
            Object sourceValue = containerPolicy.next(sourceValuesIterator, mergeManager.getSession());
            Object originalValue = null;
            if (sourceValue == null) continue;
            originalValue = this.getReferenceDescriptor(sourceValue.getClass(), mergeManager.getSession()).getObjectBuilder().buildNewInstance();
            this.getReferenceDescriptor(sourceValue.getClass(), mergeManager.getSession()).getObjectBuilder().mergeIntoObject(originalValue, true, sourceValue, mergeManager);
            containerPolicy.addInto(originalValue, valueOfTarget, mergeManager.getSession());
        }
        this.setRealAttributeValueInObject(target, valueOfTarget);
    }

    @Override
    protected void objectAddedDuringUpdate(ObjectLevelModifyQuery query, Object objectAdded, ObjectChangeSet changeSet) throws DatabaseException, OptimisticLockException {
        InsertObjectQuery insertQuery = this.getAndPrepareModifyQueryForInsert(query, objectAdded);
        query.getSession().executeQuery((DatabaseQuery)insertQuery, insertQuery.getTranslationRow());
    }

    @Override
    protected void objectRemovedDuringUpdate(ObjectLevelModifyQuery query, Object objectDeleted) throws DatabaseException, OptimisticLockException {
        DeleteObjectQuery deleteQuery = new DeleteObjectQuery();
        deleteQuery.setIsExecutionClone(true);
        this.prepareModifyQueryForDelete(query, deleteQuery, objectDeleted);
        query.getSession().executeQuery((DatabaseQuery)deleteQuery, deleteQuery.getTranslationRow());
    }

    @Override
    protected void objectUnchangedDuringUpdate(ObjectLevelModifyQuery query, Object object, Hashtable backupCloneKeyedCache, CacheKey cachedKey) throws DatabaseException, OptimisticLockException {
        UpdateObjectQuery updateQuery = new UpdateObjectQuery();
        updateQuery.setIsExecutionClone(true);
        Object backupclone = backupCloneKeyedCache.get(cachedKey);
        updateQuery.setBackupClone(backupclone);
        this.prepareModifyQueryForUpdate(query, updateQuery, object);
        query.getSession().executeQuery((DatabaseQuery)updateQuery, updateQuery.getTranslationRow());
    }

    @Override
    public void postInitialize(AbstractSession session) throws DescriptorException {
        super.postInitialize(session);
        this.getReferenceDescriptor().postInitialize(session);
    }

    @Override
    public void postInsert(WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (this.isReadOnly()) {
            return;
        }
        Object objects = this.getRealCollectionAttributeValueFromObject(query.getObject(), query.getSession());
        ContainerPolicy cp = this.getContainerPolicy();
        Object iter = cp.iteratorFor(objects);
        while (cp.hasNext(iter)) {
            Object object = cp.next(iter, query.getSession());
            InsertObjectQuery insertQuery = this.getAndPrepareModifyQueryForInsert(query, object);
            query.getSession().executeQuery((DatabaseQuery)insertQuery, insertQuery.getTranslationRow());
        }
    }

    @Override
    public void postUpdate(WriteObjectQuery writeQuery) throws DatabaseException, OptimisticLockException {
        if (this.isReadOnly()) {
            return;
        }
        if (!this.isAttributeValueInstantiatedOrChanged(writeQuery.getObject())) {
            return;
        }
        Object objects = this.getRealCollectionAttributeValueFromObject(writeQuery.getObject(), writeQuery.getSession());
        Object currentObjectsInDB = this.readPrivateOwnedForObject(writeQuery);
        if (currentObjectsInDB == null) {
            currentObjectsInDB = this.getContainerPolicy().containerInstance(1);
        }
        this.compareObjectsAndWrite(currentObjectsInDB, objects, writeQuery);
    }

    @Override
    public void preDelete(DeleteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (this.isReadOnly()) {
            return;
        }
        Object objects = this.getRealCollectionAttributeValueFromObject(query.getObject(), query.getSession());
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        if (this.mustDeleteReferenceObjectsOneByOne()) {
            Object iter = containerPolicy.iteratorFor(objects);
            while (containerPolicy.hasNext(iter)) {
                Object object = containerPolicy.next(iter, query.getSession());
                DeleteObjectQuery deleteQuery = new DeleteObjectQuery();
                deleteQuery.setIsExecutionClone(true);
                this.prepareModifyQueryForDelete(query, deleteQuery, object);
                query.getSession().executeQuery((DatabaseQuery)deleteQuery, deleteQuery.getTranslationRow());
            }
            if (!query.getSession().isUnitOfWork()) {
                this.verifyDeleteForUpdate(query);
            }
        } else {
            this.deleteAll(query, objects);
        }
    }

    @Override
    public void preInsert(WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (this.isReadOnly()) {
            return;
        }
        Object objects = this.getRealCollectionAttributeValueFromObject(query.getObject(), query.getSession());
        ContainerPolicy cp = this.getContainerPolicy();
        Object iter = cp.iteratorFor(objects);
        while (cp.hasNext(iter)) {
            Object object = cp.next(iter, query.getSession());
            InsertObjectQuery insertQuery = this.getAndPrepareModifyQueryForInsert(query, object);
            this.executeEvent(0, insertQuery);
            this.executeEvent(4, insertQuery);
            this.getReferenceDescriptor(object.getClass(), query.getSession()).getQueryManager().preInsert(insertQuery);
        }
    }

    protected InsertObjectQuery getInsertObjectQuery(AbstractSession session, ClassDescriptor desc) {
        InsertObjectQuery insertQuery = desc.getQueryManager().getInsertQuery();
        if (insertQuery == null) {
            insertQuery = new InsertObjectQuery();
            desc.getQueryManager().setInsertQuery(insertQuery);
        }
        if (insertQuery.getModifyRow() == null) {
            DatabaseRecord modifyRow = new DatabaseRecord();
            for (int i = 0; i < this.getTargetForeignKeyFields().size(); ++i) {
                DatabaseField field = this.getTargetForeignKeyFields().elementAt(i);
                modifyRow.put(field, (Object)null);
            }
            desc.getObjectBuilder().buildTemplateInsertRow(session, modifyRow);
            insertQuery.setModifyRow(modifyRow);
        }
        return insertQuery;
    }

    public InsertObjectQuery getAndPrepareModifyQueryForInsert(ObjectLevelModifyQuery originalQuery, Object object) {
        AbstractSession session = originalQuery.getSession();
        ClassDescriptor objReferenceDescriptor = this.getReferenceDescriptor(object.getClass(), session);
        InsertObjectQuery insertQueryFromDescriptor = this.getInsertObjectQuery(session, objReferenceDescriptor);
        insertQueryFromDescriptor.checkPrepare(session, insertQueryFromDescriptor.getModifyRow());
        InsertObjectQuery insertQuery = (InsertObjectQuery)insertQueryFromDescriptor.clone();
        insertQuery.setObject(object);
        insertQuery.setDescriptor(objReferenceDescriptor);
        DatabaseRecord targetForeignKeyRow = new DatabaseRecord();
        Vector referenceObjectKeys = this.getReferenceObjectKeys(originalQuery);
        for (int keyIndex = 0; keyIndex < this.getTargetForeignKeyFields().size(); ++keyIndex) {
            targetForeignKeyRow.put(this.getTargetForeignKeyFields().elementAt(keyIndex), referenceObjectKeys.elementAt(keyIndex));
        }
        insertQuery.setModifyRow(targetForeignKeyRow);
        insertQuery.setTranslationRow(targetForeignKeyRow);
        insertQuery.setSession(session);
        insertQuery.setCascadePolicy(originalQuery.getCascadePolicy());
        insertQuery.dontMaintainCache();
        if (session.isUnitOfWork()) {
            Object backupAttributeValue = this.getReferenceDescriptor(object.getClass(), session).getObjectBuilder().buildNewInstance();
            insertQuery.setBackupClone(backupAttributeValue);
        }
        return insertQuery;
    }

    public void prepareModifyQueryForDelete(ObjectLevelModifyQuery originalQuery, ObjectLevelModifyQuery modifyQuery, Object object) {
        AbstractRecord aggregateRow = this.getAggregateRow(originalQuery, object);
        modifyQuery.setObject(object);
        modifyQuery.setDescriptor(this.getReferenceDescriptor(object.getClass(), originalQuery.getSession()));
        modifyQuery.setPrimaryKey(this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromRow(aggregateRow, originalQuery.getSession()));
        modifyQuery.setModifyRow(aggregateRow);
        modifyQuery.setTranslationRow(aggregateRow);
        modifyQuery.setSession(originalQuery.getSession());
        if (originalQuery.shouldCascadeOnlyDependentParts()) {
            modifyQuery.setCascadePolicy(5);
        } else {
            modifyQuery.setCascadePolicy(originalQuery.getCascadePolicy());
        }
        modifyQuery.dontMaintainCache();
    }

    public void prepareModifyQueryForUpdate(ObjectLevelModifyQuery originalQuery, ObjectLevelModifyQuery modifyQuery, Object object) {
        AbstractRecord aggregateRow = this.getAggregateRow(originalQuery, object);
        modifyQuery.setObject(object);
        modifyQuery.setDescriptor(this.getReferenceDescriptor(object.getClass(), originalQuery.getSession()));
        modifyQuery.setPrimaryKey(this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromRow(aggregateRow, originalQuery.getSession()));
        modifyQuery.setTranslationRow(aggregateRow);
        modifyQuery.setSession(originalQuery.getSession());
        modifyQuery.setCascadePolicy(originalQuery.getCascadePolicy());
        modifyQuery.dontMaintainCache();
    }

    @Override
    protected void setReferenceDescriptor(ClassDescriptor aDescriptor) {
        this.remoteReferenceDescriptor = this.referenceDescriptor = aDescriptor;
    }

    public void setSourceKeyFieldNames(Vector fieldNames) {
        NonSynchronizedVector fields = NonSynchronizedVector.newInstance(fieldNames.size());
        Enumeration fieldNamesEnum = fieldNames.elements();
        while (fieldNamesEnum.hasMoreElements()) {
            ((Vector)fields).addElement(new DatabaseField((String)fieldNamesEnum.nextElement()));
        }
        this.setSourceKeyFields(fields);
    }

    public void setSourceKeyFields(Vector<DatabaseField> sourceKeyFields) {
        this.sourceKeyFields = sourceKeyFields;
    }

    public void setTargetForeignKeyFieldNames(Vector fieldNames) {
        NonSynchronizedVector fields = NonSynchronizedVector.newInstance(fieldNames.size());
        Enumeration fieldNamesEnum = fieldNames.elements();
        while (fieldNamesEnum.hasMoreElements()) {
            ((Vector)fields).addElement(new DatabaseField((String)fieldNamesEnum.nextElement()));
        }
        this.setTargetForeignKeyFields(fields);
    }

    public void setTargetForeignKeyFields(Vector<DatabaseField> targetForeignKeyFields) {
        this.targetForeignKeyFields = targetForeignKeyFields;
    }

    protected void setTargetForeignKeyToSourceKeys(Map<DatabaseField, DatabaseField> targetForeignKeyToSourceKeys) {
        this.targetForeignKeyToSourceKeys = targetForeignKeyToSourceKeys;
    }

    @Override
    protected boolean shouldObjectModifyCascadeToParts(ObjectLevelModifyQuery query) {
        return !this.isReadOnly();
    }

    @Override
    public void simpleAddToCollectionChangeRecord(Object referenceKey, Object changeSetToAdd, ObjectChangeSet changeSet, AbstractSession session) {
        AggregateCollectionChangeRecord collectionChangeRecord = (AggregateCollectionChangeRecord)changeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (collectionChangeRecord == null) {
            Object cloneObject = ((UnitOfWorkChangeSet)changeSet.getUOWChangeSet()).getUOWCloneForObjectChangeSet(changeSet);
            Object cloneCollection = this.getRealAttributeValueFromObject(cloneObject, session);
            collectionChangeRecord = (AggregateCollectionChangeRecord)this.convertToChangeRecord(cloneCollection, changeSet, session);
            changeSet.addChange(collectionChangeRecord);
        } else {
            collectionChangeRecord.getChangedValues().add(changeSetToAdd);
        }
    }

    @Override
    public void simpleRemoveFromCollectionChangeRecord(Object referenceKey, Object changeSetToRemove, ObjectChangeSet changeSet, AbstractSession session) {
        AggregateCollectionChangeRecord collectionChangeRecord = (AggregateCollectionChangeRecord)changeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (collectionChangeRecord == null) {
            Object cloneObject = ((UnitOfWorkChangeSet)changeSet.getUOWChangeSet()).getUOWCloneForObjectChangeSet(changeSet);
            Object cloneCollection = this.getRealAttributeValueFromObject(cloneObject, session);
            collectionChangeRecord = (AggregateCollectionChangeRecord)this.convertToChangeRecord(cloneCollection, changeSet, session);
            changeSet.addChange(collectionChangeRecord);
        } else {
            collectionChangeRecord.getChangedValues().remove(changeSetToRemove);
        }
    }

    @Override
    public Object valueFromRow(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery sourceQuery, AbstractSession executionSession) throws DatabaseException {
        row = (AbstractRecord)row.clone();
        int i = 0;
        Enumeration<DatabaseField> sourceKeys = this.getSourceKeyFields().elements();
        while (sourceKeys.hasMoreElements()) {
            DatabaseField sourceKey = sourceKeys.nextElement();
            Object value = null;
            int index = row.getFields().indexOf(sourceKey);
            if (index == -1) {
                value = sourceQuery.getTranslationRow().get(sourceKey);
                row.add(sourceKey, value);
            } else {
                value = row.getValues().elementAt(index);
            }
            row.add(this.getTargetForeignKeyFields().elementAt(i), value);
            ++i;
        }
        return super.valueFromRow(row, joinManager, sourceQuery, executionSession);
    }

    @Override
    public boolean verifyDelete(Object object, AbstractSession session) throws DatabaseException {
        if (this.isReadOnly()) {
            return true;
        }
        AbstractRecord row = this.getDescriptor().getObjectBuilder().buildRowForTranslation(object, session);
        Object value = session.executeQuery((DatabaseQuery)this.getSelectionQuery(), row);
        return this.getContainerPolicy().isEmpty(value);
    }

    protected void verifyDeleteForUpdate(DeleteObjectQuery query) throws DatabaseException, OptimisticLockException {
        Object objects = this.readPrivateOwnedForObject(query);
        ContainerPolicy cp = this.getContainerPolicy();
        Object iter = cp.iteratorFor(objects);
        while (cp.hasNext(iter)) {
            query.getSession().deleteObject(cp.next(iter, query.getSession()));
        }
    }

    @Override
    public void addToCollectionChangeRecord(Object newKey, Object newValue, ObjectChangeSet objectChangeSet, UnitOfWorkImpl uow) throws DescriptorException {
        throw DescriptorException.invalidMappingOperation(this, "addToCollectionChangeRecord");
    }

    @Override
    public boolean isCandidateForPrivateOwnedRemoval() {
        return false;
    }

    @Override
    public boolean isCascadedLockingSupported() {
        return true;
    }

    @Override
    public boolean isChangeTrackingSupported(Project project) {
        return false;
    }

    @Override
    public void removeFromCollectionChangeRecord(Object newKey, Object newValue, ObjectChangeSet objectChangeSet, UnitOfWorkImpl uow) throws DescriptorException {
        throw DescriptorException.invalidMappingOperation(this, "removeFromCollectionChangeRecord");
    }

    @Override
    public void remoteInitialization(DistributedSession session) {
        super.remoteInitialization(session);
        this.getReferenceDescriptor().remoteInitialization(session);
    }
}

