/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.helper.DatabaseType;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.platform.database.oracle.plsql.OraclePLSQLType;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLStoredProcedureCall;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLargument;
import org.eclipse.persistence.queries.StoredProcedureCall;
import org.eclipse.persistence.sessions.DatabaseRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ComplexDatabaseType
implements DatabaseType,
Cloneable,
OraclePLSQLType {
    protected String typeName;
    protected String compatibleType;
    protected Class javaType;
    protected String javaTypeName;

    public boolean isRecord() {
        return false;
    }

    public boolean isCollection() {
        return false;
    }

    @Override
    public int getConversionCode() {
        return this.getSqlCode();
    }

    @Override
    public boolean isComplexDatabaseType() {
        return true;
    }

    @Override
    public boolean isJDBCType() {
        return false;
    }

    public boolean hasCompatibleType() {
        return this.compatibleType != null;
    }

    public String getCompatibleType() {
        return this.compatibleType;
    }

    public void setCompatibleType(String compatibleType) {
        this.compatibleType = compatibleType;
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public void setJavaType(Class javaType) {
        this.javaType = javaType;
        if (javaType != null) {
            this.javaTypeName = javaType.getName();
        }
    }

    public Class getJavaType() {
        return this.javaType;
    }

    public String getJavaTypeName() {
        if (this.javaType != null && this.javaTypeName == null) {
            this.javaTypeName = this.javaType.getName();
        }
        return this.javaTypeName;
    }

    public void setJavaTypeName(String javaTypeName) {
        this.javaTypeName = javaTypeName;
    }

    public ComplexDatabaseType clone() {
        try {
            ComplexDatabaseType clone = (ComplexDatabaseType)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException exception) {
            throw new InternalError(exception.getMessage());
        }
    }

    @Override
    public void buildInDeclare(StringBuilder sb, PLSQLargument inArg) {
        if (!this.hasCompatibleType()) {
            throw QueryException.compatibleTypeNotSet(this);
        }
        if (this.getTypeName() == null || this.getTypeName().equals("")) {
            throw QueryException.typeNameNotSet(this);
        }
        sb.append("  ");
        sb.append(DatabaseType.DatabaseTypeHelper.databaseTypeHelper.buildTarget(inArg));
        sb.append(" ");
        sb.append(this.getTypeName());
        sb.append(";");
        sb.append(Helper.NL);
        sb.append("  ");
        sb.append(DatabaseType.DatabaseTypeHelper.databaseTypeHelper.buildCompatible(inArg));
        sb.append(" ");
        sb.append(this.getCompatibleType());
        sb.append(" := :");
        sb.append(inArg.inIndex);
        sb.append(";");
        sb.append(Helper.NL);
    }

    @Override
    public void buildOutDeclare(StringBuilder sb, PLSQLargument outArg) {
        if (!this.hasCompatibleType()) {
            throw QueryException.compatibleTypeNotSet(this);
        }
        if (this.getTypeName() == null || this.getTypeName().equals("")) {
            throw QueryException.typeNameNotSet(this);
        }
        sb.append("  ");
        sb.append(DatabaseType.DatabaseTypeHelper.databaseTypeHelper.buildTarget(outArg));
        sb.append(" ");
        sb.append(this.getTypeName());
        sb.append(";");
        sb.append(Helper.NL);
    }

    @Override
    public void buildBeginBlock(StringBuilder sb, PLSQLargument arg, PLSQLStoredProcedureCall call) {
        String sql2PlName = call.getSQL2PlName(this);
        if (sql2PlName == null) {
            throw new NullPointerException("no SQL2Pl conversion routine for " + this.typeName);
        }
        String target = DatabaseType.DatabaseTypeHelper.databaseTypeHelper.buildTarget(arg);
        String compat = DatabaseType.DatabaseTypeHelper.databaseTypeHelper.buildCompatible(arg);
        sb.append("  ");
        sb.append(target);
        sb.append(" := ");
        sb.append(sql2PlName);
        sb.append("(");
        sb.append(compat);
        sb.append(");");
        sb.append(Helper.NL);
    }

    @Override
    public void buildOutAssignment(StringBuilder sb, PLSQLargument outArg, PLSQLStoredProcedureCall call) {
        String sql2PlName = call.getPl2SQLName(this);
        if (sql2PlName == null) {
            throw new NullPointerException("no Pl2SQL conversion routine for " + this.typeName);
        }
        String target = DatabaseType.DatabaseTypeHelper.databaseTypeHelper.buildTarget(outArg);
        sb.append("  :");
        sb.append(outArg.outIndex);
        sb.append(" := ");
        sb.append(sql2PlName);
        sb.append("(");
        sb.append(target);
        sb.append(");");
        sb.append(Helper.NL);
    }

    @Override
    public void buildOutputRow(PLSQLargument outArg, AbstractRecord outputRow, DatabaseRecord newOutputRow, Vector outputRowFields, Vector outputRowValues) {
        DatabaseType.DatabaseTypeHelper.databaseTypeHelper.buildOutputRow(outArg, outputRow, newOutputRow, outputRowFields, outputRowValues);
    }

    @Override
    public int computeInIndex(PLSQLargument inArg, int newIndex, ListIterator<PLSQLargument> i) {
        return DatabaseType.DatabaseTypeHelper.databaseTypeHelper.computeInIndex(inArg, newIndex);
    }

    @Override
    public int computeOutIndex(PLSQLargument outArg, int newIndex, ListIterator<PLSQLargument> i) {
        return DatabaseType.DatabaseTypeHelper.databaseTypeHelper.computeOutIndex(outArg, newIndex);
    }

    @Override
    public void logParameter(StringBuilder sb, Integer direction, PLSQLargument arg, AbstractRecord translationRow, DatabasePlatform platform) {
        DatabaseType.DatabaseTypeHelper.databaseTypeHelper.logParameter(sb, direction, arg, translationRow, platform);
    }

    @Override
    public void translate(PLSQLargument arg, AbstractRecord translationRow, AbstractRecord copyOfTranslationRow, Vector copyOfTranslationFields, Vector translationRowFields, Vector translationRowValues, StoredProcedureCall call) {
        DatabaseType.DatabaseTypeHelper.databaseTypeHelper.translate(arg, translationRow, copyOfTranslationRow, copyOfTranslationFields, translationRowFields, translationRowValues, call);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getTypeName() + ")";
    }
}

