/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.util.Map;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.identitymaps.IdentityMapManager;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.IsolatedClientSessionIdentityMapAccessor;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.sessions.server.ClientSession;
import org.eclipse.persistence.sessions.server.ConnectionPolicy;
import org.eclipse.persistence.sessions.server.ServerSession;

public class IsolatedClientSession
extends ClientSession {
    public IsolatedClientSession(ServerSession parent, ConnectionPolicy connectionPolicy) {
        super(parent, connectionPolicy);
    }

    public IsolatedClientSession(ServerSession parent, ConnectionPolicy connectionPolicy, Map properties) {
        super(parent, connectionPolicy, properties);
    }

    public void initializeIdentityMapAccessor() {
        this.identityMapAccessor = new IsolatedClientSessionIdentityMapAccessor(this, new IdentityMapManager(this));
    }

    protected boolean shouldExecuteLocally(DatabaseQuery query) {
        if (this.isIsolatedQuery(query)) {
            return true;
        }
        return this.isInTransaction();
    }

    protected boolean isIsolatedQuery(DatabaseQuery query) {
        query.checkDescriptor(this);
        return query.isDataModifyQuery() || query.isDataReadQuery() || query.getDescriptor() != null && query.getDescriptor().isIsolated() || query.isObjectBuildingQuery() && ((ObjectBuildingQuery)query).shouldUseExclusiveConnection();
    }

    public AbstractSession getParentIdentityMapSession(DatabaseQuery query, boolean canReturnSelf, boolean terminalOnly) {
        if (query != null && this.isIsolatedQuery(query)) {
            return this;
        }
        return this.getParent().getParentIdentityMapSession(query, canReturnSelf, terminalOnly);
    }

    public AbstractSession getExecutionSession(DatabaseQuery query) {
        if (this.shouldExecuteLocally(query)) {
            return this;
        }
        return this.getParent().getExecutionSession(query);
    }

    public Object executeCall(Call call, AbstractRecord translationRow, DatabaseQuery query) throws DatabaseException {
        if (this.isInTransaction()) {
            return super.executeCall(call, translationRow, query);
        }
        return this.getParent().executeCall(call, translationRow, query);
    }

    public boolean isIsolatedClientSession() {
        return true;
    }
}

