/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.internal.libraries.asm.ClassWriter;
import org.eclipse.persistence.internal.libraries.asm.CodeVisitor;
import org.eclipse.persistence.internal.libraries.asm.Constants;
import org.eclipse.persistence.internal.libraries.asm.Label;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ASMContentHandler
extends DefaultHandler
implements Constants {
    private List stack = new ArrayList();
    private String match = "";
    protected boolean computeMax;
    protected OutputStream os;
    protected ClassWriter cw;
    protected CodeVisitor mw;
    protected Map labels;
    private static final String BASE = "class";
    private final Rule[] RULES = new Rule[]{new ClassRule("class"), new InterfaceRule("class/interfaces/interface"), new InterfacesRule("class/interfaces"), new FieldRule("class/field"), new MethodRule("class/method"), new ExceptionRule("class/method/exceptions/exception"), new ExceptionsRule("class/method/exceptions"), new InnerClassRule("class/innerclass"), new OpcodesRule("class/method/code/"), new TableSwitchRule("class/method/code/TABLESWITCH"), new TableSwitchLabelRule("class/method/code/TABLESWITCH/label"), new LookupSwitchRule("class/method/code/LOOKUPSWITCH"), new LookupSwitchLabelRule("class/method/code/LOOKUPSWITCH/label"), new LabelRule("class/method/code/Label"), new TryCatchRule("class/method/code/TryCatch"), new LineNumberRule("class/method/code/LineNumber"), new LocalVarRule("class/method/code/LocalVar"), new MaxRule("class/method/code/Max")};
    static final Map OPCODES = new HashMap();

    static {
        OPCODES.put("NOP", new Opcode(0, 0));
        OPCODES.put("ACONST_NULL", new Opcode(1, 0));
        OPCODES.put("ICONST_M1", new Opcode(2, 0));
        OPCODES.put("ICONST_0", new Opcode(3, 0));
        OPCODES.put("ICONST_1", new Opcode(4, 0));
        OPCODES.put("ICONST_2", new Opcode(5, 0));
        OPCODES.put("ICONST_3", new Opcode(6, 0));
        OPCODES.put("ICONST_4", new Opcode(7, 0));
        OPCODES.put("ICONST_5", new Opcode(8, 0));
        OPCODES.put("LCONST_0", new Opcode(9, 0));
        OPCODES.put("LCONST_1", new Opcode(10, 0));
        OPCODES.put("FCONST_0", new Opcode(11, 0));
        OPCODES.put("FCONST_1", new Opcode(12, 0));
        OPCODES.put("FCONST_2", new Opcode(13, 0));
        OPCODES.put("DCONST_0", new Opcode(14, 0));
        OPCODES.put("DCONST_1", new Opcode(15, 0));
        OPCODES.put("BIPUSH", new Opcode(16, 1));
        OPCODES.put("SIPUSH", new Opcode(17, 1));
        OPCODES.put("LDC", new Opcode(18, 7));
        OPCODES.put("ILOAD", new Opcode(21, 2));
        OPCODES.put("LLOAD", new Opcode(22, 2));
        OPCODES.put("FLOAD", new Opcode(23, 2));
        OPCODES.put("DLOAD", new Opcode(24, 2));
        OPCODES.put("ALOAD", new Opcode(25, 2));
        OPCODES.put("IALOAD", new Opcode(46, 0));
        OPCODES.put("LALOAD", new Opcode(47, 0));
        OPCODES.put("FALOAD", new Opcode(48, 0));
        OPCODES.put("DALOAD", new Opcode(49, 0));
        OPCODES.put("AALOAD", new Opcode(50, 0));
        OPCODES.put("BALOAD", new Opcode(51, 0));
        OPCODES.put("CALOAD", new Opcode(52, 0));
        OPCODES.put("SALOAD", new Opcode(53, 0));
        OPCODES.put("ISTORE", new Opcode(54, 2));
        OPCODES.put("LSTORE", new Opcode(55, 2));
        OPCODES.put("FSTORE", new Opcode(56, 2));
        OPCODES.put("DSTORE", new Opcode(57, 2));
        OPCODES.put("ASTORE", new Opcode(58, 2));
        OPCODES.put("IASTORE", new Opcode(79, 0));
        OPCODES.put("LASTORE", new Opcode(80, 0));
        OPCODES.put("FASTORE", new Opcode(81, 0));
        OPCODES.put("DASTORE", new Opcode(82, 0));
        OPCODES.put("AASTORE", new Opcode(83, 0));
        OPCODES.put("BASTORE", new Opcode(84, 0));
        OPCODES.put("CASTORE", new Opcode(85, 0));
        OPCODES.put("SASTORE", new Opcode(86, 0));
        OPCODES.put("POP", new Opcode(87, 0));
        OPCODES.put("POP2", new Opcode(88, 0));
        OPCODES.put("DUP", new Opcode(89, 0));
        OPCODES.put("DUP_X1", new Opcode(90, 0));
        OPCODES.put("DUP_X2", new Opcode(91, 0));
        OPCODES.put("DUP2", new Opcode(92, 0));
        OPCODES.put("DUP2_X1", new Opcode(93, 0));
        OPCODES.put("DUP2_X2", new Opcode(94, 0));
        OPCODES.put("SWAP", new Opcode(95, 0));
        OPCODES.put("IADD", new Opcode(96, 0));
        OPCODES.put("LADD", new Opcode(97, 0));
        OPCODES.put("FADD", new Opcode(98, 0));
        OPCODES.put("DADD", new Opcode(99, 0));
        OPCODES.put("ISUB", new Opcode(100, 0));
        OPCODES.put("LSUB", new Opcode(101, 0));
        OPCODES.put("FSUB", new Opcode(102, 0));
        OPCODES.put("DSUB", new Opcode(103, 0));
        OPCODES.put("IMUL", new Opcode(104, 0));
        OPCODES.put("LMUL", new Opcode(105, 0));
        OPCODES.put("FMUL", new Opcode(106, 0));
        OPCODES.put("DMUL", new Opcode(107, 0));
        OPCODES.put("IDIV", new Opcode(108, 0));
        OPCODES.put("LDIV", new Opcode(109, 0));
        OPCODES.put("FDIV", new Opcode(110, 0));
        OPCODES.put("DDIV", new Opcode(111, 0));
        OPCODES.put("IREM", new Opcode(112, 0));
        OPCODES.put("LREM", new Opcode(113, 0));
        OPCODES.put("FREM", new Opcode(114, 0));
        OPCODES.put("DREM", new Opcode(115, 0));
        OPCODES.put("INEG", new Opcode(116, 0));
        OPCODES.put("LNEG", new Opcode(117, 0));
        OPCODES.put("FNEG", new Opcode(118, 0));
        OPCODES.put("DNEG", new Opcode(119, 0));
        OPCODES.put("ISHL", new Opcode(120, 0));
        OPCODES.put("LSHL", new Opcode(121, 0));
        OPCODES.put("ISHR", new Opcode(122, 0));
        OPCODES.put("LSHR", new Opcode(123, 0));
        OPCODES.put("IUSHR", new Opcode(124, 0));
        OPCODES.put("LUSHR", new Opcode(125, 0));
        OPCODES.put("IAND", new Opcode(126, 0));
        OPCODES.put("LAND", new Opcode(127, 0));
        OPCODES.put("IOR", new Opcode(128, 0));
        OPCODES.put("LOR", new Opcode(129, 0));
        OPCODES.put("IXOR", new Opcode(130, 0));
        OPCODES.put("LXOR", new Opcode(131, 0));
        OPCODES.put("IINC", new Opcode(132, 8));
        OPCODES.put("I2L", new Opcode(133, 0));
        OPCODES.put("I2F", new Opcode(134, 0));
        OPCODES.put("I2D", new Opcode(135, 0));
        OPCODES.put("L2I", new Opcode(136, 0));
        OPCODES.put("L2F", new Opcode(137, 0));
        OPCODES.put("L2D", new Opcode(138, 0));
        OPCODES.put("F2I", new Opcode(139, 0));
        OPCODES.put("F2L", new Opcode(140, 0));
        OPCODES.put("F2D", new Opcode(141, 0));
        OPCODES.put("D2I", new Opcode(142, 0));
        OPCODES.put("D2L", new Opcode(143, 0));
        OPCODES.put("D2F", new Opcode(144, 0));
        OPCODES.put("I2B", new Opcode(145, 0));
        OPCODES.put("I2C", new Opcode(146, 0));
        OPCODES.put("I2S", new Opcode(147, 0));
        OPCODES.put("LCMP", new Opcode(148, 0));
        OPCODES.put("FCMPL", new Opcode(149, 0));
        OPCODES.put("FCMPG", new Opcode(150, 0));
        OPCODES.put("DCMPL", new Opcode(151, 0));
        OPCODES.put("DCMPG", new Opcode(152, 0));
        OPCODES.put("IFEQ", new Opcode(153, 6));
        OPCODES.put("IFNE", new Opcode(154, 6));
        OPCODES.put("IFLT", new Opcode(155, 6));
        OPCODES.put("IFGE", new Opcode(156, 6));
        OPCODES.put("IFGT", new Opcode(157, 6));
        OPCODES.put("IFLE", new Opcode(158, 6));
        OPCODES.put("IF_ICMPEQ", new Opcode(159, 6));
        OPCODES.put("IF_ICMPNE", new Opcode(160, 6));
        OPCODES.put("IF_ICMPLT", new Opcode(161, 6));
        OPCODES.put("IF_ICMPGE", new Opcode(162, 6));
        OPCODES.put("IF_ICMPGT", new Opcode(163, 6));
        OPCODES.put("IF_ICMPLE", new Opcode(164, 6));
        OPCODES.put("IF_ACMPEQ", new Opcode(165, 6));
        OPCODES.put("IF_ACMPNE", new Opcode(166, 6));
        OPCODES.put("GOTO", new Opcode(167, 6));
        OPCODES.put("JSR", new Opcode(168, 6));
        OPCODES.put("RET", new Opcode(169, 2));
        OPCODES.put("IRETURN", new Opcode(172, 0));
        OPCODES.put("LRETURN", new Opcode(173, 0));
        OPCODES.put("FRETURN", new Opcode(174, 0));
        OPCODES.put("DRETURN", new Opcode(175, 0));
        OPCODES.put("ARETURN", new Opcode(176, 0));
        OPCODES.put("RETURN", new Opcode(177, 0));
        OPCODES.put("GETSTATIC", new Opcode(178, 4));
        OPCODES.put("PUTSTATIC", new Opcode(179, 4));
        OPCODES.put("GETFIELD", new Opcode(180, 4));
        OPCODES.put("PUTFIELD", new Opcode(181, 4));
        OPCODES.put("INVOKEVIRTUAL", new Opcode(182, 5));
        OPCODES.put("INVOKESPECIAL", new Opcode(183, 5));
        OPCODES.put("INVOKESTATIC", new Opcode(184, 5));
        OPCODES.put("INVOKEINTERFACE", new Opcode(185, 5));
        OPCODES.put("NEW", new Opcode(187, 3));
        OPCODES.put("NEWARRAY", new Opcode(188, 1));
        OPCODES.put("ANEWARRAY", new Opcode(189, 3));
        OPCODES.put("ARRAYLENGTH", new Opcode(190, 0));
        OPCODES.put("ATHROW", new Opcode(191, 0));
        OPCODES.put("CHECKCAST", new Opcode(192, 3));
        OPCODES.put("INSTANCEOF", new Opcode(193, 3));
        OPCODES.put("MONITORENTER", new Opcode(194, 0));
        OPCODES.put("MONITOREXIT", new Opcode(195, 0));
        OPCODES.put("MULTIANEWARRAY", new Opcode(197, 9));
        OPCODES.put("IFNULL", new Opcode(198, 6));
        OPCODES.put("IFNONNULL", new Opcode(199, 6));
    }

    public ASMContentHandler(OutputStream os, boolean computeMax) {
        this.os = os;
        this.computeMax = computeMax;
    }

    public byte[] toByteArray() {
        return this.cw == null ? null : this.cw.toByteArray();
    }

    public final void startElement(String ns, String localName, String qName, Attributes list) throws SAXException {
        String name = localName;
        if (name == null || name.length() < 1) {
            name = qName;
        }
        StringBuffer sb = new StringBuffer(this.match);
        if (this.match.length() > 0) {
            sb.append('/');
        }
        sb.append(name);
        this.match = sb.toString();
        int i = 0;
        while (i < this.RULES.length) {
            if (this.RULES[i].match(this.match, name)) {
                this.RULES[i].begin(name, list);
            }
            ++i;
        }
    }

    public final void endElement(String ns, String localName, String qName) throws SAXException {
        String name = localName;
        if (name == null || name.length() < 1) {
            name = qName;
        }
        int i = 0;
        while (i < this.RULES.length) {
            if (this.RULES[i].match(this.match, name)) {
                this.RULES[i].end(name);
            }
            ++i;
        }
        int slash = this.match.lastIndexOf(47);
        this.match = slash >= 0 ? this.match.substring(0, slash) : "";
    }

    public final void endDocument() throws SAXException {
        try {
            this.os.write(this.cw.toByteArray());
        }
        catch (IOException ex) {
            throw new SAXException(ex.toString(), ex);
        }
    }

    final Object peek() {
        return this.stack.size() == 0 ? null : this.stack.get(this.stack.size() - 1);
    }

    final Object peek(int n) {
        return this.stack.size() < n + 1 ? null : this.stack.get(n);
    }

    final Object pop() {
        return this.stack.size() == 0 ? null : this.stack.remove(this.stack.size() - 1);
    }

    final void push(Object object) {
        this.stack.add(object);
    }

    private final class ClassRule
    extends Rule {
        public ClassRule(String path) {
            super(path);
        }

        public final void begin(String name, Attributes attrs) {
            int major = Integer.parseInt(attrs.getValue("major"));
            int minor = Integer.parseInt(attrs.getValue("minor"));
            ASMContentHandler.this.cw = new ClassWriter(ASMContentHandler.this.computeMax);
            HashMap<String, Object> vals = new HashMap<String, Object>();
            vals.put("version", new Integer(minor << 16 | major));
            vals.put("access", attrs.getValue("access"));
            vals.put("name", attrs.getValue("name"));
            vals.put("parent", attrs.getValue("parent"));
            vals.put("source", attrs.getValue("source"));
            vals.put("interfaces", new ArrayList());
            ASMContentHandler.this.push(vals);
        }
    }

    private final class ExceptionRule
    extends Rule {
        public ExceptionRule(String path) {
            super(path);
        }

        public final void begin(String name, Attributes attrs) {
            ((List)((Map)ASMContentHandler.this.peek()).get("exceptions")).add(attrs.getValue("name"));
        }
    }

    private final class ExceptionsRule
    extends Rule {
        public ExceptionsRule(String path) {
            super(path);
        }

        public final void end(String element) {
            Map vals = (Map)ASMContentHandler.this.pop();
            int access = this.getAccess((String)vals.get("access"));
            String name = (String)vals.get("name");
            String desc = (String)vals.get("desc");
            String[] exceptions = ((List)vals.get("exceptions")).toArray(new String[0]);
            ASMContentHandler.this.mw = ASMContentHandler.this.cw.visitMethod(access, name, desc, exceptions, null);
        }
    }

    private final class FieldRule
    extends Rule {
        public FieldRule(String path) {
            super(path);
        }

        public final void begin(String element, Attributes attrs) {
            int access = this.getAccess(attrs.getValue("access"));
            String name = attrs.getValue("name");
            String desc = attrs.getValue("desc");
            Object value = this.getValue(desc, attrs.getValue("value"));
            ASMContentHandler.this.cw.visitField(access, name, desc, value, null);
        }
    }

    private final class InnerClassRule
    extends Rule {
        public InnerClassRule(String path) {
            super(path);
        }

        public final void begin(String element, Attributes attrs) {
            int access = this.getAccess(attrs.getValue("access"));
            String name = attrs.getValue("name");
            String outerName = attrs.getValue("outerName");
            String innerName = attrs.getValue("innerName");
            ASMContentHandler.this.cw.visitInnerClass(name, outerName, innerName, access);
        }

        public final void end(String name) {
            ASMContentHandler.this.mw = null;
            ASMContentHandler.this.labels = null;
        }
    }

    private final class InterfaceRule
    extends Rule {
        public InterfaceRule(String path) {
            super(path);
        }

        public final void begin(String name, Attributes attrs) {
            ((List)((Map)ASMContentHandler.this.peek()).get("interfaces")).add(attrs.getValue("name"));
        }
    }

    private final class InterfacesRule
    extends Rule {
        public InterfacesRule(String path) {
            super(path);
        }

        public final void end(String element) {
            Map vals = (Map)ASMContentHandler.this.pop();
            int version = (Integer)vals.get("version");
            int access = this.getAccess((String)vals.get("access"));
            String name = (String)vals.get("name");
            String parent = (String)vals.get("parent");
            String source = (String)vals.get("source");
            String[] interfaces = ((List)vals.get("interfaces")).toArray(new String[0]);
            ASMContentHandler.this.cw.visit(version, access, name, parent, interfaces, source);
        }
    }

    private final class LabelRule
    extends Rule {
        public LabelRule(String path) {
            super(path);
        }

        public final void begin(String name, Attributes attrs) {
            this.getCodeVisitor().visitLabel(this.getLabel(attrs.getValue("name")));
        }
    }

    private final class LineNumberRule
    extends Rule {
        public LineNumberRule(String path) {
            super(path);
        }

        public final void begin(String name, Attributes attrs) {
            int line = Integer.parseInt(attrs.getValue("line"));
            Label start = this.getLabel(attrs.getValue("start"));
            this.getCodeVisitor().visitLineNumber(line, start);
        }
    }

    private final class LocalVarRule
    extends Rule {
        public LocalVarRule(String path) {
            super(path);
        }

        public final void begin(String element, Attributes attrs) {
            String name = attrs.getValue("name");
            String desc = attrs.getValue("desc");
            Label start = this.getLabel(attrs.getValue("start"));
            Label end = this.getLabel(attrs.getValue("end"));
            int var = Integer.parseInt(attrs.getValue("var"));
            this.getCodeVisitor().visitLocalVariable(name, desc, start, end, var);
        }
    }

    private final class LookupSwitchLabelRule
    extends Rule {
        public LookupSwitchLabelRule(String path) {
            super(path);
        }

        public final void begin(String name, Attributes attrs) {
            Map vals = (Map)ASMContentHandler.this.peek();
            ((List)vals.get("labels")).add(this.getLabel(attrs.getValue("name")));
            ((List)vals.get("keys")).add(attrs.getValue("key"));
        }
    }

    private final class LookupSwitchRule
    extends Rule {
        public LookupSwitchRule(String path) {
            super(path);
        }

        public final void begin(String name, Attributes attrs) {
            HashMap<String, Object> vals = new HashMap<String, Object>();
            vals.put("dflt", attrs.getValue("dflt"));
            vals.put("labels", new ArrayList());
            vals.put("keys", new ArrayList());
            ASMContentHandler.this.push(vals);
        }

        public final void end(String name) {
            Map vals = (Map)ASMContentHandler.this.pop();
            Label dflt = this.getLabel(vals.get("dflt"));
            List keyList = (List)vals.get("keys");
            Label[] lbls = ((List)vals.get("labels")).toArray(new Label[0]);
            int[] keys = new int[keyList.size()];
            int i = 0;
            while (i < keys.length) {
                keys[i] = Integer.parseInt((String)keyList.get(i));
                ++i;
            }
            this.getCodeVisitor().visitLookupSwitchInsn(dflt, keys, lbls);
        }
    }

    private final class MaxRule
    extends Rule {
        public MaxRule(String path) {
            super(path);
        }

        public final void begin(String element, Attributes attrs) {
            int maxStack = Integer.parseInt(attrs.getValue("maxStack"));
            int maxLocals = Integer.parseInt(attrs.getValue("maxLocals"));
            this.getCodeVisitor().visitMaxs(maxStack, maxLocals);
        }
    }

    private final class MethodRule
    extends Rule {
        public MethodRule(String path) {
            super(path);
        }

        public final void begin(String name, Attributes attrs) {
            ASMContentHandler.this.labels = new HashMap();
            HashMap<String, Object> vals = new HashMap<String, Object>();
            vals.put("access", attrs.getValue("access"));
            vals.put("name", attrs.getValue("name"));
            vals.put("desc", attrs.getValue("desc"));
            vals.put("exceptions", new ArrayList());
            ASMContentHandler.this.push(vals);
        }

        public final void end(String name) {
            ASMContentHandler.this.mw = null;
            ASMContentHandler.this.labels = null;
        }
    }

    private static final class Opcode {
        public int opcode;
        public int type;

        public Opcode(int opcode, int type) {
            this.opcode = opcode;
            this.type = type;
        }
    }

    private static interface OpcodeGroup {
        public static final int INSN = 0;
        public static final int INSN_INT = 1;
        public static final int INSN_VAR = 2;
        public static final int INSN_TYPE = 3;
        public static final int INSN_FIELD = 4;
        public static final int INSN_METHOD = 5;
        public static final int INSN_JUMP = 6;
        public static final int INSN_LDC = 7;
        public static final int INSN_IINC = 8;
        public static final int INSN_MULTIANEWARRAY = 9;
    }

    private final class OpcodesRule
    extends Rule {
        public OpcodesRule(String path) {
            super(path);
        }

        public boolean match(String match, String element) {
            return match.startsWith(this.path) && OPCODES.containsKey(element);
        }

        public final void begin(String element, Attributes attrs) {
            Opcode o = (Opcode)OPCODES.get(element);
            if (o == null) {
                return;
            }
            switch (o.type) {
                case 0: {
                    this.getCodeVisitor().visitInsn(o.opcode);
                    break;
                }
                case 4: {
                    this.getCodeVisitor().visitFieldInsn(o.opcode, attrs.getValue("owner"), attrs.getValue("name"), attrs.getValue("desc"));
                    break;
                }
                case 1: {
                    this.getCodeVisitor().visitIntInsn(o.opcode, Integer.parseInt(attrs.getValue("value")));
                    break;
                }
                case 6: {
                    this.getCodeVisitor().visitJumpInsn(o.opcode, this.getLabel(attrs.getValue("label")));
                    break;
                }
                case 5: {
                    this.getCodeVisitor().visitMethodInsn(o.opcode, attrs.getValue("owner"), attrs.getValue("name"), attrs.getValue("desc"));
                    break;
                }
                case 3: {
                    this.getCodeVisitor().visitTypeInsn(o.opcode, attrs.getValue("desc"));
                    break;
                }
                case 2: {
                    this.getCodeVisitor().visitVarInsn(o.opcode, Integer.parseInt(attrs.getValue("var")));
                    break;
                }
                case 8: {
                    this.getCodeVisitor().visitIincInsn(Integer.parseInt(attrs.getValue("var")), Integer.parseInt(attrs.getValue("inc")));
                    break;
                }
                case 7: {
                    this.getCodeVisitor().visitLdcInsn(this.getValue(attrs.getValue("desc"), attrs.getValue("cst")));
                    break;
                }
                case 9: {
                    this.getCodeVisitor().visitMultiANewArrayInsn(attrs.getValue("desc"), Integer.parseInt(attrs.getValue("dims")));
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid element: " + element + " at " + ASMContentHandler.this.match);
                }
            }
        }
    }

    private abstract class Rule {
        protected String path;

        public Rule(String path) {
            this.path = path;
        }

        public final String getPath() {
            return this.path;
        }

        public void begin(String name, Attributes attrs) {
        }

        public void end(String name) {
        }

        public boolean match(String match, String element) {
            return this.path.equals(match);
        }

        protected final Object getValue(String desc, String val) {
            Object value = null;
            if (val != null) {
                if (desc.equals("Ljava/lang/String;")) {
                    value = this.decode(val);
                } else if (desc.equals("Ljava/lang/Integer;") || desc.equals("Z") || desc.equals("B") || desc.equals("C") || desc.equals("I") || desc.equals("S")) {
                    value = new Integer(val);
                } else if (desc.equals("Ljava/lang/Long;") || desc.equals("J")) {
                    value = new Long(val);
                } else if (desc.equals("Ljava/lang/Float;") || desc.equals("F")) {
                    value = new Float(val);
                } else if (desc.equals("Ljava/lang/Double;") || desc.equals("D")) {
                    value = new Double(val);
                } else {
                    throw new RuntimeException("Invalid value:" + val + " desc:" + desc + " ctx:" + this);
                }
            }
            return value;
        }

        private final String decode(String val) {
            StringBuffer sb = new StringBuffer(val.length());
            try {
                int n = 0;
                while (n < val.length()) {
                    char c = val.charAt(n);
                    if (c == '\\') {
                        if ((c = val.charAt(++n)) == '\\') {
                            sb.append('\\');
                        } else {
                            sb.append((char)Integer.parseInt(val.substring(++n, n + 4), 16));
                            n += 3;
                        }
                    } else {
                        sb.append(c);
                    }
                    ++n;
                }
            }
            catch (RuntimeException ex) {
                System.err.println(String.valueOf(val) + "\n" + ex.toString());
                ex.printStackTrace();
                throw ex;
            }
            return sb.toString();
        }

        protected final Label getLabel(Object label) {
            Label lbl = (Label)ASMContentHandler.this.labels.get(label);
            if (lbl == null) {
                lbl = new Label();
                ASMContentHandler.this.labels.put(label, lbl);
            }
            return lbl;
        }

        public String toString() {
            return this.path;
        }

        protected final CodeVisitor getCodeVisitor() {
            if (ASMContentHandler.this.mw == null) {
                Map vals = (Map)ASMContentHandler.this.pop();
                int access = Integer.parseInt((String)vals.get("access"), 16);
                String name = (String)vals.get("name");
                String desc = (String)vals.get("desc");
                ASMContentHandler.this.mw = ASMContentHandler.this.cw.visitMethod(access, name, desc, null, null);
            }
            return ASMContentHandler.this.mw;
        }

        protected final int getAccess(String s) {
            int access = 0;
            if (s.indexOf("public") != -1) {
                access |= 1;
            }
            if (s.indexOf("private") != -1) {
                access |= 2;
            }
            if (s.indexOf("protected") != -1) {
                access |= 4;
            }
            if (s.indexOf("static") != -1) {
                access |= 8;
            }
            if (s.indexOf("final") != -1) {
                access |= 0x10;
            }
            if (s.indexOf("super") != -1) {
                access |= 0x20;
            }
            if (s.indexOf("synchronized") != -1) {
                access |= 0x20;
            }
            if (s.indexOf("volatile") != -1) {
                access |= 0x40;
            }
            if (s.indexOf("bridge") != -1) {
                access |= 0x40;
            }
            if (s.indexOf("varargs") != -1) {
                access |= 0x80;
            }
            if (s.indexOf("transient") != -1) {
                access |= 0x80;
            }
            if (s.indexOf("native") != -1) {
                access |= 0x100;
            }
            if (s.indexOf("interface") != -1) {
                access |= 0x200;
            }
            if (s.indexOf("abstract") != -1) {
                access |= 0x400;
            }
            if (s.indexOf("strict") != -1) {
                access |= 0x800;
            }
            if (s.indexOf("synthetic") != -1) {
                access |= 0x1000;
            }
            if (s.indexOf("annotation") != -1) {
                access |= 0x2000;
            }
            if (s.indexOf("enum") != -1) {
                access |= 0x4000;
            }
            if (s.indexOf("deprecated") != -1) {
                access |= 0x20000;
            }
            return access;
        }
    }

    private final class TableSwitchLabelRule
    extends Rule {
        public TableSwitchLabelRule(String path) {
            super(path);
        }

        public final void begin(String name, Attributes attrs) {
            ((List)((Map)ASMContentHandler.this.peek()).get("labels")).add(this.getLabel(attrs.getValue("name")));
        }
    }

    private class TableSwitchRule
    extends Rule {
        public TableSwitchRule(String path) {
            super(path);
        }

        public final void begin(String name, Attributes attrs) {
            HashMap<String, Object> vals = new HashMap<String, Object>();
            vals.put("min", attrs.getValue("min"));
            vals.put("max", attrs.getValue("max"));
            vals.put("dflt", attrs.getValue("dflt"));
            vals.put("labels", new ArrayList());
            ASMContentHandler.this.push(vals);
        }

        public final void end(String name) {
            Map vals = (Map)ASMContentHandler.this.pop();
            int min = Integer.parseInt((String)vals.get("min"));
            int max = Integer.parseInt((String)vals.get("max"));
            Label dflt = this.getLabel(vals.get("dflt"));
            Label[] lbls = ((List)vals.get("labels")).toArray(new Label[0]);
            this.getCodeVisitor().visitTableSwitchInsn(min, max, dflt, lbls);
        }
    }

    private final class TryCatchRule
    extends Rule {
        public TryCatchRule(String path) {
            super(path);
        }

        public final void begin(String name, Attributes attrs) {
            Label start = this.getLabel(attrs.getValue("start"));
            Label end = this.getLabel(attrs.getValue("end"));
            Label handler = this.getLabel(attrs.getValue("handler"));
            String type = attrs.getValue("type");
            this.getCodeVisitor().visitTryCatchBlock(start, end, handler, type);
        }
    }
}

