/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.javamodel;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.jaxb.javamodel.JavaAnnotation;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaField;
import org.eclipse.persistence.jaxb.javamodel.JavaHasAnnotations;
import org.eclipse.persistence.jaxb.javamodel.JavaMethod;
import org.eclipse.persistence.jaxb.javamodel.JavaModel;
import org.eclipse.persistence.oxm.XMLConstants;

public class Helper {
    protected ClassLoader loader;
    protected JavaModel jModel;
    private HashMap xmlToJavaTypeMap;
    public static final String APBYTE = "byte[]";
    public static final String BIGDECIMAL = "java.math.BigDecimal";
    public static final String BIGINTEGER = "java.math.BigInteger";
    public static final String PBOOLEAN = "boolean";
    public static final String PBYTE = "byte";
    public static final String CALENDAR = "java.util.Calendar";
    public static final String PDOUBLE = "double";
    public static final String PFLOAT = "float";
    public static final String PINT = "int";
    public static final String PLONG = "long";
    public static final String PSHORT = "short";
    public static final String QNAME_CLASS = "javax.xml.namespace.QName";
    public static final String STRING = "java.lang.String";
    public static final String ABYTE = "java.lang.Byte[]";
    public static final String BOOLEAN = "java.lang.Boolean";
    public static final String BYTE = "java.lang.Byte";
    public static final String GREGORIAN_CALENDAR = "java.util.GregorianCalendar";
    public static final String DOUBLE = "java.lang.Double";
    public static final String FLOAT = "java.lang.Float";
    public static final String INTEGER = "java.lang.Integer";
    public static final String UUID = "java.util.UUID";
    public static final String LONG = "java.lang.Long";
    public static final String SHORT = "java.lang.Short";
    public static final String UTIL_DATE = "java.util.Date";
    public static final String SQL_DATE = "java.sql.Date";
    public static final String SQL_TIME = "java.sql.Time";
    public static final String SQL_TIMESTAMP = "java.sql.Timestamp";
    public static final String DURATION = "javax.xml.datatype.Duration";
    public static final String XMLGREGORIANCALENDAR = "javax.xml.datatype.XMLGregorianCalendar";

    public Helper(JavaModel model) {
        this.buildXMLToJavaTypeMap();
        this.setJavaModel(model);
        this.setClassLoader(model.getClassLoader());
    }

    private HashMap buildXMLToJavaTypeMap() {
        HashMap<String, QName> javaTypes = new HashMap<String, QName>();
        javaTypes.put(APBYTE, XMLConstants.BASE_64_BINARY_QNAME);
        javaTypes.put(BIGDECIMAL, XMLConstants.DECIMAL_QNAME);
        javaTypes.put(BIGINTEGER, XMLConstants.INTEGER_QNAME);
        javaTypes.put(PBOOLEAN, XMLConstants.BOOLEAN_QNAME);
        javaTypes.put(PBYTE, XMLConstants.BYTE_QNAME);
        javaTypes.put(CALENDAR, XMLConstants.DATE_TIME_QNAME);
        javaTypes.put(PDOUBLE, XMLConstants.DOUBLE_QNAME);
        javaTypes.put(PFLOAT, XMLConstants.FLOAT_QNAME);
        javaTypes.put(PINT, XMLConstants.INT_QNAME);
        javaTypes.put(PLONG, XMLConstants.LONG_QNAME);
        javaTypes.put(PSHORT, XMLConstants.SHORT_QNAME);
        javaTypes.put(QNAME_CLASS, XMLConstants.QNAME_QNAME);
        javaTypes.put(STRING, XMLConstants.STRING_QNAME);
        javaTypes.put(ABYTE, XMLConstants.BASE_64_BINARY_QNAME);
        javaTypes.put(BOOLEAN, XMLConstants.BOOLEAN_QNAME);
        javaTypes.put(BYTE, XMLConstants.BYTE_QNAME);
        javaTypes.put(GREGORIAN_CALENDAR, XMLConstants.DATE_TIME_QNAME);
        javaTypes.put(DOUBLE, XMLConstants.DOUBLE_QNAME);
        javaTypes.put(FLOAT, XMLConstants.FLOAT_QNAME);
        javaTypes.put(INTEGER, XMLConstants.INT_QNAME);
        javaTypes.put(LONG, XMLConstants.LONG_QNAME);
        javaTypes.put(SHORT, XMLConstants.SHORT_QNAME);
        javaTypes.put(UTIL_DATE, XMLConstants.DATE_TIME_QNAME);
        javaTypes.put(SQL_DATE, XMLConstants.DATE_QNAME);
        javaTypes.put(SQL_TIME, XMLConstants.TIME_QNAME);
        javaTypes.put(SQL_TIMESTAMP, XMLConstants.DATE_TIME_QNAME);
        javaTypes.put(XMLGREGORIANCALENDAR, XMLConstants.ANY_SIMPLE_TYPE_QNAME);
        javaTypes.put(DURATION, XMLConstants.DURATION_QNAME);
        javaTypes.put(UUID, XMLConstants.STRING_QNAME);
        return javaTypes;
    }

    public JavaClass getGenericReturnType(JavaMethod meth) {
        JavaClass result = meth.getReturnType();
        JavaClass jClass = null;
        if (result == null) {
            return null;
        }
        if (result.hasActualTypeArguments()) {
            ArrayList typeArgs = (ArrayList)result.getActualTypeArguments();
            jClass = (JavaClass)typeArgs.get(0);
        }
        return jClass;
    }

    public JavaClass getJavaClass(Class javaClass) {
        return this.jModel.getClass(javaClass);
    }

    public JavaClass getJavaClass(String javaClassName) {
        return this.jModel.getClass(javaClassName);
    }

    public HashMap getXMLToJavaTypeMap() {
        if (this.xmlToJavaTypeMap == null) {
            this.xmlToJavaTypeMap = this.buildXMLToJavaTypeMap();
        }
        return this.xmlToJavaTypeMap;
    }

    public Annotation getAnnotation(JavaHasAnnotations element, Class annotationClass) {
        JavaAnnotation janno = element.getAnnotation(this.jModel.getClass(annotationClass));
        if (janno == null) {
            return null;
        }
        return this.jModel.getAnnotation(janno, annotationClass);
    }

    public JavaClass getType(JavaField field) {
        JavaClass type = field.getResolvedType();
        try {
            return this.jModel.getClass(type.getRawName());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean isAnnotationPresent(JavaHasAnnotations element, Class annotationClass) {
        if (element == null || annotationClass == null) {
            return false;
        }
        return element.getAnnotation(this.jModel.getClass(annotationClass)) != null;
    }

    public boolean isBuiltInJavaType(JavaClass jClass) {
        return this.getXMLToJavaTypeMap().containsKey(jClass.getRawName()) || jClass.getRawName().startsWith("java.") || jClass.getRawName().startsWith("javax.");
    }

    public void setClassLoader(ClassLoader loader) {
        this.loader = loader;
    }

    public void setJavaModel(JavaModel model) {
        this.jModel = model;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public JavaClass getNextMappedSuperClass(JavaClass jClass) {
        JavaClass superClass = jClass.getSuperclass();
        if (superClass == null || this.isBuiltInJavaType(jClass) || superClass.getRawName().equals("java.lang.Object")) {
            return null;
        }
        if (this.isAnnotationPresent(superClass, XmlTransient.class)) {
            return this.getNextMappedSuperClass(superClass);
        }
        return superClass;
    }

    public Class getClassForJavaClass(JavaClass javaClass) {
        String javaClassName = javaClass.getRawName();
        if (javaClass.isPrimitive() || javaClass.isArray() && javaClass.getComponentType().isPrimitive()) {
            if (ClassConstants.APBYTE.getName().equals(javaClassName)) {
                return Byte[].class;
            }
            if (ClassConstants.PBYTE.getName().equals(javaClassName)) {
                return Byte.class;
            }
            if (ClassConstants.PBOOLEAN.getName().equals(javaClassName)) {
                return Boolean.class;
            }
            if (ClassConstants.PSHORT.getName().equals(javaClassName)) {
                return Short.class;
            }
            if (ClassConstants.PFLOAT.getName().equals(javaClassName)) {
                return Float.class;
            }
            if (ClassConstants.PCHAR.getName().equals(javaClassName)) {
                return Character.class;
            }
            if (ClassConstants.PDOUBLE.getName().equals(javaClassName)) {
                return Double.class;
            }
            if (ClassConstants.PINT.getName().equals(javaClassName)) {
                return Integer.class;
            }
            if (ClassConstants.PLONG.getName().equals(javaClassName)) {
                return Long.class;
            }
            return null;
        }
        return org.eclipse.persistence.internal.helper.Helper.getClassFromClasseName((String)javaClass.getQualifiedName(), (ClassLoader)this.loader);
    }
}

