/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.mappings;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.descriptors.InstanceVariableAttributeAccessor;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.oxm.XMLChoiceFieldToClassAssociation;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.foundation.AbstractCompositeObjectMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.mappings.XMLCompositeDirectCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.mappings.converters.XMLConverter;
import org.eclipse.persistence.oxm.mappings.converters.XMLRootConverter;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.sessions.remote.RemoteSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLChoiceObjectMapping
extends DatabaseMapping
implements XMLMapping {
    private Map<XMLField, Class> fieldToClassMappings = new HashMap<XMLField, Class>();
    private Map<Class, XMLField> classToFieldMappings;
    private Map<XMLField, String> fieldToClassNameMappings = new HashMap<XMLField, String>();
    private Map<XMLField, XMLMapping> choiceElementMappings;
    private Map<XMLField, Converter> fieldsToConverters;
    private Converter converter;
    private boolean isWriteOnly;
    private static final AttributeAccessor temporaryAccessor = new InstanceVariableAttributeAccessor();

    public XMLChoiceObjectMapping() {
        this.classToFieldMappings = new HashMap<Class, XMLField>();
        this.choiceElementMappings = new HashMap<XMLField, XMLMapping>();
        this.fieldsToConverters = new HashMap<XMLField, Converter>();
    }

    public Converter getConverter() {
        return this.converter;
    }

    public void setConverter(Converter converter) {
        this.converter = converter;
    }

    @Override
    public void buildBackupClone(Object clone, Object backup, UnitOfWorkImpl unitOfWork) {
        throw DescriptorException.invalidMappingOperation(this, "buildBackupClone");
    }

    @Override
    public void buildClone(Object original, Object clone, UnitOfWorkImpl unitOfWork) {
        throw DescriptorException.invalidMappingOperation(this, "buildClone");
    }

    @Override
    public void buildCloneFromRow(AbstractRecord databaseRow, JoinedAttributeManager joinManager, Object clone, ObjectBuildingQuery sourceQuery, UnitOfWorkImpl unitOfWork, AbstractSession executionSession) {
        throw DescriptorException.invalidMappingOperation(this, "buildCloneFromRow");
    }

    @Override
    public void cascadePerformRemoveIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
    }

    @Override
    public void cascadeRegisterNewIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
    }

    @Override
    public ChangeRecord compareForChange(Object clone, Object backup, ObjectChangeSet owner, AbstractSession session) {
        throw DescriptorException.invalidMappingOperation(this, "compareForChange");
    }

    @Override
    public boolean compareObjects(Object firstObject, Object secondObject, AbstractSession session) {
        throw DescriptorException.invalidMappingOperation(this, "compareObjects");
    }

    @Override
    public void fixObjectReferences(Object object, Map objectDescriptors, Map processedObjects, ObjectLevelReadQuery query, RemoteSession session) {
        throw DescriptorException.invalidMappingOperation(this, "fixObjectReferences");
    }

    public Object getFieldValue(Object object, AbstractSession session, XMLRecord record) {
        Object attributeValue = super.getAttributeValueFromObject(object);
        if (null != this.converter) {
            attributeValue = this.converter instanceof XMLConverter ? ((XMLConverter)this.getConverter()).convertObjectValueToDataValue(attributeValue, session, record.getMarshaller()) : this.getConverter().convertObjectValueToDataValue(attributeValue, session);
        }
        return attributeValue;
    }

    @Override
    public void iterate(DescriptorIterator iterator) {
        throw DescriptorException.invalidMappingOperation(this, "iterate");
    }

    @Override
    public void mergeChangesIntoObject(Object target, ChangeRecord changeRecord, Object source, MergeManager mergeManager) {
        throw DescriptorException.invalidMappingOperation(this, "mergeChangesIntoObject");
    }

    @Override
    public void mergeIntoObject(Object target, boolean isTargetUninitialized, Object source, MergeManager mergeManager) {
        throw DescriptorException.invalidMappingOperation(this, "mergeIntoObject");
    }

    @Override
    public Object valueFromRow(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery sourceQuery, AbstractSession executionSession) throws DatabaseException {
        for (XMLMapping nextMapping : this.choiceElementMappings.values()) {
            Object value = ((DatabaseMapping)((Object)nextMapping)).valueFromRow(row, joinManager, sourceQuery, executionSession);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @Override
    public void writeFromObjectIntoRow(Object object, AbstractRecord row, AbstractSession session, DatabaseMapping.WriteType writeType) throws DescriptorException {
        XMLField valueField;
        XMLMapping mapping;
        Object value = this.getAttributeValueFromObject(object);
        Class<?> valueClass = value.getClass();
        if (valueClass == XMLRoot.class) {
            XMLRoot root = (XMLRoot)value;
            for (DatabaseField next : this.fields) {
                XMLField xmlField = (XMLField)next;
                for (XPathFragment fragment = xmlField.getXPathFragment(); fragment != null && !fragment.nameIsText(); fragment = fragment.getNextFragment()) {
                    if (fragment.getNextFragment() != null && !fragment.getHasText() || !fragment.getLocalName().equals(root.getLocalName())) continue;
                    String fragUri = fragment.getNamespaceURI();
                    String namespaceUri = root.getNamespaceURI();
                    if ((namespaceUri != null || fragUri != null) && (namespaceUri == null || fragUri == null || !namespaceUri.equals(fragUri))) continue;
                    XMLMapping mapping2 = this.choiceElementMappings.get(xmlField);
                    mapping2.writeSingleValue(value, object, (XMLRecord)row, session);
                    return;
                }
            }
            valueClass = root.getObject().getClass();
        }
        if ((mapping = this.choiceElementMappings.get(valueField = this.classToFieldMappings.get(valueClass))) != null) {
            mapping.writeSingleValue(value, object, (XMLRecord)row, session);
        }
    }

    @Override
    public void writeSingleValue(Object value, Object parent, XMLRecord row, AbstractSession session) {
    }

    @Override
    public boolean isXMLMapping() {
        return true;
    }

    @Override
    public Vector<DatabaseField> getFields() {
        return this.collectFields();
    }

    @Override
    protected Vector<DatabaseField> collectFields() {
        Vector<DatabaseField> fields = new Vector<DatabaseField>(this.getFieldToClassMappings().keySet());
        return fields;
    }

    public void addChoiceElement(String xpath, Class elementType) {
        XMLField field = new XMLField(xpath);
        this.addChoiceElement(field, elementType);
    }

    public void addChoiceElement(String xpath, String elementTypeName, boolean xmlRoot) {
        XMLField field = new XMLField(xpath);
        this.fieldToClassNameMappings.put(field, elementTypeName);
        if (xmlRoot) {
            this.fieldsToConverters.put(field, new XMLRootConverter(field));
        }
        this.addChoiceElementMapping(field, elementTypeName);
    }

    public void addChoiceElement(String xpath, String elementTypeName) {
        this.addChoiceElement(xpath, elementTypeName, false);
    }

    public void addChoiceElement(XMLField xmlField, Class elementType) {
        this.getFieldToClassMappings().put(xmlField, elementType);
        this.fieldToClassNameMappings.put(xmlField, elementType.getName());
        if (this.classToFieldMappings.get(elementType) == null) {
            this.classToFieldMappings.put(elementType, xmlField);
        }
        this.addChoiceElementMapping(xmlField, elementType);
    }

    public void addChoiceElement(XMLField field, String elementTypeName) {
        this.fieldToClassNameMappings.put(field, elementTypeName);
        this.addChoiceElementMapping(field, elementTypeName);
    }

    public Map<XMLField, Class> getFieldToClassMappings() {
        return this.fieldToClassMappings;
    }

    @Override
    public void initialize(AbstractSession session) throws DescriptorException {
        super.initialize(session);
        if (this.fieldToClassMappings.size() == 0) {
            this.convertClassNamesToClasses(((XMLConversionManager)session.getDatasourcePlatform().getConversionManager()).getLoader());
        }
        for (DatabaseMapping databaseMapping : this.getChoiceElementMappings().values()) {
            Converter converter = null;
            if (this.fieldsToConverters != null) {
                converter = this.fieldsToConverters.get(databaseMapping.getField());
            }
            if (databaseMapping.isAbstractDirectMapping()) {
                ((XMLDirectMapping)databaseMapping).setIsWriteOnly(this.isWriteOnly());
                if (converter != null) {
                    ((AbstractDirectMapping)databaseMapping).setConverter(converter);
                }
                XMLConversionManager xmlConversionManager = (XMLConversionManager)session.getDatasourcePlatform().getConversionManager();
                QName schemaType = (QName)xmlConversionManager.getDefaultJavaTypes().get(databaseMapping.getAttributeClassification());
                if (schemaType != null && ((XMLField)databaseMapping.getField()).getSchemaType() == null) {
                    ((XMLField)databaseMapping.getField()).setSchemaType(schemaType);
                }
            } else {
                ((XMLCompositeObjectMapping)databaseMapping).setIsWriteOnly(this.isWriteOnly());
                if (converter != null) {
                    ((AbstractCompositeObjectMapping)databaseMapping).setConverter(converter);
                }
            }
            databaseMapping.initialize(session);
        }
    }

    public Map<Class, XMLField> getClassToFieldMappings() {
        return this.classToFieldMappings;
    }

    public Map<XMLField, XMLMapping> getChoiceElementMappings() {
        return this.choiceElementMappings;
    }

    @Override
    public void convertClassNamesToClasses(ClassLoader classLoader) {
        for (Map.Entry<XMLField, String> entry : this.fieldToClassNameMappings.entrySet()) {
            Class elementType;
            block6: {
                String className = entry.getValue();
                elementType = null;
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            elementType = (Class)AccessController.doPrivileged(new PrivilegedClassForName(className, true, classLoader));
                            break block6;
                        }
                        catch (PrivilegedActionException exception) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(className, exception.getException());
                        }
                    }
                    elementType = PrivilegedAccessHelper.getClassForName(className, true, classLoader);
                }
                catch (ClassNotFoundException exc) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(className, exc);
                }
            }
            if (this.classToFieldMappings.get(elementType) != null) continue;
            this.classToFieldMappings.put(elementType, entry.getKey());
        }
    }

    public void addConverter(XMLField field, Converter converter) {
        if (this.fieldsToConverters == null) {
            this.fieldsToConverters = new HashMap<XMLField, Converter>();
        }
        this.fieldsToConverters.put(field, converter);
    }

    public Converter getConverter(XMLField field) {
        if (null != this.fieldsToConverters) {
            Converter converter = this.fieldsToConverters.get(field);
            if (null != converter) {
                return converter;
            }
            if (null != this.choiceElementMappings) {
                DatabaseMapping mapping = (DatabaseMapping)((Object)this.choiceElementMappings.get(field));
                if (null == mapping) {
                    return null;
                }
                if (mapping.isAbstractCompositeDirectCollectionMapping()) {
                    return ((XMLCompositeDirectCollectionMapping)mapping).getValueConverter();
                }
                if (mapping.isAbstractDirectMapping()) {
                    return ((XMLDirectMapping)mapping).getConverter();
                }
            }
        }
        return null;
    }

    public ArrayList getChoiceFieldToClassAssociations() {
        ArrayList<XMLChoiceFieldToClassAssociation> associations = new ArrayList<XMLChoiceFieldToClassAssociation>();
        if (this.fieldToClassNameMappings.size() > 0) {
            for (XMLField xmlField : this.fieldToClassNameMappings.keySet()) {
                String className = this.fieldToClassNameMappings.get(xmlField);
                XMLChoiceFieldToClassAssociation association = new XMLChoiceFieldToClassAssociation(xmlField, className);
                associations.add(association);
            }
        }
        return associations;
    }

    public void setChoiceFieldToClassAssociations(ArrayList associations) {
        if (associations.size() > 0) {
            for (Object next : associations) {
                XMLChoiceFieldToClassAssociation association = (XMLChoiceFieldToClassAssociation)next;
                this.addChoiceElement(association.getXmlField(), association.getClassName());
                if (association.getConverter() == null) continue;
                this.addConverter(association.getXmlField(), association.getConverter());
            }
        }
    }

    private void addChoiceElementMapping(XMLField xmlField, String className) {
        if (xmlField.getLastXPathFragment().nameIsText()) {
            XMLDirectMapping xmlMapping = new XMLDirectMapping();
            xmlMapping.setAttributeAccessor(temporaryAccessor);
            Class theClass = XMLConversionManager.getDefaultXMLManager().convertClassNameToClass(className);
            xmlMapping.setAttributeClassification(theClass);
            xmlMapping.setField(xmlField);
            this.choiceElementMappings.put(xmlField, xmlMapping);
        } else {
            XMLCompositeObjectMapping xmlMapping = new XMLCompositeObjectMapping();
            xmlMapping.setAttributeAccessor(temporaryAccessor);
            if (!className.equals("java.lang.Object")) {
                xmlMapping.setReferenceClassName(className);
            }
            xmlMapping.setField(xmlField);
            this.choiceElementMappings.put(xmlField, xmlMapping);
        }
    }

    private void addChoiceElementMapping(XMLField xmlField, Class theClass) {
        if (xmlField.getLastXPathFragment().nameIsText()) {
            XMLDirectMapping xmlMapping = new XMLDirectMapping();
            xmlMapping.setAttributeClassification(theClass);
            xmlMapping.setAttributeAccessor(temporaryAccessor);
            xmlMapping.setField(xmlField);
            this.choiceElementMappings.put(xmlField, xmlMapping);
        } else {
            XMLCompositeObjectMapping xmlMapping = new XMLCompositeObjectMapping();
            xmlMapping.setAttributeAccessor(temporaryAccessor);
            if (!theClass.equals(ClassConstants.OBJECT)) {
                xmlMapping.setReferenceClass(theClass);
            }
            xmlMapping.setField(xmlField);
            this.choiceElementMappings.put(xmlField, xmlMapping);
        }
    }

    @Override
    public boolean isWriteOnly() {
        return this.isWriteOnly;
    }

    @Override
    public void setIsWriteOnly(boolean b) {
        this.isWriteOnly = b;
    }

    @Override
    public void preInitialize(AbstractSession session) throws DescriptorException {
        this.getAttributeAccessor().setIsWriteOnly(this.isWriteOnly());
        this.getAttributeAccessor().setIsReadOnly(this.isReadOnly());
        super.preInitialize(session);
        for (DatabaseMapping databaseMapping : this.getChoiceElementMappings().values()) {
            databaseMapping.setDescriptor(this.getDescriptor());
            databaseMapping.setAttributeName(this.getAttributeName());
            if (databaseMapping.getAttributeAccessor() == temporaryAccessor) {
                databaseMapping.setAttributeAccessor(this.getAttributeAccessor());
            }
            databaseMapping.preInitialize(session);
        }
    }

    @Override
    public void setAttributeValueInObject(Object object, Object value) throws DescriptorException {
        if (this.isWriteOnly()) {
            return;
        }
        super.setAttributeValueInObject(object, value);
    }
}

