/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.converters;

import javax.persistence.EnumType;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.converters.MetadataConverter;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.EnumTypeConverter;

public class EnumeratedMetadata
extends MetadataConverter {
    private String m_enumeratedType;

    public EnumeratedMetadata() {
        this.m_enumeratedType = EnumType.ORDINAL.name();
    }

    public EnumeratedMetadata(String xmlElement) {
        super(xmlElement);
    }

    public EnumeratedMetadata(MetadataAccessibleObject accessibleObject) {
        super(accessibleObject);
    }

    public EnumeratedMetadata(MetadataAnnotation enumerated, MetadataAccessibleObject accessibleObject) {
        super(enumerated, accessibleObject);
        this.m_enumeratedType = (String)enumerated.getAttribute("value");
    }

    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof EnumeratedMetadata) {
            EnumeratedMetadata enumerated = (EnumeratedMetadata)objectToCompare;
            return this.valuesMatch(this.m_enumeratedType, enumerated.getEnumeratedType());
        }
        return false;
    }

    public String getEnumeratedType() {
        return this.m_enumeratedType;
    }

    public static boolean isValidEnumeratedType(MetadataClass cls) {
        return cls.isEnum();
    }

    public void process(DatabaseMapping mapping, MappingAccessor accessor, MetadataClass referenceClass, boolean isForMapKey) {
        if (!EnumeratedMetadata.isValidEnumeratedType(referenceClass)) {
            throw ValidationException.invalidTypeForEnumeratedAttribute((String)mapping.getAttributeName(), (Object)referenceClass, (Object)accessor.getJavaClass());
        }
        boolean isOrdinal = true;
        if (this.m_enumeratedType != null) {
            isOrdinal = this.m_enumeratedType.equals(EnumType.ORDINAL.name());
        }
        this.setConverter(mapping, (Converter)new EnumTypeConverter(mapping, this.getJavaClass(referenceClass), isOrdinal), isForMapKey);
    }

    public void setEnumeratedType(String enumerated) {
        this.m_enumeratedType = enumerated;
    }
}

