/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.compiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.eclipse.persistence.jaxb.compiler.ElementDeclaration;
import org.eclipse.persistence.jaxb.javamodel.Helper;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaHasAnnotations;
import org.eclipse.persistence.jaxb.javamodel.JavaMethod;
import org.eclipse.persistence.jaxb.xmlmodel.XmlAbstractNullPolicy;
import org.eclipse.persistence.jaxb.xmlmodel.XmlElementRef;
import org.eclipse.persistence.jaxb.xmlmodel.XmlElementWrapper;
import org.eclipse.persistence.jaxb.xmlmodel.XmlElements;
import org.eclipse.persistence.jaxb.xmlmodel.XmlJavaTypeAdapter;
import org.eclipse.persistence.jaxb.xmlmodel.XmlMarshalNullRepresentation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Property {
    private String propertyName;
    private QName schemaName;
    private boolean isMethodProperty;
    private QName schemaType;
    private boolean isSwaAttachmentRef;
    private boolean isMtomAttachment;
    private boolean isInlineBinaryData;
    private String mimeType;
    private JavaClass type;
    private JavaClass adapterClass;
    private JavaHasAnnotations element;
    private JavaClass genericType;
    private boolean isAttribute = false;
    private boolean isAnyAttribute = false;
    private boolean isAnyElement = false;
    private Helper helper;
    private String getMethodName;
    private String setMethodName;
    private boolean isRequired = false;
    private boolean isNillable = false;
    private boolean isXmlList = false;
    private boolean isTransient;
    private String defaultValue;
    private boolean isMixedContent = false;
    private boolean xmlElementType = false;
    private JavaClass originalType;
    private String fixedValue;
    private Boolean isReadOnly;
    private Boolean isWriteOnly;
    private Boolean isCdata;
    private static final String OPEN_BRACKET = "[";
    private XmlAbstractNullPolicy nullPolicy;
    private XmlJavaTypeAdapter xmlJavaTypeAdapter;
    private XmlElementWrapper xmlElementWrapper;
    private boolean isXmlValue = false;
    private boolean isXmlId = false;
    private boolean isXmlIdRef = false;
    private String inverseReferencePropertyName;
    private String inverseReferencePropertyGetMethodName;
    private String inverseReferencePropertySetMethodName;
    private JavaClass inverseReferencePropertyContainerClass;
    private boolean isInverseReference;
    private boolean lax;
    private String domHandlerClassName;
    private JavaClass keyType;
    private JavaClass valueType;
    public static final String DEFAULT_KEY_NAME = "key";
    public static final String DEFAULT_VALUE_NAME = "value";
    private boolean isMap = false;
    private String xmlPath;
    private Collection<Property> choiceProperties;
    private XmlElements xmlElements;
    private boolean isChoice = false;
    private ArrayList<ElementDeclaration> referencedElements;
    private List<XmlElementRef> xmlElementRefs;
    private boolean isReference = false;

    public Property() {
    }

    public Property(Helper helper) {
        this.helper = helper;
    }

    public void setHelper(Helper helper) {
        this.helper = helper;
    }

    public void setAdapterClass(JavaClass adapterCls) {
        this.adapterClass = adapterCls;
        JavaClass newType = this.helper.getJavaClass(Object.class);
        for (JavaMethod method : this.adapterClass.getDeclaredMethods()) {
            JavaClass returnType;
            if (!method.getName().equals("marshal") || (returnType = method.getReturnType()).getQualifiedName().equals(newType.getQualifiedName())) continue;
            newType = method.getReturnType();
            break;
        }
        this.setType(newType);
    }

    public JavaHasAnnotations getElement() {
        return this.element;
    }

    public void setElement(JavaHasAnnotations element) {
        this.element = element;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public QName getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(QName schemaName) {
        this.schemaName = schemaName;
    }

    public boolean isMethodProperty() {
        return this.isMethodProperty;
    }

    public void setMethodProperty(boolean isMethod) {
        this.isMethodProperty = isMethod;
    }

    public void setType(JavaClass cls) {
        if (cls == null) {
            return;
        }
        if (this.type != null && this.type == cls) {
            return;
        }
        String clsName = cls.getRawName();
        if (this.type != null && this.isCollectionType(this.type)) {
            this.genericType = cls;
        } else if (this.isCollectionType(cls)) {
            if (cls.hasActualTypeArguments()) {
                ArrayList typeArgs = (ArrayList)cls.getActualTypeArguments();
                this.genericType = (JavaClass)typeArgs.get(0);
            } else {
                this.genericType = this.helper.getJavaClass(Object.class);
            }
            this.type = cls;
        } else if (cls.isArray() && !clsName.equals("byte[]") && !clsName.equals("java.lang.Byte[]")) {
            this.type = cls;
            this.genericType = cls.getComponentType();
        } else {
            this.type = cls;
        }
        boolean isNewTypeMap = this.helper.getJavaClass(Map.class).isAssignableFrom(this.type);
        this.setIsMap(isNewTypeMap);
        if (this.isMap()) {
            Object[] types = this.type.getActualTypeArguments().toArray();
            if (types.length >= 2) {
                this.keyType = (JavaClass)types[0];
                this.valueType = (JavaClass)types[1];
            } else {
                this.keyType = this.helper.getJavaClass(Object.class);
                this.valueType = this.helper.getJavaClass(Object.class);
            }
        }
    }

    public JavaClass getType() {
        return this.type;
    }

    public JavaClass getGenericType() {
        return this.genericType;
    }

    public void setGenericType(JavaClass genericType) {
        this.genericType = genericType;
    }

    public QName getSchemaType() {
        return this.schemaType;
    }

    public void setSchemaType(QName type) {
        this.schemaType = type;
    }

    public boolean isSwaAttachmentRef() {
        return this.isSwaAttachmentRef;
    }

    public void setIsSwaAttachmentRef(boolean b) {
        this.isSwaAttachmentRef = b;
    }

    public boolean isMtomAttachment() {
        return this.isMtomAttachment;
    }

    public void setIsMtomAttachment(boolean b) {
        this.isMtomAttachment = b;
    }

    public boolean isInlineBinaryData() {
        return this.isInlineBinaryData;
    }

    public void setisInlineBinaryData(boolean b) {
        this.isInlineBinaryData = b;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public void setIsRequired(boolean b) {
        this.isRequired = b;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mType) {
        this.mimeType = mType;
    }

    public boolean isAttribute() {
        return this.isAttribute || this.isAnyAttribute;
    }

    public boolean isAnyAttribute() {
        return this.isAnyAttribute;
    }

    public void setIsAttribute(boolean attribute) {
        this.isAttribute = attribute;
    }

    public void setIsAnyAttribute(boolean anyAtribute) {
        this.isAnyAttribute = anyAtribute;
    }

    public String getGetMethodName() {
        return this.getMethodName;
    }

    public void setGetMethodName(String methodName) {
        this.getMethodName = methodName;
    }

    public String getSetMethodName() {
        return this.setMethodName;
    }

    public void setSetMethodName(String methodName) {
        this.setMethodName = methodName;
    }

    public boolean isChoice() {
        return this.isChoice;
    }

    public void setChoice(boolean choice) {
        this.isChoice = choice;
    }

    public boolean isAny() {
        return this.isAnyElement;
    }

    public void setIsAny(boolean isAnyElement) {
        this.isAnyElement = isAnyElement;
    }

    public boolean isReference() {
        return this.isReference;
    }

    public void setIsReference(boolean isReference) {
        this.isReference = isReference;
    }

    public boolean isNillable() {
        return this.isNillable;
    }

    public void setNillable(boolean isNillable) {
        this.isNillable = isNillable;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public void setTransient(boolean isTransient) {
        this.isTransient = isTransient;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isSetDefaultValue() {
        return this.defaultValue != null;
    }

    public boolean isMixedContent() {
        return this.isMixedContent;
    }

    public void setMixedContent(boolean b) {
        this.isMixedContent = b;
    }

    public void setHasXmlElementType(boolean hasXmlElementType) {
        this.xmlElementType = hasXmlElementType;
    }

    public boolean isXmlElementType() {
        return this.xmlElementType;
    }

    public boolean isCollectionType(JavaClass type) {
        return this.helper.getJavaClass(Collection.class).isAssignableFrom(type) || this.helper.getJavaClass(List.class).isAssignableFrom(type) || this.helper.getJavaClass(Set.class).isAssignableFrom(type);
    }

    public JavaClass getActualType() {
        if (this.genericType != null) {
            return this.genericType;
        }
        return this.type;
    }

    public JavaClass getOriginalType() {
        return this.originalType;
    }

    public void setOriginalType(JavaClass type) {
        this.originalType = type;
    }

    public boolean isSetXmlJavaTypeAdapter() {
        return this.getXmlJavaTypeAdapter() != null;
    }

    public XmlJavaTypeAdapter getXmlJavaTypeAdapter() {
        return this.xmlJavaTypeAdapter;
    }

    public void setXmlJavaTypeAdapter(XmlJavaTypeAdapter xmlJavaTypeAdapter) {
        this.xmlJavaTypeAdapter = xmlJavaTypeAdapter;
        if (xmlJavaTypeAdapter == null) {
            this.adapterClass = null;
            this.setType(this.originalType);
        } else {
            this.setAdapterClass(this.helper.getJavaClass(xmlJavaTypeAdapter.getValue()));
        }
    }

    public boolean isSetXmlElementWrapper() {
        return this.getXmlElementWrapper() != null;
    }

    public XmlElementWrapper getXmlElementWrapper() {
        return this.xmlElementWrapper;
    }

    public void setXmlElementWrapper(XmlElementWrapper xmlElementWrapper) {
        this.xmlElementWrapper = xmlElementWrapper;
    }

    public void setIsXmlValue(boolean isXmlValue) {
        this.isXmlValue = isXmlValue;
    }

    public boolean isXmlValue() {
        return this.isXmlValue;
    }

    public void setIsXmlList(boolean isXmlList) {
        this.isXmlList = isXmlList;
    }

    public boolean isXmlList() {
        return this.isXmlList;
    }

    public String getInverseReferencePropertyName() {
        return this.inverseReferencePropertyName;
    }

    public void setInverseReferencePropertyName(String name) {
        this.inverseReferencePropertyName = name;
    }

    public String getInverseReferencePropertyGetMethodName() {
        return this.inverseReferencePropertyGetMethodName;
    }

    public String getInverseReferencePropertySetMethodName() {
        return this.inverseReferencePropertySetMethodName;
    }

    public void setInverseReferencePropertyGetMethodName(String methodName) {
        this.inverseReferencePropertyGetMethodName = methodName;
    }

    public void setInverseReferencePropertySetMethodName(String methodName) {
        this.inverseReferencePropertySetMethodName = methodName;
    }

    public JavaClass getInverseReferencePropertyContainerClass() {
        return this.inverseReferencePropertyContainerClass;
    }

    public void setInverseReferencePropertyContainerClass(JavaClass cls) {
        this.inverseReferencePropertyContainerClass = cls;
    }

    public boolean isXmlId() {
        return this.isXmlId;
    }

    public void setIsXmlId(boolean isXmlId) {
        this.isXmlId = isXmlId;
    }

    public boolean isXmlIdRef() {
        return this.isXmlIdRef;
    }

    public void setIsXmlIdRef(boolean isXmlIdRef) {
        this.isXmlIdRef = isXmlIdRef;
    }

    public boolean isLax() {
        return this.lax;
    }

    public void setLax(boolean b) {
        this.lax = b;
    }

    public String getDomHandlerClassName() {
        return this.domHandlerClassName;
    }

    public void setDomHandlerClassName(String domHandlerClassName) {
        this.domHandlerClassName = domHandlerClassName;
    }

    public JavaClass getKeyType() {
        return this.keyType;
    }

    public void setKeyType(JavaClass keyType) {
        this.keyType = keyType;
    }

    public JavaClass getValueType() {
        return this.valueType;
    }

    public void setValueType(JavaClass valueType) {
        this.valueType = valueType;
    }

    public boolean isMap() {
        return this.isMap;
    }

    private void setIsMap(boolean isMap) {
        this.isMap = isMap;
    }

    public boolean isInverseReference() {
        return this.isInverseReference;
    }

    public void setInverseReference(boolean isInverseReference) {
        this.isInverseReference = isInverseReference;
    }

    public XmlElements getXmlElements() {
        return this.xmlElements;
    }

    public void setXmlElements(XmlElements xmlElements) {
        this.xmlElements = xmlElements;
    }

    public Collection<Property> getChoiceProperties() {
        return this.choiceProperties;
    }

    public void setChoiceProperties(Collection<Property> properties) {
        this.choiceProperties = properties;
    }

    public List<XmlElementRef> getXmlElementRefs() {
        return this.xmlElementRefs;
    }

    public void setXmlElementRefs(List<XmlElementRef> xmlElementRefs) {
        this.xmlElementRefs = xmlElementRefs;
    }

    public void addReferencedElement(ElementDeclaration element) {
        if (this.referencedElements == null) {
            this.referencedElements = new ArrayList();
        }
        if (!this.referencedElements.contains(element)) {
            this.referencedElements.add(element);
        }
    }

    public List<ElementDeclaration> getReferencedElements() {
        return this.referencedElements;
    }

    public String getFixedValue() {
        return this.fixedValue;
    }

    public void setFixedValue(String fixedValue) {
        this.fixedValue = fixedValue;
    }

    public boolean isPositional() {
        return this.getXmlPath() != null && this.getXmlPath().contains(OPEN_BRACKET);
    }

    public void setReadOnly(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    public boolean isReadOnly() {
        if (this.isReadOnly == null) {
            return false;
        }
        return this.isReadOnly;
    }

    public boolean isSetReadOnly() {
        return this.isReadOnly != null;
    }

    public void setWriteOnly(boolean isWriteOnly) {
        this.isWriteOnly = isWriteOnly;
    }

    public boolean isWriteOnly() {
        if (this.isWriteOnly == null) {
            return false;
        }
        return this.isWriteOnly;
    }

    public boolean isSetWriteOnly() {
        return this.isWriteOnly != null;
    }

    public void setCdata(boolean isCdata) {
        this.isCdata = isCdata;
    }

    public boolean isCdata() {
        if (this.isCdata == null) {
            return false;
        }
        return this.isCdata;
    }

    public boolean isSetCdata() {
        return this.isCdata != null;
    }

    public String getXmlPath() {
        return this.xmlPath;
    }

    public void setXmlPath(String xmlPath) {
        this.xmlPath = xmlPath;
    }

    public boolean isSetXmlPath() {
        return this.xmlPath != null;
    }

    public XmlAbstractNullPolicy getNullPolicy() {
        return this.nullPolicy;
    }

    public void setNullPolicy(XmlAbstractNullPolicy nullPolicy) {
        this.nullPolicy = nullPolicy;
    }

    public boolean isSetNullPolicy() {
        return this.nullPolicy != null;
    }

    public boolean shouldSetNillable() {
        if (this.isNillable()) {
            return true;
        }
        if (this.isSetNullPolicy()) {
            return this.getNullPolicy().isXsiNilRepresentsNull() || this.getNullPolicy().getNullRepresentationForXml() == XmlMarshalNullRepresentation.XSI_NIL;
        }
        return false;
    }
}

