/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors;

import java.io.Serializable;
import java.util.HashSet;
import org.eclipse.persistence.annotations.CacheKeyType;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.PessimisticLockingPolicy;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.identitymaps.CacheId;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.ObjectReferenceMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.queries.UpdateObjectQuery;

public class CMPPolicy
implements Serializable {
    protected Boolean forceUpdate = null;
    protected Boolean updateAllFields = null;
    protected PessimisticLockingPolicy pessimisticLockingPolicy;
    protected Class mappedClass;
    protected ClassDescriptor descriptor;
    protected int modificationDeferralLevel = 2;
    public static final int NONE = 0;
    public static final int UPDATE_MODIFICATIONS = 1;
    public static final int ALL_MODIFICATIONS = 2;
    protected int nonDeferredCreateTime = 0;
    public static final int UNDEFINED = 0;
    public static final int AFTER_EJBCREATE = 1;
    public static final int AFTER_EJBPOSTCREATE = 2;

    public int getNonDeferredCreateTime() {
        return this.nonDeferredCreateTime;
    }

    public PessimisticLockingPolicy getPessimisticLockingPolicy() {
        return this.pessimisticLockingPolicy;
    }

    public void setDeferModificationsUntilCommit(int deferralLevel) {
        this.modificationDeferralLevel = deferralLevel;
    }

    public void setMappedClass(Class newMappedClass) {
        this.mappedClass = newMappedClass;
    }

    public Class getMappedClass() {
        return this.mappedClass;
    }

    public void setNonDeferredCreateTime(int createTime) {
        this.nonDeferredCreateTime = createTime;
    }

    public void setPessimisticLockingPolicy(PessimisticLockingPolicy policy) {
        this.pessimisticLockingPolicy = policy;
    }

    public boolean hasPessimisticLockingPolicy() {
        return this.pessimisticLockingPolicy != null;
    }

    public int getDeferModificationsUntilCommit() {
        return this.modificationDeferralLevel;
    }

    public boolean getForceUpdate() {
        return Boolean.TRUE.equals(this.forceUpdate);
    }

    public void setForceUpdate(boolean shouldForceUpdate) {
        this.forceUpdate = shouldForceUpdate;
    }

    public boolean getUpdateAllFields() {
        return Boolean.TRUE.equals(this.updateAllFields);
    }

    public void setUpdateAllFields(boolean shouldUpdatAllFields) {
        this.updateAllFields = shouldUpdatAllFields;
    }

    public Boolean internalGetForceUpdate() {
        return this.forceUpdate;
    }

    public Boolean internalGetUpdateAllFields() {
        return this.updateAllFields;
    }

    public void internalSetForceUpdate(Boolean newForceUpdateValue) {
        this.forceUpdate = newForceUpdateValue;
    }

    public void internalSetUpdateAllFields(Boolean newUpdateAllFieldsValue) {
        this.updateAllFields = newUpdateAllFieldsValue;
    }

    public void initialize(ClassDescriptor descriptor, AbstractSession session) throws DescriptorException {
        if (this.getUpdateAllFields() && !descriptor.getQueryManager().hasUpdateQuery()) {
            descriptor.getQueryManager().setUpdateQuery(new UpdateObjectQuery());
        }
        if (this.getForceUpdate() && !this.getUpdateAllFields()) {
            throw DescriptorException.updateAllFieldsNotSet(descriptor);
        }
    }

    public ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(ClassDescriptor owningDescriptor) {
        this.descriptor = owningDescriptor;
    }

    public boolean isCMP3Policy() {
        return false;
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
    }

    public Object createPrimaryKeyInstanceFromId(Object key, AbstractSession session) {
        if (this.descriptor.getCacheKeyType() == CacheKeyType.CACHE_ID) {
            return this.createPrimaryKeyInstanceFromPrimaryKeyValues(session, new int[]{0}, ((CacheId)key).getPrimaryKey());
        }
        return this.createPrimaryKeyInstanceFromPrimaryKeyValues(session, new int[]{0}, key);
    }

    public Object createPrimaryKeyInstanceFromPrimaryKeyValues(AbstractSession session, int[] elementIndex, Object ... keyElements) {
        Object keyInstance = null;
        KeyElementAccessor[] pkElementArray = this.getKeyClassFields(this.getPKClass());
        if (pkElementArray.length == 1 && pkElementArray[0] instanceof KeyIsElementAccessor) {
            DatabaseMapping mapping = this.getDescriptor().getObjectBuilder().getMappingForAttributeName(pkElementArray[0].getAttributeName());
            if (mapping.isDirectToFieldMapping()) {
                Converter converter = ((DirectToFieldMapping)mapping).getConverter();
                if (converter != null) {
                    return converter.convertDataValueToObjectValue(keyElements[elementIndex[0]], session);
                }
                keyInstance = keyElements[elementIndex[0]];
            } else if (mapping.isObjectReferenceMapping()) {
                keyInstance = mapping.getReferenceDescriptor().getCMPPolicy().createPrimaryKeyInstanceFromPrimaryKeyValues(session, elementIndex, keyElements);
            }
            elementIndex[0] = elementIndex[0] + 1;
        } else {
            keyInstance = this.getPKClassInstance();
            for (int index = 0; index < pkElementArray.length; ++index) {
                KeyElementAccessor accessor = pkElementArray[index];
                DatabaseMapping mapping = this.getDescriptor().getObjectBuilder().getMappingForAttributeName(accessor.getAttributeName());
                if (mapping == null) {
                    mapping = this.getDescriptor().getObjectBuilder().getMappingForField(accessor.getDatabaseField());
                }
                while (mapping.isAggregateMapping()) {
                    mapping = mapping.getReferenceDescriptor().getObjectBuilder().getMappingForField(accessor.getDatabaseField());
                }
                Object fieldValue = null;
                if (mapping.isDirectToFieldMapping()) {
                    fieldValue = keyElements[elementIndex[0]];
                    Converter converter = ((DirectToFieldMapping)mapping).getConverter();
                    if (converter != null) {
                        fieldValue = converter.convertDataValueToObjectValue(fieldValue, session);
                    }
                    elementIndex[0] = elementIndex[0] + 1;
                } else if (mapping.isObjectReferenceMapping()) {
                    fieldValue = mapping.getReferenceDescriptor().getCMPPolicy().createPrimaryKeyInstanceFromPrimaryKeyValues(session, elementIndex, keyElements);
                }
                accessor.setValue(keyInstance, fieldValue);
            }
        }
        return keyInstance;
    }

    public Object createPrimaryKeyInstance(Object object, AbstractSession session) {
        KeyElementAccessor[] pkElementArray = this.getKeyClassFields(this.getPKClass());
        ObjectBuilder builder = this.getDescriptor().getObjectBuilder();
        if (pkElementArray.length == 1 && pkElementArray[0] instanceof KeyIsElementAccessor) {
            DatabaseMapping mapping = builder.getMappingForAttributeName(pkElementArray[0].getAttributeName());
            Object fieldValue = mapping.getRealAttributeValueFromObject(object, session);
            if (mapping.isObjectReferenceMapping()) {
                fieldValue = mapping.getReferenceDescriptor().getCMPPolicy().createPrimaryKeyInstance(fieldValue, session);
            }
            return fieldValue;
        }
        Object keyInstance = this.getPKClassInstance();
        HashSet<ObjectReferenceMapping> usedObjectReferenceMappings = new HashSet<ObjectReferenceMapping>();
        for (int index = 0; index < pkElementArray.length; ++index) {
            Object keyObj = object;
            KeyElementAccessor accessor = pkElementArray[index];
            DatabaseField field = accessor.getDatabaseField();
            DatabaseMapping mapping = builder.getMappingForField(field);
            if (mapping.isObjectReferenceMapping() && usedObjectReferenceMappings.contains(mapping)) continue;
            while (mapping.isAggregateObjectMapping()) {
                keyObj = mapping.getRealAttributeValueFromObject(keyObj, session);
                mapping = mapping.getReferenceDescriptor().getObjectBuilder().getMappingForField(field);
            }
            Object fieldValue = mapping.getRealAttributeValueFromObject(keyObj, session);
            if (mapping.isObjectReferenceMapping()) {
                fieldValue = mapping.getReferenceDescriptor().getCMPPolicy().createPrimaryKeyInstance(fieldValue, session);
                usedObjectReferenceMappings.add((ObjectReferenceMapping)mapping);
            }
            accessor.setValue(keyInstance, fieldValue);
        }
        return keyInstance;
    }

    public Object getPKClassInstance() {
        throw new RuntimeException("Should not get here.");
    }

    public Class getPKClass() {
        throw new RuntimeException("Should not get here.");
    }

    public Object createPrimaryKeyFromId(Object key, AbstractSession session) {
        throw new RuntimeException("Should not get here.");
    }

    public Object createBeanUsingKey(Object key, AbstractSession session) {
        throw new RuntimeException("Should not get here.");
    }

    protected KeyElementAccessor[] getKeyClassFields(Class clazz) {
        throw new RuntimeException("Should not get here.");
    }

    protected static interface KeyElementAccessor {
        public String getAttributeName();

        public DatabaseField getDatabaseField();

        public DatabaseMapping getMapping();

        public Object getValue(Object var1, AbstractSession var2);

        public void setValue(Object var1, Object var2);
    }

    protected class KeyIsElementAccessor
    implements KeyElementAccessor,
    Serializable {
        protected String attributeName;
        protected DatabaseField databaseField;
        protected DatabaseMapping mapping;

        public KeyIsElementAccessor(String attributeName, DatabaseField databaseField, DatabaseMapping mapping) {
            this.attributeName = attributeName;
            this.databaseField = databaseField;
            this.mapping = mapping;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public DatabaseField getDatabaseField() {
            return this.databaseField;
        }

        public DatabaseMapping getMapping() {
            return this.mapping;
        }

        public Object getValue(Object object, AbstractSession session) {
            return object;
        }

        public void setValue(Object object, Object value) {
        }
    }
}

