/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.eis.mappings;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.eis.EISDescriptor;
import org.eclipse.persistence.eis.mappings.EISMapping;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.oxm.XMLObjectBuilder;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.queries.MapContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.AbstractCompositeCollectionMapping;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.queries.ObjectBuildingQuery;

public class EISCompositeCollectionMapping
extends AbstractCompositeCollectionMapping
implements EISMapping {
    public boolean isEISMapping() {
        return true;
    }

    public void initialize(AbstractSession session) throws DescriptorException {
        super.initialize(session);
        if (this.getContainerPolicy() instanceof MapContainerPolicy) {
            ((MapContainerPolicy)this.getContainerPolicy()).setElementClass(this.getReferenceClass());
        }
    }

    public String getXPath() {
        return this.getField().getName();
    }

    public void setXPath(String xpathString) {
        this.setField(new XMLField(xpathString));
    }

    public String getFieldName() {
        return this.getField().getName();
    }

    public void setFieldName(String fieldName) {
        this.setField(new DatabaseField(fieldName));
    }

    protected Object buildCompositeObject(ClassDescriptor descriptor, AbstractRecord nestedRow, ObjectBuildingQuery query, JoinedAttributeManager joinManager) {
        if (((EISDescriptor)descriptor).getDataFormat() == "xml") {
            return descriptor.getObjectBuilder().buildObject(query, nestedRow, joinManager);
        }
        Object element = descriptor.getObjectBuilder().buildNewInstance();
        descriptor.getObjectBuilder().buildAttributesIntoObject(element, nestedRow, query, joinManager, false);
        return element;
    }

    protected AbstractRecord buildCompositeRow(Object attributeValue, AbstractSession session, AbstractRecord parentRow, DatabaseMapping.WriteType writeType) {
        if (((EISDescriptor)this.getDescriptor()).getDataFormat() == "xml") {
            XMLObjectBuilder objectBuilder = (XMLObjectBuilder)this.getReferenceDescriptor(attributeValue, session).getObjectBuilder();
            return objectBuilder.buildRow(attributeValue, session, this.getField(), (XMLRecord)parentRow);
        }
        return this.getObjectBuilder(attributeValue, session).buildRow(attributeValue, session, writeType);
    }
}

