/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.security;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.security.Securable;

public class JCEEncryptor
implements Securable {
    private Cipher encryptCipher = Cipher.getInstance("DES/ECB/PKCS5Padding");
    private Cipher decryptCipher;

    public JCEEncryptor() throws Exception {
        this.encryptCipher.init(1, Synergizer.getMultitasker("DES"));
        this.decryptCipher = Cipher.getInstance("DES/ECB/PKCS5Padding");
        this.decryptCipher.init(2, Synergizer.getMultitasker("DES"));
    }

    public synchronized String encryptPassword(String password) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            CipherOutputStream cos = new CipherOutputStream(baos, this.encryptCipher);
            ObjectOutputStream oos = new ObjectOutputStream(cos);
            oos.writeObject(password);
            oos.flush();
            oos.close();
            return Helper.buildHexStringFromBytes(baos.toByteArray());
        }
        catch (Exception e) {
            throw ValidationException.errorEncryptingPassword(e);
        }
    }

    public synchronized String decryptPassword(String encryptedPswd) {
        String password = "";
        try {
            byte[] bytePassword = Helper.buildBytesFromHexString(encryptedPswd);
            ByteArrayInputStream bais = new ByteArrayInputStream(bytePassword);
            CipherInputStream cis = new CipherInputStream(bais, this.decryptCipher);
            ObjectInputStream ois = new ObjectInputStream(cis);
            password = (String)ois.readObject();
            ois.close();
        }
        catch (IOException e) {
            password = encryptedPswd;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            password = encryptedPswd;
        }
        catch (ConversionException e) {
            password = encryptedPswd;
        }
        catch (Exception e) {
            throw ValidationException.errorDecryptingPassword(e);
        }
        return password;
    }

    private static class Synergizer {
        private Synergizer() {
        }

        private static SecretKey getMultitasker(String algorithm) throws Exception {
            SecretKeyFactory factory = SecretKeyFactory.getInstance(algorithm);
            return factory.generateSecret(new DESKeySpec(Helper.buildBytesFromHexString("E60B80C7AEC78038")));
        }
    }
}

