/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.sequencing;

import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;

public class SequenceGeneratorMetadata
extends ORMetadata {
    private Integer m_allocationSize;
    private Integer m_initialValue;
    private String m_name;
    private String m_schema;
    private String m_catalog;
    private String m_sequenceName;

    public SequenceGeneratorMetadata() {
        super("<sequence-generator>");
    }

    public SequenceGeneratorMetadata(MetadataAnnotation sequenceGenerator, MetadataAccessibleObject accessibleObject) {
        super(sequenceGenerator, accessibleObject);
        this.m_allocationSize = (Integer)sequenceGenerator.getAttribute("allocationSize");
        this.m_initialValue = (Integer)sequenceGenerator.getAttribute("initialValue");
        this.m_name = (String)sequenceGenerator.getAttributeString("name");
        this.m_schema = (String)sequenceGenerator.getAttribute("schema");
        this.m_catalog = (String)sequenceGenerator.getAttribute("catalog");
        this.m_sequenceName = (String)sequenceGenerator.getAttributeString("sequenceName");
    }

    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof SequenceGeneratorMetadata) {
            SequenceGeneratorMetadata generator = (SequenceGeneratorMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_name, generator.getName())) {
                return false;
            }
            if (!this.valuesMatch(this.m_initialValue, generator.getInitialValue())) {
                return false;
            }
            if (!this.valuesMatch(this.m_allocationSize, generator.getAllocationSize())) {
                return false;
            }
            return this.valuesMatch(this.m_sequenceName, generator.getSequenceName());
        }
        return false;
    }

    public Integer getAllocationSize() {
        return this.m_allocationSize;
    }

    public String getCatalog() {
        return this.m_catalog;
    }

    public String getQualifier() {
        if (this.m_catalog.length() == 0) {
            if (this.m_schema.length() == 0) {
                return "";
            }
            return this.m_schema;
        }
        return this.m_catalog + '.' + this.m_schema;
    }

    public String getCatalogContext() {
        return "metadata_default_sequence_generator_catalog";
    }

    public String getIdentifier() {
        return this.getName();
    }

    public Integer getInitialValue() {
        return this.m_initialValue;
    }

    public String getName() {
        return this.m_name;
    }

    public String getSchema() {
        return this.m_schema;
    }

    public String getSchemaContext() {
        return "metadata_default_sequence_generator_schema";
    }

    public String getSequenceName() {
        return this.m_sequenceName;
    }

    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        if (this.m_sequenceName == null) {
            this.m_sequenceName = "";
        }
    }

    public void setAllocationSize(Integer allocationSize) {
        this.m_allocationSize = allocationSize;
    }

    public void setCatalog(String catalog) {
        this.m_catalog = catalog;
    }

    public void setInitialValue(Integer initialValue) {
        this.m_initialValue = initialValue;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setSchema(String schema) {
        this.m_schema = schema;
    }

    public void setSequenceName(String sequenceName) {
        this.m_sequenceName = sequenceName;
    }
}

