/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import org.eclipse.persistence.internal.oxm.ChoiceUnmarshalContext;
import org.eclipse.persistence.internal.oxm.NodeValue;
import org.eclipse.persistence.internal.oxm.NullCapableValue;
import org.eclipse.persistence.internal.oxm.XMLCompositeObjectMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XMLDirectMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.XPathNode;
import org.eclipse.persistence.internal.oxm.record.MarshalContext;
import org.eclipse.persistence.internal.oxm.record.ObjectMarshalContext;
import org.eclipse.persistence.internal.oxm.record.UnmarshalContext;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.mappings.XMLChoiceObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.sessions.Session;
import org.xml.sax.Attributes;

public class XMLChoiceObjectMappingNodeValue
extends NodeValue
implements NullCapableValue {
    private NodeValue choiceElementNodeValue;
    private XMLChoiceObjectMapping xmlChoiceMapping;
    private XMLChoiceObjectMappingNodeValue nullCapableNodeValue;
    private XMLField xmlField;

    public XMLChoiceObjectMappingNodeValue(XMLChoiceObjectMapping mapping, XMLField xmlField) {
        this.xmlChoiceMapping = mapping;
        this.xmlField = xmlField;
        this.initializeNodeValue();
    }

    public boolean isOwningNode(XPathFragment xPathFragment) {
        return this.choiceElementNodeValue.isOwningNode(xPathFragment);
    }

    public void initializeNodeValue() {
        XMLMapping xmlMapping = this.xmlChoiceMapping.getChoiceElementMappings().get(this.xmlField);
        this.choiceElementNodeValue = xmlMapping instanceof XMLDirectMapping ? new XMLDirectMappingNodeValue((XMLDirectMapping)xmlMapping) : new XMLCompositeObjectMappingNodeValue((XMLCompositeObjectMapping)xmlMapping);
    }

    public void setNullCapableNodeValue(XMLChoiceObjectMappingNodeValue nodeValue) {
        this.nullCapableNodeValue = nodeValue;
    }

    public void setNullValue(Object object, Session session) {
        this.xmlChoiceMapping.setAttributeValueInObject(object, null);
    }

    public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, AbstractSession session, NamespaceResolver namespaceResolver) {
        return this.marshal(xPathFragment, marshalRecord, object, session, namespaceResolver, ObjectMarshalContext.getInstance());
    }

    public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, AbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext) {
        if (this.xmlChoiceMapping.isReadOnly()) {
            return false;
        }
        Object value = this.xmlChoiceMapping.getFieldValue(object, session, marshalRecord);
        return this.marshalSingleValue(xPathFragment, marshalRecord, object, value, session, namespaceResolver, marshalContext);
    }

    public boolean marshalSingleValue(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, Object value, AbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext) {
        if (value instanceof XMLRoot) {
            XMLRoot root = (XMLRoot)value;
            for (XPathFragment fragment = this.xmlField.getXPathFragment(); fragment != null && !fragment.nameIsText; fragment = fragment.getNextFragment()) {
                if (fragment.getNextFragment() != null && !fragment.getHasText() || !fragment.getLocalName().equals(root.getLocalName())) continue;
                String fragUri = fragment.getNamespaceURI();
                String namespaceUri = root.getNamespaceURI();
                if ((namespaceUri != null || fragUri != null) && (namespaceUri == null || fragUri == null || !namespaceUri.equals(fragUri))) continue;
                return this.choiceElementNodeValue.marshalSingleValue(xPathFragment, marshalRecord, object, value, session, namespaceResolver, marshalContext);
            }
        } else if (value != null && this.xmlChoiceMapping.getClassToFieldMappings().get(value.getClass()) == this.xmlField) {
            return this.choiceElementNodeValue.marshalSingleValue(xPathFragment, marshalRecord, object, value, session, namespaceResolver, marshalContext);
        }
        return false;
    }

    public void endElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord) {
        unmarshalRecord.removeNullCapableValue(this.nullCapableNodeValue);
        if (null != this.xmlChoiceMapping.getConverter()) {
            UnmarshalContext unmarshalContext = unmarshalRecord.getUnmarshalContext();
            unmarshalRecord.setUnmarshalContext(new ChoiceUnmarshalContext(unmarshalContext, this.xmlChoiceMapping.getConverter()));
            this.choiceElementNodeValue.endElement(xPathFragment, unmarshalRecord);
            unmarshalRecord.setUnmarshalContext(unmarshalContext);
        } else {
            this.choiceElementNodeValue.endElement(xPathFragment, unmarshalRecord);
        }
    }

    public boolean startElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord, Attributes atts) {
        unmarshalRecord.removeNullCapableValue(this.nullCapableNodeValue);
        return this.choiceElementNodeValue.startElement(xPathFragment, unmarshalRecord, atts);
    }

    public void setXPathNode(XPathNode xPathNode) {
        super.setXPathNode(xPathNode);
        this.choiceElementNodeValue.setXPathNode(xPathNode);
    }
}

