/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions.factories.model.transport.naming;

import java.util.Vector;
import org.eclipse.persistence.internal.security.SecurableObjectHolder;

public class JNDINamingServiceConfig {
    private String m_url;
    private String m_username;
    private String m_encryptionClass;
    private char[] m_encryptedPassword;
    private SecurableObjectHolder m_securableObjectHolder = new SecurableObjectHolder();
    private String m_initialContextFactoryName;
    private Vector m_propertyConfigs;

    public void setURL(String url) {
        this.m_url = url;
    }

    public String getURL() {
        return this.m_url;
    }

    public void setUsername(String username) {
        this.m_username = username;
    }

    public String getUsername() {
        return this.m_username;
    }

    public void setEncryptionClass(String encryptionClass) {
        this.m_encryptionClass = encryptionClass;
        this.m_securableObjectHolder.setEncryptionClassName(this.m_encryptionClass);
    }

    public String getEncryptionClass() {
        return this.m_encryptionClass;
    }

    public void setPassword(String password) {
        String passwordString = this.m_securableObjectHolder.getSecurableObject().encryptPassword(password);
        this.m_encryptedPassword = (char[])(passwordString != null ? passwordString.toCharArray() : null);
    }

    public void setEncryptedPassword(String encryptedPassword) {
        this.m_encryptedPassword = (char[])(encryptedPassword != null ? encryptedPassword.toCharArray() : null);
    }

    public String getPassword() {
        String decryptedPassword = null;
        if (this.m_encryptedPassword != null) {
            String passwordString = new String(this.m_encryptedPassword);
            decryptedPassword = this.m_securableObjectHolder.getSecurableObject().decryptPassword(passwordString);
            if (decryptedPassword.equals(passwordString)) {
                this.setPassword(decryptedPassword);
            }
        }
        return decryptedPassword;
    }

    public String getEncryptedPassword() {
        if (this.m_encryptedPassword != null) {
            return new String(this.m_encryptedPassword);
        }
        return null;
    }

    public void setInitialContextFactoryName(String initialContextFactoryName) {
        this.m_initialContextFactoryName = initialContextFactoryName;
    }

    public String getInitialContextFactoryName() {
        return this.m_initialContextFactoryName;
    }

    public void setPropertyConfigs(Vector propertyConfigs) {
        this.m_propertyConfigs = propertyConfigs;
    }

    public Vector getPropertyConfigs() {
        return this.m_propertyConfigs;
    }
}

