/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.dynamic;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.exceptions.DynamicException;
import org.eclipse.persistence.internal.dynamic.DynamicEntityImpl;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.libraries.asm.Attribute;
import org.eclipse.persistence.internal.libraries.asm.ClassWriter;
import org.eclipse.persistence.internal.libraries.asm.CodeVisitor;
import org.eclipse.persistence.internal.libraries.asm.Type;
import org.eclipse.persistence.internal.libraries.asm.attrs.SignatureAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicClassWriter {
    protected Class<?> parentClass;
    protected String parentClassName;
    protected static final String INIT = "<init>";
    private static final String WRITE_REPLACE = "writeReplace";
    static int[] ICONST = new int[]{3, 4, 5, 6, 7, 8};

    public DynamicClassWriter() {
        this(DynamicEntityImpl.class);
    }

    public DynamicClassWriter(Class<?> parentClass) {
        this.parentClass = parentClass;
    }

    public DynamicClassWriter(String parentClassName) {
        if (parentClassName == null || parentClassName.length() == 0) {
            throw DynamicException.illegalParentClassName(parentClassName);
        }
        this.parentClassName = parentClassName;
    }

    public Class<?> getParentClass() {
        return this.parentClass;
    }

    public String getParentClassName() {
        return this.parentClassName;
    }

    public byte[] writeClass(DynamicClassLoader loader, String className) throws ClassNotFoundException {
        Class<?> parent;
        DynamicClassLoader.EnumInfo enumInfo = loader.enumInfoRegistry.get(className);
        if (enumInfo != null) {
            return this.createEnum(enumInfo);
        }
        if (this.parentClass == null && this.parentClassName != null) {
            this.parentClass = loader.loadClass(this.parentClassName);
        }
        if ((parent = this.getParentClass()) == null || parent.isPrimitive() || parent.isArray() || parent.isEnum() || parent.isInterface() || Modifier.isFinal(parent.getModifiers())) {
            throw new IllegalArgumentException("Invalid parent class: " + parent);
        }
        ClassWriter cw = new ClassWriter(true);
        cw.visit(49, 33, className.replace('.', '/'), Type.getType(parent).getInternalName(), this.getInterfaces(), null);
        this.addFields(cw);
        this.addConstructors(cw);
        this.addMethods(cw);
        this.addWriteReplace(cw);
        cw.visitEnd();
        return cw.toByteArray();
    }

    protected String[] getInterfaces() {
        return null;
    }

    protected void addConstructors(ClassWriter cw) {
        Constructor<?>[] constructors = this.getParentClass().getDeclaredConstructors();
        for (int index = 0; index < constructors.length; ++index) {
            if (!Modifier.isPublic(constructors[index].getModifiers()) && !Modifier.isProtected(constructors[index].getModifiers())) continue;
            this.addConstructor(cw, constructors[index]);
        }
    }

    protected void addConstructor(ClassWriter cw, Constructor<?> constructor) {
        Type[] types = new Type[constructor.getParameterTypes().length];
        for (int index = 0; index < constructor.getParameterTypes().length; ++index) {
            types[index] = Type.getType(constructor.getParameterTypes()[index]);
        }
        String consDesc = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])types);
        CodeVisitor mv = cw.visitMethod(1, INIT, consDesc, null, null);
        mv.visitVarInsn(25, 0);
        for (int param = 1; param <= constructor.getParameterTypes().length; ++param) {
            mv.visitVarInsn(25, param);
        }
        mv.visitMethodInsn(183, Type.getType(constructor.getDeclaringClass()).getInternalName(), INIT, consDesc);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
    }

    protected void addWriteReplace(ClassWriter cw) {
        boolean parentHasWriteReplace = false;
        try {
            this.getParentClass().getDeclaredMethod(WRITE_REPLACE, new Class[0]);
            parentHasWriteReplace = true;
        }
        catch (NoSuchMethodException e) {
            parentHasWriteReplace = false;
        }
        if (Serializable.class.isAssignableFrom(this.getParentClass()) && parentHasWriteReplace) {
            Method method;
            try {
                method = this.getParentClass().getDeclaredMethod(WRITE_REPLACE, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                return;
            }
            String methodDesc = Type.getMethodDescriptor((Method)method);
            String[] exceptionsDesc = new String[]{Type.getType(ObjectStreamException.class).getInternalName()};
            CodeVisitor mv = cw.visitMethod(4, method.getName(), methodDesc, exceptionsDesc, null);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, Type.getInternalName(this.getParentClass()), method.getName(), methodDesc);
            mv.visitInsn(176);
            mv.visitMaxs(0, 0);
        }
    }

    protected byte[] createEnum(DynamicClassLoader.EnumInfo enumInfo) {
        String enumValue2;
        String[] enumValues = enumInfo.getLiteralLabels();
        String className = enumInfo.getClassName();
        String internalClassName = className.replace('.', '/');
        ClassWriter cw = new ClassWriter(true);
        cw.visit(49, 16433, internalClassName, "java/lang/Enum", null, null);
        for (String enumValue2 : enumValues) {
            cw.visitField(16409, enumValue2, "L" + internalClassName + ";", null, null);
        }
        cw.visitField(4122, "$VALUES", "[L" + internalClassName + ";", null, null);
        CodeVisitor cv = cw.visitMethod(9, "values", "()[L" + internalClassName + ";", null, null);
        cv.visitFieldInsn(178, internalClassName, "$VALUES", "[L" + internalClassName + ";");
        cv.visitMethodInsn(182, "[L" + internalClassName + ";", "clone", "()Ljava/lang/Object;");
        cv.visitTypeInsn(192, "[L" + internalClassName + ";");
        cv.visitInsn(176);
        cv.visitMaxs(1, 0);
        cv = cw.visitMethod(9, "valueOf", "(Ljava/lang/String;)L" + internalClassName + ";", null, null);
        cv.visitLdcInsn((Object)Type.getType((String)("L" + internalClassName + ";")));
        cv.visitVarInsn(25, 0);
        cv.visitMethodInsn(184, "java/lang/Enum", "valueOf", "(Ljava/lang/Class;Ljava/lang/String;)Ljava/lang/Enum;");
        cv.visitTypeInsn(192, internalClassName);
        cv.visitInsn(176);
        cv.visitMaxs(2, 1);
        SignatureAttribute methodAttrs1 = new SignatureAttribute("()V");
        cv = cw.visitMethod(2, INIT, "(Ljava/lang/String;I)V", null, (Attribute)methodAttrs1);
        cv.visitVarInsn(25, 0);
        cv.visitVarInsn(25, 1);
        cv.visitVarInsn(21, 2);
        cv.visitMethodInsn(183, "java/lang/Enum", INIT, "(Ljava/lang/String;I)V");
        cv.visitInsn(177);
        cv.visitMaxs(3, 3);
        cv = cw.visitMethod(8, "<clinit>", "()V", null, null);
        int lastCount = 0;
        int i = 0;
        while (i < enumValues.length) {
            enumValue2 = enumValues[i];
            cv.visitTypeInsn(187, internalClassName);
            cv.visitInsn(89);
            cv.visitLdcInsn((Object)enumValue2);
            if (i <= 5) {
                cv.visitInsn(ICONST[i]);
            } else {
                cv.visitIntInsn(16, i);
            }
            cv.visitMethodInsn(183, internalClassName, INIT, "(Ljava/lang/String;I)V");
            cv.visitFieldInsn(179, internalClassName, enumValue2, "L" + internalClassName + ";");
            lastCount = i++;
        }
        if (lastCount <= 5) {
            cv.visitInsn(ICONST[lastCount + 1]);
        } else {
            cv.visitIntInsn(16, lastCount + 1);
        }
        cv.visitTypeInsn(189, internalClassName);
        for (i = 0; i < enumValues.length; ++i) {
            enumValue2 = enumValues[i];
            cv.visitInsn(89);
            if (i <= 5) {
                cv.visitInsn(ICONST[i]);
            } else {
                cv.visitIntInsn(16, i);
            }
            cv.visitFieldInsn(178, internalClassName, enumValue2, "L" + internalClassName + ";");
            cv.visitInsn(83);
        }
        cv.visitFieldInsn(179, internalClassName, "$VALUES", "[L" + internalClassName + ";");
        cv.visitInsn(177);
        cv.visitMaxs(4, 0);
        cw.visitEnd();
        return cw.toByteArray();
    }

    protected void addFields(ClassWriter cw) {
    }

    protected void addMethods(ClassWriter cw) {
    }

    protected DynamicClassWriter createCopy(Class<?> parentClass) {
        return new DynamicClassWriter(parentClass);
    }

    protected boolean isCompatible(DynamicClassWriter writer) {
        if (writer == null) {
            return false;
        }
        if (this.getClass() != writer.getClass()) {
            return false;
        }
        if (this.getParentClass() == null) {
            return this.getParentClassName() != null && this.getParentClassName().equals(writer.getParentClassName());
        }
        return this.getParentClass() == writer.getParentClass();
    }

    public String toString() {
        String parentName = this.getParentClass() == null ? this.getParentClassName() : this.getParentClass().getName();
        return Helper.getShortClassName(this.getClass()) + "(" + parentName + ")";
    }
}

