/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.annotations.Converter;
import org.eclipse.persistence.annotations.Converters;
import org.eclipse.persistence.annotations.HashPartitioning;
import org.eclipse.persistence.annotations.ObjectTypeConverter;
import org.eclipse.persistence.annotations.ObjectTypeConverters;
import org.eclipse.persistence.annotations.Partitioned;
import org.eclipse.persistence.annotations.Partitioning;
import org.eclipse.persistence.annotations.PinnedPartitioning;
import org.eclipse.persistence.annotations.RangePartitioning;
import org.eclipse.persistence.annotations.ReplicationPartitioning;
import org.eclipse.persistence.annotations.RoundRobinPartitioning;
import org.eclipse.persistence.annotations.StructConverter;
import org.eclipse.persistence.annotations.StructConverters;
import org.eclipse.persistence.annotations.TypeConverter;
import org.eclipse.persistence.annotations.TypeConverters;
import org.eclipse.persistence.annotations.UnionPartitioning;
import org.eclipse.persistence.annotations.ValuePartitioning;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.PropertyMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotatedElement;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.columns.PrimaryKeyJoinColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.PrimaryKeyJoinColumnsMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.ConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.ObjectTypeConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.StructConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.TypeConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.mappings.AccessMethodsMetadata;
import org.eclipse.persistence.internal.jpa.metadata.partitioning.HashPartitioningMetadata;
import org.eclipse.persistence.internal.jpa.metadata.partitioning.PartitioningMetadata;
import org.eclipse.persistence.internal.jpa.metadata.partitioning.PinnedPartitioningMetadata;
import org.eclipse.persistence.internal.jpa.metadata.partitioning.RangePartitioningMetadata;
import org.eclipse.persistence.internal.jpa.metadata.partitioning.ReplicationPartitioningMetadata;
import org.eclipse.persistence.internal.jpa.metadata.partitioning.RoundRobinPartitioningMetadata;
import org.eclipse.persistence.internal.jpa.metadata.partitioning.UnionPartitioningMetadata;
import org.eclipse.persistence.internal.jpa.metadata.partitioning.ValuePartitioningMetadata;
import org.eclipse.persistence.internal.jpa.metadata.tables.TableMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MetadataAccessor
extends ORMetadata {
    private AccessMethodsMetadata m_accessMethods;
    private List<ConverterMetadata> m_converters = new ArrayList<ConverterMetadata>();
    private List<ObjectTypeConverterMetadata> m_objectTypeConverters = new ArrayList<ObjectTypeConverterMetadata>();
    private List<StructConverterMetadata> m_structConverters = new ArrayList<StructConverterMetadata>();
    private List<TypeConverterMetadata> m_typeConverters = new ArrayList<TypeConverterMetadata>();
    private List<PropertyMetadata> m_properties = new ArrayList<PropertyMetadata>();
    private MetadataDescriptor m_descriptor;
    private MetadataProject m_project;
    protected PartitioningMetadata partitioning;
    protected ReplicationPartitioningMetadata replicationPartitioning;
    protected RoundRobinPartitioningMetadata roundRobinPartitioning;
    protected PinnedPartitioningMetadata pinnedPartitioning;
    protected RangePartitioningMetadata rangePartitioning;
    protected ValuePartitioningMetadata valuePartitioning;
    protected UnionPartitioningMetadata unionPartitioning;
    protected HashPartitioningMetadata hashPartitioning;
    protected String partitioned;
    private String m_access;
    private String m_name;

    public MetadataAccessor(String xmlElement) {
        super(xmlElement);
    }

    public MetadataAccessor(MetadataAnnotation annotation, MetadataAccessibleObject accessibleObject, MetadataDescriptor descriptor, MetadataProject project) {
        super(annotation, accessibleObject);
        this.m_project = project;
        this.setDescriptor(descriptor);
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof MetadataAccessor) {
            MetadataAccessor accessor = (MetadataAccessor)objectToCompare;
            if (!this.valuesMatch(this.m_accessMethods, accessor.getAccessMethods())) {
                return false;
            }
            if (!this.valuesMatch(this.m_converters, accessor.getConverters())) {
                return false;
            }
            if (!this.valuesMatch(this.m_objectTypeConverters, accessor.getObjectTypeConverters())) {
                return false;
            }
            if (!this.valuesMatch(this.m_structConverters, accessor.getStructConverters())) {
                return false;
            }
            if (!this.valuesMatch(this.m_typeConverters, accessor.getTypeConverters())) {
                return false;
            }
            if (!this.valuesMatch(this.m_properties, accessor.getProperties())) {
                return false;
            }
            if (!this.valuesMatch(this.m_access, accessor.getAccess())) {
                return false;
            }
            return this.valuesMatch(this.m_name, accessor.getName());
        }
        return false;
    }

    public String getAccess() {
        return this.m_access;
    }

    @Override
    public MetadataAnnotatedElement getAccessibleObject() {
        return (MetadataAnnotatedElement)super.getAccessibleObject();
    }

    public String getAccessibleObjectName() {
        return this.getAccessibleObject().getName();
    }

    public AccessMethodsMetadata getAccessMethods() {
        return this.m_accessMethods;
    }

    public MetadataAnnotatedElement getAnnotatedElement() {
        return this.getAccessibleObject();
    }

    public String getAnnotatedElementName() {
        return this.getAnnotatedElement().toString();
    }

    protected MetadataAnnotation getAnnotation(Class annotation) {
        return this.getAnnotation(annotation.getName());
    }

    protected abstract MetadataAnnotation getAnnotation(String var1);

    public String getAttributeName() {
        return this.getAccessibleObject().getAttributeName();
    }

    public List<ConverterMetadata> getConverters() {
        return this.m_converters;
    }

    public MetadataDescriptor getDescriptor() {
        return this.m_descriptor;
    }

    public MetadataClass getDescriptorJavaClass() {
        return this.m_descriptor.getJavaClass();
    }

    @Override
    public String getIdentifier() {
        return this.getName();
    }

    public MetadataClass getJavaClass() {
        return this.m_descriptor.getJavaClass();
    }

    protected String getJavaClassName() {
        return this.getJavaClass().getName();
    }

    public MetadataLogger getLogger() {
        return this.m_project.getLogger();
    }

    public String getName() {
        return this.m_name;
    }

    protected String getName(String name, String defaultName, String context) {
        return MetadataHelper.getName(name, defaultName, context, this.getLogger(), this.getAnnotatedElementName());
    }

    public List<ObjectTypeConverterMetadata> getObjectTypeConverters() {
        return this.m_objectTypeConverters;
    }

    public MetadataProject getProject() {
        return this.m_project;
    }

    public List<PropertyMetadata> getProperties() {
        return this.m_properties;
    }

    protected DatabaseField getReferencedField(String referencedColumnName, MetadataDescriptor referenceDescriptor, String context) {
        return this.getReferencedField(referencedColumnName, referenceDescriptor, context, false);
    }

    protected DatabaseField getReferencedField(String referencedColumnName, MetadataDescriptor referenceDescriptor, String context, boolean isForAggregateCollection) {
        DatabaseField referenceField;
        if (referencedColumnName == null || referencedColumnName.equals("")) {
            referenceField = referenceDescriptor.getPrimaryKeyField();
            if (referenceDescriptor.isInheritanceSubclass() && isForAggregateCollection) {
                referenceField = referenceDescriptor.getPrimaryKeyJoinColumnAssociationField(referenceField);
            }
            this.getLogger().logConfigMessage(context, this.getAnnotatedElementName(), (Object)referenceField.getName());
        } else {
            referenceField = referenceDescriptor.getField(referencedColumnName);
            if (referenceField == null) {
                DatabaseField lookupField = new DatabaseField();
                this.setFieldName(lookupField, referencedColumnName);
                referenceField = referenceDescriptor.getField(lookupField.getNameForComparisons());
                if (referenceField == null) {
                    if (referenceDescriptor.isMappedSuperclass()) {
                        referenceField = lookupField;
                        referenceField.setTable(referenceDescriptor.getPrimaryKeyTable());
                    } else {
                        throw ValidationException.invalidReferenceColumnName((String)referencedColumnName, (Object)this.getAnnotatedElement());
                    }
                }
            }
        }
        return referenceField;
    }

    public List<StructConverterMetadata> getStructConverters() {
        return this.m_structConverters;
    }

    public List<TypeConverterMetadata> getTypeConverters() {
        return this.m_typeConverters;
    }

    protected String getDefaultAttributeName() {
        return this.m_project.useDelimitedIdentifier() ? this.getAttributeName() : this.getAttributeName().toUpperCase();
    }

    protected String getUpperCaseShortJavaClassName() {
        return Helper.getShortClassName((String)this.getJavaClassName()).toUpperCase();
    }

    protected Integer getValue(Integer value, Integer defaultValue) {
        return MetadataHelper.getValue(value, defaultValue);
    }

    protected String getValue(String value, String defaultValue) {
        return MetadataHelper.getValue(value, defaultValue);
    }

    public boolean hasAccess() {
        return this.m_access != null;
    }

    public boolean hasAccessMethods() {
        return this.m_accessMethods != null;
    }

    public void initAccess() {
        MetadataAnnotation access;
        if (this.m_access == null && (access = this.getAnnotation("javax.persistence.Access")) != null) {
            this.setAccess((String)access.getAttribute("value"));
        }
    }

    public void initXMLAccessor(MetadataDescriptor descriptor, MetadataProject project) {
        this.m_project = project;
        this.setDescriptor(descriptor);
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.initXMLObject(this.m_accessMethods, accessibleObject);
        this.initXMLObject(this.partitioning, accessibleObject);
        this.initXMLObject(this.replicationPartitioning, accessibleObject);
        this.initXMLObject(this.roundRobinPartitioning, accessibleObject);
        this.initXMLObject(this.pinnedPartitioning, accessibleObject);
        this.initXMLObject(this.rangePartitioning, accessibleObject);
        this.initXMLObject(this.valuePartitioning, accessibleObject);
        this.initXMLObject(this.hashPartitioning, accessibleObject);
        this.initXMLObject(this.unionPartitioning, accessibleObject);
        this.initXMLObjects(this.m_converters, accessibleObject);
        this.initXMLObjects(this.m_objectTypeConverters, accessibleObject);
        this.initXMLObjects(this.m_structConverters, accessibleObject);
        this.initXMLObjects(this.m_typeConverters, accessibleObject);
        this.initXMLObjects(this.m_properties, accessibleObject);
    }

    protected abstract boolean isAnnotationPresent(Class<? extends Annotation> var1);

    public abstract boolean isProcessed();

    @Override
    public void merge(ORMetadata metadata) {
        MetadataAccessor accessor = (MetadataAccessor)metadata;
        this.m_access = (String)this.mergeSimpleObjects(this.m_access, accessor.getAccess(), accessor, "@access");
        this.m_accessMethods = (AccessMethodsMetadata)this.mergeORObjects(this.m_accessMethods, accessor.getAccessMethods());
        this.m_converters = this.mergeORObjectLists(this.m_converters, accessor.getConverters());
        this.m_objectTypeConverters = this.mergeORObjectLists(this.m_objectTypeConverters, accessor.getObjectTypeConverters());
        this.m_structConverters = this.mergeORObjectLists(this.m_structConverters, accessor.getStructConverters());
        this.m_typeConverters = this.mergeORObjectLists(this.m_typeConverters, accessor.getTypeConverters());
        this.m_properties = this.mergeORObjectLists(this.m_properties, accessor.getProperties());
        this.partitioned = (String)this.mergeSimpleObjects(this.partitioned, accessor.getPartitioned(), accessor, "<partitioned>");
        this.partitioning = (PartitioningMetadata)this.mergeORObjects(this.partitioning, accessor.getPartitioning());
        this.replicationPartitioning = (ReplicationPartitioningMetadata)this.mergeORObjects(this.replicationPartitioning, accessor.getReplicationPartitioning());
        this.roundRobinPartitioning = (RoundRobinPartitioningMetadata)this.mergeORObjects(this.roundRobinPartitioning, accessor.getRoundRobinPartitioning());
        this.pinnedPartitioning = (PinnedPartitioningMetadata)this.mergeORObjects(this.pinnedPartitioning, accessor.getPinnedPartitioning());
        this.rangePartitioning = (RangePartitioningMetadata)this.mergeORObjects(this.rangePartitioning, accessor.getRangePartitioning());
        this.valuePartitioning = (ValuePartitioningMetadata)this.mergeORObjects(this.valuePartitioning, accessor.getValuePartitioning());
        this.hashPartitioning = (HashPartitioningMetadata)this.mergeORObjects(this.hashPartitioning, accessor.getHashPartitioning());
        this.unionPartitioning = (UnionPartitioningMetadata)this.mergeORObjects(this.unionPartitioning, accessor.getUnionPartitioning());
    }

    public abstract void process();

    public void processConverters() {
        this.processCustomConverters();
        this.processObjectTypeConverters();
        this.processTypeConverters();
        this.processStructConverters();
    }

    protected void processCustomConverters() {
        MetadataAnnotation metadataAnnotation;
        for (ConverterMetadata converterMetadata : this.m_converters) {
            this.m_project.addConverter(converterMetadata);
        }
        MetadataAnnotation converters = this.getAnnotation(Converters.class);
        if (converters != null) {
            for (Object converter3 : (Object[])converters.getAttributeArray("value")) {
                this.m_project.addConverter(new ConverterMetadata((MetadataAnnotation)converter3, this.getAccessibleObject()));
            }
        }
        if ((metadataAnnotation = this.getAnnotation(Converter.class)) != null) {
            this.m_project.addConverter(new ConverterMetadata(metadataAnnotation, this.getAccessibleObject()));
        }
    }

    protected void processObjectTypeConverters() {
        MetadataAnnotation metadataAnnotation;
        for (ObjectTypeConverterMetadata objectTypeConverterMetadata : this.m_objectTypeConverters) {
            this.m_project.addConverter(objectTypeConverterMetadata);
        }
        MetadataAnnotation objectTypeConverters = this.getAnnotation(ObjectTypeConverters.class);
        if (objectTypeConverters != null) {
            for (Object objectTypeConverter3 : (Object[])objectTypeConverters.getAttributeArray("value")) {
                this.m_project.addConverter(new ObjectTypeConverterMetadata((MetadataAnnotation)objectTypeConverter3, this.getAccessibleObject()));
            }
        }
        if ((metadataAnnotation = this.getAnnotation(ObjectTypeConverter.class)) != null) {
            this.m_project.addConverter(new ObjectTypeConverterMetadata(metadataAnnotation, this.getAccessibleObject()));
        }
    }

    protected List<PrimaryKeyJoinColumnMetadata> processPrimaryKeyJoinColumns(PrimaryKeyJoinColumnsMetadata primaryKeyJoinColumns) {
        List<PrimaryKeyJoinColumnMetadata> pkJoinColumns = primaryKeyJoinColumns.values(this.m_descriptor);
        if (this.m_descriptor.hasCompositePrimaryKey()) {
            if (pkJoinColumns.size() != this.m_descriptor.getPrimaryKeyFields().size()) {
                throw ValidationException.incompletePrimaryKeyJoinColumnsSpecified((Object)this.getAnnotatedElement());
            }
            for (PrimaryKeyJoinColumnMetadata pkJoinColumn : pkJoinColumns) {
                if (!pkJoinColumn.isPrimaryKeyFieldNotSpecified() && !pkJoinColumn.isForeignKeyFieldNotSpecified()) continue;
                throw ValidationException.incompletePrimaryKeyJoinColumnsSpecified((Object)this.getAnnotatedElement());
            }
        } else if (pkJoinColumns.size() > 1) {
            throw ValidationException.excessivePrimaryKeyJoinColumnsSpecified((Object)this.getAnnotatedElement());
        }
        return pkJoinColumns;
    }

    protected void processStructConverters() {
        MetadataAnnotation converter;
        for (StructConverterMetadata structConverter : this.m_structConverters) {
            this.m_project.addConverter(structConverter);
        }
        MetadataAnnotation structConverters = this.getAnnotation(StructConverters.class);
        if (structConverters != null) {
            for (Object structConverter : (Object[])structConverters.getAttributeArray("value")) {
                this.m_project.addConverter(new StructConverterMetadata((MetadataAnnotation)structConverter, this.getAccessibleObject()));
            }
        }
        if ((converter = this.getAnnotation(StructConverter.class)) != null) {
            this.m_project.addConverter(new StructConverterMetadata(converter, this.getAccessibleObject()));
        }
    }

    protected void processTable(TableMetadata table, String defaultName) {
        this.getProject().processTable(table, defaultName, this.m_descriptor.getDefaultCatalog(), this.m_descriptor.getDefaultSchema());
    }

    protected void processTypeConverters() {
        MetadataAnnotation metadataAnnotation;
        for (TypeConverterMetadata typeConverterMetadata : this.m_typeConverters) {
            this.m_project.addConverter(typeConverterMetadata);
        }
        MetadataAnnotation typeConverters = this.getAnnotation(TypeConverters.class);
        if (typeConverters != null) {
            for (Object typeConverter3 : (Object[])typeConverters.getAttributeArray("value")) {
                this.m_project.addConverter(new TypeConverterMetadata((MetadataAnnotation)typeConverter3, this.getAccessibleObject()));
            }
        }
        if ((metadataAnnotation = this.getAnnotation(TypeConverter.class)) != null) {
            this.m_project.addConverter(new TypeConverterMetadata(metadataAnnotation, this.getAccessibleObject()));
        }
    }

    public void setAccess(String access) {
        this.m_access = access;
    }

    public void setAccessMethods(AccessMethodsMetadata accessMethods) {
        this.m_accessMethods = accessMethods;
    }

    public void setConverters(List<ConverterMetadata> converters) {
        this.m_converters = converters;
    }

    public void setDescriptor(MetadataDescriptor descriptor) {
        this.m_descriptor = descriptor;
    }

    public void setFieldName(DatabaseField field, String name) {
        field.setName(name, Helper.getDefaultStartDatabaseDelimiter(), Helper.getDefaultEndDatabaseDelimiter());
        if (this.m_project.useDelimitedIdentifier()) {
            field.setUseDelimiters(true);
        } else if (this.m_project.getShouldForceFieldNamesToUpperCase() && !field.shouldUseDelimiters()) {
            field.useUpperCaseForComparisons(true);
        }
    }

    public void setFieldName(DatabaseField field, String defaultName, String context) {
        this.setFieldName(field, this.getName(field.getName(), defaultName, context));
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setObjectTypeConverters(List<ObjectTypeConverterMetadata> objectTypeConverters) {
        this.m_objectTypeConverters = objectTypeConverters;
    }

    public void setProperties(List<PropertyMetadata> properties) {
        this.m_properties = properties;
    }

    public void setStructConverters(List<StructConverterMetadata> structConverters) {
        this.m_structConverters = structConverters;
    }

    public void setTypeConverters(List<TypeConverterMetadata> typeConverters) {
        this.m_typeConverters = typeConverters;
    }

    protected void processPartitioning() {
        MetadataAnnotation annotation;
        boolean found = false;
        if (this.replicationPartitioning != null) {
            found = true;
            this.m_project.addPartitioningPolicy(this.replicationPartitioning);
        }
        if (this.roundRobinPartitioning != null) {
            found = true;
            this.m_project.addPartitioningPolicy(this.roundRobinPartitioning);
        }
        if (this.partitioning != null) {
            found = true;
            this.m_project.addPartitioningPolicy(this.partitioning);
        }
        if (this.rangePartitioning != null) {
            found = true;
            this.m_project.addPartitioningPolicy(this.rangePartitioning);
        }
        if (this.valuePartitioning != null) {
            found = true;
            this.m_project.addPartitioningPolicy(this.valuePartitioning);
        }
        if (this.hashPartitioning != null) {
            found = true;
            this.m_project.addPartitioningPolicy(this.hashPartitioning);
        }
        if (this.unionPartitioning != null) {
            found = true;
            this.m_project.addPartitioningPolicy(this.unionPartitioning);
        }
        if (this.pinnedPartitioning != null) {
            found = true;
            this.m_project.addPartitioningPolicy(this.pinnedPartitioning);
        }
        if ((annotation = this.getAnnotation(Partitioning.class)) != null) {
            found = true;
            this.m_project.addPartitioningPolicy(new PartitioningMetadata(annotation, this.getAccessibleObject()));
        }
        if ((annotation = this.getAnnotation(ReplicationPartitioning.class)) != null) {
            found = true;
            this.m_project.addPartitioningPolicy(new ReplicationPartitioningMetadata(annotation, this.getAccessibleObject()));
        }
        if ((annotation = this.getAnnotation(RoundRobinPartitioning.class)) != null) {
            found = true;
            this.m_project.addPartitioningPolicy(new RoundRobinPartitioningMetadata(annotation, this.getAccessibleObject()));
        }
        if ((annotation = this.getAnnotation(UnionPartitioning.class)) != null) {
            found = true;
            this.m_project.addPartitioningPolicy(new UnionPartitioningMetadata(annotation, this.getAccessibleObject()));
        }
        if ((annotation = this.getAnnotation(RangePartitioning.class)) != null) {
            found = true;
            this.m_project.addPartitioningPolicy(new RangePartitioningMetadata(annotation, this.getAccessibleObject()));
        }
        if ((annotation = this.getAnnotation(ValuePartitioning.class)) != null) {
            found = true;
            this.m_project.addPartitioningPolicy(new ValuePartitioningMetadata(annotation, this.getAccessibleObject()));
        }
        if ((annotation = this.getAnnotation(ValuePartitioning.class)) != null) {
            found = true;
            this.m_project.addPartitioningPolicy(new ValuePartitioningMetadata(annotation, this.getAccessibleObject()));
        }
        if ((annotation = this.getAnnotation(PinnedPartitioning.class)) != null) {
            found = true;
            this.m_project.addPartitioningPolicy(new PinnedPartitioningMetadata(annotation, this.getAccessibleObject()));
        }
        if ((annotation = this.getAnnotation(HashPartitioning.class)) != null) {
            found = true;
            this.m_project.addPartitioningPolicy(new HashPartitioningMetadata(annotation, this.getAccessibleObject()));
        }
        boolean processed = false;
        if (this.partitioned != null) {
            processed = true;
            this.processPartitioned(this.partitioned);
        }
        annotation = this.getAnnotation(Partitioned.class);
        if (!processed && annotation != null) {
            processed = true;
            this.processPartitioned((String)annotation.getAttribute("value"));
        }
        if (found && !processed) {
            this.getLogger().logWarningMessage("metadata_warning_partitioned_not_set", this.getJavaClass(), this.getAccessibleObject());
        }
    }

    public void processPartitioned(String name) {
        if (this instanceof ClassAccessor) {
            if (this.getDescriptor().getClassDescriptor().getPartitioningPolicy() != null) {
                this.getLogger().logConfigMessage("metadata_warning_ignore_mapped_superclass_annotation", Partitioned.class, (Object)this.getJavaClass(), (Object)this.getDescriptor().getJavaClass());
            }
            this.getDescriptor().getClassDescriptor().setPartitioningPolicyName(name);
        } else if (this instanceof MappingAccessor) {
            ((ForeignReferenceMapping)((MappingAccessor)this).getMapping()).setPartitioningPolicyName(name);
        }
    }

    public PartitioningMetadata getPartitioning() {
        return this.partitioning;
    }

    public void setPartitioning(PartitioningMetadata partitioning) {
        this.partitioning = partitioning;
    }

    public RangePartitioningMetadata getRangePartitioning() {
        return this.rangePartitioning;
    }

    public void setRangePartitioning(RangePartitioningMetadata rangePartitioning) {
        this.rangePartitioning = rangePartitioning;
    }

    public ValuePartitioningMetadata getValuePartitioning() {
        return this.valuePartitioning;
    }

    public void setValuePartitioning(ValuePartitioningMetadata valuePartitioning) {
        this.valuePartitioning = valuePartitioning;
    }

    public UnionPartitioningMetadata getUnionPartitioning() {
        return this.unionPartitioning;
    }

    public void setUnionPartitioning(UnionPartitioningMetadata unionPartitioning) {
        this.unionPartitioning = unionPartitioning;
    }

    public ReplicationPartitioningMetadata getReplicationPartitioning() {
        return this.replicationPartitioning;
    }

    public void setReplicationPartitioning(ReplicationPartitioningMetadata replicationPartitioning) {
        this.replicationPartitioning = replicationPartitioning;
    }

    public RoundRobinPartitioningMetadata getRoundRobinPartitioning() {
        return this.roundRobinPartitioning;
    }

    public void setRoundRobinPartitioning(RoundRobinPartitioningMetadata roundRobinPartitioning) {
        this.roundRobinPartitioning = roundRobinPartitioning;
    }

    public HashPartitioningMetadata getHashPartitioning() {
        return this.hashPartitioning;
    }

    public void setHashPartitioning(HashPartitioningMetadata hashPartitioning) {
        this.hashPartitioning = hashPartitioning;
    }

    public PinnedPartitioningMetadata getPinnedPartitioning() {
        return this.pinnedPartitioning;
    }

    public void setPinnedPartitioning(PinnedPartitioningMetadata pinnedPartitioning) {
        this.pinnedPartitioning = pinnedPartitioning;
    }

    public String getPartitioned() {
        return this.partitioned;
    }

    public void setPartitioned(String partitioned) {
        this.partitioned = partitioned;
    }
}

