/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.partitioning;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.descriptors.partitioning.PartitioningPolicy;
import org.eclipse.persistence.descriptors.partitioning.ValuePartitioningPolicy;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.partitioning.FieldPartitioningMetadata;
import org.eclipse.persistence.internal.jpa.metadata.partitioning.ValuePartitionMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValuePartitioningMetadata
extends FieldPartitioningMetadata {
    protected List<ValuePartitionMetadata> partitions;
    protected String defaultConnectionPool;

    public ValuePartitioningMetadata() {
        super("<value-partitioning>");
    }

    public ValuePartitioningMetadata(MetadataAnnotation annotation, MetadataAccessibleObject accessibleObject) {
        super(annotation, accessibleObject);
        this.defaultConnectionPool = (String)annotation.getAttribute("defaultConnectionPool");
        this.partitions = new ArrayList<ValuePartitionMetadata>();
        for (Object partitionAnnotation : (Object[])annotation.getAttributeArray("partitions")) {
            this.partitions.add(new ValuePartitionMetadata((MetadataAnnotation)partitionAnnotation, accessibleObject));
        }
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof ValuePartitioningMetadata) {
            ValuePartitioningMetadata policy = (ValuePartitioningMetadata)objectToCompare;
            return this.valuesMatch(this.partitions, policy.getPartitions());
        }
        return false;
    }

    private Object initObject(Class type, String value) {
        return ConversionManager.getDefaultManager().convertObject((Object)value, type);
    }

    @Override
    public PartitioningPolicy buildPolicy() {
        ValuePartitioningPolicy policy = new ValuePartitioningPolicy();
        super.buildPolicy((PartitioningPolicy)policy);
        Class type = String.class;
        if (this.partitionValueType != null) {
            type = this.getJavaClass(this.getMetadataClass(this.partitionValueType));
        }
        policy.setDefaultConnectionPool(this.defaultConnectionPool);
        for (ValuePartitionMetadata partition : this.getPartitions()) {
            Object value = this.initObject(type, partition.getValue());
            if (policy.getPartitions().containsKey(value)) {
                throw ValidationException.duplicatePartitionValue((String)this.getName(), (Object)value);
            }
            policy.addPartition(value, partition.getConnectionPool());
        }
        return policy;
    }

    public List<ValuePartitionMetadata> getPartitions() {
        return this.partitions;
    }

    public void setPartitions(List<ValuePartitionMetadata> partitions) {
        this.partitions = partitions;
    }

    public String getDefaultConnectionPool() {
        return this.defaultConnectionPool;
    }

    public void setDefaultConnectionPool(String defaultConnectionPool) {
        this.defaultConnectionPool = defaultConnectionPool;
    }
}

