/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.JAXBException;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.jaxb.TypeMappingInfo;
import org.eclipse.persistence.jaxb.compiler.AnnotationsProcessor;
import org.eclipse.persistence.jaxb.compiler.EnumTypeInfo;
import org.eclipse.persistence.jaxb.compiler.JAXBMetadataLogger;
import org.eclipse.persistence.jaxb.compiler.NamespaceInfo;
import org.eclipse.persistence.jaxb.compiler.Property;
import org.eclipse.persistence.jaxb.compiler.TypeInfo;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaModelInput;
import org.eclipse.persistence.jaxb.xmlmodel.JavaAttribute;
import org.eclipse.persistence.jaxb.xmlmodel.JavaType;
import org.eclipse.persistence.jaxb.xmlmodel.XmlAbstractNullPolicy;
import org.eclipse.persistence.jaxb.xmlmodel.XmlAnyAttribute;
import org.eclipse.persistence.jaxb.xmlmodel.XmlAnyElement;
import org.eclipse.persistence.jaxb.xmlmodel.XmlAttribute;
import org.eclipse.persistence.jaxb.xmlmodel.XmlBindings;
import org.eclipse.persistence.jaxb.xmlmodel.XmlElement;
import org.eclipse.persistence.jaxb.xmlmodel.XmlElementRef;
import org.eclipse.persistence.jaxb.xmlmodel.XmlElementRefs;
import org.eclipse.persistence.jaxb.xmlmodel.XmlElements;
import org.eclipse.persistence.jaxb.xmlmodel.XmlEnum;
import org.eclipse.persistence.jaxb.xmlmodel.XmlEnumValue;
import org.eclipse.persistence.jaxb.xmlmodel.XmlInverseReference;
import org.eclipse.persistence.jaxb.xmlmodel.XmlJavaTypeAdapter;
import org.eclipse.persistence.jaxb.xmlmodel.XmlJoinNodes;
import org.eclipse.persistence.jaxb.xmlmodel.XmlMap;
import org.eclipse.persistence.jaxb.xmlmodel.XmlNsForm;
import org.eclipse.persistence.jaxb.xmlmodel.XmlProperties;
import org.eclipse.persistence.jaxb.xmlmodel.XmlRegistry;
import org.eclipse.persistence.jaxb.xmlmodel.XmlSchema;
import org.eclipse.persistence.jaxb.xmlmodel.XmlSchemaType;
import org.eclipse.persistence.jaxb.xmlmodel.XmlSchemaTypes;
import org.eclipse.persistence.jaxb.xmlmodel.XmlTransformation;
import org.eclipse.persistence.jaxb.xmlmodel.XmlTransient;
import org.eclipse.persistence.jaxb.xmlmodel.XmlValue;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLProcessor {
    private Map<String, XmlBindings> xmlBindingMap;
    private JavaModelInput jModelInput;
    private AnnotationsProcessor aProcessor;
    private JAXBMetadataLogger logger;
    private static final String COLON = ":";
    private static final String SLASH = "/";
    private static final String SELF = ".";
    private static final String OPEN_BRACKET = "[";
    private static final String JAVA_LANG_OBJECT = "java.lang.Object";
    public static final String DEFAULT = "##default";

    public XMLProcessor(Map<String, XmlBindings> bindings) {
        this.xmlBindingMap = bindings;
    }

    public void processXML(AnnotationsProcessor annotationsProcessor, JavaModelInput jModelInput, TypeMappingInfo[] typeMappingInfos, JavaClass[] originalJavaClasses) {
        XmlBindings xmlBindings;
        ArrayList<JavaClass> classesToProcess;
        this.jModelInput = jModelInput;
        this.aProcessor = annotationsProcessor;
        HashMap<String, XmlEnum> xmlEnumMap = new HashMap<String, XmlEnum>();
        annotationsProcessor.init(originalJavaClasses, typeMappingInfos);
        Map<String, ArrayList<JavaClass>> pkgToClassMap = this.buildPackageToJavaClassMap();
        for (String packageName : this.xmlBindingMap.keySet()) {
            XmlBindings.XmlRegistries xmlRegs;
            classesToProcess = pkgToClassMap.get(packageName);
            if (classesToProcess == null) {
                this.getLogger().logWarning("jaxb_metadata_warning_no_classes_to_process", new Object[]{packageName});
                continue;
            }
            xmlBindings = this.xmlBindingMap.get(packageName);
            NamespaceInfo nsInfo = this.processXmlSchema(xmlBindings, packageName);
            if (nsInfo != null) {
                annotationsProcessor.addPackageToNamespaceMapping(packageName, nsInfo);
            }
            if ((xmlRegs = xmlBindings.getXmlRegistries()) != null) {
                for (XmlRegistry xmlRegistry : xmlRegs.getXmlRegistry()) {
                    this.aProcessor.addXmlRegistry(xmlRegistry.getName(), xmlRegistry);
                }
            }
            JavaClass[] javaClasses = classesToProcess.toArray(new JavaClass[classesToProcess.size()]);
            XmlBindings.XmlEnums xmlEnums = xmlBindings.getXmlEnums();
            if (xmlEnums != null) {
                for (XmlEnum xmlEnum : xmlEnums.getXmlEnum()) {
                    xmlEnumMap.put(xmlEnum.getJavaEnum(), xmlEnum);
                }
            }
            Map<String, TypeInfo> typeInfoMap = annotationsProcessor.preBuildTypeInfo(javaClasses);
            List<XmlSchemaType> xmlSchemaTypes = null;
            XmlSchemaTypes sTypes = xmlBindings.getXmlSchemaTypes();
            xmlSchemaTypes = sTypes != null ? sTypes.getXmlSchemaType() : new ArrayList<XmlSchemaType>();
            if (xmlBindings.getXmlSchemaType() != null) {
                xmlSchemaTypes.add(xmlBindings.getXmlSchemaType());
            }
            for (XmlSchemaType sType : xmlSchemaTypes) {
                JavaClass jClass = this.aProcessor.getHelper().getJavaClass(sType.getType());
                if (jClass == null) continue;
                this.aProcessor.processSchemaType(sType.getName(), sType.getNamespace(), jClass.getQualifiedName());
            }
            nsInfo = annotationsProcessor.getPackageToNamespaceMappings().get(packageName);
            XmlBindings.JavaTypes jTypes = xmlBindings.getJavaTypes();
            if (jTypes != null) {
                for (JavaType javaType : jTypes.getJavaType()) {
                    TypeInfo info = typeInfoMap.get(javaType.getName());
                    if (javaType.getXmlJavaTypeAdapter() != null) {
                        info.setXmlJavaTypeAdapter(javaType.getXmlJavaTypeAdapter());
                    }
                    if (javaType.isSetXmlAccessorOrder()) {
                        info.setXmlAccessOrder(javaType.getXmlAccessorOrder());
                    } else if (!info.isSetXmlAccessOrder()) {
                        if (xmlBindings.isSetXmlAccessorOrder()) {
                            info.setXmlAccessOrder(xmlBindings.getXmlAccessorOrder());
                        } else {
                            info.setXmlAccessOrder(nsInfo.getAccessOrder());
                        }
                    }
                    if (javaType.isSetXmlAccessorType()) {
                        info.setXmlAccessType(javaType.getXmlAccessorType());
                    } else if (!info.isSetXmlAccessType()) {
                        if (xmlBindings.isSetXmlAccessorType()) {
                            info.setXmlAccessType(xmlBindings.getXmlAccessorType());
                        } else {
                            info.setXmlAccessType(nsInfo.getAccessType());
                        }
                    }
                    if (javaType.isSetXmlInlineBinaryData()) {
                        info.setInlineBinaryData(javaType.isXmlInlineBinaryData());
                    }
                    if (javaType.isSetXmlTransient()) {
                        info.setXmlTransient(javaType.isXmlTransient());
                    }
                    if (javaType.getXmlRootElement() != null) {
                        info.setXmlRootElement(javaType.getXmlRootElement());
                    }
                    if (javaType.getXmlSeeAlso() != null && javaType.getXmlSeeAlso().size() > 0) {
                        info.setXmlSeeAlso(javaType.getXmlSeeAlso());
                    }
                    if (javaType.getXmlType() != null) {
                        info.setXmlType(javaType.getXmlType());
                    }
                    if (javaType.getXmlCustomizer() != null) {
                        info.setXmlCustomizer(javaType.getXmlCustomizer());
                    }
                    if (javaType.getXmlClassExtractor() != null) {
                        info.setClassExtractorName(javaType.getXmlClassExtractor().getClazz());
                    }
                    if (javaType.getXmlProperties() != null && javaType.getXmlProperties().getXmlProperty().size() > 0) {
                        if (info.getUserProperties() != null) {
                            info.setUserProperties(this.mergeUserPropertyMap(javaType.getXmlProperties().getXmlProperty(), info.getUserProperties()));
                        } else {
                            info.setUserProperties(this.createUserPropertyMap(javaType.getXmlProperties().getXmlProperty()));
                        }
                    }
                    if (javaType.getXmlDiscriminatorNode() != null) {
                        info.setXmlDiscriminatorNode(javaType.getXmlDiscriminatorNode());
                    }
                    if (javaType.getXmlDiscriminatorValue() == null) continue;
                    info.setXmlDiscriminatorValue(javaType.getXmlDiscriminatorValue());
                }
            }
            if (xmlBindings.getXmlJavaTypeAdapters() == null) continue;
            Map<String, TypeInfo> typeInfos = this.aProcessor.getTypeInfosForPackage(packageName);
            for (TypeInfo tInfo : typeInfos.values()) {
                List<XmlJavaTypeAdapter> adapters = xmlBindings.getXmlJavaTypeAdapters().getXmlJavaTypeAdapter();
                for (XmlJavaTypeAdapter xja : adapters) {
                    try {
                        JavaClass adapterClass = jModelInput.getJavaModel().getClass(xja.getValue());
                        JavaClass boundType = jModelInput.getJavaModel().getClass(xja.getType());
                        if (boundType == null) continue;
                        tInfo.addPackageLevelAdapterClass(adapterClass, boundType);
                    }
                    catch (JAXBException e) {
                        throw JAXBException.invalidPackageAdapterClass((String)xja.getValue(), (String)packageName);
                    }
                }
            }
        }
        for (String packageName : this.xmlBindingMap.keySet()) {
            classesToProcess = pkgToClassMap.get(packageName);
            if (classesToProcess == null) {
                this.getLogger().logWarning("jaxb_metadata_warning_no_classes_to_process", new Object[]{packageName});
                continue;
            }
            xmlBindings = this.xmlBindingMap.get(packageName);
            JavaClass[] javaClasses = classesToProcess.toArray(new JavaClass[classesToProcess.size()]);
            javaClasses = annotationsProcessor.postBuildTypeInfo(javaClasses);
            annotationsProcessor.processJavaClasses(null);
            Map<String, TypeInfo> typeInfosForPackage = annotationsProcessor.getTypeInfosForPackage(packageName);
            for (Map.Entry entry : typeInfosForPackage.entrySet()) {
                EnumTypeInfo etInfo;
                XmlEnum xmlEnum;
                TypeInfo tInfo = (TypeInfo)entry.getValue();
                if (!tInfo.isEnumerationType() || (xmlEnum = (XmlEnum)xmlEnumMap.get((etInfo = (EnumTypeInfo)tInfo).getClassName())) == null) continue;
                JavaClass restrictionClass = this.aProcessor.getHelper().getJavaClass(xmlEnum.getValue());
                if (restrictionClass == null) {
                    restrictionClass = jModelInput.getJavaModel().getClass(String.class);
                }
                etInfo.setRestrictionBase(this.aProcessor.getSchemaTypeFor(restrictionClass));
                for (XmlEnumValue xmlEnumValue : xmlEnum.getXmlEnumValue()) {
                    etInfo.addJavaFieldToXmlEnumValuePair(true, xmlEnumValue.getJavaEnumValue(), xmlEnumValue.getValue());
                }
            }
            XmlBindings.JavaTypes jTypes = xmlBindings.getJavaTypes();
            NamespaceInfo namespaceInfo = annotationsProcessor.getPackageToNamespaceMappings().get(packageName);
            if (jTypes != null) {
                for (JavaType javaType : jTypes.getJavaType()) {
                    this.processJavaType(javaType, typeInfosForPackage.get(javaType.getName()), namespaceInfo);
                }
            }
            pkgToClassMap.remove(packageName);
        }
        for (ArrayList<JavaClass> jClassList : pkgToClassMap.values()) {
            JavaClass[] jClassArray = jClassList.toArray(new JavaClass[jClassList.size()]);
            annotationsProcessor.buildNewTypeInfo(jClassArray);
            annotationsProcessor.processJavaClasses(jClassArray);
        }
        Map typeInfos = (Map)this.aProcessor.getTypeInfo().clone();
        for (Map.Entry entry : typeInfos.entrySet()) {
            for (Property property : ((TypeInfo)entry.getValue()).getPropertyList()) {
                if (!property.isSetXmlJavaTypeAdapter()) continue;
                JavaClass[] jClassArray = new JavaClass[]{property.getActualType()};
                this.aProcessor.buildNewTypeInfo(jClassArray);
            }
        }
        ArrayList<JavaClass> jClasses = this.aProcessor.getTypeInfoClasses();
        this.aProcessor.processPropertyTypes(jClasses.toArray(new JavaClass[jClasses.size()]));
        this.aProcessor.finalizeProperties();
        this.aProcessor.createElementsForTypeMappingInfo();
    }

    private void processJavaType(JavaType javaType, TypeInfo typeInfo, NamespaceInfo nsInfo) {
        if (null != javaType.getJavaAttributes()) {
            ArrayList<String> processedPropertyNames = new ArrayList<String>();
            for (JAXBElement<? extends JavaAttribute> jaxbElement : javaType.getJavaAttributes().getJavaAttribute()) {
                JavaAttribute javaAttribute = (JavaAttribute)jaxbElement.getValue();
                Property originalProperty = typeInfo.getOriginalProperties().get(javaAttribute.getJavaAttribute());
                if (originalProperty == null) {
                    this.getLogger().logWarning("jaxb_metadata_warning_ignoring_java_attribute", new Object[]{javaAttribute.getJavaAttribute(), javaType.getName()});
                    continue;
                }
                boolean alreadyProcessed = processedPropertyNames.contains(javaAttribute.getJavaAttribute());
                Property propToProcess = alreadyProcessed ? (Property)originalProperty.clone() : typeInfo.getProperties().get(javaAttribute.getJavaAttribute());
                this.processJavaAttribute(typeInfo, javaAttribute, propToProcess, nsInfo, javaType);
                if (alreadyProcessed) {
                    List<Property> additionalProps = typeInfo.getAdditionalProperties().get(javaAttribute.getJavaAttribute());
                    if (additionalProps == null) {
                        additionalProps = new ArrayList<Property>();
                    }
                    additionalProps.add(propToProcess);
                    typeInfo.getAdditionalProperties().put(javaAttribute.getJavaAttribute(), additionalProps);
                    continue;
                }
                typeInfo.getProperties().put(javaAttribute.getJavaAttribute(), propToProcess);
                processedPropertyNames.add(javaAttribute.getJavaAttribute());
            }
        }
    }

    private Property processJavaAttribute(TypeInfo typeInfo, JavaAttribute javaAttribute, Property oldProperty, NamespaceInfo nsInfo, JavaType javaType) {
        if (javaAttribute instanceof XmlAnyAttribute) {
            return this.processXmlAnyAttribute((XmlAnyAttribute)javaAttribute, oldProperty, typeInfo, javaType);
        }
        if (javaAttribute instanceof XmlAnyElement) {
            return this.processXmlAnyElement((XmlAnyElement)javaAttribute, oldProperty, typeInfo, javaType);
        }
        if (javaAttribute instanceof XmlAttribute) {
            return this.processXmlAttribute((XmlAttribute)javaAttribute, oldProperty, typeInfo, nsInfo);
        }
        if (javaAttribute instanceof XmlElement) {
            return this.processXmlElement((XmlElement)javaAttribute, oldProperty, typeInfo, nsInfo, javaType);
        }
        if (javaAttribute instanceof XmlElements) {
            return this.processXmlElements((XmlElements)javaAttribute, oldProperty, typeInfo);
        }
        if (javaAttribute instanceof XmlElementRef) {
            return this.processXmlElementRef((XmlElementRef)javaAttribute, oldProperty, typeInfo);
        }
        if (javaAttribute instanceof XmlElementRefs) {
            return this.processXmlElementRefs((XmlElementRefs)javaAttribute, oldProperty, typeInfo);
        }
        if (javaAttribute instanceof XmlTransient) {
            return this.processXmlTransient((XmlTransient)javaAttribute, oldProperty);
        }
        if (javaAttribute instanceof XmlValue) {
            return this.processXmlValue((XmlValue)javaAttribute, oldProperty, typeInfo, javaType);
        }
        if (javaAttribute instanceof XmlJavaTypeAdapter) {
            return this.processXmlJavaTypeAdapter((XmlJavaTypeAdapter)javaAttribute, oldProperty);
        }
        if (javaAttribute instanceof XmlInverseReference) {
            return this.processXmlInverseReference((XmlInverseReference)javaAttribute, oldProperty);
        }
        if (javaAttribute instanceof XmlTransformation) {
            return this.processXmlTransformation((XmlTransformation)javaAttribute, oldProperty, typeInfo);
        }
        if (javaAttribute instanceof XmlJoinNodes) {
            return this.processXmlJoinNodes((XmlJoinNodes)javaAttribute, oldProperty);
        }
        this.getLogger().logWarning("jaxb_metadata_warning_invalid_java_attribute", new Object[]{javaAttribute.getClass()});
        return null;
    }

    private Property processXmlJavaTypeAdapter(XmlJavaTypeAdapter xmlAdapter, Property oldProperty) {
        oldProperty.setXmlJavaTypeAdapter(xmlAdapter);
        return oldProperty;
    }

    private Property processXmlInverseReference(XmlInverseReference xmlInverseReference, Property oldProperty) {
        oldProperty.setInverseReference(true);
        oldProperty.setInverseReferencePropertyName(xmlInverseReference.getMappedBy());
        if (xmlInverseReference.getXmlAccessMethods() != null) {
            oldProperty.setInverseReferencePropertyGetMethodName(xmlInverseReference.getXmlAccessMethods().getGetMethod());
            oldProperty.setInverseReferencePropertySetMethodName(xmlInverseReference.getXmlAccessMethods().getSetMethod());
        }
        if (xmlInverseReference.getXmlProperties() != null && xmlInverseReference.getXmlProperties().getXmlProperty().size() > 0) {
            oldProperty.setUserProperties(this.createUserPropertyMap(xmlInverseReference.getXmlProperties().getXmlProperty()));
        }
        if (!xmlInverseReference.getContainerType().equals(DEFAULT)) {
            this.setContainerType(oldProperty, xmlInverseReference.getContainerType());
        }
        if (!xmlInverseReference.getType().equals(DEFAULT)) {
            JavaClass pType = this.jModelInput.getJavaModel().getClass(xmlInverseReference.getType());
            if (this.aProcessor.isCollectionType(oldProperty.getType())) {
                oldProperty.setGenericType(pType);
            } else {
                oldProperty.setType(pType);
            }
            oldProperty.setHasXmlElementType(true);
            if (this.aProcessor.shouldGenerateTypeInfo(pType) && this.aProcessor.getTypeInfo().get(pType.getQualifiedName()) == null) {
                this.aProcessor.buildNewTypeInfo(new JavaClass[]{pType});
            }
        }
        return oldProperty;
    }

    private Property processXmlAnyAttribute(XmlAnyAttribute xmlAnyAttribute, Property oldProperty, TypeInfo tInfo, JavaType javaType) {
        if (oldProperty.isAnyAttribute()) {
            return oldProperty;
        }
        if (!oldProperty.getType().getName().equals("java.util.Map")) {
            if (oldProperty.getType().getClass().getName().contains("OXMJavaClassImpl")) {
                JavaClass pType = this.jModelInput.getJavaModel().getClass("java.util.Map");
                oldProperty.setType(pType);
            } else {
                throw JAXBException.anyAttributeOnNonMap((String)oldProperty.getPropertyName());
            }
        }
        this.resetProperty(oldProperty, tInfo);
        oldProperty.setIsAnyAttribute(true);
        tInfo.setAnyAttributePropertyName(oldProperty.getPropertyName());
        if (xmlAnyAttribute.getXmlPath() != null) {
            oldProperty.setXmlPath(xmlAnyAttribute.getXmlPath());
        }
        if (xmlAnyAttribute.getXmlAccessMethods() != null) {
            oldProperty.setMethodProperty(true);
            oldProperty.setGetMethodName(xmlAnyAttribute.getXmlAccessMethods().getGetMethod());
            oldProperty.setSetMethodName(xmlAnyAttribute.getXmlAccessMethods().getSetMethod());
        }
        if (xmlAnyAttribute.isSetReadOnly()) {
            oldProperty.setReadOnly(xmlAnyAttribute.isReadOnly());
        }
        if (xmlAnyAttribute.isSetWriteOnly()) {
            oldProperty.setWriteOnly(xmlAnyAttribute.isWriteOnly());
        }
        if (xmlAnyAttribute.getXmlProperties() != null && xmlAnyAttribute.getXmlProperties().getXmlProperty().size() > 0) {
            oldProperty.setUserProperties(this.createUserPropertyMap(xmlAnyAttribute.getXmlProperties().getXmlProperty()));
        }
        if (!xmlAnyAttribute.getContainerType().equals(DEFAULT)) {
            this.setContainerType(oldProperty, xmlAnyAttribute.getContainerType());
        }
        return oldProperty;
    }

    private Property processXmlAnyElement(XmlAnyElement xmlAnyElement, Property oldProperty, TypeInfo tInfo, JavaType javaType) {
        this.resetProperty(oldProperty, tInfo);
        oldProperty.setIsAny(true);
        oldProperty.setDomHandlerClassName(xmlAnyElement.getDomHandler());
        oldProperty.setLax(xmlAnyElement.isLax());
        oldProperty.setMixedContent(xmlAnyElement.isXmlMixed());
        oldProperty.setXmlJavaTypeAdapter(xmlAnyElement.getXmlJavaTypeAdapter());
        tInfo.setMixed(xmlAnyElement.isXmlMixed());
        tInfo.setAnyElementPropertyName(oldProperty.getPropertyName());
        if (xmlAnyElement.getXmlPath() != null) {
            oldProperty.setXmlPath(xmlAnyElement.getXmlPath());
        }
        if (xmlAnyElement.getXmlAccessMethods() != null) {
            oldProperty.setMethodProperty(true);
            oldProperty.setGetMethodName(xmlAnyElement.getXmlAccessMethods().getGetMethod());
            oldProperty.setSetMethodName(xmlAnyElement.getXmlAccessMethods().getSetMethod());
        }
        if (xmlAnyElement.isSetReadOnly()) {
            oldProperty.setReadOnly(xmlAnyElement.isReadOnly());
        }
        if (xmlAnyElement.isSetWriteOnly()) {
            oldProperty.setWriteOnly(xmlAnyElement.isWriteOnly());
        }
        if (xmlAnyElement.getXmlProperties() != null && xmlAnyElement.getXmlProperties().getXmlProperty().size() > 0) {
            oldProperty.setUserProperties(this.createUserPropertyMap(xmlAnyElement.getXmlProperties().getXmlProperty()));
        }
        if (!xmlAnyElement.getContainerType().equals(DEFAULT)) {
            this.setContainerType(oldProperty, xmlAnyElement.getContainerType());
        }
        if (xmlAnyElement.getXmlElementRefs() != null) {
            oldProperty.setXmlElementRefs(xmlAnyElement.getXmlElementRefs().getXmlElementRef());
            oldProperty.setIsReference(true);
            if (xmlAnyElement.getXmlElementRefs().isSetXmlMixed()) {
                oldProperty.setMixedContent(xmlAnyElement.getXmlElementRefs().isXmlMixed());
            }
        }
        return oldProperty;
    }

    private Property processXmlAttribute(XmlAttribute xmlAttribute, Property oldProperty, TypeInfo typeInfo, NamespaceInfo nsInfo) {
        String namespace;
        String name;
        this.resetProperty(oldProperty, typeInfo);
        if (xmlAttribute.isXmlId()) {
            oldProperty.setIsXmlId(true);
            typeInfo.setIDProperty(oldProperty);
        } else if (typeInfo.getIDProperty() != null && typeInfo.getIDProperty().getPropertyName().equals(oldProperty.getPropertyName())) {
            typeInfo.setIDProperty(null);
        }
        oldProperty.setIsXmlIdRef(xmlAttribute.isXmlIdref());
        if (xmlAttribute.isXmlKey()) {
            typeInfo.addXmlKeyProperty(oldProperty);
        }
        oldProperty.setIsAttribute(true);
        oldProperty.setisInlineBinaryData(xmlAttribute.isXmlInlineBinaryData());
        if (xmlAttribute.getXmlPath() != null) {
            oldProperty.setXmlPath(xmlAttribute.getXmlPath());
            name = XMLProcessor.getNameFromXPath(xmlAttribute.getXmlPath(), oldProperty.getPropertyName(), true);
            namespace = DEFAULT;
        } else {
            name = xmlAttribute.getName();
            namespace = xmlAttribute.getNamespace();
        }
        if (name.equals(DEFAULT)) {
            name = oldProperty.getPropertyName();
        }
        QName qName = namespace.equals(DEFAULT) ? (nsInfo.isElementFormQualified() ? new QName(nsInfo.getNamespace(), name) : new QName(name)) : new QName(namespace, name);
        oldProperty.setSchemaName(qName);
        if (!xmlAttribute.getContainerType().equals(DEFAULT)) {
            this.setContainerType(oldProperty, xmlAttribute.getContainerType());
        }
        if (!xmlAttribute.getType().equals(DEFAULT)) {
            JavaClass pType = this.jModelInput.getJavaModel().getClass(xmlAttribute.getType());
            if (this.aProcessor.isCollectionType(oldProperty.getType())) {
                oldProperty.setGenericType(pType);
            } else {
                oldProperty.setType(pType);
            }
            oldProperty.setHasXmlElementType(true);
            if (this.aProcessor.shouldGenerateTypeInfo(pType) && this.aProcessor.getTypeInfo().get(pType.getQualifiedName()) == null) {
                this.aProcessor.buildNewTypeInfo(new JavaClass[]{pType});
            }
        }
        this.reapplyPackageAndClassAdapters(oldProperty, typeInfo);
        if (xmlAttribute.getXmlJavaTypeAdapter() != null) {
            oldProperty.setXmlJavaTypeAdapter(xmlAttribute.getXmlJavaTypeAdapter());
        }
        if (xmlAttribute.isSetRequired()) {
            oldProperty.setIsRequired(xmlAttribute.isRequired());
        } else if (oldProperty.getActualType().isPrimitive()) {
            oldProperty.setIsRequired(true);
        }
        if (xmlAttribute.getXmlMimeType() != null) {
            oldProperty.setMimeType(xmlAttribute.getXmlMimeType());
        }
        if (xmlAttribute.isXmlAttachmentRef()) {
            oldProperty.setIsSwaAttachmentRef(true);
            oldProperty.setSchemaType(XMLConstants.SWA_REF_QNAME);
        }
        if (xmlAttribute.getXmlSchemaType() != null) {
            oldProperty.setSchemaType(new QName(xmlAttribute.getXmlSchemaType().getNamespace(), xmlAttribute.getXmlSchemaType().getName()));
        }
        if (xmlAttribute.getXmlAccessMethods() != null) {
            oldProperty.setMethodProperty(true);
            oldProperty.setGetMethodName(xmlAttribute.getXmlAccessMethods().getGetMethod());
            oldProperty.setSetMethodName(xmlAttribute.getXmlAccessMethods().getSetMethod());
        }
        if (xmlAttribute.isSetReadOnly()) {
            oldProperty.setReadOnly(xmlAttribute.isReadOnly());
        }
        if (xmlAttribute.isSetWriteOnly()) {
            oldProperty.setWriteOnly(xmlAttribute.isWriteOnly());
        }
        if (xmlAttribute.getXmlAbstractNullPolicy() != null) {
            JAXBElement<? extends XmlAbstractNullPolicy> jaxbElt = xmlAttribute.getXmlAbstractNullPolicy();
            oldProperty.setNullPolicy((XmlAbstractNullPolicy)jaxbElt.getValue());
        }
        if (xmlAttribute.getXmlProperties() != null && xmlAttribute.getXmlProperties().getXmlProperty().size() > 0) {
            oldProperty.setUserProperties(this.createUserPropertyMap(xmlAttribute.getXmlProperties().getXmlProperty()));
        }
        return oldProperty;
    }

    private Property processXmlElement(XmlElement xmlElement, Property oldProperty, TypeInfo typeInfo, NamespaceInfo nsInfo, JavaType javaType) {
        String namespace;
        String name;
        this.resetProperty(oldProperty, typeInfo);
        if (xmlElement.getXmlMap() != null) {
            this.processXmlMap(xmlElement.getXmlMap(), oldProperty);
        }
        if (xmlElement.isXmlId()) {
            oldProperty.setIsXmlId(true);
            typeInfo.setIDProperty(oldProperty);
        } else if (typeInfo.getIDProperty() != null && typeInfo.getIDProperty().getPropertyName().equals(oldProperty.getPropertyName())) {
            typeInfo.setIDProperty(null);
        }
        oldProperty.setIsXmlIdRef(xmlElement.isXmlIdref());
        if (xmlElement.isXmlKey()) {
            typeInfo.addXmlKeyProperty(oldProperty);
        }
        oldProperty.setIsRequired(xmlElement.isRequired());
        oldProperty.setisInlineBinaryData(xmlElement.isXmlInlineBinaryData());
        oldProperty.setNillable(xmlElement.isNillable());
        if (xmlElement.getDefaultValue().equals("\u0000")) {
            oldProperty.setDefaultValue(null);
        } else {
            oldProperty.setDefaultValue(xmlElement.getDefaultValue());
        }
        if (xmlElement.getXmlPath() != null) {
            oldProperty.setXmlPath(xmlElement.getXmlPath());
            name = XMLProcessor.getNameFromXPath(xmlElement.getXmlPath(), oldProperty.getPropertyName(), false);
            namespace = DEFAULT;
        } else {
            name = xmlElement.getName();
            namespace = xmlElement.getNamespace();
            if (xmlElement.getXmlElementWrapper() != null) {
                oldProperty.setXmlElementWrapper(xmlElement.getXmlElementWrapper());
            }
        }
        if (name.equals(DEFAULT)) {
            name = oldProperty.getPropertyName();
        }
        QName qName = namespace.equals(DEFAULT) ? (nsInfo.isElementFormQualified() ? new QName(nsInfo.getNamespace(), name) : new QName(name)) : new QName(namespace, name);
        oldProperty.setSchemaName(qName);
        if (!xmlElement.getContainerType().equals(DEFAULT)) {
            this.setContainerType(oldProperty, xmlElement.getContainerType());
        }
        if (xmlElement.getType().equals("javax.xml.bind.annotation.XmlElement.DEFAULT")) {
            if (oldProperty.isXmlElementType()) {
                oldProperty.setType(oldProperty.getOriginalType());
            }
        } else if (xmlElement.getXmlMap() != null) {
            this.getLogger().logWarning("jaxb_metadata_warning_ignoring_type_on_map", new Object[]{xmlElement.getName()});
        } else {
            JavaClass pType = this.jModelInput.getJavaModel().getClass(xmlElement.getType());
            if (this.aProcessor.isCollectionType(oldProperty.getType())) {
                oldProperty.setGenericType(pType);
            } else {
                oldProperty.setType(pType);
            }
            oldProperty.setHasXmlElementType(true);
            if (this.aProcessor.shouldGenerateTypeInfo(pType) && this.aProcessor.getTypeInfo().get(pType.getQualifiedName()) == null) {
                this.aProcessor.buildNewTypeInfo(new JavaClass[]{pType});
            }
        }
        this.reapplyPackageAndClassAdapters(oldProperty, typeInfo);
        if (xmlElement.getXmlJavaTypeAdapter() != null) {
            try {
                oldProperty.setXmlJavaTypeAdapter(xmlElement.getXmlJavaTypeAdapter());
            }
            catch (JAXBException e) {
                throw JAXBException.invalidPropertyAdapterClass((String)xmlElement.getXmlJavaTypeAdapter().getValue(), (String)xmlElement.getJavaAttribute(), (String)javaType.getName());
            }
        }
        if (!oldProperty.isRequired()) {
            JavaClass ptype = oldProperty.getActualType();
            oldProperty.setIsRequired(ptype.isPrimitive() || ptype.isArray() && ptype.getComponentType().isPrimitive());
        }
        if (xmlElement.isSetXmlList()) {
            if (!this.aProcessor.isCollectionType(oldProperty) && !oldProperty.getType().isArray()) {
                throw JAXBException.invalidList((String)oldProperty.getPropertyName());
            }
            oldProperty.setIsXmlList(xmlElement.isXmlList());
        }
        if (xmlElement.getXmlMimeType() != null) {
            oldProperty.setMimeType(xmlElement.getXmlMimeType());
        }
        if (xmlElement.isXmlAttachmentRef()) {
            oldProperty.setIsSwaAttachmentRef(true);
            oldProperty.setSchemaType(XMLConstants.SWA_REF_QNAME);
        }
        if (xmlElement.getXmlSchemaType() != null) {
            oldProperty.setSchemaType(new QName(xmlElement.getXmlSchemaType().getNamespace(), xmlElement.getXmlSchemaType().getName()));
        }
        if (xmlElement.getXmlAccessMethods() != null) {
            oldProperty.setMethodProperty(true);
            oldProperty.setGetMethodName(xmlElement.getXmlAccessMethods().getGetMethod());
            oldProperty.setSetMethodName(xmlElement.getXmlAccessMethods().getSetMethod());
        }
        if (xmlElement.isSetReadOnly()) {
            oldProperty.setReadOnly(xmlElement.isReadOnly());
        }
        if (xmlElement.isSetWriteOnly()) {
            oldProperty.setWriteOnly(xmlElement.isWriteOnly());
        }
        if (xmlElement.isSetCdata()) {
            oldProperty.setCdata(xmlElement.isCdata());
        }
        if (xmlElement.getXmlAbstractNullPolicy() != null) {
            JAXBElement<? extends XmlAbstractNullPolicy> jaxbElt = xmlElement.getXmlAbstractNullPolicy();
            oldProperty.setNullPolicy((XmlAbstractNullPolicy)jaxbElt.getValue());
        }
        if (xmlElement.getXmlProperties() != null && xmlElement.getXmlProperties().getXmlProperty().size() > 0) {
            oldProperty.setUserProperties(this.createUserPropertyMap(xmlElement.getXmlProperties().getXmlProperty()));
        }
        return oldProperty;
    }

    private Property processXmlMap(XmlMap xmlMap, Property oldProperty) {
        XmlMap.Key mapKey = xmlMap.getKey();
        XmlMap.Value mapValue = xmlMap.getValue();
        if (mapKey != null && mapKey.getType() != null) {
            oldProperty.setKeyType(this.jModelInput.getJavaModel().getClass(mapKey.getType()));
        } else {
            oldProperty.setKeyType(this.jModelInput.getJavaModel().getClass(JAVA_LANG_OBJECT));
        }
        if (mapValue != null && mapValue.getType() != null) {
            oldProperty.setValueType(this.jModelInput.getJavaModel().getClass(mapValue.getType()));
        } else {
            oldProperty.setValueType(this.jModelInput.getJavaModel().getClass(JAVA_LANG_OBJECT));
        }
        return oldProperty;
    }

    private Property processXmlElements(XmlElements xmlElements, Property oldProperty, TypeInfo tInfo) {
        this.resetProperty(oldProperty, tInfo);
        oldProperty.setChoice(true);
        oldProperty.setXmlElements(xmlElements);
        oldProperty.setIsXmlIdRef(xmlElements.isXmlIdref());
        if (xmlElements.getXmlElementWrapper() != null) {
            oldProperty.setXmlElementWrapper(xmlElements.getXmlElementWrapper());
        }
        if (xmlElements.getXmlAccessMethods() != null) {
            oldProperty.setMethodProperty(true);
            oldProperty.setGetMethodName(xmlElements.getXmlAccessMethods().getGetMethod());
            oldProperty.setSetMethodName(xmlElements.getXmlAccessMethods().getSetMethod());
        }
        if (xmlElements.isSetReadOnly()) {
            oldProperty.setReadOnly(xmlElements.isReadOnly());
        }
        if (xmlElements.isSetWriteOnly()) {
            oldProperty.setWriteOnly(xmlElements.isWriteOnly());
        }
        if (xmlElements.getXmlProperties() != null && xmlElements.getXmlProperties().getXmlProperty().size() > 0) {
            oldProperty.setUserProperties(this.createUserPropertyMap(xmlElements.getXmlProperties().getXmlProperty()));
        }
        if (!xmlElements.getContainerType().equals(DEFAULT)) {
            this.setContainerType(oldProperty, xmlElements.getContainerType());
        }
        if (xmlElements.hasXmlJoinNodes()) {
            oldProperty.setXmlJoinNodesList(xmlElements.getXmlJoinNodes());
        }
        return oldProperty;
    }

    private Property processXmlElementRef(XmlElementRef xmlElementRef, Property oldProperty, TypeInfo info) {
        this.resetProperty(oldProperty, info);
        ArrayList<XmlElementRef> eltRefs = new ArrayList<XmlElementRef>();
        eltRefs.add(xmlElementRef);
        oldProperty.setXmlElementRefs(eltRefs);
        oldProperty.setIsReference(true);
        if (!xmlElementRef.getContainerType().equals(DEFAULT)) {
            this.setContainerType(oldProperty, xmlElementRef.getContainerType());
        }
        if (xmlElementRef.getXmlElementWrapper() != null) {
            oldProperty.setXmlElementWrapper(xmlElementRef.getXmlElementWrapper());
        }
        if (xmlElementRef.getXmlProperties() != null && xmlElementRef.getXmlProperties().getXmlProperty().size() > 0) {
            oldProperty.setUserProperties(this.createUserPropertyMap(xmlElementRef.getXmlProperties().getXmlProperty()));
        }
        if (xmlElementRef.isSetXmlMixed()) {
            oldProperty.setMixedContent(xmlElementRef.isXmlMixed());
        }
        if (xmlElementRef.getXmlAccessMethods() != null) {
            oldProperty.setMethodProperty(true);
            oldProperty.setGetMethodName(xmlElementRef.getXmlAccessMethods().getGetMethod());
            oldProperty.setSetMethodName(xmlElementRef.getXmlAccessMethods().getSetMethod());
        }
        if (xmlElementRef.isSetReadOnly()) {
            oldProperty.setReadOnly(xmlElementRef.isReadOnly());
        }
        if (xmlElementRef.isSetWriteOnly()) {
            oldProperty.setWriteOnly(xmlElementRef.isWriteOnly());
        }
        return oldProperty;
    }

    private Property processXmlElementRefs(XmlElementRefs xmlElementRefs, Property oldProperty, TypeInfo info) {
        this.resetProperty(oldProperty, info);
        ArrayList<XmlElementRef> eltRefs = new ArrayList<XmlElementRef>();
        for (XmlElementRef eltRef : xmlElementRefs.getXmlElementRef()) {
            eltRefs.add(eltRef);
        }
        oldProperty.setXmlElementRefs(eltRefs);
        oldProperty.setIsReference(true);
        if (xmlElementRefs.getXmlElementWrapper() != null) {
            oldProperty.setXmlElementWrapper(xmlElementRefs.getXmlElementWrapper());
        }
        if (xmlElementRefs.getXmlProperties() != null && xmlElementRefs.getXmlProperties().getXmlProperty().size() > 0) {
            oldProperty.setUserProperties(this.createUserPropertyMap(xmlElementRefs.getXmlProperties().getXmlProperty()));
        }
        if (xmlElementRefs.isSetXmlMixed()) {
            oldProperty.setMixedContent(xmlElementRefs.isXmlMixed());
        }
        if (xmlElementRefs.getXmlAccessMethods() != null) {
            oldProperty.setMethodProperty(true);
            oldProperty.setGetMethodName(xmlElementRefs.getXmlAccessMethods().getGetMethod());
            oldProperty.setSetMethodName(xmlElementRefs.getXmlAccessMethods().getSetMethod());
        }
        if (xmlElementRefs.isSetReadOnly()) {
            oldProperty.setReadOnly(xmlElementRefs.isReadOnly());
        }
        if (xmlElementRefs.isSetWriteOnly()) {
            oldProperty.setWriteOnly(xmlElementRefs.isWriteOnly());
        }
        return oldProperty;
    }

    private Property processXmlTransient(XmlTransient xmlTransient, Property oldProperty) {
        oldProperty.setTransient(true);
        return oldProperty;
    }

    private Property processXmlValue(XmlValue xmlValue, Property oldProperty, TypeInfo info, JavaType javaType) {
        this.resetProperty(oldProperty, info);
        oldProperty.setIsXmlValue(true);
        info.setXmlValueProperty(oldProperty);
        if (xmlValue.getXmlAccessMethods() != null) {
            oldProperty.setMethodProperty(true);
            oldProperty.setGetMethodName(xmlValue.getXmlAccessMethods().getGetMethod());
            oldProperty.setSetMethodName(xmlValue.getXmlAccessMethods().getSetMethod());
        }
        if (!xmlValue.getContainerType().equals(DEFAULT)) {
            this.setContainerType(oldProperty, xmlValue.getContainerType());
        }
        if (!xmlValue.getType().equals(DEFAULT)) {
            JavaClass pType = this.jModelInput.getJavaModel().getClass(xmlValue.getType());
            if (this.aProcessor.isCollectionType(oldProperty.getType())) {
                oldProperty.setGenericType(pType);
            } else {
                oldProperty.setType(pType);
            }
            if (this.aProcessor.shouldGenerateTypeInfo(pType) && this.aProcessor.getTypeInfo().get(pType.getQualifiedName()) == null) {
                this.aProcessor.buildNewTypeInfo(new JavaClass[]{pType});
            }
        }
        this.reapplyPackageAndClassAdapters(oldProperty, info);
        if (xmlValue.getXmlJavaTypeAdapter() != null) {
            try {
                oldProperty.setXmlJavaTypeAdapter(xmlValue.getXmlJavaTypeAdapter());
            }
            catch (JAXBException e) {
                throw JAXBException.invalidPropertyAdapterClass((String)xmlValue.getXmlJavaTypeAdapter().getValue(), (String)xmlValue.getJavaAttribute(), (String)javaType.getName());
            }
        }
        if (xmlValue.isSetReadOnly()) {
            oldProperty.setReadOnly(xmlValue.isReadOnly());
        }
        if (xmlValue.isSetWriteOnly()) {
            oldProperty.setWriteOnly(xmlValue.isWriteOnly());
        }
        if (xmlValue.isSetCdata()) {
            oldProperty.setCdata(xmlValue.isCdata());
        }
        if (xmlValue.getXmlAbstractNullPolicy() != null) {
            JAXBElement<? extends XmlAbstractNullPolicy> jaxbElt = xmlValue.getXmlAbstractNullPolicy();
            oldProperty.setNullPolicy((XmlAbstractNullPolicy)jaxbElt.getValue());
        }
        if (xmlValue.getXmlProperties() != null && xmlValue.getXmlProperties().getXmlProperty().size() > 0) {
            oldProperty.setUserProperties(this.createUserPropertyMap(xmlValue.getXmlProperties().getXmlProperty()));
        }
        return oldProperty;
    }

    private NamespaceInfo processXmlSchema(XmlBindings xmlBindings, String packageName) {
        XmlSchema schema = xmlBindings.getXmlSchema();
        if (schema == null) {
            return null;
        }
        NamespaceInfo nsInfo = new NamespaceInfo();
        XmlNsForm form = schema.getAttributeFormDefault();
        nsInfo.setAttributeFormQualified(form.equals((Object)XmlNsForm.QUALIFIED));
        form = schema.getElementFormDefault();
        nsInfo.setElementFormQualified(form.equals((Object)XmlNsForm.QUALIFIED));
        if (!nsInfo.isElementFormQualified() || nsInfo.isAttributeFormQualified()) {
            this.aProcessor.setDefaultNamespaceAllowed(false);
        }
        nsInfo.setLocation(schema.getLocation() == null ? "##generate" : schema.getLocation());
        String namespace = schema.getNamespace();
        if (namespace == null) {
            namespace = this.aProcessor.getDefaultTargetNamespace();
        }
        nsInfo.setNamespace(namespace == null ? "" : schema.getNamespace());
        NamespaceResolver nsr = new NamespaceResolver();
        for (XmlSchema.XmlNs xmlns : schema.getXmlNs()) {
            nsr.put(xmlns.getPrefix(), xmlns.getNamespaceUri());
        }
        nsInfo.setNamespaceResolver(nsr);
        return nsInfo;
    }

    private Property processXmlTransformation(XmlTransformation xmlTransformation, Property oldProperty, TypeInfo tInfo) {
        this.resetProperty(oldProperty, tInfo);
        oldProperty.setIsXmlTransformation(true);
        oldProperty.setXmlTransformation(xmlTransformation);
        if (xmlTransformation.getXmlAccessMethods() != null) {
            oldProperty.setMethodProperty(true);
            oldProperty.setGetMethodName(xmlTransformation.getXmlAccessMethods().getGetMethod());
            oldProperty.setSetMethodName(xmlTransformation.getXmlAccessMethods().getSetMethod());
        }
        if (xmlTransformation.getXmlProperties() != null && xmlTransformation.getXmlProperties().getXmlProperty().size() > 0) {
            oldProperty.setUserProperties(this.createUserPropertyMap(xmlTransformation.getXmlProperties().getXmlProperty()));
        }
        return oldProperty;
    }

    private Property processXmlJoinNodes(XmlJoinNodes xmlJoinNodes, Property oldProperty) {
        oldProperty.setXmlJoinNodes(xmlJoinNodes);
        if (!xmlJoinNodes.getContainerType().equals(DEFAULT)) {
            this.setContainerType(oldProperty, xmlJoinNodes.getContainerType());
        }
        if (!xmlJoinNodes.getType().equals(DEFAULT)) {
            JavaClass pType = this.jModelInput.getJavaModel().getClass(xmlJoinNodes.getType());
            if (this.aProcessor.isCollectionType(oldProperty.getType())) {
                oldProperty.setGenericType(pType);
            } else {
                oldProperty.setType(pType);
            }
            oldProperty.setHasXmlElementType(true);
            if (this.aProcessor.shouldGenerateTypeInfo(pType) && this.aProcessor.getTypeInfo().get(pType.getQualifiedName()) == null) {
                this.aProcessor.buildNewTypeInfo(new JavaClass[]{pType});
            }
        }
        return oldProperty;
    }

    private Map<String, ArrayList<JavaClass>> buildPackageToJavaClassMap() {
        HashMap<String, ArrayList<JavaClass>> theMap = new HashMap<String, ArrayList<JavaClass>>();
        HashMap xmlBindingsMap = new HashMap();
        for (String packageName : this.xmlBindingMap.keySet()) {
            XmlBindings.XmlEnums xmlEnums;
            XmlBindings xmlBindings = this.xmlBindingMap.get(packageName);
            ArrayList<JavaClass> classes = new ArrayList<JavaClass>();
            XmlBindings.JavaTypes jTypes = xmlBindings.getJavaTypes();
            if (jTypes != null) {
                for (JavaType javaType : jTypes.getJavaType()) {
                    JavaClass nextClass = this.jModelInput.getJavaModel().getClass(javaType.getName());
                    String nextPackageName = nextClass.getPackageName();
                    if (nextPackageName == null || !nextPackageName.equals(packageName)) {
                        throw JAXBException.javaTypeNotAllowedInBindingsFile((String)nextPackageName, (String)packageName);
                    }
                    classes.add(nextClass);
                }
            }
            if ((xmlEnums = xmlBindings.getXmlEnums()) != null) {
                for (XmlEnum xmlEnum : xmlEnums.getXmlEnum()) {
                    classes.add(this.jModelInput.getJavaModel().getClass(xmlEnum.getJavaEnum()));
                }
            }
            theMap.put(packageName, classes);
            xmlBindingsMap.put(packageName, new ArrayList(classes));
        }
        for (JavaClass jClass : this.jModelInput.getJavaClasses()) {
            String pkg = jClass.getPackageName();
            ArrayList existingXmlBindingsClasses = (ArrayList)xmlBindingsMap.get(pkg);
            ArrayList allExistingClasses = (ArrayList)theMap.get(pkg);
            if (existingXmlBindingsClasses != null) {
                if (this.classExistsInArray(jClass, existingXmlBindingsClasses)) continue;
                allExistingClasses.add(jClass);
                continue;
            }
            if (allExistingClasses != null) {
                allExistingClasses.add(jClass);
                continue;
            }
            ArrayList<JavaClass> classes = new ArrayList<JavaClass>();
            classes.add(jClass);
            theMap.put(pkg, classes);
        }
        return theMap;
    }

    private JAXBMetadataLogger getLogger() {
        if (this.logger == null) {
            this.logger = new JAXBMetadataLogger();
        }
        return this.logger;
    }

    public boolean classExistsInArray(JavaClass theClass, ArrayList<JavaClass> existingClasses) {
        return this.aProcessor.getHelper().classExistsInArray(theClass, existingClasses);
    }

    private Property resetProperty(Property oldProperty, TypeInfo tInfo) {
        oldProperty.setIsAttribute(false);
        oldProperty.setHasXmlElementType(false);
        oldProperty.setIsRequired(false);
        oldProperty.setIsXmlList(false);
        oldProperty.setXmlJavaTypeAdapter(null);
        oldProperty.setInverseReferencePropertyName(null);
        oldProperty.setDefaultValue(null);
        oldProperty.setDomHandlerClassName(null);
        oldProperty.setIsSwaAttachmentRef(false);
        oldProperty.setIsXmlIdRef(false);
        oldProperty.setIsXmlTransformation(false);
        oldProperty.setXmlElementWrapper(null);
        oldProperty.setLax(false);
        oldProperty.setNillable(false);
        oldProperty.setMixedContent(false);
        oldProperty.setMimeType(null);
        oldProperty.setTransient(false);
        oldProperty.setChoice(false);
        oldProperty.setIsReference(false);
        oldProperty.setXmlPath(null);
        oldProperty.setReadOnly(false);
        oldProperty.setWriteOnly(false);
        oldProperty.setCdata(false);
        oldProperty.setNullPolicy(null);
        oldProperty.setUserProperties(null);
        oldProperty.setGetMethodName(oldProperty.getOriginalGetMethodName());
        oldProperty.setSetMethodName(oldProperty.getOriginalSetMethodName());
        oldProperty.setXmlTransformation(null);
        oldProperty.setXmlJoinNodes(null);
        if (oldProperty.getGetMethodName() == null && oldProperty.getSetMethodName() == null) {
            oldProperty.setMethodProperty(false);
        }
        this.unsetXmlElementRefs(oldProperty, tInfo);
        this.unsetXmlElements(oldProperty);
        this.unsetXmlAnyAttribute(oldProperty, tInfo);
        this.unsetXmlAnyElement(oldProperty, tInfo);
        this.unsetXmlValue(oldProperty, tInfo);
        this.unsetXmlID(oldProperty, tInfo);
        this.unsetXmlKey(oldProperty, tInfo);
        return oldProperty;
    }

    private void unsetXmlID(Property oldProperty, TypeInfo tInfo) {
        oldProperty.setIsXmlId(false);
        if (tInfo.isIDSet() && tInfo.getIDProperty().getPropertyName().equals(oldProperty.getPropertyName())) {
            tInfo.setIDProperty(null);
        }
    }

    private void unsetXmlKey(Property oldProperty, TypeInfo tInfo) {
        if (tInfo.hasXmlKeyProperties()) {
            Property propToRemove = null;
            for (Property prop : tInfo.getXmlKeyProperties()) {
                if (!prop.getPropertyName().equals(oldProperty.getPropertyName())) continue;
                propToRemove = prop;
            }
            if (propToRemove != null) {
                tInfo.getXmlKeyProperties().remove(propToRemove);
            }
        }
    }

    private void unsetXmlElementRefs(Property oldProperty, TypeInfo tInfo) {
        if (tInfo.hasElementRefs() && tInfo.getElementRefsPropName().equals(oldProperty.getPropertyName())) {
            tInfo.setElementRefsPropertyName(null);
        }
    }

    private void unsetXmlElements(Property oldProperty) {
        oldProperty.setXmlElements(null);
        oldProperty.setChoiceProperties(null);
    }

    private void unsetXmlAnyAttribute(Property oldProperty, TypeInfo tInfo) {
        oldProperty.setIsAnyAttribute(false);
        if (tInfo.isSetAnyAttributePropertyName() && tInfo.getAnyAttributePropertyName().equals(oldProperty.getPropertyName())) {
            tInfo.setAnyAttributePropertyName(null);
        }
    }

    private void unsetXmlAnyElement(Property oldProperty, TypeInfo tInfo) {
        oldProperty.setIsAny(false);
        if (tInfo.isSetAnyElementPropertyName() && tInfo.getAnyElementPropertyName().equals(oldProperty.getPropertyName())) {
            tInfo.setAnyElementPropertyName(null);
        }
    }

    private void unsetXmlValue(Property oldProperty, TypeInfo tInfo) {
        oldProperty.setIsXmlValue(false);
        if (tInfo.isSetXmlValueProperty() && tInfo.getXmlValueProperty().getPropertyName().equals(oldProperty.getPropertyName())) {
            tInfo.setXmlValueProperty(null);
        }
    }

    public static String getNameFromXPath(String xpath, String propertyName, boolean isAttribute) {
        String name;
        if (xpath.equals(SELF)) {
            return propertyName;
        }
        int idx = xpath.indexOf("/text()");
        String path = idx >= 0 ? xpath.substring(0, idx) : xpath;
        idx = path.lastIndexOf(SLASH);
        if (idx >= 0 && path.length() > 1) {
            name = path.substring(idx + 1);
            StringTokenizer stok = new StringTokenizer(name, COLON);
            if (stok.countTokens() == 2) {
                stok.nextToken();
                name = stok.nextToken();
            }
        } else {
            name = path;
        }
        if (isAttribute) {
            idx = name.indexOf(XMLConstants.ATTRIBUTE.charValue());
            if (idx >= 0 && name.length() > 1) {
                name = name.substring(idx + 1);
            }
        } else {
            idx = name.indexOf(OPEN_BRACKET);
            if (idx != -1) {
                name = name.substring(0, idx);
            }
        }
        return name;
    }

    private Map createUserPropertyMap(List<XmlProperties.XmlProperty> propList) {
        return this.mergeUserPropertyMap(propList, new HashMap());
    }

    private Map mergeUserPropertyMap(List<XmlProperties.XmlProperty> propList, Map existingMap) {
        Map propMap = existingMap;
        for (XmlProperties.XmlProperty prop : propList) {
            Object pvalue = prop.getValue();
            if (prop.isSetValueType()) {
                pvalue = XMLConversionManager.getDefaultXMLManager().convertObject((Object)prop.getValue(), XMLConversionManager.getDefaultXMLManager().convertClassNameToClass(prop.getValueType()));
            }
            propMap.put(prop.getName(), pvalue);
        }
        return propMap;
    }

    private void setContainerType(Property property, String containerClassName) {
        JavaClass genericType = property.getGenericType();
        property.setType(this.jModelInput.getJavaModel().getClass(containerClassName));
        property.setGenericType(genericType);
    }

    public void reapplyPackageAndClassAdapters(Property prop, TypeInfo owningInfo) {
        JavaClass packageLevelAdapter;
        if (prop.getXmlJavaTypeAdapter() != null) {
            return;
        }
        JavaClass type = prop.getActualType();
        TypeInfo targetInfo = this.aProcessor.getTypeInfo().get(type.getQualifiedName());
        if (targetInfo != null && targetInfo.getXmlJavaTypeAdapter() != null) {
            prop.setXmlJavaTypeAdapter(targetInfo.getXmlJavaTypeAdapter());
        }
        if ((packageLevelAdapter = owningInfo.getPackageLevelAdaptersByClass().get(type.getQualifiedName())) != null && prop.getXmlJavaTypeAdapter() == null) {
            XmlJavaTypeAdapter xja = new XmlJavaTypeAdapter();
            xja.setValue(packageLevelAdapter.getQualifiedName());
            xja.setType(type.getQualifiedName());
            prop.setXmlJavaTypeAdapter(xja);
        }
    }
}

