/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.persistence.annotations.BatchFetchType;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.FetchGroupManager;
import org.eclipse.persistence.descriptors.VersionLockingPolicy;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.history.AsOfClause;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.internal.expressions.FieldExpression;
import org.eclipse.persistence.internal.expressions.ForUpdateClause;
import org.eclipse.persistence.internal.expressions.ForUpdateOfClause;
import org.eclipse.persistence.internal.expressions.MapEntryExpression;
import org.eclipse.persistence.internal.expressions.ObjectExpression;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DeferredLockManager;
import org.eclipse.persistence.internal.helper.InvalidObject;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.history.UniversalAsOfClause;
import org.eclipse.persistence.internal.queries.DatabaseQueryMechanism;
import org.eclipse.persistence.internal.queries.EntityFetchGroup;
import org.eclipse.persistence.internal.queries.ExpressionQueryMechanism;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.queries.MapContainerPolicy;
import org.eclipse.persistence.internal.queries.MappedKeyMapContainerPolicy;
import org.eclipse.persistence.internal.queries.QueryByExampleMechanism;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.querykeys.ForeignReferenceQueryKey;
import org.eclipse.persistence.mappings.querykeys.QueryKey;
import org.eclipse.persistence.queries.BatchFetchPolicy;
import org.eclipse.persistence.queries.ComplexQueryResult;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.InMemoryQueryIndirectionPolicy;
import org.eclipse.persistence.queries.LoadGroup;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.QueryByExamplePolicy;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.sessions.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectLevelReadQuery
extends ObjectBuildingQuery {
    public static final String READ = "READ";
    public static final String WRITE = "WRITE";
    public static final String NONE = "NONE";
    public static final String PESSIMISTIC_ = "PESSIMISTIC_";
    public static final String PESSIMISTIC_READ = "PESSIMISTIC_READ";
    public static final String PESSIMISTIC_WRITE = "PESSIMISTIC_WRITE";
    public static final String PESSIMISTIC_FORCE_INCREMENT = "PESSIMISTIC_FORCE_INCREMENT";
    public static final String OPTIMISTIC = "OPTIMISTIC";
    public static final String OPTIMISTIC_FORCE_INCREMENT = "OPTIMISTIC_FORCE_INCREMENT";
    protected ExpressionBuilder defaultBuilder;
    protected int cacheUsage;
    public static final int UseDescriptorSetting = -1;
    public static final int DoNotCheckCache = 0;
    public static final int CheckCacheByExactPrimaryKey = 1;
    public static final int CheckCacheByPrimaryKey = 2;
    public static final int CheckCacheThenDatabase = 3;
    public static final int CheckCacheOnly = 4;
    public static final int ConformResultsInUnitOfWork = 5;
    protected List<Object> additionalFields;
    protected boolean shouldIncludeData;
    protected boolean isPrePrepared;
    protected short distinctState;
    public static final short UNCOMPUTED_DISTINCT = 0;
    public static final short USE_DISTINCT = 1;
    public static final short DONT_USE_DISTINCT = 2;
    protected int inMemoryQueryIndirectionPolicy;
    protected FetchGroup fetchGroup;
    protected String fetchGroupName;
    protected boolean shouldUseDefaultFetchGroup = true;
    protected LoadGroup loadGroup;
    protected EntityFetchGroup entityFetchGroup;
    protected List<Expression> nonFetchJoinAttributeExpressions;
    protected List<Expression> partialAttributeExpressions;
    protected JoinedAttributeManager joinedAttributeManager;
    protected BatchFetchPolicy batchFetchPolicy;
    protected Boolean isReferenceClassLocked;
    protected boolean isResultSetOptimizedQuery = false;
    protected boolean isReadOnly = false;
    protected Boolean shouldOuterJoinSubclasses;
    protected Map<Class, DatabaseCall> concreteSubclassCalls;
    protected String lockModeType;
    protected Integer waitTimeout;
    protected List<Expression> orderByExpressions;
    protected boolean shouldExtendPessimisticLockScope;

    public ObjectLevelReadQuery() {
        this.shouldRefreshIdentityMapResult = false;
        this.distinctState = 0;
        this.cacheUsage = -1;
        this.shouldIncludeData = false;
        this.inMemoryQueryIndirectionPolicy = 0;
    }

    public void addDescendingOrdering(String queryKeyName) {
        this.addOrdering(this.getExpressionBuilder().get(queryKeyName).descending());
    }

    public void addOrdering(Expression orderingExpression) {
        this.getOrderByExpressions().add(orderingExpression);
        this.setIsPrepared(false);
        this.setShouldOuterJoinSubclasses(true);
    }

    public boolean equals(Object object) {
        int index;
        int size;
        if (this == object) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        if (!this.isExpressionQuery() || !this.isDefaultPropertiesQuery()) {
            return super.equals(object);
        }
        ObjectLevelReadQuery query = (ObjectLevelReadQuery)object;
        if (!this.getExpressionBuilder().equals(query.getExpressionBuilder())) {
            return false;
        }
        if (this.hasJoining()) {
            if (!query.hasJoining()) {
                return false;
            }
            List<Expression> joinedAttributes = this.getJoinedAttributeManager().getJoinedAttributeExpressions();
            List<Expression> otherJoinedAttributes = query.getJoinedAttributeManager().getJoinedAttributeExpressions();
            size = joinedAttributes.size();
            if (size != otherJoinedAttributes.size()) {
                return false;
            }
            for (index = 0; index < size; ++index) {
                if (((Object)joinedAttributes.get(index)).equals(otherJoinedAttributes.get(index))) continue;
                return false;
            }
        } else if (query.hasJoining()) {
            return false;
        }
        if (this.hasOrderByExpressions()) {
            if (!query.hasOrderByExpressions()) {
                return false;
            }
            List<Expression> orderBys = this.getOrderByExpressions();
            List<Expression> otherOrderBys = query.getOrderByExpressions();
            size = orderBys.size();
            if (size != otherOrderBys.size()) {
                return false;
            }
            for (index = 0; index < size; ++index) {
                if (((Object)orderBys.get(index)).equals(otherOrderBys.get(index))) continue;
                return false;
            }
        } else if (query.hasOrderByExpressions()) {
            return false;
        }
        return (this.getReferenceClass() == query.getReferenceClass() || this.getReferenceClass() != null && this.getReferenceClass().equals(query.getReferenceClass())) && (this.getSelectionCriteria() == query.getSelectionCriteria() || this.getSelectionCriteria() != null && this.getSelectionCriteria().equals(query.getSelectionCriteria()));
    }

    public int hashCode() {
        if (!this.isExpressionQuery()) {
            return super.hashCode();
        }
        int hashCode = 32;
        if (this.getReferenceClass() != null) {
            hashCode += this.getReferenceClass().hashCode();
        }
        if (this.getSelectionCriteria() != null) {
            hashCode += this.getSelectionCriteria().hashCode();
        }
        return hashCode;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public void setIsReadOnly(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    @Override
    protected boolean wasDefaultLockMode() {
        return this.wasDefaultLockMode;
    }

    public void setWaitTimeout(Integer waitTimeout) {
        this.waitTimeout = waitTimeout;
        this.setIsPrePrepared(false);
        this.setIsPrepared(false);
        this.setWasDefaultLockMode(false);
    }

    @Override
    protected void setWasDefaultLockMode(boolean wasDefaultLockMode) {
        this.wasDefaultLockMode = wasDefaultLockMode;
    }

    @Override
    public Object clone() {
        ObjectLevelReadQuery cloneQuery = (ObjectLevelReadQuery)super.clone();
        if (this.joinedAttributeManager != null) {
            cloneQuery.joinedAttributeManager = this.joinedAttributeManager.clone();
            cloneQuery.joinedAttributeManager.setBaseQuery(cloneQuery);
        }
        if (this.batchFetchPolicy != null) {
            cloneQuery.batchFetchPolicy = this.batchFetchPolicy.clone();
        }
        if (this.nonFetchJoinAttributeExpressions != null) {
            cloneQuery.nonFetchJoinAttributeExpressions = new ArrayList<Expression>(this.nonFetchJoinAttributeExpressions);
        }
        if (this.orderByExpressions != null) {
            cloneQuery.orderByExpressions = new ArrayList<Expression>(this.orderByExpressions);
        }
        if (this.fetchGroup != null) {
            cloneQuery.fetchGroup = this.fetchGroup.clone();
        }
        return cloneQuery;
    }

    @Override
    public Object deepClone() {
        ObjectLevelReadQuery clone = (ObjectLevelReadQuery)this.clone();
        if (this.getSelectionCriteria() != null) {
            clone.setSelectionCriteria((Expression)this.getSelectionCriteria().clone());
        } else if (this.defaultBuilder != null) {
            clone.defaultBuilder = (ExpressionBuilder)this.defaultBuilder.clone();
        }
        return clone;
    }

    public void acquireLocks() {
        this.setLockMode((short)1);
        this.setIsPrepared(false);
    }

    public void acquireLocksWithoutWaiting() {
        this.setLockMode((short)2);
        this.setIsPrepared(false);
    }

    public void addAdditionalField(DatabaseField field) {
        this.getAdditionalFields().add(field);
        this.setIsPrepared(false);
    }

    public void addAdditionalField(Expression fieldExpression) {
        this.getAdditionalFields().add(fieldExpression);
        this.setIsPrepared(false);
    }

    public void addJoinedAttribute(String attributeName) {
        this.addJoinedAttribute(this.getExpressionBuilder().get(attributeName));
    }

    public void addJoinedAttribute(Expression attributeExpression) {
        this.getJoinedAttributeManager().addJoinedAttributeExpression(attributeExpression);
        this.setIsPrePrepared(false);
    }

    public void addNonFetchJoinedAttribute(String attributeName) {
        this.addNonFetchJoinedAttribute(this.getExpressionBuilder().get(attributeName));
    }

    public void addNonFetchJoinedAttribute(Expression attributeExpression) {
        this.getNonFetchJoinAttributeExpressions().add(attributeExpression);
        this.setIsPrePrepared(false);
    }

    public void addPartialAttribute(String attributeName) {
        this.addPartialAttribute(this.getExpressionBuilder().get(attributeName));
    }

    protected void addSelectionFieldsForJoinedExpression(List fields, boolean isCustomSQL, Expression expression) {
        ObjectLevelReadQuery nestedQuery;
        FetchGroup nestedFetchGroup;
        ForeignReferenceMapping mapping;
        ClassDescriptor referenceDescriptor;
        if (isCustomSQL) {
            ExpressionBuilder builder = expression.getBuilder();
            builder.setSession(this.getSession().getRootSession(null));
            builder.setQueryClass(this.getReferenceClass());
        }
        if ((referenceDescriptor = (mapping = (ForeignReferenceMapping)((QueryKeyExpression)expression).getMapping()).getReferenceDescriptor()) != null && referenceDescriptor.hasFetchGroupManager() && (nestedFetchGroup = (nestedQuery = this.getJoinedAttributeManager().getNestedJoinedMappingQuery(expression)).getExecutionFetchGroup()) != null) {
            List<DatabaseField> nestedFields = nestedQuery.getFetchGroupSelectionFields(mapping);
            for (DatabaseField field : nestedFields) {
                fields.add(new FieldExpression(field, expression));
            }
            return;
        }
        if (isCustomSQL) {
            if (referenceDescriptor != null) {
                fields.addAll(referenceDescriptor.getAllFields());
            } else {
                fields.add(expression);
            }
        } else {
            fields.add(expression);
        }
    }

    public void setAsOfClause(AsOfClause pastTime) {
        this.getExpressionBuilder().asOf(new UniversalAsOfClause(pastTime));
        this.setIsPrepared(false);
    }

    public void addPartialAttribute(Expression attributeExpression) {
        this.getPartialAttributeExpressions().add(attributeExpression);
        this.setIsPrepared(false);
    }

    @Override
    public Object buildObject(AbstractRecord row) {
        return this.descriptor.getObjectBuilder().buildObject(this, row);
    }

    public void checkCacheOnly() {
        this.setCacheUsage(4);
    }

    @Override
    public void checkDescriptor(AbstractSession session) throws QueryException {
        if (this.descriptor == null) {
            if (this.getReferenceClass() == null) {
                throw QueryException.referenceClassMissing(this);
            }
            ClassDescriptor referenceDescriptor = session.getDescriptor(this.getReferenceClass());
            if (referenceDescriptor == null) {
                throw QueryException.descriptorIsMissing(this.getReferenceClass(), this);
            }
            this.setDescriptor(referenceDescriptor);
        }
    }

    protected abstract Object checkEarlyReturnLocal(AbstractSession var1, AbstractRecord var2);

    @Override
    public Object checkEarlyReturn(AbstractSession session, AbstractRecord translationRow) {
        this.checkPrePrepare(session);
        if (!session.isUnitOfWork()) {
            return this.checkEarlyReturnLocal(session, translationRow);
        }
        UnitOfWorkImpl unitOfWork = (UnitOfWorkImpl)session;
        Object result = null;
        if (!this.descriptor.shouldBeReadOnly()) {
            result = this.checkEarlyReturnLocal(unitOfWork, translationRow);
        }
        if (result != null) {
            return result;
        }
        if (!unitOfWork.isNestedUnitOfWork() && (this.descriptor.shouldIsolateObjectsInUnitOfWork() || this.isLockQuery()) || unitOfWork.shouldForceReadFromDB(this, null)) {
            return null;
        }
        AbstractSession parentSession = unitOfWork.getParentIdentityMapSession(this);
        result = this.checkEarlyReturn(parentSession, translationRow);
        if (result != null) {
            if (result == InvalidObject.instance) {
                return result;
            }
            Object clone = this.registerResultInUnitOfWork(result, unitOfWork, translationRow, false);
            if (this.shouldConformResultsInUnitOfWork() && unitOfWork.isObjectDeleted(clone)) {
                return InvalidObject.instance;
            }
            return clone;
        }
        return null;
    }

    @Override
    public void checkPrepare(AbstractSession session, AbstractRecord translationRow, boolean force) {
        this.checkPrePrepare(session);
        super.checkPrepare(session, translationRow, force);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkPrePrepare(AbstractSession session) {
        if (!this.isPrePrepared) {
            ObjectLevelReadQuery objectLevelReadQuery = this;
            synchronized (objectLevelReadQuery) {
                if (!this.isPrePrepared()) {
                    AbstractSession alreadySetSession = this.getSession();
                    this.setSession(session);
                    this.prePrepare();
                    this.setSession(alreadySetSession);
                    this.setIsPrePrepared(true);
                }
            }
        } else {
            this.checkDescriptor(session);
        }
    }

    public void changeDescriptor(AbstractSession theSession) {
        this.setDescriptor(null);
        this.checkDescriptor(theSession);
    }

    protected Object conformIndividualResult(Object clone, UnitOfWorkImpl unitOfWork, AbstractRecord arguments, Expression selectionCriteriaClone, Map alreadyReturned) {
        if (this.descriptor.hasWrapperPolicy() && this.descriptor.getWrapperPolicy().isWrapped(clone)) {
            return clone;
        }
        if (unitOfWork.isObjectDeleted(clone)) {
            return null;
        }
        if (!this.isExpressionQuery() || selectionCriteriaClone == null || this.isPrimaryKeyQuery()) {
            if (alreadyReturned != null) {
                alreadyReturned.remove(clone);
            }
            return clone;
        }
        try {
            int policy = this.getInMemoryQueryIndirectionPolicyState();
            if (policy != 1) {
                policy = 2;
            }
            if (selectionCriteriaClone.doesConform(clone, unitOfWork, arguments, policy)) {
                if (alreadyReturned != null) {
                    alreadyReturned.remove(clone);
                }
                return clone;
            }
        }
        catch (QueryException exception) {
            if (unitOfWork.getShouldThrowConformExceptions() == 1 && exception.getErrorCode() != 6092) {
                throw exception;
            }
            if (alreadyReturned != null) {
                alreadyReturned.remove(clone);
            }
            return clone;
        }
        return null;
    }

    public void conformResultsInUnitOfWork() {
        this.setCacheUsage(5);
    }

    public void dontAcquireLocks() {
        this.setLockMode((short)0);
        this.setIsPrepared(false);
    }

    public void dontCheckCache() {
        this.setCacheUsage(0);
    }

    @Override
    public void dontRefreshIdentityMapResult() {
        this.setShouldRefreshIdentityMapResult(false);
    }

    @Override
    public void dontRefreshRemoteIdentityMapResult() {
        this.setShouldRefreshRemoteIdentityMapResult(false);
    }

    public void dontUseDistinct() {
        this.setDistinctState((short)2);
        this.setIsPrepared(false);
    }

    public DatabaseQuery prepareOutsideUnitOfWork(AbstractSession session) {
        if (this.isLockQuery(session) && this.getLockingClause().isForUpdateOfClause()) {
            ObjectLevelReadQuery clone = (ObjectLevelReadQuery)this.clone();
            clone.setIsExecutionClone(true);
            clone.dontAcquireLocks();
            clone.setIsPrepared(false);
            clone.checkPrePrepare(session);
            return clone;
        }
        return this;
    }

    @Override
    public Object execute(AbstractSession session, AbstractRecord translationRow) throws DatabaseException, OptimisticLockException {
        if (this.shouldRefreshIdentityMapResult() && this.shouldCheckCacheOnly()) {
            throw QueryException.refreshNotPossibleWithCheckCacheOnly(this);
        }
        return super.execute(session, translationRow);
    }

    @Override
    public Object executeDatabaseQuery() throws DatabaseException {
        Object result;
        if (this.isResultSetOptimizedQuery) {
            return this.executeObjectLevelReadQueryFromResultSet();
        }
        if (this.getSession().isUnitOfWork()) {
            UnitOfWorkImpl unitOfWork = (UnitOfWorkImpl)this.getSession();
            if (this.isLockQuery() && !unitOfWork.getCommitManager().isActive() && !unitOfWork.wasTransactionBegunPrematurely()) {
                unitOfWork.beginTransaction();
                unitOfWork.setWasTransactionBegunPrematurely(true);
            }
            if (unitOfWork.isNestedUnitOfWork()) {
                UnitOfWorkImpl nestedUnitOfWork = (UnitOfWorkImpl)this.getSession();
                this.setSession(nestedUnitOfWork.getParent());
                Object result2 = this.executeDatabaseQuery();
                this.setSession(nestedUnitOfWork);
                return this.registerResultInUnitOfWork(result2, nestedUnitOfWork, this.getTranslationRow(), false);
            }
        }
        this.session.validateQuery(this);
        if (this.getQueryId() == 0L) {
            this.setQueryId(this.getSession().getNextQueryId());
        }
        if ((result = this.executeObjectLevelReadQuery()) != null) {
            if (this.loadGroup != null) {
                Object resultToLoad = result;
                if (this.shouldIncludeData) {
                    resultToLoad = ((ComplexQueryResult)result).getResult();
                }
                this.getSession().load(resultToLoad, this.loadGroup);
            } else {
                LoadGroup lg;
                FetchGroup executionFetchGroup = this.getExecutionFetchGroup();
                if (executionFetchGroup != null && (lg = executionFetchGroup.toLoadGroupLoadOnly()) != null) {
                    Object resultToLoad = result;
                    if (this.shouldIncludeData) {
                        resultToLoad = ((ComplexQueryResult)result).getResult();
                    }
                    this.getSession().load(resultToLoad, lg);
                }
            }
        }
        return result;
    }

    protected abstract Object executeObjectLevelReadQuery() throws DatabaseException;

    protected abstract Object executeObjectLevelReadQueryFromResultSet() throws DatabaseException;

    @Override
    public Object executeInUnitOfWork(UnitOfWorkImpl unitOfWork, AbstractRecord translationRow) throws DatabaseException, OptimisticLockException {
        Object result = null;
        result = !this.shouldMaintainCache() || this.isReadOnly() ? unitOfWork.getParent().executeQuery((DatabaseQuery)this, translationRow) : this.execute(unitOfWork, translationRow);
        if (this.lockModeType != null && result != null && (this.lockModeType.equals(READ) || this.lockModeType.equals(WRITE) || this.lockModeType.contains(OPTIMISTIC) || this.lockModeType.equals(PESSIMISTIC_FORCE_INCREMENT))) {
            boolean forceUpdateToVersionField;
            boolean bl = forceUpdateToVersionField = this.lockModeType.equals(WRITE) || this.lockModeType.equals(OPTIMISTIC_FORCE_INCREMENT) || this.lockModeType.equals(PESSIMISTIC_FORCE_INCREMENT);
            if (result instanceof Collection) {
                for (Object obj : (Collection)result) {
                    if (obj == null) continue;
                    if (obj instanceof Object[]) {
                        for (Object o : (Object[])obj) {
                            if (o == null) continue;
                            unitOfWork.forceUpdateToVersionField(o, forceUpdateToVersionField);
                        }
                        continue;
                    }
                    unitOfWork.forceUpdateToVersionField(obj, forceUpdateToVersionField);
                }
            } else {
                unitOfWork.forceUpdateToVersionField(result, forceUpdateToVersionField);
            }
        }
        return result;
    }

    public List<Object> getAdditionalFields() {
        if (this.additionalFields == null) {
            this.additionalFields = new ArrayList<Object>();
        }
        return this.additionalFields;
    }

    public AsOfClause getAsOfClause() {
        return this.defaultBuilder != null ? this.defaultBuilder.getAsOfClause() : null;
    }

    public int getCacheUsage() {
        return this.cacheUsage;
    }

    public short getDistinctState() {
        return this.distinctState;
    }

    public Object getExampleObject() {
        if (this.getQueryMechanism().isQueryByExampleMechanism()) {
            return ((QueryByExampleMechanism)this.getQueryMechanism()).getExampleObject();
        }
        return null;
    }

    public ExpressionBuilder getExpressionBuilder() {
        if (this.defaultBuilder == null) {
            this.initializeDefaultBuilder();
        }
        return this.defaultBuilder;
    }

    public void setExpressionBuilder(ExpressionBuilder builder) {
        this.defaultBuilder = builder;
    }

    public int getInMemoryQueryIndirectionPolicyState() {
        return this.inMemoryQueryIndirectionPolicy;
    }

    public InMemoryQueryIndirectionPolicy getInMemoryQueryIndirectionPolicy() {
        return new InMemoryQueryIndirectionPolicy(this.inMemoryQueryIndirectionPolicy, this);
    }

    public JoinedAttributeManager getJoinedAttributeManager() {
        if (this.joinedAttributeManager == null) {
            this.joinedAttributeManager = new JoinedAttributeManager(this.getDescriptor(), this.getExpressionBuilder(), this);
        }
        return this.joinedAttributeManager;
    }

    public void setJoinedAttributeManager(JoinedAttributeManager joinedAttributeManager) {
        this.joinedAttributeManager = joinedAttributeManager;
    }

    public boolean hasJoining() {
        return this.joinedAttributeManager != null;
    }

    public List getJoinedAttributeExpressions() {
        return this.getJoinedAttributeManager().getJoinedAttributeExpressions();
    }

    public void setJoinedAttributeExpressions(List expressions) {
        if (expressions != null && !expressions.isEmpty() || this.hasJoining()) {
            this.getJoinedAttributeManager().setJoinedAttributeExpressions_(expressions);
        }
    }

    public List<Expression> getOrderByExpressions() {
        if (this.orderByExpressions == null) {
            this.orderByExpressions = new ArrayList<Expression>();
        }
        return this.orderByExpressions;
    }

    public void setOrderByExpressions(List<Expression> orderByExpressions) {
        this.orderByExpressions = orderByExpressions;
    }

    public boolean hasOrderByExpressions() {
        return this.orderByExpressions != null && !this.orderByExpressions.isEmpty();
    }

    public boolean shouldFilterDuplicates() {
        if (this.hasJoining()) {
            return this.getJoinedAttributeManager().shouldFilterDuplicates();
        }
        return true;
    }

    public void setShouldFilterDuplicates(boolean shouldFilterDuplicates) {
        this.getJoinedAttributeManager().setShouldFilterDuplicates(shouldFilterDuplicates);
    }

    public DatabaseMapping getLeafMappingFor(Expression expression, ClassDescriptor rootDescriptor) throws QueryException {
        if (expression == null || expression.isFieldExpression()) {
            return null;
        }
        if (!expression.isQueryKeyExpression()) {
            return null;
        }
        if (expression.isMapEntryExpression()) {
            MapEntryExpression teExpression = (MapEntryExpression)expression;
            QueryKeyExpression baseExpression = (QueryKeyExpression)teExpression.getBaseExpression();
            Expression owningExpression = baseExpression.getBaseExpression();
            ClassDescriptor owningDescriptor = this.getLeafDescriptorFor(owningExpression, rootDescriptor);
            CollectionMapping mapping = (CollectionMapping)owningDescriptor.getObjectBuilder().getMappingForAttributeName(baseExpression.getName());
            if (teExpression.shouldReturnMapEntry()) {
                return mapping;
            }
            if (mapping.getContainerPolicy().isMappedKeyMapPolicy()) {
                MappedKeyMapContainerPolicy policy = (MappedKeyMapContainerPolicy)mapping.getContainerPolicy();
                return (DatabaseMapping)((Object)policy.getKeyMapping());
            }
            return mapping;
        }
        QueryKeyExpression qkExpression = (QueryKeyExpression)expression;
        Expression baseExpression = qkExpression.getBaseExpression();
        ClassDescriptor descriptor = this.getLeafDescriptorFor(baseExpression, rootDescriptor);
        if (descriptor == null) {
            return null;
        }
        return descriptor.getObjectBuilder().getMappingForAttributeName(qkExpression.getName());
    }

    public ClassDescriptor getLeafDescriptorFor(Expression expression, ClassDescriptor rootDescriptor) throws QueryException {
        if (expression.isExpressionBuilder()) {
            Class queryClass = ((ExpressionBuilder)expression).getQueryClass();
            if (queryClass != null && queryClass != this.getReferenceClass()) {
                return this.getSession().getDescriptor(queryClass);
            }
            return rootDescriptor;
        }
        Expression baseExpression = ((QueryKeyExpression)expression).getBaseExpression();
        ClassDescriptor baseDescriptor = this.getLeafDescriptorFor(baseExpression, rootDescriptor);
        if (expression.isMapEntryExpression()) {
            Expression owningExpression = ((QueryKeyExpression)baseExpression).getBaseExpression();
            ClassDescriptor owningDescriptor = this.getLeafDescriptorFor(owningExpression, rootDescriptor);
            CollectionMapping mapping = (CollectionMapping)owningDescriptor.getObjectBuilder().getMappingForAttributeName(baseExpression.getName());
            return ((MapContainerPolicy)mapping.getContainerPolicy()).getDescriptorForMapKey();
        }
        ClassDescriptor descriptor = null;
        String attributeName = expression.getName();
        DatabaseMapping mapping = baseDescriptor.getObjectBuilder().getMappingForAttributeName(attributeName);
        if (mapping == null) {
            QueryKey queryKey = baseDescriptor.getQueryKeyNamed(attributeName);
            if (queryKey != null) {
                descriptor = queryKey.isForeignReferenceQueryKey() ? this.getSession().getDescriptor(((ForeignReferenceQueryKey)queryKey).getReferenceClass()) : queryKey.getDescriptor();
            }
            if (descriptor == null) {
                throw QueryException.invalidExpressionForQueryItem(expression, this);
            }
        } else if (mapping.isAggregateObjectMapping()) {
            descriptor = ((AggregateObjectMapping)mapping).getReferenceDescriptor();
        } else if (mapping.isForeignReferenceMapping()) {
            descriptor = ((ForeignReferenceMapping)mapping).getReferenceDescriptor();
        }
        return descriptor;
    }

    @Override
    public short getLockMode() {
        if (this.lockingClause == null) {
            return -1;
        }
        return this.lockingClause.getLockMode();
    }

    public ForUpdateClause getLockingClause() {
        return this.lockingClause;
    }

    public List<Expression> getNonFetchJoinAttributeExpressions() {
        if (this.nonFetchJoinAttributeExpressions == null) {
            this.nonFetchJoinAttributeExpressions = new ArrayList<Expression>();
        }
        return this.nonFetchJoinAttributeExpressions;
    }

    public List<Expression> getPartialAttributeExpressions() {
        if (this.partialAttributeExpressions == null) {
            this.partialAttributeExpressions = new ArrayList<Expression>();
        }
        return this.partialAttributeExpressions;
    }

    public QueryByExamplePolicy getQueryByExamplePolicy() {
        if (this.getQueryMechanism().isQueryByExampleMechanism()) {
            return ((QueryByExampleMechanism)this.getQueryMechanism()).getQueryByExamplePolicy();
        }
        return null;
    }

    @Override
    public Class getReferenceClass() {
        return this.referenceClass;
    }

    @Override
    public String getReferenceClassName() {
        if (this.referenceClassName == null && this.referenceClass != null) {
            this.referenceClassName = this.referenceClass.getName();
        }
        return this.referenceClassName;
    }

    public boolean hasAsOfClause() {
        return this.defaultBuilder != null && this.defaultBuilder.hasAsOfClause();
    }

    public boolean hasNonFetchJoinedAttributeExpressions() {
        return this.nonFetchJoinAttributeExpressions != null && !this.nonFetchJoinAttributeExpressions.isEmpty();
    }

    @Override
    public boolean hasPartialAttributeExpressions() {
        return this.partialAttributeExpressions != null && !this.partialAttributeExpressions.isEmpty();
    }

    public boolean hasAdditionalFields() {
        return this.additionalFields != null && !this.additionalFields.isEmpty();
    }

    public Vector getPartialAttributeSelectionFields(boolean isCustomSQL) {
        NonSynchronizedVector localFields = NonSynchronizedVector.newInstance(this.getPartialAttributeExpressions().size());
        NonSynchronizedVector foreignFields = null;
        ((Vector)localFields).addAll(this.getDescriptor().getPrimaryKeyFields());
        if (this.getDescriptor().hasInheritance() && this.getDescriptor().getInheritancePolicy().getClassIndicatorField() != null) {
            ((Vector)localFields).addElement(this.getDescriptor().getInheritancePolicy().getClassIndicatorField());
        }
        for (Expression expression : this.getPartialAttributeExpressions()) {
            if (expression.isQueryKeyExpression()) {
                ((QueryKeyExpression)expression).getBuilder().setSession(this.session.getRootSession(null));
                ((QueryKeyExpression)expression).getBuilder().setQueryClass(this.getDescriptor().getJavaClass());
                DatabaseMapping mapping = ((QueryKeyExpression)expression).getMapping();
                if (!((QueryKeyExpression)expression).getBaseExpression().isExpressionBuilder()) {
                    if (foreignFields == null) {
                        foreignFields = NonSynchronizedVector.newInstance();
                    }
                    if (!isCustomSQL) {
                        ((Vector)foreignFields).add(expression);
                        continue;
                    }
                    ((Vector)foreignFields).addAll(expression.getFields());
                    continue;
                }
                if (mapping == null) {
                    throw QueryException.specifiedPartialAttributeDoesNotExist(this, expression.getName(), this.descriptor.getJavaClass().getName());
                }
                if (mapping.isForeignReferenceMapping()) {
                    if (foreignFields == null) {
                        foreignFields = NonSynchronizedVector.newInstance();
                    }
                    if (!isCustomSQL) {
                        ((Vector)foreignFields).add(expression);
                        continue;
                    }
                    ((Vector)foreignFields).addAll(expression.getFields());
                    continue;
                }
                ((Vector)localFields).addAll(expression.getFields());
                continue;
            }
            throw QueryException.expressionDoesNotSupportPartialAttributeReading(expression);
        }
        NonSynchronizedVector selectionFields = NonSynchronizedVector.newInstance();
        for (DatabaseField field : this.getDescriptor().getFields()) {
            if (localFields.contains(field)) {
                ((Vector)selectionFields).add(field);
                continue;
            }
            ((Vector)selectionFields).add(null);
        }
        if (foreignFields != null) {
            ((Vector)selectionFields).addAll(foreignFields);
        }
        return selectionFields;
    }

    public Set<DatabaseField> getFetchGroupNonNestedFieldsSet() {
        return this.getFetchGroupNonNestedFieldsSet(null);
    }

    public Set<DatabaseField> getFetchGroupNonNestedFieldsSet(DatabaseMapping nestedMapping) {
        List<DatabaseField> additionalFields;
        DatabaseField lockField;
        HashSet<DatabaseField> fetchedFields = new HashSet<DatabaseField>(this.getExecutionFetchGroup().getAttributeNames().size());
        fetchedFields.addAll(this.getDescriptor().getPrimaryKeyFields());
        if (this.getDescriptor().hasInheritance() && this.getDescriptor().getInheritancePolicy().getClassIndicatorField() != null) {
            fetchedFields.add(this.getDescriptor().getInheritancePolicy().getClassIndicatorField());
        }
        if (this.shouldMaintainCache() && this.getDescriptor().usesOptimisticLocking() && (lockField = this.getDescriptor().getOptimisticLockingPolicy().getWriteLockField()) != null) {
            fetchedFields.add(lockField);
        }
        for (String attribute : this.getExecutionFetchGroup().getAttributeNames()) {
            DatabaseMapping mapping = this.getDescriptor().getObjectBuilder().getMappingForAttributeName(attribute);
            if (mapping == null) {
                throw QueryException.fetchGroupAttributeNotMapped(attribute);
            }
            fetchedFields.addAll(mapping.getFields());
        }
        if (nestedMapping != null && nestedMapping.isCollectionMapping() && (additionalFields = nestedMapping.getContainerPolicy().getAdditionalFieldsForJoin((CollectionMapping)nestedMapping)) != null) {
            fetchedFields.addAll(additionalFields);
        }
        return fetchedFields;
    }

    public List<DatabaseField> getFetchGroupSelectionFields() {
        return this.getFetchGroupSelectionFields(null);
    }

    protected List<DatabaseField> getFetchGroupSelectionFields(DatabaseMapping nestedMapping) {
        Set<DatabaseField> fetchedFields = this.getFetchGroupNonNestedFieldsSet(nestedMapping);
        ArrayList<DatabaseField> fields = new ArrayList<DatabaseField>(fetchedFields.size());
        for (DatabaseField field : this.getDescriptor().getFields()) {
            if (!fetchedFields.contains(field)) continue;
            fields.add(field);
        }
        return fields;
    }

    public void addJoinSelectionFields(Vector fields, boolean isCustomSQL) {
        FetchGroup executionFetchGroup = null;
        if (this.session.shouldLog(6, "query")) {
            executionFetchGroup = this.getExecutionFetchGroup();
        }
        for (Expression expression : this.getJoinedAttributeManager().getJoinedAttributeExpressions()) {
            String nestedAttributeName;
            this.addSelectionFieldsForJoinedExpression(fields, isCustomSQL, expression);
            if (executionFetchGroup == null || (nestedAttributeName = ((QueryKeyExpression)expression).getNestedAttributeName()) == null || executionFetchGroup.containsAttribute(nestedAttributeName)) continue;
            this.getSession().log(6, "query", "query_has_joined_attribute_outside_fetch_group", new Object[]{this.toString(), nestedAttributeName});
        }
        for (Expression expression : this.getJoinedAttributeManager().getJoinedMappingExpressions()) {
            this.addSelectionFieldsForJoinedExpression(fields, isCustomSQL, expression);
        }
    }

    public Vector getSelectionFields() {
        if (this.hasPartialAttributeExpressions()) {
            return this.getPartialAttributeSelectionFields(true);
        }
        NonSynchronizedVector fields = NonSynchronizedVector.newInstance();
        if (this.getExecutionFetchGroup() != null) {
            ((Vector)fields).addAll(this.getFetchGroupSelectionFields());
        } else {
            ((Vector)fields).addAll(this.getDescriptor().getAllFields());
        }
        if (this.hasJoining()) {
            this.addJoinSelectionFields(fields, true);
        }
        if (this.hasAdditionalFields()) {
            ((Vector)fields).addAll(this.getAdditionalFields());
        }
        return fields;
    }

    public Integer getWaitTimeout() {
        return this.waitTimeout;
    }

    protected void initializeDefaultBuilder() {
        DatabaseQueryMechanism mech = this.getQueryMechanism();
        if (mech.isExpressionQueryMechanism() && ((ExpressionQueryMechanism)mech).getExpressionBuilder() != null) {
            this.defaultBuilder = ((ExpressionQueryMechanism)mech).getExpressionBuilder();
            if (this.defaultBuilder.getQueryClass() != null && !this.defaultBuilder.getQueryClass().equals(this.referenceClass)) {
                this.defaultBuilder = new ExpressionBuilder();
            }
            return;
        }
        this.defaultBuilder = new ExpressionBuilder();
    }

    public boolean isDistinctComputed() {
        return this.getDistinctState() != 0;
    }

    @Override
    public boolean isLockQuery() {
        return this.lockingClause != null && this.getLockMode() > 0;
    }

    public boolean isLockQuery(Session session) {
        this.checkPrePrepare((AbstractSession)session);
        return this.isLockQuery();
    }

    @Override
    public boolean isObjectLevelReadQuery() {
        return true;
    }

    public boolean isPartialAttribute(String attributeName) {
        if (!this.hasPartialAttributeExpressions()) {
            return false;
        }
        List<Expression> partialAttributeExpressions = this.getPartialAttributeExpressions();
        int size = partialAttributeExpressions.size();
        for (int index = 0; index < size; ++index) {
            QueryKeyExpression expression = (QueryKeyExpression)partialAttributeExpressions.get(index);
            while (!expression.getBaseExpression().isExpressionBuilder()) {
                expression = (QueryKeyExpression)expression.getBaseExpression();
            }
            if (!expression.getName().equals(attributeName)) continue;
            return true;
        }
        return false;
    }

    public boolean shouldExtendPessimisticLockScope() {
        return this.shouldExtendPessimisticLockScope;
    }

    protected boolean isPrePrepared() {
        return this.isPrePrepared;
    }

    protected void setIsPrePrepared(boolean isPrePrepared) {
        if (this.isPrePrepared && !isPrePrepared) {
            this.setIsPrepared(false);
            if (this.hasJoining()) {
                this.getJoinedAttributeManager().reset();
            }
        }
        this.isPrePrepared = isPrePrepared;
    }

    public void setShouldExtendPessimisticLockScope(boolean isExtended) {
        this.shouldExtendPessimisticLockScope = isExtended;
    }

    @Override
    public void setIsPrepared(boolean isPrepared) {
        super.setIsPrepared(isPrepared);
        this.isReferenceClassLocked = null;
        this.concreteSubclassCalls = null;
    }

    @Override
    protected void prepare() throws QueryException {
        super.prepare();
        this.prepareQuery();
        if (this.hasJoining()) {
            this.getJoinedAttributeManager().computeJoiningMappingQueries(this.session);
        }
        this.computeBatchReadMappingQueries();
    }

    protected boolean prepareFromCachedQuery() {
        boolean isCacheable = this.isExpressionQuery() && !this.getQueryMechanism().isJPQLCallQueryMechanism() && this.isDefaultPropertiesQuery() && !this.getSession().isHistoricalSession();
        DatabaseQuery cachedQuery = null;
        if (!isCacheable) {
            return false;
        }
        cachedQuery = this.descriptor.getQueryManager().getCachedExpressionQuery(this);
        if (cachedQuery != null && cachedQuery.isPrepared()) {
            this.prepareFromQuery(cachedQuery);
            this.setIsPrepared(true);
            return true;
        }
        this.descriptor.getQueryManager().putCachedExpressionQuery(this);
        this.isExecutionClone = false;
        return false;
    }

    @Override
    public void copyFromQuery(DatabaseQuery query) {
        super.copyFromQuery(query);
        if (query.isObjectLevelReadQuery()) {
            ObjectLevelReadQuery readQuery = (ObjectLevelReadQuery)query;
            this.cacheUsage = readQuery.cacheUsage;
            this.isReadOnly = readQuery.isReadOnly;
            this.isResultSetOptimizedQuery = readQuery.isResultSetOptimizedQuery;
            this.shouldIncludeData = readQuery.shouldIncludeData;
            this.inMemoryQueryIndirectionPolicy = readQuery.inMemoryQueryIndirectionPolicy;
            this.lockModeType = readQuery.lockModeType;
            this.defaultBuilder = readQuery.defaultBuilder;
        }
    }

    @Override
    public void prepareFromQuery(DatabaseQuery query) {
        super.prepareFromQuery(query);
        if (query.isObjectLevelReadQuery()) {
            ObjectLevelReadQuery objectQuery = (ObjectLevelReadQuery)query;
            this.referenceClass = objectQuery.referenceClass;
            this.distinctState = objectQuery.distinctState;
            if (objectQuery.hasJoining()) {
                JoinedAttributeManager thisManager = this.getJoinedAttributeManager();
                JoinedAttributeManager queryManager = objectQuery.getJoinedAttributeManager();
                thisManager.setJoinedAttributeExpressions_(queryManager.getJoinedAttributeExpressions());
                thisManager.setJoinedMappingExpressions_(queryManager.getJoinedMappingExpressions());
                thisManager.setJoinedMappingIndexes_(queryManager.getJoinedMappingIndexes_());
                thisManager.setJoinedMappingQueries_(queryManager.getJoinedMappingQueries_());
                thisManager.setOrderByExpressions_(queryManager.getOrderByExpressions_());
                thisManager.setAdditionalFieldExpressions_(queryManager.getAdditionalFieldExpressions_());
            }
            if (objectQuery.hasBatchReadAttributes()) {
                this.batchFetchPolicy = objectQuery.getBatchFetchPolicy().clone();
            }
            this.nonFetchJoinAttributeExpressions = objectQuery.nonFetchJoinAttributeExpressions;
            this.defaultBuilder = objectQuery.defaultBuilder;
            this.fetchGroup = objectQuery.fetchGroup;
            this.fetchGroupName = objectQuery.fetchGroupName;
            this.isReferenceClassLocked = objectQuery.isReferenceClassLocked;
            this.shouldOuterJoinSubclasses = objectQuery.shouldOuterJoinSubclasses;
            this.shouldUseDefaultFetchGroup = objectQuery.shouldUseDefaultFetchGroup;
            this.concreteSubclassCalls = objectQuery.concreteSubclassCalls;
            this.additionalFields = objectQuery.additionalFields;
            this.partialAttributeExpressions = objectQuery.partialAttributeExpressions;
            if (objectQuery.hasOrderByExpressions()) {
                this.orderByExpressions = objectQuery.orderByExpressions;
            }
        }
    }

    public void prepareFetchGroup() throws QueryException {
        FetchGroupManager fetchGroupManager = this.descriptor.getFetchGroupManager();
        if (fetchGroupManager != null) {
            FetchGroup executionFetchGroup;
            if (this.fetchGroup == null && this.fetchGroupName != null) {
                this.fetchGroup = fetchGroupManager.getFetchGroup(this.fetchGroupName);
            }
            if ((executionFetchGroup = this.getExecutionFetchGroup()) != null) {
                if (this.hasPartialAttributeExpressions()) {
                    throw QueryException.fetchGroupNotSupportOnPartialAttributeReading();
                }
                if (this.fetchGroup != null) {
                    this.descriptor.getFetchGroupManager().prepareAndVerify(this.fetchGroup);
                    this.entityFetchGroup = fetchGroupManager.getEntityFetchGroup(this.fetchGroup);
                } else {
                    this.entityFetchGroup = null;
                }
            }
        } else if (this.fetchGroup != null || this.fetchGroupName != null) {
            throw QueryException.fetchGroupValidOnlyIfFetchGroupManagerInDescriptor(this.getDescriptor().getJavaClassName(), this.getName());
        }
    }

    protected void prePrepare() throws QueryException {
        this.buildSelectionCriteria(this.session);
        this.checkDescriptor(this.session);
        if (this.hasJoining()) {
            this.getJoinedAttributeManager().prepareJoinExpressions(this.session);
        }
        this.prepareFetchGroup();
        if (this.getQueryMechanism().isExpressionQueryMechanism() && this.getDescriptor().getObjectBuilder().hasJoinedAttributes()) {
            Iterator<Expression> it;
            this.getJoinedAttributeManager().processJoinedMappings(this.session);
            if (this.getJoinedAttributeManager().hasOrderByExpressions()) {
                it = this.getJoinedAttributeManager().getOrderByExpressions().iterator();
                while (it.hasNext()) {
                    this.addOrdering(it.next());
                }
            }
            if (this.getJoinedAttributeManager().hasAdditionalFieldExpressions()) {
                it = this.getJoinedAttributeManager().getAdditionalFieldExpressions().iterator();
                while (it.hasNext()) {
                    this.addAdditionalField(it.next());
                }
            }
        }
        if (this.lockModeType != null) {
            if (this.lockModeType.equals(NONE)) {
                this.setLockMode((short)0);
            } else if (this.lockModeType.contains(PESSIMISTIC_)) {
                Integer timeout;
                Integer n = timeout = this.waitTimeout == null ? this.getSession().getPessimisticLockTimeoutDefault() : this.waitTimeout;
                if (timeout == null) {
                    this.setLockMode((short)1);
                } else if (timeout == 0) {
                    this.setLockMode((short)2);
                } else {
                    this.lockingClause = ForUpdateClause.newInstance(timeout);
                }
            }
        }
        if (this.isDefaultLock()) {
            this.setWasDefaultLockMode(true);
            ForUpdateOfClause lockingClause = null;
            if (this.hasJoining()) {
                lockingClause = this.getJoinedAttributeManager().setupLockingClauseForJoinedExpressions(lockingClause, this.getSession());
            }
            if (this.descriptor.hasPessimisticLockingPolicy()) {
                lockingClause = new ForUpdateOfClause();
                lockingClause.setLockMode(this.descriptor.getCMPPolicy().getPessimisticLockingPolicy().getLockingMode());
                lockingClause.addLockedExpression(this.getExpressionBuilder());
            }
            if (lockingClause == null) {
                this.lockingClause = ForUpdateClause.newInstance((short)0);
            } else {
                this.lockingClause = lockingClause;
                this.dontUseDistinct();
            }
        } else if (this.getLockMode() == 0 && !this.descriptor.hasPessimisticLockingPolicy()) {
            this.setWasDefaultLockMode(true);
        }
        this.setRequiresDeferredLocks(DeferredLockManager.SHOULD_USE_DEFERRED_LOCKS && (this.hasJoining() || this.descriptor.shouldAcquireCascadedLocks()));
        if (this.hasJoining() && this.hasPartialAttributeExpressions()) {
            this.session.log(6, "query", "query_has_both_join_attributes_and_partial_attributes", new Object[]{this, this.getName()});
        }
    }

    protected void prepareQuery() throws QueryException {
        if (!this.shouldMaintainCache() && this.shouldRefreshIdentityMapResult() && !this.descriptor.isAggregateCollectionDescriptor()) {
            throw QueryException.refreshNotPossibleWithoutCache(this);
        }
        if (this.shouldMaintainCache() && this.hasPartialAttributeExpressions()) {
            throw QueryException.cannotCachePartialObjects(this);
        }
        if (this.descriptor.isAggregateDescriptor()) {
            throw QueryException.aggregateObjectCannotBeDeletedOrWritten(this.descriptor, this);
        }
        if (this.hasAsOfClause() && this.getSession().getAsOfClause() == null) {
            if (this.shouldMaintainCache()) {
                throw QueryException.historicalQueriesMustPreserveGlobalCache();
            }
            if (!this.getSession().getPlatform().isOracle() && !this.getSession().getProject().hasGenericHistorySupport()) {
                throw QueryException.historicalQueriesOnlySupportedOnOracle();
            }
        }
        if (this.hasPartialAttributeExpressions()) {
            for (int index = 0; index < this.getPartialAttributeExpressions().size(); ++index) {
                Expression expression = this.getPartialAttributeExpressions().get(index);
                while (expression.isQueryKeyExpression() && !expression.isExpressionBuilder()) {
                    if (((QueryKeyExpression)expression).shouldQueryToManyRelationship()) {
                        this.getJoinedAttributeManager().setIsToManyJoinQuery(true);
                    }
                    expression = ((QueryKeyExpression)expression).getBaseExpression();
                }
            }
        }
        if (!this.shouldOuterJoinSubclasses()) {
            this.setShouldOuterJoinSubclasses(this.getMaxRows() > 0 || this.getFirstResult() > 0 || this.descriptor != null && this.descriptor.hasInheritance() && this.descriptor.getInheritancePolicy().shouldOuterJoinSubclasses());
        }
        if (!this.shouldOuterJoinSubclasses() && this.descriptor.hasInheritance() && this.descriptor.getInheritancePolicy().requiresMultipleTableSubclassRead()) {
            this.getConcreteSubclassCalls();
        }
    }

    @Override
    protected void prepareForRemoteExecution() throws QueryException {
        super.prepareForRemoteExecution();
        this.checkPrePrepare(this.getSession());
        this.prepareQuery();
    }

    @Override
    public void refreshIdentityMapResult() {
        this.setShouldRefreshIdentityMapResult(true);
    }

    @Override
    public void refreshRemoteIdentityMapResult() {
        this.setShouldRefreshRemoteIdentityMapResult(true);
    }

    public abstract Object registerResultInUnitOfWork(Object var1, UnitOfWorkImpl var2, AbstractRecord var3, boolean var4);

    public void resetDistinct() {
        this.setDistinctState((short)0);
        this.setIsPrepared(false);
    }

    public void setAdditionalFields(List<Object> additionalFields) {
        this.additionalFields = additionalFields;
    }

    public boolean shouldCheckCache() {
        return this.cacheUsage != 0;
    }

    public void setCacheUsage(int cacheUsage) {
        this.cacheUsage = cacheUsage;
    }

    @Override
    public void setDescriptor(ClassDescriptor descriptor) {
        super.setDescriptor(descriptor);
        if (this.joinedAttributeManager != null) {
            this.joinedAttributeManager.setDescriptor(descriptor);
        }
    }

    public void setDistinctState(short distinctState) {
        this.distinctState = distinctState;
    }

    public void setExampleObject(Object newExampleObject) {
        if (!this.getQueryMechanism().isQueryByExampleMechanism()) {
            this.setQueryMechanism(new QueryByExampleMechanism((DatabaseQuery)this, this.getSelectionCriteria()));
            ((QueryByExampleMechanism)this.getQueryMechanism()).setExampleObject(newExampleObject);
            this.setIsPrepared(false);
        } else {
            ((QueryByExampleMechanism)this.getQueryMechanism()).setExampleObject(newExampleObject);
            if (this.isPrepared() || !this.shouldPrepare() && ((QueryByExampleMechanism)this.getQueryMechanism()).isParsed()) {
                ((QueryByExampleMechanism)this.getQueryMechanism()).setIsParsed(false);
                this.setSelectionCriteria(null);
            }
        }
        if (newExampleObject != null) {
            this.setReferenceClass(newExampleObject.getClass());
        }
    }

    public void setInMemoryQueryIndirectionPolicy(InMemoryQueryIndirectionPolicy inMemoryQueryIndirectionPolicy) {
        if (inMemoryQueryIndirectionPolicy != null) {
            this.inMemoryQueryIndirectionPolicy = inMemoryQueryIndirectionPolicy.getPolicy();
            inMemoryQueryIndirectionPolicy.setQuery(this);
        }
    }

    public void setInMemoryQueryIndirectionPolicyState(int inMemoryQueryIndirectionPolicy) {
        this.inMemoryQueryIndirectionPolicy = inMemoryQueryIndirectionPolicy;
    }

    @Override
    public void setLockMode(short lockMode) {
        if (lockMode == 1 || lockMode == 2) {
            this.lockingClause = ForUpdateClause.newInstance(lockMode);
            this.setShouldRefreshIdentityMapResult(true);
        } else if (lockMode == 0) {
            this.lockingClause = ForUpdateClause.newInstance(lockMode);
        } else {
            this.lockingClause = null;
            this.setIsPrePrepared(false);
        }
        this.setIsPrepared(false);
    }

    public boolean setLockModeType(String lockModeType, AbstractSession session) {
        if (lockModeType != null) {
            OptimisticLockingPolicy lockingPolicy = session.getDescriptor(this.getReferenceClass()).getOptimisticLockingPolicy();
            if (!(lockingPolicy != null && lockingPolicy instanceof VersionLockingPolicy || lockModeType.equals(PESSIMISTIC_READ) || lockModeType.equals(PESSIMISTIC_WRITE) || lockModeType.equals(NONE))) {
                return true;
            }
            this.lockModeType = lockModeType;
            this.setIsPrePrepared(false);
            this.setIsPrepared(false);
            this.setWasDefaultLockMode(false);
        }
        return false;
    }

    protected void setNonFetchJoinAttributeExpressions(List<Expression> nonFetchJoinExpressions) {
        this.nonFetchJoinAttributeExpressions = nonFetchJoinExpressions;
    }

    public void setLockingClause(ForUpdateClause clause) {
        if (clause.isForUpdateOfClause()) {
            this.lockingClause = clause;
            this.setIsPrePrepared(false);
        } else {
            this.setLockMode(clause.getLockMode());
        }
        this.setWasDefaultLockMode(false);
    }

    public void setPartialAttributeExpressions(List<Expression> partialAttributeExpressions) {
        this.partialAttributeExpressions = partialAttributeExpressions;
    }

    @Override
    public void setEJBQLString(String ejbqlString) {
        super.setEJBQLString(ejbqlString);
        this.setIsPrePrepared(false);
    }

    public void setQueryByExamplePolicy(QueryByExamplePolicy queryByExamplePolicy) {
        if (!this.getQueryMechanism().isQueryByExampleMechanism()) {
            this.setQueryMechanism(new QueryByExampleMechanism((DatabaseQuery)this, this.getSelectionCriteria()));
            ((QueryByExampleMechanism)this.getQueryMechanism()).setQueryByExamplePolicy(queryByExamplePolicy);
            this.setIsPrepared(false);
        } else {
            ((QueryByExampleMechanism)this.getQueryMechanism()).setQueryByExamplePolicy(queryByExamplePolicy);
            if (this.isPrepared() || !this.shouldPrepare() && ((QueryByExampleMechanism)this.getQueryMechanism()).isParsed()) {
                ((QueryByExampleMechanism)this.getQueryMechanism()).setIsParsed(false);
                this.setSelectionCriteria(null);
            }
        }
        this.setIsPrePrepared(false);
    }

    @Override
    public void setReferenceClass(Class aClass) {
        if (this.referenceClass != aClass) {
            this.setIsPrepared(false);
        }
        this.referenceClass = aClass;
    }

    @Override
    public void setReferenceClassName(String aClass) {
        if (this.referenceClassName != aClass) {
            this.setIsPrepared(false);
        }
        this.referenceClassName = aClass;
    }

    @Override
    public void setSelectionCriteria(Expression expression) {
        ExpressionBuilder newBuilder;
        super.setSelectionCriteria(expression);
        if (expression != null && this.defaultBuilder != null && this.defaultBuilder.getQueryClass() == null && (newBuilder = expression.getBuilder()) != this.defaultBuilder) {
            if (this.hasAsOfClause() && this.getAsOfClause().isUniversal()) {
                newBuilder.asOf(this.defaultBuilder.getAsOfClause());
            }
            this.defaultBuilder = newBuilder;
        }
    }

    public void setShouldIncludeData(boolean shouldIncludeData) {
        this.shouldIncludeData = shouldIncludeData;
    }

    public boolean shouldCheckCacheOnly() {
        return this.cacheUsage == 4;
    }

    public boolean shouldCheckDescriptorForCacheUsage() {
        return this.cacheUsage == -1;
    }

    public boolean shouldConformResultsInUnitOfWork() {
        return this.cacheUsage == 5;
    }

    public boolean shouldDistinctBeUsed() {
        return this.getDistinctState() == 1;
    }

    public boolean shouldIncludeData() {
        return this.shouldIncludeData;
    }

    public boolean shouldOuterJoinSubclasses() {
        if (this.shouldOuterJoinSubclasses == null) {
            return false;
        }
        return this.shouldOuterJoinSubclasses;
    }

    public void setShouldOuterJoinSubclasses(boolean shouldOuterJoinSubclasses) {
        this.shouldOuterJoinSubclasses = shouldOuterJoinSubclasses;
        this.setIsPrepared(false);
    }

    @Override
    public boolean shouldReadAllMappings() {
        return !this.hasPartialAttributeExpressions() && this.getEntityFetchGroup() == null;
    }

    @Override
    public boolean shouldReadMapping(DatabaseMapping mapping) {
        String attrName = mapping.getAttributeName();
        EntityFetchGroup entityFG = this.getEntityFetchGroup();
        if (entityFG != null) {
            return entityFG.containsAttribute(mapping.getAttributeName());
        }
        return this.isPartialAttribute(attrName);
    }

    public void useDistinct() {
        this.setDistinctState((short)1);
        this.setIsPrepared(false);
    }

    @Override
    public boolean isClonePessimisticLocked(Object clone, UnitOfWorkImpl uow) {
        return this.descriptor.hasPessimisticLockingPolicy() && uow.isPessimisticLocked(clone);
    }

    protected boolean isReferenceClassLocked() {
        if (this.isReferenceClassLocked == null) {
            this.isReferenceClassLocked = this.isLockQuery() && this.lockingClause.isReferenceClassLocked();
        }
        return this.isReferenceClassLocked;
    }

    @Override
    public void recordCloneForPessimisticLocking(Object clone, UnitOfWorkImpl uow) {
        if (this.isReferenceClassLocked()) {
            uow.addPessimisticLockedClone(clone);
        }
    }

    public boolean isResultSetOptimizedQuery() {
        return this.isResultSetOptimizedQuery;
    }

    public void setIsResultSetOptimizedQuery(boolean isResultSetOptimizedQuery) {
        this.isResultSetOptimizedQuery = isResultSetOptimizedQuery;
    }

    @Override
    public boolean isDefaultLock() {
        return this.lockingClause == null || this.wasDefaultLockMode();
    }

    @Override
    public boolean isDefaultPropertiesQuery() {
        return super.isDefaultPropertiesQuery() && !this.isResultSetOptimizedQuery() && this.isDefaultLock() && !this.isDistinctComputed() && !this.hasAdditionalFields() && !this.hasPartialAttributeExpressions() && !this.hasNonFetchJoinedAttributeExpressions() && !this.hasFetchGroup() && this.getFetchGroupName() == null && this.shouldUseDefaultFetchGroup();
    }

    public boolean hasDefaultBuilder() {
        return this.defaultBuilder != null;
    }

    public boolean hasFetchGroup() {
        return this.fetchGroup != null;
    }

    public FetchGroup getFetchGroup() {
        return this.fetchGroup;
    }

    public LoadGroup getLoadGroup() {
        return this.loadGroup;
    }

    @Override
    public FetchGroup getExecutionFetchGroup() {
        if (this.fetchGroup == null && this.shouldUseDefaultFetchGroup && this.descriptor != null && this.descriptor.hasFetchGroupManager()) {
            return this.descriptor.getFetchGroupManager().getDefaultFetchGroup();
        }
        return this.fetchGroup;
    }

    @Override
    public EntityFetchGroup getEntityFetchGroup() {
        if (this.fetchGroup == null && this.shouldUseDefaultFetchGroup && this.descriptor != null && this.descriptor.hasFetchGroupManager()) {
            return this.descriptor.getFetchGroupManager().getDefaultEntityFetchGroup();
        }
        return this.entityFetchGroup;
    }

    @Override
    public boolean hasExecutionFetchGroup() {
        return this.getExecutionFetchGroup() != null;
    }

    public void setFetchGroup(FetchGroup newFetchGroup) {
        this.fetchGroup = newFetchGroup;
        this.fetchGroupName = null;
        this.entityFetchGroup = null;
        this.setIsPrePrepared(false);
    }

    public void setFetchGroupName(String groupName) {
        this.fetchGroup = null;
        this.fetchGroupName = groupName;
        this.entityFetchGroup = null;
        this.setIsPrePrepared(false);
    }

    public void setLoadGroup(LoadGroup loadGroup) {
        this.loadGroup = loadGroup;
    }

    public String getFetchGroupName() {
        return this.fetchGroupName;
    }

    public boolean shouldUseDefaultFetchGroup() {
        return this.shouldUseDefaultFetchGroup;
    }

    public void setShouldUseDefaultFetchGroup(boolean shouldUseDefaultFetchGroup) {
        this.shouldUseDefaultFetchGroup = shouldUseDefaultFetchGroup;
        if (shouldUseDefaultFetchGroup) {
            this.fetchGroup = null;
            this.fetchGroupName = null;
            this.entityFetchGroup = null;
        }
        this.setIsPrePrepared(false);
    }

    public Map<Class, DatabaseCall> getConcreteSubclassCalls() {
        if (this.concreteSubclassCalls == null) {
            this.concreteSubclassCalls = new ConcurrentHashMap<Class, DatabaseCall>(8);
        }
        return this.concreteSubclassCalls;
    }

    public boolean isPrimaryKeyQuery() {
        return false;
    }

    public void extendPessimisticLockScope() {
        if (!this.shouldExtendPessimisticLockScope || this.getDescriptor() == null) {
            return;
        }
        int size = this.getDescriptor().getMappings().size();
        boolean isExtended = false;
        boolean isFurtherExtensionRequired = false;
        for (int i = 0; i < size; ++i) {
            ForeignReferenceMapping frMapping;
            DatabaseMapping mapping = this.getDescriptor().getMappings().get(i);
            if (!mapping.isForeignReferenceMapping() || !(frMapping = (ForeignReferenceMapping)mapping).shouldExtendPessimisticLockScope()) continue;
            if (frMapping.shouldExtendPessimisticLockScopeInSourceQuery()) {
                frMapping.extendPessimisticLockScopeInSourceQuery(this);
                isExtended = true;
                continue;
            }
            isFurtherExtensionRequired = true;
        }
        if (isExtended) {
            this.useDistinct();
        }
        if (!isFurtherExtensionRequired) {
            this.shouldExtendPessimisticLockScope = false;
        }
    }

    public BatchFetchPolicy getBatchFetchPolicy() {
        if (this.batchFetchPolicy == null) {
            this.batchFetchPolicy = new BatchFetchPolicy();
        }
        return this.batchFetchPolicy;
    }

    public void setBatchFetchPolicy(BatchFetchPolicy batchFetchPolicy) {
        this.batchFetchPolicy = batchFetchPolicy;
    }

    public List<Expression> getBatchReadAttributeExpressions() {
        return this.getBatchFetchPolicy().getAttributeExpressions();
    }

    public void setBatchReadAttributeExpressions(List<Expression> attributeExpressions) {
        this.getBatchFetchPolicy().setAttributeExpressions(attributeExpressions);
    }

    public boolean hasBatchReadAttributes() {
        return this.batchFetchPolicy != null && this.batchFetchPolicy.hasAttributes();
    }

    public boolean isAttributeBatchRead(ClassDescriptor mappingDescriptor, String attributeName) {
        if (this.batchFetchPolicy == null) {
            return false;
        }
        if (mappingDescriptor.isAggregateDescriptor() && mappingDescriptor != this.descriptor) {
            return false;
        }
        return this.batchFetchPolicy.isAttributeBatchRead(mappingDescriptor, attributeName);
    }

    public void computeBatchReadMappingQueries() {
        boolean initialized = false;
        if (this.getDescriptor().getObjectBuilder().hasBatchFetchedAttributes() && this.batchFetchPolicy == null) {
            this.batchFetchPolicy = new BatchFetchPolicy();
            if (this.getDescriptor().getObjectBuilder().hasInBatchFetchedAttribute()) {
                this.batchFetchPolicy.setType(BatchFetchType.IN);
            }
            List<DatabaseMapping> batchedMappings = this.getDescriptor().getObjectBuilder().getBatchFetchedAttributes();
            this.batchFetchPolicy.setMappingQueries(new HashMap<DatabaseMapping, ReadQuery>(batchedMappings.size()));
            initialized = true;
            int size = batchedMappings.size();
            for (int index = 0; index < size; ++index) {
                DatabaseMapping mapping = batchedMappings.get(index);
                if (mapping == null || !mapping.isForeignReferenceMapping()) continue;
                ReadQuery nestedQuery = ((ForeignReferenceMapping)mapping).prepareNestedBatchQuery(this);
                this.batchFetchPolicy.getMappingQueries().put(mapping, nestedQuery);
            }
            this.batchFetchPolicy.setBatchedMappings(this.getDescriptor().getObjectBuilder().getBatchFetchedAttributes());
        }
        if (this.hasBatchReadAttributes() && !this.descriptor.hasInheritance()) {
            List<Expression> batchReadAttributeExpressions = this.getBatchReadAttributeExpressions();
            this.batchFetchPolicy.setAttributes(new ArrayList<String>(batchReadAttributeExpressions.size()));
            if (!initialized) {
                this.batchFetchPolicy.setMappingQueries(new HashMap<DatabaseMapping, ReadQuery>(batchReadAttributeExpressions.size()));
            }
            this.computeNestedQueriesForBatchReadExpressions(batchReadAttributeExpressions);
        }
    }

    protected void computeNestedQueriesForBatchReadExpressions(List<Expression> batchReadExpressions) {
        int size = batchReadExpressions.size();
        for (int index = 0; index < size; ++index) {
            DatabaseMapping mapping;
            ObjectExpression objectExpression = (ObjectExpression)batchReadExpressions.get(index);
            ExpressionBuilder builder = objectExpression.getBuilder();
            builder.setSession(this.getSession().getRootSession(null));
            builder.setQueryClass(this.getReferenceClass());
            ObjectExpression baseExpression = objectExpression;
            while (!baseExpression.getBaseExpression().isExpressionBuilder()) {
                baseExpression = (ObjectExpression)baseExpression.getBaseExpression();
            }
            this.batchFetchPolicy.getAttributes().add(baseExpression.getName());
            if (!objectExpression.getBaseExpression().isExpressionBuilder() || (mapping = objectExpression.getMapping()) == null || !mapping.isForeignReferenceMapping()) continue;
            ReadQuery nestedQuery = ((ForeignReferenceMapping)mapping).prepareNestedBatchQuery(this);
            this.batchFetchPolicy.getMappingQueries().put(mapping, nestedQuery);
        }
    }

    public void addBatchReadAttribute(String attributeName) {
        this.addBatchReadAttribute(this.getExpressionBuilder().get(attributeName));
    }

    public void addBatchReadAttribute(Expression attributeExpression) {
        if (!this.getQueryMechanism().isExpressionQueryMechanism()) {
            throw QueryException.batchReadingNotSupported(this);
        }
        this.getBatchReadAttributeExpressions().add(attributeExpression);
    }

    public void setBatchFetchType(BatchFetchType type) {
        this.getBatchFetchPolicy().setType(type);
    }

    public void setBatchFetchSize(int size) {
        this.getBatchFetchPolicy().setSize(size);
    }

    @Override
    public Map<Object, Object> getBatchObjects() {
        return this.getBatchFetchPolicy().getBatchObjects();
    }

    @Override
    public void setBatchObjects(Map<Object, Object> batchObjects) {
        this.getBatchFetchPolicy().setBatchObjects(batchObjects);
    }

    @Override
    public String toString() {
        FetchGroup defaultFetchGroup;
        String str = super.toString();
        if (this.fetchGroup != null) {
            str = str + '\n' + this.fetchGroup.toString();
        } else if (this.fetchGroupName != null) {
            str = str + "\nFetchGroup(" + this.fetchGroupName + ")";
        } else if (this.shouldUseDefaultFetchGroup && this.descriptor != null && this.descriptor.hasFetchGroupManager() && (defaultFetchGroup = this.descriptor.getFetchGroupManager().getDefaultFetchGroup()) != null) {
            str = str + "\nDefault " + defaultFetchGroup.toString();
        }
        return str;
    }
}

