/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.record;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.descriptors.DescriptorEventManager;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.identitymaps.CacheId;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.oxm.ContainerValue;
import org.eclipse.persistence.internal.oxm.MappingNodeValue;
import org.eclipse.persistence.internal.oxm.NodeValue;
import org.eclipse.persistence.internal.oxm.NullCapableValue;
import org.eclipse.persistence.internal.oxm.Reference;
import org.eclipse.persistence.internal.oxm.SAXFragmentBuilder;
import org.eclipse.persistence.internal.oxm.StrBuffer;
import org.eclipse.persistence.internal.oxm.TreeObjectBuilder;
import org.eclipse.persistence.internal.oxm.XMLChoiceCollectionMappingUnmarshalNodeValue;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.XPathNode;
import org.eclipse.persistence.internal.oxm.XPathPredicate;
import org.eclipse.persistence.internal.oxm.record.ExtendedContentHandler;
import org.eclipse.persistence.internal.oxm.record.ObjectUnmarshalContext;
import org.eclipse.persistence.internal.oxm.record.SequencedUnmarshalContext;
import org.eclipse.persistence.internal.oxm.record.UnmappedContentHandlerWrapper;
import org.eclipse.persistence.internal.oxm.record.UnmarshalContext;
import org.eclipse.persistence.internal.oxm.record.XMLReader;
import org.eclipse.persistence.internal.oxm.record.namespaces.StackUnmarshalNamespaceResolver;
import org.eclipse.persistence.internal.oxm.record.namespaces.UnmarshalNamespaceResolver;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.mappings.foundation.AbstractTransformationMapping;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLUnmarshalListener;
import org.eclipse.persistence.oxm.mappings.XMLChoiceCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.record.DOMRecord;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.oxm.unmapped.DefaultUnmappedContentHandler;
import org.eclipse.persistence.oxm.unmapped.UnmappedContentHandler;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.ext.Locator2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnmarshalRecord
extends XMLRecord
implements ExtendedContentHandler,
LexicalHandler {
    public static final UnmappedContentHandler DEFAULT_UNMAPPED_CONTENT_HANDLER = new DefaultUnmappedContentHandler();
    protected XMLReader xmlReader;
    private TreeObjectBuilder treeObjectBuilder;
    private XPathFragment xPathFragment = new XPathFragment();
    private XPathNode xPathNode;
    private int levelIndex;
    private UnmarshalRecord childRecord;
    protected UnmarshalRecord parentRecord;
    private DOMRecord transformationRecord;
    private List<UnmarshalRecord> selfRecords;
    private Map<XPathFragment, Integer> indexMap;
    private List<NullCapableValue> nullCapableValues;
    private Map<ContainerValue, Object> containersMap;
    private boolean isBufferCDATA;
    private Attributes attributes;
    private QName typeQName;
    protected String rootElementLocalName;
    protected String rootElementName;
    protected String rootElementNamespaceUri;
    private SAXFragmentBuilder fragmentBuilder;
    private Map<String, String> prefixesForFragment;
    private String encoding;
    private String version;
    private String schemaLocation;
    private String noNamespaceSchemaLocation;
    private boolean isSelfRecord;
    private UnmarshalContext unmarshalContext;
    private UnmarshalNamespaceResolver unmarshalNamespaceResolver;
    private boolean isXsiNil;
    private boolean xpathNodeIsMixedContent = false;
    private int unmappedLevel = -1;
    protected List<UnmarshalRecord> childRecordPool = new ArrayList<UnmarshalRecord>();

    public UnmarshalRecord(TreeObjectBuilder treeObjectBuilder) {
        this.prefixesForFragment = new HashMap<String, String>();
        this.initialize(treeObjectBuilder);
    }

    protected UnmarshalRecord initialize(TreeObjectBuilder treeObjectBuilder) {
        this.isBufferCDATA = false;
        this.treeObjectBuilder = treeObjectBuilder;
        if (null != treeObjectBuilder) {
            this.xPathNode = treeObjectBuilder.getRootXPathNode();
            if (null != treeObjectBuilder.getNullCapableValues()) {
                this.nullCapableValues = new ArrayList<NullCapableValue>(treeObjectBuilder.getNullCapableValues());
            }
        }
        this.isSelfRecord = false;
        return this;
    }

    private void reset() {
        this.xPathNode = null;
        this.childRecord = null;
        this.transformationRecord = null;
        if (null != this.selfRecords) {
            this.selfRecords.clear();
        }
        if (null != this.indexMap) {
            this.indexMap.clear();
        }
        this.nullCapableValues = null;
        if (null != this.containersMap) {
            this.containersMap.clear();
        }
        this.isBufferCDATA = false;
        this.attributes = null;
        this.typeQName = null;
        this.isSelfRecord = false;
        this.unmarshalContext = null;
        this.isXsiNil = false;
        this.childRecordPool.add(this);
        this.unmappedLevel = -1;
    }

    @Override
    public String getLocalName() {
        return this.rootElementLocalName;
    }

    public void setLocalName(String localName) {
        this.rootElementLocalName = localName;
    }

    @Override
    public String getNamespaceURI() {
        throw XMLMarshalException.operationNotSupported("getNamespaceURI");
    }

    @Override
    public void clear() {
        throw XMLMarshalException.operationNotSupported("clear");
    }

    @Override
    public Document getDocument() {
        throw XMLMarshalException.operationNotSupported("getDocument");
    }

    @Override
    public Element getDOM() {
        throw XMLMarshalException.operationNotSupported("getDOM");
    }

    @Override
    public String transformToXML() {
        throw XMLMarshalException.operationNotSupported("transformToXML");
    }

    public XMLReader getXMLReader() {
        return this.xmlReader;
    }

    public void setXMLReader(XMLReader xmlReader) {
        this.xmlReader = xmlReader;
    }

    public UnmarshalRecord getChildRecord() {
        return this.childRecord;
    }

    public void setChildRecord(UnmarshalRecord childRecord) {
        this.childRecord = childRecord;
        if (null != childRecord) {
            childRecord.setParentRecord(this);
        }
    }

    public UnmarshalRecord getParentRecord() {
        return this.parentRecord;
    }

    public String getRootElementName() {
        return this.rootElementName;
    }

    public void setRootElementName(String qName) {
        this.rootElementName = qName;
    }

    public String getRootElementNamespaceUri() {
        return this.rootElementNamespaceUri;
    }

    public void setRootElementNamespaceUri(String uri) {
        this.rootElementNamespaceUri = uri;
    }

    public void setParentRecord(UnmarshalRecord parentRecord) {
        this.parentRecord = parentRecord;
    }

    public DOMRecord getTransformationRecord() {
        return this.transformationRecord;
    }

    public void setTransformationRecord(DOMRecord transformationRecord) {
        this.transformationRecord = transformationRecord;
    }

    public UnmarshalNamespaceResolver getUnmarshalNamespaceResolver() {
        if (null == this.unmarshalNamespaceResolver) {
            this.unmarshalNamespaceResolver = new StackUnmarshalNamespaceResolver();
        }
        return this.unmarshalNamespaceResolver;
    }

    public void setUnmarshalNamespaceResolver(UnmarshalNamespaceResolver anUnmarshalNamespaceResolver) {
        this.unmarshalNamespaceResolver = anUnmarshalNamespaceResolver;
    }

    public List getNullCapableValues() {
        if (null == this.nullCapableValues) {
            this.nullCapableValues = new ArrayList<NullCapableValue>();
        }
        return this.nullCapableValues;
    }

    public void removeNullCapableValue(NullCapableValue nullCapableValue) {
        if (null != this.nullCapableValues) {
            this.nullCapableValues.remove(nullCapableValue);
        }
    }

    public Object getContainerInstance(ContainerValue containerValue) {
        if (null == this.containersMap) {
            return null;
        }
        return this.containersMap.get(containerValue);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String enc) {
        this.encoding = enc;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public String getNoNamespaceSchemaLocation() {
        return this.noNamespaceSchemaLocation;
    }

    public void setNoNamespaceSchemaLocation(String location) {
        this.noNamespaceSchemaLocation = location;
    }

    protected StrBuffer getStringBuffer() {
        return this.getUnmarshaller().getStringBuffer();
    }

    public CharSequence getCharacters() {
        return this.getUnmarshaller().getStringBuffer();
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Attributes attributes) {
        this.attributes = attributes;
    }

    public QName getTypeQName() {
        return this.typeQName;
    }

    public void setTypeQName(QName typeQName) {
        this.typeQName = typeQName;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        if (this.getParentRecord() == null && locator instanceof Locator2) {
            Locator2 loc = (Locator2)locator;
            this.setEncoding(loc.getEncoding());
            this.setVersion(loc.getXMLVersion());
        }
    }

    @Override
    public Object get(DatabaseField key) {
        XMLField xmlField = this.convertToXMLField(key);
        XPathFragment lastFragment = xmlField.getLastXPathFragment();
        NamespaceResolver namespaceResolver = xmlField.getNamespaceResolver();
        String namespaceURI = "";
        if (null != namespaceResolver && null == (namespaceURI = namespaceResolver.resolveNamespacePrefix(lastFragment.getPrefix()))) {
            namespaceURI = "";
        }
        return this.attributes.getValue(namespaceURI, lastFragment.getLocalName());
    }

    public XPathNode getXPathNode() {
        return this.xPathNode;
    }

    public XMLDescriptor getDescriptor() {
        return (XMLDescriptor)this.treeObjectBuilder.getDescriptor();
    }

    public UnmarshalContext getUnmarshalContext() {
        return this.unmarshalContext;
    }

    public void setUnmarshalContext(UnmarshalContext unmarshalContext) {
        this.unmarshalContext = unmarshalContext;
    }

    public boolean isNil() {
        return this.isXsiNil;
    }

    public void setNil(boolean nil) {
        this.isXsiNil = nil;
    }

    @Override
    public void startDocument() throws SAXException {
    }

    private void initializeRecord(Attributes attrs) throws SAXException {
        Object indicator;
        QName leafElementType;
        this.setAttributes(attrs);
        XMLDescriptor xmlDescriptor = (XMLDescriptor)this.treeObjectBuilder.getDescriptor();
        if (!xmlDescriptor.hasInheritance() || xmlDescriptor.getInheritancePolicy().getClassIndicatorField() == null) {
            this.initialize((TreeObjectBuilder)xmlDescriptor.getObjectBuilder());
            this.initializeRecord((XMLMapping)null);
            return;
        }
        Class classValue = xmlDescriptor.getInheritancePolicy().classFromRow(this, this.session);
        if (classValue == null && (leafElementType = xmlDescriptor.getDefaultRootElementType()) != null && (indicator = xmlDescriptor.getInheritancePolicy().getClassIndicatorMapping().get(leafElementType)) != null) {
            classValue = (Class)indicator;
        }
        if (classValue != null) {
            xmlDescriptor = (XMLDescriptor)this.session.getDescriptor(classValue);
        }
        this.initialize((TreeObjectBuilder)xmlDescriptor.getObjectBuilder());
        this.initializeRecord((XMLMapping)null);
    }

    public void initializeRecord(XMLMapping selfRecordMapping) throws SAXException {
        try {
            XMLDescriptor xmlDescriptor = (XMLDescriptor)this.treeObjectBuilder.getDescriptor();
            this.unmarshalContext = xmlDescriptor.isSequencedObject() ? new SequencedUnmarshalContext() : ObjectUnmarshalContext.getInstance();
            Object object = this.xmlReader.getCurrentObject(this.session, selfRecordMapping);
            if (object == null) {
                object = this.treeObjectBuilder.buildNewInstance();
            }
            this.setCurrentObject(object);
            XMLUnmarshalListener xmlUnmarshalListener = this.unmarshaller.getUnmarshalListener();
            if (null != xmlUnmarshalListener) {
                if (null == this.parentRecord) {
                    xmlUnmarshalListener.beforeUnmarshal(object, null);
                } else {
                    xmlUnmarshalListener.beforeUnmarshal(object, this.parentRecord.getCurrentObject());
                }
            }
            if (null == this.parentRecord) {
                this.xmlReader.newObjectEvent(object, null, selfRecordMapping);
            } else {
                this.xmlReader.newObjectEvent(object, this.parentRecord.getCurrentObject(), selfRecordMapping);
            }
            List containerValues = this.treeObjectBuilder.getContainerValues();
            if (null != containerValues) {
                this.containersMap = new HashMap<ContainerValue, Object>(containerValues.size());
                int containerValuesSize = containerValues.size();
                for (int x = 0; x < containerValuesSize; ++x) {
                    ContainerValue containerValue = (ContainerValue)containerValues.get(x);
                    Object containerInstance = null;
                    if (containerValue.getReuseContainer()) {
                        containerInstance = containerValue.getMapping().getAttributeAccessor().getAttributeValueFromObject(object);
                    }
                    if (null == containerInstance) {
                        containerInstance = containerValue.getContainerInstance();
                    }
                    this.containersMap.put(containerValue, containerInstance);
                    if (!(containerValue.getMapping() instanceof XMLChoiceCollectionMapping)) continue;
                    XMLChoiceCollectionMappingUnmarshalNodeValue nodeValue = (XMLChoiceCollectionMappingUnmarshalNodeValue)containerValue;
                    for (NodeValue next : nodeValue.getAllNodeValues()) {
                        NodeValue nestedNodeValue = ((XMLChoiceCollectionMappingUnmarshalNodeValue)next).getChoiceElementNodeValue();
                        this.containersMap.put((ContainerValue)((Object)nestedNodeValue), containerInstance);
                    }
                }
            }
            if (null != this.xPathNode.getSelfChildren()) {
                int selfChildrenSize = this.xPathNode.getSelfChildren().size();
                this.selfRecords = new ArrayList<UnmarshalRecord>(selfChildrenSize);
                for (int x = 0; x < selfChildrenSize; ++x) {
                    XPathNode selfNode = this.xPathNode.getSelfChildren().get(x);
                    if (null == selfNode.getNodeValue()) continue;
                    this.selfRecords.add(selfNode.getNodeValue().buildSelfRecord(this, this.attributes));
                }
            }
        }
        catch (EclipseLinkException e) {
            if (null == this.xmlReader.getErrorHandler()) {
                throw e;
            }
            SAXParseException saxParseException = new SAXParseException(null, null, null, 0, 0, e);
            this.xmlReader.getErrorHandler().error(saxParseException);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        int primaryKeyFieldsSize;
        List<DatabaseField> primaryKeyFields;
        ClassDescriptor xmlDescriptor;
        if (null != this.selfRecords) {
            int selfRecordsSize = this.selfRecords.size();
            for (int x = 0; x < selfRecordsSize; ++x) {
                UnmarshalRecord selfRecord = this.selfRecords.get(x);
                if (selfRecord == null) continue;
                selfRecord.endDocument();
            }
        }
        if (null != this.xPathNode.getSelfChildren()) {
            int selfChildrenSize = this.xPathNode.getSelfChildren().size();
            for (int x = 0; x < selfChildrenSize; ++x) {
                XPathNode selfNode = this.xPathNode.getSelfChildren().get(x);
                if (null == selfNode.getNodeValue()) continue;
                selfNode.getNodeValue().endSelfNodeValue(this, this.selfRecords.get(x), this.attributes);
            }
        }
        try {
            DescriptorEventManager eventManager;
            ClassDescriptor xmlDescriptor2;
            List transformationMappings;
            if (null != this.containersMap) {
                for (Map.Entry<ContainerValue, Object> entry : this.containersMap.entrySet()) {
                    entry.getKey().setContainerInstance(this.currentObject, entry.getValue());
                }
            }
            if (null != this.nullCapableValues) {
                int nullValuesSize = this.nullCapableValues.size();
                for (int x = 0; x < nullValuesSize; ++x) {
                    this.nullCapableValues.get(x).setNullValue(this.currentObject, this.session);
                }
            }
            if (null != (transformationMappings = this.treeObjectBuilder.getTransformationMappings())) {
                ReadObjectQuery query = new ReadObjectQuery();
                query.setSession(this.session);
                int transformationMappingsSize = transformationMappings.size();
                for (int x = 0; x < transformationMappingsSize; ++x) {
                    AbstractTransformationMapping transformationMapping = (AbstractTransformationMapping)transformationMappings.get(x);
                    transformationMapping.readFromRowIntoObject(this.transformationRecord, null, this.currentObject, null, query, this.session, true);
                }
            }
            if (this.getUnmarshaller().getUnmarshalListener() != null) {
                if (this.parentRecord != null) {
                    this.getUnmarshaller().getUnmarshalListener().afterUnmarshal(this.currentObject, this.parentRecord.getCurrentObject());
                } else {
                    this.getUnmarshaller().getUnmarshalListener().afterUnmarshal(this.currentObject, null);
                }
            }
            if ((xmlDescriptor2 = this.treeObjectBuilder.getDescriptor()).hasEventManager() && null != (eventManager = xmlDescriptor2.getEventManager()) && eventManager.hasAnyEventListeners()) {
                DescriptorEvent event = new DescriptorEvent(this.currentObject);
                event.setSession(this.session);
                event.setRecord(this);
                event.setEventCode(8);
                eventManager.executeEvent(event);
            }
        }
        catch (EclipseLinkException e) {
            if (null == this.xmlReader.getErrorHandler()) {
                throw e;
            }
            SAXParseException saxParseException = new SAXParseException(null, null, null, 0, 0, e);
            this.xmlReader.getErrorHandler().error(saxParseException);
        }
        if (this.session.isUnitOfWork() && null != (xmlDescriptor = this.treeObjectBuilder.getDescriptor()) && null != (primaryKeyFields = xmlDescriptor.getPrimaryKeyFields()) && (primaryKeyFieldsSize = primaryKeyFields.size()) > 0) {
            Object pk = this.treeObjectBuilder.extractPrimaryKeyFromObject(this.currentObject, this.session);
            for (int x = 0; x < primaryKeyFieldsSize; ++x) {
                Object value = ((CacheId)pk).getPrimaryKey()[x];
                if (null != value) continue;
                XMLField pkField = (XMLField)xmlDescriptor.getPrimaryKeyFields().get(x);
                ((CacheId)pk).set(x, this.getUnmarshaller().getXMLContext().getValueByXPath(this.currentObject, pkField.getXPath(), pkField.getNamespaceResolver(), Object.class));
            }
            CacheKey key = this.session.getIdentityMapAccessorInstance().acquireDeferredLock(pk, xmlDescriptor.getJavaClass(), xmlDescriptor);
            key.setRecord(this);
            key.setObject(this.currentObject);
            key.releaseDeferredLock();
        }
        if (null != this.parentRecord) {
            this.reset();
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.getUnmarshalNamespaceResolver().push(prefix, uri);
        this.prefixesForFragment.put(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.getUnmarshalNamespaceResolver().pop(prefix);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (this.getCurrentObject() == null) {
            this.initializeRecord(atts);
        }
        if (null != this.xPathNode.getXPathFragment() && this.xPathNode.getXPathFragment().nameIsText() || this.xpathNodeIsMixedContent) {
            this.xpathNodeIsMixedContent = false;
            NodeValue xPathNodeUnmarshalNodeValue = this.xPathNode.getUnmarshalNodeValue();
            if (null != xPathNodeUnmarshalNodeValue) {
                xPathNodeUnmarshalNodeValue.endElement(this.xPathFragment, this);
                if (this.xPathNode.getParent() != null) {
                    this.xPathNode = this.xPathNode.getParent();
                }
            }
        }
        if (null == this.rootElementName && null == this.rootElementLocalName) {
            this.rootElementLocalName = localName;
            this.rootElementName = qName;
            this.rootElementNamespaceUri = namespaceURI;
            this.schemaLocation = atts.getValue("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation");
            this.noNamespaceSchemaLocation = atts.getValue("http://www.w3.org/2001/XMLSchema-instance", "noNamespaceSchemaLocation");
        }
        try {
            block28: {
                if (null != this.selfRecords) {
                    int selfRecordsSize = this.selfRecords.size();
                    for (int x = 0; x < selfRecordsSize; ++x) {
                        UnmarshalRecord selfRecord = this.selfRecords.get(x);
                        if (selfRecord == null) {
                            this.getFragmentBuilder().startElement(namespaceURI, localName, qName, atts);
                            continue;
                        }
                        selfRecord.startElement(namespaceURI, localName, qName, atts);
                    }
                }
                if (this.unmappedLevel != -1 && this.unmappedLevel <= this.levelIndex) {
                    ++this.levelIndex;
                    return;
                }
                XPathNode node = this.getNonAttributeXPathNode(namespaceURI, localName, qName, atts);
                if (null == node) {
                    NodeValue parentNodeValue = this.xPathNode.getUnmarshalNodeValue();
                    if (null == this.xPathNode.getXPathFragment() && parentNodeValue != null) {
                        XPathFragment parentFragment = new XPathFragment();
                        if (namespaceURI != null && namespaceURI.length() == 0) {
                            parentFragment.setLocalName(qName);
                            parentFragment.setNamespaceURI(null);
                        } else {
                            parentFragment.setLocalName(localName);
                            parentFragment.setNamespaceURI(namespaceURI);
                        }
                        if (!parentNodeValue.startElement(parentFragment, this, atts)) {
                            this.startUnmappedElement(namespaceURI, localName, qName, atts);
                            return;
                        }
                        ++this.levelIndex;
                        break block28;
                    } else {
                        ++this.levelIndex;
                        this.startUnmappedElement(namespaceURI, localName, qName, atts);
                        return;
                    }
                }
                this.xPathNode = node;
                this.unmarshalContext.startElement(this);
                ++this.levelIndex;
                this.isXsiNil = atts.getIndex("http://www.w3.org/2001/XMLSchema-instance", "nil") >= 0;
                NodeValue nodeValue = node.getUnmarshalNodeValue();
                if (null != nodeValue && !nodeValue.startElement(this.xPathFragment, this, atts)) {
                    this.startUnmappedElement(namespaceURI, localName, qName, atts);
                    return;
                }
                int size = atts.getLength();
                for (int i = 0; i < size; ++i) {
                    String qname;
                    String attNamespace = atts.getURI(i);
                    String attLocalName = atts.getLocalName(i);
                    String value = atts.getValue(i);
                    NodeValue attributeNodeValue = null;
                    if ((attLocalName == null || attLocalName.length() == 0) && (qname = atts.getQName(i)) != null && qname.length() > 0) {
                        int idx = qname.indexOf(58);
                        if (idx > 0) {
                            attLocalName = qname.substring(idx + 1, qname.length());
                            String attPrefix = qname.substring(0, idx);
                            if (attPrefix.equals("xmlns")) {
                                attNamespace = "http://www.w3.org/2000/xmlns/";
                            }
                        } else {
                            attLocalName = qname;
                            if (attLocalName.equals("xmlns")) {
                                attNamespace = "http://www.w3.org/2000/xmlns/";
                            }
                        }
                    }
                    if (this.selfRecords != null) {
                        for (int j = 0; j < this.selfRecords.size(); ++j) {
                            UnmarshalRecord nestedRecord = this.selfRecords.get(j);
                            if (nestedRecord == null || (attributeNodeValue = nestedRecord.getAttributeChildNodeValue(attNamespace, attLocalName)) == null) continue;
                            attributeNodeValue.attribute(nestedRecord, attNamespace, attLocalName, value);
                        }
                    }
                    if (attributeNodeValue != null) continue;
                    attributeNodeValue = this.getAttributeChildNodeValue(attNamespace, attLocalName);
                    if (attributeNodeValue != null) {
                        attributeNodeValue.attribute(this, attNamespace, attLocalName, value);
                        continue;
                    }
                    if (this.xPathNode.getAnyAttributeNodeValue() == null) continue;
                    this.xPathNode.getAnyAttributeNodeValue().attribute(this, attNamespace, attLocalName, value);
                }
            }
            this.prefixesForFragment.clear();
            return;
        }
        catch (EclipseLinkException e) {
            if (null == this.xmlReader) throw e;
            if (null == this.xmlReader.getErrorHandler()) {
                throw e;
            }
            SAXParseException saxParseException = new SAXParseException(null, null, null, 0, 0, e);
            this.xmlReader.getErrorHandler().error(saxParseException);
        }
    }

    public void startUnmappedElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        UnmappedContentHandler unmappedContentHandler;
        if (null != this.selfRecords || null == this.xmlReader || this.isSelfRecord()) {
            if (-1 == this.unmappedLevel) {
                this.unmappedLevel = this.levelIndex;
            }
            return;
        }
        Class unmappedContentHandlerClass = this.getUnmarshaller().getUnmappedContentHandlerClass();
        if (null == unmappedContentHandlerClass) {
            unmappedContentHandler = DEFAULT_UNMAPPED_CONTENT_HANDLER;
        } else {
            try {
                PrivilegedNewInstanceFromClass privilegedNewInstanceFromClass = new PrivilegedNewInstanceFromClass(unmappedContentHandlerClass);
                unmappedContentHandler = (UnmappedContentHandler)privilegedNewInstanceFromClass.run();
            }
            catch (ClassCastException e) {
                throw XMLMarshalException.unmappedContentHandlerDoesntImplement(e, unmappedContentHandlerClass.getName());
            }
            catch (IllegalAccessException e) {
                throw XMLMarshalException.errorInstantiatingUnmappedContentHandler(e, unmappedContentHandlerClass.getName());
            }
            catch (InstantiationException e) {
                throw XMLMarshalException.errorInstantiatingUnmappedContentHandler(e, unmappedContentHandlerClass.getName());
            }
        }
        UnmappedContentHandlerWrapper unmappedContentHandlerWrapper = new UnmappedContentHandlerWrapper(this, unmappedContentHandler);
        unmappedContentHandlerWrapper.startElement(namespaceURI, localName, qName, atts);
        this.xmlReader.setContentHandler(unmappedContentHandlerWrapper);
        this.xmlReader.setLexicalHandler(unmappedContentHandlerWrapper);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        try {
            if (null != this.selfRecords) {
                int selfRecordsSize = this.selfRecords.size();
                for (int x = 0; x < selfRecordsSize; ++x) {
                    UnmarshalRecord selfRecord = this.selfRecords.get(x);
                    if (selfRecord != null) {
                        selfRecord.endElement(namespaceURI, localName, qName);
                        continue;
                    }
                    this.getFragmentBuilder().endSelfElement(namespaceURI, localName, qName);
                }
            }
            if (-1 != this.unmappedLevel && this.unmappedLevel <= this.levelIndex) {
                if (this.levelIndex == this.unmappedLevel) {
                    this.unmappedLevel = -1;
                }
                --this.levelIndex;
                return;
            }
            if (null != this.xPathNode.getUnmarshalNodeValue()) {
                this.xPathNode.getUnmarshalNodeValue().endElement(this.xPathFragment, this);
            } else {
                XPathNode textNode = this.xPathNode.getTextNode();
                if (null != textNode && textNode.isWhitespaceAware() && this.getStringBuffer().length() == 0) {
                    NodeValue textNodeUnmarshalNodeValue = textNode.getUnmarshalNodeValue();
                    if (!this.isXsiNil) {
                        if (textNodeUnmarshalNodeValue.isMappingNodeValue()) {
                            textNodeUnmarshalNodeValue.endElement(this.xPathFragment, this);
                        }
                    } else if (textNodeUnmarshalNodeValue.isMappingNodeValue()) {
                        Object nullValue;
                        DatabaseMapping mapping = ((MappingNodeValue)textNodeUnmarshalNodeValue).getMapping();
                        if (mapping.isAbstractDirectMapping() && !"".equals(nullValue = ((AbstractDirectMapping)mapping).getNullValue())) {
                            this.setAttributeValue(null, mapping);
                            this.removeNullCapableValue((NullCapableValue)((Object)textNodeUnmarshalNodeValue));
                        }
                        this.isXsiNil = false;
                    }
                }
            }
            XPathFragment xPathFragment = this.xPathNode.getXPathFragment();
            if (null != xPathFragment && xPathFragment.nameIsText()) {
                this.xPathNode = this.xPathNode.getParent();
            }
            if (null != this.xPathNode.getParent()) {
                this.xPathNode = this.xPathNode.getParent();
            }
            this.xpathNodeIsMixedContent = false;
            this.unmarshalContext.endElement(this);
            this.typeQName = null;
            --this.levelIndex;
            if (this.isNil() && this.levelIndex > 0) {
                this.setNil(false);
            }
            if (0 == this.levelIndex && null != this.getParentRecord() && !this.isSelfRecord()) {
                this.endDocument();
                UnmarshalRecord pRec = this.getParentRecord();
                while (pRec.isSelfRecord()) {
                    pRec = pRec.getParentRecord();
                }
                pRec.endElement(namespaceURI, localName, qName);
                this.xmlReader.setContentHandler(pRec);
                this.xmlReader.setLexicalHandler(pRec);
            }
        }
        catch (EclipseLinkException e) {
            if (null == this.xmlReader || null == this.xmlReader.getErrorHandler()) {
                throw e;
            }
            SAXParseException saxParseException = new SAXParseException(null, null, null, 0, 0, e);
            this.xmlReader.getErrorHandler().error(saxParseException);
        }
    }

    public void endUnmappedElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.typeQName = null;
        --this.levelIndex;
        if (0 == this.levelIndex && null != this.parentRecord && !this.isSelfRecord()) {
            this.endDocument();
            UnmarshalRecord pRec = this.parentRecord;
            while (pRec.isSelfRecord()) {
                pRec = pRec.parentRecord;
            }
            pRec.endElement(namespaceURI, localName, qName);
            this.xmlReader.setContentHandler(pRec);
            this.xmlReader.setLexicalHandler(pRec);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            if (null != this.selfRecords) {
                int selfRecordsSize = this.selfRecords.size();
                for (int x = 0; x < selfRecordsSize; ++x) {
                    UnmarshalRecord selfRecord = this.selfRecords.get(x);
                    if (selfRecord != null) {
                        selfRecord.characters(ch, start, length);
                        continue;
                    }
                    this.getFragmentBuilder().characters(ch, start, length);
                }
            }
            if (-1 != this.unmappedLevel && this.unmappedLevel <= this.levelIndex) {
                return;
            }
            XPathNode textNode = this.xPathNode.getTextNode();
            if (null == textNode && (textNode = this.xPathNode.getAnyNode()) != null) {
                this.xpathNodeIsMixedContent = true;
                this.xPathFragment.setLocalName(null);
                this.xPathFragment.setNamespaceURI(null);
                if (0 == length) {
                    return;
                }
            }
            if (null != textNode) {
                if (textNode.getUnmarshalNodeValue().isMixedContentNodeValue()) {
                    String tmpString = new String(ch, start, length);
                    if (!textNode.isWhitespaceAware() && tmpString.trim().length() == 0) {
                        return;
                    }
                }
                this.xPathNode = textNode;
                this.unmarshalContext.characters(this);
            }
            if (null != this.xPathNode.getUnmarshalNodeValue()) {
                this.getStringBuffer().append(ch, start, length);
            }
        }
        catch (EclipseLinkException e) {
            if (null == this.xmlReader.getErrorHandler()) {
                throw e;
            }
            SAXParseException saxParseException = new SAXParseException(null, null, null, 0, 0, e);
            this.xmlReader.getErrorHandler().error(saxParseException);
        }
    }

    @Override
    public void characters(CharSequence characters) throws SAXException {
        if (null != characters) {
            String string = ((Object)characters).toString();
            this.characters(string.toCharArray(), 0, string.length());
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    protected XPathNode getNonAttributeXPathNode(String namespaceURI, String localName, String qName, Attributes attributes) {
        if (0 == this.levelIndex) {
            return this.xPathNode;
        }
        if (namespaceURI != null && namespaceURI.length() == 0) {
            this.xPathFragment.setLocalName(qName);
            this.xPathFragment.setNamespaceURI(null);
        } else {
            this.xPathFragment.setLocalName(localName);
            this.xPathFragment.setNamespaceURI(namespaceURI);
        }
        XPathNode resultNode = null;
        Map<XPathFragment, XPathNode> nonAttributeChildrenMap = this.xPathNode.getNonAttributeChildrenMap();
        if (null != nonAttributeChildrenMap) {
            resultNode = nonAttributeChildrenMap.get(this.xPathFragment);
            if (null == resultNode) {
                int newIndex;
                if (null == this.indexMap) {
                    this.indexMap = new HashMap<XPathFragment, Integer>();
                    newIndex = 1;
                } else {
                    Integer oldIndex = this.indexMap.get(this.xPathFragment);
                    newIndex = null == oldIndex ? 1 : oldIndex + 1;
                }
                this.indexMap.put(this.xPathFragment, newIndex);
                XPathFragment predicateFragment = new XPathFragment();
                predicateFragment.setNamespaceURI(this.xPathFragment.getNamespaceURI());
                predicateFragment.setLocalName(this.xPathFragment.getLocalName());
                predicateFragment.setIndexValue(newIndex);
                resultNode = nonAttributeChildrenMap.get(predicateFragment);
                if (null == resultNode) {
                    predicateFragment.setIndexValue(-1);
                    int length = attributes.getLength();
                    for (int x = 0; x < length; ++x) {
                        XPathFragment conditionFragment = new XPathFragment();
                        conditionFragment.setLocalName(attributes.getLocalName(x));
                        conditionFragment.setNamespaceURI(attributes.getURI(x));
                        conditionFragment.setAttribute(true);
                        XPathPredicate condition = new XPathPredicate(conditionFragment, attributes.getValue(x));
                        predicateFragment.setPredicate(condition);
                        resultNode = nonAttributeChildrenMap.get(predicateFragment);
                        if (null != resultNode) break;
                    }
                    if (null == resultNode) {
                        resultNode = this.xPathNode.getAnyNode();
                    }
                }
            }
            return resultNode;
        }
        return null;
    }

    @Override
    public String resolveNamespacePrefix(String prefix) {
        String namespaceURI = this.getUnmarshalNamespaceResolver().getNamespaceURI(prefix);
        if (null == namespaceURI && null != this.getParentRecord()) {
            namespaceURI = this.getParentRecord().resolveNamespacePrefix(prefix);
        }
        return namespaceURI;
    }

    public String resolveNamespaceUri(String uri) {
        String prefix = this.getUnmarshalNamespaceResolver().getPrefix(uri);
        if (null == prefix && null != this.getParentRecord()) {
            prefix = this.getParentRecord().resolveNamespaceUri(uri);
        }
        return prefix;
    }

    @Override
    public String toString() {
        StringWriter writer = new StringWriter();
        writer.write(Helper.getShortClassName(this.getClass()));
        writer.write("()");
        return writer.toString();
    }

    public NodeValue getSelfNodeValueForAttribute(String namespace, String localName) {
        if (this.selfRecords != null) {
            int selfRecordsSize = this.selfRecords.size();
            for (int i = 0; i < selfRecordsSize; ++i) {
                NodeValue node;
                UnmarshalRecord nestedRecord = this.selfRecords.get(i);
                if (nestedRecord == null || (node = nestedRecord.getAttributeChildNodeValue(namespace, localName)) == null) continue;
                return node;
            }
        }
        return null;
    }

    public NodeValue getAttributeChildNodeValue(String namespace, String localName) {
        Map<XPathFragment, XPathNode> attributeChildrenMap = this.xPathNode.getAttributeChildrenMap();
        if (attributeChildrenMap != null) {
            this.xPathFragment.setLocalName(localName);
            if (namespace != null && namespace.length() == 0) {
                this.xPathFragment.setNamespaceURI(null);
            } else {
                this.xPathFragment.setNamespaceURI(namespace);
            }
            XPathNode node = attributeChildrenMap.get(this.xPathFragment);
            if (node != null) {
                return node.getUnmarshalNodeValue();
            }
        }
        return null;
    }

    public SAXFragmentBuilder getFragmentBuilder() {
        if (this.fragmentBuilder == null) {
            this.fragmentBuilder = new SAXFragmentBuilder(this);
        }
        return this.fragmentBuilder;
    }

    public void setFragmentBuilder(SAXFragmentBuilder builder) {
        this.fragmentBuilder = builder;
    }

    public void resetStringBuffer() {
        this.getStringBuffer().reset();
        this.isBufferCDATA = false;
    }

    public boolean isBufferCDATA() {
        return this.isBufferCDATA;
    }

    @Override
    public void comment(char[] data, int start, int length) {
    }

    @Override
    public void startCDATA() {
        if (null != this.xPathNode && this.xPathNode.getUnmarshalNodeValue() != null) {
            this.isBufferCDATA = true;
        }
    }

    @Override
    public void endCDATA() {
    }

    @Override
    public void startEntity(String entity) {
    }

    @Override
    public void endEntity(String entity) {
    }

    @Override
    public void startDTD(String a, String b, String c) {
    }

    @Override
    public void endDTD() {
    }

    public void setSelfRecord(boolean isSelfRecord) {
        this.isSelfRecord = isSelfRecord;
    }

    public boolean isSelfRecord() {
        return this.isSelfRecord;
    }

    public int getLevelIndex() {
        return this.levelIndex;
    }

    public void setAttributeValue(Object value, DatabaseMapping mapping) {
        this.unmarshalContext.setAttributeValue(this, value, mapping);
    }

    public void addAttributeValue(ContainerValue containerValue, Object value) {
        this.unmarshalContext.addAttributeValue(this, containerValue, value);
    }

    public void addAttributeValue(ContainerValue containerValue, Object value, Object collection) {
        this.unmarshalContext.addAttributeValue(this, containerValue, value, collection);
    }

    public void reference(Reference reference) {
        this.unmarshalContext.reference(reference);
    }

    public void unmappedContent() {
        if (this.xPathNode.getParent() != null) {
            this.xPathNode = this.xPathNode.getParent();
        }
        this.unmarshalContext.unmappedContent(this);
    }

    public UnmarshalRecord getChildUnmarshalRecord(TreeObjectBuilder treeObjectBuilder) {
        if (this.childRecordPool.isEmpty()) {
            UnmarshalRecord childRecord = (UnmarshalRecord)treeObjectBuilder.createRecord(this.session);
            childRecord.setUnmarshaller(this.unmarshaller);
            childRecord.session = this.session;
            childRecord.xmlReader = this.xmlReader;
            childRecord.setFragmentBuilder(this.fragmentBuilder);
            childRecord.setUnmarshalNamespaceResolver(this.getUnmarshalNamespaceResolver());
            childRecord.childRecordPool = this.childRecordPool;
            return childRecord;
        }
        return this.childRecordPool.remove(this.childRecordPool.size() - 1).initialize(treeObjectBuilder);
    }

    public Map<String, String> getPrefixesForFragment() {
        return this.prefixesForFragment;
    }
}

