/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle.publisher.viewcache;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.SequencedInfo;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.UserArguments;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.ViewRow;

public class RowtypeInfo
extends SequencedInfo {
    public String argument_name;
    public String type_owner;
    public String type_name;
    public String type_subname;
    public String modifier;
    public String data_type;
    public int data_level;
    public int data_length;
    public int data_precision;
    public int data_scale;

    public RowtypeInfo(UserArguments item) {
        this.argument_name = item.ARGUMENT_NAME;
        this.type_owner = item.TYPE_OWNER;
        this.type_name = item.TYPE_NAME == null && item.TYPE_SUBNAME == null ? item.DATA_TYPE : item.TYPE_NAME;
        if (this.type_name != null && this.type_name.equals("PL/SQL BOOLEAN")) {
            this.type_name = "BOOLEAN";
        }
        this.type_subname = item.TYPE_SUBNAME;
        this.sequence = item.sequence;
        this.data_type = item.DATA_TYPE;
        this.data_level = item.DATA_LEVEL;
        this.data_length = item.DATA_LENGTH;
        this.data_precision = item.DATA_PRECISION;
        this.data_scale = item.DATA_SCALE;
        this.modifier = "";
        if ("REF".equals(item.DATA_TYPE) || "PL/SQL RECORD".equals(item.DATA_TYPE) || "PL/SQL TABLE".equals(item.DATA_TYPE) || "TABLE".equals(item.DATA_TYPE) || "VARRAY".equals(item.DATA_TYPE)) {
            this.modifier = item.DATA_TYPE;
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof RowtypeInfo)) {
            return false;
        }
        RowtypeInfo p = (RowtypeInfo)o;
        if (this.argument_name == null && p.argument_name != null) {
            return false;
        }
        if (this.type_owner == null && p.type_owner != null) {
            return false;
        }
        if (this.type_subname == null && p.type_subname != null) {
            return false;
        }
        if (this.type_subname != null && p.type_subname == null) {
            return false;
        }
        if (this.type_subname != null && p.type_subname != null && !this.type_subname.equals(p.type_subname)) {
            return false;
        }
        if (this.data_type == null && p.data_type != null) {
            return false;
        }
        if (this.data_type != null && p.data_type == null) {
            return false;
        }
        if (this.data_type != null && p.data_type != null && !this.data_type.equals(p.data_type)) {
            return false;
        }
        if (this.data_level != p.data_level) {
            return false;
        }
        if (this.data_length != p.data_length) {
            return false;
        }
        if (this.data_precision != p.data_precision) {
            return false;
        }
        return this.data_scale == p.data_scale;
    }

    public String toString() {
        return "RowtypeInfo(" + this.argument_name + "," + this.type_owner + "," + this.type_name + "," + this.type_subname + "," + this.modifier + "," + this.data_type + "," + this.data_level + "," + this.data_length + "," + this.data_precision + "," + this.data_scale + "," + this.sequence() + ")";
    }

    public int data_level() {
        return this.data_level;
    }

    public void data_level(int dl) {
        this.data_level = dl;
    }

    public static List<RowtypeInfo> getRowtypeInfo(ArrayList<ViewRow> viewRows) throws SQLException {
        ArrayList<RowtypeInfo> a = new ArrayList<RowtypeInfo>();
        for (int i = 0; i < viewRows.size(); ++i) {
            RowtypeInfo rif = new RowtypeInfo((UserArguments)viewRows.get(i));
            a.add(rif);
        }
        if (a.size() == 0) {
            return null;
        }
        SequencedInfo[] r = a.toArray(new RowtypeInfo[a.size()]);
        RowtypeInfo[] rr = (RowtypeInfo[])RowtypeInfo.reorder(r);
        ArrayList<RowtypeInfo> aa = new ArrayList<RowtypeInfo>();
        for (RowtypeInfo rti : rr) {
            aa.add(rti);
        }
        return aa;
    }
}

