/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.compiler;

import java.awt.Image;
import java.beans.Introspector;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.bind.annotation.XmlElementDecl;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.eclipse.persistence.exceptions.JAXBException;
import org.eclipse.persistence.internal.descriptors.Namespace;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.jaxb.many.MapValue;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.schema.model.All;
import org.eclipse.persistence.internal.oxm.schema.model.Any;
import org.eclipse.persistence.internal.oxm.schema.model.AnyAttribute;
import org.eclipse.persistence.internal.oxm.schema.model.Attribute;
import org.eclipse.persistence.internal.oxm.schema.model.Choice;
import org.eclipse.persistence.internal.oxm.schema.model.ComplexContent;
import org.eclipse.persistence.internal.oxm.schema.model.ComplexType;
import org.eclipse.persistence.internal.oxm.schema.model.Element;
import org.eclipse.persistence.internal.oxm.schema.model.Extension;
import org.eclipse.persistence.internal.oxm.schema.model.Import;
import org.eclipse.persistence.internal.oxm.schema.model.List;
import org.eclipse.persistence.internal.oxm.schema.model.Restriction;
import org.eclipse.persistence.internal.oxm.schema.model.Schema;
import org.eclipse.persistence.internal.oxm.schema.model.Sequence;
import org.eclipse.persistence.internal.oxm.schema.model.SimpleComponent;
import org.eclipse.persistence.internal.oxm.schema.model.SimpleContent;
import org.eclipse.persistence.internal.oxm.schema.model.SimpleType;
import org.eclipse.persistence.internal.oxm.schema.model.TypeDefParticle;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jaxb.compiler.CompilerHelper;
import org.eclipse.persistence.jaxb.compiler.ElementDeclaration;
import org.eclipse.persistence.jaxb.compiler.EnumTypeInfo;
import org.eclipse.persistence.jaxb.compiler.NamespaceInfo;
import org.eclipse.persistence.jaxb.compiler.PackageInfo;
import org.eclipse.persistence.jaxb.compiler.Property;
import org.eclipse.persistence.jaxb.compiler.SchemaTypeInfo;
import org.eclipse.persistence.jaxb.compiler.TypeInfo;
import org.eclipse.persistence.jaxb.compiler.XMLProcessor;
import org.eclipse.persistence.jaxb.javamodel.Helper;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaMethod;
import org.eclipse.persistence.jaxb.xmlmodel.XmlElementWrapper;
import org.eclipse.persistence.jaxb.xmlmodel.XmlJoinNodes;
import org.eclipse.persistence.jaxb.xmlmodel.XmlRootElement;
import org.eclipse.persistence.jaxb.xmlmodel.XmlTransformation;
import org.eclipse.persistence.jaxb.xmlmodel.XmlVirtualAccessMethodsSchema;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.sessions.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaGenerator {
    private HashMap<String, Schema> schemaForNamespace;
    private java.util.List<Schema> allSchemas;
    private Schema schema;
    private int schemaCount;
    private Helper helper;
    private HashMap<String, TypeInfo> typeInfo;
    private HashMap<String, PackageInfo> packageToPackageInfoMappings;
    private HashMap<String, SchemaTypeInfo> schemaTypeInfo;
    private HashMap<String, QName> userDefinedSchemaTypes;
    private Map<String, Class> arrayClassesToGeneratedClasses;
    private static final String JAVAX_ACTIVATION_DATAHANDLER = "javax.activation.DataHandler";
    private static final String JAVAX_MAIL_INTERNET_MIMEMULTIPART = "javax.mail.internet.MimeMultipart";
    private static final String SWA_REF_IMPORT = "http://ws-i.org/profiles/basic/1.1/swaref.xsd";
    private static final String BUILD_FIELD_VALUE_METHOD = "buildFieldValue";
    private static final String COLON = ":";
    private static final String ATT = "@";
    private static final String EMPTY_STRING = "";
    private static final String DOT = ".";
    private static final String SKIP = "skip";
    private static final String ENTRY = "entry";
    private static final String DEFAULT = "##default";
    private static final String GENERATE = "##generate";
    private static final String SCHEMA = "schema";
    private static final String SCHEMA_EXT = ".xsd";
    private static final String OBJECT_CLASSNAME = "java.lang.Object";
    private static final String ID = "ID";
    private static final String IDREF = "IDREF";
    private static final Character DOT_CHAR = Character.valueOf('.');
    private static final Character SLASH = Character.valueOf('/');
    private static final Character SLASHES = Character.valueOf('\\');
    private SchemaOutputResolver outputResolver;

    public SchemaGenerator(Helper helper) {
        this.helper = helper;
    }

    public Schema generateSchema(ArrayList<JavaClass> typeInfoClasses, HashMap<String, TypeInfo> typeInfo, HashMap<String, QName> userDefinedSchemaTypes, HashMap<String, PackageInfo> packageToPackageInfoMappings, HashMap<QName, ElementDeclaration> additionalGlobalElements, Map<String, Class> arrayClassesToGeneratedClasses, SchemaOutputResolver outputResolver) {
        this.outputResolver = outputResolver;
        return this.generateSchema(typeInfoClasses, typeInfo, userDefinedSchemaTypes, packageToPackageInfoMappings, additionalGlobalElements, arrayClassesToGeneratedClasses);
    }

    public Schema generateSchema(ArrayList<JavaClass> typeInfoClasses, HashMap<String, TypeInfo> typeInfo, HashMap<String, QName> userDefinedSchemaTypes, HashMap<String, PackageInfo> packageToPackageInfoMappings, HashMap<QName, ElementDeclaration> additionalGlobalElements, Map<String, Class> arrayClassesToGeneratedClasses) {
        this.typeInfo = typeInfo;
        this.userDefinedSchemaTypes = userDefinedSchemaTypes;
        this.packageToPackageInfoMappings = packageToPackageInfoMappings;
        this.schemaCount = 1;
        this.schemaTypeInfo = new HashMap(typeInfo.size());
        this.arrayClassesToGeneratedClasses = arrayClassesToGeneratedClasses;
        for (JavaClass javaClass : typeInfoClasses) {
            this.addSchemaComponents(javaClass);
        }
        this.populateSchemaTypes();
        if (additionalGlobalElements != null) {
            this.addGlobalElements(additionalGlobalElements);
        }
        return this.schema;
    }

    public void addSchemaComponents(JavaClass myClass) {
        SimpleType type;
        String myClassName = myClass.getQualifiedName();
        Element rootElement = null;
        TypeInfo info = this.typeInfo.get(myClassName);
        if (info.isTransient() || info.getClassNamespace().equals("http://www.w3.org/2001/XMLSchema")) {
            return;
        }
        SchemaTypeInfo schemaTypeInfo = new SchemaTypeInfo();
        schemaTypeInfo.setSchemaTypeName(new QName(info.getClassNamespace(), info.getSchemaTypeName()));
        this.schemaTypeInfo.put(myClass.getQualifiedName(), schemaTypeInfo);
        NamespaceInfo namespaceInfo = this.packageToPackageInfoMappings.get(myClass.getPackageName()).getNamespaceInfo();
        if (namespaceInfo.getLocation() != null && !namespaceInfo.getLocation().equals(GENERATE)) {
            return;
        }
        Schema schema = this.getSchemaForNamespace(info.getClassNamespace());
        info.setSchema(schema);
        String typeName = info.getSchemaTypeName();
        String pfx = EMPTY_STRING;
        Property valueField = null;
        if (info.isSetXmlRootElement()) {
            Schema rootElementSchema;
            XmlRootElement xmlRE = info.getXmlRootElement();
            rootElement = new Element();
            String elementName = xmlRE.getName();
            if (elementName.equals(DEFAULT) || elementName.equals(EMPTY_STRING)) {
                try {
                    elementName = info.getXmlNameTransformer().transformRootElementName(myClassName);
                }
                catch (Exception ex) {
                    throw JAXBException.exceptionDuringNameTransformation((String)myClassName, (String)info.getXmlNameTransformer().getClass().getName(), (Exception)ex);
                }
            }
            rootElement.setName(elementName);
            String rootNamespace = xmlRE.getNamespace();
            if (rootNamespace.equals(DEFAULT)) {
                rootElementSchema = this.getSchemaForNamespace(namespaceInfo.getNamespace());
                if (rootElementSchema != null) {
                    rootElementSchema.addTopLevelElement(rootElement);
                }
                schemaTypeInfo.getGlobalElementDeclarations().add(new QName(namespaceInfo.getNamespace(), rootNamespace));
                rootNamespace = namespaceInfo.getNamespace();
            } else {
                rootElementSchema = this.getSchemaForNamespace(rootNamespace);
                if (rootElementSchema != null) {
                    rootElementSchema.addTopLevelElement(rootElement);
                }
                schemaTypeInfo.getGlobalElementDeclarations().add(new QName(rootNamespace, elementName));
            }
            Schema rootSchema = this.getSchemaForNamespace(rootNamespace);
            this.addImportIfRequired(rootSchema, schema, schema.getTargetNamespace());
            if (rootSchema != null && !info.getClassNamespace().equals(EMPTY_STRING)) {
                pfx = this.getOrGeneratePrefixForNamespace(info.getClassNamespace(), rootSchema);
                pfx = pfx + COLON;
            }
        }
        ArrayList<String> propertyNames = info.getPropertyNames();
        Property xmlValueProperty = info.getXmlValueProperty();
        if (info.isEnumerationType() || propertyNames.size() == 1 && xmlValueProperty != null) {
            type = new SimpleType();
            if (typeName.equals(EMPTY_STRING)) {
                if (rootElement != null) {
                    rootElement.setSimpleType(type);
                }
            } else {
                type.setName(typeName);
                schema.addTopLevelSimpleTypes(type);
                if (rootElement != null) {
                    rootElement.setType(pfx + type.getName());
                }
            }
            QName restrictionType = null;
            Restriction restriction = new Restriction();
            if (info.isEnumerationType()) {
                restrictionType = ((EnumTypeInfo)info).getRestrictionBase();
                restriction.setEnumerationFacets(this.getEnumerationFacetsFor((EnumTypeInfo)info));
                restriction.setBaseType("xsd:" + restrictionType.getLocalPart());
                type.setRestriction(restriction);
            } else {
                valueField = info.getProperties().get(propertyNames.get(0));
                JavaClass javaType = valueField.getActualType();
                QName baseType = this.getSchemaTypeFor(javaType);
                String prefix = null;
                if (baseType.getNamespaceURI() != null && !baseType.getNamespaceURI().equals(EMPTY_STRING)) {
                    prefix = baseType.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema") ? "xsd" : this.getPrefixForNamespace(schema, baseType.getNamespaceURI());
                }
                String baseTypeName = baseType.getLocalPart();
                if (prefix != null) {
                    baseTypeName = prefix + COLON + baseTypeName;
                }
                if (valueField.isXmlList() || valueField.getGenericType() != null) {
                    List list = new List();
                    list.setItemType(baseTypeName);
                    type.setList(list);
                } else {
                    if (this.helper.isAnnotationPresent(valueField.getElement(), XmlSchemaType.class)) {
                        XmlSchemaType schemaType = (XmlSchemaType)this.helper.getAnnotation(valueField.getElement(), XmlSchemaType.class);
                        baseType = new QName(schemaType.namespace(), schemaType.name());
                    }
                    restriction.setBaseType(baseTypeName);
                    type.setRestriction(restriction);
                }
            }
            info.setSimpleType(type);
        } else {
            valueField = this.getXmlValueFieldForSimpleContent(info);
            if (valueField != null) {
                type = new ComplexType();
                SimpleContent content = new SimpleContent();
                if (typeName.equals(EMPTY_STRING)) {
                    if (rootElement != null) {
                        rootElement.setComplexType((ComplexType)type);
                    }
                    info.setComplexType((ComplexType)type);
                } else {
                    type.setName(typeName);
                    schema.addTopLevelComplexTypes((ComplexType)type);
                    if (rootElement != null) {
                        rootElement.setType(pfx + type.getName());
                    }
                }
                QName extensionType = this.getSchemaTypeFor(valueField.getType());
                if (this.helper.isAnnotationPresent(valueField.getElement(), XmlSchemaType.class)) {
                    XmlSchemaType schemaType = (XmlSchemaType)this.helper.getAnnotation(valueField.getElement(), XmlSchemaType.class);
                    extensionType = new QName(schemaType.namespace(), schemaType.name());
                }
                String prefix = null;
                if (extensionType.getNamespaceURI() != null && !extensionType.getNamespaceURI().equals(EMPTY_STRING)) {
                    prefix = extensionType.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema") ? "xsd" : this.getPrefixForNamespace(schema, extensionType.getNamespaceURI());
                }
                String extensionTypeName = extensionType.getLocalPart();
                if (prefix != null) {
                    extensionTypeName = prefix + COLON + extensionTypeName;
                }
                Extension extension = new Extension();
                extension.setBaseType(extensionTypeName);
                content.setExtension(extension);
                type.setSimpleContent(content);
                info.setComplexType((ComplexType)type);
            } else {
                TypeInfo parentTypeInfo;
                type = new ComplexType();
                JavaClass superClass = CompilerHelper.getNextMappedSuperClass(myClass, this.typeInfo, this.helper);
                if (myClass.isAbstract()) {
                    type.setAbstractValue(true);
                }
                Extension extension = null;
                if (superClass != null && (parentTypeInfo = this.typeInfo.get(superClass.getQualifiedName())) != null) {
                    extension = new Extension();
                    String parentPrefix = this.getPrefixForNamespace(schema, parentTypeInfo.getClassNamespace());
                    if (parentPrefix != null) {
                        extension.setBaseType(parentPrefix + COLON + parentTypeInfo.getSchemaTypeName());
                    } else {
                        extension.setBaseType(parentTypeInfo.getSchemaTypeName());
                    }
                    ComplexContent content = new ComplexContent();
                    content.setExtension(extension);
                    type.setComplexContent(content);
                }
                Sequence compositor = null;
                String[] propOrder = null;
                if (info.isSetPropOrder()) {
                    propOrder = info.getPropOrder();
                }
                if (propOrder != null && propOrder.length == 0) {
                    if (info.hasElementRefs()) {
                        compositor = new Sequence();
                        if (extension != null) {
                            extension.setSequence(compositor);
                        } else {
                            type.setSequence(compositor);
                        }
                    } else if (extension != null) {
                        compositor = new All();
                        extension.setAll((All)compositor);
                    } else {
                        compositor = new All();
                        type.setAll((All)compositor);
                    }
                } else {
                    compositor = new Sequence();
                    if (extension != null) {
                        extension.setSequence(compositor);
                    } else {
                        type.setSequence(compositor);
                    }
                }
                if (typeName.equals(EMPTY_STRING)) {
                    if (rootElement != null) {
                        rootElement.setComplexType((ComplexType)type);
                    }
                    info.setComplexType((ComplexType)type);
                    info.setCompositor((TypeDefParticle)compositor);
                } else {
                    type.setName(typeName);
                    if (rootElement != null) {
                        rootElement.setType(pfx + type.getName());
                    }
                    schema.addTopLevelComplexTypes((ComplexType)type);
                    info.setComplexType((ComplexType)type);
                    info.setCompositor((TypeDefParticle)compositor);
                }
            }
        }
    }

    public void addToSchemaType(TypeInfo ownerTypeInfo, java.util.List<Property> properties, TypeDefParticle compositor, ComplexType type, Schema workingSchema) {
        if (properties.size() == 0) {
            type.setAll(null);
            type.setSequence(null);
            type.setChoice(null);
            ownerTypeInfo.setCompositor(null);
            return;
        }
        boolean extAnyAdded = false;
        for (Property next : properties) {
            if (next == null) continue;
            Schema currentSchema = workingSchema;
            TypeDefParticle parentCompositor = compositor;
            boolean isChoice = parentCompositor instanceof Choice;
            ComplexType parentType = type;
            if (next.isTransient() || next.isInverseReference()) continue;
            if (next.isVirtual()) {
                boolean extSchemaAny = false;
                if (ownerTypeInfo.getXmlVirtualAccessMethods().getSchema() != null) {
                    extSchemaAny = ownerTypeInfo.getXmlVirtualAccessMethods().getSchema().equals((Object)XmlVirtualAccessMethodsSchema.ANY);
                }
                if (extSchemaAny && !next.isAttribute()) {
                    if (extAnyAdded) continue;
                    this.addAnyToSchema(next, compositor, true, "##any");
                    extAnyAdded = true;
                    continue;
                }
            }
            if (next.isSetXmlTransformation() && next.getXmlTransformation().isSetXmlWriteTransformers()) {
                this.addTransformerToSchema(next, ownerTypeInfo, compositor, type, workingSchema);
                continue;
            }
            if (next.isSetXmlJoinNodes()) {
                this.addXmlJoinNodesToSchema(next, parentCompositor, currentSchema, parentType);
                continue;
            }
            if (next.getXmlPath() != null) {
                AddToSchemaResult xpr = this.addXPathToSchema(next, parentCompositor, currentSchema, isChoice, type);
                if (xpr == null || (parentCompositor = xpr.particle) == null) continue;
                currentSchema = xpr.schema;
                if (parentCompositor.getOwner() instanceof ComplexType) {
                    parentType = (ComplexType)parentCompositor.getOwner();
                }
            } else if (!isChoice && next.isSetXmlElementWrapper()) {
                AddToSchemaResult asr = this.addXmlElementWrapperToSchema(next, currentSchema, compositor);
                if (asr == null) continue;
                parentType = asr.type;
                parentCompositor = asr.particle;
            }
            if (next.isMixedContent()) {
                parentType.setMixed(true);
            }
            if (next.isAttribute() && !next.isAnyAttribute()) {
                this.addAttributeToSchema(this.buildAttribute(next, currentSchema), next.getSchemaName(), currentSchema, parentType);
                continue;
            }
            if (next.isAnyAttribute()) {
                this.addAnyAttributeToSchema(parentType);
                continue;
            }
            if (next.isChoice()) {
                this.addChoiceToSchema(next, ownerTypeInfo, parentType, parentCompositor, currentSchema);
                continue;
            }
            if (next.isReference()) {
                this.addReferenceToSchema(next, currentSchema, parentCompositor);
                continue;
            }
            if (next.isAny()) {
                this.addAnyToSchema(next, parentCompositor);
                continue;
            }
            if (ownerTypeInfo.getXmlValueProperty() != null && ownerTypeInfo.getXmlValueProperty() == next) continue;
            this.addElementToSchema(this.buildElement(next, parentCompositor instanceof All, currentSchema, ownerTypeInfo), next.getSchemaName().getNamespaceURI(), next.isPositional(), parentCompositor, currentSchema);
        }
    }

    public QName getSchemaTypeFor(JavaClass javaClass) {
        TypeInfo targetInfo;
        Class wrapperClass;
        String className = javaClass.isArray() ? (null == (wrapperClass = this.arrayClassesToGeneratedClasses.get(javaClass.getName())) ? javaClass.getQualifiedName() : wrapperClass.getName()) : javaClass.getQualifiedName();
        QName schemaType = this.userDefinedSchemaTypes.get(className);
        if (schemaType == null) {
            schemaType = (QName)this.helper.getXMLToJavaTypeMap().get(javaClass.getRawName());
        }
        if (schemaType == null && (targetInfo = this.typeInfo.get(className)) != null) {
            schemaType = new QName(targetInfo.getClassNamespace(), targetInfo.getSchemaTypeName());
        }
        if (schemaType == null) {
            if (javaClass.getQualifiedName().equals(OBJECT_CLASSNAME)) {
                return XMLConstants.ANY_TYPE_QNAME;
            }
            return XMLConstants.ANY_SIMPLE_TYPE_QNAME;
        }
        return schemaType;
    }

    public void populateSchemaTypes() {
        for (String javaClassName : this.typeInfo.keySet()) {
            String xpath;
            String pname;
            TypeInfo info = this.typeInfo.get(javaClassName);
            if (!info.isComplexType() || info.getSchema() == null) continue;
            java.util.List<Property> props = info.getNonTransientPropertiesInPropOrder();
            if (info.isSetXmlDiscriminatorNode() && !(pname = XMLProcessor.getNameFromXPath(xpath = info.getXmlDiscriminatorNode(), EMPTY_STRING, true)).equals(EMPTY_STRING)) {
                Property prop = new Property(this.helper);
                prop.setPropertyName(pname);
                prop.setXmlPath(xpath);
                prop.setSchemaName(new QName(pname));
                prop.setType(this.helper.getJavaClass(String.class));
                prop.setIsAttribute(true);
                props.add(prop);
            }
            this.addToSchemaType(info, props, info.getCompositor(), info.getComplexType(), info.getSchema());
        }
    }

    public String getSchemaTypeNameForClassName(String className) {
        return Introspector.decapitalize(className.substring(className.lastIndexOf(DOT_CHAR.charValue()) + 1));
    }

    public ArrayList<String> getEnumerationFacetsFor(EnumTypeInfo info) {
        return (ArrayList)info.getXmlEnumValues();
    }

    public Property getXmlValueFieldForSimpleContent(TypeInfo info) {
        ArrayList<Property> properties = info.getPropertyList();
        Property xmlValueProperty = info.getXmlValueProperty();
        boolean foundValue = false;
        boolean foundNonAttribute = false;
        Property valueField = null;
        for (Property prop : properties) {
            if (xmlValueProperty != null && xmlValueProperty == prop) {
                foundValue = true;
                valueField = prop;
                continue;
            }
            if (prop.isAttribute() || this.helper.isAnnotationPresent(prop.getElement(), XmlTransient.class) || prop.isAnyAttribute()) continue;
            foundNonAttribute = true;
        }
        if (foundValue && !foundNonAttribute) {
            return valueField;
        }
        return null;
    }

    public boolean isCollectionType(Property field) {
        JavaClass type = field.getType();
        return this.helper.getJavaClass(Collection.class).isAssignableFrom(type) || this.helper.getJavaClass(java.util.List.class).isAssignableFrom(type) || this.helper.getJavaClass(Set.class).isAssignableFrom(type);
    }

    private Schema getSchemaForNamespace(String namespace) {
        Schema schema;
        if (this.schemaForNamespace == null) {
            this.schemaForNamespace = new HashMap();
            this.allSchemas = new ArrayList<Schema>();
        }
        if ((schema = this.schemaForNamespace.get(namespace)) == null && !"http://www.w3.org/XML/1998/namespace".equals(namespace)) {
            schema = new Schema();
            String schemaName = SCHEMA + this.schemaCount + SCHEMA_EXT;
            NamespaceInfo namespaceInfo = this.getNamespaceInfoForNamespace(namespace);
            if (namespaceInfo != null) {
                if (namespaceInfo.getLocation() != null && !namespaceInfo.getLocation().equals(GENERATE)) {
                    return null;
                }
                Vector namespaces = namespaceInfo.getNamespaceResolver().getNamespaces();
                for (int i = 0; i < namespaces.size(); ++i) {
                    Namespace nextNamespace = (Namespace)namespaces.get(i);
                    schema.getNamespaceResolver().put(nextNamespace.getPrefix(), nextNamespace.getNamespaceURI());
                }
            }
            if (this.outputResolver != null) {
                try {
                    Result res = this.outputResolver.createOutput(namespace, schemaName);
                    if (res == null) {
                        return null;
                    }
                    schema.setResult(res);
                    if (res.getSystemId() != null) {
                        schemaName = res.getSystemId();
                        schemaName = schemaName.replace(SLASHES.charValue(), SLASH.charValue());
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            schema.setName(schemaName);
            ++this.schemaCount;
            if (!namespace.equals(EMPTY_STRING)) {
                schema.setTargetNamespace(namespace);
                String prefix = null;
                if (namespaceInfo != null) {
                    prefix = namespaceInfo.getNamespaceResolver().resolveNamespaceURI(namespace);
                }
                if (prefix == null) {
                    prefix = schema.getNamespaceResolver().generatePrefix();
                }
                schema.getNamespaceResolver().put(prefix, namespace);
            }
            if (namespaceInfo != null) {
                schema.setAttributeFormDefault(namespaceInfo.isAttributeFormQualified());
                schema.setElementFormDefault(namespaceInfo.isElementFormQualified());
            }
            this.schemaForNamespace.put(namespace, schema);
            this.allSchemas.add(schema);
        }
        return schema;
    }

    public Collection<Schema> getAllSchemas() {
        if (this.allSchemas == null) {
            this.allSchemas = new ArrayList<Schema>();
        }
        return this.allSchemas;
    }

    public NamespaceInfo getNamespaceInfoForNamespace(String namespace) {
        Collection<PackageInfo> packageInfo = this.packageToPackageInfoMappings.values();
        for (PackageInfo info : packageInfo) {
            if (!info.getNamespace().equals(namespace)) continue;
            return info.getNamespaceInfo();
        }
        return null;
    }

    public String getPrefixForNamespace(Schema schema, String URI2) {
        Schema referencedSchema = this.getSchemaForNamespace(URI2);
        this.addImportIfRequired(schema, referencedSchema, URI2);
        NamespaceResolver namespaceResolver = schema.getNamespaceResolver();
        Enumeration keys = namespaceResolver.getPrefixes();
        while (keys.hasMoreElements()) {
            String next = (String)keys.nextElement();
            String nextUri = namespaceResolver.resolveNamespacePrefix(next);
            if (!nextUri.equals(URI2)) continue;
            return next;
        }
        return null;
    }

    public String getOrGeneratePrefixForNamespace(String URI2, Schema schema) {
        String prefix = schema.getNamespaceResolver().resolveNamespaceURI(URI2);
        if (prefix == null) {
            if (URI2.equals("http://www.w3.org/2001/XMLSchema")) {
                prefix = schema.getNamespaceResolver().generatePrefix("xsd");
            } else if (URI2.equals("http://ws-i.org/profiles/basic/1.1/xsd")) {
                prefix = schema.getNamespaceResolver().generatePrefix("ref");
                if (!this.importExists(schema, SWA_REF_IMPORT)) {
                    Import schemaImport = new Import();
                    schemaImport.setSchemaLocation(SWA_REF_IMPORT);
                    schemaImport.setNamespace(URI2);
                    schema.getImports().add(schemaImport);
                }
            } else {
                prefix = schema.getNamespaceResolver().generatePrefix();
            }
            schema.getNamespaceResolver().put(prefix, URI2);
        }
        return prefix;
    }

    public void addGlobalElements(HashMap<QName, ElementDeclaration> additionalElements) {
        for (Map.Entry<QName, ElementDeclaration> entry : additionalElements.entrySet()) {
            String prefix;
            String namespaceURI;
            Schema targetSchema;
            ElementDeclaration nextElement;
            QName next = entry.getKey();
            if (next == null || (nextElement = entry.getValue()).getScopeClass() != XmlElementDecl.GLOBAL.class || (targetSchema = this.getSchemaForNamespace(namespaceURI = next.getNamespaceURI())) == null || targetSchema.getTopLevelElements().get(next.getLocalPart()) != null) continue;
            Element element = new Element();
            element.setName(next.getLocalPart());
            JavaClass javaClass = nextElement.getJavaType();
            QName schemaType = (QName)this.helper.getXMLToJavaTypeMap().get(javaClass.getRawName());
            if (schemaType != null) {
                element.setType("xsd:" + schemaType.getLocalPart());
            } else if (this.areEquals(javaClass, JAVAX_ACTIVATION_DATAHANDLER) || this.areEquals(javaClass, byte[].class) || this.areEquals(javaClass, Byte[].class) || this.areEquals(javaClass, Image.class) || this.areEquals(javaClass, Source.class) || this.areEquals(javaClass, JAVAX_MAIL_INTERNET_MIMEMULTIPART)) {
                schemaType = XMLConstants.BASE_64_BINARY_QNAME;
                if (nextElement.getTypeMappingInfo() != null) {
                    if (nextElement.isXmlAttachmentRef()) {
                        schemaType = XMLConstants.SWA_REF_QNAME;
                    }
                    if (nextElement.getXmlMimeType() != null) {
                        element.getAttributesMap().put(XMLConstants.EXPECTED_CONTENT_TYPES_QNAME, nextElement.getXmlMimeType());
                    }
                }
                String prefix2 = this.getOrGeneratePrefixForNamespace(schemaType.getNamespaceURI(), targetSchema);
                element.setType(prefix2 + COLON + schemaType.getLocalPart());
            } else if (this.areEquals(javaClass, ClassConstants.XML_GREGORIAN_CALENDAR)) {
                schemaType = XMLConstants.ANY_SIMPLE_TYPE_QNAME;
                element.setType("xsd:" + schemaType.getLocalPart());
            } else {
                TypeInfo type = this.typeInfo.get(javaClass.getQualifiedName());
                if (type != null) {
                    String typeName = null;
                    typeName = type.isComplexType() ? type.getComplexType().getName() : type.getSimpleType().getName();
                    if (typeName == null) {
                        Schema schema = this.getSchemaForNamespace(next.getNamespaceURI());
                        ComplexType cType = new ComplexType();
                        Sequence particle = new Sequence();
                        cType.setTypeDefParticle((TypeDefParticle)particle);
                        element.setComplexType(cType);
                        this.addToSchemaType(type, type.getPropertyList(), (TypeDefParticle)particle, cType, schema);
                        targetSchema = schema;
                    } else if (type.getClassNamespace().equals(namespaceURI)) {
                        prefix = targetSchema.getNamespaceResolver().resolveNamespaceURI(namespaceURI);
                        if (prefix != null && !prefix.equals(EMPTY_STRING)) {
                            element.setType(prefix + COLON + typeName);
                        } else {
                            element.setType(typeName);
                        }
                    } else {
                        Schema complexTypeSchema = this.getSchemaForNamespace(type.getClassNamespace());
                        String complexTypeSchemaNS = type.getClassNamespace();
                        if (complexTypeSchemaNS == null) {
                            complexTypeSchemaNS = EMPTY_STRING;
                        }
                        this.addImportIfRequired(targetSchema, complexTypeSchema, type.getClassNamespace());
                        String prefix3 = targetSchema.getNamespaceResolver().resolveNamespaceURI(complexTypeSchemaNS);
                        if (prefix3 != null) {
                            element.setType(prefix3 + COLON + typeName);
                        } else {
                            element.setType(typeName);
                        }
                    }
                }
            }
            if (nextElement.getSubstitutionHead() != null) {
                String subLocal = nextElement.getSubstitutionHead().getLocalPart();
                String subNamespace = nextElement.getSubstitutionHead().getNamespaceURI();
                prefix = this.getPrefixForNamespace(targetSchema, subNamespace);
                if (prefix == null || prefix.equals(EMPTY_STRING)) {
                    element.setSubstitutionGroup(subLocal);
                } else {
                    element.setSubstitutionGroup(prefix + COLON + subLocal);
                }
            }
            targetSchema.addTopLevelElement(element);
            SchemaTypeInfo info = this.schemaTypeInfo.get(javaClass.getQualifiedName());
            if (info == null) {
                info = new SchemaTypeInfo();
                info.setSchemaTypeName(schemaType);
                this.schemaTypeInfo.put(javaClass.getQualifiedName(), info);
            }
            info.getGlobalElementDeclarations().add(next);
        }
    }

    public HashMap<String, SchemaTypeInfo> getSchemaTypeInfo() {
        return this.schemaTypeInfo;
    }

    private boolean importExists(Schema schema, String schemaName) {
        java.util.List imports = schema.getImports();
        for (int i = 0; i < imports.size(); ++i) {
            Import nextImport = (Import)imports.get(i);
            if (nextImport.getSchemaLocation() == null || !nextImport.getSchemaLocation().equals(schemaName)) continue;
            return true;
        }
        return false;
    }

    private boolean addImportIfRequired(Schema sourceSchema, Schema importSchema, String importNamespace) {
        if (!(importSchema == sourceSchema || importNamespace != null && importNamespace.equals("http://www.w3.org/2001/XMLSchema"))) {
            String schemaName = null;
            if ("http://www.w3.org/XML/1998/namespace".equals(importNamespace)) {
                schemaName = "http://www.w3.org/XML/1998/xml.xsd";
            } else if (importSchema != null) {
                schemaName = importSchema.getName();
            } else if (importNamespace != null) {
                NamespaceInfo nInfo = this.getNamespaceInfoForNamespace(importNamespace);
                schemaName = nInfo.getLocation();
            }
            if (schemaName != null && importSchema != null) {
                URI relativizedURI = null;
                try {
                    String schemaPath = sourceSchema.getName();
                    int idx = schemaPath.lastIndexOf(SLASH.charValue());
                    if (idx != -1) {
                        schemaPath = schemaPath.substring(0, idx);
                    }
                    URI baseURI = new URI(schemaPath);
                    URI importURI = new URI(schemaName);
                    relativizedURI = baseURI.relativize(importURI);
                }
                catch (Exception e) {
                    relativizedURI = null;
                }
                if (relativizedURI != null) {
                    schemaName = relativizedURI.getPath();
                }
            }
            if (schemaName != null && !this.importExists(sourceSchema, schemaName)) {
                String prefix;
                Import schemaImport = new Import();
                schemaImport.setSchemaLocation(schemaName);
                if (importNamespace != null && !importNamespace.equals(EMPTY_STRING)) {
                    schemaImport.setNamespace(importNamespace);
                }
                sourceSchema.getImports().add(schemaImport);
                if (schemaImport.getNamespace() != null && (prefix = sourceSchema.getNamespaceResolver().resolveNamespaceURI(importNamespace)) == null && !importNamespace.equals(EMPTY_STRING)) {
                    sourceSchema.getNamespaceResolver().put(sourceSchema.getNamespaceResolver().generatePrefix(), importNamespace);
                }
                return true;
            }
        }
        return false;
    }

    protected boolean areEquals(JavaClass src, String tgtCanonicalName) {
        if (src == null || tgtCanonicalName == null) {
            return false;
        }
        return src.getRawName().equals(tgtCanonicalName);
    }

    protected boolean areEquals(JavaClass src, Class tgt) {
        if (src == null || tgt == null) {
            return false;
        }
        return src.getRawName().equals(tgt.getCanonicalName());
    }

    private String getTypeName(Property next, JavaClass javaType, Schema theSchema) {
        QName schemaType = next.getSchemaType();
        if (schemaType == null) {
            schemaType = this.getSchemaTypeFor(javaType);
        }
        if (schemaType != null) {
            if (schemaType.getNamespaceURI() == null) {
                return schemaType.getLocalPart();
            }
            return this.getOrGeneratePrefixForNamespace(schemaType.getNamespaceURI(), theSchema) + COLON + schemaType.getLocalPart();
        }
        return "xsd:anySimpleType";
    }

    private String getQualifiedTypeName(Property prop, Schema schema) {
        String prefix;
        JavaClass javaType = prop.getActualType();
        String typeName = this.getTypeName(prop, javaType, schema);
        if (typeName != null && !typeName.contains(COLON) && (prefix = this.getPrefixForNamespace(schema, schema.getTargetNamespace())) != null) {
            typeName = prefix + COLON + typeName;
        }
        return typeName;
    }

    protected AddToSchemaResult buildSchemaComponentsForXPath(XPathFragment frag, AddToSchemaResult xpr, boolean isChoice, Property next) {
        boolean currentElementExists;
        boolean lastFrag;
        boolean isAny = next.isAny() || next.isAnyAttribute();
        TypeDefParticle currentParticle = xpr.particle;
        Schema workingSchema = xpr.schema;
        boolean isUnbounded = currentParticle.getMaxOccurs() != null && currentParticle.getMaxOccurs() == "unbounded";
        boolean bl = lastFrag = frag.getNextFragment() == null || frag.getNextFragment().nameIsText();
        if (lastFrag && this.elementExistsInParticle(frag.getLocalName(), frag.getShortName(), currentParticle) != null) {
            xpr.particle = null;
            return xpr;
        }
        Element currentElement = this.elementExistsInParticle(frag.getLocalName(), frag.getShortName(), currentParticle);
        boolean bl2 = currentElementExists = currentElement != null;
        if (!currentElementExists) {
            currentElement = new Element();
            ComplexType cType = new ComplexType();
            Choice particle = null;
            if (isChoice) {
                particle = new Choice();
                if (isUnbounded) {
                    particle.setMaxOccurs("unbounded");
                }
            } else {
                particle = new Sequence();
            }
            cType.setTypeDefParticle((TypeDefParticle)particle);
            currentElement.setComplexType(cType);
        }
        Element globalElement = null;
        String fragUri = frag.getNamespaceURI();
        if (fragUri != null) {
            Schema fragSchema = this.getSchemaForNamespace(fragUri);
            String targetNS = workingSchema.getTargetNamespace();
            if (frag.isAttribute()) {
                if (fragSchema.isAttributeFormDefault() && !fragUri.equals(targetNS) || !fragSchema.isAttributeFormDefault() && fragUri.length() > 0) {
                    String attributeRefName;
                    Attribute globalAttribute = null;
                    globalAttribute = (Attribute)fragSchema.getTopLevelAttributes().get(frag.getLocalName());
                    if (globalAttribute == null) {
                        globalAttribute = this.createGlobalAttribute(frag, workingSchema, fragSchema, next);
                    }
                    if (fragUri.equals(targetNS)) {
                        String prefix = fragSchema.getNamespaceResolver().resolveNamespaceURI(fragUri);
                        attributeRefName = prefix + COLON + frag.getLocalName();
                    } else {
                        attributeRefName = frag.getShortName();
                    }
                    if (currentParticle.getOwner() instanceof ComplexType) {
                        this.createRefAttribute(attributeRefName, (ComplexType)currentParticle.getOwner());
                    }
                    xpr.schema = fragSchema;
                    xpr.particle = null;
                }
                return xpr;
            }
            if (fragSchema.isElementFormDefault() && !fragUri.equals(targetNS) || !fragSchema.isElementFormDefault() && fragUri.length() > 0) {
                globalElement = (Element)fragSchema.getTopLevelElements().get(frag.getLocalName());
                if (globalElement == null) {
                    globalElement = this.createGlobalElement(frag, workingSchema, fragSchema, isChoice, isUnbounded, next, lastFrag && !isAny);
                }
                if (!currentElementExists) {
                    String fragPrefix = workingSchema.getNamespaceResolver().resolveNamespaceURI(fragUri);
                    if (fragPrefix == null) {
                        fragPrefix = workingSchema.getNamespaceResolver().generatePrefix(frag.getPrefix());
                        workingSchema.getNamespaceResolver().put(fragPrefix, fragUri);
                    }
                    currentElement = this.createRefElement(fragPrefix + COLON + frag.getLocalName(), currentParticle);
                    currentElementExists = true;
                }
                xpr.schema = fragSchema;
                if (lastFrag) {
                    if (isAny) {
                        xpr.particle = globalElement.getComplexType().getTypeDefParticle();
                        return xpr;
                    }
                    xpr.particle = null;
                    return xpr;
                }
                currentElement = globalElement;
            }
        }
        if (!lastFrag || lastFrag && isAny) {
            if (!currentElementExists && globalElement == null) {
                currentElement.setName(frag.getLocalName());
                currentElement.setMinOccurs("0");
                currentParticle.addElement(currentElement);
            }
            xpr.particle = currentElement.getComplexType().getTypeDefParticle();
        }
        if (lastFrag) {
            return xpr;
        }
        return this.buildSchemaComponentsForXPath(frag.getNextFragment(), xpr, isChoice, next);
    }

    protected Element elementExistsInParticle(String elementName, String refString, TypeDefParticle particle) {
        if (particle.getElements() == null || particle.getElements().size() == 0) {
            return null;
        }
        java.util.List existingElements = particle.getElements();
        if (existingElements != null) {
            Iterator elementIt = existingElements.iterator();
            while (elementIt.hasNext()) {
                Element element;
                try {
                    element = (Element)elementIt.next();
                }
                catch (ClassCastException cce) {
                    continue;
                }
                if (!(refString == null ? (element.getRef() == null || element.getRef() != null && element.getRef().equals(element.getName())) && elementName.equals(element.getName()) : (refString.equals(elementName) ? element.getRef() != null && element.getRef().equals(refString) || element.getRef() == null && elementName.equals(element.getName()) : element.getRef() != null && element.getRef().equals(refString)))) continue;
                return element;
            }
        }
        return null;
    }

    public Attribute createGlobalAttribute(XPathFragment frag, Schema workingSchema, Schema fragSchema, Property prop) {
        Attribute gAttribute = new Attribute();
        gAttribute.setName(frag.getLocalName());
        gAttribute.setType(this.getQualifiedTypeName(prop, fragSchema));
        fragSchema.getTopLevelAttributes().put(gAttribute.getName(), gAttribute);
        this.addImportIfRequired(workingSchema, fragSchema, frag.getNamespaceURI());
        return gAttribute;
    }

    public Element createGlobalElement(XPathFragment frag, Schema workingSchema, Schema fragSchema, boolean isChoice, boolean isUnbounded, Property prop, boolean shouldSetType) {
        Element gElement = new Element();
        gElement.setName(frag.getLocalName());
        if (shouldSetType) {
            gElement.setType(this.getQualifiedTypeName(prop, fragSchema));
        } else {
            Choice particle;
            ComplexType gCType = new ComplexType();
            if (isChoice) {
                particle = new Choice();
                if (isUnbounded) {
                    particle.setMaxOccurs("unbounded");
                }
            } else {
                particle = new Sequence();
            }
            gCType.setTypeDefParticle((TypeDefParticle)particle);
            gElement.setComplexType(gCType);
        }
        fragSchema.addTopLevelElement(gElement);
        this.addImportIfRequired(workingSchema, fragSchema, frag.getNamespaceURI());
        return gElement;
    }

    public Element createRefElement(String elementRefName, TypeDefParticle particle) {
        Element refElement = new Element();
        refElement.setComplexType(null);
        refElement.setMinOccurs("0");
        refElement.setMaxOccurs("1");
        refElement.setRef(elementRefName);
        particle.addElement(refElement);
        return refElement;
    }

    public Attribute createRefAttribute(String attributeRefName, ComplexType owningComplexType) {
        Attribute refAttribute = new Attribute();
        refAttribute.setRef(attributeRefName);
        if (owningComplexType.getSimpleContent() != null) {
            owningComplexType.getSimpleContent().getExtension().getOrderedAttributes().add(refAttribute);
        } else {
            owningComplexType.getOrderedAttributes().add(refAttribute);
        }
        return refAttribute;
    }

    private void addTransformerToSchema(Property property, TypeInfo typeInfo, TypeDefParticle compositor, ComplexType type, Schema schema) {
        ArrayList<Property> props = new ArrayList<Property>();
        for (XmlTransformation.XmlWriteTransformer writeTransformer : property.getXmlTransformation().getXmlWriteTransformer()) {
            String methodName;
            String xpath = writeTransformer.getXmlPath();
            String pname = XMLProcessor.getNameFromXPath(xpath, property.getPropertyName(), xpath.contains(ATT));
            Property prop = new Property(this.helper);
            prop.setPropertyName(pname);
            prop.setXmlPath(xpath);
            prop.setSchemaName(new QName(pname));
            JavaClass jType = null;
            JavaClass jClass = null;
            JavaMethod jMethod = null;
            if (writeTransformer.isSetTransformerClass()) {
                try {
                    jClass = this.helper.getJavaClass(writeTransformer.getTransformerClass());
                }
                catch (JAXBException x) {
                    throw JAXBException.transformerClassNotFound((String)writeTransformer.getTransformerClass());
                }
                methodName = BUILD_FIELD_VALUE_METHOD;
                jMethod = jClass.getDeclaredMethod(methodName, new JavaClass[]{this.helper.getJavaClass(Object.class), this.helper.getJavaClass(String.class), this.helper.getJavaClass(Session.class)});
                if (jMethod == null) {
                    throw JAXBException.noSuchWriteTransformationMethod((String)methodName);
                }
                jType = jMethod.getReturnType();
            } else {
                jClass = this.helper.getJavaClass(typeInfo.getJavaClassName());
                jMethod = jClass.getDeclaredMethod(methodName = writeTransformer.getMethod(), new JavaClass[0]);
                if (jMethod == null && (jMethod = jClass.getDeclaredMethod(methodName, new JavaClass[]{this.helper.getJavaClass(AbstractSession.class)})) == null && (jMethod = jClass.getDeclaredMethod(methodName, new JavaClass[]{this.helper.getJavaClass(Session.class)})) == null) {
                    throw JAXBException.noSuchWriteTransformationMethod((String)methodName);
                }
                jType = jMethod.getReturnType();
            }
            prop.setType(jType);
            props.add(prop);
        }
        this.addToSchemaType(typeInfo, props, compositor, type, schema);
    }

    private AddToSchemaResult addXPathToSchema(Property property, TypeDefParticle compositor, Schema schema, boolean isChoice, ComplexType type) {
        if (property.getXmlPath().equals(DOT)) {
            TypeInfo info = this.typeInfo.get(property.getActualType().getQualifiedName());
            this.addToSchemaType(info, info.getPropertyList(), compositor, type, info.getSchema());
            return null;
        }
        XMLField xfld = new XMLField(property.getXmlPath());
        xfld.setNamespaceResolver(schema.getNamespaceResolver());
        xfld.initialize();
        return this.buildSchemaComponentsForXPath(xfld.getXPathFragment(), new AddToSchemaResult(compositor, schema), isChoice, property);
    }

    private AddToSchemaResult addXmlElementWrapperToSchema(Property property, Schema schema, TypeDefParticle compositor) {
        XmlElementWrapper wrapper = property.getXmlElementWrapper();
        Element wrapperElement = new Element();
        String name = wrapper.getName();
        if (name.equals(DEFAULT)) {
            name = property.getPropertyName();
        }
        wrapperElement.setNillable(wrapper.isNillable());
        String wrapperNS = wrapper.getNamespace();
        if (!wrapperNS.equals(DEFAULT) && !wrapperNS.equals(schema.getTargetNamespace())) {
            wrapperElement.setMinOccurs("1");
            wrapperElement.setMaxOccurs("1");
            String prefix = this.getOrGeneratePrefixForNamespace(wrapperNS, schema);
            wrapperElement.setRef(prefix + COLON + name);
            compositor.addElement(wrapperElement);
            return null;
        }
        wrapperElement.setName(name);
        if (wrapper.isRequired()) {
            wrapperElement.setMinOccurs("1");
        } else {
            wrapperElement.setMinOccurs("0");
        }
        compositor.addElement(wrapperElement);
        ComplexType wrapperType = new ComplexType();
        Sequence wrapperSequence = new Sequence();
        wrapperType.setSequence(wrapperSequence);
        wrapperElement.setComplexType(wrapperType);
        return new AddToSchemaResult((TypeDefParticle)wrapperSequence, wrapperType);
    }

    private Attribute buildAttribute(QName attributeName, String typeName) {
        Attribute attribute = new Attribute();
        attribute.setName(attributeName.getLocalPart());
        attribute.setType(typeName);
        return attribute;
    }

    private Attribute buildAttribute(Property property, Schema schema) {
        String fixedValue;
        Attribute attribute = new Attribute();
        QName attributeName = property.getSchemaName();
        attribute.setName(attributeName.getLocalPart());
        if (property.isRequired()) {
            attribute.setUse("required");
        }
        if ((fixedValue = property.getFixedValue()) != null) {
            attribute.setFixed(fixedValue);
        }
        TypeInfo info = this.typeInfo.get(property.getActualType().getQualifiedName());
        String typeName = null;
        typeName = property.isXmlId() ? (property.getSchemaType() != null ? this.getTypeName(property, property.getActualType(), schema) : "xsd:ID") : (property.isXmlIdRef() ? "xsd:IDREF" : (info != null && !info.isComplexType() ? info.getSimpleType().getName() : this.getTypeName(property, property.getActualType(), schema)));
        if (this.isCollectionType(property)) {
            SimpleType localType = new SimpleType();
            List list = new List();
            list.setItemType(typeName);
            localType.setList(list);
            attribute.setSimpleType(localType);
        } else {
            String prefix;
            if (typeName != null && !typeName.contains(COLON) && info.getSchema() == schema && (prefix = this.getPrefixForNamespace(schema, schema.getTargetNamespace())) != null) {
                typeName = prefix + COLON + typeName;
            }
            attribute.setType(typeName);
        }
        return attribute;
    }

    private void addAttributeToSchema(Attribute attribute, QName attributeName, Schema schema, ComplexType type) {
        boolean addRef;
        String lookupNamespace = schema.getTargetNamespace();
        if (lookupNamespace == null) {
            lookupNamespace = EMPTY_STRING;
        }
        NamespaceInfo namespaceInfo = this.getNamespaceInfoForNamespace(lookupNamespace);
        boolean isAttributeFormQualified = false;
        if (namespaceInfo != null) {
            isAttributeFormQualified = namespaceInfo.isAttributeFormQualified();
        }
        if (addRef = this.shouldAddRefAndSetForm((SimpleComponent)attribute, attributeName.getNamespaceURI(), lookupNamespace, isAttributeFormQualified, false)) {
            Schema attributeSchema = this.getSchemaForNamespace(attributeName.getNamespaceURI());
            if (attributeSchema != null && attributeSchema.getTopLevelAttributes().get(attribute.getName()) == null) {
                attributeSchema.getTopLevelAttributes().put(attribute.getName(), attribute);
            }
            Attribute reference = new Attribute();
            String prefix = this.getPrefixForNamespace(schema, attributeName.getNamespaceURI());
            if (prefix == null) {
                reference.setRef(attribute.getName());
            } else {
                reference.setRef(prefix + COLON + attribute.getName());
            }
            if (type.getSimpleContent() != null) {
                type.getSimpleContent().getExtension().getOrderedAttributes().add(reference);
            } else {
                type.getOrderedAttributes().add(reference);
            }
        } else if (type.getSimpleContent() != null) {
            type.getSimpleContent().getExtension().getOrderedAttributes().add(attribute);
        } else if (type.getComplexContent() != null) {
            type.getComplexContent().getExtension().getOrderedAttributes().add(attribute);
        } else {
            type.getOrderedAttributes().add(attribute);
        }
    }

    private boolean shouldAddRefAndSetForm(SimpleComponent sc, String simpleComponentNamespace, String lookupNamespace, boolean formQualified, boolean isElement) {
        boolean addRef = false;
        boolean sameNamespace = simpleComponentNamespace.equals(lookupNamespace);
        if (formQualified && !sameNamespace) {
            if (simpleComponentNamespace.equals(EMPTY_STRING)) {
                sc.setForm("unqualified");
            } else {
                addRef = true;
            }
        } else if (!formQualified && !simpleComponentNamespace.equals(EMPTY_STRING)) {
            if (sameNamespace && isElement) {
                sc.setForm("qualified");
            } else {
                addRef = true;
            }
        }
        return addRef;
    }

    private void addAnyAttributeToSchema(ComplexType type) {
        AnyAttribute anyAttribute = new AnyAttribute();
        anyAttribute.setProcessContents(SKIP);
        anyAttribute.setNamespace("##other");
        if (type.getSimpleContent() != null) {
            SimpleContent content = type.getSimpleContent();
            content.getRestriction().setAnyAttribute(anyAttribute);
        } else {
            type.setAnyAttribute(anyAttribute);
        }
    }

    private void addAnyToSchema(Property property, TypeDefParticle compositor) {
        this.addAnyToSchema(property, compositor, this.isCollectionType(property), "##other");
    }

    private void addAnyToSchema(Property property, TypeDefParticle compositor, boolean isCollection) {
        this.addAnyToSchema(property, compositor, isCollection, "##other");
    }

    private void addAnyToSchema(Property property, TypeDefParticle compositor, boolean isCollection, String anyNamespace) {
        Any any = new Any();
        any.setNamespace(anyNamespace);
        if (property.isLax()) {
            any.setProcessContents("lax");
        } else {
            any.setProcessContents(SKIP);
        }
        if (isCollection) {
            any.setMinOccurs("0");
            any.setMaxOccurs("unbounded");
        }
        if (compositor instanceof Sequence) {
            ((Sequence)compositor).addAny(any);
        } else if (compositor instanceof Choice) {
            ((Choice)compositor).addAny(any);
        }
    }

    private void addChoiceToSchema(Property property, TypeInfo typeInfo, ComplexType type, TypeDefParticle compositor, Schema schema) {
        Choice choice = new Choice();
        if (property.getGenericType() != null) {
            choice.setMaxOccurs("unbounded");
        }
        ArrayList choiceProperties = (ArrayList)property.getChoiceProperties();
        this.addToSchemaType(typeInfo, choiceProperties, (TypeDefParticle)choice, type, schema);
        if (compositor instanceof Sequence) {
            ((Sequence)compositor).addChoice(choice);
        } else if (compositor instanceof Choice) {
            ((Choice)compositor).addChoice(choice);
        }
    }

    private void addReferenceToSchema(Property property, Schema schema, TypeDefParticle compositor) {
        java.util.List<ElementDeclaration> referencedElements = property.getReferencedElements();
        if (referencedElements.size() == 1 && !property.isAny()) {
            Element element = new Element();
            ElementDeclaration decl = referencedElements.get(0);
            String localName = decl.getElementName().getLocalPart();
            String prefix = this.getPrefixForNamespace(schema, decl.getElementName().getNamespaceURI());
            if (decl.getScopeClass() == XmlElementDecl.GLOBAL.class) {
                if (prefix == null || prefix.equals(EMPTY_STRING)) {
                    element.setRef(localName);
                } else {
                    element.setRef(prefix + COLON + localName);
                }
            } else {
                element.setType(this.getTypeName(property, decl.getJavaType(), schema));
                element.setName(localName);
            }
            if (property.getGenericType() != null) {
                element.setMinOccurs("0");
                element.setMaxOccurs("unbounded");
            }
            compositor.addElement(element);
        } else {
            Choice choice = new Choice();
            if (property.getGenericType() != null) {
                choice.setMaxOccurs("unbounded");
            }
            for (ElementDeclaration elementDecl : referencedElements) {
                Element element = new Element();
                String localName = elementDecl.getElementName().getLocalPart();
                String prefix = this.getPrefixForNamespace(schema, elementDecl.getElementName().getNamespaceURI());
                if (elementDecl.getScopeClass() == XmlElementDecl.GLOBAL.class) {
                    if (prefix == null || prefix.equals(EMPTY_STRING)) {
                        element.setRef(localName);
                    } else {
                        element.setRef(prefix + COLON + localName);
                    }
                } else {
                    Schema referencedSchema = this.getSchemaForNamespace(elementDecl.getElementName().getNamespaceURI());
                    element.setType(this.getTypeName(property, elementDecl.getJavaType(), referencedSchema));
                    element.setName(localName);
                }
                choice.addElement(element);
            }
            if (property.isAny()) {
                this.addAnyToSchema(property, (TypeDefParticle)choice, false);
            }
            if (compositor instanceof Sequence) {
                ((Sequence)compositor).addChoice(choice);
            } else if (compositor instanceof Choice) {
                ((Choice)compositor).addChoice(choice);
            }
        }
    }

    private void addMapToSchema(Property property, Element element, Schema schema, TypeInfo typeInfo) {
        String typeName;
        QName keySchemaType;
        ComplexType entryComplexType = new ComplexType();
        Sequence entrySequence = new Sequence();
        Element keyElement = new Element();
        keyElement.setName("key");
        keyElement.setMinOccurs("0");
        JavaClass keyType = property.getKeyType();
        JavaClass valueType = property.getValueType();
        if (keyType == null) {
            keyType = this.helper.getJavaClass(Object.class);
        }
        if (valueType == null) {
            valueType = this.helper.getJavaClass(Object.class);
        }
        if ((keySchemaType = this.getSchemaTypeFor(keyType)) != null) {
            TypeInfo targetInfo = this.typeInfo.get(keyType.getQualifiedName());
            if (targetInfo != null) {
                Schema keyElementSchema = this.getSchemaForNamespace(keySchemaType.getNamespaceURI());
                this.addImportIfRequired(schema, keyElementSchema, keySchemaType.getNamespaceURI());
            }
            String prefix = keySchemaType.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema") ? "xsd" : this.getPrefixForNamespace(schema, keySchemaType.getNamespaceURI());
            typeName = prefix != null && !prefix.equals(EMPTY_STRING) ? prefix + COLON + keySchemaType.getLocalPart() : keySchemaType.getLocalPart();
            keyElement.setType(typeName);
        }
        entrySequence.addElement(keyElement);
        Element valueElement = new Element();
        valueElement.setName("value");
        valueElement.setMinOccurs("0");
        QName valueSchemaType = this.getSchemaTypeFor(valueType);
        if (valueSchemaType != null) {
            TypeInfo targetInfo = this.typeInfo.get(valueType.getQualifiedName());
            if (targetInfo != null) {
                Schema valueElementSchema = this.getSchemaForNamespace(valueSchemaType.getNamespaceURI());
                this.addImportIfRequired(schema, valueElementSchema, valueSchemaType.getNamespaceURI());
            }
            String prefix = valueSchemaType.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema") ? "xsd" : this.getPrefixForNamespace(schema, valueSchemaType.getNamespaceURI());
            typeName = prefix != null && !prefix.equals(EMPTY_STRING) ? prefix + COLON + valueSchemaType.getLocalPart() : valueSchemaType.getLocalPart();
            valueElement.setType(typeName);
        }
        entrySequence.addElement(valueElement);
        entryComplexType.setSequence(entrySequence);
        JavaClass descriptorClass = this.helper.getJavaClass(typeInfo.getDescriptor().getJavaClassName());
        JavaClass mapValueClass = this.helper.getJavaClass(MapValue.class);
        if (mapValueClass.isAssignableFrom(descriptorClass)) {
            element.setComplexType(entryComplexType);
            element.setMaxOccurs("unbounded");
        } else {
            ComplexType complexType = new ComplexType();
            Sequence sequence = new Sequence();
            complexType.setSequence(sequence);
            Element entryElement = new Element();
            entryElement.setName(ENTRY);
            entryElement.setMinOccurs("0");
            entryElement.setMaxOccurs("unbounded");
            sequence.addElement(entryElement);
            entryElement.setComplexType(entryComplexType);
            element.setComplexType(complexType);
        }
    }

    private void addElementRefToSchema(Schema schema, TypeDefParticle compositor, Element referencedElement, String referencedElementURI) {
        String prefix;
        Element reference = new Element();
        reference.setMinOccurs(referencedElement.getMinOccurs());
        reference.setMaxOccurs(referencedElement.getMaxOccurs());
        Schema attributeSchema = this.getSchemaForNamespace(referencedElementURI);
        if (attributeSchema != null && attributeSchema.getTopLevelElements().get(referencedElement.getName()) == null) {
            referencedElement.setMinOccurs(null);
            referencedElement.setMaxOccurs(null);
            attributeSchema.getTopLevelElements().put(referencedElement.getName(), referencedElement);
        }
        if ((prefix = this.getPrefixForNamespace(schema, referencedElementURI)) == null) {
            reference.setRef(referencedElement.getName());
        } else {
            reference.setRef(prefix + COLON + referencedElement.getName());
        }
        if (this.elementExistsInParticle(reference.getName(), reference.getRef(), compositor) == null) {
            compositor.addElement(reference);
        }
    }

    private Element buildElement(String elementName, String elementType, boolean isAll) {
        Element element = new Element();
        if (!isAll) {
            element.setMinOccurs("0");
        }
        element.setName(elementName);
        element.setType(elementType);
        return element;
    }

    private Element buildElement(Property property, boolean isAll, Schema schema, TypeInfo typeInfo) {
        boolean addRef;
        Element element = new Element();
        element.setMinOccurs(property.isRequired() ? "1" : "0");
        if (property.shouldSetNillable()) {
            element.setNillable(true);
        }
        if (property.isSetDefaultValue()) {
            element.setDefaultValue(property.getDefaultValue());
        }
        if (property.getMimeType() != null) {
            element.getAttributesMap().put(XMLConstants.EXPECTED_CONTENT_TYPES_QNAME, property.getMimeType());
        }
        QName elementName = property.getSchemaName();
        String elementNamespace = elementName.getNamespaceURI();
        String lookupNamespace = schema.getTargetNamespace();
        if (lookupNamespace == null) {
            lookupNamespace = EMPTY_STRING;
        }
        NamespaceInfo namespaceInfo = this.getNamespaceInfoForNamespace(lookupNamespace);
        boolean isElementFormQualified = false;
        if (namespaceInfo != null) {
            isElementFormQualified = namespaceInfo.isElementFormQualified();
        }
        if (addRef = this.shouldAddRefAndSetForm((SimpleComponent)element, elementNamespace, lookupNamespace, isElementFormQualified, true)) {
            schema = this.getSchemaForNamespace(elementNamespace);
        }
        JavaClass javaType = property.getActualType();
        element.setName(elementName.getLocalPart());
        String typeName = this.getTypeNameForElement(property, schema, javaType, element);
        if (property.getGenericType() != null) {
            if (property.isXmlList()) {
                SimpleType localSimpleType = new SimpleType();
                List list = new List();
                list.setItemType(typeName);
                localSimpleType.setList(list);
                element.setSimpleType(localSimpleType);
            } else {
                element.setMaxOccurs("unbounded");
                element.setType(typeName);
            }
        } else if (property.isMap()) {
            this.addMapToSchema(property, element, schema, typeInfo);
        } else {
            element.setType(typeName);
        }
        return element;
    }

    private void addElementToSchema(Element element, String elementURI, boolean isPositional, TypeDefParticle compositor, Schema schema) {
        boolean addRef;
        String lookupNamespace = schema.getTargetNamespace();
        if (lookupNamespace == null) {
            lookupNamespace = EMPTY_STRING;
        }
        NamespaceInfo namespaceInfo = this.getNamespaceInfoForNamespace(lookupNamespace);
        boolean isElementFormQualified = false;
        if (namespaceInfo != null) {
            isElementFormQualified = namespaceInfo.isElementFormQualified();
        }
        if (addRef = this.shouldAddRefAndSetForm((SimpleComponent)element, elementURI, lookupNamespace, isElementFormQualified, true)) {
            this.addElementRefToSchema(schema, compositor, element, elementURI);
        } else if (this.elementExistsInParticle(element.getName(), element.getRef(), compositor) == null) {
            if (isPositional) {
                element.setMaxOccurs("unbounded");
            }
            compositor.addElement(element);
        }
    }

    private void addXmlJoinNodesToSchema(Property property, TypeDefParticle compositor, Schema schema, ComplexType type) {
        for (XmlJoinNodes.XmlJoinNode xmlJoinNode : property.getXmlJoinNodes().getXmlJoinNode()) {
            XMLField xfld = new XMLField(xmlJoinNode.getXmlPath());
            xfld.setNamespaceResolver(schema.getNamespaceResolver());
            xfld.initialize();
            AddToSchemaResult asr = this.buildSchemaComponentsForXPath(xfld.getXPathFragment(), new AddToSchemaResult(compositor, schema), false, property);
            TypeDefParticle currentParticle = asr.particle;
            Schema currentSchema = asr.schema;
            if (currentParticle.getOwner() instanceof ComplexType) {
                type = (ComplexType)currentParticle.getOwner();
            }
            XPathFragment frag = xfld.getLastXPathFragment();
            boolean isAttribute = xmlJoinNode.getXmlPath().contains(ATT);
            if (!isAttribute && frag.nameIsText()) {
                frag = xfld.getXPathFragment();
                while (frag.getNextFragment() != null && !frag.getNextFragment().nameIsText()) {
                    frag = frag.getNextFragment();
                }
            }
            QName schemaName = new QName(frag.getNamespaceURI(), frag.getLocalName());
            if (isAttribute) {
                this.addAttributeToSchema(this.buildAttribute(schemaName, "xsd:anySimpleType"), schemaName, currentSchema, type);
                continue;
            }
            this.addElementToSchema(this.buildElement(schemaName.getLocalPart(), "xsd:anySimpleType", currentParticle instanceof All), schemaName.getNamespaceURI(), false, currentParticle, currentSchema);
        }
    }

    private String getTypeNameForElement(Property property, Schema schema, JavaClass javaClass, Element element) {
        String typeName = null;
        if (property.isXmlId()) {
            typeName = property.getSchemaType() != null ? this.getTypeName(property, property.getActualType(), schema) : "xsd:ID";
        } else if (property.isXmlIdRef()) {
            typeName = "xsd:IDREF";
        } else {
            String prefix;
            TypeInfo info = this.typeInfo.get(javaClass.getQualifiedName());
            if (info != null) {
                typeName = info.isComplexType() ? info.getComplexType().getName() : (info.getSimpleType() != null ? info.getSimpleType().getName() : info.getSchemaTypeName());
                if (typeName == null) {
                    if (!info.hasRootElement()) {
                        if (info.isComplexType()) {
                            element.setComplexType(info.getComplexType());
                        } else {
                            element.setSimpleType(info.getSimpleType());
                        }
                    }
                } else if (this.addImportIfRequired(schema, info.getSchema(), info.getClassNamespace()) && (prefix = schema.getNamespaceResolver().resolveNamespaceURI(info.getClassNamespace())) != null && !typeName.equals(EMPTY_STRING)) {
                    typeName = prefix + COLON + typeName;
                }
            } else if (!property.isMap()) {
                typeName = this.getTypeName(property, javaClass, schema);
            }
            if (typeName != null && !typeName.contains(COLON) && (prefix = info.getClassNamespace().equals("http://www.w3.org/2001/XMLSchema") ? "xsd" : this.getPrefixForNamespace(schema, info.getClassNamespace())) != null) {
                typeName = prefix + COLON + typeName;
            }
        }
        return typeName;
    }

    class AddToSchemaResult {
        ComplexType type;
        TypeDefParticle particle;
        Schema schema;

        AddToSchemaResult(TypeDefParticle particle, Schema schema) {
            this.particle = particle;
            this.schema = schema;
        }

        AddToSchemaResult(TypeDefParticle particle, ComplexType type) {
            this.particle = particle;
            this.type = type;
        }
    }
}

