/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.dbws.oracle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.structures.ArrayMapping;
import org.eclipse.persistence.mappings.structures.ObjectArrayMapping;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDataTypeDescriptor;
import org.eclipse.persistence.mappings.structures.StructureMapping;
import org.eclipse.persistence.platform.database.oracle.publisher.visit.PublisherDefaultListener;

public class PLSQLORDescriptorBuilder
extends PublisherDefaultListener {
    public static final String ITEMS_MAPPING_ATTRIBUTE_NAME = "items";
    public static final String ITEMS_MAPPING_FIELD_NAME = "ITEMS";
    protected Stack<PublisherDefaultListener.ListenerHelper> stac = new Stack();
    protected Map<String, ObjectRelationalDataTypeDescriptor> descriptorMap = new HashMap<String, ObjectRelationalDataTypeDescriptor>();
    protected String packageName = null;

    public List<ObjectRelationalDataTypeDescriptor> getDescriptors() {
        if (this.descriptorMap.isEmpty()) {
            return null;
        }
        ArrayList<ObjectRelationalDataTypeDescriptor> al = new ArrayList<ObjectRelationalDataTypeDescriptor>();
        al.addAll(this.descriptorMap.values());
        return al;
    }

    @Override
    public void beginPackage(String packageName) {
        int dotIdx = packageName.indexOf(46);
        if (dotIdx > -1) {
            this.packageName = packageName.substring(dotIdx + 1);
        }
    }

    @Override
    public void beginPlsqlTable(String tableName, String targetTypeName) {
        PublisherDefaultListener.TableHelper tableHelper = new PublisherDefaultListener.TableHelper(tableName, targetTypeName.toLowerCase(), targetTypeName);
        this.stac.push(tableHelper);
    }

    @Override
    public void endPlsqlTable(String tableName, String typeDDL, String typeDropDDL) {
        boolean itemsMappingFound;
        PublisherDefaultListener.ListenerHelper top = this.stac.pop();
        PublisherDefaultListener.TableHelper tableHelper = (PublisherDefaultListener.TableHelper)this.stac.peek();
        String tableAlias = tableHelper.targetTypeName().toLowerCase();
        ObjectRelationalDataTypeDescriptor ordt = this.descriptorMap.get(tableAlias);
        if (ordt == null) {
            ordt = new ObjectRelationalDataTypeDescriptor();
            ordt.descriptorIsAggregate();
            ordt.setAlias(tableHelper.tableAlias());
            ordt.setJavaClassName(tableName.toLowerCase() + "_CollectionWrapper");
            ordt.getQueryManager();
        }
        boolean bl = itemsMappingFound = ordt.getMappingForAttributeName(ITEMS_MAPPING_ATTRIBUTE_NAME) != null;
        if (top.isRecord()) {
            if (!itemsMappingFound) {
                ObjectArrayMapping itemsMapping = new ObjectArrayMapping();
                itemsMapping.setAttributeName(ITEMS_MAPPING_ATTRIBUTE_NAME);
                itemsMapping.setFieldName(ITEMS_MAPPING_FIELD_NAME);
                itemsMapping.setStructureName(tableHelper.targetTypeName());
                itemsMapping.setReferenceClassName(((PublisherDefaultListener.RecordHelper)top).recordName().toLowerCase());
                ordt.addMapping((DatabaseMapping)itemsMapping);
            }
            tableHelper.nestedIsComplex();
        } else {
            if (!itemsMappingFound) {
                ArrayMapping itemsMapping = new ArrayMapping();
                itemsMapping.setAttributeName(ITEMS_MAPPING_ATTRIBUTE_NAME);
                itemsMapping.setFieldName(ITEMS_MAPPING_FIELD_NAME);
                itemsMapping.useCollectionClass(ArrayList.class);
                itemsMapping.setStructureName(tableHelper.targetTypeName());
                ordt.addMapping((DatabaseMapping)itemsMapping);
            }
            if (top.isTable()) {
                tableHelper.nestedIsComplex();
            }
        }
        if (!itemsMappingFound) {
            this.descriptorMap.put(tableAlias, ordt);
        }
    }

    @Override
    public void beginPlsqlRecord(String plsqlRecordName, String targetTypeName, int numFields) {
        PublisherDefaultListener.RecordHelper recordHelper = new PublisherDefaultListener.RecordHelper(plsqlRecordName, targetTypeName, numFields);
        this.stac.push(recordHelper);
        String recordAlias = targetTypeName.toLowerCase();
        ObjectRelationalDataTypeDescriptor ordt = this.descriptorMap.get(recordAlias);
        if (ordt == null) {
            ordt = new ObjectRelationalDataTypeDescriptor();
            ordt.descriptorIsAggregate();
            ordt.setAlias(recordAlias);
            ordt.setJavaClassName(plsqlRecordName.toLowerCase());
            ordt.getQueryManager();
            ordt.setStructureName(targetTypeName);
            this.descriptorMap.put(recordAlias, ordt);
        }
    }

    @Override
    public void beginPlsqlRecordField(String fieldName, int idx) {
        PublisherDefaultListener.RecordHelper recordHelper = (PublisherDefaultListener.RecordHelper)this.stac.peek();
        ObjectRelationalDataTypeDescriptor ordt = this.descriptorMap.get(recordHelper.targetTypeName().toLowerCase());
        String lFieldName = fieldName.toLowerCase();
        boolean found = false;
        Vector orderedFields = ordt.getOrderedFields();
        for (Object o : orderedFields) {
            DatabaseField field;
            if (!(o instanceof DatabaseField) || !(field = (DatabaseField)o).getName().equals(lFieldName)) continue;
            found = true;
            break;
        }
        if (!found) {
            ordt.addFieldOrdering(lFieldName);
        }
    }

    @Override
    public void endPlsqlRecordField(String fieldName, int idx) {
        PublisherDefaultListener.ListenerHelper top = this.stac.pop();
        PublisherDefaultListener.ListenerHelper listenerHelper = this.stac.peek();
        if (listenerHelper.isRecord()) {
            String lFieldName;
            PublisherDefaultListener.RecordHelper recordHelper = (PublisherDefaultListener.RecordHelper)this.stac.peek();
            ObjectRelationalDataTypeDescriptor ordt = this.descriptorMap.get(recordHelper.targetTypeName().toLowerCase());
            if (ordt.getMappingForAttributeName(lFieldName = fieldName.toLowerCase()) == null) {
                if (top.isComplex()) {
                    if (top.isTable()) {
                        if (((PublisherDefaultListener.TableHelper)top).isNestedComplex()) {
                            ObjectArrayMapping objectArrayMapping = new ObjectArrayMapping();
                            objectArrayMapping.setAttributeName(lFieldName);
                            objectArrayMapping.setFieldName(lFieldName);
                            objectArrayMapping.setStructureName(top.targetTypeName());
                            objectArrayMapping.setReferenceClassName(((PublisherDefaultListener.TableHelper)top).tableName().toLowerCase() + "_CollectionWrapper");
                            ordt.addMapping((DatabaseMapping)objectArrayMapping);
                        } else {
                            ArrayMapping arrayMapping = new ArrayMapping();
                            arrayMapping.setAttributeName(lFieldName);
                            arrayMapping.setFieldName(lFieldName);
                            arrayMapping.setStructureName(top.targetTypeName());
                            ordt.addMapping((DatabaseMapping)arrayMapping);
                        }
                    } else if (top.isRecord()) {
                        StructureMapping structureMapping = new StructureMapping();
                        structureMapping.setAttributeName(lFieldName);
                        structureMapping.setFieldName(lFieldName);
                        structureMapping.setReferenceClassName(((PublisherDefaultListener.RecordHelper)top).recordName().toLowerCase());
                        ordt.addMapping((DatabaseMapping)structureMapping);
                    }
                } else {
                    ordt.addDirectMapping(lFieldName, lFieldName);
                }
            }
        } else {
            System.identityHashCode(listenerHelper);
        }
    }

    @Override
    public void endPlsqlRecord(String recordName, String typeDDL, String typeDropDDL) {
    }

    @Override
    public void endMethodArg(String argName) {
        this.stac.pop();
    }

    @Override
    public void handleSqlType(String sqlTypeName, int typecode, String targetType) {
        this.stac.push(new PublisherDefaultListener.SqltypeHelper(sqlTypeName));
    }

    @Override
    public void handleObjectType(String objectTypename, String targetTypeName, int numAttributes) {
        this.stac.push(new PublisherDefaultListener.ObjectTypeHelper(objectTypename, targetTypeName, numAttributes));
    }
}

