/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.internal.jpql;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.persistence.jpa.internal.jpql.AbstractVisitor;
import org.eclipse.persistence.jpa.internal.jpql.DeclarationResolver;
import org.eclipse.persistence.jpa.internal.jpql.DefaultContentAssistProposals;
import org.eclipse.persistence.jpa.internal.jpql.JPQLQueryContext;
import org.eclipse.persistence.jpa.internal.jpql.LiteralType;
import org.eclipse.persistence.jpa.internal.jpql.Resolver;
import org.eclipse.persistence.jpa.internal.jpql.SingleValuedObjectFieldResolver;
import org.eclipse.persistence.jpa.internal.jpql.WordParser;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbsExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractConditionalClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractDoubleEncapsulatedExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractEncapsulatedExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractFromClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractPathExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractSchemaName;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractSelectClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractSelectStatement;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractSingleEncapsulatedExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractTraverseChildrenVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractTraverseParentVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractTripleEncapsulatedExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.AdditionExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.AggregateFunction;
import org.eclipse.persistence.jpa.internal.jpql.parser.AllOrAnyExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.AndExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.AnonymousExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.ArithmeticExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ArithmeticFactor;
import org.eclipse.persistence.jpa.internal.jpql.parser.AvgFunction;
import org.eclipse.persistence.jpa.internal.jpql.parser.BadExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.BetweenExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.CaseExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.CoalesceExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.CollectionMemberDeclaration;
import org.eclipse.persistence.jpa.internal.jpql.parser.CollectionMemberExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.CollectionValuedPathExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ComparisonExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ConcatExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ConstructorExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.CountFunction;
import org.eclipse.persistence.jpa.internal.jpql.parser.DateTime;
import org.eclipse.persistence.jpa.internal.jpql.parser.DeleteClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.DeleteStatement;
import org.eclipse.persistence.jpa.internal.jpql.parser.DivisionExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.EmptyCollectionComparisonExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.EncapsulatedIdentificationVariableExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.EntityTypeLiteral;
import org.eclipse.persistence.jpa.internal.jpql.parser.EntryExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ExistsExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.Expression;
import org.eclipse.persistence.jpa.internal.jpql.parser.FromClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.FuncExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.GroupByClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.HavingClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.IdentificationVariable;
import org.eclipse.persistence.jpa.internal.jpql.parser.IdentificationVariableDeclaration;
import org.eclipse.persistence.jpa.internal.jpql.parser.IdentifierRole;
import org.eclipse.persistence.jpa.internal.jpql.parser.InExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.IndexExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.InputParameter;
import org.eclipse.persistence.jpa.internal.jpql.parser.JPQLExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.Join;
import org.eclipse.persistence.jpa.internal.jpql.parser.JoinFetch;
import org.eclipse.persistence.jpa.internal.jpql.parser.KeyExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.KeywordExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.LengthExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.LikeExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.LocateExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.LogicalExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.LowerExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.MaxFunction;
import org.eclipse.persistence.jpa.internal.jpql.parser.MinFunction;
import org.eclipse.persistence.jpa.internal.jpql.parser.ModExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.MultiplicationExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.NotExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.NullComparisonExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.NullExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.NullIfExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.NumericLiteral;
import org.eclipse.persistence.jpa.internal.jpql.parser.ObjectExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.OrExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.OrderByClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.OrderByItem;
import org.eclipse.persistence.jpa.internal.jpql.parser.QueryPosition;
import org.eclipse.persistence.jpa.internal.jpql.parser.RangeVariableDeclaration;
import org.eclipse.persistence.jpa.internal.jpql.parser.ResultVariable;
import org.eclipse.persistence.jpa.internal.jpql.parser.SelectClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.SelectStatement;
import org.eclipse.persistence.jpa.internal.jpql.parser.SimpleFromClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.SimpleSelectClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.SimpleSelectStatement;
import org.eclipse.persistence.jpa.internal.jpql.parser.SizeExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.SqrtExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.StateFieldPathExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.StringLiteral;
import org.eclipse.persistence.jpa.internal.jpql.parser.SubExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.SubstringExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.SubtractionExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.SumFunction;
import org.eclipse.persistence.jpa.internal.jpql.parser.TreatExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.TrimExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.TypeExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.UnknownExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.UpdateClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.UpdateItem;
import org.eclipse.persistence.jpa.internal.jpql.parser.UpdateStatement;
import org.eclipse.persistence.jpa.internal.jpql.parser.UpperExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ValueExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.WhenClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.WhereClause;
import org.eclipse.persistence.jpa.internal.jpql.util.AndFilter;
import org.eclipse.persistence.jpa.internal.jpql.util.Filter;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.persistence.jpa.jpql.MappingTypeHelper;
import org.eclipse.persistence.jpa.jpql.spi.IEntity;
import org.eclipse.persistence.jpa.jpql.spi.IJPAVersion;
import org.eclipse.persistence.jpa.jpql.spi.IManagedType;
import org.eclipse.persistence.jpa.jpql.spi.IMapping;
import org.eclipse.persistence.jpa.jpql.spi.IType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentAssistVisitor
extends AbstractVisitor {
    private Stack<Integer> corrections;
    private Map<Class<?>, Object> helpers;
    private Stack<Expression> lockedExpressions;
    private Stack<Integer> positionInCollections;
    private DefaultContentAssistProposals proposals;
    private QueryPosition queryPosition;
    private Stack<Integer> virtualSpaces;
    private String word;
    private WordParser wordParser;
    private static final int SPACE_LENGTH = 1;

    public ContentAssistVisitor(JPQLQueryContext queryContext) {
        super(queryContext);
    }

    private Iterable<IEntity> abstractSchemaTypes() {
        return this.getProvider().abstractSchemaTypes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IType acceptableType(Expression expression) {
        AcceptableTypeVisitor visitor = this.expressionTypeVisitor();
        try {
            expression.accept(visitor);
            IType iType = visitor.type;
            return iType;
        }
        finally {
            visitor.type = null;
        }
    }

    private void addAbstractSchemaTypes() {
        for (IEntity abstractSchemaType : this.abstractSchemaTypes()) {
            if (!this.isValidProposal(abstractSchemaType.getName(), this.word)) continue;
            this.proposals.addAbstractSchemaType(abstractSchemaType);
        }
    }

    private void addAbstractSchemaTypes(IType type) {
        for (IEntity abstractSchemaType : this.abstractSchemaTypes()) {
            if (!this.isValidProposal(abstractSchemaType.getName(), this.word) || !type.isAssignableTo(abstractSchemaType.getType())) continue;
            this.proposals.addAbstractSchemaType(abstractSchemaType);
        }
    }

    private void addAggregate(String identifier) {
        if (this.isAggregate(identifier)) {
            this.addProposal(identifier);
        }
    }

    private void addAllAggregates(JPQLQueryBNF queryBNF) {
        for (String identifier : queryBNF.identifiers()) {
            this.addAggregate(identifier);
        }
    }

    private void addAllAggregates(String queryBNFId) {
        this.addAllAggregates((JPQLQueryBNF)AbstractExpression.queryBNF(queryBNFId));
    }

    private void addAllClauses(JPQLQueryBNF queryBNF) {
        for (String identifier : queryBNF.identifiers()) {
            this.addClause(identifier);
        }
    }

    private void addAllClauses(String queryBNF) {
        this.addAllClauses((JPQLQueryBNF)AbstractExpression.queryBNF(queryBNF));
    }

    private void addAllCompounds(JPQLQueryBNF queryBNF) {
        for (String identifier : queryBNF.identifiers()) {
            this.addCompound(identifier);
        }
    }

    private void addAllCompounds(String queryBNFId) {
        this.addAllCompounds((JPQLQueryBNF)AbstractExpression.queryBNF(queryBNFId));
    }

    private void addAllFunctions(JPQLQueryBNF queryBNF) {
        this.addAllFunctions(queryBNF, this.queryPosition.getPosition());
    }

    private void addAllFunctions(JPQLQueryBNF queryBNF, int position) {
        for (String identifier : queryBNF.identifiers()) {
            this.addFunction(identifier, position);
        }
    }

    private void addAllFunctions(String queryBNFId) {
        this.addAllFunctions((JPQLQueryBNF)AbstractExpression.queryBNF(queryBNFId), this.queryPosition.getPosition());
    }

    private void addAllIdentificationVariables(Expression expression) {
        this.addIdentificationVariables(IdentificationVariableType.ALL, expression);
    }

    private void addAllIdentifiers(JPQLQueryBNF queryBNF) {
        for (String identifier : queryBNF.identifiers()) {
            this.addProposal(identifier);
        }
    }

    private void addAllIdentifiers(String queryBNFId) {
        this.addAllIdentifiers((JPQLQueryBNF)AbstractExpression.queryBNF(queryBNFId));
    }

    private void addClause(String identifier) {
        if (this.isClause(identifier)) {
            this.addProposal(identifier);
        }
    }

    private void addCompound(String identifier) {
        if (this.isCompoundFunction(identifier)) {
            this.addIdentifier(identifier, this.queryPosition.getPosition());
        }
    }

    private void addFunction(String identifier, int position) {
        if (this.isFunction(identifier)) {
            this.addIdentifier(identifier, position);
        }
    }

    private void addIdentificationVariable(String identificationVariable) {
        if (ExpressionTools.stringIsNotEmpty(identificationVariable) && this.isValidProposal(identificationVariable, this.word)) {
            this.proposals.addIdentificationVariable(identificationVariable);
        }
    }

    private void addIdentificationVariables(IdentificationVariableType type, Expression expression) {
        block23: {
            block24: {
                if (type != IdentificationVariableType.RESULT_VARIABLE) break block24;
                for (String resultVariable : this.queryContext.getResultVariables()) {
                    this.addProposal(resultVariable);
                }
                break block23;
            }
            if (type == IdentificationVariableType.NONE) break block23;
            boolean stop = false;
            block7: for (DeclarationResolver.Declaration declaration : this.queryContext.getDeclarations()) {
                if (!stop) {
                    block0 : switch (type) {
                        case ALL: {
                            if (declaration.rangeDeclaration) {
                                this.addRangeIdentificationVariable(declaration.getVariableName());
                            } else {
                                this.addIdentificationVariable(declaration.getVariableName());
                            }
                            for (String joinIdentificationVariable : declaration.getJoinIdentificationVariables()) {
                                this.addIdentificationVariable(joinIdentificationVariable);
                            }
                            continue block7;
                        }
                        case COLLECTION: {
                            if (declaration.rangeDeclaration) break;
                            this.addIdentificationVariable(declaration.getVariableName());
                            for (String joinIdentificationVariable : declaration.getJoinIdentificationVariables()) {
                                this.addIdentificationVariable(joinIdentificationVariable);
                            }
                            continue block7;
                        }
                        case LEFT: {
                            boolean shouldStop = declaration.declarationExpression.isAncestor(expression);
                            if (shouldStop && !declaration.getJoins().contains(expression) && !declaration.getJoinFetches().contains(expression)) {
                                stop = true;
                                break;
                            }
                            if (declaration.rangeDeclaration) {
                                this.addRangeIdentificationVariable(declaration.getVariableName());
                            } else if (!shouldStop) {
                                this.addIdentificationVariable(declaration.getVariableName());
                            }
                            for (Map.Entry<Join, String> join : declaration.getJoinEntries()) {
                                if (join.getKey().isAncestor(expression)) {
                                    stop = true;
                                    break block0;
                                }
                                this.addIdentificationVariable(join.getValue());
                            }
                            continue block7;
                        }
                        case LEFT_COLLECTION: {
                            boolean shouldStop = declaration.declarationExpression.isAncestor(expression);
                            if (shouldStop && declaration.getJoins().contains(expression) && declaration.getJoinFetches().contains(expression)) {
                                stop = true;
                                break;
                            }
                            if (!shouldStop && !declaration.rangeDeclaration) {
                                this.addIdentificationVariable(declaration.getVariableName());
                                break;
                            }
                            for (Map.Entry<Join, String> join : declaration.getJoinEntries()) {
                                if (join.getKey().isAncestor(expression)) {
                                    stop = true;
                                    break block0;
                                }
                                this.addIdentificationVariable(join.getValue());
                            }
                            continue block7;
                        }
                    }
                    continue;
                }
                break;
            }
        }
    }

    private void addIdentifier(String identifier, int position) {
        boolean found = this.addIdentifier(identifier, position -= this.word.length(), "IS NOT ", 2);
        if (!found && !(found = this.addIdentifier(identifier, position, "NOT ", 3)) && this.isValidProposal(identifier, this.word) && this.isValidVersion(identifier)) {
            this.proposals.addIdentifier(identifier);
        }
    }

    private boolean addIdentifier(String identifier, int position, String partialEnding, int endIndex) {
        for (int index = partialEnding.length(); index > endIndex; --index) {
            String partial = partialEnding.substring(0, index);
            if (!this.wordParser.endsWith(position, partial)) continue;
            this.addProposal(identifier, partial + this.word);
            return true;
        }
        return false;
    }

    private void addJoinIdentifiers() {
        this.proposals.addIdentifier("INNER JOIN");
        this.proposals.addIdentifier("INNER JOIN FETCH");
        this.proposals.addIdentifier("JOIN");
        this.proposals.addIdentifier("JOIN FETCH");
        this.proposals.addIdentifier("LEFT JOIN");
        this.proposals.addIdentifier("LEFT JOIN FETCH");
        this.proposals.addIdentifier("LEFT OUTER JOIN");
        this.proposals.addIdentifier("LEFT OUTER JOIN FETCH");
    }

    private void addLeftIdentificationVariables(Expression expression) {
        this.addIdentificationVariables(IdentificationVariableType.LEFT, expression);
    }

    private void addProposal(String proposal) {
        this.addProposal(proposal, this.word);
    }

    private void addProposal(String identifier, String word) {
        if (this.isValidProposal(identifier, word) && this.isValidVersion(identifier)) {
            this.proposals.addIdentifier(identifier);
        }
    }

    private void addRangeIdentificationVariable(String identificationVariable) {
        if (ExpressionTools.stringIsNotEmpty(identificationVariable) && this.isValidProposal(identificationVariable, this.word)) {
            Resolver resolver = this.queryContext.getResolver(identificationVariable);
            IEntity entity = this.entity(resolver.getManagedType());
            if (entity != null) {
                this.proposals.addRangeIdentificationVariable(identificationVariable, entity);
            } else {
                this.proposals.addIdentificationVariable(identificationVariable);
            }
        }
    }

    private void addResultVariables(Expression expression) {
        this.addIdentificationVariables(IdentificationVariableType.RESULT_VARIABLE, expression);
    }

    private void addScalarExpressionProposals(Expression expression) {
        this.addAllIdentificationVariables(expression);
        this.addAbstractSchemaTypes();
        this.addAllFunctions("scalar_expression");
    }

    private void addSelectExpressionProposals(AbstractSelectClause expression, int length) {
        int position = this.position(expression) - this.corrections.peek();
        CollectionExpression collectionExpression = this.collectionExpression(expression.getSelectExpression());
        if (collectionExpression != null) {
            int count = collectionExpression.childrenSize();
            for (int index = 0; index < count; ++index) {
                Expression child = collectionExpression.getChild(index);
                if (position == length) {
                    this.addAllIdentificationVariables(expression);
                    this.addAllFunctions("select_item");
                    break;
                }
                boolean withinChild = this.addSelectExpressionProposals(child, length, index, index + 1 == count);
                if (withinChild) break;
                length += this.length(child);
                if (!collectionExpression.hasComma(index)) break;
                if (position == ++length) {
                    this.addAllIdentificationVariables(expression);
                    this.addAllFunctions("select_item");
                    break;
                }
                if (!collectionExpression.hasSpace(index)) continue;
                ++length;
            }
        } else {
            this.addSelectExpressionProposals(expression.getSelectExpression(), length, 0, true);
        }
    }

    private boolean addSelectExpressionProposals(Expression expression, int length, int index, boolean last) {
        int position = this.position(expression) - this.corrections.peek();
        if (position > 0) {
            if (position == 0) {
                if (index == 0) {
                    this.addProposal("DISTINCT");
                }
                this.addAllIdentificationVariables(expression);
                this.addAllFunctions("select_item");
            } else {
                int childLength = this.length(expression);
                if ((position == length + childLength + this.virtualSpaces.peek() || position == childLength) && this.isSelectExpressionComplete(expression)) {
                    if (!this.isResultVariable(expression)) {
                        if (this.virtualSpaces.peek() > 0 || position == childLength) {
                            this.proposals.addIdentifier("AS");
                        }
                        this.addAllAggregates("select_item");
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private AppendableExpressionVisitor appendableExpressionVisitor() {
        return this.getHelper(AppendableExpressionVisitor.class);
    }

    private FilteringMappingCollector buildFilteringMappingCollector(AbstractPathExpression expression, Resolver resolver, Filter<IMapping> filter, String pattern) {
        return new FilteringMappingCollector(resolver, this.buildMappingFilter(expression, filter), pattern);
    }

    private Object buildHelper(Class<?> helperClass) {
        try {
            Constructor<?> constructor = helperClass.getDeclaredConstructor(ContentAssistVisitor.class);
            constructor.setAccessible(true);
            Object helper = constructor.newInstance(this);
            this.helpers.put(helperClass, helper);
            return helper;
        }
        catch (Exception e) {
            return null;
        }
    }

    private MappingCollector buildMappingCollector(AbstractPathExpression expression, Resolver resolver, Filter<IMapping> filter) {
        return this.buildFilteringMappingCollector(expression, resolver, filter, "");
    }

    private Filter<IMapping> buildMappingFilter(AbstractPathExpression expression, Filter<IMapping> filter) {
        IType type = this.acceptableType(expression.getParent());
        if (type == null) {
            return filter;
        }
        return new AndFilter<IMapping>(new MappingTypeFilter(type), filter);
    }

    private SelectStatementHelper<AbstractSelectStatement, Expression> cast(SelectStatementHelper<? extends AbstractSelectStatement, ? extends Expression> helper) {
        return helper;
    }

    private CompletenessVisitor completenessVisitor() {
        return this.getHelper(TrailingCompletenessVisitor.class);
    }

    private CompoundExpressionHelper compoundExpressionHelper() {
        return this.getHelper(CompoundExpressionHelper.class);
    }

    private CompletenessVisitor conditionalExpressionCompletenessVisitor() {
        return this.getHelper(ConditionalExpressionCompletenessVisitor.class);
    }

    private ConstrutorCollectionHelper constructorCollectionHelper() {
        return this.getHelper(ConstrutorCollectionHelper.class);
    }

    private MappingCollector defaultMappingCollector() {
        return this.getHelper(DefaultMappingCollector.class);
    }

    private ClauseHelper<DeleteClause> deleteClauseHelper() {
        return this.getHelper(DeleteClauseHelper.class);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.word = null;
        this.proposals = null;
        this.wordParser = null;
        this.queryPosition = null;
    }

    private DoubleEncapsulatedCollectionHelper doubleEncapsulatedCollectionHelper() {
        return this.getHelper(DoubleEncapsulatedCollectionHelper.class);
    }

    private AcceptableTypeVisitor expressionTypeVisitor() {
        return this.getHelper(AcceptableTypeVisitor.class);
    }

    private int findExpressionPosition(CollectionExpression expression) {
        int position;
        Expression leafExpression = this.queryPosition.getExpression();
        if (leafExpression != expression) {
            int count = expression.childrenSize();
            for (int index = 0; index < count; ++index) {
                Expression child = expression.getChild(index);
                if (!child.isAncestor(leafExpression)) continue;
                return index;
            }
        }
        if ((position = this.position(expression)) > -1) {
            int count = expression.childrenSize();
            for (int index = 0; index < count; ++index) {
                Expression child = expression.getChild(index);
                String text = child.toActualText();
                if (position <= text.length()) {
                    return index;
                }
                position -= text.length();
                if (expression.hasComma(index)) {
                    --position;
                }
                if (!expression.hasSpace(index)) continue;
                --position;
            }
        }
        if (position == 0 && (expression.endsWithComma() || expression.endsWithSpace())) {
            return expression.childrenSize();
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RangeVariableDeclaration findRangeVariableDeclaration(UpdateClause expression) {
        RangeVariableDeclarationVisitor visitor = this.rangeVariableDeclarationVisitor();
        try {
            expression.getRangeVariableDeclaration().accept(visitor);
            RangeVariableDeclaration rangeVariableDeclaration = visitor.expression;
            return rangeVariableDeclaration;
        }
        finally {
            visitor.expression = null;
        }
    }

    private FromClauseCollectionHelper fromClauseCollectionHelper() {
        return this.getHelper(FromClauseCollectionHelper.class);
    }

    private ClauseHelper<AbstractFromClause> fromClauseHelper() {
        return this.getHelper(FromClauseHelper.class);
    }

    private FromClauseSelectStatementHelper fromClauseSelectStatementHelper() {
        return this.getHelper(FromClauseSelectStatementHelper.class);
    }

    private <T> T getHelper(Class<T> helperClass) {
        Object helper = this.helpers.get(helperClass);
        if (helper == null) {
            helper = this.buildHelper(helperClass);
        }
        return (T)helper;
    }

    public DefaultContentAssistProposals getProposals() {
        return this.proposals;
    }

    private GroupByClauseCollectionHelper groupByClauseCollectionHelper() {
        return this.getHelper(GroupByClauseCollectionHelper.class);
    }

    private GroupByClauseSelectStatementHelper groupByClauseSelectStatementHelper() {
        return this.getHelper(GroupByClauseSelectStatementHelper.class);
    }

    private ClauseHelper<HavingClause> havingClauseHelper() {
        return this.getHelper(HavingClauseHelper.class);
    }

    private HavingClauseSelectStatementHelper havingClauseSelectStatementHelper() {
        return this.getHelper(HavingClauseSelectStatementHelper.class);
    }

    private CompletenessVisitor incompleteCollectionExpressionVisitor() {
        return this.getHelper(IncompleteCollectionExpressionVisitor.class);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.helpers = new HashMap();
        this.lockedExpressions = new Stack();
        this.virtualSpaces = new Stack();
        this.virtualSpaces.add(0);
        this.positionInCollections = new Stack();
        this.positionInCollections.add(-1);
        this.corrections = new Stack();
        this.corrections.add(0);
    }

    private boolean isAggregate(String proposal) {
        return AbstractExpression.identifierRole(proposal) == IdentifierRole.AGGREGATE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAppendable(Expression expression) {
        AppendableExpressionVisitor visitor = this.appendableExpressionVisitor();
        try {
            expression.accept(visitor);
            boolean bl = visitor.appendable;
            return bl;
        }
        finally {
            visitor.appendable = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAppendableToCollection(Expression expression) {
        CompletenessVisitor visitor = this.incompleteCollectionExpressionVisitor();
        try {
            expression.accept(visitor);
            boolean bl = visitor.complete;
            return bl;
        }
        finally {
            visitor.complete = false;
        }
    }

    private boolean isClause(String identifier) {
        return JPQLExpression.identifierRole(identifier) == IdentifierRole.CLAUSE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isComplete(Expression expression) {
        CompletenessVisitor visitor = this.completenessVisitor();
        try {
            expression.accept(visitor);
            boolean bl = visitor.complete;
            return bl;
        }
        finally {
            visitor.complete = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCompoundable(Expression expression) {
        CompoundExpressionHelper visitor = this.compoundExpressionHelper();
        try {
            expression.accept(visitor);
            boolean bl = visitor.isCompoundable();
            return bl;
        }
        finally {
            visitor.dispose();
        }
    }

    private boolean isCompoundFunction(String identifier) {
        if (identifier == "IS" || identifier == "OF") {
            return false;
        }
        return AbstractExpression.identifierRole(identifier) == IdentifierRole.COMPOUND_FUNCTION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isConditionalExpressionComplete(Expression expression) {
        CompletenessVisitor visitor = this.conditionalExpressionCompletenessVisitor();
        try {
            expression.accept(visitor);
            boolean bl = visitor.complete;
            return bl;
        }
        finally {
            visitor.complete = false;
        }
    }

    private boolean isFunction(String identifier) {
        return AbstractExpression.identifierRole(identifier) == IdentifierRole.FUNCTION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isGroupByComplete(Expression expression) {
        CompletenessVisitor visitor = this.completenessVisitor();
        try {
            expression.accept(visitor);
            boolean bl = visitor.complete;
            return bl;
        }
        finally {
            visitor.complete = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isInSubquery(Expression expression) {
        SubqueryVisitor visitor = this.subqueryVisitor();
        try {
            expression.accept(visitor);
            boolean bl = visitor.expression != null;
            return bl;
        }
        finally {
            visitor.expression = null;
        }
    }

    private boolean isLocked(Expression expression) {
        return !this.lockedExpressions.empty() && this.lockedExpressions.peek() == expression;
    }

    private boolean isPositionWithin(int position, int offset, String word) {
        return position >= offset && position - offset <= word.length();
    }

    private boolean isPositionWithin(int position, String word) {
        return this.isPositionWithin(position, 0, word);
    }

    private boolean isPreviousClauseComplete(AbstractSelectStatement expression, SelectStatementHelper<AbstractSelectStatement, Expression> helper) {
        if ((helper = this.cast(helper.getPreviousHelper())) == null || !helper.hasClause(expression)) {
            return false;
        }
        Expression clause = helper.getClause(expression);
        Expression clauseExpression = helper.getClauseExpression(clause);
        return helper.isClauseExpressionComplete(clauseExpression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isResultVariable(Expression expression) {
        ResultVariableVisitor visitor = this.resultVariableVisitor();
        try {
            expression.accept(visitor);
            boolean bl = visitor.expression != null;
            return bl;
        }
        finally {
            visitor.expression = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSelectExpressionComplete(Expression expression) {
        CompletenessVisitor visitor = this.selectClauseCompletenessVisitor();
        try {
            expression.accept(visitor);
            boolean bl = visitor.complete;
            return bl;
        }
        finally {
            visitor.complete = false;
        }
    }

    private boolean isValidProposal(String proposal, String word) {
        if (word.length() == 0) {
            return true;
        }
        char character = word.charAt(0);
        if (character == '+' || character == '-' || character == '*' || character == '/') {
            return true;
        }
        if (word.length() > proposal.length()) {
            return false;
        }
        int length = word.length();
        for (int index = 0; index < length; ++index) {
            char upperCase2;
            char character1 = proposal.charAt(index);
            char character2 = word.charAt(index);
            char upperCase1 = Character.toUpperCase(character1);
            if (upperCase1 != (upperCase2 = Character.toUpperCase(character2))) {
                return false;
            }
            if (Character.toLowerCase(upperCase1) == Character.toLowerCase(upperCase2)) continue;
            return false;
        }
        return true;
    }

    private boolean isValidVersion(String identifier) {
        IJPAVersion identifierVersion = JPQLExpression.identifierVersion(identifier);
        return this.getJPAVersion().isNewerThanOrEqual(identifierVersion);
    }

    private JoinCollectionHelper joinCollectionHelper() {
        return this.getHelper(JoinCollectionHelper.class);
    }

    private int length(Expression expression) {
        return expression.toActualText().length();
    }

    private Filter<IMapping> mappingCollectionFilter() {
        return this.getHelper(CollectionMappingFilter.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Filter<IMapping> mappingFilter(Expression expression) {
        MappingFilterBuilder visitor = this.mappingFilterBuilder();
        try {
            expression.accept(visitor);
            Filter<IMapping> filter = visitor.filter;
            return filter;
        }
        finally {
            visitor.filter = null;
        }
    }

    private MappingFilterBuilder mappingFilterBuilder() {
        return this.getHelper(MappingFilterBuilder.class);
    }

    private Filter<IMapping> mappingPropertyFilter() {
        return this.getHelper(PropertyMappingFilter.class);
    }

    private OrderByClauseCollectionHelper orderByClauseCollectionHelper() {
        return this.getHelper(OrderByClauseCollectionHelper.class);
    }

    private OrderByClauseSelectStatementHelper orderByClauseSelectStatementHelper() {
        return this.getHelper(OrderByClauseSelectStatementHelper.class);
    }

    private int position(Expression expression) {
        return this.queryPosition.getPosition(expression);
    }

    public void prepare(QueryPosition queryPosition) {
        this.queryPosition = queryPosition;
        this.proposals = new DefaultContentAssistProposals();
        this.wordParser = new WordParser(this.queryContext.getJPQLExpression().toActualText());
        this.wordParser.setPosition(queryPosition.getPosition());
        this.word = this.wordParser.partialWord();
    }

    private RangeVariableDeclarationVisitor rangeVariableDeclarationVisitor() {
        return this.getHelper(RangeVariableDeclarationVisitor.class);
    }

    private ResultVariableVisitor resultVariableVisitor() {
        return this.getHelper(ResultVariableVisitor.class);
    }

    private CompletenessVisitor selectClauseCompletenessVisitor() {
        return this.getHelper(SelectClauseCompletenessVisitor.class);
    }

    private SelectClauseSelectStatementHelper selectClauseSelectStatementHelper() {
        return this.getHelper(SelectClauseSelectStatementHelper.class);
    }

    private SimpleFromClauseSelectStatementHelper simpleFromClauseSelectStatementHelper() {
        return this.getHelper(SimpleFromClauseSelectStatementHelper.class);
    }

    private SimpleGroupByClauseSelectStatementHelper simpleGroupByClauseSelectStatementHelper() {
        return this.getHelper(SimpleGroupByClauseSelectStatementHelper.class);
    }

    private SimpleHavingClauseSelectStatementHelper simpleHavingClauseSelectStatementHelper() {
        return this.getHelper(SimpleHavingClauseSelectStatementHelper.class);
    }

    private SimpleSelectClauseSelectStatementHelper simpleSelectClauseSelectStatementHelper() {
        return this.getHelper(SimpleSelectClauseSelectStatementHelper.class);
    }

    private SimpleWhereClauseSelectStatementHelper simpleWhereClauseSelectStatementHelper() {
        return this.getHelper(SimpleWhereClauseSelectStatementHelper.class);
    }

    private SubqueryVisitor subqueryVisitor() {
        return this.getHelper(SubqueryVisitor.class);
    }

    private TripleEncapsulatedCollectionHelper tripleEncapsulatedCollectionHelper() {
        return this.getHelper(TripleEncapsulatedCollectionHelper.class);
    }

    private UpdateItemCollectionHelper updateItemCollectionHelper() {
        return this.getHelper(UpdateItemCollectionHelper.class);
    }

    @Override
    public void visit(AbsExpression expression) {
        super.visit(expression);
        this.visitSingleEncapsulatedExpression(expression, IdentificationVariableType.ALL);
    }

    @Override
    public void visit(AbstractSchemaName expression) {
        this.corrections.add(this.position(expression));
        super.visit(expression);
        this.corrections.pop();
        this.addAbstractSchemaTypes();
    }

    @Override
    public void visit(AdditionExpression expression) {
        super.visit(expression);
        this.visitArithmeticExpression(expression);
    }

    @Override
    public void visit(AllOrAnyExpression expression) {
        super.visit(expression);
        this.visitSingleEncapsulatedExpression(expression, IdentificationVariableType.NONE, "ALL", "ANY", "SOME");
    }

    @Override
    public void visit(AndExpression expression) {
        super.visit(expression);
        this.visitLogicalExpression(expression, "AND");
    }

    @Override
    public void visit(ArithmeticFactor expression) {
        super.visit(expression);
        int position = this.position(expression) - this.corrections.peek();
        if (position == 1) {
            this.addAllIdentificationVariables(expression);
            this.addAllFunctions(expression.getQueryBNF());
        }
    }

    @Override
    public void visit(AvgFunction expression) {
        super.visit(expression);
        this.visitAggregateFunction(expression);
    }

    @Override
    public void visit(BadExpression expression) {
        this.corrections.add(this.position(expression));
        super.visit(expression);
        this.corrections.pop();
    }

    @Override
    public void visit(BetweenExpression expression) {
        super.visit(expression);
        int position = this.position(expression) - this.corrections.peek();
        int length = 0;
        if (expression.hasExpression()) {
            length += this.length(expression.getExpression()) + 1;
        }
        if (expression.hasNot() && this.isPositionWithin(position, length, "NOT BETWEEN") || !expression.hasNot() && this.isPositionWithin(position, length, "BETWEEN")) {
            this.proposals.addIdentifier("BETWEEN");
            this.proposals.addIdentifier("NOT BETWEEN");
        } else if (expression.hasSpaceAfterBetween()) {
            if (position == (length += expression.getIdentifier().length() + 1)) {
                this.addAllIdentificationVariables(expression);
                this.addAllFunctions("internal_between_expression");
            }
            if (expression.hasLowerBoundExpression()) {
                int lowerBoundLength = this.length(expression.getLowerBoundExpression());
                if (!expression.hasAnd() && position > length && position < length + lowerBoundLength && this.isAppendableToCollection(expression.getLowerBoundExpression())) {
                    this.addProposal("AND");
                }
                length += lowerBoundLength;
                if (expression.hasSpaceAfterLowerBound()) {
                    if (position == ++length) {
                        this.proposals.addIdentifier("AND");
                    } else if (expression.hasAnd() && this.isPositionWithin(position, length, "AND")) {
                        this.proposals.addIdentifier("AND");
                    } else if (expression.hasSpaceAfterAnd()) {
                        if (position == (length += "AND".length() + 1)) {
                            this.addAllIdentificationVariables(expression);
                            this.addAllFunctions("internal_between_expression");
                        }
                    } else if (!expression.hasAnd() && expression.hasUpperBoundExpression() && position == (length += this.length(expression.getUpperBoundExpression()))) {
                        this.addProposal("AND");
                    }
                }
            }
        }
    }

    @Override
    public void visit(CaseExpression expression) {
        super.visit(expression);
        int position = this.position(expression) - this.corrections.peek();
        if (this.isPositionWithin(position, "CASE")) {
            if (this.isValidVersion("CASE")) {
                this.proposals.addIdentifier("CASE");
            }
        } else if (expression.hasSpaceAfterCase()) {
            int length = "CASE".length() + 1;
            if (position == length) {
                this.addAllIdentificationVariables(expression);
                this.addAllFunctions("case_operand");
                this.proposals.addIdentifier("WHEN");
            }
            if (expression.hasCaseOperand() && expression.hasSpaceAfterCaseOperand() && position == (length += this.length(expression.getCaseOperand()) + 1)) {
                this.proposals.addIdentifier("WHEN");
            }
            if (expression.hasWhenClauses() && expression.hasSpaceAfterWhenClauses()) {
                if (this.isPositionWithin(position, length += this.length(expression.getWhenClauses()) + 1, "ELSE")) {
                    this.proposals.addIdentifier("ELSE");
                }
                if (expression.hasElse() && expression.hasSpaceAfterElse()) {
                    if (position == (length += "ELSE".length() + 1)) {
                        this.addAllIdentificationVariables(expression);
                        this.addAllFunctions("case_operand");
                    }
                    if (expression.hasElseExpression() && expression.hasSpaceAfterElseExpression() && this.isPositionWithin(position, length += this.length(expression.getElseExpression()) + 1, "END")) {
                        this.proposals.addIdentifier("END");
                    }
                }
            }
        }
    }

    @Override
    public void visit(CoalesceExpression expression) {
        super.visit(expression);
        this.visitEncapsulatedExpression(expression, "COALESCE", expression.encapsulatedExpressionBNF());
    }

    @Override
    public void visit(CollectionExpression expression) {
        this.positionInCollections.add(this.findExpressionPosition(expression));
        super.visit(expression);
        this.positionInCollections.pop();
    }

    @Override
    public void visit(CollectionMemberDeclaration expression) {
        super.visit(expression);
        int position = this.position(expression) - this.corrections.peek();
        if (this.isPositionWithin(position, "IN")) {
            this.proposals.addIdentifier("IN");
        }
        if (this.isInSubquery(expression) && expression.hasSpaceAfterIn()) {
            int length = "IN".length() + 1;
            if (position == length) {
                this.addLeftIdentificationVariables(expression);
            }
        } else if (expression.hasLeftParenthesis()) {
            int length = "IN".length() + 1;
            if (position == length) {
                this.addLeftIdentificationVariables(expression);
                this.addAllFunctions("collection_valued_path_expression");
            }
            if (expression.hasRightParenthesis()) {
                if (position == (length += this.length(expression.getCollectionValuedPathExpression()) + 1) && !expression.hasSpaceAfterRightParenthesis()) {
                    this.proposals.addIdentifier("AS");
                }
                if (expression.hasSpaceAfterRightParenthesis()) {
                    ++length;
                }
                if (this.isPositionWithin(position, length, "AS")) {
                    this.proposals.addIdentifier("AS");
                }
            }
        }
    }

    @Override
    public void visit(CollectionMemberExpression expression) {
        super.visit(expression);
        int position = this.position(expression) - this.corrections.peek();
        String identifier = expression.getIdentifier();
        int length = 0;
        if (expression.hasEntityExpression()) {
            length = this.length(expression.getEntityExpression()) + 1;
        }
        if (this.isPositionWithin(position, length, identifier)) {
            this.proposals.addIdentifier("NOT MEMBER");
            this.proposals.addIdentifier("NOT MEMBER OF");
            this.proposals.addIdentifier("MEMBER");
            this.proposals.addIdentifier("MEMBER OF");
        } else if ((expression.hasOf() && expression.hasSpaceAfterOf() || !expression.hasOf() && expression.hasSpaceAfterMember()) && position == (length += identifier.length() + 1)) {
            if (!expression.hasOf()) {
                this.addProposal("OF");
            }
            this.addAllIdentificationVariables(expression);
        }
    }

    @Override
    public void visit(CollectionValuedPathExpression expression) {
        this.visitPathExpression(expression);
    }

    @Override
    public void visit(ComparisonExpression expression) {
        super.visit(expression);
        int position = this.position(expression) - this.corrections.peek();
        int length = 0;
        if (expression.hasLeftExpression()) {
            length += this.length(expression.getLeftExpression()) + 1;
        }
        if (this.isPositionWithin(position, length, expression.getComparisonOperator())) {
            this.proposals.addIdentifier("<");
            this.proposals.addIdentifier("<=");
            this.proposals.addIdentifier("<>");
            this.proposals.addIdentifier("=");
            this.proposals.addIdentifier(">");
            this.proposals.addIdentifier(">=");
        }
        length += expression.getComparisonOperator().length();
        if (expression.hasSpaceAfterIdentifier()) {
            ++length;
        }
        if (position == length) {
            this.addAllIdentificationVariables(expression);
            this.addAllFunctions(expression.rightExpressionBNF());
            this.addAllClauses(expression.rightExpressionBNF().getId());
        }
    }

    @Override
    public void visit(ConcatExpression expression) {
        super.visit(expression);
        this.visitSingleEncapsulatedExpression(expression, IdentificationVariableType.ALL);
    }

    @Override
    public void visit(ConstructorExpression expression) {
        super.visit(expression);
        int position = this.position(expression) - this.corrections.peek();
        if (this.isPositionWithin(position, "NEW")) {
            this.proposals.addIdentifier("NEW");
        } else if (expression.hasSpaceAfterNew()) {
            int length = "NEW".length() + 1;
            if (position == length) {
                // empty if block
            }
            if (expression.hasLeftParenthesis()) {
                String className = expression.getClassName();
                if (position == (length += className.length() + 1)) {
                    this.addAllIdentificationVariables(expression);
                    this.addAllFunctions("constructor_item");
                } else {
                    this.visitCollectionExpression(expression, "NEW", this.constructorCollectionHelper());
                }
            }
        }
    }

    @Override
    public void visit(CountFunction expression) {
        super.visit(expression);
        this.visitAggregateFunction(expression);
    }

    @Override
    public void visit(DateTime expression) {
        super.visit(expression);
        int position = this.position(expression) - this.corrections.peek();
        if (this.isPositionWithin(position, "CURRENT_DATE") || this.isPositionWithin(position, "CURRENT_TIME") || this.isPositionWithin(position, "CURRENT_TIMESTAMP")) {
            this.proposals.addIdentifier("CURRENT_DATE");
            this.proposals.addIdentifier("CURRENT_TIME");
            this.proposals.addIdentifier("CURRENT_TIMESTAMP");
        }
    }

    @Override
    public void visit(DeleteClause expression) {
        if (!this.isLocked(expression)) {
            super.visit(expression);
            this.visitClause(expression, "DELETE FROM", expression.hasSpaceAfterFrom(), this.deleteClauseHelper());
        }
    }

    @Override
    public void visit(DeleteStatement expression) {
        if (!this.isLocked(expression)) {
            super.visit(expression);
            this.visitDeleteStatement(expression);
        }
    }

    @Override
    public void visit(DivisionExpression expression) {
        super.visit(expression);
        this.visitArithmeticExpression(expression);
    }

    @Override
    public void visit(EmptyCollectionComparisonExpression expression) {
        super.visit(expression);
        int position = this.position(expression) - this.corrections.peek();
        int length = 0;
        if (expression.hasExpression()) {
            length = this.length(expression.getExpression()) + 1;
        }
        if (this.isPositionWithin(position, length, expression.getIdentifier())) {
            this.proposals.addIdentifier("IS EMPTY");
            this.proposals.addIdentifier("IS NOT EMPTY");
        }
    }

    @Override
    public void visit(EntityTypeLiteral expression) {
        this.corrections.add(this.position(expression));
        super.visit(expression);
        this.corrections.pop();
        this.addAbstractSchemaTypes();
    }

    @Override
    public void visit(EntryExpression expression) {
        super.visit(expression);
        this.visitSingleEncapsulatedExpression(expression, IdentificationVariableType.COLLECTION);
    }

    @Override
    public void visit(ExistsExpression expression) {
        super.visit(expression);
        this.visitSingleEncapsulatedExpression(expression, IdentificationVariableType.NONE, "EXISTS", "NOT EXISTS");
    }

    @Override
    protected void visit(Expression expression) {
        expression.getParent().accept(this);
    }

    @Override
    public void visit(FromClause expression) {
        if (!this.isLocked(expression)) {
            super.visit(expression);
            this.visitCollectionExpression(expression, "FROM", this.fromClauseCollectionHelper());
        }
    }

    @Override
    public void visit(FuncExpression expression) {
        super.visit(expression);
        this.visitSingleEncapsulatedExpression(expression, IdentificationVariableType.ALL);
    }

    @Override
    public void visit(GroupByClause expression) {
        if (!this.isLocked(expression)) {
            super.visit(expression);
            this.visitCollectionExpression(expression, "GROUP BY", this.groupByClauseCollectionHelper());
        }
    }

    @Override
    public void visit(HavingClause expression) {
        if (!this.isLocked(expression)) {
            super.visit(expression);
            this.visitClause(expression, "HAVING", expression.hasSpaceAfterIdentifier(), this.havingClauseHelper());
            this.visitCompoundableExpression(expression);
        }
    }

    @Override
    public void visit(IdentificationVariable expression) {
        this.corrections.add(this.position(expression));
        super.visit(expression);
        this.corrections.pop();
    }

    @Override
    public void visit(IdentificationVariableDeclaration expression) {
        super.visit(expression);
        if (expression.hasSpace()) {
            int length;
            int position = this.position(expression) - this.corrections.peek();
            if (position == (length = this.length(expression.getRangeVariableDeclaration()) + 1)) {
                this.addJoinIdentifiers();
            } else {
                this.visitCollectionExpression(expression, "", this.joinCollectionHelper());
            }
        }
    }

    @Override
    public void visit(IndexExpression expression) {
        super.visit(expression);
        this.visitSingleEncapsulatedExpression(expression, IdentificationVariableType.ALL);
    }

    @Override
    public void visit(InExpression expression) {
        expression.accept(this.visitParentVisitor());
        int position = this.position(expression) - this.corrections.peek();
        int length = 0;
        if (expression.hasExpression()) {
            length += this.length(expression.getExpression()) + 1;
        }
        if (this.isPositionWithin(position, length, expression.getIdentifier())) {
            this.proposals.addIdentifier("IN");
            this.proposals.addIdentifier("NOT IN");
        } else if (expression.hasLeftParenthesis() && position == (length += expression.getIdentifier().length() + 1)) {
            this.addAllFunctions("in_item");
            this.proposals.addIdentifier("SELECT");
        }
    }

    @Override
    public void visit(InputParameter expression) {
        super.visit(expression);
    }

    @Override
    public void visit(Join expression) {
        super.visit(expression);
        int position = this.position(expression) - this.corrections.peek();
        String identifier = expression.getIdentifier();
        if (this.isPositionWithin(position, identifier)) {
            this.proposals.addIdentifier("JOIN");
            this.proposals.addIdentifier("INNER JOIN");
            this.proposals.addIdentifier("LEFT JOIN");
            this.proposals.addIdentifier("LEFT OUTER JOIN");
            if (!expression.hasAs() && !expression.hasIdentificationVariable()) {
                this.proposals.addIdentifier("JOIN FETCH");
                this.proposals.addIdentifier("INNER JOIN FETCH");
                this.proposals.addIdentifier("LEFT JOIN FETCH");
                this.proposals.addIdentifier("LEFT OUTER JOIN FETCH");
            }
        } else if (expression.hasSpaceAfterJoin()) {
            int length = identifier.length() + 1;
            if (position == length) {
                if (identifier == "LEFT") {
                    this.addProposal("LEFT JOIN");
                    this.addProposal("LEFT OUTER JOIN");
                    if (!expression.hasAs() && !expression.hasIdentificationVariable()) {
                        this.addProposal("LEFT JOIN FETCH");
                        this.addProposal("LEFT OUTER JOIN FETCH");
                    }
                } else if (identifier == "INNER") {
                    this.addProposal("INNER JOIN");
                    if (!expression.hasAs() && !expression.hasIdentificationVariable()) {
                        this.addProposal("INNER JOIN FETCH");
                    }
                } else if (identifier.equals("LEFT_OUTER")) {
                    this.addProposal("LEFT OUTER JOIN");
                    if (!expression.hasAs() && !expression.hasIdentificationVariable()) {
                        this.addProposal("LEFT OUTER JOIN FETCH");
                    }
                } else {
                    this.addLeftIdentificationVariables(expression);
                }
            }
            if (expression.hasJoinAssociationPath() && expression.hasSpaceAfterJoinAssociation() && this.isPositionWithin(position, length += this.length(expression.getJoinAssociationPath()) + 1, "AS")) {
                this.addProposal("AS");
            }
        }
    }

    @Override
    public void visit(JoinFetch expression) {
        int length;
        super.visit(expression);
        int position = this.position(expression) - this.corrections.peek();
        String identifier = expression.getIdentifier();
        if (this.isPositionWithin(position, identifier)) {
            this.addJoinIdentifiers();
        } else if (expression.hasSpaceAfterFetch() && position == (length = identifier.length() + 1)) {
            this.addLeftIdentificationVariables(expression);
        }
    }

    @Override
    public void visit(JPQLExpression expression) {
        if (!this.isLocked(expression)) {
            int length;
            int position = this.position(expression);
            boolean hasQueryStatement = expression.hasQueryStatement();
            int n = length = hasQueryStatement ? this.length(expression.getQueryStatement()) : 0;
            if (position == 0) {
                this.addProposal("SELECT");
                this.addProposal("UPDATE");
                this.addProposal("DELETE FROM");
            } else if (position > length) {
                String text = expression.getUnknownEndingStatement().toActualText();
                this.addProposal("SELECT", text);
                this.addProposal("DELETE FROM", text);
                this.addProposal("UPDATE", text);
                if (hasQueryStatement) {
                    this.lockedExpressions.add(expression);
                    this.corrections.add(-length - 1);
                    expression.getQueryStatement().accept(this);
                    this.corrections.pop();
                    this.lockedExpressions.pop();
                }
            }
        }
    }

    @Override
    public void visit(KeyExpression expression) {
        super.visit(expression);
        this.visitSingleEncapsulatedExpression(expression, IdentificationVariableType.LEFT_COLLECTION);
    }

    @Override
    public void visit(KeywordExpression expression) {
        this.corrections.add(this.position(expression));
        super.visit(expression);
        this.corrections.pop();
        int position = this.position(expression) - this.corrections.peek();
        if (this.isPositionWithin(position, "TRUE") || this.isPositionWithin(position, "FALSE") || this.isPositionWithin(position, "NULL")) {
            this.proposals.addIdentifier("TRUE");
            this.proposals.addIdentifier("FALSE");
            this.proposals.addIdentifier("NULL");
        }
    }

    @Override
    public void visit(LengthExpression expression) {
        super.visit(expression);
        this.visitSingleEncapsulatedExpression(expression, IdentificationVariableType.ALL);
    }

    @Override
    public void visit(LikeExpression expression) {
        super.visit(expression);
        int position = this.position(expression) - this.corrections.peek();
        int length = 0;
        if (expression.hasStringExpression()) {
            length += this.length(expression.getStringExpression()) + 1;
        }
        if (this.isPositionWithin(position, length, expression.getIdentifier())) {
            this.proposals.addIdentifier("LIKE");
            this.proposals.addIdentifier("NOT LIKE");
        } else if (expression.hasSpaceAfterLike()) {
            length += expression.getIdentifier().length() + 1;
            if (expression.hasPatternValue() && expression.hasSpaceAfterPatternValue() && this.isPositionWithin(position, length += this.length(expression.getPatternValue()) + 1, "ESCAPE")) {
                this.proposals.addIdentifier("ESCAPE");
            }
        }
    }

    @Override
    public void visit(LocateExpression expression) {
        super.visit(expression);
        this.visitCollectionExpression(expression, "LOCATE", this.tripleEncapsulatedCollectionHelper());
    }

    @Override
    public void visit(LowerExpression expression) {
        super.visit(expression);
        this.visitSingleEncapsulatedExpression(expression, IdentificationVariableType.ALL);
    }

    @Override
    public void visit(MaxFunction expression) {
        super.visit(expression);
        this.visitAggregateFunction(expression);
    }

    @Override
    public void visit(MinFunction expression) {
        super.visit(expression);
        this.visitAggregateFunction(expression);
    }

    @Override
    public void visit(ModExpression expression) {
        super.visit(expression);
        this.visitCollectionExpression(expression, "MOD", this.doubleEncapsulatedCollectionHelper());
    }

    @Override
    public void visit(MultiplicationExpression expression) {
        super.visit(expression);
        this.visitArithmeticExpression(expression);
    }

    @Override
    public void visit(NotExpression expression) {
        int length;
        super.visit(expression);
        int position = this.position(expression) - this.corrections.peek();
        if (this.isPositionWithin(position, "NOT")) {
            this.proposals.addIdentifier("NOT");
            if (!expression.hasExpression()) {
                int currentPosition = this.queryPosition.getPosition();
                this.addIdentifier("NOT BETWEEN", currentPosition);
                this.addIdentifier("NOT EXISTS", currentPosition);
                this.addIdentifier("NOT IN", currentPosition);
                this.addIdentifier("NOT LIKE", currentPosition);
                this.addIdentifier("NOT MEMBER", currentPosition);
                this.addIdentifier("NOT MEMBER OF", currentPosition);
                this.addIdentifier("IS NOT EMPTY", currentPosition);
                this.addIdentifier("IS NOT NULL", currentPosition);
            }
        } else if (expression.hasSpaceAfterNot() && position == (length = "NOT".length() + 1)) {
            boolean canAddCompoundIdentifiers;
            boolean bl = canAddCompoundIdentifiers = !expression.hasExpression();
            if (!canAddCompoundIdentifiers) {
                String variableName = this.queryContext.literal(expression.getExpression(), LiteralType.IDENTIFICATION_VARIABLE);
                canAddCompoundIdentifiers = ExpressionTools.stringIsNotEmpty(variableName);
            }
            if (canAddCompoundIdentifiers) {
                int currentPosition = this.queryPosition.getPosition();
                this.addIdentifier("NOT BETWEEN", currentPosition);
                this.addIdentifier("NOT EXISTS", currentPosition);
                this.addIdentifier("NOT IN", currentPosition);
                this.addIdentifier("NOT LIKE", currentPosition);
                this.addIdentifier("NOT MEMBER", currentPosition);
                this.addIdentifier("NOT MEMBER OF", currentPosition);
                this.addIdentifier("IS NOT EMPTY", currentPosition);
                this.addIdentifier("IS NOT NULL", currentPosition);
            }
        }
    }

    @Override
    public void visit(NullComparisonExpression expression) {
        super.visit(expression);
        int position = this.position(expression) - this.corrections.peek();
        int length = 0;
        if (expression.hasExpression()) {
            length += this.length(expression.getExpression()) + 1;
        }
        if (this.isPositionWithin(position, length, expression.getIdentifier())) {
            this.proposals.addIdentifier("IS NULL");
            this.proposals.addIdentifier("IS NOT NULL");
        }
    }

    @Override
    public void visit(NullExpression expression) {
        super.visit(expression);
    }

    @Override
    public void visit(NullIfExpression expression) {
        super.visit(expression);
        this.visitCollectionExpression(expression, "NULLIF", this.doubleEncapsulatedCollectionHelper());
    }

    @Override
    public void visit(NumericLiteral expression) {
        super.visit(expression);
    }

    @Override
    public void visit(ObjectExpression expression) {
        super.visit(expression);
        this.visitSingleEncapsulatedExpression(expression, IdentificationVariableType.ALL);
    }

    @Override
    public void visit(OrderByClause expression) {
        if (!this.isLocked(expression)) {
            super.visit(expression);
            this.visitCollectionExpression(expression, "ORDER BY", this.orderByClauseCollectionHelper());
        }
    }

    @Override
    public void visit(OrderByItem expression) {
        super.visit(expression);
        int position = this.position(expression) - this.corrections.peek();
        if (expression.hasExpression()) {
            int length = this.length(expression.getExpression());
            if (expression.hasSpaceAfterExpression()) {
                if (position == ++length) {
                    this.proposals.addIdentifier("ASC");
                    this.proposals.addIdentifier("DESC");
                } else {
                    OrderByItem.Ordering ordering = expression.getOrdering();
                    if (ordering != OrderByItem.Ordering.DEFAULT && this.isPositionWithin(position, length, ordering.name())) {
                        this.proposals.addIdentifier("ASC");
                        this.proposals.addIdentifier("DESC");
                    }
                }
            }
        }
    }

    @Override
    public void visit(OrExpression expression) {
        super.visit(expression);
        this.visitLogicalExpression(expression, "OR");
    }

    @Override
    public void visit(RangeVariableDeclaration expression) {
        int length;
        super.visit(expression);
        int position = this.position(expression) - this.corrections.peek();
        if (expression.hasAbstractSchemaName() && expression.hasSpaceAfterAbstractSchemaName() && this.isPositionWithin(position, length = this.length(expression.getAbstractSchemaName()) + 1, "AS")) {
            this.addProposal("AS");
        }
    }

    @Override
    public void visit(ResultVariable expression) {
        super.visit(expression);
        int position = this.position(expression) - this.corrections.peek();
        int length = 0;
        if (expression.hasSelectExpression()) {
            length += this.length(expression.getSelectExpression()) + 1;
        }
        if (this.isPositionWithin(position, length, "AS")) {
            this.addProposal("AS");
        }
    }

    @Override
    public void visit(SelectClause expression) {
        if (!this.isLocked(expression)) {
            super.visit(expression);
            this.visitSelectClause(expression);
        }
    }

    @Override
    public void visit(SelectStatement expression) {
        if (!this.isLocked(expression)) {
            super.visit(expression);
            this.visitSelectStatement(expression, this.selectClauseSelectStatementHelper());
        }
    }

    @Override
    public void visit(SimpleFromClause expression) {
        if (!this.isLocked(expression)) {
            super.visit(expression);
            this.visitClause(expression, "FROM", expression.hasSpaceAfterFrom(), this.fromClauseHelper());
        }
    }

    @Override
    public void visit(SimpleSelectClause expression) {
        if (!this.isLocked(expression)) {
            super.visit(expression);
            this.visitSelectClause(expression);
        }
    }

    @Override
    public void visit(SimpleSelectStatement expression) {
        if (!this.isLocked(expression)) {
            this.visitSelectStatement(expression, this.simpleSelectClauseSelectStatementHelper());
        }
    }

    @Override
    public void visit(SizeExpression expression) {
        super.visit(expression);
        this.visitSingleEncapsulatedExpression(expression, IdentificationVariableType.ALL);
    }

    @Override
    public void visit(SqrtExpression expression) {
        expression.accept(this.visitParentVisitor());
        this.visitSingleEncapsulatedExpression(expression, IdentificationVariableType.ALL);
    }

    @Override
    public void visit(StateFieldPathExpression expression) {
        this.visitPathExpression(expression);
    }

    @Override
    public void visit(StringLiteral expression) {
        super.visit(expression);
    }

    @Override
    public void visit(SubExpression expression) {
        this.corrections.add(this.position(expression));
        super.visit(expression);
        this.corrections.pop();
    }

    @Override
    public void visit(SubstringExpression expression) {
        super.visit(expression);
        this.visitCollectionExpression(expression, "SUBSTRING", this.tripleEncapsulatedCollectionHelper());
    }

    @Override
    public void visit(SubtractionExpression expression) {
        super.visit(expression);
        this.visitArithmeticExpression(expression);
    }

    @Override
    public void visit(SumFunction expression) {
        super.visit(expression);
        this.visitAggregateFunction(expression);
    }

    @Override
    public void visit(TreatExpression expression) {
        super.visit(expression);
        int position = this.position(expression) - this.corrections.peek();
        if (this.isPositionWithin(position, "TREAT")) {
            if (this.isValidVersion("TREAT")) {
                this.proposals.addIdentifier("TREAT");
            }
        } else if (expression.hasLeftParenthesis()) {
            Expression collectionValuedPathExpression;
            int length = "TREAT".length() + 1;
            if (position == length) {
                this.addLeftIdentificationVariables(expression);
            }
            if (expression.hasCollectionValuedPathExpression() && expression.hasSpaceAfterCollectionValuedPathExpression() && this.isPositionWithin(position, length += this.length(collectionValuedPathExpression = expression.getCollectionValuedPathExpression()) + 1, "AS")) {
                this.proposals.addIdentifier("AS");
                if (!expression.hasEntityType()) {
                    IType type = this.getType(collectionValuedPathExpression);
                    if (type.isResolvable()) {
                        this.addAbstractSchemaTypes(type);
                    } else {
                        this.addAbstractSchemaTypes();
                    }
                }
            }
            if (expression.hasAs() && expression.hasSpaceAfterAs() && position == (length += "AS".length() + 1)) {
                IType type = this.getType(expression.getCollectionValuedPathExpression());
                if (type.isResolvable()) {
                    this.addAbstractSchemaTypes(type);
                } else {
                    this.addAbstractSchemaTypes();
                }
            }
        }
    }

    @Override
    public void visit(TrimExpression expression) {
        super.visit(expression);
        int position = this.position(expression) - this.corrections.peek();
        int length = 0;
        if (this.isPositionWithin(position, "TRIM")) {
            this.proposals.addIdentifier("TRIM");
        } else if (expression.hasLeftParenthesis()) {
            if (position == (length += "TRIM".length() + 1)) {
                this.addProposal("BOTH");
                this.addProposal("LEADING");
                this.addProposal("TRAILING");
                if (!expression.hasTrimCharacter() && !expression.hasFrom()) {
                    this.addAllIdentificationVariables(expression);
                    this.addAllFunctions("string_primary");
                }
            }
            if (expression.hasSpecification()) {
                String specification = expression.getSpecification().name();
                if (this.isPositionWithin(position, length, specification)) {
                    this.addProposal("BOTH");
                    this.addProposal("LEADING");
                    this.addProposal("TRAILING");
                    if (!expression.hasTrimCharacter() && !expression.hasFrom()) {
                        this.addAllIdentificationVariables(expression);
                        this.addAllFunctions("string_primary");
                    }
                }
                length += specification.length();
            }
            if (expression.hasSpaceAfterSpecification()) {
                ++length;
            }
            if (expression.hasTrimCharacter()) {
                length += this.length(expression.getTrimCharacter());
            }
            if (expression.hasSpaceAfterTrimCharacter()) {
                ++length;
            }
            if (position == length) {
                this.addProposal("FROM");
                if (!expression.hasFrom()) {
                    this.addAllIdentificationVariables(expression);
                    this.addAllFunctions("string_primary");
                }
            }
            if (expression.hasFrom()) {
                if (this.isPositionWithin(position, length, "FROM")) {
                    this.addProposal("FROM");
                }
                length += "FROM".length();
            }
            if (expression.hasSpaceAfterFrom()) {
                ++length;
            }
            if (position == length) {
                this.addAllIdentificationVariables(expression);
                this.addAllFunctions("string_primary");
            }
            if (expression.hasExpression() && position == (length += this.length(expression.getExpression())) + this.virtualSpaces.peek() && !expression.hasTrimCharacter() && !expression.hasFrom()) {
                this.addProposal("FROM");
            }
        }
    }

    @Override
    public void visit(TypeExpression expression) {
        super.visit(expression);
        this.visitSingleEncapsulatedExpression(expression, IdentificationVariableType.ALL);
    }

    @Override
    public void visit(UnknownExpression expression) {
        this.corrections.add(this.position(expression));
        super.visit(expression);
        this.corrections.pop();
    }

    @Override
    public void visit(UpdateClause expression) {
        super.visit(expression);
        int position = this.position(expression) - this.corrections.peek();
        if (this.isPositionWithin(position, "UPDATE")) {
            this.proposals.addIdentifier("UPDATE");
        } else if (expression.hasSpaceAfterUpdate()) {
            RangeVariableDeclaration rangeVariableDeclaration;
            int length = "UPDATE".length() + 1;
            if (position == length) {
                this.addAbstractSchemaTypes();
            } else if (expression.hasRangeVariableDeclaration() && (rangeVariableDeclaration = this.findRangeVariableDeclaration(expression)) != null && rangeVariableDeclaration.hasAbstractSchemaName() && rangeVariableDeclaration.hasSpaceAfterAbstractSchemaName()) {
                if (!expression.hasSet() && !rangeVariableDeclaration.hasAs() && this.isPositionWithin(position, length += this.length(rangeVariableDeclaration.getAbstractSchemaName()) + 1, "SET")) {
                    this.addProposal("SET");
                } else {
                    if (rangeVariableDeclaration.hasAs()) {
                        length += 2;
                    }
                    if (rangeVariableDeclaration.hasSpaceAfterAs()) {
                        ++length;
                    }
                    if (rangeVariableDeclaration.hasIdentificationVariable()) {
                        length += this.length(rangeVariableDeclaration.getIdentificationVariable());
                    }
                    if (expression.hasSpaceAfterRangeVariableDeclaration()) {
                        ++length;
                    }
                    if ((rangeVariableDeclaration.hasAs() && rangeVariableDeclaration.hasIdentificationVariable() || !rangeVariableDeclaration.hasAs() && rangeVariableDeclaration.hasIdentificationVariable()) && this.isPositionWithin(position, length, "SET")) {
                        this.addProposal("SET");
                    } else if (expression.hasSet() && expression.hasSpaceAfterSet()) {
                        if (position == (length += "SET".length() + 1)) {
                            this.addAllIdentificationVariables(expression);
                        } else {
                            this.visitCollectionExpression(expression, "", this.updateItemCollectionHelper());
                        }
                    }
                }
            }
        }
    }

    @Override
    public void visit(UpdateItem expression) {
        super.visit(expression);
        int position = this.position(expression) - this.corrections.peek();
        int length = 0;
        if (position == length) {
            this.addAllIdentificationVariables(expression);
        } else if (expression.hasStateFieldPathExpression() && expression.hasSpaceAfterStateFieldPathExpression()) {
            if (position == (length += this.length(expression.getStateFieldPathExpression()) + 1)) {
                this.proposals.addIdentifier("=");
            } else if (expression.hasEqualSign()) {
                if (position == ++length) {
                    this.proposals.addIdentifier("=");
                    this.addAllIdentificationVariables(expression);
                    this.addAllFunctions("new_value");
                } else if (expression.hasSpaceAfterEqualSign() && position == ++length) {
                    this.addAllIdentificationVariables(expression);
                    this.addAllFunctions("new_value");
                }
            }
        }
    }

    @Override
    public void visit(UpdateStatement expression) {
        if (!this.isLocked(expression)) {
            super.visit(expression);
            this.visitUpdateStatement(expression);
        }
    }

    @Override
    public void visit(UpperExpression expression) {
        super.visit(expression);
        this.visitSingleEncapsulatedExpression(expression, IdentificationVariableType.ALL);
    }

    @Override
    public void visit(ValueExpression expression) {
        super.visit(expression);
        this.visitSingleEncapsulatedExpression(expression, IdentificationVariableType.LEFT_COLLECTION);
    }

    @Override
    public void visit(WhenClause expression) {
        super.visit(expression);
        int position = this.position(expression) - this.corrections.peek();
        if (this.isPositionWithin(position, "WHEN")) {
            this.proposals.addIdentifier("WHEN");
        } else if (expression.hasSpaceAfterWhen()) {
            int length = "WHEN".length() + 1;
            if (position == length) {
                this.addAllIdentificationVariables(expression);
                this.addAllFunctions("internal_when_clause*");
            } else {
                length += this.length(expression.getWhenExpression());
                if (expression.hasSpaceAfterWhenExpression()) {
                    if (position == ++length) {
                        this.proposals.addIdentifier("THEN");
                    } else if (expression.hasThen()) {
                        if (this.isPositionWithin(position, length, "THEN")) {
                            this.proposals.addIdentifier("THEN");
                        } else {
                            length += "THEN".length();
                            if (expression.hasSpaceAfterThen() && position == ++length) {
                                this.addScalarExpressionProposals(expression);
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void visit(WhereClause expression) {
        if (!this.isLocked(expression)) {
            super.visit(expression);
            this.visitClause(expression, "WHERE", expression.hasSpaceAfterIdentifier(), this.whereClauseHelper());
            this.visitCompoundableExpression(expression);
        }
    }

    private void visitAggregateFunction(AggregateFunction expression) {
        String identifier;
        int position = this.position(expression) - this.corrections.peek();
        if (this.isPositionWithin(position, identifier = expression.getIdentifier())) {
            this.proposals.addIdentifier(identifier);
        } else if (expression.hasLeftParenthesis()) {
            int length = identifier.length() + 1;
            boolean hasDistinct = expression.hasDistinct();
            if (hasDistinct && this.isPositionWithin(position, length, "DISTINCT")) {
                this.addProposal("DISTINCT");
            } else {
                if (hasDistinct && expression.hasSpaceAfterDistinct()) {
                    length += "DISTINCT".length() + 1;
                }
                if (position == length) {
                    if (!hasDistinct) {
                        this.addProposal("DISTINCT");
                    }
                    this.addAllIdentificationVariables(expression);
                    this.addAllFunctions(expression.encapsulatedExpressionBNF());
                }
            }
        }
    }

    private void visitArithmeticExpression(ArithmeticExpression expression) {
        int position = this.position(expression) - this.corrections.peek();
        int length = 0;
        if (expression.hasLeftExpression()) {
            length += this.length(expression.getLeftExpression()) + 1;
        }
        if (this.isPositionWithin(position, length, "+")) {
            this.addAllAggregates(expression.getQueryBNF());
        } else if (expression.hasSpaceAfterIdentifier() && position == (length += 2) && this.positionInCollections.peek() == -1) {
            this.addAllIdentificationVariables(expression);
            this.addAllFunctions(expression.rightExpressionBNF(), position);
        }
    }

    private <T extends AbstractExpression> void visitClause(T expression, String identifier, boolean hasSpaceAfterIdentifier, ClauseHelper<T> helper) {
        this.lockedExpressions.add(expression);
        int position = this.position(expression) - this.corrections.peek();
        if (this.isPositionWithin(position, identifier)) {
            this.proposals.addIdentifier(identifier);
        } else if (hasSpaceAfterIdentifier) {
            int length = identifier.length() + 1;
            if (position == length) {
                helper.addProposals(expression);
            } else {
                Expression clauseExpression = helper.getClauseExpression(expression);
                int clauseExpressionLength = this.length(clauseExpression);
                if (position == length + clauseExpressionLength + this.virtualSpaces.peek()) {
                    this.virtualSpaces.add(1);
                    this.corrections.add(-clauseExpressionLength - 2);
                    clauseExpression.accept(this);
                    if (this.isComplete(clauseExpression)) {
                        helper.addAtTheEndOfExpression(expression);
                    }
                    this.virtualSpaces.pop();
                    this.corrections.pop();
                }
            }
        }
        this.lockedExpressions.pop();
    }

    private <T extends Expression> void visitCollectionExpression(T expression, String identifier, CollectionExpressionHelper<T> helper) {
        int position = this.position(expression) - this.corrections.peek();
        if (this.isPositionWithin(position, identifier)) {
            this.proposals.addIdentifier(identifier);
        } else if (helper.hasDelimiterAfterIdentifier(expression)) {
            int length = identifier.length() + 1;
            if (position == (length += helper.preExpressionLength(expression))) {
                helper.addProposals(expression, 0);
            } else {
                CollectionExpression collectionExpression = helper.buildCollectionExpression(expression);
                boolean hasComma = false;
                int count = Math.min(collectionExpression.childrenSize(), helper.maxCollectionSize(expression));
                for (int index = 0; index < count; ++index) {
                    Expression child = collectionExpression.getChild(index);
                    int childLength = 0;
                    if (position == length) {
                        helper.addProposals(expression, index);
                        break;
                    }
                    childLength = this.length(child);
                    if (position == length + childLength + this.virtualSpaces.peek() && this.isComplete(child)) {
                        helper.addAtTheEndOfChild(expression, child, index);
                        break;
                    }
                    length += childLength;
                    hasComma = collectionExpression.hasComma(index);
                    if (hasComma && position == ++length) {
                        helper.addProposals(expression, index + 1);
                        break;
                    }
                    if (collectionExpression.hasSpace(index)) {
                        ++length;
                    }
                    if (position < length) break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visitCompoundableExpression(AbstractConditionalClause expression) {
        if (expression.hasConditionalExpression()) {
            int position = this.position(expression);
            int length = expression.getIdentifier().length() + 1;
            CompoundExpressionHelper helper = this.compoundExpressionHelper();
            try {
                expression.getConditionalExpression().accept(helper);
                this.visitCompoundableExpression(helper, position, length);
            }
            finally {
                helper.dispose();
            }
        }
    }

    private void visitCompoundableExpression(CompoundExpressionHelper helper, int position, int length) {
        if (position == (length += helper.length())) {
            if (helper.isCompoundable()) {
                this.addAllCompounds("conditional_expression");
            }
        } else if (helper.hasIdentifier()) {
            length += helper.identifierLength();
            if (helper.hasNext()) {
                helper.next();
                this.visitCompoundableExpression(helper, position, length);
            }
        }
    }

    private void visitDeleteStatement(DeleteStatement expression) {
        this.lockedExpressions.add(expression);
        int position = this.position(expression);
        DeleteClause deleteClause = expression.getDeleteClause();
        int length = this.length(deleteClause);
        if (position == length && this.isAppendable(deleteClause)) {
            this.addProposal("WHERE");
        } else if (position == length + 1 && expression.hasSpaceAfterDeleteClause()) {
            this.virtualSpaces.add(1);
            this.corrections.add(-length - 2);
            deleteClause.accept(this);
            this.corrections.pop();
            this.virtualSpaces.pop();
        }
        if (position == length && !expression.hasSpaceAfterDeleteClause()) {
            return;
        }
        if (expression.hasSpaceAfterDeleteClause()) {
            ++length;
        }
        if (position == length && !deleteClause.hasRangeVariableDeclaration()) {
            return;
        }
        if (position == length && expression.hasSpaceAfterDeleteClause() && this.isComplete(deleteClause.getRangeVariableDeclaration())) {
            this.addProposal("WHERE");
        }
        if (expression.hasWhereClause()) {
            int whereClauseLength;
            AbstractConditionalClause whereClause = (AbstractConditionalClause)expression.getWhereClause();
            if (position > length && position == (length += (whereClauseLength = this.length(whereClause))) + 1) {
                this.virtualSpaces.add(1);
                this.corrections.add(-whereClauseLength - 2);
                whereClause.accept(this);
                this.corrections.pop();
                this.virtualSpaces.pop();
            }
        }
    }

    private void visitEncapsulatedExpression(AbstractEncapsulatedExpression expression, String identifier, String jpqlQueryBNF) {
        int length;
        int position = this.position(expression) - this.corrections.peek();
        if (this.isPositionWithin(position, identifier)) {
            this.proposals.addIdentifier(identifier);
        } else if (expression.hasLeftParenthesis() && position == (length = identifier.length() + 1)) {
            this.addAllIdentificationVariables(expression);
            this.addAllFunctions(jpqlQueryBNF);
        }
    }

    private void visitLogicalExpression(LogicalExpression expression, String identifier) {
        int position = this.position(expression) - this.corrections.peek();
        int length = 0;
        if (expression.hasLeftExpression()) {
            length += this.length(expression.getLeftExpression()) + 1;
        }
        if (this.isPositionWithin(position, length, expression.getIdentifier())) {
            this.proposals.addIdentifier(identifier);
        } else if (expression.hasSpaceAfterIdentifier() && position == (length += identifier.length() + 1)) {
            this.addAllIdentificationVariables(expression);
            this.addAllFunctions(expression.rightExpressionBNF());
        }
    }

    private VisitParentVisitor visitParentVisitor() {
        return this.getHelper(VisitParentVisitor.class);
    }

    private void visitPathExpression(AbstractPathExpression expression) {
        int position = this.position(expression);
        String text = expression.toActualText();
        int dotIndex = text.indexOf(46);
        if (position > -1) {
            if (dotIndex > -1 && position > dotIndex) {
                this.visitPathExpression(expression, this.mappingFilter(expression));
            } else {
                String variableName = this.queryContext.literal(expression.getIdentificationVariable(), LiteralType.IDENTIFICATION_VARIABLE);
                if (ExpressionTools.stringIsNotEmpty(variableName)) {
                    this.corrections.add(this.position(expression));
                    this.visit(expression);
                    this.corrections.pop();
                }
            }
        }
    }

    private void visitPathExpression(AbstractPathExpression expression, Filter<IMapping> helper) {
        MappingCollector mappingCollector = this.defaultMappingCollector();
        int position = this.queryPosition.getPosition(expression);
        boolean mappingCollectorCreated = false;
        Resolver resolver = null;
        int length = 0;
        int count = expression.pathSize();
        for (int index = 0; index < count; ++index) {
            Resolver childResolver;
            String path = expression.getPath(index);
            if (position <= length + path.length()) {
                if (length == position) {
                    path = "";
                } else if (position - length > -1) {
                    path = path.substring(0, position - length);
                }
                if (resolver == null) break;
                mappingCollector = this.buildFilteringMappingCollector(expression, resolver, helper, path);
                mappingCollectorCreated = true;
                break;
            }
            if (resolver == null) {
                resolver = this.queryContext.getResolver(expression.getIdentificationVariable());
            } else if ((index + 1 < count || expression.endsWithDot()) && (childResolver = resolver.getChild(path)) == null) {
                childResolver = new SingleValuedObjectFieldResolver(resolver, path);
                resolver.addChild(path, childResolver);
                resolver = childResolver;
            }
            length += path.length() + 1;
        }
        if (!mappingCollectorCreated && resolver != null) {
            mappingCollector = this.buildMappingCollector(expression, resolver, helper);
        }
        this.proposals.addMappings(mappingCollector.buildProposals());
    }

    private void visitSelectClause(AbstractSelectClause expression) {
        int position = this.position(expression) - this.corrections.peek();
        if (this.isPositionWithin(position, "SELECT")) {
            this.proposals.addIdentifier("SELECT");
        } else if (expression.hasSpaceAfterSelect()) {
            int length = "SELECT".length() + 1;
            if (expression.hasDistinct() && this.isPositionWithin(position, length, "DISTINCT")) {
                this.proposals.addIdentifier("DISTINCT");
            } else {
                if (expression.hasDistinct()) {
                    length += "DISTINCT".length();
                    if (expression.hasSpaceAfterDistinct()) {
                        ++length;
                    }
                }
                if (position == length) {
                    if (!expression.hasDistinct()) {
                        this.addProposal("DISTINCT");
                    }
                    this.addAllIdentificationVariables(expression);
                    this.addAllFunctions("select_item");
                } else {
                    int selectExpressionLength = this.length(expression.getSelectExpression());
                    if (position <= length + selectExpressionLength + this.virtualSpaces.peek()) {
                        this.addSelectExpressionProposals(expression, length);
                    }
                }
            }
        }
    }

    private SelectStatementHelper<? extends AbstractSelectStatement, ? extends Expression> visitSelectStatement(AbstractSelectStatement expression, int position, int[] length, SelectStatementHelper<AbstractSelectStatement, Expression> helper) {
        if (position == length[0]) {
            if (helper.hasSpaceBeforeClause(expression) && this.isPreviousClauseComplete(expression, helper)) {
                helper.addClauseProposal();
            }
            return null;
        }
        if (helper.hasClause(expression)) {
            Expression clause = helper.getClause(expression);
            if (position > length[0]) {
                int clauseLength = this.length(clause);
                length[0] = length[0] + clauseLength;
                boolean hasSpaceAfterIdentifier = helper.hasSpaceAfterClause(expression);
                Expression clauseExpression = helper.getClauseExpression(clause);
                if (position == length[0]) {
                    helper.appendNextClauseProposals(expression, clause, position, false);
                } else if (position == length[0] + 1 && hasSpaceAfterIdentifier) {
                    this.virtualSpaces.add(1);
                    this.corrections.add(-clauseLength - 2);
                    clause.accept(this);
                    this.corrections.pop();
                    this.virtualSpaces.pop();
                    if (helper.isClauseExpressionComplete(clauseExpression)) {
                        helper.appendNextClauseProposals(expression, clause, position, true);
                    }
                }
                if (position < length[0] || position == length[0] && !hasSpaceAfterIdentifier) {
                    return null;
                }
                if (hasSpaceAfterIdentifier) {
                    length[0] = length[0] + 1;
                }
                if (position < length[0] || position == length[0] && !helper.hasClauseExpression(clause)) {
                    return null;
                }
                if (position == length[0]) {
                    if (hasSpaceAfterIdentifier && helper.isClauseExpressionComplete(clauseExpression)) {
                        helper.appendNextClauseProposals(expression, clause, position, true);
                    }
                    return null;
                }
            }
        }
        return helper.getNextHelper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visitSelectStatement(AbstractSelectStatement expression, SelectStatementHelper<? extends AbstractSelectStatement, ? extends Expression> helper) {
        this.lockedExpressions.add(expression);
        try {
            int position = this.position(expression);
            int[] length = new int[1];
            while (helper != null) {
                helper = this.visitSelectStatement(expression, position, length, this.cast(helper));
            }
        }
        finally {
            this.lockedExpressions.pop();
        }
    }

    private void visitSingleEncapsulatedExpression(AbstractSingleEncapsulatedExpression expression, IdentificationVariableType identificationVariableType) {
        this.visitSingleEncapsulatedExpression(expression, identificationVariableType, expression.getIdentifier());
    }

    private void visitSingleEncapsulatedExpression(AbstractSingleEncapsulatedExpression expression, IdentificationVariableType identificationVariableType, String ... expressionIdentifiers) {
        int position = this.position(expression) - this.corrections.peek();
        String actualIdentifier = expression.getIdentifier();
        boolean added = false;
        for (String identifier : expressionIdentifiers) {
            if (this.isPositionWithin(position, actualIdentifier)) {
                this.proposals.addIdentifier(identifier);
                continue;
            }
            if (!expression.hasLeftParenthesis()) continue;
            int length = identifier.length() + 1;
            if (added || position != length) continue;
            added = true;
            this.addIdentificationVariables(identificationVariableType, expression);
            String queryBNF = expression.encapsulatedExpressionBNF();
            this.addAllFunctions(queryBNF);
            this.addAllClauses(queryBNF);
        }
    }

    private void visitUpdateStatement(UpdateStatement expression) {
        this.lockedExpressions.add(expression);
        int position = this.position(expression);
        UpdateClause updateClause = expression.getUpdateClause();
        int length = this.length(updateClause);
        if (position == length + 1 && expression.hasSpaceAfterUpdateClause()) {
            this.virtualSpaces.add(1);
            this.corrections.add(-length - 2);
            updateClause.accept(this);
            this.corrections.pop();
            this.virtualSpaces.pop();
        }
        if (position == length && !expression.hasSpaceAfterUpdateClause()) {
            return;
        }
        if (expression.hasSpaceAfterUpdateClause()) {
            ++length;
        }
        if (position == length && !updateClause.hasRangeVariableDeclaration()) {
            return;
        }
        if (position == length) {
            if (expression.hasSpaceAfterUpdateClause() && this.isComplete(updateClause.getUpdateItems())) {
                this.addProposal("WHERE");
            }
            return;
        }
        if (expression.hasWhereClause()) {
            int whereClauseLength;
            AbstractConditionalClause whereClause = (AbstractConditionalClause)expression.getWhereClause();
            if (position > length && position == (length += (whereClauseLength = this.length(whereClause))) + 1) {
                this.virtualSpaces.add(1);
                this.corrections.add(-whereClauseLength - 2);
                whereClause.accept(this);
                this.corrections.pop();
                this.virtualSpaces.pop();
            }
        }
    }

    private ClauseHelper<WhereClause> whereClauseHelper() {
        return this.getHelper(WhereClauseHelper.class);
    }

    private WhereClauseSelectStatementHelper whereClauseSelectStatementHelper() {
        return this.getHelper(WhereClauseSelectStatementHelper.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AbstractFromClauseSelectStatementHelper<T extends AbstractSelectStatement>
    implements SelectStatementHelper<T, AbstractFromClause> {
        private AbstractFromClauseSelectStatementHelper() {
        }

        protected boolean addAppendableToCollection(T expression, int position) {
            if (ContentAssistVisitor.this.wordParser.endsWith(position, "GROUP") || ContentAssistVisitor.this.wordParser.endsWith(position, "GROUP B")) {
                if (!((AbstractSelectStatement)expression).hasWhereClause()) {
                    ContentAssistVisitor.this.proposals.addIdentifier("GROUP BY");
                }
                return true;
            }
            if (ContentAssistVisitor.this.wordParser.endsWith(position, "ORDER") || ContentAssistVisitor.this.wordParser.endsWith(position, "ORDER B")) {
                if (!((AbstractSelectStatement)expression).hasWhereClause() && !((AbstractSelectStatement)expression).hasHavingClause()) {
                    ContentAssistVisitor.this.proposals.addIdentifier("ORDER BY");
                }
                return true;
            }
            return false;
        }

        protected abstract void addClauseIdentifierProposals(T var1);

        @Override
        public void addClauseProposal() {
            ContentAssistVisitor.this.addProposal("FROM");
        }

        @Override
        public final void appendNextClauseProposals(T expression, AbstractFromClause clause, int position, boolean complete) {
            boolean skip;
            if (complete || ContentAssistVisitor.this.isAppendable(clause)) {
                this.addClauseIdentifierProposals(expression);
            } else if (ContentAssistVisitor.this.isAppendableToCollection(clause) && !(skip = this.addAppendableToCollection(expression, position))) {
                this.addClauseIdentifierProposals(expression);
            }
        }

        @Override
        public AbstractFromClause getClause(T expression) {
            return (AbstractFromClause)((AbstractSelectStatement)expression).getFromClause();
        }

        @Override
        public Expression getClauseExpression(AbstractFromClause clause) {
            return clause.getDeclaration();
        }

        @Override
        public boolean hasClause(AbstractSelectStatement expression) {
            return expression.hasFromClause();
        }

        @Override
        public boolean hasClauseExpression(AbstractFromClause clause) {
            return clause.hasDeclaration();
        }

        @Override
        public boolean hasSpaceAfterClause(T expression) {
            return ((AbstractSelectStatement)expression).hasSpaceAfterFrom();
        }

        @Override
        public boolean hasSpaceBeforeClause(T expression) {
            return ((AbstractSelectStatement)expression).hasSpaceAfterSelect();
        }

        @Override
        public boolean isClauseExpressionComplete(Expression expression) {
            return ContentAssistVisitor.this.isComplete(expression);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AbstractGroupByClauseSelectStatementHelper<T extends AbstractSelectStatement>
    implements SelectStatementHelper<T, GroupByClause> {
        private AbstractGroupByClauseSelectStatementHelper() {
        }

        @Override
        public void addClauseProposal() {
            ContentAssistVisitor.this.addProposal("GROUP BY");
        }

        @Override
        public GroupByClause getClause(AbstractSelectStatement expression) {
            return (GroupByClause)expression.getGroupByClause();
        }

        @Override
        public Expression getClauseExpression(GroupByClause clause) {
            return clause.getGroupByItems();
        }

        @Override
        public boolean hasClause(AbstractSelectStatement expression) {
            return expression.hasGroupByClause();
        }

        @Override
        public boolean hasClauseExpression(GroupByClause clause) {
            return clause.hasGroupByItems();
        }

        @Override
        public boolean hasSpaceAfterClause(AbstractSelectStatement expression) {
            return expression.hasSpaceAfterGroupBy();
        }

        @Override
        public boolean hasSpaceBeforeClause(AbstractSelectStatement expression) {
            return expression.hasSpaceAfterWhere();
        }

        @Override
        public boolean isClauseExpressionComplete(Expression expression) {
            return ContentAssistVisitor.this.isGroupByComplete(expression);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AbstractHavingClauseSelectStatementHelper<T extends AbstractSelectStatement>
    implements SelectStatementHelper<T, HavingClause> {
        private AbstractHavingClauseSelectStatementHelper() {
        }

        @Override
        public void addClauseProposal() {
            ContentAssistVisitor.this.addProposal("HAVING");
        }

        @Override
        public HavingClause getClause(AbstractSelectStatement expression) {
            return (HavingClause)expression.getHavingClause();
        }

        @Override
        public Expression getClauseExpression(HavingClause clause) {
            return clause.getConditionalExpression();
        }

        @Override
        public boolean hasClause(AbstractSelectStatement expression) {
            return expression.hasHavingClause();
        }

        @Override
        public boolean hasClauseExpression(HavingClause clause) {
            return clause.hasConditionalExpression();
        }

        @Override
        public boolean hasSpaceBeforeClause(AbstractSelectStatement expression) {
            return expression.hasSpaceAfterGroupBy();
        }

        @Override
        public boolean isClauseExpressionComplete(Expression expression) {
            return ContentAssistVisitor.this.isConditionalExpressionComplete(expression);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AbstractSelectClauseSelectStatementHelper
    implements SelectStatementHelper<AbstractSelectStatement, AbstractSelectClause> {
        private AbstractSelectClauseSelectStatementHelper() {
        }

        @Override
        public void addClauseProposal() {
            ContentAssistVisitor.this.addProposal("SELECT");
        }

        @Override
        public void appendNextClauseProposals(AbstractSelectStatement expression, AbstractSelectClause clause, int position, boolean complete) {
            if (complete || ContentAssistVisitor.this.isAppendable(clause)) {
                ContentAssistVisitor.this.addProposal("FROM");
            }
        }

        @Override
        public AbstractSelectClause getClause(AbstractSelectStatement expression) {
            return expression.getSelectClause();
        }

        @Override
        public Expression getClauseExpression(AbstractSelectClause clause) {
            return clause.getSelectExpression();
        }

        @Override
        public SelectStatementHelper<AbstractSelectStatement, Expression> getPreviousHelper() {
            return null;
        }

        @Override
        public boolean hasClause(AbstractSelectStatement expression) {
            return true;
        }

        @Override
        public boolean hasClauseExpression(AbstractSelectClause clause) {
            return clause.hasSelectExpression();
        }

        @Override
        public boolean hasSpaceAfterClause(AbstractSelectStatement expression) {
            return expression.hasSpaceAfterSelect();
        }

        @Override
        public boolean hasSpaceBeforeClause(AbstractSelectStatement expression) {
            return false;
        }

        @Override
        public boolean isClauseExpressionComplete(Expression expression) {
            return ContentAssistVisitor.this.isSelectExpressionComplete(expression);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AbstractWhereClauseSelectStatementHelper<T extends AbstractSelectStatement>
    implements SelectStatementHelper<T, WhereClause> {
        private AbstractWhereClauseSelectStatementHelper() {
        }

        @Override
        public void addClauseProposal() {
            ContentAssistVisitor.this.addProposal("WHERE");
        }

        @Override
        public WhereClause getClause(AbstractSelectStatement expression) {
            return (WhereClause)expression.getWhereClause();
        }

        @Override
        public Expression getClauseExpression(WhereClause clause) {
            return clause.getConditionalExpression();
        }

        @Override
        public boolean hasClause(AbstractSelectStatement expression) {
            return expression.hasWhereClause();
        }

        @Override
        public boolean hasClauseExpression(WhereClause clause) {
            return clause.hasConditionalExpression();
        }

        @Override
        public boolean hasSpaceAfterClause(AbstractSelectStatement expression) {
            return expression.hasSpaceAfterWhere();
        }

        @Override
        public boolean hasSpaceBeforeClause(AbstractSelectStatement expression) {
            return expression.hasSpaceAfterFrom();
        }

        @Override
        public boolean isClauseExpressionComplete(Expression expression) {
            return ContentAssistVisitor.this.isConditionalExpressionComplete(expression);
        }
    }

    private class AcceptableTypeVisitor
    extends AbstractExpressionVisitor {
        IType type;

        private AcceptableTypeVisitor() {
        }

        public void visit(AbsExpression expression) {
            this.type = ContentAssistVisitor.this.getType(Number.class);
        }

        public void visit(ArithmeticFactor expression) {
            this.type = ContentAssistVisitor.this.getType(Number.class);
        }

        public void visit(AvgFunction expression) {
            this.type = ContentAssistVisitor.this.getType(Number.class);
        }

        public void visit(CollectionExpression expression) {
            expression.getParent().accept(this);
        }

        public void visit(ConcatExpression expression) {
            this.type = ContentAssistVisitor.this.getType(CharSequence.class);
        }

        public void visit(LengthExpression expression) {
            this.type = ContentAssistVisitor.this.getType(CharSequence.class);
        }

        public void visit(LocateExpression expression) {
            this.type = ContentAssistVisitor.this.getType(CharSequence.class);
        }

        public void visit(LowerExpression expression) {
            this.type = ContentAssistVisitor.this.getType(CharSequence.class);
        }

        public void visit(ModExpression expression) {
            this.type = ContentAssistVisitor.this.getType(Number.class);
        }

        public void visit(SqrtExpression expression) {
            this.type = ContentAssistVisitor.this.getType(Number.class);
        }

        public void visit(SubExpression expression) {
            expression.getParent().accept(this);
        }

        public void visit(SubstringExpression expression) {
            this.type = ContentAssistVisitor.this.getType(CharSequence.class);
        }

        public void visit(SumFunction expression) {
            this.type = ContentAssistVisitor.this.getType(Number.class);
        }

        public void visit(TrimExpression expression) {
            this.type = ContentAssistVisitor.this.getType(CharSequence.class);
        }

        public void visit(UpperExpression expression) {
            this.type = ContentAssistVisitor.this.getType(CharSequence.class);
        }
    }

    private class AppendableExpressionVisitor
    extends AbstractTraverseChildrenVisitor {
        boolean appendable;
        int positionInCollection = -1;

        AppendableExpressionVisitor() {
        }

        public void visit(AdditionExpression expression) {
            super.visit(expression);
        }

        public void visit(AndExpression expression) {
            super.visit(expression);
        }

        public void visit(CollectionExpression expression) {
            this.positionInCollection = expression.childrenSize() - 1;
            expression.getChild(this.positionInCollection).accept(this);
            this.positionInCollection = -1;
        }

        public void visit(DivisionExpression expression) {
            super.visit(expression);
        }

        public void visit(IdentificationVariable expression) {
            this.appendable = this.positionInCollection > -1;
        }

        public void visit(IdentificationVariableDeclaration expression) {
            if (expression.hasJoins()) {
                expression.getJoins().accept(this);
            } else {
                expression.getRangeVariableDeclaration().accept(this);
            }
        }

        public void visit(MultiplicationExpression expression) {
            super.visit(expression);
        }

        public void visit(OrExpression expression) {
            super.visit(expression);
        }

        public void visit(RangeVariableDeclaration expression) {
            this.appendable = !expression.hasSpaceAfterAbstractSchemaName() && !expression.hasAs() && !expression.hasIdentificationVariable();
        }

        public void visit(ResultVariable expression) {
            this.appendable = !expression.hasAs() && !expression.hasSpaceAfterAs() && expression.hasResultVariable();
        }

        public void visit(SubtractionExpression expression) {
            super.visit(expression);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface ClauseHelper<T extends Expression> {
        public void addAtTheEndOfExpression(T var1);

        public void addProposals(T var1);

        public Expression getClauseExpression(T var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface CollectionExpressionHelper<T extends Expression> {
        public void addAtTheEndOfChild(T var1, Expression var2, int var3);

        public void addProposals(T var1, int var2);

        public CollectionExpression buildCollectionExpression(T var1);

        public boolean hasDelimiterAfterIdentifier(T var1);

        public int maxCollectionSize(T var1);

        public int preExpressionLength(T var1);

        public JPQLQueryBNF queryBNF(T var1, int var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CollectionMappingFilter
    implements Filter<IMapping> {
        private CollectionMappingFilter() {
        }

        @Override
        public boolean accept(IMapping value) {
            return MappingTypeHelper.isRelationshipMapping(value);
        }
    }

    private abstract class CompletenessVisitor
    extends AbstractExpressionVisitor {
        boolean complete;

        private CompletenessVisitor() {
        }

        public void visit(CollectionExpression expression) {
            int lastIndex = expression.childrenSize() - 1;
            AbstractExpression child = (AbstractExpression)expression.getChild(lastIndex);
            child.accept(this);
        }
    }

    private class CompoundExpressionHelper
    extends AnonymousExpressionVisitor {
        private Expression leftExpression;
        private LogicalExpression logicalExpression;
        private Expression rightExpression;

        private CompoundExpressionHelper() {
        }

        void dispose() {
            this.leftExpression = null;
            this.rightExpression = null;
            this.logicalExpression = null;
        }

        boolean hasIdentifier() {
            return this.logicalExpression != null;
        }

        boolean hasNext() {
            return this.rightExpression != null;
        }

        int identifierLength() {
            if (this.logicalExpression != null) {
                int length = this.logicalExpression.getIdentifier().length();
                length += this.logicalExpression.hasLeftExpression() ? 1 : 0;
                return length += this.logicalExpression.hasSpaceAfterIdentifier() ? 1 : 0;
            }
            return 0;
        }

        boolean isCompoundable() {
            return ContentAssistVisitor.this.isComplete(this.leftExpression);
        }

        int length() {
            if (this.leftExpression != null) {
                return ContentAssistVisitor.this.length(this.leftExpression);
            }
            return 0;
        }

        void next() {
            this.rightExpression.accept(this);
        }

        public void visit(AndExpression expression) {
            this.visitLogicalExpression(expression);
        }

        public void visit(Expression expression) {
            this.leftExpression = expression;
            this.rightExpression = null;
        }

        public void visit(OrExpression expression) {
            this.visitLogicalExpression(expression);
        }

        private void visitLogicalExpression(LogicalExpression expression) {
            this.logicalExpression = expression;
            this.leftExpression = expression.hasLeftExpression() ? expression.getLeftExpression() : null;
            this.rightExpression = expression.hasRightExpression() ? expression.getRightExpression() : null;
        }
    }

    private class ConditionalExpressionCompletenessVisitor
    extends CompletenessVisitor {
        private ConditionalExpressionCompletenessVisitor() {
        }

        public void visit(AndExpression expression) {
            this.complete = expression.hasRightExpression();
            if (this.complete) {
                this.complete = ContentAssistVisitor.this.isComplete(expression.getRightExpression());
            }
        }

        public void visit(BetweenExpression expression) {
            this.complete = expression.hasUpperBoundExpression();
            if (this.complete) {
                this.complete = ContentAssistVisitor.this.isComplete(expression.getUpperBoundExpression());
            }
        }

        public void visit(CollectionMemberExpression expression) {
            this.complete = expression.hasCollectionValuedPathExpression();
            if (this.complete) {
                this.complete = ContentAssistVisitor.this.isComplete(expression.getCollectionValuedPathExpression());
            }
        }

        public void visit(ComparisonExpression expression) {
            this.complete = expression.hasRightExpression();
            if (this.complete) {
                this.complete = ContentAssistVisitor.this.isComplete(expression.getRightExpression());
            }
        }

        public void visit(EmptyCollectionComparisonExpression expression) {
            this.complete = true;
        }

        public void visit(ExistsExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(InExpression expression) {
            this.complete = expression.hasInItems();
            if (this.complete) {
                this.complete = ContentAssistVisitor.this.isComplete(expression.getInItems());
            }
        }

        public void visit(LikeExpression expression) {
            this.complete = ContentAssistVisitor.this.isComplete(expression);
        }

        public void visit(NullComparisonExpression expression) {
            this.complete = true;
        }

        public void visit(OrExpression expression) {
            this.complete = expression.hasRightExpression();
            if (this.complete) {
                this.complete = ContentAssistVisitor.this.isComplete(expression.getRightExpression());
            }
        }

        public void visit(SubExpression expression) {
            if (!this.complete) {
                this.complete = expression.hasRightParenthesis();
                if (this.complete) {
                    expression.getExpression().accept(this);
                }
            } else {
                this.complete = expression.hasRightParenthesis();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConstrutorCollectionHelper
    implements CollectionExpressionHelper<ConstructorExpression> {
        private ConstrutorCollectionHelper() {
        }

        @Override
        public void addAtTheEndOfChild(ConstructorExpression expression, Expression child, int index) {
            ContentAssistVisitor.this.addAllAggregates("constructor_item");
        }

        @Override
        public void addProposals(ConstructorExpression expression, int index) {
            ContentAssistVisitor.this.addIdentificationVariables(IdentificationVariableType.ALL, expression);
            ContentAssistVisitor.this.addAllFunctions("constructor_item");
        }

        @Override
        public CollectionExpression buildCollectionExpression(ConstructorExpression expression) {
            CollectionExpression collectionExpression = ContentAssistVisitor.this.collectionExpression(expression.getConstructorItems());
            if (collectionExpression == null) {
                collectionExpression = expression.buildCollectionExpression();
            }
            return collectionExpression;
        }

        @Override
        public boolean hasDelimiterAfterIdentifier(ConstructorExpression expression) {
            return expression.hasLeftParenthesis();
        }

        @Override
        public int maxCollectionSize(ConstructorExpression expression) {
            return Integer.MAX_VALUE;
        }

        @Override
        public int preExpressionLength(ConstructorExpression expression) {
            if (expression.hasSpaceAfterNew()) {
                return expression.getClassName().length() + 1;
            }
            return expression.getClassName().length();
        }

        @Override
        public JPQLQueryBNF queryBNF(ConstructorExpression expression, int index) {
            return AbstractExpression.queryBNF("constructor_item");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DefaultMappingCollector
    implements MappingCollector {
        private DefaultMappingCollector() {
        }

        @Override
        public Collection<IMapping> buildProposals() {
            return Collections.emptyList();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DeleteClauseHelper
    implements ClauseHelper<DeleteClause> {
        private DeleteClauseHelper() {
        }

        @Override
        public void addAtTheEndOfExpression(DeleteClause expression) {
        }

        @Override
        public void addProposals(DeleteClause expression) {
            ContentAssistVisitor.this.addAbstractSchemaTypes();
        }

        @Override
        public Expression getClauseExpression(DeleteClause expression) {
            return expression.getRangeVariableDeclaration();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DoubleEncapsulatedCollectionHelper
    implements CollectionExpressionHelper<AbstractDoubleEncapsulatedExpression> {
        private DoubleEncapsulatedCollectionHelper() {
        }

        @Override
        public void addAtTheEndOfChild(AbstractDoubleEncapsulatedExpression expression, Expression child, int index) {
            if (this.queryBNF(expression, index).handleAggregate()) {
                ContentAssistVisitor.this.addAllAggregates(this.queryBNF(expression, index));
            }
        }

        @Override
        public void addProposals(AbstractDoubleEncapsulatedExpression expression, int index) {
            ContentAssistVisitor.this.addAllIdentificationVariables(expression);
            ContentAssistVisitor.this.addAllFunctions(this.queryBNF(expression, index));
        }

        @Override
        public CollectionExpression buildCollectionExpression(AbstractDoubleEncapsulatedExpression expression) {
            return expression.buildCollectionExpression();
        }

        @Override
        public boolean hasDelimiterAfterIdentifier(AbstractDoubleEncapsulatedExpression expression) {
            return expression.hasLeftParenthesis();
        }

        @Override
        public int maxCollectionSize(AbstractDoubleEncapsulatedExpression expression) {
            return 2;
        }

        @Override
        public int preExpressionLength(AbstractDoubleEncapsulatedExpression expression) {
            return 0;
        }

        @Override
        public JPQLQueryBNF queryBNF(AbstractDoubleEncapsulatedExpression expression, int index) {
            return expression.parameterExpressionBNF(index);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FilteringMappingCollector
    implements MappingCollector {
        private final Filter<IMapping> filter;
        private final Resolver resolver;
        private final String suffix;

        FilteringMappingCollector(Resolver resolver, Filter<IMapping> filter, String suffix) {
            this.filter = filter;
            this.suffix = suffix;
            this.resolver = resolver;
        }

        private void addFilteredMappings(IManagedType managedType, List<IMapping> mappings) {
            Filter<IMapping> filter = this.buildFilter(this.suffix);
            for (IMapping mapping : managedType.mappings()) {
                if (!filter.accept(mapping)) continue;
                mappings.add(mapping);
            }
        }

        private Filter<IMapping> buildFilter(String suffix) {
            if (suffix.length() == 0) {
                return this.filter;
            }
            return new AndFilter<IMapping>(this.filter, this.buildMappingNameFilter(suffix));
        }

        private Filter<IMapping> buildMappingNameFilter(final String suffix) {
            return new Filter<IMapping>(){

                @Override
                public boolean accept(IMapping mapping) {
                    return mapping.getName().startsWith(suffix);
                }
            };
        }

        @Override
        public Collection<IMapping> buildProposals() {
            IManagedType managedType = this.resolver.getManagedType();
            if (managedType == null) {
                return Collections.emptyList();
            }
            ArrayList<IMapping> mappings = new ArrayList<IMapping>();
            this.addFilteredMappings(managedType, mappings);
            return mappings;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FromClauseCollectionHelper
    implements CollectionExpressionHelper<AbstractFromClause> {
        private FromClauseCollectionHelper() {
        }

        @Override
        public void addAtTheEndOfChild(AbstractFromClause expression, Expression child, int index) {
            ContentAssistVisitor.this.addJoinIdentifiers();
        }

        @Override
        public void addProposals(AbstractFromClause expression, int index) {
            ContentAssistVisitor.this.addAbstractSchemaTypes();
            if (index > 0) {
                ContentAssistVisitor.this.addProposal("IN");
            }
        }

        @Override
        public CollectionExpression buildCollectionExpression(AbstractFromClause expression) {
            CollectionExpression collectionExpression = ContentAssistVisitor.this.collectionExpression(expression.getDeclaration());
            if (collectionExpression == null) {
                collectionExpression = expression.buildCollectionExpression();
            }
            return collectionExpression;
        }

        @Override
        public boolean hasDelimiterAfterIdentifier(AbstractFromClause expression) {
            return expression.hasSpaceAfterFrom();
        }

        @Override
        public int maxCollectionSize(AbstractFromClause expression) {
            return Integer.MAX_VALUE;
        }

        @Override
        public int preExpressionLength(AbstractFromClause expression) {
            return 0;
        }

        @Override
        public JPQLQueryBNF queryBNF(AbstractFromClause expression, int index) {
            return expression.declarationBNF();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FromClauseHelper
    implements ClauseHelper<AbstractFromClause> {
        private FromClauseHelper() {
        }

        @Override
        public void addAtTheEndOfExpression(AbstractFromClause expression) {
        }

        @Override
        public void addProposals(AbstractFromClause expression) {
            ContentAssistVisitor.this.addAbstractSchemaTypes();
            if ((Integer)ContentAssistVisitor.this.positionInCollections.peek() > 0) {
                ContentAssistVisitor.this.addAllIdentifiers("internal_from_clause");
            }
        }

        @Override
        public Expression getClauseExpression(AbstractFromClause expression) {
            return expression.getDeclaration();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FromClauseSelectStatementHelper
    extends AbstractFromClauseSelectStatementHelper<SelectStatement> {
        private FromClauseSelectStatementHelper() {
        }

        @Override
        protected boolean addAppendableToCollection(SelectStatement expression, int position) {
            boolean skip = super.addAppendableToCollection(expression, position);
            if (!skip && (ContentAssistVisitor.this.wordParser.endsWith(position, "ORDER") || ContentAssistVisitor.this.wordParser.endsWith(position, "ORDER B"))) {
                if (!expression.hasWhereClause() && !expression.hasHavingClause()) {
                    ContentAssistVisitor.this.proposals.addIdentifier("ORDER BY");
                }
                return true;
            }
            return false;
        }

        @Override
        protected void addClauseIdentifierProposals(SelectStatement expression) {
            ContentAssistVisitor.this.addProposal("WHERE");
            if (!expression.hasWhereClause()) {
                ContentAssistVisitor.this.addProposal("GROUP BY");
                if (!expression.hasGroupByClause()) {
                    ContentAssistVisitor.this.addProposal("HAVING");
                    if (!expression.hasHavingClause()) {
                        ContentAssistVisitor.this.addProposal("ORDER BY");
                    }
                }
            }
        }

        public WhereClauseSelectStatementHelper getNextHelper() {
            return ContentAssistVisitor.this.whereClauseSelectStatementHelper();
        }

        public SelectClauseSelectStatementHelper getPreviousHelper() {
            return ContentAssistVisitor.this.selectClauseSelectStatementHelper();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GroupByClauseCollectionHelper
    implements CollectionExpressionHelper<GroupByClause> {
        private GroupByClauseCollectionHelper() {
        }

        @Override
        public void addAtTheEndOfChild(GroupByClause expression, Expression child, int index) {
        }

        @Override
        public void addProposals(GroupByClause expression, int index) {
            ContentAssistVisitor.this.addAllIdentificationVariables(expression);
        }

        @Override
        public CollectionExpression buildCollectionExpression(GroupByClause expression) {
            CollectionExpression collectionExpression = ContentAssistVisitor.this.collectionExpression(expression.getGroupByItems());
            if (collectionExpression == null) {
                collectionExpression = expression.buildCollectionExpression();
            }
            return collectionExpression;
        }

        @Override
        public boolean hasDelimiterAfterIdentifier(GroupByClause expression) {
            return expression.hasSpaceAfterGroupBy();
        }

        @Override
        public int maxCollectionSize(GroupByClause expression) {
            return Integer.MAX_VALUE;
        }

        @Override
        public int preExpressionLength(GroupByClause expression) {
            return 0;
        }

        @Override
        public JPQLQueryBNF queryBNF(GroupByClause expression, int index) {
            return AbstractExpression.queryBNF("groupby_item");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GroupByClauseSelectStatementHelper
    extends AbstractGroupByClauseSelectStatementHelper<SelectStatement> {
        private GroupByClauseSelectStatementHelper() {
        }

        @Override
        public void appendNextClauseProposals(SelectStatement expression, GroupByClause clause, int position, boolean complete) {
            if (complete || ContentAssistVisitor.this.isAppendable(clause)) {
                ContentAssistVisitor.this.addProposal("HAVING");
                if (!expression.hasHavingClause()) {
                    ContentAssistVisitor.this.addProposal("ORDER BY");
                }
            }
        }

        public HavingClauseSelectStatementHelper getNextHelper() {
            return ContentAssistVisitor.this.havingClauseSelectStatementHelper();
        }

        public WhereClauseSelectStatementHelper getPreviousHelper() {
            return ContentAssistVisitor.this.whereClauseSelectStatementHelper();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HavingClauseHelper
    implements ClauseHelper<HavingClause> {
        private HavingClauseHelper() {
        }

        @Override
        public void addAtTheEndOfExpression(HavingClause expression) {
            ContentAssistVisitor.this.addAllAggregates("conditional_expression");
        }

        @Override
        public void addProposals(HavingClause expression) {
            ContentAssistVisitor.this.addAllIdentificationVariables(expression);
            ContentAssistVisitor.this.addAllFunctions("conditional_expression");
        }

        @Override
        public Expression getClauseExpression(HavingClause expression) {
            return expression.getConditionalExpression();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HavingClauseSelectStatementHelper
    extends AbstractHavingClauseSelectStatementHelper<SelectStatement> {
        private HavingClauseSelectStatementHelper() {
        }

        @Override
        public void appendNextClauseProposals(SelectStatement expression, HavingClause clause, int position, boolean complete) {
            if (complete || ContentAssistVisitor.this.isAppendable(clause)) {
                ContentAssistVisitor.this.addProposal("ORDER BY");
            }
        }

        public OrderByClauseSelectStatementHelper getNextHelper() {
            return ContentAssistVisitor.this.orderByClauseSelectStatementHelper();
        }

        public GroupByClauseSelectStatementHelper getPreviousHelper() {
            return ContentAssistVisitor.this.groupByClauseSelectStatementHelper();
        }

        @Override
        public boolean hasSpaceAfterClause(SelectStatement expression) {
            return expression.hasSpaceBeforeOrderBy();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum IdentificationVariableType {
        ALL,
        COLLECTION,
        LEFT,
        LEFT_COLLECTION,
        NONE,
        RESULT_VARIABLE;

    }

    private class IncompleteCollectionExpressionVisitor
    extends CompletenessVisitor {
        private boolean insideCollection;

        private IncompleteCollectionExpressionVisitor() {
        }

        public void visit(CollectionExpression expression) {
            int lastIndex = expression.childrenSize() - 1;
            this.insideCollection = true;
            if (!expression.hasComma(lastIndex - 1)) {
                expression.getChild(lastIndex).accept(this);
            }
            this.insideCollection = false;
        }

        public void visit(FromClause expression) {
            expression.getDeclaration().accept(this);
        }

        public void visit(GroupByClause expression) {
            expression.getGroupByItems().accept(this);
        }

        public void visit(HavingClause expression) {
            expression.getConditionalExpression().accept(this);
        }

        public void visit(IdentificationVariable expression) {
            this.complete = true;
        }

        public void visit(IdentificationVariableDeclaration expression) {
            if (this.insideCollection && !expression.hasJoins()) {
                expression.getRangeVariableDeclaration().accept(this);
            }
        }

        public void visit(RangeVariableDeclaration expression) {
            if (this.insideCollection) {
                boolean bl = this.complete = !expression.hasAs() && !expression.hasIdentificationVariable();
                if (!this.complete) {
                    this.complete = expression.toParsedText().equalsIgnoreCase("GROUP B") || expression.toParsedText().equalsIgnoreCase("ORDER B");
                }
            }
        }

        public void visit(WhereClause expression) {
            expression.getConditionalExpression().accept(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JoinCollectionHelper
    implements CollectionExpressionHelper<IdentificationVariableDeclaration> {
        private JoinCollectionHelper() {
        }

        @Override
        public void addAtTheEndOfChild(IdentificationVariableDeclaration expression, Expression child, int index) {
        }

        @Override
        public void addProposals(IdentificationVariableDeclaration expression, int index) {
            ContentAssistVisitor.this.addJoinIdentifiers();
        }

        @Override
        public CollectionExpression buildCollectionExpression(IdentificationVariableDeclaration expression) {
            CollectionExpression collectionExpression = ContentAssistVisitor.this.collectionExpression(expression.getJoins());
            if (collectionExpression == null) {
                collectionExpression = expression.buildCollectionExpression();
            }
            return collectionExpression;
        }

        @Override
        public boolean hasDelimiterAfterIdentifier(IdentificationVariableDeclaration expression) {
            return expression.hasSpace();
        }

        @Override
        public int maxCollectionSize(IdentificationVariableDeclaration expression) {
            return Integer.MAX_VALUE;
        }

        @Override
        public int preExpressionLength(IdentificationVariableDeclaration expression) {
            return ContentAssistVisitor.this.length(expression.getRangeVariableDeclaration());
        }

        @Override
        public JPQLQueryBNF queryBNF(IdentificationVariableDeclaration expression, int index) {
            return AbstractExpression.queryBNF("join*");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface MappingCollector {
        public Collection<IMapping> buildProposals();
    }

    private class MappingFilterBuilder
    extends AbstractTraverseParentVisitor {
        Filter<IMapping> filter;

        private MappingFilterBuilder() {
        }

        public void visit(CollectionMemberDeclaration expression) {
            this.filter = ContentAssistVisitor.this.mappingCollectionFilter();
        }

        public void visit(CollectionValuedPathExpression expression) {
            this.filter = ContentAssistVisitor.this.mappingCollectionFilter();
        }

        public void visit(Join expression) {
            this.filter = ContentAssistVisitor.this.mappingCollectionFilter();
        }

        public void visit(JoinFetch expression) {
            this.filter = ContentAssistVisitor.this.mappingCollectionFilter();
        }

        public void visit(JPQLExpression expression) {
            this.filter = ContentAssistVisitor.this.mappingPropertyFilter();
        }

        public void visit(SizeExpression expression) {
            this.filter = ContentAssistVisitor.this.mappingCollectionFilter();
        }

        public void visit(TreatExpression expression) {
            this.filter = ContentAssistVisitor.this.mappingCollectionFilter();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MappingTypeFilter
    implements Filter<IMapping> {
        private final IType type;

        MappingTypeFilter(IType type) {
            this.type = type;
        }

        @Override
        public boolean accept(IMapping value) {
            if (MappingTypeHelper.isRelationshipMapping(value) && !MappingTypeHelper.isCollectionMapping(value)) {
                return true;
            }
            IType mappingType = value.getType();
            mappingType = ContentAssistVisitor.this.getTypeHelper().convertPrimitive(mappingType);
            return mappingType.isAssignableTo(this.type);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OrderByClauseCollectionHelper
    implements CollectionExpressionHelper<OrderByClause> {
        private OrderByClauseCollectionHelper() {
        }

        @Override
        public void addAtTheEndOfChild(OrderByClause expression, Expression child, int index) {
            ContentAssistVisitor.this.addProposal("ASC");
            ContentAssistVisitor.this.addProposal("DESC");
        }

        @Override
        public void addProposals(OrderByClause expression, int index) {
            ContentAssistVisitor.this.addAllIdentificationVariables(expression);
            ContentAssistVisitor.this.addResultVariables(expression);
        }

        @Override
        public CollectionExpression buildCollectionExpression(OrderByClause expression) {
            CollectionExpression collectionExpression = ContentAssistVisitor.this.collectionExpression(expression.getOrderByItems());
            if (collectionExpression == null) {
                collectionExpression = expression.buildCollectionExpression();
            }
            return collectionExpression;
        }

        @Override
        public boolean hasDelimiterAfterIdentifier(OrderByClause expression) {
            return expression.hasSpaceAfterOrderBy();
        }

        @Override
        public int maxCollectionSize(OrderByClause expression) {
            return Integer.MAX_VALUE;
        }

        @Override
        public int preExpressionLength(OrderByClause expression) {
            return 0;
        }

        @Override
        public JPQLQueryBNF queryBNF(OrderByClause expression, int index) {
            return AbstractExpression.queryBNF("orderby_item");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OrderByClauseSelectStatementHelper
    implements SelectStatementHelper<SelectStatement, OrderByClause> {
        private OrderByClauseSelectStatementHelper() {
        }

        @Override
        public void addClauseProposal() {
            ContentAssistVisitor.this.addProposal("ORDER BY");
        }

        @Override
        public void appendNextClauseProposals(SelectStatement expression, OrderByClause clause, int position, boolean complete) {
        }

        @Override
        public OrderByClause getClause(SelectStatement expression) {
            return (OrderByClause)expression.getOrderByClause();
        }

        @Override
        public Expression getClauseExpression(OrderByClause clause) {
            return clause.getOrderByItems();
        }

        @Override
        public SelectStatementHelper<? extends AbstractSelectStatement, ? extends Expression> getNextHelper() {
            return null;
        }

        public HavingClauseSelectStatementHelper getPreviousHelper() {
            return ContentAssistVisitor.this.havingClauseSelectStatementHelper();
        }

        @Override
        public boolean hasClause(SelectStatement expression) {
            return expression.hasOrderByClause();
        }

        @Override
        public boolean hasClauseExpression(OrderByClause clause) {
            return clause.hasOrderByItems();
        }

        @Override
        public boolean hasSpaceAfterClause(SelectStatement expression) {
            return false;
        }

        @Override
        public boolean hasSpaceBeforeClause(SelectStatement expression) {
            return expression.hasSpaceBeforeOrderBy();
        }

        @Override
        public boolean isClauseExpressionComplete(Expression expression) {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PropertyMappingFilter
    implements Filter<IMapping> {
        private PropertyMappingFilter() {
        }

        @Override
        public boolean accept(IMapping value) {
            return !MappingTypeHelper.isTransientMapping(value) && !MappingTypeHelper.isCollectionMapping(value);
        }
    }

    private class RangeVariableDeclarationVisitor
    extends AbstractExpressionVisitor {
        RangeVariableDeclaration expression;

        private RangeVariableDeclarationVisitor() {
        }

        public void visit(RangeVariableDeclaration expression) {
            this.expression = expression;
        }
    }

    private class ResultVariableVisitor
    extends AbstractExpressionVisitor {
        private ResultVariable expression;

        private ResultVariableVisitor() {
        }

        public void visit(ResultVariable expression) {
            this.expression = expression;
        }
    }

    private class SelectClauseCompletenessVisitor
    extends CompletenessVisitor {
        private SelectClauseCompletenessVisitor() {
        }

        public void visit(AbsExpression expression) {
            this.visitAbstractSingleEncapsulatedExpression(expression);
        }

        public void visit(AdditionExpression expression) {
            this.visitArithmeticExpression(expression);
        }

        public void visit(AvgFunction expression) {
            this.visitAggregateFunction(expression);
        }

        public void visit(CaseExpression expression) {
            this.complete = expression.hasEnd();
        }

        public void visit(CoalesceExpression expression) {
            this.visitAbstractSingleEncapsulatedExpression(expression);
        }

        public void visit(CollectionExpression expression) {
            int lastIndex;
            AbstractExpression child;
            if (expression.endsWithComma()) {
                this.complete = true;
            }
            if (ContentAssistVisitor.this.isNull(child = (AbstractExpression)expression.getChild(lastIndex = expression.childrenSize() - 1))) {
                this.complete = false;
            } else {
                int length = expression.toActualText((Integer)ContentAssistVisitor.this.positionInCollections.peek()).length();
                if ((Integer)ContentAssistVisitor.this.corrections.peek() == length) {
                    int index = Math.max(0, (Integer)ContentAssistVisitor.this.positionInCollections.peek() - 1);
                    this.complete = expression.hasComma(index);
                } else {
                    child.accept(this);
                }
            }
        }

        public void visit(ConcatExpression expression) {
            this.visitAbstractSingleEncapsulatedExpression(expression);
        }

        public void visit(ConstructorExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(CountFunction expression) {
            this.visitAggregateFunction(expression);
        }

        public void visit(DateTime expression) {
            this.complete = expression.isJDBCDate() ? expression.toActualText().endsWith("}") : true;
        }

        public void visit(DivisionExpression expression) {
            this.visitArithmeticExpression(expression);
        }

        public void visit(EntryExpression expression) {
            this.visitEncapsulatedIdentificationVariableExpression(expression);
        }

        public void visit(FuncExpression expression) {
            this.visitAbstractSingleEncapsulatedExpression(expression);
        }

        public void visit(IdentificationVariable expression) {
            this.complete = true;
        }

        public void visit(IndexExpression expression) {
            this.visitAbstractSingleEncapsulatedExpression(expression);
        }

        public void visit(KeyExpression expression) {
            this.visitEncapsulatedIdentificationVariableExpression(expression);
        }

        public void visit(KeywordExpression expression) {
            this.complete = true;
        }

        public void visit(LengthExpression expression) {
            this.visitAbstractSingleEncapsulatedExpression(expression);
        }

        public void visit(LocateExpression expression) {
            this.visitAbstractTripleEncapsulatedExpression(expression);
        }

        public void visit(LowerExpression expression) {
            this.visitAbstractSingleEncapsulatedExpression(expression);
        }

        public void visit(MaxFunction expression) {
            this.visitAggregateFunction(expression);
        }

        public void visit(MinFunction expression) {
            this.visitAggregateFunction(expression);
        }

        public void visit(ModExpression expression) {
            this.visitAbstractDoubleEncapsulatedExpression(expression);
        }

        public void visit(MultiplicationExpression expression) {
            this.visitArithmeticExpression(expression);
        }

        public void visit(NullExpression expression) {
            this.complete = true;
        }

        public void visit(NullIfExpression expression) {
            this.visitAbstractDoubleEncapsulatedExpression(expression);
        }

        public void visit(ObjectExpression expression) {
            this.visitAbstractSingleEncapsulatedExpression(expression);
        }

        public void visit(ResultVariable expression) {
            this.complete = expression.hasResultVariable();
        }

        public void visit(SelectClause expression) {
            int position = ContentAssistVisitor.this.position(expression);
            if (position == "SELECT".length() + 1) {
                this.complete = true;
            } else {
                expression.getSelectExpression().accept(this);
            }
        }

        public void visit(SimpleSelectClause expression) {
            expression.getSelectExpression().accept(this);
        }

        public void visit(SizeExpression expression) {
            this.visitAbstractSingleEncapsulatedExpression(expression);
        }

        public void visit(SqrtExpression expression) {
            this.visitAbstractSingleEncapsulatedExpression(expression);
        }

        public void visit(StateFieldPathExpression expression) {
            this.complete = true;
        }

        public void visit(SubstringExpression expression) {
            this.visitAbstractTripleEncapsulatedExpression(expression);
        }

        public void visit(SubtractionExpression expression) {
            this.visitArithmeticExpression(expression);
        }

        public void visit(SumFunction expression) {
            this.visitAggregateFunction(expression);
        }

        public void visit(TrimExpression expression) {
            this.visitAbstractSingleEncapsulatedExpression(expression);
        }

        public void visit(TypeExpression expression) {
            this.visitAbstractSingleEncapsulatedExpression(expression);
        }

        public void visit(UpperExpression expression) {
            this.visitAbstractSingleEncapsulatedExpression(expression);
        }

        public void visit(ValueExpression expression) {
            this.visitEncapsulatedIdentificationVariableExpression(expression);
        }

        private void visitAbstractDoubleEncapsulatedExpression(AbstractDoubleEncapsulatedExpression expression) {
            this.visitAbstractEncapsulatedExpression(expression);
        }

        private void visitAbstractEncapsulatedExpression(AbstractEncapsulatedExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        private void visitAbstractSingleEncapsulatedExpression(AbstractSingleEncapsulatedExpression expression) {
            this.visitAbstractEncapsulatedExpression(expression);
        }

        private void visitAbstractTripleEncapsulatedExpression(AbstractTripleEncapsulatedExpression expression) {
            this.visitAbstractEncapsulatedExpression(expression);
        }

        private void visitAggregateFunction(AggregateFunction expression) {
            this.visitAbstractSingleEncapsulatedExpression(expression);
        }

        private void visitArithmeticExpression(ArithmeticExpression expression) {
            expression.getRightExpression().accept(this);
        }

        private void visitEncapsulatedIdentificationVariableExpression(EncapsulatedIdentificationVariableExpression expression) {
            this.visitAbstractSingleEncapsulatedExpression(expression);
        }
    }

    private class SelectClauseSelectStatementHelper
    extends AbstractSelectClauseSelectStatementHelper {
        private SelectClauseSelectStatementHelper() {
        }

        public FromClauseSelectStatementHelper getNextHelper() {
            return ContentAssistVisitor.this.fromClauseSelectStatementHelper();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface SelectStatementHelper<T extends AbstractSelectStatement, C extends Expression> {
        public void addClauseProposal();

        public void appendNextClauseProposals(T var1, C var2, int var3, boolean var4);

        public C getClause(T var1);

        public Expression getClauseExpression(C var1);

        public SelectStatementHelper<? extends AbstractSelectStatement, ? extends Expression> getNextHelper();

        public SelectStatementHelper<? extends AbstractSelectStatement, ? extends Expression> getPreviousHelper();

        public boolean hasClause(T var1);

        public boolean hasClauseExpression(C var1);

        public boolean hasSpaceAfterClause(T var1);

        public boolean hasSpaceBeforeClause(T var1);

        public boolean isClauseExpressionComplete(Expression var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SimpleFromClauseSelectStatementHelper
    extends AbstractFromClauseSelectStatementHelper<SimpleSelectStatement> {
        private SimpleFromClauseSelectStatementHelper() {
        }

        @Override
        protected boolean addAppendableToCollection(SimpleSelectStatement expression, int position) {
            if (ContentAssistVisitor.this.wordParser.endsWith(position, "GROUP") || ContentAssistVisitor.this.wordParser.endsWith(position, "GROUP B")) {
                if (!expression.hasWhereClause()) {
                    ContentAssistVisitor.this.proposals.addIdentifier("GROUP BY");
                }
                return true;
            }
            return false;
        }

        @Override
        protected void addClauseIdentifierProposals(SimpleSelectStatement expression) {
            ContentAssistVisitor.this.addProposal("WHERE");
            if (!expression.hasWhereClause()) {
                ContentAssistVisitor.this.addProposal("GROUP BY");
                if (!expression.hasGroupByClause()) {
                    ContentAssistVisitor.this.addProposal("HAVING");
                }
            }
        }

        public SimpleWhereClauseSelectStatementHelper getNextHelper() {
            return ContentAssistVisitor.this.simpleWhereClauseSelectStatementHelper();
        }

        public SimpleSelectClauseSelectStatementHelper getPreviousHelper() {
            return ContentAssistVisitor.this.simpleSelectClauseSelectStatementHelper();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SimpleGroupByClauseSelectStatementHelper
    extends AbstractGroupByClauseSelectStatementHelper<SimpleSelectStatement> {
        private SimpleGroupByClauseSelectStatementHelper() {
        }

        @Override
        public void appendNextClauseProposals(SimpleSelectStatement expression, GroupByClause clause, int position, boolean complete) {
            if (complete || ContentAssistVisitor.this.isAppendable(clause)) {
                ContentAssistVisitor.this.addProposal("HAVING");
            }
        }

        public SimpleHavingClauseSelectStatementHelper getNextHelper() {
            return ContentAssistVisitor.this.simpleHavingClauseSelectStatementHelper();
        }

        public SimpleWhereClauseSelectStatementHelper getPreviousHelper() {
            return ContentAssistVisitor.this.simpleWhereClauseSelectStatementHelper();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SimpleHavingClauseSelectStatementHelper
    extends AbstractHavingClauseSelectStatementHelper<SimpleSelectStatement> {
        private SimpleHavingClauseSelectStatementHelper() {
        }

        @Override
        public void appendNextClauseProposals(SimpleSelectStatement expression, HavingClause clause, int position, boolean complete) {
        }

        @Override
        public SelectStatementHelper<AbstractSelectStatement, Expression> getNextHelper() {
            return null;
        }

        public SimpleGroupByClauseSelectStatementHelper getPreviousHelper() {
            return ContentAssistVisitor.this.simpleGroupByClauseSelectStatementHelper();
        }

        @Override
        public boolean hasSpaceAfterClause(SimpleSelectStatement expression) {
            return false;
        }
    }

    private class SimpleSelectClauseSelectStatementHelper
    extends AbstractSelectClauseSelectStatementHelper {
        private SimpleSelectClauseSelectStatementHelper() {
        }

        public SimpleFromClauseSelectStatementHelper getNextHelper() {
            return ContentAssistVisitor.this.simpleFromClauseSelectStatementHelper();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SimpleWhereClauseSelectStatementHelper
    extends AbstractWhereClauseSelectStatementHelper<SimpleSelectStatement> {
        private SimpleWhereClauseSelectStatementHelper() {
        }

        @Override
        public void appendNextClauseProposals(SimpleSelectStatement expression, WhereClause clause, int position, boolean complete) {
            if (complete || ContentAssistVisitor.this.isAppendable(clause)) {
                ContentAssistVisitor.this.addProposal("GROUP BY");
                if (!expression.hasGroupByClause()) {
                    ContentAssistVisitor.this.addProposal("HAVING");
                }
            }
        }

        public SimpleGroupByClauseSelectStatementHelper getNextHelper() {
            return ContentAssistVisitor.this.simpleGroupByClauseSelectStatementHelper();
        }

        public SimpleFromClauseSelectStatementHelper getPreviousHelper() {
            return ContentAssistVisitor.this.simpleFromClauseSelectStatementHelper();
        }
    }

    private class SubqueryVisitor
    extends AbstractTraverseParentVisitor {
        SimpleSelectStatement expression;

        private SubqueryVisitor() {
        }

        public void visit(SimpleSelectStatement expression) {
            this.expression = expression;
        }
    }

    private class TrailingCompletenessVisitor
    extends CompletenessVisitor {
        private TrailingCompletenessVisitor() {
        }

        public void visit(AbsExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(AbstractSchemaName expression) {
            this.complete = true;
        }

        public void visit(AdditionExpression expression) {
            this.complete = expression.hasRightExpression();
            if (this.complete) {
                expression.getRightExpression().accept(this);
            }
        }

        public void visit(AllOrAnyExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(AndExpression expression) {
            this.complete = expression.hasRightExpression();
            if (this.complete) {
                expression.getRightExpression().accept(this);
            }
        }

        public void visit(ArithmeticFactor expression) {
            this.complete = expression.hasExpression();
            if (this.complete) {
                expression.getExpression().accept(this);
            }
        }

        public void visit(AvgFunction expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(BetweenExpression expression) {
            boolean bl = this.complete = expression.hasAnd() && expression.hasUpperBoundExpression();
            if (this.complete) {
                expression.getUpperBoundExpression().accept(this);
            }
        }

        public void visit(CaseExpression expression) {
            this.complete = expression.hasEnd();
        }

        public void visit(CoalesceExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(CollectionMemberDeclaration expression) {
            this.complete = expression.hasIdentificationVariable();
        }

        public void visit(CollectionMemberExpression expression) {
            this.complete = expression.hasCollectionValuedPathExpression();
            if (this.complete) {
                expression.getCollectionValuedPathExpression().accept(this);
            }
        }

        public void visit(CollectionValuedPathExpression expression) {
            this.complete = !expression.endsWithDot();
        }

        public void visit(ComparisonExpression expression) {
            this.complete = expression.hasRightExpression();
            if (this.complete) {
                expression.getRightExpression().accept(this);
            }
        }

        public void visit(ConcatExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(ConstructorExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(CountFunction expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(DateTime expression) {
            this.complete = expression.isJDBCDate() ? expression.toActualText().endsWith("}") : true;
        }

        public void visit(DivisionExpression expression) {
            this.complete = expression.hasRightExpression();
            if (this.complete) {
                expression.getRightExpression().accept(this);
            }
        }

        public void visit(EmptyCollectionComparisonExpression expression) {
            this.complete = true;
        }

        public void visit(EntityTypeLiteral expression) {
            this.complete = true;
        }

        public void visit(EntryExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(ExistsExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(FuncExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(IdentificationVariable expression) {
            this.complete = true;
        }

        public void visit(IdentificationVariableDeclaration expression) {
            if (expression.hasJoins()) {
                expression.getJoins().accept(this);
            } else {
                expression.getRangeVariableDeclaration().accept(this);
            }
        }

        public void visit(IndexExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(InExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(InputParameter expression) {
            this.complete = true;
        }

        public void visit(Join expression) {
            this.complete = expression.hasIdentificationVariable();
        }

        public void visit(JoinFetch expression) {
            this.complete = expression.hasJoinAssociationPath();
        }

        public void visit(KeyExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(KeywordExpression expression) {
            this.complete = true;
        }

        public void visit(LengthExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(LikeExpression expression) {
            this.complete = expression.hasEscape() ? expression.hasEscapeCharacter() : expression.hasPatternValue();
        }

        public void visit(LocateExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(LowerExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(MaxFunction expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(MinFunction expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(ModExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(MultiplicationExpression expression) {
            this.complete = expression.hasRightExpression();
            if (this.complete) {
                expression.getRightExpression().accept(this);
            }
        }

        public void visit(NotExpression expression) {
            this.complete = expression.hasExpression();
        }

        public void visit(NullComparisonExpression expression) {
            this.complete = true;
        }

        public void visit(NullIfExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(NumericLiteral expression) {
            this.complete = true;
        }

        public void visit(ObjectExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(OrderByItem expression) {
            this.complete = true;
        }

        public void visit(OrExpression expression) {
            this.complete = expression.hasRightExpression();
            if (this.complete) {
                expression.getRightExpression().accept(this);
            }
        }

        public void visit(RangeVariableDeclaration expression) {
            this.complete = expression.hasIdentificationVariable();
        }

        public void visit(ResultVariable expression) {
            this.complete = expression.hasResultVariable();
        }

        public void visit(SizeExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(SqrtExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(StateFieldPathExpression expression) {
            this.complete = true;
        }

        public void visit(StringLiteral expression) {
            this.complete = expression.hasCloseQuote();
        }

        public void visit(SubExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(SubstringExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(SubtractionExpression expression) {
            this.complete = expression.hasRightExpression();
            if (this.complete) {
                expression.getRightExpression().accept(this);
            }
        }

        public void visit(SumFunction expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(TreatExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(TrimExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(TypeExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(UpdateItem expression) {
            this.complete = expression.hasNewValue();
            if (this.complete) {
                expression.getNewValue().accept(this);
            }
        }

        public void visit(UpperExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(ValueExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(WhenClause expression) {
            this.complete = expression.hasThenExpression();
            if (this.complete) {
                expression.getThenExpression().accept(this);
            }
        }

        public void visit(WhereClause expression) {
            this.complete = expression.hasConditionalExpression();
            if (this.complete) {
                expression.getConditionalExpression().accept(this);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TripleEncapsulatedCollectionHelper
    implements CollectionExpressionHelper<AbstractTripleEncapsulatedExpression> {
        private TripleEncapsulatedCollectionHelper() {
        }

        @Override
        public void addAtTheEndOfChild(AbstractTripleEncapsulatedExpression expression, Expression child, int index) {
            if (this.queryBNF(expression, index).handleAggregate()) {
                ContentAssistVisitor.this.addAllAggregates(this.queryBNF(expression, index));
            }
        }

        @Override
        public void addProposals(AbstractTripleEncapsulatedExpression expression, int index) {
            ContentAssistVisitor.this.addAllIdentificationVariables(expression);
            ContentAssistVisitor.this.addAllFunctions(this.queryBNF(expression, index));
        }

        @Override
        public CollectionExpression buildCollectionExpression(AbstractTripleEncapsulatedExpression expression) {
            return expression.buildCollectionExpression();
        }

        @Override
        public boolean hasDelimiterAfterIdentifier(AbstractTripleEncapsulatedExpression expression) {
            return expression.hasLeftParenthesis();
        }

        @Override
        public int maxCollectionSize(AbstractTripleEncapsulatedExpression expression) {
            return 3;
        }

        @Override
        public int preExpressionLength(AbstractTripleEncapsulatedExpression expression) {
            return 0;
        }

        @Override
        public JPQLQueryBNF queryBNF(AbstractTripleEncapsulatedExpression expression, int index) {
            return expression.parameterExpressionBNF(index);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UpdateItemCollectionHelper
    implements CollectionExpressionHelper<UpdateClause> {
        private UpdateItemCollectionHelper() {
        }

        @Override
        public void addAtTheEndOfChild(UpdateClause expression, Expression child, int index) {
            ContentAssistVisitor.this.addAllAggregates("new_value");
        }

        @Override
        public void addProposals(UpdateClause expression, int index) {
            ContentAssistVisitor.this.addAllIdentificationVariables(expression);
        }

        @Override
        public CollectionExpression buildCollectionExpression(UpdateClause expression) {
            CollectionExpression collectionExpression = ContentAssistVisitor.this.collectionExpression(expression.getUpdateItems());
            if (collectionExpression == null) {
                collectionExpression = expression.buildCollectionExpression();
            }
            return collectionExpression;
        }

        @Override
        public boolean hasDelimiterAfterIdentifier(UpdateClause expression) {
            return true;
        }

        @Override
        public int maxCollectionSize(UpdateClause expression) {
            return Integer.MAX_VALUE;
        }

        @Override
        public int preExpressionLength(UpdateClause expression) {
            return "UPDATE".length() + 1 + ContentAssistVisitor.this.length(expression.getRangeVariableDeclaration()) + 1 + "SET".length();
        }

        @Override
        public JPQLQueryBNF queryBNF(UpdateClause expression, int index) {
            return AbstractExpression.queryBNF("new_value");
        }
    }

    private class VisitParentVisitor
    extends AnonymousExpressionVisitor {
        private VisitParentVisitor() {
        }

        protected void visit(Expression expression) {
            expression.getParent().accept(ContentAssistVisitor.this);
        }

        public void visit(InExpression expression) {
            int position = ContentAssistVisitor.this.position(expression) - (Integer)ContentAssistVisitor.this.corrections.peek();
            int length = 0;
            if (expression.hasExpression()) {
                length += ContentAssistVisitor.this.length(expression.getExpression()) + 1;
            }
            if (ContentAssistVisitor.this.isPositionWithin(position, length, expression.getIdentifier())) {
                boolean hasOnlyIdentifier;
                boolean bl = hasOnlyIdentifier = !expression.hasExpression() && !expression.hasInItems();
                if (hasOnlyIdentifier) {
                    ContentAssistVisitor.this.corrections.add(ContentAssistVisitor.this.position(expression));
                }
                super.visit(expression);
                if (hasOnlyIdentifier) {
                    ContentAssistVisitor.this.corrections.pop();
                }
            } else {
                super.visit(expression);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WhereClauseHelper
    implements ClauseHelper<WhereClause> {
        private WhereClauseHelper() {
        }

        @Override
        public void addAtTheEndOfExpression(WhereClause expression) {
            ContentAssistVisitor.this.addAllAggregates("conditional_expression");
            if (ContentAssistVisitor.this.isCompoundable(expression.getConditionalExpression())) {
                ContentAssistVisitor.this.addAllCompounds("conditional_expression");
            }
        }

        @Override
        public void addProposals(WhereClause expression) {
            ContentAssistVisitor.this.addAllIdentificationVariables(expression);
            ContentAssistVisitor.this.addAllFunctions("conditional_expression");
        }

        @Override
        public Expression getClauseExpression(WhereClause expression) {
            return expression.getConditionalExpression();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WhereClauseSelectStatementHelper
    extends AbstractWhereClauseSelectStatementHelper<SelectStatement> {
        private WhereClauseSelectStatementHelper() {
        }

        @Override
        public void appendNextClauseProposals(SelectStatement expression, WhereClause clause, int position, boolean complete) {
            if (complete || ContentAssistVisitor.this.isAppendable(clause)) {
                ContentAssistVisitor.this.addProposal("GROUP BY");
                if (!expression.hasGroupByClause()) {
                    ContentAssistVisitor.this.addProposal("HAVING");
                    if (!expression.hasHavingClause()) {
                        ContentAssistVisitor.this.addProposal("ORDER BY");
                    }
                }
            }
        }

        public GroupByClauseSelectStatementHelper getNextHelper() {
            return ContentAssistVisitor.this.groupByClauseSelectStatementHelper();
        }

        public FromClauseSelectStatementHelper getPreviousHelper() {
            return ContentAssistVisitor.this.fromClauseSelectStatementHelper();
        }
    }
}

