/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.partitioning;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.descriptors.partitioning.PartitioningPolicy;
import org.eclipse.persistence.descriptors.partitioning.RangePartition;
import org.eclipse.persistence.descriptors.partitioning.RangePartitioningPolicy;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.partitioning.FieldPartitioningMetadata;
import org.eclipse.persistence.internal.jpa.metadata.partitioning.RangePartitionMetadata;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetConstructorFor;
import org.eclipse.persistence.internal.security.PrivilegedInvokeConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RangePartitioningMetadata
extends FieldPartitioningMetadata {
    protected List<RangePartitionMetadata> partitions;

    public RangePartitioningMetadata() {
        super("<range-partitioning>");
    }

    public RangePartitioningMetadata(MetadataAnnotation annotation, MetadataAccessor accessor) {
        super(annotation, accessor);
        this.partitions = new ArrayList<RangePartitionMetadata>();
        for (Object partitionAnnotation : (Object[])annotation.getAttributeArray("partitions")) {
            this.partitions.add(new RangePartitionMetadata((MetadataAnnotation)partitionAnnotation, accessor));
        }
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof RangePartitioningMetadata) {
            RangePartitioningMetadata policy = (RangePartitioningMetadata)objectToCompare;
            return this.valuesMatch(this.partitions, policy.getPartitions());
        }
        return false;
    }

    private Object initObject(Class type, String value) {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                Constructor constructor = (Constructor)AccessController.doPrivileged(new PrivilegedGetConstructorFor(type, new Class[]{String.class}, false));
                return AccessController.doPrivileged(new PrivilegedInvokeConstructor(constructor, new Object[]{value}));
            }
            catch (PrivilegedActionException exception) {}
        } else {
            try {
                Constructor constructor = PrivilegedAccessHelper.getConstructorFor((Class)type, (Class[])new Class[]{String.class}, (boolean)false);
                return PrivilegedAccessHelper.invokeConstructor((Constructor)constructor, (Object[])new Object[]{value});
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return value;
    }

    @Override
    public PartitioningPolicy buildPolicy() {
        RangePartitioningPolicy policy = new RangePartitioningPolicy();
        super.buildPolicy((PartitioningPolicy)policy);
        Class type = String.class;
        if (this.partitionValueType != null) {
            type = this.getJavaClass(this.getMetadataClass(this.partitionValueType));
        }
        for (RangePartitionMetadata partition : this.getPartitions()) {
            Comparable startValue = null;
            if (partition.getStartValue() != null) {
                startValue = (Comparable)this.initObject(type, partition.getStartValue());
            }
            Comparable endValue = null;
            if (partition.getEndValue() != null) {
                endValue = (Comparable)this.initObject(type, partition.getEndValue());
            }
            policy.addPartition(new RangePartition(partition.getConnectionPool(), startValue, endValue));
        }
        return policy;
    }

    public List<RangePartitionMetadata> getPartitions() {
        return this.partitions;
    }

    public void setPartitions(List<RangePartitionMetadata> partitions) {
        this.partitions = partitions;
    }
}

