/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import org.eclipse.persistence.indirection.IndirectCollection;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;

public abstract class DeferrableChangeRecord
extends ChangeRecord {
    protected transient Object originalCollection;
    protected transient Object latestCollection;
    protected boolean isDeferred = false;

    public DeferrableChangeRecord() {
    }

    public DeferrableChangeRecord(ObjectChangeSet owner) {
        this.owner = owner;
    }

    public boolean isDeferred() {
        return this.isDeferred;
    }

    public void setIsDeferred(boolean isDeferred) {
        this.isDeferred = isDeferred;
    }

    public Object getLatestCollection() {
        return this.latestCollection;
    }

    public Object getOriginalCollection() {
        return this.originalCollection;
    }

    public void setLatestCollection(Object latestCollection) {
        this.latestCollection = latestCollection;
    }

    public void setOriginalCollection(Object originalCollection) {
        this.originalCollection = originalCollection;
    }

    public abstract void internalRecreateOriginalCollection(Object var1, AbstractSession var2);

    public abstract void clearChanges();

    public void recreateOriginalCollection(Object currentCollection, AbstractSession session) {
        if (currentCollection == null) {
            this.setOriginalCollection(null);
            return;
        }
        if (currentCollection instanceof IndirectCollection) {
            this.setOriginalCollection(((IndirectCollection)currentCollection).getDelegateObject());
        } else {
            this.setOriginalCollection(currentCollection);
        }
        this.internalRecreateOriginalCollection(this.originalCollection, session);
        this.clearChanges();
    }

    public Object getOldValue() {
        if (this.originalCollection != null) {
            return this.originalCollection;
        }
        if (this.getOwner() != null) {
            Object obj = ((ObjectChangeSet)this.getOwner()).getUnitOfWorkClone();
            AbstractSession session = ((UnitOfWorkChangeSet)this.getOwner().getUOWChangeSet()).getSession();
            if (obj != null && session != null) {
                Object currentCollection = this.mapping.getAttributeValueFromObject(obj);
                ContainerPolicy cp = this.mapping.getContainerPolicy();
                Object cloneCurrentCollection = cp.containerInstance(cp.sizeFor(currentCollection));
                Object valuesIterator = cp.iteratorFor(currentCollection);
                while (cp.hasNext(valuesIterator)) {
                    Object member = cp.next(valuesIterator, session);
                    cp.addInto(cp.keyFromIterator(valuesIterator), member, cloneCurrentCollection, session);
                }
                return this.getOldValue(cloneCurrentCollection, session);
            }
        }
        return null;
    }

    public Object getOldValue(Object currentCollection, AbstractSession session) {
        if (currentCollection != null) {
            if (currentCollection instanceof IndirectCollection) {
                currentCollection = ((IndirectCollection)currentCollection).getDelegateObject();
            }
            this.internalRecreateOriginalCollection(currentCollection, session);
        }
        return currentCollection;
    }
}

