/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.MarshalException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.attachment.AttachmentMarshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.validation.Schema;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.jaxb.WrappedValue;
import org.eclipse.persistence.internal.jaxb.many.ManyValue;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.record.CharacterEscapeHandlerWrapper;
import org.eclipse.persistence.internal.oxm.record.namespaces.MapNamespacePrefixMapper;
import org.eclipse.persistence.internal.oxm.record.namespaces.NamespacePrefixMapperWrapper;
import org.eclipse.persistence.jaxb.JAXBContext;
import org.eclipse.persistence.jaxb.JAXBErrorHandler;
import org.eclipse.persistence.jaxb.JAXBIntrospector;
import org.eclipse.persistence.jaxb.JAXBMarshalListener;
import org.eclipse.persistence.jaxb.JAXBTypeElement;
import org.eclipse.persistence.jaxb.TypeMappingInfo;
import org.eclipse.persistence.jaxb.attachment.AttachmentMarshallerAdapter;
import org.eclipse.persistence.oxm.CharacterEscapeHandler;
import org.eclipse.persistence.oxm.MediaType;
import org.eclipse.persistence.oxm.NamespacePrefixMapper;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLMarshalListener;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.attachment.XMLAttachmentMarshaller;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.eclipse.persistence.oxm.record.XMLEventWriterRecord;
import org.eclipse.persistence.oxm.record.XMLStreamWriterRecord;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;

public class JAXBMarshaller
implements Marshaller {
    private ValidationEventHandler validationEventHandler = JAXBContext.DEFAULT_VALIDATION_EVENT_HANDER;
    private XMLMarshaller xmlMarshaller;
    private JAXBContext jaxbContext;
    public static final String XML_JAVATYPE_ADAPTERS = "xml-javatype-adapters";
    private static final String SUN_NAMESPACE_PREFIX_MAPPER = "com.sun.xml.bind.namespacePrefixMapper";
    private static final String SUN_JSE_NAMESPACE_PREFIX_MAPPER = "com.sun.xml.internal.bind.namespacePrefixMapper";
    private static final String SUN_INDENT_STRING = "com.sun.xml.bind.indentString";
    private static final String SUN_JSE_INDENT_STRING = "com.sun.xml.internal.bind.indentString";
    private static final String SUN_CHARACTER_ESCAPE_HANDLER = "com.sun.xml.bind.marshaller.CharacterEscapeHandler";
    private static final String SUN_JSE_CHARACTER_ESCAPE_HANDLER = "com.sun.xml.internal.bind.marshaller.CharacterEscapeHandler";
    private static final String XML_DECLARATION = "com.sun.xml.bind.xmlDeclaration";
    private static final String XML_HEADERS = "com.sun.xml.bind.xmlHeaders";
    private static final String OBJECT_IDENTITY_CYCLE_DETECTION = "com.sun.xml.bind.objectIdentitityCycleDetection";

    public JAXBMarshaller(XMLMarshaller newXMLMarshaller, JAXBIntrospector newIntrospector) {
        this.xmlMarshaller = newXMLMarshaller;
        this.xmlMarshaller.setEncoding("UTF-8");
        this.xmlMarshaller.setFormattedOutput(false);
        JAXBMarshalListener listener = new JAXBMarshalListener(this);
        this.xmlMarshaller.setMarshalListener((XMLMarshalListener)listener);
        this.xmlMarshaller.getProperties().put("jaxb.marshaller", this);
    }

    private XMLRoot createXMLRootFromJAXBElement(JAXBElement elt) {
        Type objectType;
        Class theClass;
        XMLRoot xmlroot = new XMLRoot();
        Object objectValue = elt.getValue();
        xmlroot.setObject(objectValue);
        QName qname = elt.getName();
        xmlroot.setLocalName(qname.getLocalPart());
        xmlroot.setNamespaceURI(qname.getNamespaceURI());
        xmlroot.setDeclaredType(elt.getDeclaredType());
        xmlroot.setNil(elt.isNil());
        if (elt.getDeclaredType() == ClassConstants.ABYTE || elt.getDeclaredType() == ClassConstants.APBYTE || elt.getDeclaredType().getCanonicalName().equals("javax.activation.DataHandler") || elt.getDeclaredType().isEnum()) {
            Class generatedClass = this.getClassToGeneratedClasses().get(elt.getDeclaredType().getCanonicalName());
            if (!elt.getDeclaredType().isEnum()) {
                xmlroot.setSchemaType(XMLConstants.BASE_64_BINARY_QNAME);
            }
            if (generatedClass != null && WrappedValue.class.isAssignableFrom(generatedClass)) {
                ClassDescriptor desc = this.xmlMarshaller.getXMLContext().getSession(generatedClass).getDescriptor(generatedClass);
                Object newObject = desc.getInstantiationPolicy().buildNewInstance();
                ((WrappedValue)((Object)newObject)).setValue(objectValue);
                xmlroot.setObject(newObject);
                return xmlroot;
            }
        } else {
            xmlroot.setSchemaType((QName)XMLConversionManager.getDefaultJavaTypes().get(elt.getDeclaredType()));
        }
        if (elt instanceof WrappedValue) {
            xmlroot.setObject((Object)elt);
            return xmlroot;
        }
        Map<QName, Class> qNameToGeneratedClasses = this.jaxbContext.getQNameToGeneratedClasses();
        if (qNameToGeneratedClasses != null && (theClass = qNameToGeneratedClasses.get(qname)) != null && WrappedValue.class.isAssignableFrom(theClass)) {
            ClassDescriptor desc = this.xmlMarshaller.getXMLContext().getSession(theClass).getDescriptor(theClass);
            Object newObject = desc.getInstantiationPolicy().buildNewInstance();
            ((WrappedValue)((Object)newObject)).setValue(objectValue);
            xmlroot.setObject(newObject);
            return xmlroot;
        }
        Class generatedClass = null;
        if (this.jaxbContext.getTypeMappingInfoToGeneratedType() != null) {
            if (this.jaxbContext.getTypeToTypeMappingInfo() != null) {
                if (elt.getDeclaredType() != null && elt.getDeclaredType().isArray()) {
                    TypeMappingInfo tmi = this.jaxbContext.getTypeToTypeMappingInfo().get(elt.getDeclaredType());
                    generatedClass = this.jaxbContext.getTypeMappingInfoToGeneratedType().get(tmi);
                } else if (elt instanceof JAXBTypeElement) {
                    objectType = ((JAXBTypeElement)elt).getType();
                    TypeMappingInfo tmi = this.jaxbContext.getTypeToTypeMappingInfo().get(objectType);
                    generatedClass = this.jaxbContext.getTypeMappingInfoToGeneratedType().get(tmi);
                }
            }
        } else if (elt.getDeclaredType() != null && elt.getDeclaredType().isArray()) {
            if (this.jaxbContext.getArrayClassesToGeneratedClasses() != null) {
                generatedClass = this.jaxbContext.getArrayClassesToGeneratedClasses().get(elt.getDeclaredType().getCanonicalName());
            }
        } else if (elt instanceof JAXBTypeElement) {
            objectType = ((JAXBTypeElement)elt).getType();
            generatedClass = this.jaxbContext.getCollectionClassesToGeneratedClasses().get(objectType);
        }
        if (generatedClass != null) {
            ClassDescriptor desc = this.xmlMarshaller.getXMLContext().getSession(generatedClass).getDescriptor(generatedClass);
            Object newObject = desc.getInstantiationPolicy().buildNewInstance();
            ((ManyValue)newObject).setItem(objectValue);
            xmlroot.setObject(newObject);
        }
        return xmlroot;
    }

    public XmlAdapter getAdapter(Class javaClass) {
        HashMap result = (HashMap)this.xmlMarshaller.getProperty((Object)XML_JAVATYPE_ADAPTERS);
        if (result == null) {
            return null;
        }
        return (XmlAdapter)result.get(javaClass);
    }

    public AttachmentMarshaller getAttachmentMarshaller() {
        if (this.xmlMarshaller.getAttachmentMarshaller() == null) {
            return null;
        }
        return ((AttachmentMarshallerAdapter)this.xmlMarshaller.getAttachmentMarshaller()).getAttachmentMarshaller();
    }

    public ValidationEventHandler getEventHandler() throws JAXBException {
        return this.validationEventHandler;
    }

    public Marshaller.Listener getListener() {
        return ((JAXBMarshalListener)this.xmlMarshaller.getMarshalListener()).getListener();
    }

    public Node getNode(Object object) throws JAXBException {
        throw new UnsupportedOperationException();
    }

    public Object getProperty(String key) throws PropertyException {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if ("jaxb.formatted.output".equals(key)) {
            return this.xmlMarshaller.isFormattedOutput();
        }
        if ("jaxb.encoding".equals(key)) {
            return this.xmlMarshaller.getEncoding();
        }
        if ("jaxb.schemaLocation".equals(key)) {
            return this.xmlMarshaller.getSchemaLocation();
        }
        if ("jaxb.noNamespaceSchemaLocation".equals(key)) {
            return this.xmlMarshaller.getNoNamespaceSchemaLocation();
        }
        if ("jaxb.fragment".equals(key)) {
            return this.xmlMarshaller.isFragment();
        }
        if ("eclipselink.media-type".equals(key)) {
            return this.xmlMarshaller.getMediaType();
        }
        if ("eclipselink.namespace-prefix-mapper".equals(key)) {
            return this.xmlMarshaller.getNamespacePrefixMapper();
        }
        if ("eclipselink.indent-string".equals(key) || SUN_INDENT_STRING.equals(key) || SUN_JSE_INDENT_STRING.equals(key)) {
            return this.xmlMarshaller.getIndentString();
        }
        if ("eclipselink.character-escape-handler".equals(key)) {
            return this.xmlMarshaller.getCharacterEscapeHandler();
        }
        if (XML_DECLARATION.equals(key)) {
            return !this.xmlMarshaller.isFragment();
        }
        if (XML_HEADERS.equals(key)) {
            return this.xmlMarshaller.getXmlHeader();
        }
        if (OBJECT_IDENTITY_CYCLE_DETECTION.equals(key)) {
            return this.xmlMarshaller.isEqualUsingIdenity();
        }
        if ("eclipselink.json.attribute-prefix".equals(key)) {
            return this.xmlMarshaller.getAttributePrefix();
        }
        if ("eclipselink.json.include-root".equals(key)) {
            return this.xmlMarshaller.isIncludeRoot();
        }
        if ("eclipselink.json.value-wrapper".equals(key)) {
            return this.xmlMarshaller.getValueWrapper();
        }
        if ("eclipselink.json.namespace-separator".equals(key)) {
            return Character.valueOf(this.xmlMarshaller.getNamespaceSeparator());
        }
        if (SUN_CHARACTER_ESCAPE_HANDLER.equals(key) || SUN_JSE_CHARACTER_ESCAPE_HANDLER.equals(key)) {
            if (this.xmlMarshaller.getCharacterEscapeHandler() instanceof CharacterEscapeHandlerWrapper) {
                CharacterEscapeHandlerWrapper wrapper = (CharacterEscapeHandlerWrapper)this.xmlMarshaller.getCharacterEscapeHandler();
                return wrapper.getHandler();
            }
            return this.xmlMarshaller.getCharacterEscapeHandler();
        }
        if (SUN_NAMESPACE_PREFIX_MAPPER.equals(key) || SUN_JSE_NAMESPACE_PREFIX_MAPPER.equals(key)) {
            NamespacePrefixMapperWrapper wrapper = (NamespacePrefixMapperWrapper)this.xmlMarshaller.getNamespacePrefixMapper();
            if (wrapper == null) {
                return null;
            }
            return wrapper.getPrefixMapper();
        }
        throw new PropertyException(key);
    }

    public Schema getSchema() {
        return this.xmlMarshaller.getSchema();
    }

    public void marshal(Object object, ContentHandler contentHandler) throws JAXBException {
        if (object == null || contentHandler == null) {
            throw new IllegalArgumentException();
        }
        object = this.modifyObjectIfNeeded(object);
        try {
            this.xmlMarshaller.marshal(object, contentHandler);
        }
        catch (Exception e) {
            throw new MarshalException((Throwable)e);
        }
    }

    private Object wrapEnumeration(Object object, Class enumerationClass) {
        Class generatedClass = this.getClassToGeneratedClasses().get(enumerationClass.getName());
        if (generatedClass != null && WrappedValue.class.isAssignableFrom(generatedClass)) {
            ClassDescriptor desc = this.xmlMarshaller.getXMLContext().getSession(generatedClass).getDescriptor(generatedClass);
            Object newObject = desc.getInstantiationPolicy().buildNewInstance();
            ((WrappedValue)((Object)newObject)).setValue(object);
            object = newObject;
        }
        return object;
    }

    public void marshal(Object object, XMLEventWriter eventWriter) throws JAXBException {
        if (object == null || eventWriter == null) {
            throw new IllegalArgumentException();
        }
        object = this.modifyObjectIfNeeded(object);
        try {
            XMLEventWriterRecord record = new XMLEventWriterRecord(eventWriter);
            record.setMarshaller(this.xmlMarshaller);
            this.xmlMarshaller.marshal(object, (MarshalRecord)record);
        }
        catch (Exception ex) {
            throw new MarshalException((Throwable)ex);
        }
    }

    public void marshal(Object object, XMLEventWriter eventWriter, TypeMappingInfo type) throws JAXBException {
        if (this.jaxbContext.getTypeMappingInfoToGeneratedType() == null) {
            this.marshal(object, eventWriter);
        } else {
            JAXBContext.RootLevelXmlAdapter adapter;
            JAXBElement element = null;
            Object value = object;
            if (object instanceof JAXBElement) {
                element = (JAXBElement)object;
                value = element.getValue();
            }
            if ((adapter = this.jaxbContext.getTypeMappingInfoToJavaTypeAdapters().get(type)) != null) {
                try {
                    value = adapter.getXmlAdapter().marshal(value);
                }
                catch (Exception ex) {
                    throw new JAXBException((Throwable)XMLMarshalException.marshalException((Exception)ex));
                }
            }
            value = this.wrapObject(value, element, type);
            this.marshal(value, eventWriter);
        }
    }

    public void marshal(Object object, Node node) throws JAXBException {
        if (object == null || node == null) {
            throw new IllegalArgumentException();
        }
        object = this.modifyObjectIfNeeded(object);
        try {
            this.xmlMarshaller.marshal(object, node);
        }
        catch (Exception e) {
            throw new MarshalException((Throwable)e);
        }
    }

    public void marshal(Object object, OutputStream outputStream) throws JAXBException {
        if (object == null || outputStream == null) {
            throw new IllegalArgumentException();
        }
        object = this.modifyObjectIfNeeded(object);
        try {
            this.xmlMarshaller.marshal(object, outputStream);
        }
        catch (Exception e) {
            throw new MarshalException((Throwable)e);
        }
    }

    public void marshal(Object object, File file) throws JAXBException {
        try {
            FileOutputStream outputStream = new FileOutputStream(file);
            try {
                this.marshal(object, outputStream);
            }
            finally {
                outputStream.close();
            }
        }
        catch (Exception ex) {
            throw new MarshalException((Throwable)ex);
        }
    }

    public void marshal(Object object, Result result) throws JAXBException {
        if (object == null || result == null) {
            throw new IllegalArgumentException();
        }
        object = this.modifyObjectIfNeeded(object);
        try {
            this.xmlMarshaller.marshal(object, result);
        }
        catch (Exception e) {
            throw new MarshalException((Throwable)e);
        }
    }

    public void marshal(Object object, Result result, TypeMappingInfo type) throws JAXBException {
        if (this.jaxbContext.getTypeMappingInfoToGeneratedType() == null) {
            this.marshal(object, result);
        } else {
            JAXBContext.RootLevelXmlAdapter adapter;
            JAXBElement element = null;
            Object value = object;
            if (object instanceof JAXBElement) {
                element = (JAXBElement)object;
                value = element.getValue();
            }
            if ((adapter = this.jaxbContext.getTypeMappingInfoToJavaTypeAdapters().get(type)) != null) {
                try {
                    value = adapter.getXmlAdapter().marshal(value);
                }
                catch (Exception ex) {
                    throw new JAXBException((Throwable)XMLMarshalException.marshalException((Exception)ex));
                }
            }
            value = this.wrapObject(value, element, type);
            this.marshal(value, result);
        }
    }

    public void marshal(Object object, XMLStreamWriter streamWriter) throws JAXBException {
        if (object == null || streamWriter == null) {
            throw new IllegalArgumentException();
        }
        object = this.modifyObjectIfNeeded(object);
        try {
            XMLStreamWriterRecord record = new XMLStreamWriterRecord(streamWriter);
            record.setMarshaller(this.xmlMarshaller);
            this.xmlMarshaller.marshal(object, (MarshalRecord)record);
        }
        catch (Exception ex) {
            throw new MarshalException((Throwable)ex);
        }
    }

    private Object modifyObjectIfNeeded(Object obj) {
        if (obj instanceof Collection) {
            Collection objectList = (Collection)obj;
            ArrayList<Object> newList = new ArrayList<Object>(objectList.size());
            for (Object o : objectList) {
                newList.add(this.modifySingleObjectIfNeeded(o));
            }
            return newList;
        }
        return this.modifySingleObjectIfNeeded(obj);
    }

    private Object modifySingleObjectIfNeeded(Object obj) {
        if (obj instanceof JAXBElement) {
            return this.createXMLRootFromJAXBElement((JAXBElement)obj);
        }
        if (obj != null && obj.getClass().isEnum()) {
            return this.wrapEnumeration(obj, obj.getClass());
        }
        return obj;
    }

    public void marshal(Object object, XMLStreamWriter streamWriter, TypeMappingInfo type) throws JAXBException {
        if (this.jaxbContext.getTypeMappingInfoToGeneratedType() == null) {
            this.marshal(object, streamWriter);
        } else {
            JAXBContext.RootLevelXmlAdapter adapter;
            JAXBElement element = null;
            Object value = object;
            if (object instanceof JAXBElement) {
                element = (JAXBElement)object;
                value = element.getValue();
            }
            if ((adapter = this.jaxbContext.getTypeMappingInfoToJavaTypeAdapters().get(type)) != null) {
                try {
                    value = adapter.getXmlAdapter().marshal(value);
                }
                catch (Exception ex) {
                    throw new JAXBException((Throwable)XMLMarshalException.marshalException((Exception)ex));
                }
            }
            value = this.wrapObject(value, element, type);
            this.marshal(value, streamWriter);
        }
    }

    private Object wrapObject(Object object, JAXBElement wrapperElement, TypeMappingInfo typeMappingInfo) {
        Object newObject;
        ClassDescriptor desc;
        Class generatedClass = this.jaxbContext.getTypeMappingInfoToGeneratedType().get(typeMappingInfo);
        if (generatedClass != null && object == null && wrapperElement != null) {
            return this.wrapObjectInXMLRoot(wrapperElement, object);
        }
        if (generatedClass != null && WrappedValue.class.isAssignableFrom(generatedClass)) {
            desc = this.xmlMarshaller.getXMLContext().getSession(generatedClass).getDescriptor(generatedClass);
            newObject = desc.getInstantiationPolicy().buildNewInstance();
            ((WrappedValue)((Object)newObject)).setValue(object);
            object = newObject;
        } else if (generatedClass != null) {
            desc = this.xmlMarshaller.getXMLContext().getSession(generatedClass).getDescriptor(generatedClass);
            newObject = desc.getInstantiationPolicy().buildNewInstance();
            ((ManyValue)newObject).setItem(object);
            object = newObject;
        }
        if (wrapperElement == null) {
            XMLRoot xmlRoot = new XMLRoot();
            QName xmlTagName = typeMappingInfo.getXmlTagName();
            if (xmlTagName == null) {
                return object;
            }
            xmlRoot.setNamespaceURI(typeMappingInfo.getXmlTagName().getNamespaceURI());
            xmlRoot.setLocalName(typeMappingInfo.getXmlTagName().getLocalPart());
            xmlRoot.setObject(object);
            return xmlRoot;
        }
        return this.wrapObjectInXMLRoot(wrapperElement, object);
    }

    private XMLRoot wrapObjectInXMLRoot(JAXBElement wrapperElement, Object value) {
        XMLRoot xmlroot = new XMLRoot();
        Object objectValue = value;
        xmlroot.setObject(objectValue);
        QName qname = wrapperElement.getName();
        xmlroot.setLocalName(qname.getLocalPart());
        xmlroot.setNamespaceURI(qname.getNamespaceURI());
        xmlroot.setDeclaredType(wrapperElement.getDeclaredType());
        if (value != null && (value.getClass() == ClassConstants.ABYTE || value.getClass() == ClassConstants.APBYTE || value.getClass().getCanonicalName().equals("javax.activation.DataHandler"))) {
            xmlroot.setSchemaType(XMLConstants.BASE_64_BINARY_QNAME);
        }
        return xmlroot;
    }

    public void marshal(Object object, Writer writer) throws JAXBException {
        if (object == null || writer == null) {
            throw new IllegalArgumentException();
        }
        object = this.modifyObjectIfNeeded(object);
        try {
            this.xmlMarshaller.marshal(object, writer);
        }
        catch (Exception e) {
            throw new MarshalException((Throwable)e);
        }
    }

    public void marshal(Object object, MarshalRecord record) throws JAXBException {
        if (object == null || record == null) {
            throw new IllegalArgumentException();
        }
        object = this.modifyObjectIfNeeded(object);
        try {
            record.setMarshaller(this.xmlMarshaller);
            this.xmlMarshaller.marshal(object, record);
        }
        catch (Exception e) {
            throw new MarshalException((Throwable)e);
        }
    }

    public void marshal(Object object, MarshalRecord record, TypeMappingInfo type) throws JAXBException {
        if (this.jaxbContext.getTypeMappingInfoToGeneratedType() == null) {
            this.marshal(object, record);
        } else {
            JAXBContext.RootLevelXmlAdapter adapter;
            JAXBElement element = null;
            Object value = object;
            if (object instanceof JAXBElement) {
                element = (JAXBElement)object;
                value = element.getValue();
            }
            if ((adapter = this.jaxbContext.getTypeMappingInfoToJavaTypeAdapters().get(type)) != null) {
                try {
                    value = adapter.getXmlAdapter().marshal(value);
                }
                catch (Exception ex) {
                    throw new JAXBException((Throwable)XMLMarshalException.marshalException((Exception)ex));
                }
            }
            value = this.wrapObject(value, element, type);
            this.marshal(value, record);
        }
    }

    public void setAdapter(Class javaClass, XmlAdapter adapter) {
        HashMap<Class, XmlAdapter> result = (HashMap<Class, XmlAdapter>)this.xmlMarshaller.getProperty((Object)XML_JAVATYPE_ADAPTERS);
        if (result == null) {
            result = new HashMap<Class, XmlAdapter>();
            this.xmlMarshaller.getProperties().put(XML_JAVATYPE_ADAPTERS, result);
        }
        result.put(javaClass, adapter);
    }

    public void setAdapter(XmlAdapter adapter) {
        this.setAdapter(adapter.getClass(), adapter);
    }

    public void setAttachmentMarshaller(AttachmentMarshaller attachmentMarshaller) {
        if (attachmentMarshaller == null) {
            this.xmlMarshaller.setAttachmentMarshaller(null);
        } else {
            this.xmlMarshaller.setAttachmentMarshaller((XMLAttachmentMarshaller)new AttachmentMarshallerAdapter(attachmentMarshaller));
        }
    }

    public void setEventHandler(ValidationEventHandler newValidationEventHandler) throws JAXBException {
        this.validationEventHandler = newValidationEventHandler == null ? JAXBContext.DEFAULT_VALIDATION_EVENT_HANDER : newValidationEventHandler;
        this.xmlMarshaller.setErrorHandler((ErrorHandler)new JAXBErrorHandler(this.validationEventHandler));
    }

    public void setListener(Marshaller.Listener listener) {
        ((JAXBMarshalListener)this.xmlMarshaller.getMarshalListener()).setListener(listener);
    }

    public void setMarshalCallbacks(HashMap callbacks) {
        ((JAXBMarshalListener)this.xmlMarshaller.getMarshalListener()).setClassBasedMarshalEvents(callbacks);
    }

    public void setProperty(String key, Object value) throws PropertyException {
        block40: {
            try {
                if (key == null) {
                    throw new IllegalArgumentException();
                }
                if ("jaxb.formatted.output".equals(key)) {
                    if (value == null) {
                        throw new PropertyException(key, "");
                    }
                    Boolean formattedOutput = (Boolean)value;
                    this.xmlMarshaller.setFormattedOutput(formattedOutput.booleanValue());
                    break block40;
                }
                if ("jaxb.encoding".equals(key)) {
                    this.xmlMarshaller.setEncoding((String)value);
                    break block40;
                }
                if ("jaxb.schemaLocation".equals(key)) {
                    this.xmlMarshaller.setSchemaLocation((String)value);
                    break block40;
                }
                if ("jaxb.noNamespaceSchemaLocation".equals(key)) {
                    this.xmlMarshaller.setNoNamespaceSchemaLocation((String)value);
                    break block40;
                }
                if ("jaxb.fragment".equals(key)) {
                    if (value == null) {
                        throw new PropertyException(key, "");
                    }
                    Boolean fragment = (Boolean)value;
                    this.xmlMarshaller.setFragment(fragment.booleanValue());
                    break block40;
                }
                if ("eclipselink.namespace-prefix-mapper".equals(key)) {
                    if (value == null) {
                        this.xmlMarshaller.setNamespacePrefixMapper(null);
                    } else if (value instanceof Map) {
                        MapNamespacePrefixMapper namespacePrefixMapper = new MapNamespacePrefixMapper((Map)value);
                        this.xmlMarshaller.setNamespacePrefixMapper((NamespacePrefixMapper)namespacePrefixMapper);
                    } else {
                        this.xmlMarshaller.setNamespacePrefixMapper((NamespacePrefixMapper)value);
                    }
                    break block40;
                }
                if (SUN_NAMESPACE_PREFIX_MAPPER.equals(key) || SUN_JSE_NAMESPACE_PREFIX_MAPPER.equals(key)) {
                    if (value == null) {
                        this.xmlMarshaller.setNamespacePrefixMapper(null);
                    } else {
                        this.xmlMarshaller.setNamespacePrefixMapper((NamespacePrefixMapper)new NamespacePrefixMapperWrapper(value));
                    }
                    break block40;
                }
                if ("eclipselink.indent-string".equals(key) || SUN_INDENT_STRING.equals(key) || SUN_JSE_INDENT_STRING.equals(key)) {
                    this.xmlMarshaller.setIndentString((String)value);
                    break block40;
                }
                if ("eclipselink.json.marshal-empty-collections".equals(key)) {
                    this.xmlMarshaller.setMarshalEmptyCollections((Boolean)value);
                    break block40;
                }
                if ("eclipselink.character-escape-handler".equals(key)) {
                    this.xmlMarshaller.setCharacterEscapeHandler((CharacterEscapeHandler)value);
                    break block40;
                }
                if (SUN_CHARACTER_ESCAPE_HANDLER.equals(key) || SUN_JSE_CHARACTER_ESCAPE_HANDLER.equals(key)) {
                    if (value == null) {
                        this.xmlMarshaller.setCharacterEscapeHandler(null);
                    } else {
                        this.xmlMarshaller.setCharacterEscapeHandler((CharacterEscapeHandler)new CharacterEscapeHandlerWrapper(value));
                    }
                    break block40;
                }
                if (XML_DECLARATION.equals(key)) {
                    if (value == null) {
                        throw new PropertyException(key, "");
                    }
                    Boolean fragment = (Boolean)value == false;
                    this.xmlMarshaller.setFragment(fragment.booleanValue());
                    break block40;
                }
                if (XML_HEADERS.equals(key)) {
                    this.xmlMarshaller.setXmlHeader((String)value);
                    break block40;
                }
                if (OBJECT_IDENTITY_CYCLE_DETECTION.equals(key)) {
                    if (value == null) {
                        throw new PropertyException(key, "");
                    }
                    this.xmlMarshaller.setEqualUsingIdenity(((Boolean)value).booleanValue());
                    break block40;
                }
                if ("eclipselink.media-type".equals(key)) {
                    MediaType mType = null;
                    if (value instanceof MediaType) {
                        mType = (MediaType)value;
                    } else if (value instanceof String) {
                        mType = MediaType.getMediaType((String)((String)value));
                    }
                    if (mType == null) {
                        throw new PropertyException(key, "");
                    }
                    this.xmlMarshaller.setMediaType(mType);
                    break block40;
                }
                if ("eclipselink.json.attribute-prefix".equals(key)) {
                    this.xmlMarshaller.setAttributePrefix((String)value);
                    break block40;
                }
                if ("eclipselink.json.include-root".equals(key)) {
                    if (value == null) {
                        throw new PropertyException(key, "");
                    }
                    this.xmlMarshaller.setIncludeRoot(((Boolean)value).booleanValue());
                    break block40;
                }
                if ("eclipselink.json.value-wrapper".equals(key)) {
                    this.xmlMarshaller.setValueWrapper((String)value);
                    break block40;
                }
                if ("eclipselink.json.namespace-separator".equals(key)) {
                    if (value == null) {
                        throw new PropertyException(key, "");
                    }
                    this.xmlMarshaller.setNamespaceSeparator(((Character)value).charValue());
                    break block40;
                }
                throw new PropertyException(key, value);
            }
            catch (ClassCastException exception) {
                throw new PropertyException(key, (Throwable)exception);
            }
        }
    }

    public void setSchema(Schema schema) {
        this.xmlMarshaller.setSchema(schema);
    }

    private HashMap<String, Class> getClassToGeneratedClasses() {
        return this.jaxbContext.getClassToGeneratedClasses();
    }

    public JAXBContext getJaxbContext() {
        return this.jaxbContext;
    }

    public void setJaxbContext(JAXBContext jaxbContext) {
        this.jaxbContext = jaxbContext;
    }

    public XMLMarshaller getXMLMarshaller() {
        return this.xmlMarshaller;
    }
}

