/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.XMLConversionException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.TimeZoneHolder;
import org.eclipse.persistence.internal.oxm.conversion.Base64;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.record.XMLRecord;

public class XMLConversionManager
extends ConversionManager
implements TimeZoneHolder {
    protected static final String GMT_ID = "GMT";
    protected static final String GMT_SUFFIX = "Z";
    protected static XMLConversionManager defaultXMLManager;
    protected static HashMap defaultXMLTypes;
    protected static HashMap defaultJavaTypes;
    protected boolean timeZoneQualified = false;
    protected TimeZone timeZone;
    protected static int TOTAL_MS_DIGITS;
    protected static int TOTAL_NS_DIGITS;
    protected static long YEAR_ONE_AD_TIME;
    private static final char PLUS = '+';
    protected DatatypeFactory datatypeFactory;
    private boolean trimGMonth = false;

    static {
        TOTAL_MS_DIGITS = 3;
        TOTAL_NS_DIGITS = 9;
        YEAR_ONE_AD_TIME = -62135769600000L;
    }

    protected DatatypeFactory getDatatypeFactory() {
        if (this.datatypeFactory == null) {
            try {
                this.datatypeFactory = DatatypeFactory.newInstance();
            }
            catch (DatatypeConfigurationException e) {
                throw new RuntimeException(e);
            }
        }
        return this.datatypeFactory;
    }

    public static XMLConversionManager getDefaultXMLManager() {
        if (defaultXMLManager == null) {
            defaultXMLManager = new XMLConversionManager();
        }
        return defaultXMLManager;
    }

    @Override
    public TimeZone getTimeZone() {
        if (this.timeZone == null) {
            return TimeZone.getDefault();
        }
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public boolean isTimeZoneQualified() {
        return this.timeZoneQualified;
    }

    public void setTimeZoneQualified(boolean timeZoneQualified) {
        this.timeZoneQualified = timeZoneQualified;
    }

    @Override
    public Object convertObject(Object sourceObject, Class javaClass) throws ConversionException {
        if (sourceObject == null) {
            return super.convertObject(sourceObject, javaClass);
        }
        if (javaClass == XMLConstants.QNAME_CLASS && sourceObject != null) {
            return this.convertObjectToQName(sourceObject);
        }
        if (javaClass == ClassConstants.List_Class && sourceObject instanceof String) {
            return this.convertStringToList(sourceObject);
        }
        if (javaClass == ClassConstants.STRING && sourceObject instanceof List) {
            return this.convertListToString(sourceObject);
        }
        if (javaClass == ClassConstants.CALENDAR) {
            return this.convertObjectToCalendar(sourceObject);
        }
        if (javaClass == ClassConstants.UTILDATE) {
            return this.convertObjectToUtilDate(sourceObject, XMLConstants.DATE_TIME_QNAME);
        }
        if (javaClass == ClassConstants.SQLDATE) {
            return this.convertObjectToSQLDate(sourceObject, XMLConstants.DATE_QNAME);
        }
        if (javaClass == ClassConstants.TIME) {
            return this.convertObjectToSQLTime(sourceObject, XMLConstants.TIME_QNAME);
        }
        if (javaClass == ClassConstants.TIMESTAMP) {
            return this.convertObjectToTimestamp(sourceObject, XMLConstants.DATE_TIME_QNAME);
        }
        if (javaClass == URI.class) {
            return this.convertObjectToURI(sourceObject);
        }
        if (javaClass == ClassConstants.XML_GREGORIAN_CALENDAR) {
            return this.convertObjectToXMLGregorianCalendar(sourceObject);
        }
        if (javaClass == ClassConstants.DURATION) {
            return this.convertObjectToDuration(sourceObject);
        }
        try {
            return super.convertObject(sourceObject, javaClass);
        }
        catch (ConversionException ex) {
            if (sourceObject.getClass() == ClassConstants.STRING) {
                return super.convertObject(((String)sourceObject).trim(), javaClass);
            }
            throw ex;
        }
    }

    public Object convertObject(Object sourceObject, Class javaClass, QName schemaTypeQName) throws ConversionException {
        if (schemaTypeQName == null) {
            return this.convertObject(sourceObject, javaClass);
        }
        if (sourceObject == null) {
            return super.convertObject(sourceObject, javaClass);
        }
        if (javaClass == ClassConstants.CALENDAR || javaClass == ClassConstants.GREGORIAN_CALENDAR) {
            return this.convertObjectToCalendar(sourceObject, schemaTypeQName);
        }
        if (javaClass == ClassConstants.ABYTE) {
            if (schemaTypeQName.getLocalPart().equalsIgnoreCase("hexBinary")) {
                return super.convertObjectToByteObjectArray(sourceObject);
            }
            if (schemaTypeQName.getLocalPart().equalsIgnoreCase("base64Binary")) {
                return this.convertSchemaBase64ToByteObjectArray(sourceObject);
            }
        } else if (javaClass == ClassConstants.APBYTE) {
            if (schemaTypeQName.getLocalPart().equalsIgnoreCase("hexBinary")) {
                return super.convertObjectToByteArray(sourceObject);
            }
            if (schemaTypeQName.getLocalPart().equalsIgnoreCase("base64Binary")) {
                return this.convertSchemaBase64ToByteArray(sourceObject);
            }
        } else {
            if (javaClass == ClassConstants.List_Class && sourceObject instanceof String) {
                return this.convertStringToList(sourceObject);
            }
            if (javaClass == ClassConstants.STRING && sourceObject instanceof List) {
                return this.convertListToString(sourceObject);
            }
            if (sourceObject instanceof byte[]) {
                if (schemaTypeQName.getLocalPart().equalsIgnoreCase("base64Binary")) {
                    return this.buildBase64StringFromBytes((byte[])sourceObject);
                }
                return Helper.buildHexStringFromBytes((byte[])sourceObject);
            }
            if (sourceObject instanceof Byte[]) {
                if (schemaTypeQName.getLocalPart().equalsIgnoreCase("base64Binary")) {
                    return this.buildBase64StringFromObjectBytes((Byte[])sourceObject);
                }
                return this.buildHexStringFromObjectBytes((Byte[])sourceObject);
            }
            if (javaClass == ClassConstants.UTILDATE) {
                return this.convertObjectToUtilDate(sourceObject, schemaTypeQName);
            }
            if (javaClass == ClassConstants.SQLDATE) {
                return this.convertObjectToSQLDate(sourceObject, schemaTypeQName);
            }
            if (javaClass == ClassConstants.TIME) {
                return this.convertObjectToSQLTime(sourceObject, schemaTypeQName);
            }
            if (javaClass == ClassConstants.TIMESTAMP) {
                return this.convertObjectToTimestamp(sourceObject, schemaTypeQName);
            }
            if (javaClass == XMLConstants.QNAME_CLASS && sourceObject != null) {
                return this.convertObjectToQName(sourceObject);
            }
            if (javaClass == ClassConstants.STRING) {
                return this.convertObjectToString(sourceObject, schemaTypeQName);
            }
            if (javaClass == URI.class) {
                return this.convertObjectToURI(sourceObject);
            }
            if (javaClass == ClassConstants.XML_GREGORIAN_CALENDAR) {
                return this.convertObjectToXMLGregorianCalendar(sourceObject, schemaTypeQName);
            }
            if (javaClass == ClassConstants.DURATION) {
                return this.convertObjectToDuration(sourceObject);
            }
            try {
                return super.convertObject(sourceObject, javaClass);
            }
            catch (ConversionException ex) {
                if (sourceObject.getClass() == ClassConstants.STRING) {
                    return super.convertObject(((String)sourceObject).trim(), javaClass);
                }
                throw ex;
            }
        }
        throw ConversionException.couldNotBeConverted(sourceObject, javaClass);
    }

    protected XMLGregorianCalendar convertObjectToXMLGregorianCalendar(Object sourceObject, QName schemaTypeQName) throws ConversionException {
        if (sourceObject instanceof XMLGregorianCalendar) {
            return (XMLGregorianCalendar)sourceObject;
        }
        if (sourceObject instanceof String) {
            return this.convertStringToXMLGregorianCalendar((String)sourceObject, schemaTypeQName);
        }
        throw ConversionException.couldNotBeConverted(sourceObject, ClassConstants.XML_GREGORIAN_CALENDAR);
    }

    protected XMLGregorianCalendar convertObjectToXMLGregorianCalendar(Object sourceObject) throws ConversionException {
        if (sourceObject instanceof XMLGregorianCalendar) {
            return (XMLGregorianCalendar)sourceObject;
        }
        if (sourceObject instanceof String) {
            return this.convertStringToXMLGregorianCalendar((String)sourceObject);
        }
        throw ConversionException.couldNotBeConverted(sourceObject, ClassConstants.XML_GREGORIAN_CALENDAR);
    }

    protected Duration convertObjectToDuration(Object sourceObject) throws ConversionException {
        if (sourceObject instanceof Duration) {
            return (Duration)sourceObject;
        }
        if (sourceObject instanceof String) {
            return this.convertStringToDuration((String)sourceObject);
        }
        throw ConversionException.couldNotBeConverted(sourceObject, ClassConstants.DURATION);
    }

    @Override
    protected Character convertObjectToChar(Object sourceObject) throws ConversionException {
        if (sourceObject == null || sourceObject.equals("")) {
            return Character.valueOf('\u0000');
        }
        return super.convertObjectToChar(sourceObject);
    }

    protected URI convertObjectToURI(Object sourceObject) throws ConversionException {
        if (sourceObject instanceof String) {
            try {
                return new URI((String)sourceObject);
            }
            catch (Exception exception) {}
        }
        throw ConversionException.couldNotBeConverted(sourceObject, URI.class);
    }

    protected QName convertObjectToQName(Object sourceObject) throws ConversionException {
        if (sourceObject instanceof QName) {
            return (QName)sourceObject;
        }
        if (sourceObject instanceof String) {
            return this.qnameFromString((String)sourceObject);
        }
        throw ConversionException.couldNotBeConverted(sourceObject, XMLConstants.QNAME_CLASS);
    }

    @Override
    protected Calendar convertObjectToCalendar(Object sourceObject) throws ConversionException {
        if (sourceObject instanceof String) {
            String sourceString = (String)sourceObject;
            if (sourceString.lastIndexOf(84) != -1) {
                return this.convertStringToCalendar((String)sourceObject, XMLConstants.DATE_TIME_QNAME);
            }
            if (sourceString.lastIndexOf(58) != -1) {
                return this.convertStringToCalendar((String)sourceObject, XMLConstants.TIME_QNAME);
            }
            return this.convertStringToCalendar((String)sourceObject, XMLConstants.DATE_QNAME);
        }
        return super.convertObjectToCalendar(sourceObject);
    }

    @Override
    protected String convertObjectToString(Object sourceObject) throws ConversionException {
        if (sourceObject instanceof Calendar) {
            return this.stringFromCalendar((Calendar)sourceObject);
        }
        if (sourceObject instanceof Character && sourceObject.equals(Character.valueOf('\u0000'))) {
            return "";
        }
        if (sourceObject instanceof QName) {
            return this.stringFromQName((QName)sourceObject);
        }
        if (sourceObject instanceof Date) {
            return this.stringFromSQLDate((Date)sourceObject);
        }
        if (sourceObject instanceof Time) {
            return this.stringFromSQLTime((Time)sourceObject);
        }
        if (sourceObject instanceof Timestamp) {
            return this.stringFromTimestamp((Timestamp)sourceObject);
        }
        if (sourceObject instanceof java.util.Date) {
            return this.stringFromDate((java.util.Date)sourceObject);
        }
        if (sourceObject instanceof XMLGregorianCalendar) {
            return this.stringFromXMLGregorianCalendar((XMLGregorianCalendar)sourceObject);
        }
        if (sourceObject instanceof Duration) {
            return this.stringFromDuration((Duration)sourceObject);
        }
        if (sourceObject instanceof Double) {
            if (Double.POSITIVE_INFINITY == (Double)sourceObject) {
                return "INF";
            }
            if (Double.NEGATIVE_INFINITY == (Double)sourceObject) {
                return "-INF";
            }
            return ((Double)sourceObject).toString();
        }
        if (sourceObject instanceof Float) {
            if (Float.POSITIVE_INFINITY == ((Float)sourceObject).floatValue()) {
                return "INF";
            }
            if (Float.NEGATIVE_INFINITY == ((Float)sourceObject).floatValue()) {
                return "-INF";
            }
            return ((Float)sourceObject).toString();
        }
        return super.convertObjectToString(sourceObject);
    }

    protected String convertObjectToString(Object sourceObject, QName schemaTypeQName) throws ConversionException {
        if (sourceObject instanceof Calendar) {
            return this.stringFromCalendar((Calendar)sourceObject, schemaTypeQName);
        }
        if (sourceObject instanceof Character && sourceObject.equals(Character.valueOf('\u0000'))) {
            return "";
        }
        if (sourceObject instanceof QName) {
            return this.stringFromQName((QName)sourceObject);
        }
        if (sourceObject instanceof Date) {
            return this.stringFromSQLDate((Date)sourceObject, schemaTypeQName);
        }
        if (sourceObject instanceof Time) {
            return this.stringFromSQLTime((Time)sourceObject, schemaTypeQName);
        }
        if (sourceObject instanceof Timestamp) {
            return this.stringFromTimestamp((Timestamp)sourceObject, schemaTypeQName);
        }
        if (sourceObject instanceof java.util.Date) {
            return this.stringFromDate((java.util.Date)sourceObject, schemaTypeQName);
        }
        if (sourceObject instanceof XMLGregorianCalendar) {
            return this.stringFromXMLGregorianCalendar((XMLGregorianCalendar)sourceObject, schemaTypeQName);
        }
        if (sourceObject instanceof Duration) {
            return this.stringFromDuration((Duration)sourceObject);
        }
        if (sourceObject instanceof Double) {
            if (Double.POSITIVE_INFINITY == (Double)sourceObject) {
                return "INF";
            }
            if (Double.NEGATIVE_INFINITY == (Double)sourceObject) {
                return "-INF";
            }
            return ((Double)sourceObject).toString();
        }
        if (sourceObject instanceof Float) {
            if (Float.POSITIVE_INFINITY == ((Float)sourceObject).floatValue()) {
                return "INF";
            }
            if (Float.NEGATIVE_INFINITY == ((Float)sourceObject).floatValue()) {
                return "-INF";
            }
            return ((Float)sourceObject).toString();
        }
        return super.convertObjectToString(sourceObject);
    }

    private Calendar convertObjectToCalendar(Object sourceObject, QName schemaTypeQName) {
        if (sourceObject instanceof String) {
            return this.convertStringToCalendar((String)sourceObject, schemaTypeQName);
        }
        return super.convertObjectToCalendar(sourceObject);
    }

    @Override
    protected Date convertObjectToDate(Object sourceObject) throws ConversionException {
        Object o = sourceObject;
        if (sourceObject instanceof Calendar) {
            o = ((Calendar)sourceObject).clone();
        }
        return super.convertObjectToDate(o);
    }

    @Override
    protected Double convertObjectToDouble(Object sourceObject) throws ConversionException {
        if (sourceObject instanceof String) {
            if (((String)sourceObject).length() == 0) {
                return 0.0;
            }
            if ("INF".equals(sourceObject)) {
                return Double.POSITIVE_INFINITY;
            }
            if ("-INF".equals(sourceObject)) {
                return Double.NEGATIVE_INFINITY;
            }
            return super.convertObjectToDouble(sourceObject);
        }
        return super.convertObjectToDouble(sourceObject);
    }

    @Override
    protected Float convertObjectToFloat(Object sourceObject) throws ConversionException {
        if (sourceObject instanceof String) {
            if (((String)sourceObject).length() == 0) {
                return Float.valueOf(0.0f);
            }
            if ("INF".equals(sourceObject)) {
                return new Float(Float.POSITIVE_INFINITY);
            }
            if ("-INF".equals(sourceObject)) {
                return new Float(Float.NEGATIVE_INFINITY);
            }
        }
        return super.convertObjectToFloat(sourceObject);
    }

    @Override
    protected Integer convertObjectToInteger(Object sourceObject) throws ConversionException {
        if (sourceObject instanceof String) {
            String sourceString = (String)sourceObject;
            if (sourceString.length() == 0) {
                return 0;
            }
            if (sourceString.charAt(0) == '+') {
                return super.convertObjectToInteger(sourceString.substring(1));
            }
        }
        return super.convertObjectToInteger(sourceObject);
    }

    @Override
    protected Long convertObjectToLong(Object sourceObject) throws ConversionException {
        if (sourceObject instanceof String) {
            String sourceString = (String)sourceObject;
            if (sourceString.length() == 0) {
                return 0L;
            }
            if (sourceString.charAt(0) == '+') {
                return super.convertObjectToLong(sourceString.substring(1));
            }
        }
        return super.convertObjectToLong(sourceObject);
    }

    @Override
    protected Short convertObjectToShort(Object sourceObject) throws ConversionException {
        if (sourceObject instanceof String) {
            String sourceString = (String)sourceObject;
            if (sourceString.length() == 0) {
                return (short)0;
            }
            if (sourceString.charAt(0) == '+') {
                return super.convertObjectToShort(sourceString.substring(1));
            }
        }
        return super.convertObjectToShort(sourceObject);
    }

    @Override
    protected BigDecimal convertObjectToNumber(Object sourceObject) throws ConversionException {
        if (sourceObject instanceof String) {
            String sourceString = (String)sourceObject;
            if (sourceString.length() == 0) {
                return BigDecimal.ZERO;
            }
            if (sourceString.charAt(0) == '+') {
                return super.convertObjectToNumber(sourceString.substring(1));
            }
        }
        return super.convertObjectToNumber(sourceObject);
    }

    @Override
    protected BigInteger convertObjectToBigInteger(Object sourceObject) throws ConversionException {
        if (sourceObject instanceof String) {
            String sourceString = (String)sourceObject;
            if (sourceString.length() == 0) {
                return null;
            }
            if (sourceString.charAt(0) == '+') {
                return super.convertObjectToBigInteger(sourceString.substring(1));
            }
        }
        return super.convertObjectToBigInteger(sourceObject);
    }

    @Override
    protected BigDecimal convertObjectToBigDecimal(Object sourceObject) throws ConversionException {
        String sourceString;
        if (sourceObject instanceof String && (sourceString = (String)sourceObject).length() == 0) {
            return null;
        }
        return super.convertObjectToBigDecimal(sourceObject);
    }

    @Override
    protected Boolean convertObjectToBoolean(Object sourceObject) {
        if (sourceObject == null || sourceObject.equals("")) {
            return false;
        }
        return super.convertObjectToBoolean(sourceObject);
    }

    @Override
    protected Byte convertObjectToByte(Object sourceObject) throws ConversionException {
        if (sourceObject instanceof String) {
            String sourceString = (String)sourceObject;
            if (sourceString.length() == 0) {
                return (byte)0;
            }
            if (sourceString.charAt(0) == '+') {
                return super.convertObjectToByte(sourceString.substring(1));
            }
        }
        return super.convertObjectToByte(sourceObject);
    }

    public XMLGregorianCalendar convertStringToXMLGregorianCalendar(String sourceString, QName schemaTypeQName) {
        XMLGregorianCalendar xmlGregorianCalender = null;
        try {
            xmlGregorianCalender = this.convertStringToXMLGregorianCalendar(sourceString);
        }
        catch (Exception exception) {
            if (XMLConstants.DATE_QNAME.equals(schemaTypeQName)) {
                throw ConversionException.incorrectDateFormat(sourceString);
            }
            if (XMLConstants.TIME_QNAME.equals(schemaTypeQName)) {
                throw ConversionException.incorrectTimeFormat(sourceString);
            }
            if (XMLConstants.G_DAY_QNAME.equals(schemaTypeQName)) {
                throw XMLConversionException.incorrectGDayFormat(sourceString);
            }
            if (XMLConstants.G_MONTH_QNAME.equals(schemaTypeQName)) {
                throw XMLConversionException.incorrectGMonthFormat(sourceString);
            }
            if (XMLConstants.G_MONTH_DAY_QNAME.equals(schemaTypeQName)) {
                throw XMLConversionException.incorrectGMonthDayFormat(sourceString);
            }
            if (XMLConstants.G_YEAR_QNAME.equals(schemaTypeQName)) {
                throw XMLConversionException.incorrectGYearFormat(sourceString);
            }
            if (XMLConstants.G_YEAR_MONTH_QNAME.equals(schemaTypeQName)) {
                throw XMLConversionException.incorrectGYearMonthFormat(sourceString);
            }
            if (XMLConstants.DURATION_QNAME.equals(schemaTypeQName)) {
                throw new IllegalArgumentException();
            }
            throw ConversionException.incorrectDateTimeFormat(sourceString);
        }
        QName calendarQName = xmlGregorianCalender.getXMLSchemaType();
        if (!calendarQName.equals(schemaTypeQName)) {
            if (XMLConstants.DATE_QNAME.equals(schemaTypeQName)) {
                if (calendarQName.equals(XMLConstants.DATE_TIME_QNAME)) {
                    xmlGregorianCalender.setHour(Integer.MIN_VALUE);
                    xmlGregorianCalender.setMinute(Integer.MIN_VALUE);
                    xmlGregorianCalender.setSecond(Integer.MIN_VALUE);
                    xmlGregorianCalender.setMillisecond(Integer.MIN_VALUE);
                    return xmlGregorianCalender;
                }
                throw ConversionException.incorrectDateFormat(sourceString);
            }
            if (XMLConstants.TIME_QNAME.equals(schemaTypeQName)) {
                throw ConversionException.incorrectTimeFormat(sourceString);
            }
            if (XMLConstants.G_DAY_QNAME.equals(schemaTypeQName)) {
                throw XMLConversionException.incorrectGDayFormat(sourceString);
            }
            if (XMLConstants.G_MONTH_QNAME.equals(schemaTypeQName)) {
                throw XMLConversionException.incorrectGMonthFormat(sourceString);
            }
            if (XMLConstants.G_MONTH_DAY_QNAME.equals(schemaTypeQName)) {
                throw XMLConversionException.incorrectGMonthDayFormat(sourceString);
            }
            if (XMLConstants.G_YEAR_QNAME.equals(schemaTypeQName)) {
                throw XMLConversionException.incorrectGYearFormat(sourceString);
            }
            if (XMLConstants.G_YEAR_MONTH_QNAME.equals(schemaTypeQName)) {
                throw XMLConversionException.incorrectGYearMonthFormat(sourceString);
            }
            if (XMLConstants.DURATION_QNAME.equals(schemaTypeQName)) {
                throw new IllegalArgumentException();
            }
            if (XMLConstants.DATE_TIME_QNAME.equals(schemaTypeQName)) {
                throw ConversionException.incorrectDateTimeFormat(sourceString);
            }
        }
        return xmlGregorianCalender;
    }

    public XMLGregorianCalendar convertStringToXMLGregorianCalendar(String sourceString) {
        XMLGregorianCalendar calToReturn = null;
        try {
            calToReturn = this.getDatatypeFactory().newXMLGregorianCalendar(sourceString);
        }
        catch (IllegalArgumentException e1) {
            try {
                int length = sourceString.length();
                String retryString = null;
                if (length >= 6 && sourceString.charAt(4) == '-' && sourceString.charAt(5) == '-') {
                    retryString = sourceString.substring(0, 4) + (length > 6 ? sourceString.substring(6) : "");
                } else if (length >= 4) {
                    retryString = sourceString.substring(0, 4) + "--" + (length > 4 ? sourceString.substring(4) : "");
                }
                if (retryString == null) {
                    throw e1;
                }
                calToReturn = this.getDatatypeFactory().newXMLGregorianCalendar(retryString);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw e1;
            }
        }
        return calToReturn;
    }

    public Duration convertStringToDuration(String sourceString) {
        return this.getDatatypeFactory().newDuration(sourceString);
    }

    public Calendar convertStringToCalendar(String sourceString, QName schemaTypeQName) {
        XMLGregorianCalendar xmlGregorianCalender = this.convertStringToXMLGregorianCalendar(sourceString, schemaTypeQName);
        return this.toCalendar(xmlGregorianCalender);
    }

    private java.util.Date convertObjectToUtilDate(Object sourceObject, QName schemaTypeQName) {
        if (sourceObject instanceof String) {
            return this.convertStringToDate((String)sourceObject, schemaTypeQName);
        }
        return super.convertObjectToUtilDate(sourceObject);
    }

    protected Date convertObjectToSQLDate(Object sourceObject, QName schemaTypeQName) {
        if (sourceObject instanceof String) {
            java.util.Date date = this.convertStringToDate((String)sourceObject, schemaTypeQName);
            return new Date(date.getTime() / 1000L * 1000L);
        }
        return this.convertObjectToDate(sourceObject);
    }

    protected Time convertObjectToSQLTime(Object sourceObject, QName schemaTypeQName) {
        if (sourceObject instanceof String) {
            java.util.Date date = this.convertStringToDate((String)sourceObject, schemaTypeQName);
            return new Time(date.getTime() / 1000L * 1000L);
        }
        return super.convertObjectToTime(sourceObject);
    }

    protected Timestamp convertStringToTimestamp(String sourceObject) {
        return this.convertStringToTimestamp(sourceObject, XMLConstants.DATE_TIME_QNAME);
    }

    protected Timestamp convertObjectToTimestamp(Object sourceObject, QName schemaTypeQName) {
        if (sourceObject instanceof String) {
            return this.convertStringToTimestamp((String)sourceObject, schemaTypeQName);
        }
        return super.convertObjectToTimestamp(sourceObject);
    }

    public Timestamp convertStringToTimestamp(String sourceString, QName schemaType) {
        QName calendarQName;
        XMLGregorianCalendar xmlGregorianCalender = null;
        try {
            xmlGregorianCalender = this.convertStringToXMLGregorianCalendar(sourceString);
        }
        catch (Exception exception) {
            if (XMLConstants.DATE_QNAME.equals(schemaType)) {
                throw ConversionException.incorrectDateFormat(sourceString);
            }
            if (XMLConstants.TIME_QNAME.equals(schemaType)) {
                throw XMLConversionException.incorrectTimestampTimeFormat(sourceString);
            }
            if (XMLConstants.G_DAY_QNAME.equals(schemaType)) {
                throw XMLConversionException.incorrectGDayFormat(sourceString);
            }
            if (XMLConstants.G_MONTH_QNAME.equals(schemaType)) {
                throw XMLConversionException.incorrectGMonthFormat(sourceString);
            }
            if (XMLConstants.G_MONTH_DAY_QNAME.equals(schemaType)) {
                throw XMLConversionException.incorrectGMonthDayFormat(sourceString);
            }
            if (XMLConstants.G_YEAR_QNAME.equals(schemaType)) {
                throw XMLConversionException.incorrectGYearFormat(sourceString);
            }
            if (XMLConstants.G_YEAR_MONTH_QNAME.equals(schemaType)) {
                throw XMLConversionException.incorrectGYearMonthFormat(sourceString);
            }
            if (XMLConstants.DURATION_QNAME.equals(schemaType)) {
                throw new IllegalArgumentException();
            }
            throw XMLConversionException.incorrectTimestampDateTimeFormat(sourceString);
        }
        GregorianCalendar cal = xmlGregorianCalender.toGregorianCalendar();
        if (xmlGregorianCalender.getTimezone() == Integer.MIN_VALUE) {
            cal.setTimeZone(this.getTimeZone());
        }
        if (!(calendarQName = xmlGregorianCalender.getXMLSchemaType()).equals(schemaType)) {
            if (XMLConstants.DATE_QNAME.equals(schemaType)) {
                if (calendarQName.equals(XMLConstants.DATE_TIME_QNAME)) {
                    cal.clear(11);
                    cal.clear(12);
                    cal.clear(13);
                    cal.clear(14);
                    return Helper.timestampFromCalendar(cal);
                }
                throw ConversionException.incorrectDateFormat(sourceString);
            }
            if (XMLConstants.TIME_QNAME.equals(schemaType)) {
                throw XMLConversionException.incorrectTimestampTimeFormat(sourceString);
            }
            if (XMLConstants.G_DAY_QNAME.equals(schemaType)) {
                throw XMLConversionException.incorrectGDayFormat(sourceString);
            }
            if (XMLConstants.G_MONTH_QNAME.equals(schemaType)) {
                throw XMLConversionException.incorrectGMonthFormat(sourceString);
            }
            if (XMLConstants.G_MONTH_DAY_QNAME.equals(schemaType)) {
                throw XMLConversionException.incorrectGMonthDayFormat(sourceString);
            }
            if (XMLConstants.G_YEAR_QNAME.equals(schemaType)) {
                throw XMLConversionException.incorrectGYearFormat(sourceString);
            }
            if (XMLConstants.G_YEAR_MONTH_QNAME.equals(schemaType)) {
                throw XMLConversionException.incorrectGYearMonthFormat(sourceString);
            }
            if (XMLConstants.DURATION_QNAME.equals(schemaType)) {
                throw new IllegalArgumentException();
            }
            if (XMLConstants.DATE_TIME_QNAME.equals(schemaType)) {
                throw XMLConversionException.incorrectTimestampDateTimeFormat(sourceString);
            }
        }
        Timestamp timestamp = Helper.timestampFromCalendar(cal);
        int decimalIndex = sourceString.lastIndexOf(46);
        if (-1 == decimalIndex) {
            return timestamp;
        }
        int timeZoneIndex = sourceString.lastIndexOf(GMT_SUFFIX);
        if (-1 == timeZoneIndex) {
            timeZoneIndex = sourceString.lastIndexOf(45);
            if (timeZoneIndex < decimalIndex) {
                timeZoneIndex = -1;
            }
            if (-1 == timeZoneIndex) {
                timeZoneIndex = sourceString.lastIndexOf(43);
            }
        }
        String nsString = -1 == timeZoneIndex ? sourceString.substring(decimalIndex + 1) : sourceString.substring(decimalIndex + 1, timeZoneIndex);
        double ns = Long.valueOf(nsString).doubleValue();
        timestamp.setNanos((int)(ns *= Math.pow(10.0, 9 - nsString.length())));
        return timestamp;
    }

    public String stringFromCalendar(Calendar sourceCalendar, QName schemaTypeQName) {
        Calendar cal = (Calendar)sourceCalendar.clone();
        XMLGregorianCalendar xgc = this.getDatatypeFactory().newXMLGregorianCalendar();
        if (sourceCalendar.isSet(15) || this.isTimeZoneQualified()) {
            if (sourceCalendar.isSet(16)) {
                xgc.setTimezone((cal.get(15) + cal.get(16)) / 60000);
            } else {
                xgc.setTimezone(cal.get(15) / 60000);
            }
        }
        if (XMLConstants.G_DAY_QNAME.equals(schemaTypeQName)) {
            xgc.setDay(cal.get(5));
            return xgc.toXMLFormat();
        }
        if (XMLConstants.G_MONTH_QNAME.equals(schemaTypeQName)) {
            xgc.setMonth(cal.get(2) + 1);
            String xmlFormat = xgc.toXMLFormat();
            String pre = xmlFormat.substring(0, 4);
            String post = "";
            if (xmlFormat.length() == 6) {
                if (this.trimGMonth()) {
                    return pre;
                }
                return xmlFormat;
            }
            if (xmlFormat.length() == 7 || xmlFormat.length() == 12) {
                if (this.trimGMonth()) {
                    return String.valueOf(pre) + xmlFormat.substring(6);
                }
                return xmlFormat;
            }
            if (xmlFormat.length() == 4) {
                if (this.trimGMonth()) {
                    return xmlFormat;
                }
                post = "--";
            }
            if (xmlFormat.length() == 5 || xmlFormat.length() == 10) {
                if (this.trimGMonth()) {
                    return xmlFormat;
                }
                post = "--" + xmlFormat.substring(4);
            }
            return String.valueOf(pre) + post;
        }
        if (XMLConstants.G_MONTH_DAY_QNAME.equals(schemaTypeQName)) {
            xgc.setMonth(cal.get(2) + 1);
            xgc.setDay(cal.get(5));
            return xgc.toXMLFormat();
        }
        if (XMLConstants.G_YEAR_QNAME.equals(schemaTypeQName)) {
            if (cal.get(0) == 0) {
                xgc.setYear(-cal.get(1));
            } else {
                xgc.setYear(cal.get(1));
            }
            return xgc.toXMLFormat();
        }
        if (XMLConstants.G_YEAR_MONTH_QNAME.equals(schemaTypeQName)) {
            if (cal.get(0) == 0) {
                xgc.setYear(-cal.get(1));
            } else {
                xgc.setYear(cal.get(1));
            }
            xgc.setMonth(cal.get(2) + 1);
            return xgc.toXMLFormat();
        }
        if (XMLConstants.DATE_QNAME.equals(schemaTypeQName)) {
            if (cal.get(0) == 0) {
                xgc.setYear(-cal.get(1));
            } else {
                xgc.setYear(cal.get(1));
            }
            xgc.setMonth(cal.get(2) + 1);
            xgc.setDay(cal.get(5));
            return xgc.toXMLFormat();
        }
        if (XMLConstants.TIME_QNAME.equals(schemaTypeQName)) {
            xgc.setTime(cal.get(11), cal.get(12), cal.get(13), cal.get(14));
            return this.truncateMillis(xgc.toXMLFormat());
        }
        if (cal.get(0) == 0) {
            xgc.setYear(-cal.get(1));
        } else {
            xgc.setYear(cal.get(1));
        }
        xgc.setMonth(cal.get(2) + 1);
        xgc.setDay(cal.get(5));
        xgc.setTime(cal.get(11), cal.get(12), cal.get(13), cal.get(14));
        return this.truncateMillis(xgc.toXMLFormat());
    }

    private String truncateMillis(String xmlFormat) {
        String result = xmlFormat;
        int dotIdx = xmlFormat.indexOf(46);
        if (dotIdx > 0) {
            String pre = xmlFormat.substring(0, dotIdx);
            String post = "";
            if (xmlFormat.length() > dotIdx + 4) {
                post = xmlFormat.substring(dotIdx + 4, xmlFormat.length());
            }
            String milliStr = xmlFormat.substring(dotIdx + 1, dotIdx + 4);
            char[] numbChar = new char[milliStr.length()];
            milliStr.getChars(0, milliStr.length(), numbChar, 0);
            int truncIndex = 2;
            while (truncIndex >= 1 && numbChar[truncIndex] == '0') {
                --truncIndex;
            }
            milliStr = new String(numbChar, 0, truncIndex + 1);
            if (milliStr.length() > 0) {
                milliStr = String.valueOf('.') + milliStr;
                result = String.valueOf(pre) + milliStr + post;
            } else {
                result = String.valueOf(pre) + post;
            }
        }
        return result;
    }

    private String stringFromCalendar(Calendar sourceCalendar) {
        if (!(sourceCalendar.isSet(10) || sourceCalendar.isSet(12) || sourceCalendar.isSet(13) || sourceCalendar.isSet(14))) {
            return this.stringFromCalendar(sourceCalendar, XMLConstants.DATE_QNAME);
        }
        if (!(sourceCalendar.isSet(1) || sourceCalendar.isSet(2) || sourceCalendar.isSet(5))) {
            return this.stringFromCalendar(sourceCalendar, XMLConstants.TIME_QNAME);
        }
        return this.stringFromCalendar(sourceCalendar, XMLConstants.DATE_TIME_QNAME);
    }

    public java.util.Date convertStringToDate(String sourceString, QName schemaType) {
        XMLGregorianCalendar xmlGregorianCalender = this.convertStringToXMLGregorianCalendar(sourceString, schemaType);
        Calendar cal = this.toCalendar(xmlGregorianCalender);
        java.util.Date returnDate = cal.getTime();
        return returnDate;
    }

    private Calendar toCalendar(XMLGregorianCalendar xgc) {
        BigInteger year;
        TimeZone tz = null;
        tz = xgc.getTimezone() == Integer.MIN_VALUE ? this.getTimeZone() : xgc.getTimeZone(xgc.getTimezone());
        Calendar cal = Calendar.getInstance(tz, Locale.getDefault());
        cal.clear();
        if (xgc.getTimezone() != Integer.MIN_VALUE) {
            cal.set(15, xgc.getTimezone() * 60000);
        }
        if ((year = xgc.getEonAndYear()) != null) {
            cal.set(0, year.signum() < 0 ? 0 : 1);
            cal.set(1, year.abs().intValue());
        }
        if (xgc.getDay() != Integer.MIN_VALUE) {
            cal.set(5, xgc.getDay());
        }
        if (xgc.getMonth() != Integer.MIN_VALUE) {
            cal.set(2, xgc.getMonth() - 1);
        }
        if (xgc.getHour() != Integer.MIN_VALUE) {
            cal.set(11, xgc.getHour());
        }
        if (xgc.getMinute() != Integer.MIN_VALUE) {
            cal.set(12, xgc.getMinute());
        }
        if (xgc.getSecond() != Integer.MIN_VALUE) {
            cal.set(13, xgc.getSecond());
        }
        if (xgc.getFractionalSecond() != null) {
            cal.set(14, xgc.getMillisecond());
        }
        return cal;
    }

    private String stringFromDate(java.util.Date sourceDate) {
        XMLGregorianCalendar xgc = this.getDatatypeFactory().newXMLGregorianCalendar();
        GregorianCalendar cal = new GregorianCalendar(this.getTimeZone());
        cal.setGregorianChange(new java.util.Date(Long.MIN_VALUE));
        cal.setTime(sourceDate);
        if (cal.get(0) == 0) {
            xgc.setYear(-cal.get(1));
        } else {
            xgc.setYear(cal.get(1));
        }
        xgc.setMonth(cal.get(2) + 1);
        xgc.setDay(cal.get(5));
        xgc.setHour(cal.get(11));
        xgc.setMinute(cal.get(12));
        xgc.setSecond(cal.get(13));
        String string = xgc.toXMLFormat();
        string = this.appendMillis(string, sourceDate.getTime());
        string = this.appendTimeZone(string, sourceDate);
        return string;
    }

    public String stringFromDate(java.util.Date sourceDate, QName schemaType) {
        XMLGregorianCalendar xgc = this.getDatatypeFactory().newXMLGregorianCalendar();
        if (XMLConstants.DATE_QNAME.equals(schemaType)) {
            GregorianCalendar cal = new GregorianCalendar(this.getTimeZone());
            cal.setTime(sourceDate);
            xgc.setDay(cal.get(5));
            xgc.setMonth(cal.get(2) + 1);
            if (cal.get(0) == 0) {
                xgc.setYear(-cal.get(1));
            } else {
                xgc.setYear(cal.get(1));
            }
            return xgc.toXMLFormat();
        }
        if (XMLConstants.TIME_QNAME.equals(schemaType)) {
            GregorianCalendar cal = new GregorianCalendar(this.getTimeZone());
            cal.setTime(sourceDate);
            xgc.setHour(cal.get(11));
            xgc.setMinute(cal.get(12));
            xgc.setSecond(cal.get(13));
            String string = xgc.toXMLFormat();
            string = this.appendMillis(string, sourceDate.getTime());
            return this.appendTimeZone(string, sourceDate);
        }
        if (XMLConstants.G_DAY_QNAME.equals(schemaType)) {
            GregorianCalendar cal = new GregorianCalendar(this.getTimeZone());
            cal.setTime(sourceDate);
            xgc.setDay(cal.get(5));
            return xgc.toXMLFormat();
        }
        if (XMLConstants.G_MONTH_QNAME.equals(schemaType)) {
            GregorianCalendar cal = new GregorianCalendar(this.getTimeZone());
            cal.setTime(sourceDate);
            xgc.setMonth(cal.get(2) + 1);
            return this.stringFromXMLGregorianCalendar(xgc, schemaType);
        }
        if (XMLConstants.G_MONTH_DAY_QNAME.equals(schemaType)) {
            GregorianCalendar cal = new GregorianCalendar(this.getTimeZone());
            cal.setTime(sourceDate);
            xgc.setMonth(cal.get(2) + 1);
            xgc.setDay(cal.get(5));
            return xgc.toXMLFormat();
        }
        if (XMLConstants.G_YEAR_QNAME.equals(schemaType)) {
            GregorianCalendar cal = new GregorianCalendar(this.getTimeZone());
            cal.setTime(sourceDate);
            if (cal.get(0) == 0) {
                xgc.setYear(-cal.get(1));
            } else {
                xgc.setYear(cal.get(1));
            }
            return xgc.toXMLFormat();
        }
        if (XMLConstants.G_YEAR_MONTH_QNAME.equals(schemaType)) {
            GregorianCalendar cal = new GregorianCalendar(this.getTimeZone());
            cal.setTime(sourceDate);
            if (cal.get(0) == 0) {
                xgc.setYear(-cal.get(1));
            } else {
                xgc.setYear(cal.get(1));
            }
            xgc.setMonth(cal.get(2) + 1);
            return xgc.toXMLFormat();
        }
        if (XMLConstants.DURATION_QNAME.equals(schemaType)) {
            throw new IllegalArgumentException();
        }
        GregorianCalendar cal = new GregorianCalendar(this.getTimeZone());
        cal.setTime(sourceDate);
        xgc = this.getDatatypeFactory().newXMLGregorianCalendar(cal);
        if (!this.isTimeZoneQualified()) {
            xgc.setTimezone(Integer.MIN_VALUE);
        }
        String string = xgc.toXMLFormat();
        return this.truncateMillis(string);
    }

    private String stringFromSQLDate(Date sourceDate) {
        XMLGregorianCalendar xgc = this.getDatatypeFactory().newXMLGregorianCalendar();
        GregorianCalendar cal = new GregorianCalendar(this.getTimeZone());
        cal.setGregorianChange(new java.util.Date(Long.MIN_VALUE));
        cal.setTime(sourceDate);
        if (cal.get(0) == 0) {
            xgc.setYear(-cal.get(1));
        } else {
            xgc.setYear(cal.get(1));
        }
        xgc.setMonth(cal.get(2) + 1);
        xgc.setDay(cal.get(5));
        return xgc.toXMLFormat();
    }

    private String stringFromSQLDate(Date sourceDate, QName schemaType) {
        if (XMLConstants.DATE_TIME_QNAME.equals(schemaType)) {
            XMLGregorianCalendar xgc = this.getDatatypeFactory().newXMLGregorianCalendar();
            GregorianCalendar cal = new GregorianCalendar(this.getTimeZone());
            cal.setGregorianChange(new java.util.Date(Long.MIN_VALUE));
            cal.setTime(sourceDate);
            if (cal.get(0) == 0) {
                xgc.setYear(-cal.get(1));
            } else {
                xgc.setYear(cal.get(1));
            }
            xgc.setMonth(cal.get(2) + 1);
            xgc.setDay(cal.get(5));
            xgc.setHour(cal.get(11));
            xgc.setMinute(cal.get(12));
            xgc.setSecond(cal.get(13));
            String string = xgc.toXMLFormat();
            return this.appendTimeZone(string, sourceDate);
        }
        if (XMLConstants.TIME_QNAME.equals(schemaType)) {
            XMLGregorianCalendar xgc = this.getDatatypeFactory().newXMLGregorianCalendar();
            GregorianCalendar cal = new GregorianCalendar(this.getTimeZone());
            cal.setGregorianChange(new java.util.Date(Long.MIN_VALUE));
            cal.setTime(sourceDate);
            xgc.setHour(cal.get(11));
            xgc.setMinute(cal.get(12));
            xgc.setSecond(cal.get(13));
            String string = xgc.toXMLFormat();
            return this.appendTimeZone(string, sourceDate);
        }
        if (XMLConstants.G_DAY_QNAME.equals(schemaType)) {
            XMLGregorianCalendar xgc = this.getDatatypeFactory().newXMLGregorianCalendar();
            GregorianCalendar cal = new GregorianCalendar(this.getTimeZone());
            cal.setGregorianChange(new java.util.Date(Long.MIN_VALUE));
            cal.setTime(sourceDate);
            xgc.setDay(cal.get(5));
            return xgc.toXMLFormat();
        }
        if (XMLConstants.G_MONTH_QNAME.equals(schemaType)) {
            XMLGregorianCalendar xgc = this.getDatatypeFactory().newXMLGregorianCalendar();
            GregorianCalendar cal = new GregorianCalendar(this.getTimeZone());
            cal.setGregorianChange(new java.util.Date(Long.MIN_VALUE));
            cal.setTime(sourceDate);
            xgc.setMonth(cal.get(2) + 1);
            return this.stringFromXMLGregorianCalendar(xgc, schemaType);
        }
        if (XMLConstants.G_MONTH_DAY_QNAME.equals(schemaType)) {
            XMLGregorianCalendar xgc = this.getDatatypeFactory().newXMLGregorianCalendar();
            GregorianCalendar cal = new GregorianCalendar(this.getTimeZone());
            cal.setGregorianChange(new java.util.Date(Long.MIN_VALUE));
            cal.setTime(sourceDate);
            xgc.setMonth(cal.get(2) + 1);
            xgc.setDay(cal.get(5));
            return xgc.toXMLFormat();
        }
        if (XMLConstants.G_YEAR_QNAME.equals(schemaType)) {
            XMLGregorianCalendar xgc = this.getDatatypeFactory().newXMLGregorianCalendar();
            GregorianCalendar cal = new GregorianCalendar(this.getTimeZone());
            cal.setGregorianChange(new java.util.Date(Long.MIN_VALUE));
            cal.setTime(sourceDate);
            if (cal.get(0) == 0) {
                xgc.setYear(-cal.get(1));
            } else {
                xgc.setYear(cal.get(1));
            }
            return xgc.toXMLFormat();
        }
        if (XMLConstants.G_YEAR_MONTH_QNAME.equals(schemaType)) {
            XMLGregorianCalendar xgc = this.getDatatypeFactory().newXMLGregorianCalendar();
            GregorianCalendar cal = new GregorianCalendar(this.getTimeZone());
            cal.setGregorianChange(new java.util.Date(Long.MIN_VALUE));
            cal.setTime(sourceDate);
            if (cal.get(0) == 0) {
                xgc.setYear(-cal.get(1));
            } else {
                xgc.setYear(cal.get(1));
            }
            xgc.setMonth(cal.get(2) + 1);
            return xgc.toXMLFormat();
        }
        if (XMLConstants.DURATION_QNAME.equals(schemaType)) {
            throw new IllegalArgumentException();
        }
        return this.stringFromSQLDate(sourceDate);
    }

    private String stringFromSQLTime(Time sourceTime) {
        XMLGregorianCalendar xgc = this.getDatatypeFactory().newXMLGregorianCalendar();
        GregorianCalendar cal = new GregorianCalendar(this.getTimeZone());
        cal.setGregorianChange(new java.util.Date(Long.MIN_VALUE));
        cal.setTime(sourceTime);
        xgc.setHour(cal.get(11));
        xgc.setMinute(cal.get(12));
        xgc.setSecond(cal.get(13));
        String string = xgc.toXMLFormat();
        return this.appendTimeZone(string, sourceTime);
    }

    private String stringFromSQLTime(Time sourceTime, QName schemaType) {
        if (XMLConstants.DATE_TIME_QNAME.equals(schemaType)) {
            XMLGregorianCalendar xgc = this.getDatatypeFactory().newXMLGregorianCalendar();
            GregorianCalendar cal = new GregorianCalendar(this.getTimeZone());
            cal.setGregorianChange(new java.util.Date(Long.MIN_VALUE));
            cal.setTime(sourceTime);
            if (cal.get(0) == 0) {
                xgc.setYear(-cal.get(1));
            } else {
                xgc.setYear(cal.get(1));
            }
            xgc.setMonth(cal.get(2) + 1);
            xgc.setDay(cal.get(5));
            xgc.setHour(cal.get(11));
            xgc.setMinute(cal.get(12));
            xgc.setSecond(cal.get(13));
            String string = xgc.toXMLFormat();
            return this.appendTimeZone(string, sourceTime);
        }
        if (XMLConstants.DATE_QNAME.equals(schemaType)) {
            XMLGregorianCalendar xgc = this.getDatatypeFactory().newXMLGregorianCalendar();
            GregorianCalendar cal = new GregorianCalendar(this.getTimeZone());
            cal.setGregorianChange(new java.util.Date(Long.MIN_VALUE));
            cal.setTime(sourceTime);
            if (cal.get(0) == 0) {
                xgc.setYear(-cal.get(1));
            } else {
                xgc.setYear(cal.get(1));
            }
            xgc.setMonth(cal.get(2) + 1);
            xgc.setDay(cal.get(5));
            return xgc.toXMLFormat();
        }
        if (XMLConstants.G_DAY_QNAME.equals(schemaType)) {
            XMLGregorianCalendar xgc = this.getDatatypeFactory().newXMLGregorianCalendar();
            GregorianCalendar cal = new GregorianCalendar(this.getTimeZone());
            cal.setGregorianChange(new java.util.Date(Long.MIN_VALUE));
            cal.setTime(sourceTime);
            xgc.setDay(cal.get(5));
            return xgc.toXMLFormat();
        }
        if (XMLConstants.G_MONTH_QNAME.equals(schemaType)) {
            XMLGregorianCalendar xgc = this.getDatatypeFactory().newXMLGregorianCalendar();
            GregorianCalendar cal = new GregorianCalendar(this.getTimeZone());
            cal.setGregorianChange(new java.util.Date(Long.MIN_VALUE));
            cal.setTime(sourceTime);
            xgc.setMonth(cal.get(2) + 1);
            return this.stringFromXMLGregorianCalendar(xgc, schemaType);
        }
        if (XMLConstants.G_MONTH_DAY_QNAME.equals(schemaType)) {
            XMLGregorianCalendar xgc = this.getDatatypeFactory().newXMLGregorianCalendar();
            GregorianCalendar cal = new GregorianCalendar(this.getTimeZone());
            cal.setGregorianChange(new java.util.Date(Long.MIN_VALUE));
            cal.setTime(sourceTime);
            xgc.setMonth(cal.get(2) + 1);
            xgc.setDay(cal.get(5));
            return xgc.toXMLFormat();
        }
        if (XMLConstants.G_YEAR_QNAME.equals(schemaType)) {
            XMLGregorianCalendar xgc = this.getDatatypeFactory().newXMLGregorianCalendar();
            GregorianCalendar cal = new GregorianCalendar(this.getTimeZone());
            cal.setGregorianChange(new java.util.Date(Long.MIN_VALUE));
            cal.setTime(sourceTime);
            if (cal.get(0) == 0) {
                xgc.setYear(-cal.get(1));
            } else {
                xgc.setYear(cal.get(1));
            }
            return xgc.toXMLFormat();
        }
        if (XMLConstants.G_YEAR_MONTH_QNAME.equals(schemaType)) {
            XMLGregorianCalendar xgc = this.getDatatypeFactory().newXMLGregorianCalendar();
            GregorianCalendar cal = new GregorianCalendar(this.getTimeZone());
            cal.setGregorianChange(new java.util.Date(Long.MIN_VALUE));
            cal.setTime(sourceTime);
            if (cal.get(0) == 0) {
                xgc.setYear(-cal.get(1));
            } else {
                xgc.setYear(cal.get(1));
            }
            xgc.setMonth(cal.get(2) + 1);
            return xgc.toXMLFormat();
        }
        if (XMLConstants.DURATION_QNAME.equals(schemaType)) {
            throw new IllegalArgumentException();
        }
        return this.stringFromSQLTime(sourceTime);
    }

    private String stringFromTimestamp(Timestamp sourceDate) {
        GregorianCalendar cal = new GregorianCalendar(this.getTimeZone());
        cal.setGregorianChange(new java.util.Date(Long.MIN_VALUE));
        cal.setTime(sourceDate);
        XMLGregorianCalendar xgc = this.getDatatypeFactory().newXMLGregorianCalendar();
        if (cal.get(0) == 0) {
            xgc.setYear(-cal.get(1));
        } else {
            xgc.setYear(cal.get(1));
        }
        xgc.setMonth(cal.get(2) + 1);
        xgc.setDay(cal.get(5));
        xgc.setHour(cal.get(11));
        xgc.setMinute(cal.get(12));
        xgc.setSecond(cal.get(13));
        String string = xgc.toXMLFormat();
        string = this.appendNanos(string, sourceDate);
        return this.appendTimeZone(string, sourceDate);
    }

    private String stringFromTimestamp(Timestamp sourceDate, QName schemaType) {
        if (XMLConstants.DATE_QNAME.equals(schemaType)) {
            GregorianCalendar cal = new GregorianCalendar(this.getTimeZone());
            cal.setGregorianChange(new java.util.Date(Long.MIN_VALUE));
            cal.setTime(sourceDate);
            XMLGregorianCalendar xgc = this.getDatatypeFactory().newXMLGregorianCalendar();
            if (cal.get(0) == 0) {
                xgc.setYear(-cal.get(1));
            } else {
                xgc.setYear(cal.get(1));
            }
            xgc.setMonth(cal.get(2) + 1);
            xgc.setDay(cal.get(5));
            return xgc.toXMLFormat();
        }
        if (XMLConstants.TIME_QNAME.equals(schemaType)) {
            Calendar cal = Calendar.getInstance(this.getTimeZone());
            cal.setTimeInMillis(sourceDate.getTime());
            XMLGregorianCalendar xgc = this.getDatatypeFactory().newXMLGregorianCalendar();
            xgc.setHour(cal.get(11));
            xgc.setMinute(cal.get(12));
            xgc.setSecond(cal.get(13));
            String string = xgc.toXMLFormat();
            string = this.appendNanos(string, sourceDate);
            return this.appendTimeZone(string, sourceDate);
        }
        if (XMLConstants.G_DAY_QNAME.equals(schemaType)) {
            XMLGregorianCalendar xgc = this.getDatatypeFactory().newXMLGregorianCalendar();
            GregorianCalendar cal = new GregorianCalendar(this.getTimeZone());
            cal.setGregorianChange(new java.util.Date(Long.MIN_VALUE));
            cal.setTime(sourceDate);
            xgc.setDay(cal.get(5));
            return xgc.toXMLFormat();
        }
        if (XMLConstants.G_MONTH_QNAME.equals(schemaType)) {
            XMLGregorianCalendar xgc = this.getDatatypeFactory().newXMLGregorianCalendar();
            GregorianCalendar cal = new GregorianCalendar(this.getTimeZone());
            cal.setGregorianChange(new java.util.Date(Long.MIN_VALUE));
            cal.setTime(sourceDate);
            xgc.setMonth(cal.get(2) + 1);
            return this.stringFromXMLGregorianCalendar(xgc, schemaType);
        }
        if (XMLConstants.G_MONTH_DAY_QNAME.equals(schemaType)) {
            XMLGregorianCalendar xgc = this.getDatatypeFactory().newXMLGregorianCalendar();
            GregorianCalendar cal = new GregorianCalendar(this.getTimeZone());
            cal.setGregorianChange(new java.util.Date(Long.MIN_VALUE));
            cal.setTime(sourceDate);
            xgc.setMonth(cal.get(2) + 1);
            xgc.setDay(cal.get(5));
            return xgc.toXMLFormat();
        }
        if (XMLConstants.G_YEAR_QNAME.equals(schemaType)) {
            XMLGregorianCalendar xgc = this.getDatatypeFactory().newXMLGregorianCalendar();
            GregorianCalendar cal = new GregorianCalendar(this.getTimeZone());
            cal.setGregorianChange(new java.util.Date(Long.MIN_VALUE));
            cal.setTime(sourceDate);
            if (cal.get(0) == 0) {
                xgc.setYear(-cal.get(1));
            } else {
                xgc.setYear(cal.get(1));
            }
            return xgc.toXMLFormat();
        }
        if (XMLConstants.G_YEAR_MONTH_QNAME.equals(schemaType)) {
            XMLGregorianCalendar xgc = this.getDatatypeFactory().newXMLGregorianCalendar();
            GregorianCalendar cal = new GregorianCalendar(this.getTimeZone());
            cal.setGregorianChange(new java.util.Date(Long.MIN_VALUE));
            cal.setTime(sourceDate);
            if (cal.get(0) == 0) {
                xgc.setYear(-cal.get(1));
            } else {
                xgc.setYear(cal.get(1));
            }
            xgc.setMonth(cal.get(2) + 1);
            return xgc.toXMLFormat();
        }
        if (XMLConstants.DURATION_QNAME.equals(schemaType)) {
            throw new IllegalArgumentException();
        }
        XMLGregorianCalendar xgc = this.getDatatypeFactory().newXMLGregorianCalendar();
        GregorianCalendar cal = new GregorianCalendar(this.getTimeZone());
        cal.setGregorianChange(new java.util.Date(Long.MIN_VALUE));
        cal.setTime(sourceDate);
        if (cal.get(0) == 0) {
            xgc.setYear(-cal.get(1));
        } else {
            xgc.setYear(cal.get(1));
        }
        xgc.setMonth(cal.get(2) + 1);
        xgc.setDay(cal.get(5));
        xgc.setHour(cal.get(11));
        xgc.setMinute(cal.get(12));
        xgc.setSecond(cal.get(13));
        String string = xgc.toXMLFormat();
        string = this.appendNanos(string, sourceDate);
        return this.appendTimeZone(string, sourceDate);
    }

    private String stringFromXMLGregorianCalendar(XMLGregorianCalendar cal, QName schemaTypeQName) {
        GregorianCalendar gCal = cal.toGregorianCalendar();
        if (cal.getTimezone() == Integer.MIN_VALUE) {
            gCal.clear(15);
        }
        return this.stringFromCalendar(gCal, schemaTypeQName);
    }

    private String stringFromXMLGregorianCalendar(XMLGregorianCalendar cal) {
        return cal.toXMLFormat();
    }

    private String stringFromDuration(Duration dur) {
        return dur.toString();
    }

    private String stringFromQName(QName sourceQName) {
        return sourceQName.toString();
    }

    private QName qnameFromString(String sourceString) {
        if (sourceString.indexOf(123) != -1) {
            String uri = sourceString.substring(sourceString.indexOf(123) + 1, sourceString.indexOf(125));
            String localpart = sourceString.substring(sourceString.indexOf(125) + 1);
            return new QName(uri, localpart);
        }
        return new QName(sourceString);
    }

    public byte[] convertSchemaBase64ToByteArray(Object sourceObject) throws ConversionException {
        if (sourceObject instanceof String) {
            StringTokenizer tokenizer = new StringTokenizer((String)sourceObject);
            StringBuilder builder = new StringBuilder();
            while (tokenizer.hasMoreTokens()) {
                builder.append(tokenizer.nextToken());
            }
            byte[] bytes = Base64.base64Decode(builder.toString().getBytes());
            return bytes;
        }
        return this.convertObjectToByteArray(sourceObject);
    }

    protected Byte[] convertSchemaBase64ToByteObjectArray(Object sourceObject) throws ConversionException {
        byte[] bytes = this.convertSchemaBase64ToByteArray(sourceObject);
        Byte[] objectBytes = new Byte[bytes.length];
        int index = 0;
        while (index < bytes.length) {
            objectBytes[index] = bytes[index];
            ++index;
        }
        return objectBytes;
    }

    public String buildBase64StringFromBytes(byte[] bytes) {
        byte[] convertedBytes = Base64.base64Encode(bytes);
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < convertedBytes.length) {
            buffer.append((char)convertedBytes[i]);
            ++i;
        }
        return buffer.toString();
    }

    public String buildBase64StringFromObjectBytes(Byte[] bytes) {
        byte[] primitiveBytes = new byte[bytes.length];
        int i = 0;
        while (i < bytes.length) {
            primitiveBytes[i] = bytes[i];
            ++i;
        }
        return this.buildBase64StringFromBytes(primitiveBytes);
    }

    protected String buildHexStringFromObjectBytes(Byte[] bytes) {
        byte[] primitiveBytes = new byte[bytes.length];
        int i = 0;
        while (i < bytes.length) {
            primitiveBytes[i] = bytes[i];
            ++i;
        }
        return Helper.buildHexStringFromBytes(primitiveBytes);
    }

    protected List convertStringToList(Object sourceObject) throws ConversionException {
        ArrayList<String> list = new ArrayList<String>();
        if (sourceObject instanceof String) {
            StringTokenizer tokenizer = new StringTokenizer((String)sourceObject, " ");
            while (tokenizer.hasMoreElements()) {
                String token = tokenizer.nextToken();
                list.add(token);
            }
        }
        return list;
    }

    public Object convertStringToList(Object sourceObject, Class elementType, ContainerPolicy containerPolicy) throws ConversionException {
        Collection collection = (Collection)containerPolicy.containerInstance();
        if (sourceObject instanceof String) {
            StringTokenizer tokenizer = new StringTokenizer((String)sourceObject, " ");
            while (tokenizer.hasMoreElements()) {
                String token = tokenizer.nextToken();
                collection.add(this.convertObject(token, elementType));
            }
        }
        return collection;
    }

    public String convertListToString(Object sourceObject) throws ConversionException {
        StringBuilder returnStringBuilder = new StringBuilder();
        if (sourceObject instanceof List) {
            List list = (List)sourceObject;
            int i = 0;
            int listSize = list.size();
            while (i < listSize) {
                Object next = list.get(i);
                if (i > 0) {
                    returnStringBuilder.append(' ');
                }
                returnStringBuilder.append(this.convertObjectToString(next));
                ++i;
            }
        }
        return returnStringBuilder.toString();
    }

    public static HashMap getDefaultXMLTypes() {
        if (defaultXMLTypes == null) {
            defaultXMLTypes = XMLConversionManager.buildXMLTypes();
        }
        return defaultXMLTypes;
    }

    public static HashMap getDefaultJavaTypes() {
        if (defaultJavaTypes == null) {
            defaultJavaTypes = XMLConversionManager.buildJavaTypes();
        }
        return defaultJavaTypes;
    }

    private static HashMap buildXMLTypes() {
        HashMap<QName, Class> XMLTypes = new HashMap<QName, Class>();
        XMLTypes.put(XMLConstants.BASE_64_BINARY_QNAME, ClassConstants.APBYTE);
        XMLTypes.put(XMLConstants.BOOLEAN_QNAME, ClassConstants.PBOOLEAN);
        XMLTypes.put(XMLConstants.BYTE_QNAME, ClassConstants.PBYTE);
        XMLTypes.put(XMLConstants.DATE_QNAME, ClassConstants.CALENDAR);
        XMLTypes.put(XMLConstants.DATE_TIME_QNAME, ClassConstants.CALENDAR);
        XMLTypes.put(XMLConstants.DECIMAL_QNAME, ClassConstants.BIGDECIMAL);
        XMLTypes.put(XMLConstants.DOUBLE_QNAME, ClassConstants.PDOUBLE);
        XMLTypes.put(XMLConstants.FLOAT_QNAME, ClassConstants.PFLOAT);
        XMLTypes.put(XMLConstants.HEX_BINARY_QNAME, ClassConstants.APBYTE);
        XMLTypes.put(XMLConstants.INT_QNAME, ClassConstants.PINT);
        XMLTypes.put(XMLConstants.INTEGER_QNAME, ClassConstants.BIGINTEGER);
        XMLTypes.put(XMLConstants.LONG_QNAME, ClassConstants.PLONG);
        XMLTypes.put(XMLConstants.QNAME_QNAME, XMLConstants.QNAME_CLASS);
        XMLTypes.put(XMLConstants.SHORT_QNAME, ClassConstants.PSHORT);
        XMLTypes.put(XMLConstants.STRING_QNAME, ClassConstants.STRING);
        XMLTypes.put(XMLConstants.TIME_QNAME, ClassConstants.CALENDAR);
        XMLTypes.put(XMLConstants.UNSIGNED_BYTE_QNAME, ClassConstants.PSHORT);
        XMLTypes.put(XMLConstants.UNSIGNED_INT_QNAME, ClassConstants.PLONG);
        XMLTypes.put(XMLConstants.UNSIGNED_SHORT_QNAME, ClassConstants.PINT);
        XMLTypes.put(XMLConstants.ANY_SIMPLE_TYPE_QNAME, ClassConstants.STRING);
        XMLTypes.put(XMLConstants.NAME_QNAME, ClassConstants.STRING);
        XMLTypes.put(XMLConstants.NCNAME_QNAME, ClassConstants.STRING);
        return XMLTypes;
    }

    private static HashMap buildJavaTypes() {
        HashMap<Class, QName> javaTypes = new HashMap<Class, QName>();
        javaTypes.put(ClassConstants.APBYTE, XMLConstants.HEX_BINARY_QNAME);
        javaTypes.put(ClassConstants.BIGDECIMAL, XMLConstants.DECIMAL_QNAME);
        javaTypes.put(ClassConstants.BIGINTEGER, XMLConstants.INTEGER_QNAME);
        javaTypes.put(ClassConstants.PBOOLEAN, XMLConstants.BOOLEAN_QNAME);
        javaTypes.put(ClassConstants.PBYTE, XMLConstants.BYTE_QNAME);
        javaTypes.put(ClassConstants.CALENDAR, XMLConstants.DATE_TIME_QNAME);
        javaTypes.put(ClassConstants.PDOUBLE, XMLConstants.DOUBLE_QNAME);
        javaTypes.put(ClassConstants.PFLOAT, XMLConstants.FLOAT_QNAME);
        javaTypes.put(ClassConstants.PINT, XMLConstants.INT_QNAME);
        javaTypes.put(ClassConstants.PLONG, XMLConstants.LONG_QNAME);
        javaTypes.put(ClassConstants.PSHORT, XMLConstants.SHORT_QNAME);
        javaTypes.put(XMLConstants.QNAME_CLASS, XMLConstants.QNAME_QNAME);
        javaTypes.put(ClassConstants.STRING, XMLConstants.STRING_QNAME);
        javaTypes.put(ClassConstants.ABYTE, XMLConstants.HEX_BINARY_QNAME);
        javaTypes.put(ClassConstants.BOOLEAN, XMLConstants.BOOLEAN_QNAME);
        javaTypes.put(ClassConstants.BYTE, XMLConstants.BYTE_QNAME);
        javaTypes.put(ClassConstants.GREGORIAN_CALENDAR, XMLConstants.DATE_TIME_QNAME);
        javaTypes.put(ClassConstants.DOUBLE, XMLConstants.DOUBLE_QNAME);
        javaTypes.put(ClassConstants.FLOAT, XMLConstants.FLOAT_QNAME);
        javaTypes.put(ClassConstants.INTEGER, XMLConstants.INT_QNAME);
        javaTypes.put(ClassConstants.LONG, XMLConstants.LONG_QNAME);
        javaTypes.put(ClassConstants.SHORT, XMLConstants.SHORT_QNAME);
        javaTypes.put(ClassConstants.UTILDATE, XMLConstants.DATE_TIME_QNAME);
        javaTypes.put(ClassConstants.CHAR, XMLConstants.UNSIGNED_INT_QNAME);
        javaTypes.put(ClassConstants.PCHAR, XMLConstants.UNSIGNED_INT_QNAME);
        javaTypes.put(ClassConstants.DURATION, XMLConstants.DURATION_QNAME);
        javaTypes.put(XMLConstants.UUID, XMLConstants.STRING_QNAME);
        javaTypes.put(XMLConstants.URI, XMLConstants.STRING_QNAME);
        javaTypes.put(ClassConstants.URL_Class, XMLConstants.ANY_URI_QNAME);
        return javaTypes;
    }

    private String appendTimeZone(String string, java.util.Date date) {
        if (!this.timeZoneQualified) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        int rawMinuteOffset = this.getTimeZone().getOffset(date.getTime()) / 60000;
        if (rawMinuteOffset == 0) {
            stringBuilder.append(GMT_SUFFIX);
            return stringBuilder.toString();
        }
        if (rawMinuteOffset < 0) {
            stringBuilder.append('-');
            rawMinuteOffset = Math.abs(rawMinuteOffset);
        } else {
            stringBuilder.append('+');
        }
        int hourOffset = rawMinuteOffset / 60;
        if (hourOffset < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(hourOffset);
        stringBuilder.append(':');
        int minuteOffset = rawMinuteOffset % 60;
        if (minuteOffset < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(minuteOffset);
        return stringBuilder.toString();
    }

    @Override
    public Object clone() {
        XMLConversionManager clone = (XMLConversionManager)super.clone();
        return clone;
    }

    private String appendNanos(String string, Timestamp ts) {
        StringBuilder strBldr = new StringBuilder(string);
        int nanos = ts.getNanos();
        strBldr.append(nanos == 0 ? ".0" : String.valueOf('.') + Helper.buildZeroPrefixAndTruncTrailZeros(nanos, TOTAL_NS_DIGITS)).toString();
        return strBldr.toString();
    }

    private String appendMillis(String string, long time) {
        StringBuilder strBldr = new StringBuilder(string);
        int msns = (int)(time % 1000L);
        if (msns < 0) {
            msns += 1000;
        }
        strBldr.append(msns == 0 ? ".0" : String.valueOf('.') + Helper.buildZeroPrefixAndTruncTrailZeros(msns, TOTAL_MS_DIGITS)).toString();
        return strBldr.toString();
    }

    public void setTrimGMonth(boolean value) {
        this.trimGMonth = value;
    }

    public boolean trimGMonth() {
        return this.trimGMonth;
    }

    public QName buildQNameFromString(String stringValue, XMLRecord record) {
        int index = stringValue.lastIndexOf(58);
        if (index > -1) {
            String prefix = stringValue.substring(0, index);
            String localName = stringValue.substring(index + 1);
            String namespaceURI = record.resolveNamespacePrefix(prefix);
            return new QName(namespaceURI, localName, prefix);
        }
        String namespaceURI = record.resolveNamespacePrefix("");
        if (namespaceURI == null) {
            namespaceURI = record.resolveNamespacePrefix(null);
        }
        return new QName(namespaceURI, stringValue);
    }

    public String normalizeStringValue(String value) {
        int i = 0;
        while (i < value.length()) {
            if (this.isWhitespace(value.charAt(i), false)) break;
            ++i;
        }
        if (i == value.length()) {
            return value;
        }
        char[] buffer = value.toCharArray();
        buffer[i] = 32;
        ++i;
        while (i < value.length()) {
            if (this.isWhitespace(buffer[i], false)) {
                buffer[i] = 32;
            }
            ++i;
        }
        return new String(buffer);
    }

    public String collapseStringValue(String value) {
        int length = value.length();
        int start = 0;
        while (start < length) {
            if (this.isWhitespace(value.charAt(start), true)) break;
            ++start;
        }
        if (start == length) {
            return value;
        }
        StringBuffer collapsedString = new StringBuffer(length);
        if (start != 0) {
            int i = 0;
            while (i < start) {
                collapsedString.append(value.charAt(i));
                ++i;
            }
            collapsedString.append(' ');
        }
        boolean inSequence = true;
        int i = start + 1;
        while (i < length) {
            char nextCharacter = value.charAt(i);
            if (!this.isWhitespace(nextCharacter, true)) {
                collapsedString.append(nextCharacter);
                inSequence = false;
            } else if (!inSequence) {
                collapsedString.append(' ');
                inSequence = true;
            }
            ++i;
        }
        length = collapsedString.length();
        if (length > 0 && collapsedString.charAt(length - 1) == ' ') {
            collapsedString.setLength(length - 1);
        }
        return collapsedString.toString();
    }

    private boolean isWhitespace(char character, boolean includeSpace) {
        if (character > ' ') {
            return false;
        }
        if (character == '\t' || character == '\n' || character == '\r') {
            return true;
        }
        if (includeSpace) {
            return character == ' ';
        }
        return false;
    }
}

