/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.columns;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.columns.JoinColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.OverrideMetadata;
import org.eclipse.persistence.internal.jpa.metadata.tables.JoinTableMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;

public class AssociationOverrideMetadata
extends OverrideMetadata {
    private JoinTableMetadata m_joinTable;
    private List<JoinColumnMetadata> m_joinColumns = new ArrayList<JoinColumnMetadata>();

    public AssociationOverrideMetadata() {
        super("<association-override>");
    }

    public AssociationOverrideMetadata(MetadataAnnotation associationOverride, MetadataAccessor accessor) {
        super(associationOverride, accessor);
        Object[] objectArray = (Object[])associationOverride.getAttributeArray("joinColumns");
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object joinColumn = objectArray[n2];
            this.m_joinColumns.add(new JoinColumnMetadata((MetadataAnnotation)joinColumn, accessor));
            ++n2;
        }
        this.m_joinTable = new JoinTableMetadata((MetadataAnnotation)associationOverride.getAttribute("joinTable"), accessor);
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof AssociationOverrideMetadata) {
            AssociationOverrideMetadata associationOverride = (AssociationOverrideMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_joinColumns, associationOverride.getJoinColumns())) {
                return false;
            }
            return this.valuesMatch(this.m_joinTable, associationOverride.getJoinTable());
        }
        return false;
    }

    @Override
    public String getIgnoreMappedSuperclassContext() {
        return "metadata_warning_ignore_mapped_superclass_association_override";
    }

    public List<JoinColumnMetadata> getJoinColumns() {
        return this.m_joinColumns;
    }

    public JoinTableMetadata getJoinTable() {
        return this.m_joinTable;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        for (JoinColumnMetadata jcm : this.m_joinColumns) {
            this.initXMLObject(jcm, accessibleObject);
        }
        this.initXMLObject(this.m_joinTable, accessibleObject);
    }

    public void setJoinColumns(List<JoinColumnMetadata> joinColumns) {
        this.m_joinColumns = joinColumns;
    }

    public void setJoinTable(JoinTableMetadata joinTable) {
        this.m_joinTable = joinTable;
    }
}

