/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.oracleddl.test.visit;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.oracleddl.metadata.ArgumentType;
import org.eclipse.persistence.tools.oracleddl.metadata.ProcedureType;
import org.eclipse.persistence.tools.oracleddl.metadata.visit.BaseDatabaseTypeVisitor;

class ProcedureTypeVisitor
extends BaseDatabaseTypeVisitor {
    public String procName;
    public String schema;
    public List<String> argData = new ArrayList<String>();

    ProcedureTypeVisitor() {
    }

    @Override
    public void beginVisit(ProcedureType procType) {
        this.procName = procType.getProcedureName();
        this.schema = procType.getSchema();
    }

    @Override
    public void beginVisit(ArgumentType argType) {
        if (argType.optional()) {
            this.argData.add(String.valueOf(argType.getArgumentName()) + "(opt) " + (Object)((Object)argType.getDirection()) + " " + argType.getEnclosedType());
        } else {
            this.argData.add(String.valueOf(argType.getArgumentName()) + " " + (Object)((Object)argType.getDirection()) + " " + argType.getEnclosedType());
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PROCEDURE ");
        if (this.schema != null) {
            sb.append(this.schema);
            sb.append(".");
        }
        sb.append(this.procName);
        sb.append(" (");
        int i = 0;
        while (i < this.argData.size()) {
            String arg = this.argData.get(i);
            sb.append(arg);
            if (++i >= this.argData.size()) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }
}

