/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.jpa.jpql.ContentAssistProposals;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.persistence.jpa.jpql.ResultQuery;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.IdentifierRole;
import org.eclipse.persistence.jpa.jpql.parser.JPQLGrammar;
import org.eclipse.persistence.jpa.jpql.spi.IEntity;
import org.eclipse.persistence.jpa.jpql.spi.IMapping;
import org.eclipse.persistence.jpa.jpql.util.iterator.CloneIterator;
import org.eclipse.persistence.jpa.jpql.util.iterator.IterableIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultContentAssistProposals
implements ContentAssistProposals {
    private Set<IEntity> abstractSchemaTypes;
    private Set<String> identificationVariables;
    private Set<String> identifiers;
    private JPQLGrammar jpqlGrammar;
    private Set<IMapping> mappings;
    private Map<String, IEntity> rangeIdentificationVariables;
    private static final Map<String, String> LONGUEST_IDENTIFIERS = DefaultContentAssistProposals.buildLonguestIdentifiers();
    private static final Map<String, List<String>> ORDERED_IDENTIFIERS = DefaultContentAssistProposals.buildOrderedIdentifiers();

    public DefaultContentAssistProposals(JPQLGrammar jpqlGrammar) {
        this.initialize(jpqlGrammar);
    }

    private static Map<String, String> buildLonguestIdentifiers() {
        HashMap<String, String> identifiers = new HashMap<String, String>();
        identifiers.put("IS EMPTY", "IS NOT EMPTY");
        identifiers.put("IS NULL", "IS NOT NULL");
        identifiers.put("IN", "NOT IN");
        identifiers.put("BETWEEN", "NOT BETWEEN");
        identifiers.put("MEMBER", "NOT MEMBER OF");
        identifiers.put("MEMBER OF", "NOT MEMBER OF");
        identifiers.put("NOT MEMBER", "NOT MEMBER OF");
        identifiers.put("JOIN", "LEFT OUTER JOIN FETCH");
        identifiers.put("JOIN FETCH", "LEFT OUTER JOIN FETCH");
        identifiers.put("LEFT JOIN", "LEFT OUTER JOIN FETCH");
        identifiers.put("LEFT JOIN FETCH", "LEFT OUTER JOIN FETCH");
        identifiers.put("LEFT OUTER JOIN", "LEFT OUTER JOIN FETCH");
        identifiers.put("INNER JOIN", "LEFT OUTER JOIN FETCH");
        identifiers.put("INNER JOIN FETCH", "LEFT OUTER JOIN FETCH");
        identifiers.put("SELECT", "DELETE FROM");
        identifiers.put("UPDATE", "DELETE FROM");
        return identifiers;
    }

    private static Map<String, List<String>> buildOrderedIdentifiers() {
        HashMap<String, List<String>> identifiers = new HashMap<String, List<String>>();
        identifiers.put("IS NOT EMPTY", Collections.singletonList("IS NOT EMPTY"));
        identifiers.put("IS NOT NULL", Collections.singletonList("IS NOT NULL"));
        identifiers.put("NOT IN", Collections.singletonList("NOT IN"));
        identifiers.put("NOT BETWEEN", Collections.singletonList("NOT BETWEEN"));
        ArrayList<String> members = new ArrayList<String>();
        members.add("MEMBER OF");
        members.add("NOT MEMBER");
        members.add("MEMBER");
        identifiers.put("NOT MEMBER OF", members);
        ArrayList<String> joins = new ArrayList<String>();
        joins.add("LEFT OUTER JOIN");
        joins.add("LEFT JOIN FETCH");
        joins.add("LEFT JOIN");
        joins.add("INNER JOIN FETCH");
        joins.add("INNER JOIN");
        joins.add("JOIN FETCH");
        joins.add("JOIN");
        identifiers.put("LEFT OUTER JOIN FETCH", joins);
        ArrayList<String> clauses = new ArrayList<String>();
        clauses.add("SELECT");
        clauses.add("UPDATE");
        identifiers.put("DELETE FROM", clauses);
        return identifiers;
    }

    @Override
    public IterableIterator<IEntity> abstractSchemaTypes() {
        return new CloneIterator<IEntity>(this.abstractSchemaTypes);
    }

    public void addAbstractSchemaType(IEntity abstractSchemaType) {
        this.abstractSchemaTypes.add(abstractSchemaType);
    }

    public void addIdentificationVariable(String identificationVariable) {
        this.identificationVariables.add(identificationVariable);
    }

    public void addIdentifier(String identifier) {
        this.identifiers.add(identifier);
    }

    public void addMapping(IMapping mapping) {
        this.mappings.add(mapping);
    }

    public void addMappings(Collection<IMapping> mappings) {
        this.mappings.addAll(mappings);
    }

    public void addRangeIdentificationVariable(String identificationVariable, IEntity abstractSchemaType) {
        this.rangeIdentificationVariables.put(identificationVariable, abstractSchemaType);
    }

    @Override
    public Result buildEscapedQuery(String jpqlQuery, String proposal, int position, boolean insert) {
        Result result = this.buildQuery(jpqlQuery, proposal, position, insert);
        int[] positions = new int[]{result.position};
        result.jpqlQuery = ExpressionTools.escape(result.jpqlQuery, positions);
        result.position = positions[0];
        return result;
    }

    private int[] buildPositions(WordParser wordParser, String proposal, boolean insert) {
        int length;
        int startPosition;
        int index;
        String wordsToReplace = null;
        if (wordParser.isArithmeticSymbol(proposal.charAt(0))) {
            char character;
            int startIndex;
            int endIndex = startIndex = wordParser.position();
            while (wordParser.isArithmeticSymbol(character = wordParser.character(--startIndex))) {
            }
            while (wordParser.isArithmeticSymbol(character = wordParser.character(endIndex++))) {
            }
            index = ++startIndex;
            wordsToReplace = wordParser.substring(index, --endIndex);
        } else {
            wordsToReplace = this.longuestIdentifier(proposal);
            index = this.startPositionImp(wordParser, wordsToReplace);
            if (index == -1 && ORDERED_IDENTIFIERS.containsKey(wordsToReplace)) {
                for (String identifier : ORDERED_IDENTIFIERS.get(wordsToReplace)) {
                    wordsToReplace = identifier;
                    index = this.startPositionImp(wordParser, wordsToReplace);
                    if (index > -1) break;
                }
            }
        }
        if (index > -1) {
            startPosition = index;
        } else {
            String partialWord = wordParser.partialWord();
            String entireWord = wordParser.entireWord();
            int dotIndex = partialWord.lastIndexOf(".");
            if (dotIndex > 0) {
                wordsToReplace = entireWord.substring(dotIndex + 1);
                startPosition = wordParser.position() - partialWord.length() + dotIndex + 1;
            } else if (insert) {
                wordsToReplace = wordParser.word();
                startPosition = wordParser.position() - partialWord.length();
            } else {
                wordsToReplace = entireWord;
                startPosition = wordParser.position() - partialWord.length();
            }
        }
        if (insert) {
            String partialWord = wordParser.substring(startPosition, wordParser.position());
            length = partialWord.length();
        } else if (proposal != wordsToReplace) {
            length = wordsToReplace.length();
        } else {
            index = 0;
            int charIndex = 0;
            int wordLength = wordParser.length();
            int count = wordsToReplace.length();
            while (startPosition + index < wordLength && charIndex < count) {
                if (wordParser.character(startPosition + charIndex) != wordsToReplace.charAt(charIndex)) break;
                ++index;
                ++charIndex;
            }
            length = index;
        }
        return new int[]{startPosition, startPosition + length};
    }

    @Override
    public Result buildQuery(String jpqlQuery, String proposal, int position, boolean insert) {
        if (ExpressionTools.stringIsEmpty(proposal)) {
            return new Result(jpqlQuery, position);
        }
        WordParser wordParser = new WordParser(jpqlQuery);
        wordParser.setPosition(position);
        int[] positions = this.buildPositions(wordParser, proposal, insert);
        StringBuilder sb = new StringBuilder(jpqlQuery);
        sb.replace(positions[0], positions[1], proposal);
        return new Result(sb.toString(), positions[0] + proposal.length());
    }

    @Override
    public IEntity getAbstractSchemaType(String identificationVariable) {
        return this.rangeIdentificationVariables.get(identificationVariable);
    }

    public JPQLGrammar getGrammar() {
        return this.jpqlGrammar;
    }

    @Override
    public IdentifierRole getIdentifierRole(String identifier) {
        return this.jpqlGrammar.getExpressionRegistry().getIdentifierRole(identifier);
    }

    @Override
    public boolean hasProposals() {
        return !this.mappings.isEmpty() || !this.identifiers.isEmpty() || !this.abstractSchemaTypes.isEmpty() || !this.identificationVariables.isEmpty();
    }

    @Override
    public IterableIterator<String> identificationVariables() {
        ArrayList<String> variables = new ArrayList<String>(this.identificationVariables.size() + this.rangeIdentificationVariables.size());
        variables.addAll(this.identificationVariables);
        variables.addAll(this.rangeIdentificationVariables.keySet());
        return new CloneIterator<String>(variables);
    }

    @Override
    public IterableIterator<String> identifiers() {
        return new CloneIterator<String>(this.identifiers);
    }

    private void initialize(JPQLGrammar jpqlGrammar) {
        this.jpqlGrammar = jpqlGrammar;
        this.mappings = new HashSet<IMapping>();
        this.identifiers = new HashSet<String>();
        this.abstractSchemaTypes = new HashSet<IEntity>();
        this.identificationVariables = new HashSet<String>();
        this.rangeIdentificationVariables = new HashMap<String, IEntity>();
    }

    private String longuestIdentifier(String proposal) {
        return LONGUEST_IDENTIFIERS.containsKey(proposal) ? LONGUEST_IDENTIFIERS.get(proposal) : proposal;
    }

    @Override
    public IterableIterator<IMapping> mappings() {
        return new CloneIterator<IMapping>(this.mappings);
    }

    public boolean remove(String proposal) {
        Iterator<Comparable<IMapping>> iter;
        boolean removed;
        boolean bl = removed = this.identifiers.remove(proposal) || this.identificationVariables.remove(proposal) || this.rangeIdentificationVariables.remove(proposal) != null;
        if (!removed) {
            iter = this.mappings.iterator();
            while (iter.hasNext()) {
                IMapping mapping = (IMapping)iter.next();
                if (!mapping.getName().equals(proposal)) continue;
                iter.remove();
                removed = true;
                break;
            }
        }
        if (!removed) {
            iter = this.abstractSchemaTypes.iterator();
            while (iter.hasNext()) {
                IEntity entity = (IEntity)iter.next();
                if (!entity.getName().equals(proposal)) continue;
                iter.remove();
                removed = true;
                break;
            }
        }
        return removed;
    }

    protected void removeIdentifier(String identifier) {
        this.identifiers.remove(identifier);
    }

    private int startPositionImp(WordParser wordParser, String proposal) {
        int index = wordParser.position();
        int maxMoveLength = proposal.length();
        while (index >= 0 && maxMoveLength > 0) {
            if (wordParser.startsWith(proposal, index)) {
                return index;
            }
            --index;
            --maxMoveLength;
        }
        return -1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.identifiers.isEmpty()) {
            sb.append(this.identifiers);
        }
        if (!this.abstractSchemaTypes.isEmpty()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(this.abstractSchemaTypes);
        }
        if (!this.identificationVariables.isEmpty()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(this.identificationVariables);
        }
        if (!this.mappings.isEmpty()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(this.mappings);
        }
        if (sb.length() == 0) {
            sb.append("<No Default Proposals>");
        }
        return sb.toString();
    }

    private final class Result
    implements ResultQuery {
        private String jpqlQuery;
        private int position;

        public Result(String jpqlQuery, int position) {
            this.jpqlQuery = jpqlQuery;
            this.position = position;
        }

        public int getPosition() {
            return this.position;
        }

        public String getQuery() {
            return this.jpqlQuery;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Query=[").append(this.jpqlQuery);
            sb.append("], position=").append(this.position);
            return sb.toString();
        }
    }
}

