/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.tools.spi.java;

import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.persistence.jpa.jpql.tools.spi.IEntity;
import org.eclipse.persistence.jpa.jpql.tools.spi.IManagedTypeProvider;
import org.eclipse.persistence.jpa.jpql.tools.spi.IManagedTypeVisitor;
import org.eclipse.persistence.jpa.jpql.tools.spi.IMappingBuilder;
import org.eclipse.persistence.jpa.jpql.tools.spi.IQuery;
import org.eclipse.persistence.jpa.jpql.tools.spi.java.JavaManagedType;
import org.eclipse.persistence.jpa.jpql.tools.spi.java.JavaQuery;
import org.eclipse.persistence.jpa.jpql.tools.spi.java.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaEntity
extends JavaManagedType
implements IEntity {
    private String name;
    private Map<String, IQuery> queries;

    public JavaEntity(IManagedTypeProvider provider, JavaType type, IMappingBuilder<Member> mappingBuilder) {
        super(provider, type, mappingBuilder);
    }

    @Override
    public void accept(IManagedTypeVisitor visitor) {
        visitor.visit(this);
    }

    protected String buildName() {
        Class<?> type = this.getType().getType();
        Entity entity = type.getAnnotation(Entity.class);
        String entityName = entity.name();
        if (ExpressionTools.stringIsEmpty(entityName)) {
            this.name = type.getSimpleName();
        }
        return this.name;
    }

    protected Map<String, IQuery> buildQueries() {
        HashMap<String, IQuery> queries = new HashMap<String, IQuery>();
        try {
            Class<?> type = this.getType().getType();
            Annotation[] annotations = type.getAnnotations();
            NamedQueries namedQueries = this.getAnnotation(annotations, NamedQueries.class);
            if (namedQueries != null) {
                NamedQuery[] namedQueryArray = namedQueries.value();
                int n = namedQueryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    NamedQuery namedQuery = namedQueryArray[n2];
                    IQuery query = this.buildQuery(namedQuery);
                    queries.put(namedQuery.name(), query);
                    ++n2;
                }
            } else {
                NamedQuery namedQuery = this.getAnnotation(annotations, NamedQuery.class);
                if (namedQuery != null) {
                    IQuery query = this.buildQuery(namedQuery);
                    queries.put(namedQuery.name(), query);
                }
            }
        }
        catch (Exception exception) {}
        return queries;
    }

    protected IQuery buildQuery(NamedQuery namedQuery) {
        return new JavaQuery(this.getProvider(), namedQuery.query());
    }

    protected <T extends Annotation> T getAnnotation(Annotation[] annotations, Class<T> annotationType) {
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotationType == annotation.annotationType()) {
                return (T)annotation;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = this.buildName();
        }
        return this.name;
    }

    @Override
    public IQuery getNamedQuery(String queryName) {
        this.initializeQueries();
        return this.queries.get(queryName);
    }

    protected boolean hasAnnotation(Annotation[] annotations, String annotationType) {
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotationType.equals(annotation.annotationType().getName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void initializeQueries() {
        if (this.queries == null) {
            this.queries = this.buildQueries();
        }
    }

    public String toString() {
        return this.getName();
    }
}

