/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;

public class QueryByExamplePolicy
implements Serializable {
    public Map valuesToExclude = new HashMap();
    public Map attributesToAlwaysInclude = new HashMap();
    public Map specialOperations = new HashMap();
    public boolean shouldUseEqualityForNulls = true;
    protected boolean validateExample;

    public QueryByExamplePolicy() {
        this.valuesToExclude = new HashMap(10);
        this.attributesToAlwaysInclude = new HashMap(5);
        this.specialOperations = new HashMap(5);
        this.excludeDefaultPrimitiveValues();
    }

    public void addSpecialOperation(Class attributeValueClass, String operation) {
        this.getSpecialOperations().put(attributeValueClass, operation);
    }

    public void alwaysIncludeAttribute(Class exampleClass, String attributeName) {
        Vector<String> included = (Vector<String>)this.getAttributesToAlwaysInclude().get(exampleClass);
        if (included == null) {
            included = new Vector<String>(3);
        }
        included.addElement(attributeName);
        this.getAttributesToAlwaysInclude().put(exampleClass, included);
    }

    public Expression completeExpression(Expression expression, Object attributeValue, Class attributeValueClass) {
        block10: {
            String operation = this.getOperation(attributeValue.getClass());
            if (operation == null) {
                return expression.equal(attributeValue);
            }
            Class[] argTypes = new Class[]{attributeValueClass};
            Object[] args = new Object[]{attributeValue};
            try {
                Method anOperator = Helper.getDeclaredMethod(ClassConstants.Expression_Class, operation, argTypes);
                if (anOperator == null) {
                    throw QueryException.methodDoesNotExistOnExpression(operation, argTypes);
                }
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        expression = (Expression)AccessController.doPrivileged(new PrivilegedMethodInvoker(anOperator, expression, args));
                        break block10;
                    }
                    catch (PrivilegedActionException ex) {
                        throw (RuntimeException)ex.getCause();
                    }
                }
                expression = (Expression)PrivilegedAccessHelper.invokeMethod(anOperator, expression, args);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Class superClass = attributeValueClass.getSuperclass();
                if (superClass != null) {
                    return this.completeExpression(expression, attributeValue, superClass);
                }
                throw QueryException.methodDoesNotExistOnExpression(operation, argTypes);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw QueryException.methodDoesNotExistOnExpression(operation, argTypes);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw QueryException.methodDoesNotExistOnExpression(operation, argTypes);
            }
        }
        return expression;
    }

    public Expression completeExpressionForNull(Expression expression) {
        if (this.shouldUseEqualityForNulls()) {
            return expression.isNull();
        }
        return expression.notNull();
    }

    public void excludeDefaultPrimitiveValues() {
        this.excludeValue(0);
        this.excludeValue(0.0);
        this.excludeValue(false);
        this.excludeValue((short)0);
        this.excludeValue('\u0000');
        this.excludeValue(0L);
        this.excludeValue((byte)0);
        this.excludeValue(0.0f);
        this.excludeValue(new String(""));
    }

    public void excludeValue(byte value) {
        this.excludeValue((Object)value);
    }

    public void excludeValue(char value) {
        this.excludeValue(Character.valueOf(value));
    }

    public void excludeValue(double value) {
        this.excludeValue((Object)value);
    }

    public void excludeValue(float value) {
        this.excludeValue(Float.valueOf(value));
    }

    public void excludeValue(int value) {
        this.excludeValue((Object)value);
    }

    public void excludeValue(long value) {
        this.excludeValue((Object)value);
    }

    public void excludeValue(Object value) {
        this.valuesToExclude.put(value, value);
    }

    public void excludeValue(short value) {
        this.excludeValue((Object)value);
    }

    public void excludeValue(boolean value) {
        this.excludeValue((Object)value);
    }

    public Map getAttributesToAlwaysInclude() {
        return this.attributesToAlwaysInclude;
    }

    public String getOperation(Class aClass) {
        String operation = (String)this.getSpecialOperations().get(aClass);
        if (operation != null && !operation.equals("equal")) {
            return operation;
        }
        return null;
    }

    public Map getSpecialOperations() {
        return this.specialOperations;
    }

    public Map getValuesToExclude() {
        return this.valuesToExclude;
    }

    public void includeAllValues() {
        this.setValuesToExclude(new HashMap(5));
    }

    public boolean isAlwaysIncluded(Class theClass, String attributeName) {
        Vector values = (Vector)this.getAttributesToAlwaysInclude().get(theClass);
        if (values != null) {
            return values.contains(attributeName);
        }
        return false;
    }

    public boolean isExcludedValue(Object value) {
        return this.getValuesToExclude().containsKey(value);
    }

    public void removeFromValuesToExclude(Object value) {
        this.getValuesToExclude().remove(value);
    }

    public void setAttributesToAlwaysInclude(Map newAttributesToAlwaysInclude) {
        this.attributesToAlwaysInclude = newAttributesToAlwaysInclude;
    }

    public void setShouldUseEqualityForNulls(boolean shouldUseEqualityForNulls) {
        this.shouldUseEqualityForNulls = shouldUseEqualityForNulls;
    }

    public void setSpecialOperations(Map newOperations) {
        this.specialOperations = newOperations;
    }

    public void setValidateExample(boolean validate) {
        this.validateExample = validate;
    }

    public void setValuesToExclude(Map newValuesToExclude) {
        this.valuesToExclude = newValuesToExclude;
    }

    public boolean shouldIncludeInQuery(Class aClass, String attributeName, Object attributeValue) {
        if (attributeValue == null) {
            return this.isAlwaysIncluded(aClass, attributeName);
        }
        if (this.isExcludedValue(attributeValue)) {
            return this.isAlwaysIncluded(aClass, attributeName);
        }
        return true;
    }

    public boolean shouldUseEqualityForNulls() {
        return this.shouldUseEqualityForNulls;
    }

    public boolean shouldValidateExample() {
        return this.validateExample;
    }
}

