/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.compiler;

import java.awt.Image;
import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementDecl;
import javax.xml.bind.annotation.XmlMixed;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.NormalizedStringAdapter;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.eclipse.persistence.config.DescriptorCustomizer;
import org.eclipse.persistence.core.descriptors.CoreDescriptor;
import org.eclipse.persistence.core.mappings.CoreAttributeAccessor;
import org.eclipse.persistence.core.mappings.CoreMapping;
import org.eclipse.persistence.core.mappings.converters.CoreConverter;
import org.eclipse.persistence.core.queries.CoreAttributeGroup;
import org.eclipse.persistence.core.sessions.CoreProject;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.JAXBException;
import org.eclipse.persistence.internal.core.descriptors.CoreInstantiationPolicy;
import org.eclipse.persistence.internal.core.helper.CoreClassConstants;
import org.eclipse.persistence.internal.core.helper.CoreField;
import org.eclipse.persistence.internal.core.queries.CoreContainerPolicy;
import org.eclipse.persistence.internal.descriptors.InstanceVariableAttributeAccessor;
import org.eclipse.persistence.internal.descriptors.InstantiationPolicy;
import org.eclipse.persistence.internal.descriptors.MethodAttributeAccessor;
import org.eclipse.persistence.internal.descriptors.VirtualAttributeAccessor;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jaxb.AccessorFactoryWrapper;
import org.eclipse.persistence.internal.jaxb.CustomAccessorAttributeAccessor;
import org.eclipse.persistence.internal.jaxb.DefaultElementConverter;
import org.eclipse.persistence.internal.jaxb.DomHandlerConverter;
import org.eclipse.persistence.internal.jaxb.JAXBElementConverter;
import org.eclipse.persistence.internal.jaxb.JAXBElementRootConverter;
import org.eclipse.persistence.internal.jaxb.JAXBSetMethodAttributeAccessor;
import org.eclipse.persistence.internal.jaxb.JaxbClassLoader;
import org.eclipse.persistence.internal.jaxb.MultiArgInstantiationPolicy;
import org.eclipse.persistence.internal.jaxb.WrappedValue;
import org.eclipse.persistence.internal.jaxb.XMLJavaTypeConverter;
import org.eclipse.persistence.internal.jaxb.many.JAXBArrayAttributeAccessor;
import org.eclipse.persistence.internal.jaxb.many.ManyValue;
import org.eclipse.persistence.internal.jaxb.many.MapValue;
import org.eclipse.persistence.internal.jaxb.many.MapValueAttributeAccessor;
import org.eclipse.persistence.internal.libraries.asm.EclipseLinkASMClassWriter;
import org.eclipse.persistence.internal.libraries.asm.MethodVisitor;
import org.eclipse.persistence.internal.libraries.asm.Type;
import org.eclipse.persistence.internal.localization.JAXBLocalization;
import org.eclipse.persistence.internal.oxm.Constants;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.mappings.AnyAttributeMapping;
import org.eclipse.persistence.internal.oxm.mappings.AnyCollectionMapping;
import org.eclipse.persistence.internal.oxm.mappings.AnyObjectMapping;
import org.eclipse.persistence.internal.oxm.mappings.BinaryDataCollectionMapping;
import org.eclipse.persistence.internal.oxm.mappings.BinaryDataMapping;
import org.eclipse.persistence.internal.oxm.mappings.ChoiceCollectionMapping;
import org.eclipse.persistence.internal.oxm.mappings.ChoiceObjectMapping;
import org.eclipse.persistence.internal.oxm.mappings.CollectionReferenceMapping;
import org.eclipse.persistence.internal.oxm.mappings.CompositeCollectionMapping;
import org.eclipse.persistence.internal.oxm.mappings.CompositeObjectMapping;
import org.eclipse.persistence.internal.oxm.mappings.Descriptor;
import org.eclipse.persistence.internal.oxm.mappings.DirectCollectionMapping;
import org.eclipse.persistence.internal.oxm.mappings.DirectMapping;
import org.eclipse.persistence.internal.oxm.mappings.Field;
import org.eclipse.persistence.internal.oxm.mappings.InverseReferenceMapping;
import org.eclipse.persistence.internal.oxm.mappings.Mapping;
import org.eclipse.persistence.internal.oxm.mappings.MimeTypePolicy;
import org.eclipse.persistence.internal.oxm.mappings.ObjectReferenceMapping;
import org.eclipse.persistence.internal.oxm.mappings.TransformationMapping;
import org.eclipse.persistence.internal.oxm.mappings.VariableXPathCollectionMapping;
import org.eclipse.persistence.internal.oxm.mappings.VariableXPathObjectMapping;
import org.eclipse.persistence.internal.oxm.mappings.XMLContainerMapping;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.jaxb.JAXBEnumTypeConverter;
import org.eclipse.persistence.jaxb.TypeMappingInfo;
import org.eclipse.persistence.jaxb.compiler.CompilerHelper;
import org.eclipse.persistence.jaxb.compiler.ElementDeclaration;
import org.eclipse.persistence.jaxb.compiler.EnumTypeInfo;
import org.eclipse.persistence.jaxb.compiler.NamespaceInfo;
import org.eclipse.persistence.jaxb.compiler.PackageInfo;
import org.eclipse.persistence.jaxb.compiler.Property;
import org.eclipse.persistence.jaxb.compiler.TypeInfo;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaField;
import org.eclipse.persistence.jaxb.javamodel.JavaMethod;
import org.eclipse.persistence.jaxb.xmlmodel.XmlAbstractNullPolicy;
import org.eclipse.persistence.jaxb.xmlmodel.XmlElementWrapper;
import org.eclipse.persistence.jaxb.xmlmodel.XmlIsSetNullPolicy;
import org.eclipse.persistence.jaxb.xmlmodel.XmlJavaTypeAdapter;
import org.eclipse.persistence.jaxb.xmlmodel.XmlJoinNodes;
import org.eclipse.persistence.jaxb.xmlmodel.XmlNamedAttributeNode;
import org.eclipse.persistence.jaxb.xmlmodel.XmlNamedObjectGraph;
import org.eclipse.persistence.jaxb.xmlmodel.XmlNamedSubgraph;
import org.eclipse.persistence.jaxb.xmlmodel.XmlNullPolicy;
import org.eclipse.persistence.jaxb.xmlmodel.XmlRootElement;
import org.eclipse.persistence.jaxb.xmlmodel.XmlTransformation;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.FixedMimeTypePolicy;
import org.eclipse.persistence.oxm.mappings.UnmarshalKeepAsElementPolicy;
import org.eclipse.persistence.oxm.mappings.XMLAnyAttributeMapping;
import org.eclipse.persistence.oxm.mappings.XMLAnyCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLAnyObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLBinaryDataCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLBinaryDataMapping;
import org.eclipse.persistence.oxm.mappings.XMLChoiceCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLChoiceObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLCollectionReferenceMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeDirectCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.oxm.mappings.XMLInverseReferenceMapping;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.mappings.XMLObjectReferenceMapping;
import org.eclipse.persistence.oxm.mappings.XMLTransformationMapping;
import org.eclipse.persistence.oxm.mappings.XMLVariableXPathCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLVariableXPathObjectMapping;
import org.eclipse.persistence.oxm.mappings.converters.XMLConverter;
import org.eclipse.persistence.oxm.mappings.converters.XMLListConverter;
import org.eclipse.persistence.oxm.mappings.nullpolicy.AbstractNullPolicy;
import org.eclipse.persistence.oxm.mappings.nullpolicy.IsSetNullPolicy;
import org.eclipse.persistence.oxm.mappings.nullpolicy.NullPolicy;
import org.eclipse.persistence.oxm.mappings.nullpolicy.XMLNullRepresentationType;
import org.eclipse.persistence.oxm.schema.XMLSchemaClassPathReference;
import org.eclipse.persistence.oxm.schema.XMLSchemaReference;
import org.eclipse.persistence.queries.AttributeGroup;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;

public class MappingsGenerator {
    private static final String ATT = "@";
    private static final String TXT = "/text()";
    private static String OBJECT_CLASS_NAME = "java.lang.Object";
    public static final QName RESERVED_QNAME = new QName("urn:ECLIPSELINK_RESERVEDURI", "RESERVEDNAME");
    String outputDir = ".";
    private Map<String, QName> userDefinedSchemaTypes;
    private org.eclipse.persistence.jaxb.javamodel.Helper helper;
    private JavaClass jotArrayList;
    private JavaClass jotHashSet;
    private JavaClass jotHashMap;
    private JavaClass jotLinkedList;
    private JavaClass jotTreeSet;
    private Map<String, PackageInfo> packageToPackageInfoMappings;
    private Map<String, TypeInfo> typeInfo;
    private Map<QName, Class> qNamesToGeneratedClasses;
    private Map<String, Class> classToGeneratedClasses;
    private Map<QName, Class> qNamesToDeclaredClasses;
    private Map<QName, ElementDeclaration> globalElements;
    private List<ElementDeclaration> localElements;
    private Map<TypeMappingInfo, Class> typeMappingInfoToGeneratedClasses;
    private Map<MapEntryGeneratedKey, Class> generatedMapEntryClasses;
    private CoreProject project;
    private NamespaceResolver globalNamespaceResolver;
    private boolean isDefaultNamespaceAllowed;
    private Map<TypeMappingInfo, Class> typeMappingInfoToAdapterClasses;

    public MappingsGenerator(org.eclipse.persistence.jaxb.javamodel.Helper helper) {
        this.helper = helper;
        this.jotArrayList = helper.getJavaClass(ArrayList.class);
        this.jotHashSet = helper.getJavaClass(HashSet.class);
        this.jotHashMap = helper.getJavaClass(HashMap.class);
        this.jotLinkedList = helper.getJavaClass(LinkedList.class);
        this.jotTreeSet = helper.getJavaClass(TreeSet.class);
        this.qNamesToGeneratedClasses = new HashMap<QName, Class>();
        this.qNamesToDeclaredClasses = new HashMap<QName, Class>();
        this.classToGeneratedClasses = new HashMap<String, Class>();
        this.globalNamespaceResolver = new NamespaceResolver();
        this.isDefaultNamespaceAllowed = true;
    }

    public CoreProject generateProject(List<JavaClass> typeInfoClasses, Map<String, TypeInfo> typeInfo, Map<String, QName> userDefinedSchemaTypes, Map<String, PackageInfo> packageToPackageInfoMappings, Map<QName, ElementDeclaration> globalElements, List<ElementDeclaration> localElements, Map<TypeMappingInfo, Class> typeMappingInfoToGeneratedClass, Map<TypeMappingInfo, Class> typeMappingInfoToAdapterClasses, boolean isDefaultNamespaceAllowed) throws Exception {
        this.typeInfo = typeInfo;
        this.userDefinedSchemaTypes = userDefinedSchemaTypes;
        this.packageToPackageInfoMappings = packageToPackageInfoMappings;
        this.isDefaultNamespaceAllowed = isDefaultNamespaceAllowed;
        this.globalElements = globalElements;
        this.localElements = localElements;
        this.typeMappingInfoToGeneratedClasses = typeMappingInfoToGeneratedClass;
        this.typeMappingInfoToAdapterClasses = typeMappingInfoToAdapterClasses;
        this.project = new Project();
        this.processDefaultNamespacePreferences(packageToPackageInfoMappings.values());
        for (JavaClass next : typeInfoClasses) {
            if (next.isEnum()) continue;
            this.generateDescriptor(next, this.project);
        }
        for (JavaClass next : typeInfoClasses) {
            if (next.isEnum()) continue;
            this.setupInheritance(next);
        }
        this.generateMappings();
        for (JavaClass next : typeInfoClasses) {
            this.setupAttributeGroups(next);
        }
        Set<Map.Entry<String, TypeInfo>> entrySet = this.typeInfo.entrySet();
        for (Map.Entry<String, TypeInfo> entry : entrySet) {
            TypeInfo tInfo = entry.getValue();
            if (tInfo.getXmlCustomizer() == null) continue;
            String customizerClassName = tInfo.getXmlCustomizer();
            try {
                Class customizerClass = PrivilegedAccessHelper.getClassForName((String)customizerClassName, (boolean)true, (ClassLoader)this.helper.getClassLoader());
                DescriptorCustomizer descriptorCustomizer = (DescriptorCustomizer)PrivilegedAccessHelper.newInstanceFromClass((Class)customizerClass);
                descriptorCustomizer.customize((ClassDescriptor)((XMLDescriptor)tInfo.getDescriptor()));
            }
            catch (IllegalAccessException iae) {
                throw JAXBException.couldNotCreateCustomizerInstance((Exception)iae, (String)customizerClassName);
            }
            catch (InstantiationException ie) {
                throw JAXBException.couldNotCreateCustomizerInstance((Exception)ie, (String)customizerClassName);
            }
            catch (ClassCastException cce) {
                throw JAXBException.invalidCustomizerClass((Exception)cce, (String)customizerClassName);
            }
            catch (ClassNotFoundException cnfe) {
                throw JAXBException.couldNotCreateCustomizerInstance((Exception)cnfe, (String)customizerClassName);
            }
        }
        this.processGlobalElements(this.project);
        return this.project;
    }

    private void setupAttributeGroups(JavaClass javaClass) {
        TypeInfo info = this.typeInfo.get(javaClass.getQualifiedName());
        XMLDescriptor descriptor = (XMLDescriptor)info.getDescriptor();
        if (!info.getObjectGraphs().isEmpty()) {
            for (XmlNamedObjectGraph next : info.getObjectGraphs()) {
                AttributeGroup group = descriptor.getAttributeGroup(next.getName());
                Map<String, List<CoreAttributeGroup>> subgraphs = this.processSubgraphs(next.getXmlNamedSubgraph());
                for (XmlNamedAttributeNode nextAttributeNode : next.getXmlNamedAttributeNode()) {
                    if (nextAttributeNode.getSubgraph() == null || nextAttributeNode.getSubgraph().length() == 0) {
                        group.addAttribute(nextAttributeNode.getName());
                        continue;
                    }
                    List<CoreAttributeGroup> nestedGroups = subgraphs.get(nextAttributeNode.getSubgraph());
                    if (nestedGroups == null || nestedGroups.isEmpty()) {
                        JavaClass cls;
                        TypeInfo referenceType;
                        Property property = info.getProperties().get(nextAttributeNode.getName());
                        if (property == null || (referenceType = this.typeInfo.get((cls = property.getActualType()).getQualifiedName())) == null) continue;
                        AttributeGroup targetGroup = (AttributeGroup)referenceType.getDescriptor().getAttributeGroup(nextAttributeNode.getSubgraph());
                        group.addAttribute(nextAttributeNode.getName(), targetGroup);
                        continue;
                    }
                    if (nestedGroups.size() == 1) {
                        group.addAttribute(nextAttributeNode.getName(), nestedGroups.get(0));
                        continue;
                    }
                    group.addAttribute(nextAttributeNode.getName(), nestedGroups);
                }
                for (XmlNamedSubgraph nextSubclass : next.getXmlNamedSubclassGraph()) {
                    AttributeGroup subclassGroup = new AttributeGroup(next.getName(), nextSubclass.getType(), true);
                    group.getSubClassGroups().put(nextSubclass.getType(), subclassGroup);
                    for (XmlNamedAttributeNode nextAttributeNode : nextSubclass.getXmlNamedAttributeNode()) {
                        if (nextAttributeNode.getSubgraph() == null || nextAttributeNode.getSubgraph().length() == 0) {
                            subclassGroup.addAttribute(nextAttributeNode.getName());
                            continue;
                        }
                        List<CoreAttributeGroup> nestedGroups = subgraphs.get(nextAttributeNode.getSubgraph());
                        if (nestedGroups == null || nestedGroups.isEmpty()) {
                            Property property = info.getProperties().get(nextAttributeNode.getName());
                            JavaClass cls = property.getActualType();
                            TypeInfo referenceType = this.typeInfo.get(cls.getQualifiedName());
                            if (referenceType == null) continue;
                            AttributeGroup targetGroup = (AttributeGroup)referenceType.getDescriptor().getAttributeGroup(nextAttributeNode.getSubgraph());
                            subclassGroup.addAttribute(nextAttributeNode.getName(), targetGroup);
                            continue;
                        }
                        if (nestedGroups.size() == 1) {
                            subclassGroup.addAttribute(nextAttributeNode.getName(), nestedGroups.get(0));
                            continue;
                        }
                        subclassGroup.addAttribute(nextAttributeNode.getName(), nestedGroups);
                    }
                }
            }
        }
    }

    private Map<String, List<CoreAttributeGroup>> processSubgraphs(List<XmlNamedSubgraph> subgraphs) {
        HashMap<String, List<CoreAttributeGroup>> subgroups = new HashMap<String, List<CoreAttributeGroup>>();
        for (XmlNamedSubgraph next : subgraphs) {
            List<AttributeGroup> groups;
            AttributeGroup group;
            String type = next.getType();
            if (type == null) {
                type = "java.lang.Object";
            }
            if (subgroups.containsKey((group = new AttributeGroup(next.getName(), type, false)).getName())) {
                groups = (List)subgroups.get(group.getName());
                groups.add(group);
                continue;
            }
            groups = new ArrayList(1);
            groups.add(group);
            subgroups.put(group.getName(), groups);
        }
        for (XmlNamedSubgraph next : subgraphs) {
            List<XmlNamedAttributeNode> attributeNodes = next.getXmlNamedAttributeNode();
            List attributeGroups = (List)subgroups.get(next.getName());
            if (attributeGroups == null) continue;
            for (CoreAttributeGroup group : attributeGroups) {
                String typeName = next.getType();
                if (typeName == null) {
                    typeName = "java.lang.Object";
                }
                if (!group.getTypeName().equals(typeName)) continue;
                for (XmlNamedAttributeNode attributeNode : attributeNodes) {
                    if (attributeNode.getSubgraph() == null || attributeNode.getSubgraph().length() == 0) {
                        group.addAttribute(attributeNode.getName());
                        continue;
                    }
                    List nestedGroups = (List)subgroups.get(attributeNode.getSubgraph());
                    if (nestedGroups == null || nestedGroups.size() == 0) continue;
                    group.addAttribute(attributeNode.getName(), (CoreAttributeGroup)nestedGroups.get(0));
                }
            }
        }
        return subgroups;
    }

    public void generateDescriptor(JavaClass javaClass, CoreProject project) {
        String namespace;
        String elementName;
        String jClassName = javaClass.getQualifiedName();
        TypeInfo info = this.typeInfo.get(jClassName);
        if (info.isTransient()) {
            return;
        }
        NamespaceInfo namespaceInfo = this.packageToPackageInfoMappings.get(javaClass.getPackageName()).getNamespaceInfo();
        String packageNamespace = namespaceInfo.getNamespace();
        if (javaClass.getSuperclass() != null && javaClass.getSuperclass().getName().equals("javax.xml.bind.JAXBElement")) {
            this.generateDescriptorForJAXBElementSubclass(javaClass, project, this.getNamespaceResolverForDescriptor(namespaceInfo));
            return;
        }
        XMLDescriptor descriptor = new XMLDescriptor();
        XmlRootElement rootElem = info.getXmlRootElement();
        if (rootElem == null) {
            try {
                elementName = info.getXmlNameTransformer().transformRootElementName(javaClass.getName());
            }
            catch (Exception ex) {
                throw JAXBException.exceptionDuringNameTransformation((String)javaClass.getName(), (String)info.getXmlNameTransformer().getClass().getName(), (Exception)ex);
            }
            namespace = packageNamespace;
        } else {
            elementName = rootElem.getName();
            if (elementName.equals("##default")) {
                try {
                    elementName = info.getXmlNameTransformer().transformRootElementName(javaClass.getName());
                }
                catch (Exception ex) {
                    throw JAXBException.exceptionDuringNameTransformation((String)javaClass.getName(), (String)info.getXmlNameTransformer().getClass().getName(), (Exception)ex);
                }
            }
            namespace = rootElem.getNamespace();
        }
        descriptor.setJavaClassName(jClassName);
        if (info.getFactoryMethodName() != null) {
            descriptor.getInstantiationPolicy().useFactoryInstantiationPolicy(info.getObjectFactoryClassName(), info.getFactoryMethodName());
        }
        if (namespace.equals("##default")) {
            namespace = namespaceInfo.getNamespace();
        }
        org.eclipse.persistence.internal.oxm.NamespaceResolver resolverForDescriptor = this.getNamespaceResolverForDescriptor(namespaceInfo);
        JavaClass manyValueJavaClass = this.helper.getJavaClass(ManyValue.class);
        if (!manyValueJavaClass.isAssignableFrom(javaClass)) {
            if (this.isDefaultNamespaceAllowed && namespace.length() != 0 && this.globalNamespaceResolver.getDefaultNamespaceURI() == null && !resolverForDescriptor.getPrefixesToNamespaces().containsValue(namespace)) {
                this.globalNamespaceResolver.setDefaultNamespaceURI(namespace);
                resolverForDescriptor.setDefaultNamespaceURI(namespace);
            }
            if (rootElem == null) {
                descriptor.setDefaultRootElement("");
            } else if (namespace.length() == 0) {
                descriptor.setDefaultRootElement(elementName);
            } else {
                descriptor.setDefaultRootElement(this.getQualifiedString(this.getPrefixForNamespace(namespace, resolverForDescriptor), elementName));
            }
        }
        descriptor.setNamespaceResolver(resolverForDescriptor);
        this.setSchemaContext((Descriptor)descriptor, info);
        if (info.isSetClassExtractorName()) {
            descriptor.getInheritancePolicy().setClassExtractorName(info.getClassExtractorName());
        }
        if (info.getUserProperties() != null) {
            descriptor.setProperties(info.getUserProperties());
        }
        if (info.isLocationAware()) {
            Property locProp = null;
            for (Property p : info.getPropertyList()) {
                if (!p.getType().getName().equals("org.xml.sax.Locator")) continue;
                locProp = p;
            }
            if (locProp != null && locProp.isTransient()) {
                MethodAttributeAccessor aa;
                if (locProp.isMethodProperty()) {
                    aa = new MethodAttributeAccessor();
                    aa.setAttributeName(locProp.getPropertyName());
                    aa.setSetMethodName(locProp.getSetMethodName());
                    aa.setGetMethodName(locProp.getGetMethodName());
                    descriptor.setLocationAccessor((CoreAttributeAccessor)aa);
                } else {
                    aa = new InstanceVariableAttributeAccessor();
                    aa.setAttributeName(locProp.getPropertyName());
                    descriptor.setLocationAccessor((CoreAttributeAccessor)aa);
                }
            }
        }
        if (!info.getObjectGraphs().isEmpty()) {
            for (XmlNamedObjectGraph next : info.getObjectGraphs()) {
                AttributeGroup attributeGroup = new AttributeGroup(next.getName(), info.getJavaClassName(), false);
                descriptor.addAttributeGroup((CoreAttributeGroup)attributeGroup);
            }
        }
        project.addDescriptor((CoreDescriptor)descriptor);
        info.setDescriptor((Descriptor)descriptor);
    }

    public void generateDescriptorForJAXBElementSubclass(JavaClass javaClass, CoreProject project, org.eclipse.persistence.internal.oxm.NamespaceResolver nsr) {
        String jClassName = javaClass.getQualifiedName();
        TypeInfo info = this.typeInfo.get(jClassName);
        XMLDescriptor xmlDescriptor = new XMLDescriptor();
        xmlDescriptor.setJavaClassName(jClassName);
        String[] factoryMethodParamTypes = info.getFactoryMethodParamTypes();
        MultiArgInstantiationPolicy policy = new MultiArgInstantiationPolicy();
        policy.useFactoryInstantiationPolicy(info.getObjectFactoryClassName(), info.getFactoryMethodName());
        policy.setParameterTypeNames(factoryMethodParamTypes);
        policy.setDefaultValues(new String[1]);
        xmlDescriptor.setInstantiationPolicy((CoreInstantiationPolicy)policy);
        JavaClass paramClass = this.helper.getJavaClass(factoryMethodParamTypes[0]);
        boolean isObject = paramClass.getName().equals("java.lang.Object");
        if (this.helper.isBuiltInJavaType(paramClass) && !isObject) {
            if (this.isBinaryData(paramClass)) {
                XMLBinaryDataMapping mapping = new XMLBinaryDataMapping();
                mapping.setAttributeName("value");
                mapping.setXPath(".");
                ((Field)mapping.getField()).setSchemaType(Constants.BASE_64_BINARY_QNAME);
                mapping.setSetMethodName("setValue");
                mapping.setGetMethodName("getValue");
                Class attributeClassification = Helper.getClassFromClasseName((String)factoryMethodParamTypes[0], (ClassLoader)this.helper.getClassLoader());
                mapping.setAttributeClassification(attributeClassification);
                mapping.getNullPolicy().setNullRepresentedByEmptyNode(false);
                mapping.setShouldInlineBinaryData(false);
                if (mapping.getMimeType() == null) {
                    if (this.areEquals(paramClass, Source.class)) {
                        mapping.setMimeTypePolicy((MimeTypePolicy)new FixedMimeTypePolicy("application/xml"));
                    } else {
                        mapping.setMimeTypePolicy((MimeTypePolicy)new FixedMimeTypePolicy("application/octet-stream"));
                    }
                }
                xmlDescriptor.addMapping((CoreMapping)mapping);
            } else {
                XMLDirectMapping mapping = new XMLDirectMapping();
                mapping.setNullValueMarshalled(true);
                mapping.setAttributeName("value");
                mapping.setGetMethodName("getValue");
                mapping.setSetMethodName("setValue");
                mapping.setXPath("text()");
                Class attributeClassification = Helper.getClassFromClasseName((String)factoryMethodParamTypes[0], (ClassLoader)this.helper.getClassLoader());
                mapping.setAttributeClassification(attributeClassification);
                xmlDescriptor.addMapping((CoreMapping)mapping);
            }
        } else if (paramClass.isEnum()) {
            EnumTypeInfo enumInfo = (EnumTypeInfo)this.typeInfo.get(paramClass.getQualifiedName());
            XMLDirectMapping mapping = new XMLDirectMapping();
            mapping.setConverter((CoreConverter)this.buildJAXBEnumTypeConverter((Mapping)mapping, enumInfo));
            mapping.setNullValueMarshalled(true);
            mapping.setAttributeName("value");
            mapping.setGetMethodName("getValue");
            mapping.setSetMethodName("setValue");
            mapping.setXPath("text()");
            Class attributeClassification = Helper.getClassFromClasseName((String)factoryMethodParamTypes[0], (ClassLoader)this.helper.getClassLoader());
            mapping.setAttributeClassification(attributeClassification);
            xmlDescriptor.addMapping((CoreMapping)mapping);
        } else {
            XMLCompositeObjectMapping mapping = new XMLCompositeObjectMapping();
            mapping.setAttributeName("value");
            mapping.setGetMethodName("getValue");
            mapping.setSetMethodName("setValue");
            mapping.setXPath(".");
            if (isObject) {
                mapping.setKeepAsElementPolicy((org.eclipse.persistence.internal.oxm.mappings.UnmarshalKeepAsElementPolicy)UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT);
            } else {
                mapping.setReferenceClassName(factoryMethodParamTypes[0]);
            }
            xmlDescriptor.addMapping((CoreMapping)mapping);
        }
        xmlDescriptor.setNamespaceResolver(nsr);
        this.setSchemaContext((Descriptor)xmlDescriptor, info);
        project.addDescriptor((CoreDescriptor)xmlDescriptor);
        info.setDescriptor((Descriptor)xmlDescriptor);
    }

    private void setSchemaContext(Descriptor desc, TypeInfo info) {
        XMLSchemaClassPathReference schemaRef = new XMLSchemaClassPathReference();
        if (info.getClassNamespace() == null || info.getClassNamespace().equals("")) {
            schemaRef.setSchemaContext("/" + info.getSchemaTypeName());
            schemaRef.setSchemaContextAsQName(new QName(info.getSchemaTypeName()));
        } else {
            String prefix = desc.getNonNullNamespaceResolver().resolveNamespaceURI(info.getClassNamespace());
            if (prefix != null && !prefix.equals("")) {
                schemaRef.setSchemaContext("/" + prefix + ":" + info.getSchemaTypeName());
                schemaRef.setSchemaContextAsQName(new QName(info.getClassNamespace(), info.getSchemaTypeName(), prefix));
            } else {
                String generatedPrefix = this.getPrefixForNamespace(info.getClassNamespace(), desc.getNonNullNamespaceResolver(), false);
                schemaRef.setSchemaContext("/" + this.getQualifiedString(generatedPrefix, info.getSchemaTypeName()));
                if (generatedPrefix == null || generatedPrefix.equals("")) {
                    schemaRef.setSchemaContextAsQName(new QName(info.getClassNamespace(), info.getSchemaTypeName()));
                } else {
                    schemaRef.setSchemaContextAsQName(new QName(info.getClassNamespace(), info.getSchemaTypeName(), generatedPrefix));
                }
            }
        }
        if (info.isEnumerationType() || info.getPropertyNames().size() == 1 && this.helper.isAnnotationPresent(info.getProperties().get(info.getPropertyNames().get(0)).getElement(), XmlValue.class)) {
            schemaRef.setType(2);
        }
        desc.setSchemaReference((XMLSchemaReference)schemaRef);
    }

    public Mapping generateMapping(Property property, Descriptor descriptor, JavaClass descriptorJavaClass, NamespaceInfo namespaceInfo) {
        if (property.isSetXmlJavaTypeAdapter()) {
            ChoiceCollectionMapping mapping;
            boolean isArray;
            if (property.isReference()) {
                return this.generateMappingForReferenceProperty(property, descriptor, namespaceInfo);
            }
            XmlJavaTypeAdapter xja = property.getXmlJavaTypeAdapter();
            JavaClass adapterClass = this.helper.getJavaClass(xja.getValue());
            JavaClass valueType = null;
            String sValType = xja.getValueType();
            valueType = sValType.equals("javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter.DEFAULT") ? property.getActualType() : this.helper.getJavaClass(xja.getValueType());
            boolean bl = isArray = property.getType().isArray() && !property.getType().getRawName().equals("byte[]");
            if (property.isChoice()) {
                if (this.helper.isCollectionType(property.getType()) || property.getType().isArray()) {
                    mapping = this.generateChoiceCollectionMapping(property, descriptor, namespaceInfo);
                    mapping.setConverter((CoreConverter)new XMLJavaTypeConverter(adapterClass.getQualifiedName()));
                } else {
                    mapping = this.generateChoiceMapping(property, descriptor, namespaceInfo);
                    ((ChoiceObjectMapping)mapping).setConverter((CoreConverter)new XMLJavaTypeConverter(adapterClass.getQualifiedName()));
                }
            } else if (this.typeInfo.containsKey(valueType.getQualifiedName())) {
                TypeInfo reference = this.typeInfo.get(valueType.getQualifiedName());
                if (this.helper.isCollectionType(property.getType())) {
                    if (reference.isEnumerationType()) {
                        mapping = this.generateEnumCollectionMapping(property, descriptor, namespaceInfo, (EnumTypeInfo)reference);
                        XMLJavaTypeConverter converter = new XMLJavaTypeConverter(adapterClass.getQualifiedName());
                        converter.setNestedConverter((CoreConverter<DatabaseMapping, Session>)((DirectCollectionMapping)mapping).getValueConverter());
                        ((DirectCollectionMapping)mapping).setValueConverter((CoreConverter)converter);
                    } else if (property.getVariableAttributeName() != null) {
                        mapping = this.generateVariableXPathCollectionMapping(property, descriptor, namespaceInfo, valueType);
                        ((VariableXPathCollectionMapping)mapping).setConverter((CoreConverter)new XMLJavaTypeConverter(adapterClass.getQualifiedName()));
                    } else {
                        mapping = this.generateCompositeCollectionMapping(property, descriptor, descriptorJavaClass, namespaceInfo, valueType.getQualifiedName());
                        ((CompositeCollectionMapping)mapping).setConverter((CoreConverter)new XMLJavaTypeConverter(adapterClass.getQualifiedName()));
                    }
                } else if (reference.isEnumerationType()) {
                    mapping = this.generateDirectEnumerationMapping(property, descriptor, namespaceInfo, (EnumTypeInfo)reference);
                    XMLJavaTypeConverter converter = new XMLJavaTypeConverter(adapterClass.getQualifiedName());
                    converter.setNestedConverter((CoreConverter<DatabaseMapping, Session>)((DirectMapping)mapping).getConverter());
                    ((DirectMapping)mapping).setConverter((CoreConverter)converter);
                } else if (property.isInverseReference()) {
                    mapping = this.generateInverseReferenceMapping(property, descriptor, namespaceInfo);
                } else if (property.getVariableAttributeName() != null) {
                    mapping = this.generateVariableXPathObjectMapping(property, descriptor, namespaceInfo, valueType);
                    ((VariableXPathObjectMapping)mapping).setConverter((CoreConverter)new XMLJavaTypeConverter(adapterClass.getQualifiedName()));
                } else {
                    mapping = this.generateCompositeObjectMapping(property, descriptor, namespaceInfo, valueType.getQualifiedName());
                    ((CompositeObjectMapping)mapping).setConverter((CoreConverter)new XMLJavaTypeConverter(adapterClass.getQualifiedName()));
                }
            } else if (property.isAny()) {
                if (this.helper.isCollectionType(property.getType())) {
                    mapping = this.generateAnyCollectionMapping(property, descriptor, namespaceInfo, property.isMixedContent());
                    ((AnyCollectionMapping)mapping).setConverter((CoreConverter)new XMLJavaTypeConverter(adapterClass.getQualifiedName()));
                } else {
                    mapping = this.generateAnyObjectMapping(property, descriptor, namespaceInfo);
                    ((AnyObjectMapping)mapping).setConverter((CoreConverter)new XMLJavaTypeConverter(adapterClass.getQualifiedName()));
                }
            } else if (this.helper.isCollectionType(property.getType()) || isArray) {
                if (property.isSwaAttachmentRef() || property.isMtomAttachment()) {
                    mapping = this.generateBinaryDataCollectionMapping(property, descriptor, namespaceInfo);
                    ((BinaryDataCollectionMapping)mapping).setValueConverter((CoreConverter)new XMLJavaTypeConverter(adapterClass.getQualifiedName()));
                } else {
                    mapping = this.generateDirectCollectionMapping(property, descriptor, namespaceInfo);
                    if (adapterClass.getQualifiedName().equals(CollapsedStringAdapter.class.getName())) {
                        ((DirectCollectionMapping)mapping).setCollapsingStringValues(true);
                    } else if (adapterClass.getQualifiedName().equals(NormalizedStringAdapter.class.getName())) {
                        ((DirectCollectionMapping)mapping).setNormalizingStringValues(true);
                    } else {
                        ((DirectCollectionMapping)mapping).setValueConverter((CoreConverter)new XMLJavaTypeConverter(adapterClass.getQualifiedName()));
                    }
                }
            } else if (property.isSwaAttachmentRef() || property.isMtomAttachment()) {
                mapping = this.generateBinaryMapping(property, descriptor, namespaceInfo);
                ((BinaryDataMapping)mapping).setConverter((CoreConverter)new XMLJavaTypeConverter(adapterClass.getQualifiedName()));
            } else {
                if (!property.isAttribute() && this.areEquals(valueType, Object.class) || property.isTyped()) {
                    CompositeObjectMapping mapping2 = this.generateCompositeObjectMapping(property, descriptor, namespaceInfo, null);
                    mapping2.setKeepAsElementPolicy((org.eclipse.persistence.internal.oxm.mappings.UnmarshalKeepAsElementPolicy)UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT);
                    mapping2.setConverter((CoreConverter)new XMLJavaTypeConverter(adapterClass.getQualifiedName()));
                    return mapping2;
                }
                mapping = this.generateDirectMapping(property, descriptor, namespaceInfo);
                if (adapterClass.getQualifiedName().equals(CollapsedStringAdapter.class.getName())) {
                    ((DirectMapping)mapping).setCollapsingStringValues(true);
                } else if (adapterClass.getQualifiedName().equals(NormalizedStringAdapter.class.getName())) {
                    ((DirectMapping)mapping).setNormalizingStringValues(true);
                } else {
                    ((DirectMapping)mapping).setConverter((CoreConverter)new XMLJavaTypeConverter(adapterClass.getQualifiedName()));
                }
            }
            return mapping;
        }
        if (property.getVariableAttributeName() != null) {
            if (this.helper.isCollectionType(property.getType()) || property.getType().isArray() || property.isMap()) {
                return this.generateVariableXPathCollectionMapping(property, descriptor, namespaceInfo, property.getActualType());
            }
            return this.generateVariableXPathObjectMapping(property, descriptor, namespaceInfo, property.getActualType());
        }
        if (property.isSetXmlJoinNodes()) {
            if (this.helper.isCollectionType(property.getType())) {
                return this.generateXMLCollectionReferenceMapping(property, descriptor, namespaceInfo, property.getActualType());
            }
            return this.generateXMLObjectReferenceMapping(property, descriptor, namespaceInfo, property.getType());
        }
        if (property.isXmlTransformation()) {
            return this.generateTransformationMapping(property, descriptor, namespaceInfo);
        }
        if (property.isChoice()) {
            if (this.helper.isCollectionType(property.getType()) || property.getType().isArray()) {
                return this.generateChoiceCollectionMapping(property, descriptor, namespaceInfo);
            }
            return this.generateChoiceMapping(property, descriptor, namespaceInfo);
        }
        if (property.isInverseReference()) {
            return this.generateInverseReferenceMapping(property, descriptor, namespaceInfo);
        }
        if (property.isReference()) {
            return this.generateMappingForReferenceProperty(property, descriptor, namespaceInfo);
        }
        if (property.isAny()) {
            if (this.helper.isCollectionType(property.getType()) || property.getType().isArray()) {
                return this.generateAnyCollectionMapping(property, descriptor, namespaceInfo, property.isMixedContent());
            }
            return this.generateAnyObjectMapping(property, descriptor, namespaceInfo);
        }
        if (property.isMap()) {
            if (property.isAnyAttribute()) {
                return this.generateAnyAttributeMapping(property, descriptor, namespaceInfo);
            }
            return this.generateCompositeCollectionMapping(property, descriptor, descriptorJavaClass, namespaceInfo, null);
        }
        if (this.helper.isCollectionType(property.getType())) {
            return this.generateCollectionMapping(property, descriptor, descriptorJavaClass, namespaceInfo);
        }
        JavaClass referenceClass = property.getType();
        String referenceClassName = referenceClass.getRawName();
        if (referenceClass.isArray() && !referenceClassName.equals("byte[]")) {
            JavaClass componentType = referenceClass.getComponentType();
            TypeInfo reference = this.typeInfo.get(componentType.getName());
            if (reference != null && reference.isEnumerationType()) {
                return this.generateEnumCollectionMapping(property, descriptor, namespaceInfo, (EnumTypeInfo)reference);
            }
            if (this.areEquals(componentType, Object.class)) {
                CompositeCollectionMapping mapping = this.generateCompositeCollectionMapping(property, descriptor, descriptorJavaClass, namespaceInfo, null);
                mapping.setKeepAsElementPolicy((org.eclipse.persistence.internal.oxm.mappings.UnmarshalKeepAsElementPolicy)UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT);
                return mapping;
            }
            if (reference != null || componentType.isArray()) {
                if (property.isXmlIdRef() || property.isSetXmlJoinNodes()) {
                    return this.generateXMLCollectionReferenceMapping(property, descriptor, namespaceInfo, componentType);
                }
                return this.generateCompositeCollectionMapping(property, descriptor, descriptorJavaClass, namespaceInfo, componentType.getQualifiedName());
            }
            return this.generateDirectCollectionMapping(property, descriptor, namespaceInfo);
        }
        if (property.isXmlIdRef()) {
            return this.generateXMLObjectReferenceMapping(property, descriptor, namespaceInfo, referenceClass);
        }
        TypeInfo reference = this.typeInfo.get(referenceClass.getQualifiedName());
        if (reference != null) {
            if (reference.isEnumerationType()) {
                return this.generateDirectEnumerationMapping(property, descriptor, namespaceInfo, (EnumTypeInfo)reference);
            }
            if (property.isXmlLocation()) {
                CompositeObjectMapping locationMapping = this.generateCompositeObjectMapping(property, descriptor, namespaceInfo, referenceClass.getQualifiedName());
                reference.getDescriptor().setInstantiationPolicy((CoreInstantiationPolicy)new NullInstantiationPolicy());
                descriptor.setLocationAccessor(locationMapping.getAttributeAccessor());
                return locationMapping;
            }
            return this.generateCompositeObjectMapping(property, descriptor, namespaceInfo, referenceClass.getQualifiedName());
        }
        if (property.isSwaAttachmentRef() || property.isMtomAttachment()) {
            return this.generateBinaryMapping(property, descriptor, namespaceInfo);
        }
        if (referenceClass.getQualifiedName().equals(OBJECT_CLASS_NAME) && !property.isAttribute() || property.isTyped()) {
            CompositeObjectMapping coMapping = this.generateCompositeObjectMapping(property, descriptor, namespaceInfo, null);
            coMapping.setKeepAsElementPolicy((org.eclipse.persistence.internal.oxm.mappings.UnmarshalKeepAsElementPolicy)UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT);
            return coMapping;
        }
        if (property.isXmlLocation()) {
            return null;
        }
        return this.generateDirectMapping(property, descriptor, namespaceInfo);
    }

    private Mapping generateVariableXPathCollectionMapping(Property property, Descriptor descriptor, NamespaceInfo namespaceInfo, JavaClass actualType) {
        JavaClass collectionType;
        XMLVariableXPathCollectionMapping mapping = new XMLVariableXPathCollectionMapping();
        mapping.setAttributeName(property.getPropertyName());
        if (property.isMap()) {
            actualType = property.getValueType();
        }
        this.initializeXMLContainerMapping((XMLContainerMapping)mapping, property.getType().isArray());
        this.initializeXMLMapping((XMLMapping)mapping, property);
        this.initializeVariableXPathMapping((VariableXPathObjectMapping)mapping, property, actualType);
        if (property.getXmlPath() != null) {
            mapping.setField((DatabaseField)new XMLField(property.getXmlPath()));
        } else if (property.isSetXmlElementWrapper()) {
            mapping.setField((DatabaseField)((XMLField)this.getXPathForField(property, namespaceInfo, false, true)));
        }
        if (property.isSetXmlElementWrapper()) {
            mapping.setWrapperNullPolicy(this.getWrapperNullPolicyFromProperty(property));
        }
        if ((collectionType = property.getType()).isArray()) {
            JAXBArrayAttributeAccessor accessor = new JAXBArrayAttributeAccessor((CoreAttributeAccessor)mapping.getAttributeAccessor(), (CoreContainerPolicy)mapping.getContainerPolicy(), this.helper.getClassLoader());
            JavaClass componentType = collectionType.getComponentType();
            if (componentType.isArray()) {
                JavaClass baseComponentType = this.getBaseComponentType(componentType);
                if (baseComponentType.isPrimitive()) {
                    Class primitiveClass = XMLConversionManager.getDefaultManager().convertClassNameToClass(baseComponentType.getRawName());
                    accessor.setComponentClass(primitiveClass);
                } else {
                    accessor.setComponentClassName(baseComponentType.getQualifiedName());
                }
            } else {
                accessor.setComponentClassName(componentType.getQualifiedName());
            }
            mapping.setAttributeAccessor((AttributeAccessor)accessor);
        }
        if (property.isMap()) {
            JavaClass mapType = property.getType();
            if (mapType.isInterface()) {
                mapping.useMapClass("java.util.HashMap");
            } else {
                mapping.useMapClass(property.getType().getName());
            }
        } else {
            collectionType = this.containerClassImpl(collectionType);
            mapping.useCollectionClass(this.helper.getClassForJavaClass(collectionType));
        }
        return mapping;
    }

    private Mapping generateVariableXPathObjectMapping(Property property, Descriptor descriptor, NamespaceInfo namespaceInfo, JavaClass actualType) {
        XMLVariableXPathObjectMapping mapping = new XMLVariableXPathObjectMapping();
        this.initializeXMLMapping((XMLMapping)mapping, property);
        this.initializeVariableXPathMapping((VariableXPathObjectMapping)mapping, property, actualType);
        if (property.isSetNullPolicy()) {
            mapping.setNullPolicy(this.getNullPolicyFromProperty(property, this.getNamespaceResolverForDescriptor(namespaceInfo)));
        } else {
            NullPolicy nullPolicy = (NullPolicy)mapping.getNullPolicy();
            nullPolicy.setSetPerformedForAbsentNode(false);
            if (property.isNillable()) {
                nullPolicy.setNullRepresentedByXsiNil(true);
                nullPolicy.setMarshalNullRepresentation(XMLNullRepresentationType.XSI_NIL);
            }
        }
        if (property.getXmlPath() != null) {
            mapping.setField((DatabaseField)new XMLField(property.getXmlPath()));
        } else if (property.isSetXmlElementWrapper()) {
            mapping.setField((DatabaseField)((XMLField)this.getXPathForField(property, namespaceInfo, false, true)));
        }
        return mapping;
    }

    private void initializeVariableXPathMapping(VariableXPathObjectMapping mapping, Property property, JavaClass actualType) {
        String variableAttributeName = property.getVariableAttributeName();
        TypeInfo refInfo = this.typeInfo.get(actualType.getName());
        if (refInfo == null) {
            throw JAXBException.unknownTypeForVariableNode((String)actualType.getName());
        }
        Property refProperty = refInfo.getProperties().get(variableAttributeName);
        while (refProperty == null) {
            JavaClass superClass = CompilerHelper.getNextMappedSuperClass(actualType, this.typeInfo, this.helper);
            if (superClass == null) break;
            refInfo = this.typeInfo.get(superClass.getName());
            refProperty = refInfo.getProperties().get(variableAttributeName);
        }
        if (refProperty == null) {
            throw JAXBException.unknownPropertyForVariableNode((String)variableAttributeName, (String)actualType.getName());
        }
        String refPropertyType = refProperty.getActualType().getQualifiedName();
        if (!refPropertyType.equals("java.lang.String") && !refPropertyType.equals("javax.xml.namespace.QName")) {
            throw JAXBException.invalidTypeForVariableNode((String)variableAttributeName, (String)refPropertyType, (String)actualType.getName());
        }
        if (refProperty.isMethodProperty()) {
            if (refProperty.getGetMethodName() == null) {
                String paramTypeAsString = refProperty.getType().getName();
                JAXBSetMethodAttributeAccessor accessor = new JAXBSetMethodAttributeAccessor(paramTypeAsString, this.helper.getClassLoader());
                accessor.setIsReadOnly(true);
                accessor.setSetMethodName(refProperty.getSetMethodName());
                mapping.setIsReadOnly(true);
                accessor.setAttributeName("thingBLAH");
                mapping.setVariableAttributeAccessor((CoreAttributeAccessor)accessor);
            } else if (refProperty.getSetMethodName() == null) {
                mapping.setVariableGetMethodName(refProperty.getGetMethodName());
            } else {
                mapping.setVariableGetMethodName(refProperty.getGetMethodName());
                mapping.setVariableSetMethodName(refProperty.getSetMethodName());
            }
        } else {
            mapping.setVariableAttributeName(property.getVariableAttributeName());
        }
        if (property.getVariableClassName() != null) {
            mapping.setReferenceClassName(property.getVariableClassName());
        } else {
            mapping.setReferenceClassName(actualType.getQualifiedName());
        }
        mapping.setAttribute(property.isVariableNodeAttribute());
    }

    private InverseReferenceMapping generateInverseReferenceMapping(Property property, Descriptor descriptor, NamespaceInfo namespace) {
        XMLInverseReferenceMapping invMapping = new XMLInverseReferenceMapping();
        boolean isCollection = this.helper.isCollectionType(property.getType());
        if (isCollection) {
            invMapping.setReferenceClassName(property.getGenericType().getQualifiedName());
        } else {
            invMapping.setReferenceClassName(property.getType().getQualifiedName());
        }
        invMapping.setAttributeName(property.getPropertyName());
        String setMethodName = property.getInverseReferencePropertySetMethodName();
        String getMethodName = property.getInverseReferencePropertyGetMethodName();
        if (setMethodName != null && !setMethodName.equals("")) {
            invMapping.setSetMethodName(setMethodName);
        }
        if (getMethodName != null && !getMethodName.equals("")) {
            invMapping.setGetMethodName(getMethodName);
        }
        invMapping.setMappedBy(property.getInverseReferencePropertyName());
        if (isCollection) {
            JavaClass collectionType = property.getType();
            collectionType = this.containerClassImpl(collectionType);
            invMapping.useCollectionClass(Helper.getClassFromClasseName((String)collectionType.getQualifiedName(), (ClassLoader)this.helper.getClassLoader()));
        }
        if (property.isWriteableInverseReference()) {
            if (isCollection) {
                JavaClass descriptorClass = this.helper.getJavaClass(descriptor.getJavaClassName());
                invMapping.setInlineMapping((CoreMapping)((XMLCompositeCollectionMapping)this.generateCompositeCollectionMapping(property, descriptor, descriptorClass, namespace, invMapping.getReferenceClassName())));
            } else {
                invMapping.setInlineMapping((CoreMapping)((XMLCompositeObjectMapping)this.generateCompositeObjectMapping(property, descriptor, namespace, invMapping.getReferenceClassName())));
            }
        }
        return invMapping;
    }

    public TransformationMapping generateTransformationMapping(Property property, Descriptor descriptor, NamespaceInfo namespace) {
        XMLTransformationMapping mapping = new XMLTransformationMapping();
        if (property.isMethodProperty()) {
            if (property.getGetMethodName() == null) {
                String paramTypeAsString = property.getType().getName();
                mapping.setAttributeAccessor((CoreAttributeAccessor)new JAXBSetMethodAttributeAccessor(paramTypeAsString, this.helper.getClassLoader()));
                mapping.setSetMethodName(property.getSetMethodName());
            } else if (property.getSetMethodName() == null) {
                mapping.setGetMethodName(property.getGetMethodName());
            } else {
                mapping.setSetMethodName(property.getSetMethodName());
                mapping.setGetMethodName(property.getGetMethodName());
            }
        }
        if (property.isSetXmlTransformation()) {
            XmlTransformation xmlTransformation = property.getXmlTransformation();
            mapping.setIsOptional(xmlTransformation.isOptional());
            if (xmlTransformation.isSetXmlReadTransformer()) {
                mapping.setAttributeName(property.getPropertyName());
                XmlTransformation.XmlReadTransformer readTransformer = xmlTransformation.getXmlReadTransformer();
                if (readTransformer.isSetTransformerClass()) {
                    mapping.setAttributeTransformerClassName(xmlTransformation.getXmlReadTransformer().getTransformerClass());
                } else {
                    mapping.setAttributeTransformation(xmlTransformation.getXmlReadTransformer().getMethod());
                }
            }
            if (xmlTransformation.isSetXmlWriteTransformers()) {
                for (XmlTransformation.XmlWriteTransformer writeTransformer : xmlTransformation.getXmlWriteTransformer()) {
                    if (writeTransformer.isSetTransformerClass()) {
                        mapping.addFieldTransformerClassName(writeTransformer.getXmlPath(), writeTransformer.getTransformerClass());
                        continue;
                    }
                    mapping.addFieldTransformation(writeTransformer.getXmlPath(), writeTransformer.getMethod());
                }
            }
        }
        return mapping;
    }

    public ChoiceObjectMapping generateChoiceMapping(Property property, Descriptor descriptor, NamespaceInfo namespace) {
        XMLChoiceObjectMapping mapping = new XMLChoiceObjectMapping();
        this.initializeXMLMapping((XMLMapping)mapping, property);
        boolean isIdRef = property.isXmlIdRef();
        for (Property next : property.getChoiceProperties()) {
            Mapping nestedMapping;
            XmlJavaTypeAdapter adapter;
            JavaClass type = next.getType();
            JavaClass originalType = next.getType();
            XMLJavaTypeConverter converter = null;
            TypeInfo info = this.typeInfo.get(type.getName());
            if (info != null && (adapter = info.getXmlJavaTypeAdapter()) != null) {
                JavaClass theClass;
                String adapterValue = adapter.getValue();
                JavaClass adapterClass = this.helper.getJavaClass(adapterValue);
                type = theClass = CompilerHelper.getTypeFromAdapterClass(adapterClass, this.helper);
                converter = new XMLJavaTypeConverter(adapterClass.getQualifiedName());
            }
            if (next.getXmlJoinNodes() != null) {
                ArrayList<XMLField> srcFlds = new ArrayList<XMLField>();
                ArrayList<XMLField> tgtFlds = new ArrayList<XMLField>();
                for (XmlJoinNodes.XmlJoinNode xmlJoinNode : next.getXmlJoinNodes().getXmlJoinNode()) {
                    srcFlds.add(new XMLField(xmlJoinNode.getXmlPath()));
                    tgtFlds.add(new XMLField(xmlJoinNode.getReferencedXmlPath()));
                }
                mapping.addChoiceElement(srcFlds, type.getQualifiedName(), tgtFlds);
                continue;
            }
            if (isIdRef) {
                String tgtXPath = null;
                TypeInfo referenceType = this.typeInfo.get(type.getQualifiedName());
                if (referenceType != null && referenceType.isIDSet()) {
                    Property prop;
                    tgtXPath = this.getXPathForField(prop, namespace, !(prop = referenceType.getIDProperty()).isAttribute(), false).getXPath();
                }
                Object srcXPath = next.getXmlPath() != null ? new XMLField(next.getXmlPath()) : this.getXPathForField(next, namespace, true, false);
                mapping.addChoiceElement(srcXPath.getXPath(), type.getQualifiedName(), tgtXPath);
                continue;
            }
            Object xpath = next.getXmlPath() != null ? new XMLField(next.getXmlPath()) : this.getXPathForField(next, namespace, !this.typeInfo.containsKey(type.getQualifiedName()) || next.isMtomAttachment() || type.isEnum(), false);
            mapping.addChoiceElement((Field)xpath, type.getQualifiedName());
            if (!originalType.getQualifiedName().equals(type.getQualifiedName())) {
                if (mapping.getClassNameToFieldMappings().get(originalType.getQualifiedName()) == null) {
                    mapping.getClassNameToFieldMappings().put(originalType.getQualifiedName(), xpath);
                }
                mapping.addConverter((Field)xpath, (CoreConverter)converter);
            }
            if ((nestedMapping = (Mapping)mapping.getChoiceElementMappings().get(xpath)) instanceof BinaryDataMapping) {
                ((BinaryDataMapping)nestedMapping).getNullPolicy().setNullRepresentedByEmptyNode(false);
            }
            if (!type.isEnum() || !nestedMapping.isAbstractDirectMapping()) continue;
            ((DirectMapping)nestedMapping).setConverter((CoreConverter)this.buildJAXBEnumTypeConverter(nestedMapping, (EnumTypeInfo)info));
        }
        return mapping;
    }

    public ChoiceCollectionMapping generateChoiceCollectionMapping(Property property, Descriptor descriptor, NamespaceInfo namespace) {
        XMLChoiceCollectionMapping mapping = new XMLChoiceCollectionMapping();
        this.initializeXMLContainerMapping((XMLContainerMapping)mapping, property.getType().isArray());
        this.initializeXMLMapping((XMLMapping)mapping, property);
        JavaClass collectionType = property.getType();
        if (collectionType.isArray()) {
            JAXBArrayAttributeAccessor accessor = new JAXBArrayAttributeAccessor(mapping.getAttributeAccessor(), mapping.getContainerPolicy(), this.helper.getClassLoader());
            JavaClass componentType = collectionType.getComponentType();
            if (componentType.isArray()) {
                JavaClass baseComponentType = this.getBaseComponentType(componentType);
                if (baseComponentType.isPrimitive()) {
                    Class primitiveClass = XMLConversionManager.getDefaultManager().convertClassNameToClass(baseComponentType.getRawName());
                    accessor.setComponentClass(primitiveClass);
                } else {
                    accessor.setComponentClassName(baseComponentType.getQualifiedName());
                }
            } else {
                accessor.setComponentClassName(componentType.getQualifiedName());
            }
            mapping.setAttributeAccessor((CoreAttributeAccessor)accessor);
        }
        collectionType = this.containerClassImpl(collectionType);
        mapping.useCollectionClassName(collectionType.getRawName());
        if (property.isSetXmlElementWrapper()) {
            mapping.setWrapperNullPolicy(this.getWrapperNullPolicyFromProperty(property));
        }
        boolean isIdRef = property.isXmlIdRef();
        for (Property next : property.getChoiceProperties()) {
            XmlJavaTypeAdapter adapter;
            JavaClass type = next.getType();
            JavaClass originalType = next.getType();
            XMLJavaTypeConverter converter = null;
            XMLField xmlField = null;
            TypeInfo info = this.typeInfo.get(type.getName());
            if (info != null && (adapter = info.getXmlJavaTypeAdapter()) != null) {
                JavaClass theClass;
                String adapterValue = adapter.getValue();
                JavaClass adapterClass = this.helper.getJavaClass(adapterValue);
                type = theClass = CompilerHelper.getTypeFromAdapterClass(adapterClass, this.helper);
                converter = new XMLJavaTypeConverter(adapterClass.getQualifiedName());
            }
            if (next.getXmlJoinNodes() != null) {
                ArrayList<XMLField> srcFlds = new ArrayList<XMLField>();
                ArrayList<XMLField> tgtFlds = new ArrayList<XMLField>();
                for (XmlJoinNodes.XmlJoinNode xmlJoinNode : next.getXmlJoinNodes().getXmlJoinNode()) {
                    srcFlds.add(new XMLField(xmlJoinNode.getXmlPath()));
                    tgtFlds.add(new XMLField(xmlJoinNode.getReferencedXmlPath()));
                }
                mapping.addChoiceElement(srcFlds, type.getQualifiedName(), tgtFlds);
            } else if (isIdRef) {
                String tgtXPath = null;
                TypeInfo referenceType = this.typeInfo.get(type.getQualifiedName());
                if (referenceType != null && referenceType.isIDSet()) {
                    Property prop;
                    tgtXPath = this.getXPathForField(prop, namespace, !(prop = referenceType.getIDProperty()).isAttribute(), false).getXPath();
                }
                Object srcXPath = next.getXmlPath() != null ? new XMLField(next.getXmlPath()) : this.getXPathForField(next, namespace, true, false);
                mapping.addChoiceElement(srcXPath.getXPath(), type.getQualifiedName(), tgtXPath);
            } else {
                Object xpath = next.getXmlPath() != null ? new XMLField(next.getXmlPath()) : this.getXPathForField(next, namespace, !this.typeInfo.containsKey(type.getQualifiedName()) || type.isEnum(), false);
                xmlField = xpath;
                mapping.addChoiceElement(xpath.getName(), type.getQualifiedName());
                if (!originalType.getQualifiedName().equals(type.getQualifiedName())) {
                    if (mapping.getClassNameToFieldMappings().get(originalType.getQualifiedName()) == null) {
                        mapping.getClassNameToFieldMappings().put(originalType.getQualifiedName(), xpath);
                    }
                    mapping.addConverter((Field)xpath, (CoreConverter)converter);
                }
            }
            if (xmlField == null) continue;
            Mapping nestedMapping = (Mapping)mapping.getChoiceElementMappings().get(xmlField);
            if (nestedMapping.isAbstractCompositeCollectionMapping()) {
                if (property.isSetNullPolicy()) {
                    ((CompositeCollectionMapping)nestedMapping).setNullPolicy(this.getNullPolicyFromProperty(property, this.getNamespaceResolverForDescriptor(namespace)));
                    continue;
                }
                if (!next.isNillable() || !property.isNillable()) continue;
                ((CompositeCollectionMapping)nestedMapping).getNullPolicy().setNullRepresentedByXsiNil(true);
                ((CompositeCollectionMapping)nestedMapping).getNullPolicy().setMarshalNullRepresentation(XMLNullRepresentationType.XSI_NIL);
                continue;
            }
            if (nestedMapping.isAbstractCompositeDirectCollectionMapping()) {
                if (next.isSetNullPolicy()) {
                    ((DirectCollectionMapping)nestedMapping).setNullPolicy(this.getNullPolicyFromProperty(next, this.getNamespaceResolverForDescriptor(namespace)));
                } else if (next.isNillable() && property.isNillable()) {
                    ((DirectCollectionMapping)nestedMapping).getNullPolicy().setNullRepresentedByXsiNil(true);
                    ((DirectCollectionMapping)nestedMapping).getNullPolicy().setMarshalNullRepresentation(XMLNullRepresentationType.XSI_NIL);
                }
                ((DirectCollectionMapping)nestedMapping).getNullPolicy().setNullRepresentedByEmptyNode(false);
                if (!type.isEnum()) continue;
                ((DirectCollectionMapping)nestedMapping).setValueConverter((CoreConverter)this.buildJAXBEnumTypeConverter(nestedMapping, (EnumTypeInfo)info));
                continue;
            }
            if (!(nestedMapping instanceof BinaryDataCollectionMapping)) continue;
            if (next.isSetNullPolicy()) {
                ((BinaryDataCollectionMapping)nestedMapping).setNullPolicy(this.getNullPolicyFromProperty(next, this.getNamespaceResolverForDescriptor(namespace)));
                continue;
            }
            if (!next.isNillable() || !property.isNillable()) continue;
            ((BinaryDataCollectionMapping)nestedMapping).getNullPolicy().setNullRepresentedByXsiNil(true);
            ((BinaryDataCollectionMapping)nestedMapping).getNullPolicy().setMarshalNullRepresentation(XMLNullRepresentationType.XSI_NIL);
        }
        return mapping;
    }

    public Mapping generateMappingForReferenceProperty(Property property, Descriptor descriptor, NamespaceInfo namespaceInfo) {
        XMLChoiceCollectionMapping mapping;
        boolean isCollection;
        boolean bl = isCollection = this.helper.isCollectionType(property.getType()) || property.getType().isArray();
        if (isCollection) {
            mapping = new XMLChoiceCollectionMapping();
            this.initializeXMLContainerMapping((XMLContainerMapping)((ChoiceCollectionMapping)mapping), property.getType().isArray());
            JavaClass collectionType = property.getType();
            collectionType = this.containerClassImpl(collectionType);
            ((ChoiceCollectionMapping)mapping).useCollectionClassName(collectionType.getRawName());
            JAXBElementRootConverter jaxbERConverter = new JAXBElementRootConverter(Object.class);
            if (property.isSetXmlJavaTypeAdapter()) {
                JavaClass adapterClass = this.helper.getJavaClass(property.getXmlJavaTypeAdapter().getValue());
                jaxbERConverter.setNestedConverter((XMLConverter)new XMLJavaTypeConverter(adapterClass.getQualifiedName()));
            }
            ((ChoiceCollectionMapping)mapping).setConverter((CoreConverter)jaxbERConverter);
            if (property.isSetWriteOnly()) {
                ((ChoiceCollectionMapping)mapping).setIsWriteOnly(property.isWriteOnly());
            }
            if (property.isSetXmlElementWrapper()) {
                ((ChoiceCollectionMapping)mapping).setWrapperNullPolicy(this.getWrapperNullPolicyFromProperty(property));
            }
        } else {
            mapping = new XMLChoiceObjectMapping();
            JAXBElementRootConverter jaxbERConverter = new JAXBElementRootConverter(Object.class);
            if (property.isSetXmlJavaTypeAdapter()) {
                JavaClass adapterClass = this.helper.getJavaClass(property.getXmlJavaTypeAdapter().getValue());
                jaxbERConverter.setNestedConverter((XMLConverter)new XMLJavaTypeConverter(adapterClass.getQualifiedName()));
            }
            ((ChoiceObjectMapping)mapping).setConverter((CoreConverter)jaxbERConverter);
            if (property.isSetWriteOnly()) {
                ((ChoiceObjectMapping)mapping).setIsWriteOnly(property.isWriteOnly());
            }
        }
        this.initializeXMLMapping((XMLMapping)mapping, property);
        List<ElementDeclaration> referencedElements = property.getReferencedElements();
        JavaClass propertyType = property.getType();
        if (propertyType.isArray()) {
            JAXBArrayAttributeAccessor accessor = new JAXBArrayAttributeAccessor(mapping.getAttributeAccessor(), mapping.getContainerPolicy(), this.helper.getClassLoader());
            accessor.setComponentClassName(property.getType().getComponentType().getQualifiedName());
            JavaClass componentType = propertyType.getComponentType();
            if (componentType.isArray()) {
                Class adaptedClass = this.classToGeneratedClasses.get(componentType.getQualifiedName());
                accessor.setAdaptedClassName(adaptedClass.getName());
            }
            mapping.setAttributeAccessor((CoreAttributeAccessor)accessor);
        }
        String wrapperXPath = "";
        if (property.isSetXmlElementWrapper()) {
            XmlElementWrapper wrapper = property.getXmlElementWrapper();
            String namespace = wrapper.getNamespace();
            if (namespace.equals("##default")) {
                namespace = namespaceInfo.isElementFormQualified() ? namespaceInfo.getNamespace() : "";
            }
            if (namespace.equals("")) {
                wrapperXPath = String.valueOf(wrapperXPath) + wrapper.getName() + "/";
            } else {
                String prefix = this.getPrefixForNamespace(namespace, this.getNamespaceResolverForDescriptor(namespaceInfo));
                wrapperXPath = String.valueOf(wrapperXPath) + this.getQualifiedString(prefix, String.valueOf(wrapper.getName()) + "/");
            }
        }
        if (property.isMixedContent() && isCollection) {
            if (wrapperXPath.length() == 0) {
                ((ChoiceCollectionMapping)mapping).setMixedContent(true);
            } else {
                ((ChoiceCollectionMapping)mapping).setMixedContent(wrapperXPath.substring(0, wrapperXPath.length() - 1));
            }
        }
        for (ElementDeclaration element : referencedElements) {
            CoreConverter originalConverter;
            Mapping nestedMapping;
            QName elementName = element.getElementName();
            JavaClass pType = element.getJavaType();
            String pTypeName = element.getJavaTypeName();
            boolean isBinaryType = this.areEquals(pType, "javax.activation.DataHandler") || this.areEquals(pType, byte[].class) || this.areEquals(pType, Image.class) || this.areEquals(pType, Source.class) || this.areEquals(pType, "javax.mail.internet.MimeMultipart");
            boolean isText = pType.isEnum() || !isBinaryType && !this.typeInfo.containsKey(element.getJavaTypeName()) && !element.getJavaTypeName().equals(OBJECT_CLASS_NAME);
            String xPath = wrapperXPath;
            Field xmlField = this.getXPathForElement(xPath, elementName, namespaceInfo, isText);
            if (this.helper.getXMLToJavaTypeMap().get(pType.getRawName()) == Constants.BASE_64_BINARY_QNAME) {
                xmlField.setSchemaType(Constants.BASE_64_BINARY_QNAME);
            }
            if (this.areEquals(pType, Object.class)) {
                this.setTypedTextField(xmlField);
            }
            AbstractNullPolicy nullPolicy = null;
            if (isCollection) {
                ChoiceCollectionMapping xmlChoiceCollectionMapping = (ChoiceCollectionMapping)mapping;
                xmlChoiceCollectionMapping.addChoiceElement(xmlField, pTypeName);
                nestedMapping = (Mapping)xmlChoiceCollectionMapping.getChoiceElementMappings().get(xmlField);
                if (nestedMapping.isAbstractCompositeCollectionMapping()) {
                    ((CompositeCollectionMapping)nestedMapping).setKeepAsElementPolicy((org.eclipse.persistence.internal.oxm.mappings.UnmarshalKeepAsElementPolicy)UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT);
                    nullPolicy = ((CompositeCollectionMapping)nestedMapping).getNullPolicy();
                }
                if (nestedMapping.isAbstractCompositeDirectCollectionMapping()) {
                    DirectCollectionMapping nestedCompositeDirectCollectionMapping = (DirectCollectionMapping)nestedMapping;
                    nullPolicy = nestedCompositeDirectCollectionMapping.getNullPolicy();
                    if (pType.isEnum()) {
                        TypeInfo enumTypeInfo = this.typeInfo.get(pType.getQualifiedName());
                        nestedCompositeDirectCollectionMapping.setValueConverter((CoreConverter)this.buildJAXBEnumTypeConverter((Mapping)nestedCompositeDirectCollectionMapping, (EnumTypeInfo)enumTypeInfo));
                    }
                    if (element.isList()) {
                        XMLListConverter listConverter = new XMLListConverter();
                        listConverter.setObjectClassName(pType.getQualifiedName());
                        ((DirectCollectionMapping)nestedMapping).setValueConverter((CoreConverter)listConverter);
                    }
                } else if (nestedMapping instanceof BinaryDataCollectionMapping) {
                    nullPolicy = ((BinaryDataCollectionMapping)nestedMapping).getNullPolicy();
                    if (element.isList()) {
                        ((XMLField)((BinaryDataCollectionMapping)nestedMapping).getField()).setUsesSingleNode(true);
                    }
                }
            } else {
                ChoiceObjectMapping xmlChoiceObjectMapping = (ChoiceObjectMapping)mapping;
                xmlChoiceObjectMapping.addChoiceElement(xmlField, pTypeName);
                nestedMapping = (Mapping)xmlChoiceObjectMapping.getChoiceElementMappings().get(xmlField);
                if (pType.isEnum()) {
                    TypeInfo enumTypeInfo = this.typeInfo.get(pType.getQualifiedName());
                    ((DirectMapping)nestedMapping).setConverter((CoreConverter)this.buildJAXBEnumTypeConverter(nestedMapping, (EnumTypeInfo)enumTypeInfo));
                }
                if (nestedMapping.isAbstractCompositeObjectMapping()) {
                    ((CompositeObjectMapping)nestedMapping).setKeepAsElementPolicy((org.eclipse.persistence.internal.oxm.mappings.UnmarshalKeepAsElementPolicy)UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT);
                    nullPolicy = ((CompositeObjectMapping)nestedMapping).getNullPolicy();
                } else if (nestedMapping instanceof BinaryDataMapping) {
                    nullPolicy = ((BinaryDataMapping)nestedMapping).getNullPolicy();
                } else if (nestedMapping instanceof DirectMapping) {
                    nullPolicy = ((DirectMapping)nestedMapping).getNullPolicy();
                }
            }
            if (nullPolicy != null) {
                nullPolicy.setNullRepresentedByEmptyNode(false);
                nullPolicy.setMarshalNullRepresentation(XMLNullRepresentationType.XSI_NIL);
                nullPolicy.setNullRepresentedByXsiNil(true);
                nullPolicy.setIgnoreAttributesForNil(false);
            }
            if (element.isXmlRootElement()) continue;
            Class<JAXBElement.GlobalScope> scopeClass = element.getScopeClass();
            if (scopeClass == XmlElementDecl.GLOBAL.class) {
                scopeClass = JAXBElement.GlobalScope.class;
            }
            Class declaredType = null;
            declaredType = element.getAdaptedJavaType() != null ? Helper.getClassFromClasseName((String)element.getAdaptedJavaType().getQualifiedName(), (ClassLoader)this.helper.getClassLoader()) : Helper.getClassFromClasseName((String)pType.getQualifiedName(), (ClassLoader)this.helper.getClassLoader());
            JAXBElementConverter converter = new JAXBElementConverter(xmlField, declaredType, scopeClass);
            if (isCollection) {
                ChoiceCollectionMapping xmlChoiceCollectionMapping = (ChoiceCollectionMapping)mapping;
                if (element.getJavaTypeAdapterClass() != null) {
                    converter.setNestedConverter((CoreConverter)new XMLJavaTypeConverter(element.getJavaTypeAdapterClass().getName()));
                } else {
                    originalConverter = xmlChoiceCollectionMapping.getConverter(xmlField);
                    converter.setNestedConverter(originalConverter);
                }
                xmlChoiceCollectionMapping.addConverter(xmlField, (CoreConverter)converter);
                continue;
            }
            ChoiceObjectMapping xmlChoiceObjectMapping = (ChoiceObjectMapping)mapping;
            if (element.getJavaTypeAdapterClass() != null) {
                converter.setNestedConverter((CoreConverter)new XMLJavaTypeConverter(element.getJavaTypeAdapterClass().getName()));
            } else {
                originalConverter = xmlChoiceObjectMapping.getConverter(xmlField);
                converter.setNestedConverter(originalConverter);
            }
            xmlChoiceObjectMapping.addConverter(xmlField, (CoreConverter)converter);
        }
        if (property.isAny() && isCollection) {
            XMLChoiceCollectionMapping xmlChoiceCollectionMapping = mapping;
            xmlChoiceCollectionMapping.setIsAny(true);
        }
        return mapping;
    }

    private void setTypedTextField(Field field) {
        field.setIsTypedTextField(true);
        if (field.getSchemaType() == null) {
            field.setSchemaType(Constants.ANY_TYPE_QNAME);
        }
        ((XMLField)field).addXMLConversion(Constants.DATE_TIME_QNAME, CoreClassConstants.XML_GREGORIAN_CALENDAR);
        ((XMLField)field).addXMLConversion(Constants.DATE_QNAME, CoreClassConstants.XML_GREGORIAN_CALENDAR);
        ((XMLField)field).addXMLConversion(Constants.TIME_QNAME, CoreClassConstants.XML_GREGORIAN_CALENDAR);
        ((XMLField)field).addJavaConversion(CoreClassConstants.APBYTE, Constants.BASE_64_BINARY_QNAME);
        ((XMLField)field).addJavaConversion(CoreClassConstants.ABYTE, Constants.BASE_64_BINARY_QNAME);
    }

    public AnyCollectionMapping generateAnyCollectionMapping(Property property, Descriptor descriptor, NamespaceInfo namespaceInfo, boolean isMixed) {
        JavaClass collectionType;
        XMLAnyCollectionMapping mapping = new XMLAnyCollectionMapping();
        this.initializeXMLContainerMapping((XMLContainerMapping)mapping, property.getType().isArray());
        this.initializeXMLMapping((XMLMapping)mapping, property);
        if (property.getXmlPath() != null) {
            mapping.setField((CoreField)new XMLField(property.getXmlPath()));
        } else if (property.isSetXmlElementWrapper()) {
            mapping.setField((CoreField)this.getXPathForField(property, namespaceInfo, false, true));
        }
        if (property.isSetXmlElementWrapper()) {
            mapping.setWrapperNullPolicy(this.getWrapperNullPolicyFromProperty(property));
        }
        Class declaredType = Helper.getClassFromClasseName((String)property.getActualType().getQualifiedName(), (ClassLoader)this.helper.getClassLoader());
        JAXBElementRootConverter jaxbElementRootConverter = new JAXBElementRootConverter(declaredType);
        mapping.setConverter((CoreConverter)jaxbElementRootConverter);
        if (property.getDomHandlerClassName() != null) {
            jaxbElementRootConverter.setNestedConverter(new DomHandlerConverter(property.getDomHandlerClassName()));
        }
        if (property.isLax() || property.isReference()) {
            mapping.setKeepAsElementPolicy((org.eclipse.persistence.internal.oxm.mappings.UnmarshalKeepAsElementPolicy)UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT);
        } else if (property.isAny()) {
            mapping.setKeepAsElementPolicy((org.eclipse.persistence.internal.oxm.mappings.UnmarshalKeepAsElementPolicy)UnmarshalKeepAsElementPolicy.KEEP_ALL_AS_ELEMENT);
        } else {
            mapping.setKeepAsElementPolicy((org.eclipse.persistence.internal.oxm.mappings.UnmarshalKeepAsElementPolicy)UnmarshalKeepAsElementPolicy.KEEP_NONE_AS_ELEMENT);
        }
        mapping.setMixedContent(isMixed);
        if (isMixed) {
            mapping.setPreserveWhitespaceForMixedContent(true);
        }
        if (property.isAny()) {
            mapping.setUseXMLRoot(true);
        }
        if ((collectionType = property.getType()).isArray()) {
            JAXBArrayAttributeAccessor accessor = new JAXBArrayAttributeAccessor(mapping.getAttributeAccessor(), mapping.getContainerPolicy(), this.helper.getClassLoader());
            JavaClass componentType = collectionType.getComponentType();
            if (componentType.isArray()) {
                JavaClass baseComponentType = this.getBaseComponentType(componentType);
                if (baseComponentType.isPrimitive()) {
                    Class primitiveClass = XMLConversionManager.getDefaultManager().convertClassNameToClass(baseComponentType.getRawName());
                    accessor.setComponentClass(primitiveClass);
                } else {
                    accessor.setComponentClassName(baseComponentType.getQualifiedName());
                }
            } else {
                accessor.setComponentClassName(componentType.getQualifiedName());
            }
            mapping.setAttributeAccessor((CoreAttributeAccessor)accessor);
        }
        collectionType = this.containerClassImpl(collectionType);
        mapping.useCollectionClass(this.helper.getClassForJavaClass(collectionType));
        return mapping;
    }

    public CompositeObjectMapping generateCompositeObjectMapping(Property property, Descriptor descriptor, NamespaceInfo namespaceInfo, String referenceClassName) {
        XMLCompositeObjectMapping mapping = new XMLCompositeObjectMapping();
        this.initializeXMLMapping((XMLMapping)mapping, property);
        mapping.setField((CoreField)this.getXPathForField(property, namespaceInfo, false, false));
        if (property.isSetNullPolicy()) {
            mapping.setNullPolicy(this.getNullPolicyFromProperty(property, this.getNamespaceResolverForDescriptor(namespaceInfo)));
        } else {
            NullPolicy nullPolicy = (NullPolicy)mapping.getNullPolicy();
            nullPolicy.setSetPerformedForAbsentNode(false);
            if (property.isNillable()) {
                nullPolicy.setNullRepresentedByXsiNil(true);
                nullPolicy.setMarshalNullRepresentation(XMLNullRepresentationType.XSI_NIL);
            }
        }
        if (referenceClassName == null) {
            this.setTypedTextField((Field)mapping.getField());
            String defaultValue = property.getDefaultValue();
            if (defaultValue != null) {
                mapping.setConverter((CoreConverter)new DefaultElementConverter(defaultValue));
            }
        } else {
            mapping.setReferenceClassName(referenceClassName);
        }
        if (property.isTransientType()) {
            mapping.setReferenceClassName("UNKNOWN_OR_TRANSIENT_CLASS");
        }
        if (property.isRequired()) {
            ((Field)mapping.getField()).setRequired(true);
        }
        return mapping;
    }

    public DirectMapping generateDirectMapping(Property property, Descriptor descriptor, NamespaceInfo namespaceInfo) {
        XMLDirectMapping mapping = new XMLDirectMapping();
        mapping.setNullValueMarshalled(true);
        String fixedValue = property.getFixedValue();
        if (fixedValue != null) {
            mapping.setIsWriteOnly(true);
        }
        this.initializeXMLMapping((XMLMapping)mapping, property);
        Field xmlField = this.getXPathForField(property, namespaceInfo, true, false);
        mapping.setField((CoreField)xmlField);
        if (property.getDefaultValue() != null) {
            mapping.setNullValue((Object)property.getDefaultValue());
        }
        if (property.isXmlId()) {
            mapping.setCollapsingStringValues(true);
        }
        if (property.isSetNullPolicy()) {
            mapping.setNullPolicy(this.getNullPolicyFromProperty(property, this.getNamespaceResolverForDescriptor(namespaceInfo)));
        } else {
            if (property.isNillable()) {
                mapping.getNullPolicy().setNullRepresentedByXsiNil(true);
                mapping.getNullPolicy().setMarshalNullRepresentation(XMLNullRepresentationType.XSI_NIL);
            }
            mapping.getNullPolicy().setNullRepresentedByEmptyNode(false);
            if (!mapping.getXPath().equals("text()")) {
                ((NullPolicy)mapping.getNullPolicy()).setSetPerformedForAbsentNode(false);
            }
        }
        if (property.isRequired()) {
            ((Field)mapping.getField()).setRequired(true);
        }
        if (property.getType() != null) {
            String theClass = null;
            String targetClass = null;
            if (property.isSetXmlJavaTypeAdapter()) {
                theClass = property.getOriginalType().getQualifiedName();
                targetClass = property.getType().getQualifiedName();
            } else {
                theClass = property.getType().getQualifiedName();
            }
            try {
                JavaClass actualJavaClass = this.helper.getJavaClass(theClass);
                Class actualClass = Helper.getClassFromClasseName((String)actualJavaClass.getQualifiedName(), (ClassLoader)this.helper.getClassLoader());
                mapping.setAttributeClassification(actualClass);
                if (targetClass != null) {
                    Class fieldClass = Helper.getClassFromClasseName((String)targetClass, (ClassLoader)this.helper.getClassLoader());
                    mapping.getField().setType(fieldClass);
                }
            }
            catch (Exception e) {
                mapping.setAttributeClassificationName(theClass);
            }
        }
        if (Constants.QNAME_QNAME.equals(property.getSchemaType())) {
            ((Field)mapping.getField()).setSchemaType(Constants.QNAME_QNAME);
        }
        if (property.isSetCdata()) {
            mapping.setIsCDATA(property.isCdata());
        }
        return mapping;
    }

    public BinaryDataMapping generateBinaryMapping(Property property, Descriptor descriptor, NamespaceInfo namespaceInfo) {
        Field f;
        XMLBinaryDataMapping mapping = new XMLBinaryDataMapping();
        this.initializeXMLMapping((XMLMapping)mapping, property);
        mapping.setField((CoreField)this.getXPathForField(property, namespaceInfo, false, false));
        if (property.isSwaAttachmentRef()) {
            ((Field)mapping.getField()).setSchemaType(Constants.SWA_REF_QNAME);
            mapping.setSwaRef(true);
        } else if (property.isMtomAttachment() && !(f = (Field)mapping.getField()).getSchemaType().equals(Constants.HEX_BINARY_QNAME)) {
            f.setSchemaType(Constants.BASE_64_BINARY_QNAME);
        }
        if (property.isInlineBinaryData()) {
            mapping.setShouldInlineBinaryData(true);
        }
        if (property.getMimeType() != null) {
            mapping.setMimeTypePolicy((MimeTypePolicy)new FixedMimeTypePolicy(property.getMimeType(), (DatabaseMapping)mapping));
        } else if (this.areEquals(property.getType(), Source.class)) {
            mapping.setMimeTypePolicy((MimeTypePolicy)new FixedMimeTypePolicy("application/xml", (DatabaseMapping)mapping));
        } else if (this.areEquals(property.getType(), Image.class)) {
            mapping.setMimeTypePolicy((MimeTypePolicy)new FixedMimeTypePolicy("image/png", (DatabaseMapping)mapping));
        } else {
            mapping.setMimeTypePolicy((MimeTypePolicy)new FixedMimeTypePolicy("application/octet-stream", (DatabaseMapping)mapping));
        }
        if (property.isSetNullPolicy()) {
            mapping.setNullPolicy(this.getNullPolicyFromProperty(property, this.getNamespaceResolverForDescriptor(namespaceInfo)));
        } else {
            if (property.isNillable()) {
                mapping.getNullPolicy().setNullRepresentedByXsiNil(true);
                mapping.getNullPolicy().setMarshalNullRepresentation(XMLNullRepresentationType.XSI_NIL);
            }
            mapping.getNullPolicy().setNullRepresentedByEmptyNode(false);
            if (!mapping.getXPath().equals("text()")) {
                ((NullPolicy)mapping.getNullPolicy()).setSetPerformedForAbsentNode(false);
            }
        }
        mapping.setAttributeClassificationName(property.getActualType().getQualifiedName());
        return mapping;
    }

    public BinaryDataCollectionMapping generateBinaryDataCollectionMapping(Property property, Descriptor descriptor, NamespaceInfo namespaceInfo) {
        Field f;
        XMLBinaryDataCollectionMapping mapping = new XMLBinaryDataCollectionMapping();
        this.initializeXMLMapping((XMLMapping)mapping, property);
        this.initializeXMLContainerMapping((XMLContainerMapping)mapping, property.getType().isArray());
        if (property.isSetXmlElementWrapper()) {
            mapping.setWrapperNullPolicy(this.getWrapperNullPolicyFromProperty(property));
        }
        if (property.isSetNullPolicy()) {
            mapping.setNullPolicy(this.getNullPolicyFromProperty(property, this.getNamespaceResolverForDescriptor(namespaceInfo)));
        } else if (property.isNillable()) {
            mapping.getNullPolicy().setNullRepresentedByXsiNil(true);
            mapping.getNullPolicy().setMarshalNullRepresentation(XMLNullRepresentationType.XSI_NIL);
        }
        mapping.setField((CoreField)this.getXPathForField(property, namespaceInfo, false, false));
        if (property.isSwaAttachmentRef()) {
            ((Field)mapping.getField()).setSchemaType(Constants.SWA_REF_QNAME);
            mapping.setSwaRef(true);
        } else if (property.isMtomAttachment() && !(f = (Field)mapping.getField()).getSchemaType().equals(Constants.HEX_BINARY_QNAME)) {
            f.setSchemaType(Constants.BASE_64_BINARY_QNAME);
        }
        if (property.isInlineBinaryData()) {
            mapping.setShouldInlineBinaryData(true);
        }
        if (property.getMimeType() != null) {
            mapping.setMimeTypePolicy((MimeTypePolicy)new FixedMimeTypePolicy(property.getMimeType()));
        } else if (this.areEquals(property.getType(), Source.class)) {
            mapping.setMimeTypePolicy((MimeTypePolicy)new FixedMimeTypePolicy("application/xml"));
        } else {
            mapping.setMimeTypePolicy((MimeTypePolicy)new FixedMimeTypePolicy("application/octet-stream"));
        }
        JavaClass collectionType = property.getType();
        JavaClass itemType = property.getActualType();
        if (collectionType != null && this.helper.isCollectionType(collectionType)) {
            try {
                Class declaredClass = PrivilegedAccessHelper.getClassForName((String)itemType.getQualifiedName(), (boolean)false, (ClassLoader)this.helper.getClassLoader());
                mapping.setAttributeElementClass(declaredClass);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        collectionType = this.containerClassImpl(collectionType);
        mapping.useCollectionClassName(collectionType.getRawName());
        return mapping;
    }

    public DirectMapping generateDirectEnumerationMapping(Property property, Descriptor descriptor, NamespaceInfo namespaceInfo, EnumTypeInfo enumInfo) {
        XMLDirectMapping mapping = new XMLDirectMapping();
        this.initializeXMLMapping((XMLMapping)mapping, property);
        mapping.setNullValueMarshalled(true);
        mapping.setConverter((CoreConverter)this.buildJAXBEnumTypeConverter((Mapping)mapping, enumInfo));
        if (property.isSetNullPolicy()) {
            mapping.setNullPolicy(this.getNullPolicyFromProperty(property, this.getNamespaceResolverForDescriptor(namespaceInfo)));
        } else if (property.isNillable()) {
            mapping.getNullPolicy().setNullRepresentedByXsiNil(true);
            mapping.getNullPolicy().setMarshalNullRepresentation(XMLNullRepresentationType.XSI_NIL);
        }
        mapping.setField((CoreField)this.getXPathForField(property, namespaceInfo, true, false));
        if (!mapping.getXPath().equals("text()")) {
            ((NullPolicy)mapping.getNullPolicy()).setSetPerformedForAbsentNode(false);
        }
        return mapping;
    }

    private JAXBEnumTypeConverter buildJAXBEnumTypeConverter(Mapping mapping, EnumTypeInfo enumInfo) {
        JAXBEnumTypeConverter converter = new JAXBEnumTypeConverter(mapping, enumInfo.getClassName(), false);
        List<String> fieldNames = enumInfo.getFieldNames();
        List<Object> xmlEnumValues = enumInfo.getXmlEnumValues();
        int i = 0;
        while (i < fieldNames.size()) {
            converter.addConversionValue(xmlEnumValues.get(i), fieldNames.get(i));
            ++i;
        }
        return converter;
    }

    public Mapping generateCollectionMapping(Property property, Descriptor descriptor, JavaClass descriptorJavaClass, NamespaceInfo namespaceInfo) {
        JavaClass javaClass = property.getActualType();
        if (property.isMixedContent()) {
            return this.generateAnyCollectionMapping(property, descriptor, namespaceInfo, true);
        }
        if (property.isXmlIdRef() || property.isSetXmlJoinNodes()) {
            return this.generateXMLCollectionReferenceMapping(property, descriptor, namespaceInfo, javaClass);
        }
        if (javaClass != null && this.typeInfo.get(javaClass.getQualifiedName()) != null) {
            TypeInfo referenceInfo = this.typeInfo.get(javaClass.getQualifiedName());
            if (referenceInfo.isEnumerationType()) {
                return this.generateEnumCollectionMapping(property, descriptor, namespaceInfo, (EnumTypeInfo)referenceInfo);
            }
            return this.generateCompositeCollectionMapping(property, descriptor, descriptorJavaClass, namespaceInfo, javaClass.getQualifiedName());
        }
        if (!property.isAttribute() && javaClass != null && javaClass.getQualifiedName().equals(OBJECT_CLASS_NAME)) {
            CompositeCollectionMapping ccMapping = this.generateCompositeCollectionMapping(property, descriptor, descriptorJavaClass, namespaceInfo, null);
            ccMapping.setKeepAsElementPolicy((org.eclipse.persistence.internal.oxm.mappings.UnmarshalKeepAsElementPolicy)UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT);
            return ccMapping;
        }
        if (this.isBinaryData(javaClass)) {
            return this.generateBinaryDataCollectionMapping(property, descriptor, namespaceInfo);
        }
        return this.generateDirectCollectionMapping(property, descriptor, namespaceInfo);
    }

    public DirectCollectionMapping generateEnumCollectionMapping(Property property, Descriptor descriptor, NamespaceInfo namespaceInfo, EnumTypeInfo info) {
        DirectCollectionMapping mapping = this.generateDirectCollectionMapping(property, descriptor, namespaceInfo);
        mapping.setValueConverter((CoreConverter)this.buildJAXBEnumTypeConverter((Mapping)mapping, info));
        return mapping;
    }

    public AnyAttributeMapping generateAnyAttributeMapping(Property property, Descriptor descriptor, NamespaceInfo namespaceInfo) {
        XMLAnyAttributeMapping mapping = new XMLAnyAttributeMapping();
        this.initializeXMLMapping((XMLMapping)mapping, property);
        this.initializeXMLContainerMapping((XMLContainerMapping)mapping, property.getType().isArray());
        if (property.getXmlPath() != null) {
            mapping.setField((CoreField)new XMLField(property.getXmlPath()));
        }
        mapping.setSchemaInstanceIncluded(false);
        mapping.setNamespaceDeclarationIncluded(false);
        JavaClass mapType = property.getType();
        if (this.areEquals(mapType, Map.class)) {
            mapType = this.jotHashMap;
        }
        mapping.useMapClassName(mapType.getRawName());
        return mapping;
    }

    public AnyObjectMapping generateAnyObjectMapping(Property property, Descriptor descriptor, NamespaceInfo namespaceInfo) {
        XMLAnyObjectMapping mapping = new XMLAnyObjectMapping();
        this.initializeXMLMapping((XMLMapping)mapping, property);
        if (property.getXmlPath() != null) {
            mapping.setField((CoreField)new XMLField(property.getXmlPath()));
        }
        Class declaredType = Helper.getClassFromClasseName((String)property.getActualType().getQualifiedName(), (ClassLoader)this.helper.getClassLoader());
        JAXBElementRootConverter jaxbElementRootConverter = new JAXBElementRootConverter(declaredType);
        mapping.setConverter((CoreConverter)jaxbElementRootConverter);
        if (property.getDomHandlerClassName() != null) {
            jaxbElementRootConverter.setNestedConverter(new DomHandlerConverter(property.getDomHandlerClassName()));
        }
        if (property.isLax()) {
            mapping.setKeepAsElementPolicy((org.eclipse.persistence.internal.oxm.mappings.UnmarshalKeepAsElementPolicy)UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT);
        } else {
            mapping.setKeepAsElementPolicy((org.eclipse.persistence.internal.oxm.mappings.UnmarshalKeepAsElementPolicy)UnmarshalKeepAsElementPolicy.KEEP_ALL_AS_ELEMENT);
        }
        if (property.isMixedContent()) {
            mapping.setMixedContent(true);
        } else {
            mapping.setUseXMLRoot(true);
        }
        return mapping;
    }

    protected boolean areEquals(JavaClass src, Class tgt) {
        if (src == null || tgt == null) {
            return false;
        }
        return src.getRawName().equals(tgt.getCanonicalName());
    }

    protected boolean areEquals(JavaClass src, String tgtCanonicalName) {
        if (src == null || tgtCanonicalName == null) {
            return false;
        }
        return src.getRawName().equals(tgtCanonicalName);
    }

    private Class generateMapEntryClassAndDescriptor(Property property, org.eclipse.persistence.internal.oxm.NamespaceResolver nr) {
        JavaClass keyType = property.getKeyType();
        JavaClass valueType = property.getValueType();
        if (keyType == null) {
            keyType = this.helper.getJavaClass("java.lang.Object");
        }
        if (valueType == null) {
            valueType = this.helper.getJavaClass("java.lang.Object");
        }
        String mapEntryClassName = this.getJaxbClassLoader().nextAvailableGeneratedClassName();
        MapEntryGeneratedKey mapKey = new MapEntryGeneratedKey(keyType.getQualifiedName(), valueType.getQualifiedName());
        Class generatedClass = this.getGeneratedMapEntryClasses().get(mapKey);
        if (generatedClass == null) {
            generatedClass = this.generateMapEntryClass(mapEntryClassName, keyType.getQualifiedName(), valueType.getQualifiedName());
            this.getGeneratedMapEntryClasses().put(mapKey, generatedClass);
            XMLDescriptor desc = new XMLDescriptor();
            desc.setJavaClass(generatedClass);
            desc.addMapping((CoreMapping)this.generateMappingForType(keyType, "key"));
            desc.addMapping((CoreMapping)this.generateMappingForType(valueType, "value"));
            desc.setNamespaceResolver(nr);
            this.project.addDescriptor((CoreDescriptor)desc);
        }
        return generatedClass;
    }

    private Class generateMapEntryClass(String className, String keyType, String valueType) {
        EclipseLinkASMClassWriter cw = new EclipseLinkASMClassWriter();
        String qualifiedInternalClassName = className.replace('.', '/');
        String qualifiedInternalKeyClassName = keyType.replace('.', '/');
        String qualifiedInternalValueClassName = valueType.replace('.', '/');
        String valuePrefix = "L";
        if (qualifiedInternalValueClassName.startsWith("[L") && qualifiedInternalValueClassName.endsWith(";")) {
            valuePrefix = "[L";
            qualifiedInternalValueClassName = qualifiedInternalValueClassName.substring(2, qualifiedInternalValueClassName.length() - 1);
        }
        String sig = "Ljava/lang/Object;Lorg/eclipse/persistence/internal/jaxb/many/MapEntry<L" + qualifiedInternalKeyClassName + ";" + valuePrefix + qualifiedInternalValueClassName + ";>;";
        cw.visit(33, qualifiedInternalClassName, sig, "java/lang/Object", new String[]{"org/eclipse/persistence/internal/jaxb/many/MapEntry"});
        cw.visitField(2, "key", "L" + qualifiedInternalKeyClassName + ";", null, null);
        cw.visitField(2, "value", String.valueOf(valuePrefix) + qualifiedInternalValueClassName + ";", null, null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "getKey", "()L" + qualifiedInternalKeyClassName + ";", null, null);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, qualifiedInternalClassName, "key", "L" + qualifiedInternalKeyClassName + ";");
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "setKey", "(L" + qualifiedInternalKeyClassName + ";)V", null, null);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitFieldInsn(181, qualifiedInternalClassName, "key", "L" + qualifiedInternalKeyClassName + ";");
        mv.visitInsn(177);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
        mv = cw.visitMethod(1, "getValue", "()" + valuePrefix + qualifiedInternalValueClassName + ";", null, null);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, qualifiedInternalClassName, "value", String.valueOf(valuePrefix) + qualifiedInternalValueClassName + ";");
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "setValue", "(" + valuePrefix + qualifiedInternalValueClassName + ";)V", null, null);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitFieldInsn(181, qualifiedInternalClassName, "value", String.valueOf(valuePrefix) + qualifiedInternalValueClassName + ";");
        mv.visitInsn(177);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
        if (!qualifiedInternalValueClassName.equals("java/lang/Object")) {
            mv = cw.visitMethod(4161, "getValue", "()Ljava/lang/Object;", null, null);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(182, qualifiedInternalClassName, "getValue", "()" + valuePrefix + qualifiedInternalValueClassName + ";", false);
            mv.visitInsn(176);
            mv.visitMaxs(1, 1);
            mv.visitEnd();
            mv = cw.visitMethod(4161, "setValue", "(Ljava/lang/Object;)V", null, null);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            if (valuePrefix.equals("[L")) {
                mv.visitTypeInsn(192, String.valueOf(valuePrefix) + qualifiedInternalValueClassName + ";");
            } else {
                mv.visitTypeInsn(192, qualifiedInternalValueClassName);
            }
            mv.visitMethodInsn(182, qualifiedInternalClassName, "setValue", "(" + valuePrefix + qualifiedInternalValueClassName + ";)V", false);
            mv.visitInsn(177);
            mv.visitMaxs(2, 2);
            mv.visitEnd();
        }
        if (!qualifiedInternalKeyClassName.equals("java/lang/Object")) {
            mv = cw.visitMethod(4161, "getKey", "()Ljava/lang/Object;", null, null);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(182, qualifiedInternalClassName, "getKey", "()L" + qualifiedInternalKeyClassName + ";", false);
            mv.visitInsn(176);
            mv.visitMaxs(1, 1);
            mv.visitEnd();
            mv = cw.visitMethod(4161, "setKey", "(Ljava/lang/Object;)V", null, null);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitTypeInsn(192, qualifiedInternalKeyClassName);
            mv.visitMethodInsn(182, qualifiedInternalClassName, "setKey", "(L" + qualifiedInternalKeyClassName + ";)V", false);
            mv.visitInsn(177);
            mv.visitMaxs(2, 2);
            mv.visitEnd();
        }
        cw.visitEnd();
        byte[] classBytes = cw.toByteArray();
        Class generatedClass = this.getJaxbClassLoader().generateClass(className, classBytes);
        return generatedClass;
    }

    private Mapping generateMappingForType(JavaClass theType, String attributeName) {
        XMLCompositeObjectMapping mapping;
        boolean typeIsObject = theType.getRawName().equals(OBJECT_CLASS_NAME);
        TypeInfo info = this.typeInfo.get(theType.getQualifiedName());
        if (info != null && !info.isEnumerationType() || typeIsObject) {
            mapping = new XMLCompositeObjectMapping();
            mapping.setAttributeName(attributeName);
            ((CompositeObjectMapping)mapping).setXPath(attributeName);
            if (typeIsObject) {
                ((CompositeObjectMapping)mapping).setKeepAsElementPolicy((org.eclipse.persistence.internal.oxm.mappings.UnmarshalKeepAsElementPolicy)UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT);
                this.setTypedTextField((Field)((CompositeObjectMapping)mapping).getField());
            } else {
                ((CompositeObjectMapping)mapping).setReferenceClassName(theType.getQualifiedName());
            }
        } else if (theType.isArray() || this.helper.isCollectionType(theType)) {
            JavaClass itemType;
            Class declaredClass;
            Collection args;
            XMLCompositeDirectCollectionMapping directCollectionMapping = new XMLCompositeDirectCollectionMapping();
            mapping = directCollectionMapping;
            this.initializeXMLContainerMapping((XMLContainerMapping)directCollectionMapping, theType.isArray());
            directCollectionMapping.setAttributeName(attributeName);
            if (theType.isArray()) {
                JAXBArrayAttributeAccessor accessor = new JAXBArrayAttributeAccessor(directCollectionMapping.getAttributeAccessor(), directCollectionMapping.getContainerPolicy(), this.helper.getClassLoader());
                String componentClassName = theType.getComponentType().getQualifiedName();
                if (theType.getComponentType().isPrimitive()) {
                    Class primitiveClass = XMLConversionManager.getDefaultManager().convertClassNameToClass(componentClassName);
                    accessor.setComponentClass(primitiveClass);
                    directCollectionMapping.setAttributeAccessor((CoreAttributeAccessor)accessor);
                    XMLConversionManager.getDefaultManager();
                    Class declaredClass2 = ConversionManager.getObjectClass((Class)primitiveClass);
                    directCollectionMapping.setAttributeElementClass(declaredClass2);
                } else {
                    accessor.setComponentClassName(componentClassName);
                    directCollectionMapping.setAttributeAccessor((CoreAttributeAccessor)accessor);
                    JavaClass componentType = theType.getComponentType();
                    Class declaredClass3 = (Class)PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.getClassForName((String)componentType.getRawName(), (boolean)false, (ClassLoader)this.helper.getClassLoader()), ex -> JAXBException.classNotFoundException((String)componentType.getRawName()));
                    directCollectionMapping.setAttributeElementClass(declaredClass3);
                }
            } else if (this.helper.isCollectionType(theType) && (args = theType.getActualTypeArguments()).size() > 0 && (declaredClass = (Class)PrivilegedAccessHelper.callDoPrivilegedWithException(() -> this.lambda$2(itemType = (JavaClass)args.iterator().next()), ex -> JAXBException.classNotFoundException((String)itemType.getRawName()))) != String.class) {
                directCollectionMapping.setAttributeElementClass(declaredClass);
            }
            theType = this.containerClassImpl(theType);
            directCollectionMapping.useCollectionClassName(theType.getRawName());
            directCollectionMapping.setXPath(String.valueOf(attributeName) + TXT);
        } else {
            mapping = new XMLDirectMapping();
            mapping.setAttributeName(attributeName);
            ((DirectMapping)mapping).setNullValueMarshalled(true);
            ((DirectMapping)mapping).setXPath(String.valueOf(attributeName) + TXT);
            QName schemaType = this.userDefinedSchemaTypes.get(theType.getQualifiedName());
            if (schemaType == null) {
                schemaType = (QName)this.helper.getXMLToJavaTypeMap().get(theType);
            }
            ((Field)((DirectMapping)mapping).getField()).setSchemaType(schemaType);
            if (info != null && info.isEnumerationType()) {
                ((DirectMapping)mapping).setConverter((CoreConverter)this.buildJAXBEnumTypeConverter((Mapping)mapping, (EnumTypeInfo)info));
            }
        }
        return mapping;
    }

    public CompositeCollectionMapping generateCompositeCollectionMapping(Property property, Descriptor descriptor, JavaClass javaClass, NamespaceInfo namespaceInfo, String referenceClassName) {
        JavaClass collectionType;
        boolean nestedArray = false;
        XMLCompositeCollectionMapping mapping = new XMLCompositeCollectionMapping();
        this.initializeXMLMapping((XMLMapping)mapping, property);
        this.initializeXMLContainerMapping((XMLContainerMapping)mapping, property.getType().isArray());
        JavaClass manyValueJavaClass = this.helper.getJavaClass(ManyValue.class);
        if (manyValueJavaClass.isAssignableFrom(javaClass)) {
            mapping.setReuseContainer(false);
        }
        if (property.isSetNullPolicy()) {
            mapping.setNullPolicy(this.getNullPolicyFromProperty(property, this.getNamespaceResolverForDescriptor(namespaceInfo)));
        } else if (property.isNillable()) {
            mapping.getNullPolicy().setNullRepresentedByXsiNil(true);
            mapping.getNullPolicy().setMarshalNullRepresentation(XMLNullRepresentationType.XSI_NIL);
        }
        if (property.isSetXmlElementWrapper()) {
            mapping.setWrapperNullPolicy(this.getWrapperNullPolicyFromProperty(property));
        }
        if ((collectionType = property.getType()).isArray()) {
            JAXBArrayAttributeAccessor accessor = new JAXBArrayAttributeAccessor(mapping.getAttributeAccessor(), mapping.getContainerPolicy(), this.helper.getClassLoader());
            JavaClass componentType = collectionType.getComponentType();
            if (componentType.isArray()) {
                Class adaptedClass = this.classToGeneratedClasses.get(componentType.getName());
                referenceClassName = adaptedClass.getName();
                accessor.setAdaptedClassName(referenceClassName);
                JavaClass baseComponentType = this.getBaseComponentType(componentType);
                if (baseComponentType.isPrimitive()) {
                    Class primitiveClass = XMLConversionManager.getDefaultManager().convertClassNameToClass(baseComponentType.getRawName());
                    accessor.setComponentClass(primitiveClass);
                } else {
                    accessor.setComponentClassName(baseComponentType.getQualifiedName());
                }
            } else {
                accessor.setComponentClassName(componentType.getQualifiedName());
            }
            mapping.setAttributeAccessor((CoreAttributeAccessor)accessor);
        } else if (this.helper.isMapType(property.getType())) {
            Class generatedClass = this.generateMapEntryClassAndDescriptor(property, descriptor.getNonNullNamespaceResolver());
            referenceClassName = generatedClass.getName();
            String mapClassName = property.getType().getRawName();
            mapping.setAttributeAccessor((CoreAttributeAccessor)new MapValueAttributeAccessor(mapping.getAttributeAccessor(), mapping.getContainerPolicy(), generatedClass, mapClassName, this.helper.getClassLoader()));
        }
        if (collectionType.getComponentType() == null) {
            if ((collectionType.isArray() || this.helper.isCollectionType(collectionType)) && referenceClassName != null && referenceClassName.contains("jaxb.dev.java.net.array")) {
                nestedArray = true;
            }
        } else if ((collectionType.isArray() || this.helper.isCollectionType(collectionType)) && (collectionType.getComponentType().isArray() || this.helper.isCollectionType(collectionType.getComponentType()))) {
            nestedArray = true;
        }
        collectionType = this.containerClassImpl(collectionType);
        mapping.useCollectionClassName(collectionType.getRawName());
        Field xmlField = this.getXPathForField(property, namespaceInfo, false, false);
        if (this.helper.isMapType(property.getType())) {
            JavaClass mapValueClass = this.helper.getJavaClass(MapValue.class);
            if (mapValueClass.isAssignableFrom(javaClass)) {
                mapping.setXPath("entry");
            } else {
                mapping.setXPath(String.valueOf(xmlField.getXPath()) + "/entry");
            }
        } else {
            mapping.setXPath(xmlField.getXPath());
        }
        if (referenceClassName == null) {
            this.setTypedTextField((Field)mapping.getField());
        } else {
            mapping.setReferenceClassName(referenceClassName);
        }
        if (property.isTransientType()) {
            mapping.setReferenceClassName("UNKNOWN_OR_TRANSIENT_CLASS");
        }
        if (property.isRequired()) {
            ((Field)mapping.getField()).setRequired(true);
        }
        ((Field)mapping.getField()).setNestedArray(nestedArray);
        return mapping;
    }

    public DirectCollectionMapping generateDirectCollectionMapping(Property property, Descriptor descriptor, NamespaceInfo namespaceInfo) {
        Collection args;
        XMLCompositeDirectCollectionMapping mapping = new XMLCompositeDirectCollectionMapping();
        this.initializeXMLMapping((XMLMapping)mapping, property);
        this.initializeXMLContainerMapping((XMLContainerMapping)mapping, property.getType().isArray());
        JavaClass collectionType = property.getType();
        if (collectionType.isArray()) {
            JAXBArrayAttributeAccessor accessor = new JAXBArrayAttributeAccessor(mapping.getAttributeAccessor(), mapping.getContainerPolicy(), this.helper.getClassLoader());
            String componentClassName = collectionType.getComponentType().getQualifiedName();
            if (collectionType.getComponentType().isPrimitive()) {
                Class primitiveClass = XMLConversionManager.getDefaultManager().convertClassNameToClass(componentClassName);
                accessor.setComponentClass(primitiveClass);
                mapping.setAttributeAccessor((CoreAttributeAccessor)accessor);
                XMLConversionManager.getDefaultManager();
                Class declaredClass = ConversionManager.getObjectClass((Class)primitiveClass);
                mapping.setAttributeElementClass(declaredClass);
            } else {
                accessor.setComponentClassName(componentClassName);
                mapping.setAttributeAccessor((CoreAttributeAccessor)accessor);
                JavaClass componentType = collectionType.getComponentType();
                try {
                    Class declaredClass = PrivilegedAccessHelper.getClassForName((String)componentType.getRawName(), (boolean)false, (ClassLoader)this.helper.getClassLoader());
                    mapping.setAttributeElementClass(declaredClass);
                }
                catch (Exception exception) {}
            }
        } else if (this.helper.isCollectionType(collectionType) && (args = collectionType.getActualTypeArguments()).size() > 0) {
            JavaClass itemType = (JavaClass)args.iterator().next();
            try {
                Class declaredClass = PrivilegedAccessHelper.getClassForName((String)itemType.getRawName(), (boolean)false, (ClassLoader)this.helper.getClassLoader());
                if (declaredClass != String.class) {
                    mapping.setAttributeElementClass(declaredClass);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        collectionType = this.containerClassImpl(collectionType);
        mapping.useCollectionClassName(collectionType.getRawName());
        if (property.getDefaultValue() != null) {
            mapping.setNullValue((Object)property.getDefaultValue());
        }
        Field xmlField = this.getXPathForField(property, namespaceInfo, true, false);
        mapping.setField((CoreField)xmlField);
        if (this.helper.isAnnotationPresent(property.getElement(), XmlMixed.class)) {
            xmlField.setXPath("text()");
        }
        if (Constants.QNAME_QNAME.equals(property.getSchemaType())) {
            ((Field)mapping.getField()).setSchemaType(Constants.QNAME_QNAME);
        }
        if (property.isSetNullPolicy()) {
            mapping.setNullPolicy(this.getNullPolicyFromProperty(property, this.getNamespaceResolverForDescriptor(namespaceInfo)));
        } else if (property.isNillable()) {
            mapping.getNullPolicy().setNullRepresentedByXsiNil(true);
            mapping.getNullPolicy().setMarshalNullRepresentation(XMLNullRepresentationType.XSI_NIL);
        }
        mapping.getNullPolicy().setNullRepresentedByEmptyNode(false);
        if (property.isSetXmlElementWrapper()) {
            mapping.setWrapperNullPolicy(this.getWrapperNullPolicyFromProperty(property));
        }
        if (property.isRequired()) {
            ((Field)mapping.getField()).setRequired(true);
        }
        if (property.isXmlElementType() && property.getGenericType() != null) {
            Class theClass = Helper.getClassFromClasseName((String)property.getGenericType().getQualifiedName(), (ClassLoader)this.helper.getClassLoader());
            mapping.setAttributeElementClass(theClass);
        }
        if (xmlField.getXPathFragment().isAttribute() || property.isXmlList() || xmlField.getXPathFragment().nameIsText()) {
            mapping.setUsesSingleNode(true);
        }
        if (property.isSetCdata()) {
            mapping.setIsCDATA(property.isCdata());
        }
        return mapping;
    }

    public String getPrefixForNamespace(String URI, org.eclipse.persistence.internal.oxm.NamespaceResolver namespaceResolver) {
        return this.getPrefixForNamespace(URI, namespaceResolver, true);
    }

    public String getPrefixForNamespace(String URI, org.eclipse.persistence.internal.oxm.NamespaceResolver namespaceResolver, boolean addPrefixToNR) {
        String defaultNS = namespaceResolver.getDefaultNamespaceURI();
        if (defaultNS != null && URI.equals(defaultNS)) {
            return null;
        }
        String prefix = namespaceResolver.resolveNamespaceURI(URI);
        if (prefix != null) {
            return prefix;
        }
        prefix = this.globalNamespaceResolver.resolveNamespaceURI(URI);
        if (prefix == null) {
            if (URI.equals(this.globalNamespaceResolver.getDefaultNamespaceURI())) {
                namespaceResolver.setDefaultNamespaceURI(URI);
                return null;
            }
            String suggestedPrefix = null;
            NamespaceInfo refInfo = this.getNamespaceInfoForURI(URI);
            if (refInfo != null && refInfo.getNamespaceResolver() != null) {
                suggestedPrefix = refInfo.getNamespaceResolver().resolveNamespaceURI(URI);
            }
            prefix = suggestedPrefix != null ? this.globalNamespaceResolver.generatePrefix(suggestedPrefix) : this.globalNamespaceResolver.generatePrefix();
        }
        String nrUri = namespaceResolver.resolveNamespacePrefix(prefix);
        while (nrUri != null && !URI.equals(nrUri)) {
            prefix = this.globalNamespaceResolver.generatePrefix();
            nrUri = namespaceResolver.resolveNamespacePrefix(prefix);
        }
        if (addPrefixToNR) {
            namespaceResolver.put(prefix, URI);
        }
        this.globalNamespaceResolver.put(prefix, URI);
        return prefix;
    }

    private void setupInheritance(JavaClass jClass) {
        TypeInfo tInfo = this.typeInfo.get(jClass.getName());
        Descriptor descriptor = tInfo.getDescriptor();
        if (descriptor == null) {
            return;
        }
        JavaClass superClass = CompilerHelper.getNextMappedSuperClass(jClass, this.typeInfo, this.helper);
        if (superClass == null) {
            return;
        }
        TypeInfo superTypeInfo = this.typeInfo.get(superClass.getName());
        if (superTypeInfo == null) {
            return;
        }
        Descriptor superDescriptor = superTypeInfo.getDescriptor();
        if (superDescriptor != null) {
            Object value;
            XMLSchemaReference sRef = descriptor.getSchemaReference();
            if (sRef == null || sRef.getSchemaContext() == null) {
                return;
            }
            JavaClass rootMappedSuperClass = this.getRootMappedSuperClass(superClass);
            TypeInfo rootTypeInfo = this.typeInfo.get(rootMappedSuperClass.getName());
            Descriptor rootDescriptor = rootTypeInfo.getDescriptor();
            if (rootDescriptor.getNamespaceResolver() == null) {
                rootDescriptor.setNamespaceResolver((org.eclipse.persistence.internal.oxm.NamespaceResolver)new NamespaceResolver());
            }
            if (rootDescriptor.getInheritancePolicy().getClassIndicatorField() == null) {
                XMLField classIndicatorField;
                if (rootTypeInfo.isSetXmlDiscriminatorNode()) {
                    classIndicatorField = new XMLField(rootTypeInfo.getXmlDiscriminatorNode());
                } else {
                    classIndicatorField = XMLConstants.DEFAULT_XML_TYPE_ATTRIBUTE;
                    classIndicatorField.getXPathFragment().setNamespaceURI("http://www.w3.org/2001/XMLSchema-instance");
                }
                rootDescriptor.getInheritancePolicy().setClassIndicatorField((CoreField)classIndicatorField);
            }
            Object sCtx = null;
            if (tInfo.isSetXmlDiscriminatorValue()) {
                sCtx = tInfo.getXmlDiscriminatorValue();
            } else if (!tInfo.isAnonymousComplexType()) {
                sCtx = sRef.getSchemaContextAsQName();
            }
            if (sCtx != null) {
                descriptor.getInheritancePolicy().setParentClassName(superClass.getName());
                rootDescriptor.getInheritancePolicy().addClassNameIndicator(jClass.getName(), sCtx);
            }
            if ((value = rootDescriptor.getInheritancePolicy().getClassNameIndicatorMapping().get(rootDescriptor.getJavaClassName())) == null) {
                if (rootTypeInfo.isSetXmlDiscriminatorValue()) {
                    rootDescriptor.getInheritancePolicy().addClassNameIndicator(rootDescriptor.getJavaClassName(), (Object)rootTypeInfo.getXmlDiscriminatorValue());
                } else {
                    XMLSchemaReference rootSRef = rootDescriptor.getSchemaReference();
                    if (rootSRef != null && rootSRef.getSchemaContext() != null) {
                        QName rootSCtx = rootSRef.getSchemaContextAsQName();
                        rootDescriptor.getInheritancePolicy().addClassNameIndicator(rootDescriptor.getJavaClassName(), (Object)rootSCtx);
                    }
                }
            }
            rootDescriptor.getInheritancePolicy().setShouldReadSubclasses(Boolean.valueOf(true));
            Map childGroups = ((XMLDescriptor)descriptor).getAttributeGroups();
            Map parentGroups = ((XMLDescriptor)rootDescriptor).getAttributeGroups();
            if (childGroups != null && !childGroups.isEmpty() && parentGroups != null && !parentGroups.isEmpty()) {
                for (String nextKey : childGroups.keySet()) {
                    AttributeGroup parentGroup = (AttributeGroup)parentGroups.get(nextKey);
                    if (parentGroup == null) continue;
                    AttributeGroup childGroup = (AttributeGroup)childGroups.get(nextKey);
                    parentGroup.getSubClassGroups().put(descriptor.getJavaClassName(), childGroup);
                }
            }
        }
    }

    private JavaClass getRootMappedSuperClass(JavaClass javaClass) {
        JavaClass rootMappedSuperClass;
        JavaClass nextMappedSuperClass = rootMappedSuperClass = javaClass;
        while (nextMappedSuperClass != null) {
            if ((nextMappedSuperClass = CompilerHelper.getNextMappedSuperClass(nextMappedSuperClass, this.typeInfo, this.helper)) == null) {
                return rootMappedSuperClass;
            }
            rootMappedSuperClass = nextMappedSuperClass;
        }
        return rootMappedSuperClass;
    }

    public void generateMappings() {
        for (String next : this.typeInfo.keySet()) {
            JavaClass javaClass = this.helper.getJavaClass(next);
            TypeInfo info = this.typeInfo.get(next);
            if (info.isEnumerationType()) continue;
            NamespaceInfo namespaceInfo = this.packageToPackageInfoMappings.get(javaClass.getPackageName()).getNamespaceInfo();
            Descriptor descriptor = info.getDescriptor();
            if (descriptor != null) {
                CoreMapping mapping;
                this.generateMappings(info, descriptor, javaClass, namespaceInfo);
                if (info.isIDSet() && (mapping = descriptor.getMappingForAttributeName(info.getIDProperty().getPropertyName())) != null) {
                    descriptor.addPrimaryKeyField(mapping.getField());
                }
                if (info.hasXmlKeyProperties()) {
                    for (Property keyProp : info.getXmlKeyProperties()) {
                        mapping = descriptor.getMappingForAttributeName(keyProp.getPropertyName());
                        if (mapping == null) continue;
                        descriptor.addPrimaryKeyField(mapping.getField());
                    }
                }
            }
            info.postInitialize();
            if (descriptor == null) continue;
            this.logMappingGeneration(descriptor);
        }
    }

    public void generateMappings(TypeInfo info, Descriptor descriptor, JavaClass descriptorJavaClass, NamespaceInfo namespaceInfo) {
        if (info.isAnonymousComplexType()) {
            this.generateInheritedMappingsForAnonymousType(info, descriptor, descriptorJavaClass, namespaceInfo);
        }
        List<Property> propertiesInOrder = info.getNonTransientPropertiesInPropOrder();
        int i = 0;
        while (i < propertiesInOrder.size()) {
            Property next = propertiesInOrder.get(i);
            if (next != null && (!next.isTransient() || next.isTransient() && next.isXmlLocation())) {
                AccessorFactoryWrapper accessorFactory;
                Mapping mapping = this.generateMapping(next, descriptor, descriptorJavaClass, namespaceInfo);
                if (next.isVirtual()) {
                    VirtualAttributeAccessor accessor = new VirtualAttributeAccessor();
                    accessor.setAttributeName(mapping.getAttributeName());
                    String getMethod = info.getXmlVirtualAccessMethods().getGetMethod();
                    String setMethod = info.getXmlVirtualAccessMethods().getSetMethod();
                    if (mapping.getAttributeAccessor().isMethodAttributeAccessor()) {
                        getMethod = ((MethodAttributeAccessor)mapping.getAttributeAccessor()).getGetMethodName();
                        setMethod = ((MethodAttributeAccessor)mapping.getAttributeAccessor()).getSetMethodName();
                        accessor.setValueType(mapping.getAttributeClassification());
                    }
                    accessor.setGetMethodName(getMethod);
                    accessor.setSetMethodName(setMethod);
                    if (mapping.getAttributeAccessor() instanceof JAXBArrayAttributeAccessor) {
                        JAXBArrayAttributeAccessor jaa = (JAXBArrayAttributeAccessor)mapping.getAttributeAccessor();
                        jaa.setNestedAccessor((AttributeAccessor)accessor);
                    } else {
                        mapping.setAttributeAccessor((CoreAttributeAccessor)accessor);
                    }
                }
                if (mapping != null) {
                    descriptor.addMapping((CoreMapping)mapping);
                }
                if (next.isSetUserProperties()) {
                    mapping.setProperties(next.getUserProperties());
                }
                if ((accessorFactory = info.getXmlAccessorFactory()) == null) {
                    accessorFactory = info.getPackageLevelXmlAccessorFactory();
                }
                if (accessorFactory != null) {
                    try {
                        Object accessor = CompilerHelper.createAccessorFor(descriptorJavaClass, next, this.helper, accessorFactory);
                        if (accessor != null) {
                            CustomAccessorAttributeAccessor attributeAccessor = new CustomAccessorAttributeAccessor(accessor);
                            mapping.setAttributeAccessor((CoreAttributeAccessor)attributeAccessor);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            next.postInitialize();
            ++i;
        }
    }

    private void generateInheritedMappingsForAnonymousType(TypeInfo info, Descriptor descriptor, JavaClass descriptorJavaClass, NamespaceInfo namespaceInfo) {
        ArrayList<TypeInfo> mappedParents = new ArrayList<TypeInfo>();
        JavaClass next = CompilerHelper.getNextMappedSuperClass(descriptorJavaClass, this.typeInfo, this.helper);
        while (next != null) {
            TypeInfo nextInfo = this.typeInfo.get(next.getName());
            mappedParents.add(0, nextInfo);
            next = CompilerHelper.getNextMappedSuperClass(this.helper.getJavaClass(nextInfo.getJavaClassName()), this.typeInfo, this.helper);
        }
        for (TypeInfo nextInfo : mappedParents) {
            List<Property> propertiesInOrder = nextInfo.getNonTransientPropertiesInPropOrder();
            int i = 0;
            while (i < propertiesInOrder.size()) {
                Property nextProp = propertiesInOrder.get(i);
                if (nextProp != null) {
                    Mapping mapping = this.generateMapping(nextProp, descriptor, descriptorJavaClass, namespaceInfo);
                    descriptor.addMapping((CoreMapping)mapping);
                    if (nextProp.isSetUserProperties()) {
                        mapping.setProperties(nextProp.getUserProperties());
                    }
                }
                ++i;
            }
        }
    }

    public CollectionReferenceMapping generateXMLCollectionReferenceMapping(Property property, Descriptor descriptor, NamespaceInfo namespaceInfo, JavaClass referenceClass) {
        XMLCollectionReferenceMapping mapping = new XMLCollectionReferenceMapping();
        this.initializeXMLMapping((XMLMapping)mapping, property);
        this.initializeXMLContainerMapping((XMLContainerMapping)mapping, property.getType().isArray());
        mapping.setUsesSingleNode(property.isXmlList() || property.isAttribute() && (property.getXmlPath() == null || !property.getXmlPath().contains("/")));
        String referenceClassName = referenceClass.getQualifiedName();
        JavaClass collectionType = property.getType();
        if (collectionType.isArray()) {
            JAXBArrayAttributeAccessor accessor = new JAXBArrayAttributeAccessor(mapping.getAttributeAccessor(), mapping.getContainerPolicy(), this.helper.getClassLoader());
            JavaClass componentType = collectionType.getComponentType();
            if (componentType.isArray()) {
                Class adaptedClass = this.classToGeneratedClasses.get(componentType.getName());
                referenceClassName = adaptedClass.getName();
                accessor.setAdaptedClassName(referenceClassName);
                JavaClass baseComponentType = this.getBaseComponentType(componentType);
                if (baseComponentType.isPrimitive()) {
                    Class primitiveClass = XMLConversionManager.getDefaultManager().convertClassNameToClass(baseComponentType.getRawName());
                    accessor.setComponentClass(primitiveClass);
                } else {
                    accessor.setComponentClassName(baseComponentType.getQualifiedName());
                }
            } else {
                accessor.setComponentClassName(componentType.getQualifiedName());
            }
            mapping.setAttributeAccessor((CoreAttributeAccessor)accessor);
        }
        collectionType = this.containerClassImpl(collectionType);
        mapping.useCollectionClassName(collectionType.getRawName());
        mapping.setReferenceClassName(referenceClassName);
        if (property.isSetXmlJoinNodes()) {
            for (XmlJoinNodes.XmlJoinNode xmlJoinNode : property.getXmlJoinNodes().getXmlJoinNode()) {
                this.validateJoinNode(descriptor.getJavaClassName(), property, xmlJoinNode.getReferencedXmlPath(), referenceClass);
                mapping.addSourceToTargetKeyFieldAssociation(xmlJoinNode.getXmlPath(), xmlJoinNode.getReferencedXmlPath());
            }
        } else {
            TypeInfo referenceType = this.typeInfo.get(referenceClass.getQualifiedName());
            String tgtXPath = null;
            if (referenceType != null && referenceType.isIDSet()) {
                Property prop;
                tgtXPath = this.getXPathForField(prop, namespaceInfo, !(prop = referenceType.getIDProperty()).isAttribute(), false).getXPath();
            }
            Object srcXPath = property.getXmlPath() != null ? new XMLField(property.getXmlPath()) : this.getXPathForField(property, namespaceInfo, true, false);
            mapping.addSourceToTargetKeyFieldAssociation(srcXPath.getXPath(), tgtXPath);
        }
        if (property.getInverseReferencePropertyName() != null) {
            mapping.getInverseReferenceMapping().setAttributeName(property.getInverseReferencePropertyName());
            JavaClass backPointerPropertyType = null;
            if (property.getInverseReferencePropertyGetMethodName() != null && property.getInverseReferencePropertySetMethodName() != null && !property.getInverseReferencePropertyGetMethodName().equals("") && !property.getInverseReferencePropertySetMethodName().equals("")) {
                mapping.getInverseReferenceMapping().setGetMethodName(property.getInverseReferencePropertySetMethodName());
                mapping.getInverseReferenceMapping().setSetMethodName(property.getInverseReferencePropertySetMethodName());
                JavaMethod getMethod = referenceClass.getDeclaredMethod(mapping.getInverseReferenceMapping().getGetMethodName(), new JavaClass[0]);
                if (getMethod != null) {
                    backPointerPropertyType = getMethod.getReturnType();
                }
            } else {
                JavaField backpointerField = referenceClass.getDeclaredField(property.getInverseReferencePropertyName());
                if (backpointerField != null) {
                    backPointerPropertyType = backpointerField.getResolvedType();
                }
            }
            if (this.helper.isCollectionType(backPointerPropertyType)) {
                mapping.getInverseReferenceMapping().setContainerPolicy((CoreContainerPolicy)ContainerPolicy.buildDefaultPolicy());
            }
        }
        return mapping;
    }

    public ObjectReferenceMapping generateXMLObjectReferenceMapping(Property property, Descriptor descriptor, NamespaceInfo namespaceInfo, JavaClass referenceClass) {
        XMLObjectReferenceMapping mapping = new XMLObjectReferenceMapping();
        this.initializeXMLMapping((XMLMapping)mapping, property);
        mapping.setReferenceClassName(referenceClass.getQualifiedName());
        if (property.isSetXmlJoinNodes()) {
            for (XmlJoinNodes.XmlJoinNode xmlJoinNode : property.getXmlJoinNodes().getXmlJoinNode()) {
                this.validateJoinNode(descriptor.getJavaClassName(), property, xmlJoinNode.getReferencedXmlPath(), referenceClass);
                mapping.addSourceToTargetKeyFieldAssociation(xmlJoinNode.getXmlPath(), xmlJoinNode.getReferencedXmlPath());
            }
        } else {
            String tgtXPath = null;
            TypeInfo referenceType = this.typeInfo.get(referenceClass.getQualifiedName());
            if (referenceType != null && referenceType.isIDSet()) {
                Property prop;
                tgtXPath = this.getXPathForField(prop, namespaceInfo, !(prop = referenceType.getIDProperty()).isAttribute(), false).getXPath();
            }
            Object srcXPath = property.getXmlPath() != null ? new XMLField(property.getXmlPath()) : this.getXPathForField(property, namespaceInfo, true, false);
            mapping.addSourceToTargetKeyFieldAssociation(srcXPath.getXPath(), tgtXPath);
        }
        if (property.getInverseReferencePropertyName() != null) {
            mapping.getInverseReferenceMapping().setAttributeName(property.getInverseReferencePropertyName());
            JavaClass backPointerPropertyType = null;
            if (property.getInverseReferencePropertyGetMethodName() != null && property.getInverseReferencePropertySetMethodName() != null && !property.getInverseReferencePropertyGetMethodName().equals("") && !property.getInverseReferencePropertySetMethodName().equals("")) {
                mapping.getInverseReferenceMapping().setGetMethodName(property.getInverseReferencePropertySetMethodName());
                mapping.getInverseReferenceMapping().setSetMethodName(property.getInverseReferencePropertySetMethodName());
                JavaMethod getMethod = referenceClass.getDeclaredMethod(mapping.getInverseReferenceMapping().getGetMethodName(), new JavaClass[0]);
                if (getMethod != null) {
                    backPointerPropertyType = getMethod.getReturnType();
                }
            } else {
                JavaField backpointerField = referenceClass.getDeclaredField(property.getInverseReferencePropertyName());
                if (backpointerField != null) {
                    backPointerPropertyType = backpointerField.getResolvedType();
                }
            }
            if (this.helper.isCollectionType(backPointerPropertyType)) {
                mapping.getInverseReferenceMapping().setContainerPolicy((CoreContainerPolicy)ContainerPolicy.buildDefaultPolicy());
            }
        }
        return mapping;
    }

    private void validateJoinNode(String className, Property property, String referencedXmlPath, JavaClass referenceClass) {
        TypeInfo targetInfo = this.typeInfo.get(referenceClass.getQualifiedName());
        NamespaceInfo namespaceInfo = this.packageToPackageInfoMappings.get(referenceClass.getPackageName()).getNamespaceInfo();
        Property idProp = targetInfo.getIDProperty();
        if (idProp != null) {
            String idXpath = idProp.getXmlPath();
            if (idXpath == null) {
                idXpath = this.getXPathForField(idProp, namespaceInfo, !idProp.isAttribute(), false).getXPath();
            }
            if (referencedXmlPath.equals(idXpath)) {
                return;
            }
        }
        boolean matched = false;
        if (targetInfo.getXmlKeyProperties() != null) {
            for (Property xmlkeyProperty : targetInfo.getXmlKeyProperties()) {
                String keyXpath = xmlkeyProperty.getXmlPath();
                if (keyXpath == null) {
                    keyXpath = this.getXPathForField(xmlkeyProperty, namespaceInfo, !xmlkeyProperty.isAttribute(), false).getXPath();
                }
                if (!referencedXmlPath.equals(keyXpath)) continue;
                matched = true;
                break;
            }
        }
        if (!matched) {
            throw JAXBException.invalidReferencedXmlPathOnJoin((String)className, (String)property.getPropertyName(), (String)referenceClass.getQualifiedName(), (String)referencedXmlPath);
        }
    }

    private String prefixCustomXPath(String unprefixedXPath, Property property, NamespaceInfo nsInfo) {
        StringBuilder newXPath = new StringBuilder(32);
        QName schemaName = property.getSchemaName();
        String namespace = schemaName.getNamespaceURI();
        if (namespace == null || namespace.equals("")) {
            return unprefixedXPath;
        }
        String prefix = this.getPrefixForNamespace(namespace, this.getNamespaceResolverForDescriptor(nsInfo));
        if (prefix == null) {
            return unprefixedXPath;
        }
        StringTokenizer st = new StringTokenizer(unprefixedXPath, "/");
        while (st.hasMoreTokens()) {
            String nextToken = st.nextToken();
            if (st.hasMoreTokens()) {
                if (nextToken.lastIndexOf(58) != -1) {
                    newXPath.append(nextToken);
                } else {
                    newXPath.append(prefix).append(':').append(nextToken);
                }
                newXPath.append("/");
                continue;
            }
            newXPath.append(nextToken);
        }
        return newXPath.toString();
    }

    public Field getXPathForField(Property property, NamespaceInfo namespaceInfo, boolean isTextMapping, boolean isAny) {
        XMLField xmlField = null;
        String xPath = property.getXmlPath();
        if (xPath != null) {
            String newXPath = this.prefixCustomXPath(xPath, property, namespaceInfo);
            xmlField = new XMLField(newXPath);
        } else {
            String prefix;
            String namespace;
            StringBuilder xPathBuilder = new StringBuilder();
            if (property.isSetXmlElementWrapper()) {
                XmlElementWrapper wrapper = property.getXmlElementWrapper();
                namespace = wrapper.getNamespace();
                if (namespace.equals("##default")) {
                    namespace = namespaceInfo.isElementFormQualified() ? namespaceInfo.getNamespace() : "";
                }
                if (namespace.equals("")) {
                    xPathBuilder.append(wrapper.getName()).append("/");
                } else {
                    prefix = this.getPrefixForNamespace(namespace, this.getNamespaceResolverForDescriptor(namespaceInfo));
                    xPathBuilder.append(this.getQualifiedString(prefix, String.valueOf(wrapper.getName()) + "/"));
                }
                if (isAny || property.isMap()) {
                    xmlField = new XMLField(xPathBuilder.toString());
                    return xmlField;
                }
            }
            if (property.isAttribute()) {
                if (property.isSetXmlPath()) {
                    xPathBuilder.append(property.getXmlPath());
                } else {
                    QName name = property.getSchemaName();
                    namespace = name.getNamespaceURI();
                    if (namespace.equals("")) {
                        xPathBuilder.append(ATT).append(name.getLocalPart());
                    } else {
                        prefix = this.getPrefixForNamespace(namespace, this.getNamespaceResolverForDescriptor(namespaceInfo));
                        xPathBuilder.append(ATT).append(this.getQualifiedString(prefix, name.getLocalPart()));
                    }
                }
                xmlField = new XMLField(xPathBuilder.toString());
            } else if (property.isXmlValue()) {
                xmlField = this.isBinaryData(property.getActualType()) ? new XMLField(".") : new XMLField("text()");
            } else {
                QName elementName = property.getSchemaName();
                xmlField = this.getXPathForElement(xPathBuilder.toString(), elementName, namespaceInfo, isTextMapping);
            }
        }
        QName schemaType = this.userDefinedSchemaTypes.get(property.getActualType().getQualifiedName());
        if (property.getSchemaType() != null) {
            schemaType = property.getSchemaType();
        }
        if (schemaType == null) {
            String propertyActualTypeRawName = property.getActualType().getRawName();
            if (QName.class.getCanonicalName().equals(propertyActualTypeRawName)) {
                schemaType = (QName)this.helper.getXMLToJavaTypeMap().get(propertyActualTypeRawName);
            }
        }
        if (schemaType != null && !schemaType.equals(Constants.NORMALIZEDSTRING_QNAME)) {
            xmlField.setSchemaType(schemaType);
        }
        return xmlField;
    }

    public Field getXPathForElement(String path, QName elementName, NamespaceInfo namespaceInfo, boolean isText) {
        String namespace = "";
        if (!elementName.getNamespaceURI().equals("")) {
            namespace = elementName.getNamespaceURI();
        }
        if (namespace.equals("")) {
            path = String.valueOf(path) + elementName.getLocalPart();
            if (isText) {
                path = String.valueOf(path) + TXT;
            }
        } else {
            String prefix = this.getPrefixForNamespace(namespace, this.getNamespaceResolverForDescriptor(namespaceInfo));
            path = String.valueOf(path) + this.getQualifiedString(prefix, elementName.getLocalPart());
            if (isText) {
                path = String.valueOf(path) + TXT;
            }
        }
        return new XMLField(path);
    }

    public Property getXmlValueFieldForSimpleContent(ArrayList<Property> properties) {
        boolean foundValue = false;
        boolean foundNonAttribute = false;
        Property valueField = null;
        for (Property prop : properties) {
            if (this.helper.isAnnotationPresent(prop.getElement(), XmlValue.class)) {
                foundValue = true;
                valueField = prop;
                continue;
            }
            if (this.helper.isAnnotationPresent(prop.getElement(), XmlAttribute.class) || this.helper.isAnnotationPresent(prop.getElement(), XmlTransient.class) || prop.isAnyAttribute()) continue;
            foundNonAttribute = true;
        }
        if (foundValue && !foundNonAttribute) {
            return valueField;
        }
        return null;
    }

    public String getSchemaTypeNameForClassName(String className) {
        String typeName = Introspector.decapitalize(className.substring(className.lastIndexOf(46) + 1));
        return typeName;
    }

    public void processGlobalElements(CoreProject project) {
        if (this.globalElements == null && this.localElements == null) {
            return;
        }
        ArrayList<ElementDeclaration> elements = new ArrayList<ElementDeclaration>();
        elements.addAll(this.localElements);
        elements.addAll(this.globalElements.values());
        for (ElementDeclaration nextElement : elements) {
            QName next = nextElement.getElementName();
            String nextClassName = nextElement.getJavaTypeName();
            TypeInfo type = this.typeInfo.get(nextClassName);
            if (this.helper.isBuiltInJavaType(nextElement.getJavaType()) || type != null && type.isEnumerationType()) {
                Class declaredClass4;
                Class generatedClass;
                String attributeTypeName = nextClassName;
                if (nextElement.getJavaType().isPrimitive()) {
                    attributeTypeName = this.helper.getClassForJavaClass(nextElement.getJavaType()).getName();
                }
                if (nextElement.getAdaptedJavaTypeName() != null) {
                    attributeTypeName = nextElement.getAdaptedJavaTypeName();
                }
                if (next == null) {
                    if (this.isBinaryData(nextElement.getJavaType())) {
                        generatedClass = this.addByteArrayWrapperAndDescriptor(type, nextElement.getJavaType().getRawName(), nextElement, nextClassName, attributeTypeName);
                        this.qNamesToGeneratedClasses.put(next, generatedClass);
                        if (nextElement.getTypeMappingInfo() != null) {
                            this.typeMappingInfoToGeneratedClasses.put(nextElement.getTypeMappingInfo(), generatedClass);
                        }
                        try {
                            declaredClass4 = PrivilegedAccessHelper.getClassForName((String)nextClassName, (boolean)false, (ClassLoader)this.helper.getClassLoader());
                            this.qNamesToDeclaredClasses.put(next, declaredClass4);
                        }
                        catch (Exception declaredClass2) {
                            // empty catch block
                        }
                    }
                    if (!nextElement.getJavaType().isEnum() || this.helper.getClassLoader() instanceof DynamicClassLoader) continue;
                    generatedClass = this.addEnumerationWrapperAndDescriptor(type, nextElement.getJavaType().getRawName(), nextElement, nextClassName, attributeTypeName);
                    this.qNamesToGeneratedClasses.put(next, generatedClass);
                    if (nextElement.getTypeMappingInfo() != null) {
                        this.typeMappingInfoToGeneratedClasses.put(nextElement.getTypeMappingInfo(), generatedClass);
                    }
                    try {
                        declaredClass4 = PrivilegedAccessHelper.getClassForName((String)nextClassName, (boolean)false, (ClassLoader)this.helper.getClassLoader());
                        this.qNamesToDeclaredClasses.put(next, declaredClass4);
                    }
                    catch (Exception declaredClass3) {}
                    continue;
                }
                generatedClass = this.generateWrapperClassAndDescriptor(type, next, nextElement, nextClassName, attributeTypeName);
                this.qNamesToGeneratedClasses.put(next, generatedClass);
                if (type != null && type.isEnumerationType() && nextElement.isXmlRootElement()) {
                    this.classToGeneratedClasses.put(type.getJavaClassName(), generatedClass);
                }
                try {
                    declaredClass4 = PrivilegedAccessHelper.getClassForName((String)nextClassName, (boolean)false, (ClassLoader)this.helper.getClassLoader());
                    this.qNamesToDeclaredClasses.put(next, declaredClass4);
                }
                catch (Exception declaredClass4) {}
                continue;
            }
            if (type == null || type.isTransient()) continue;
            if (next.getNamespaceURI() == null || next.getNamespaceURI().equals("")) {
                type.getDescriptor().addRootElement(next.getLocalPart());
                continue;
            }
            Descriptor descriptor = type.getDescriptor();
            String uri = next.getNamespaceURI();
            String prefix = this.getPrefixForNamespace(uri, descriptor.getNamespaceResolver());
            descriptor.addRootElement(this.getQualifiedString(prefix, next.getLocalPart()));
        }
    }

    private Class addByteArrayWrapperAndDescriptor(TypeInfo type, String javaClassName, ElementDeclaration nextElement, String nextClassName, String attributeTypeName) {
        Class generatedClass = this.classToGeneratedClasses.get(javaClassName);
        if (generatedClass == null) {
            generatedClass = this.generateWrapperClassAndDescriptor(type, null, nextElement, nextClassName, attributeTypeName);
            this.classToGeneratedClasses.put(javaClassName, generatedClass);
        }
        return generatedClass;
    }

    private Class addEnumerationWrapperAndDescriptor(TypeInfo type, String javaClassName, ElementDeclaration nextElement, String nextClassName, String attributeTypeName) {
        Class generatedClass = this.classToGeneratedClasses.get(javaClassName);
        if (generatedClass == null) {
            generatedClass = this.generateWrapperClassAndDescriptor(type, nextElement.getElementName(), nextElement, nextClassName, attributeTypeName);
            this.classToGeneratedClasses.put(javaClassName, generatedClass);
        }
        return generatedClass;
    }

    private Class generateWrapperClassAndDescriptor(TypeInfo type, QName next, ElementDeclaration nextElement, String nextClassName, String attributeTypeName) {
        String namespaceUri = null;
        if (next != null && ((namespaceUri = next.getNamespaceURI()) == null || namespaceUri.equals("##default"))) {
            namespaceUri = "";
        }
        TypeMappingInfo tmi = nextElement.getTypeMappingInfo();
        Class generatedClass = null;
        JaxbClassLoader loader = this.getJaxbClassLoader();
        if (tmi != null) {
            generatedClass = CompilerHelper.getExisitingGeneratedClass(tmi, this.typeMappingInfoToGeneratedClasses, this.typeMappingInfoToAdapterClasses, this.helper.getClassLoader());
            if (generatedClass == null) {
                generatedClass = this.generateWrapperClass(loader.nextAvailableGeneratedClassName(), attributeTypeName, nextElement.isList(), next);
            }
            this.typeMappingInfoToGeneratedClasses.put(tmi, generatedClass);
        } else {
            generatedClass = this.generateWrapperClass(loader.nextAvailableGeneratedClassName(), attributeTypeName, nextElement.isList(), next);
        }
        this.qNamesToGeneratedClasses.put(next, generatedClass);
        try {
            Class declaredClass = PrivilegedAccessHelper.getClassForName((String)nextClassName, (boolean)false, (ClassLoader)this.helper.getClassLoader());
            this.qNamesToDeclaredClasses.put(next, declaredClass);
        }
        catch (Exception declaredClass) {
            // empty catch block
        }
        Descriptor desc = (Descriptor)this.project.getDescriptor(generatedClass);
        if (desc == null) {
            Class attributeClassification;
            XMLCompositeDirectCollectionMapping mapping;
            desc = new XMLDescriptor();
            desc.setJavaClass(generatedClass);
            if (nextElement.isList()) {
                mapping = new XMLCompositeDirectCollectionMapping();
                mapping.setAttributeName("value");
                mapping.setXPath("text()");
                mapping.setUsesSingleNode(true);
                mapping.setReuseContainer(true);
                if (type != null && type.isEnumerationType()) {
                    mapping.setValueConverter((CoreConverter)this.buildJAXBEnumTypeConverter((Mapping)mapping, (EnumTypeInfo)type));
                } else {
                    try {
                        Class fieldElementClass = PrivilegedAccessHelper.getClassForName((String)nextClassName, (boolean)false, (ClassLoader)this.helper.getClassLoader());
                        mapping.setFieldElementClass(fieldElementClass);
                    }
                    catch (ClassNotFoundException fieldElementClass) {
                        // empty catch block
                    }
                }
                if (nextClassName.equals("[B") || nextClassName.equals("[Ljava.lang.Byte;")) {
                    ((Field)mapping.getField()).setSchemaType(Constants.BASE_64_BINARY_QNAME);
                } else if (nextClassName.equals("javax.xml.namespace.QName")) {
                    ((Field)mapping.getField()).setSchemaType(Constants.QNAME_QNAME);
                }
                desc.addMapping((CoreMapping)mapping);
            } else if (nextElement.getJavaTypeName().equals(OBJECT_CLASS_NAME)) {
                mapping = new XMLCompositeObjectMapping();
                mapping.setAttributeName("value");
                mapping.setSetMethodName("setValue");
                mapping.setGetMethodName("getValue");
                mapping.setKeepAsElementPolicy((org.eclipse.persistence.internal.oxm.mappings.UnmarshalKeepAsElementPolicy)UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT);
                mapping.setXPath(".");
                this.setTypedTextField((Field)mapping.getField());
                desc.addMapping((CoreMapping)mapping);
            } else if (this.isBinaryData(nextElement.getJavaType())) {
                mapping = new XMLBinaryDataMapping();
                mapping.setAttributeName("value");
                mapping.setXPath(".");
                ((Field)mapping.getField()).setSchemaType(Constants.BASE_64_BINARY_QNAME);
                mapping.setSetMethodName("setValue");
                mapping.setGetMethodName("getValue");
                mapping.getNullPolicy().setNullRepresentedByXsiNil(true);
                mapping.getNullPolicy().setNullRepresentedByEmptyNode(false);
                attributeClassification = Helper.getClassFromClasseName((String)attributeTypeName, (ClassLoader)this.helper.getClassLoader());
                mapping.setAttributeClassification(attributeClassification);
                mapping.setShouldInlineBinaryData(false);
                mapping.setSwaRef(nextElement.isXmlAttachmentRef());
                mapping.setMimeType(nextElement.getXmlMimeType());
                desc.addMapping((CoreMapping)mapping);
            } else {
                mapping = new XMLDirectMapping();
                mapping.setNullValueMarshalled(true);
                mapping.setAttributeName("value");
                mapping.setXPath("text()");
                mapping.setSetMethodName("setValue");
                mapping.setGetMethodName("getValue");
                if (nextElement.getDefaultValue() != null) {
                    mapping.setNullValue((Object)nextElement.getDefaultValue());
                    mapping.getNullPolicy().setNullRepresentedByXsiNil(true);
                }
                if (this.helper.isBuiltInJavaType(nextElement.getJavaType())) {
                    attributeClassification = null;
                    attributeClassification = nextElement.getJavaType().isPrimitive() ? XMLConversionManager.getDefaultManager().convertClassNameToClass(attributeTypeName) : Helper.getClassFromClasseName((String)attributeTypeName, (ClassLoader)this.helper.getClassLoader());
                    mapping.setAttributeClassification(attributeClassification);
                }
                IsSetNullPolicy nullPolicy = new IsSetNullPolicy("isSetValue", false, true, XMLNullRepresentationType.ABSENT_NODE);
                mapping.setNullPolicy((AbstractNullPolicy)nullPolicy);
                if (type != null && type.isEnumerationType()) {
                    mapping.setConverter((CoreConverter)this.buildJAXBEnumTypeConverter((Mapping)mapping, (EnumTypeInfo)type));
                }
                if (nextClassName.equals("[B") || nextClassName.equals("[Ljava.lang.Byte;")) {
                    ((Field)mapping.getField()).setSchemaType(Constants.BASE_64_BINARY_QNAME);
                } else if (nextClassName.equals("javax.xml.namespace.QName")) {
                    ((Field)mapping.getField()).setSchemaType(Constants.QNAME_QNAME);
                }
                if (nextElement.getJavaTypeAdapterClass() != null) {
                    mapping.setConverter((CoreConverter)new XMLJavaTypeConverter(nextElement.getJavaTypeAdapterClass()));
                }
                desc.addMapping((CoreMapping)mapping);
            }
            if (next != null) {
                org.eclipse.persistence.internal.oxm.NamespaceResolver resolver;
                NamespaceInfo info = this.getNamespaceInfoForURI(namespaceUri);
                if (info != null) {
                    resolver = this.getNamespaceResolverForDescriptor(info);
                    String prefix = null;
                    if (namespaceUri != "" && (prefix = resolver.resolveNamespaceURI(namespaceUri)) == null) {
                        prefix = this.getPrefixForNamespace(namespaceUri, resolver);
                    }
                    desc.setNamespaceResolver(resolver);
                    if (nextElement.isXmlRootElement()) {
                        desc.setDefaultRootElement(this.getQualifiedString(prefix, next.getLocalPart()));
                    } else {
                        desc.setDefaultRootElement("");
                        desc.addRootElement(this.getQualifiedString(prefix, next.getLocalPart()));
                        desc.setResultAlwaysXMLRoot(true);
                    }
                } else if (namespaceUri.equals("")) {
                    desc.setDefaultRootElement(next.getLocalPart());
                } else {
                    resolver = new NamespaceResolver();
                    String prefix = this.getPrefixForNamespace(namespaceUri, resolver);
                    desc.setNamespaceResolver(resolver);
                    if (nextElement.isXmlRootElement()) {
                        desc.setDefaultRootElement(this.getQualifiedString(prefix, next.getLocalPart()));
                    } else {
                        desc.setDefaultRootElement("");
                        desc.addRootElement(this.getQualifiedString(prefix, next.getLocalPart()));
                        desc.setResultAlwaysXMLRoot(true);
                    }
                }
            }
            this.project.addDescriptor((CoreDescriptor)desc);
        }
        return generatedClass;
    }

    private String getQualifiedString(String prefix, String localPart) {
        if (prefix == null) {
            return localPart;
        }
        return String.valueOf(prefix) + ':' + localPart;
    }

    private NamespaceInfo getNamespaceInfoForURI(String namespaceUri) {
        Iterator<PackageInfo> namespaces = this.packageToPackageInfoMappings.values().iterator();
        while (namespaces.hasNext()) {
            NamespaceInfo next = namespaces.next().getNamespaceInfo();
            if (!next.getNamespace().equals(namespaceUri)) continue;
            return next;
        }
        return null;
    }

    private String getPackageNameForURI(String namespaceUri) {
        for (String next : this.packageToPackageInfoMappings.keySet()) {
            if (!this.packageToPackageInfoMappings.get(next).getNamespace().equals(namespaceUri)) continue;
            return next;
        }
        return null;
    }

    public Class generateWrapperClass(String className, String attributeType, boolean isList, QName theQName) {
        EclipseLinkASMClassWriter cw = new EclipseLinkASMClassWriter();
        String sig = null;
        cw.visit(1, className.replace(".", "/"), sig, Type.getType(WrappedValue.class).getInternalName(), null);
        String fieldType = null;
        if (isList) {
            fieldType = "Ljava/util/List;";
        } else {
            fieldType = attributeType.replace(".", "/");
            if (!fieldType.startsWith("[")) {
                fieldType = "L" + fieldType + ";";
            }
        }
        if (theQName == null) {
            theQName = RESERVED_QNAME;
        }
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitVarInsn(25, 0);
        mv.visitTypeInsn(187, "javax/xml/namespace/QName");
        mv.visitInsn(89);
        mv.visitLdcInsn((Object)theQName.getNamespaceURI());
        mv.visitLdcInsn((Object)theQName.getLocalPart());
        mv.visitMethodInsn(183, "javax/xml/namespace/QName", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", false);
        mv.visitLdcInsn((Object)Type.getType((String)fieldType));
        mv.visitInsn(1);
        mv.visitMethodInsn(183, "org/eclipse/persistence/internal/jaxb/WrappedValue", "<init>", "(Ljavax/xml/namespace/QName;Ljava/lang/Class;Ljava/lang/Object;)V", false);
        mv.visitInsn(177);
        mv.visitMaxs(5, 1);
        mv.visitEnd();
        cw.visitEnd();
        byte[] classBytes = cw.toByteArray();
        Class generatedClass = this.getJaxbClassLoader().generateClass(className, classBytes);
        return generatedClass;
    }

    public Map<QName, Class> getQNamesToGeneratedClasses() {
        return this.qNamesToGeneratedClasses;
    }

    public Map<String, Class> getClassToGeneratedClasses() {
        return this.classToGeneratedClasses;
    }

    public Map<QName, Class> getQNamesToDeclaredClasses() {
        return this.qNamesToDeclaredClasses;
    }

    private Map<MapEntryGeneratedKey, Class> getGeneratedMapEntryClasses() {
        if (this.generatedMapEntryClasses == null) {
            this.generatedMapEntryClasses = new HashMap<MapEntryGeneratedKey, Class>();
        }
        return this.generatedMapEntryClasses;
    }

    private AbstractNullPolicy getWrapperNullPolicyFromProperty(Property property) {
        NullPolicy nullPolicy = null;
        if (property.isSetXmlElementWrapper()) {
            nullPolicy = new NullPolicy();
            nullPolicy.setNullRepresentedByEmptyNode(false);
            nullPolicy.setSetPerformedForAbsentNode(false);
            if (property.getXmlElementWrapper().isNillable()) {
                nullPolicy.setMarshalNullRepresentation(XMLNullRepresentationType.XSI_NIL);
                nullPolicy.setNullRepresentedByXsiNil(true);
            } else {
                nullPolicy.setMarshalNullRepresentation(XMLNullRepresentationType.ABSENT_NODE);
                nullPolicy.setNullRepresentedByXsiNil(false);
            }
        }
        return nullPolicy;
    }

    private AbstractNullPolicy getNullPolicyFromProperty(Property property, org.eclipse.persistence.internal.oxm.NamespaceResolver nsr) {
        NullPolicy absNullPolicy = null;
        XmlAbstractNullPolicy xmlAbsNullPolicy = property.getNullPolicy();
        if (xmlAbsNullPolicy instanceof XmlNullPolicy) {
            XmlNullPolicy xmlNullPolicy = (XmlNullPolicy)xmlAbsNullPolicy;
            NullPolicy nullPolicy = new NullPolicy();
            nullPolicy.setSetPerformedForAbsentNode(xmlNullPolicy.isIsSetPerformedForAbsentNode());
            absNullPolicy = nullPolicy;
        } else {
            XmlIsSetNullPolicy xmlIsSetNullPolicy = (XmlIsSetNullPolicy)xmlAbsNullPolicy;
            IsSetNullPolicy isSetNullPolicy = new IsSetNullPolicy();
            isSetNullPolicy.setIsSetMethodName(xmlIsSetNullPolicy.getIsSetMethodName());
            ArrayList<Object> parameters = new ArrayList<Object>();
            ArrayList<Class> parameterTypes = new ArrayList<Class>();
            List<XmlIsSetNullPolicy.IsSetParameter> params = xmlIsSetNullPolicy.getIsSetParameter();
            for (XmlIsSetNullPolicy.IsSetParameter param : params) {
                String valueStr = param.getValue();
                String typeStr = param.getType();
                XMLConversionManager mgr = new XMLConversionManager();
                mgr.setLoader(this.helper.getClassLoader());
                Class typeClass = mgr.convertClassNameToClass(typeStr);
                Object parameterValue = mgr.convertObject((Object)valueStr, typeClass);
                parameters.add(parameterValue);
                parameterTypes.add(typeClass);
            }
            isSetNullPolicy.setIsSetParameters(parameters.toArray());
            isSetNullPolicy.setIsSetParameterTypes(parameterTypes.toArray(new Class[parameterTypes.size()]));
            absNullPolicy = isSetNullPolicy;
        }
        absNullPolicy.setMarshalNullRepresentation(XMLNullRepresentationType.valueOf((String)xmlAbsNullPolicy.getNullRepresentationForXml().name()));
        absNullPolicy.setNullRepresentedByEmptyNode(xmlAbsNullPolicy.isEmptyNodeRepresentsNull());
        boolean xsiRepresentsNull = xmlAbsNullPolicy.isXsiNilRepresentsNull();
        if (xsiRepresentsNull) {
            absNullPolicy.setNullRepresentedByXsiNil(true);
        }
        return absNullPolicy;
    }

    private JavaClass getBaseComponentType(JavaClass javaClass) {
        JavaClass componentType = javaClass.getComponentType();
        if (componentType == null) {
            return javaClass;
        }
        if (!componentType.isArray()) {
            return componentType;
        }
        return this.getBaseComponentType(componentType);
    }

    public JaxbClassLoader getJaxbClassLoader() {
        if (this.helper.getClassLoader() instanceof DynamicClassLoader) {
            return (JaxbClassLoader)this.helper.getClassLoader().getParent();
        }
        return (JaxbClassLoader)this.helper.getClassLoader();
    }

    private boolean isBinaryData(JavaClass type) {
        return this.areEquals(type, CoreClassConstants.APBYTE) || this.areEquals(type, "javax.activation.DataHandler") || this.areEquals(type, "java.awt.Image") || this.areEquals(type, "javax.xml.transform.Source") || this.areEquals(type, "javax.mail.internet.MimeMultipart");
    }

    private void initializeXMLContainerMapping(XMLContainerMapping xmlContainerMapping, boolean isArray) {
        xmlContainerMapping.setReuseContainer(!isArray);
        xmlContainerMapping.setDefaultEmptyContainer(false);
    }

    private void initializeXMLMapping(XMLMapping mapping, Property property) {
        mapping.setAttributeName(property.getPropertyName());
        if (property.isSetReadOnly()) {
            mapping.setIsReadOnly(property.isReadOnly());
        }
        if (property.isSetWriteOnly()) {
            mapping.setIsWriteOnly(property.isWriteOnly());
        }
        if (property.isMethodProperty()) {
            if (property.getGetMethodName() == null) {
                String paramTypeAsString = property.getType().getName();
                mapping.setAttributeAccessor((CoreAttributeAccessor)new JAXBSetMethodAttributeAccessor(paramTypeAsString, this.helper.getClassLoader()));
                mapping.setIsReadOnly(true);
                mapping.setSetMethodName(property.getSetMethodName());
            } else if (property.getSetMethodName() == null) {
                mapping.setGetMethodName(property.getGetMethodName());
                mapping.setIsWriteOnly(true);
            } else {
                mapping.setSetMethodName(property.getSetMethodName());
                mapping.setGetMethodName(property.getGetMethodName());
            }
        }
    }

    private JavaClass containerClassImpl(JavaClass collectionType) {
        if (this.areEquals(collectionType, List.class) || this.areEquals(collectionType, Collection.class) || collectionType.isArray() || this.helper.isMapType(collectionType)) {
            return this.jotArrayList;
        }
        if (this.areEquals(collectionType, Set.class)) {
            return this.jotHashSet;
        }
        if (this.areEquals(collectionType, Deque.class) || this.areEquals(collectionType, Queue.class)) {
            return this.jotLinkedList;
        }
        if (this.areEquals(collectionType, NavigableSet.class) || this.areEquals(collectionType, SortedSet.class)) {
            return this.jotTreeSet;
        }
        return collectionType;
    }

    private void processDefaultNamespacePreferences(Collection<PackageInfo> packageInfos) {
        if (this.isDefaultNamespaceAllowed && this.globalNamespaceResolver.getDefaultNamespaceURI() == null) {
            for (PackageInfo packageInfo : packageInfos) {
                NamespaceResolver resolver = packageInfo.getNamespaceInfo().getNamespaceResolver();
                String defaultNS = resolver.getDefaultNamespaceURI();
                if (defaultNS == null) continue;
                this.globalNamespaceResolver.setDefaultNamespaceURI(defaultNS);
                break;
            }
        }
    }

    private org.eclipse.persistence.internal.oxm.NamespaceResolver getNamespaceResolverForDescriptor(NamespaceInfo info) {
        return info.getNamespaceResolverForDescriptor(this.globalNamespaceResolver, this.isDefaultNamespaceAllowed);
    }

    private void logMappingGeneration(Descriptor xmlDescriptor) {
        String i18nmsg = JAXBLocalization.buildMessage((String)"create_mappings", (Object[])new Object[]{xmlDescriptor.getJavaClassName()});
        AbstractSessionLog.getLog().log(1, "moxy", i18nmsg, new Object[0], false);
        for (Mapping xmlMapping : xmlDescriptor.getMappings()) {
            AbstractSessionLog.getLog().log(1, "moxy", xmlMapping.toString(), new Object[0], false);
        }
    }

    private /* synthetic */ Class lambda$2(JavaClass javaClass) throws Exception {
        return PrivilegedAccessHelper.getClassForName((String)javaClass.getRawName(), (boolean)false, (ClassLoader)this.helper.getClassLoader());
    }

    private static final class MapEntryGeneratedKey {
        String keyClassName;
        String valueClassName;

        public MapEntryGeneratedKey(String keyClass, String valueClass) {
            this.keyClassName = keyClass;
            this.valueClassName = valueClass;
        }
    }

    private static final class NullInstantiationPolicy
    extends InstantiationPolicy {
        private NullInstantiationPolicy() {
        }

        public Object buildNewInstance() throws DescriptorException {
            return null;
        }
    }
}

