/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.stream.util.EventReaderDelegate;

public class NamespaceNormalizingXMLEventReaderDelegate
extends EventReaderDelegate {
    private final XMLEventFactory eventFactory;
    private final Map<String, String> namespaceMapping;

    public NamespaceNormalizingXMLEventReaderDelegate(XMLEventReader eventReader, XMLEventFactory eventFactory, Map<String, String> namespaceMapping) {
        super(eventReader);
        this.eventFactory = eventFactory;
        this.namespaceMapping = namespaceMapping;
    }

    @Override
    public XMLEvent peek() throws XMLStreamException {
        return this.normalizeXMLEvent(super.peek());
    }

    @Override
    public XMLEvent nextEvent() throws XMLStreamException {
        return this.normalizeXMLEvent(super.nextEvent());
    }

    private XMLEvent normalizeXMLEvent(XMLEvent xmlEvent) {
        if (xmlEvent.isStartElement()) {
            return this.normalizeNamespace(xmlEvent.asStartElement());
        }
        if (xmlEvent.isEndElement()) {
            return this.normalizeNamespace(xmlEvent.asEndElement());
        }
        return xmlEvent;
    }

    private StartElement normalizeNamespace(StartElement element) {
        this.eventFactory.setLocation(element.getLocation());
        return this.eventFactory.createStartElement(this.normalizeQName(element.getName()), element.getAttributes(), this.normalizeNamespaces(element.getNamespaces()));
    }

    private EndElement normalizeNamespace(EndElement element) {
        this.eventFactory.setLocation(element.getLocation());
        return this.eventFactory.createEndElement(this.normalizeQName(element.getName()), this.normalizeNamespaces(element.getNamespaces()));
    }

    private QName normalizeQName(QName qName) {
        return new QName(this.normalizeNamespaceURI(qName.getNamespaceURI()), qName.getLocalPart());
    }

    private Iterator<Namespace> normalizeNamespaces(Iterator<Namespace> namespaces) {
        ArrayList<Namespace> newNamespaces = new ArrayList<Namespace>();
        while (namespaces.hasNext()) {
            newNamespaces.add(this.normalizeNamespace(namespaces.next()));
        }
        return newNamespaces.iterator();
    }

    private Namespace normalizeNamespace(Namespace namespace) {
        return this.eventFactory.createNamespace(namespace.getPrefix(), this.normalizeNamespaceURI(namespace.getNamespaceURI()));
    }

    private String normalizeNamespaceURI(String namespaceURI) {
        return this.namespaceMapping.getOrDefault(namespaceURI, namespaceURI);
    }
}

