/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.theme;

import java.util.Arrays;
import org.eclipse.rap.rwt.internal.theme.CssValue;

public class CssAnimation
implements CssValue {
    public Animation[] animations = new Animation[0];

    public void addAnimation(String name, int duration, String timingFunction) {
        Animation animation = new Animation(name, duration, timingFunction);
        Animation[] newAnimations = new Animation[this.animations.length + 1];
        System.arraycopy(this.animations, 0, newAnimations, 0, this.animations.length);
        newAnimations[this.animations.length] = animation;
        this.animations = newAnimations;
    }

    @Override
    public String toDefaultString() {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < this.animations.length) {
            if (result.length() != 0) {
                result.append(", ");
            }
            result.append(this.animations[i].name);
            result.append(" ");
            result.append(this.animations[i].duration);
            result.append("ms ");
            result.append(this.animations[i].timingFunction);
            ++i;
        }
        return result.toString();
    }

    public String toString() {
        return "CssAnimation{ " + this.toDefaultString() + " }";
    }

    public int hashCode() {
        return Arrays.hashCode(this.animations);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof CssAnimation) {
            CssAnimation other = (CssAnimation)object;
            return Arrays.equals(this.animations, other.animations);
        }
        return false;
    }

    public static String toCamelCaseString(String string) {
        StringBuilder result = new StringBuilder();
        boolean toUpperCase = false;
        int i = 0;
        while (i < string.length()) {
            char ch = string.charAt(i);
            if (ch == '-') {
                toUpperCase = true;
            } else if (toUpperCase) {
                result.append(Character.toUpperCase(ch));
                toUpperCase = false;
            } else {
                result.append(ch);
            }
            ++i;
        }
        return result.toString();
    }

    public static final class Animation {
        private static final String[] PREDEFINED_NAMES = new String[]{"hoverIn", "hoverOut", "fadeIn", "fadeOut", "slideIn", "slideOut", "flyInLeft", "flyInTop", "flyInRight", "flyInBottom", "flyOutLeft", "flyOutTop", "flyOutRight", "flyOutBottom"};
        private static final String[] PREDEFINED_TIMING_FUNCTIONS = new String[]{"ease", "linear", "ease-in", "ease-out", "ease-in-out"};
        public final String name;
        public final int duration;
        public final String timingFunction;

        private Animation(String name, int duration, String timingFunction) {
            Animation.checkName(name);
            Animation.checkTimingFunction(timingFunction);
            this.name = name;
            this.duration = duration;
            this.timingFunction = timingFunction;
        }

        private static void checkName(String name) {
            boolean result = false;
            if (name == null) {
                throw new NullPointerException("null argument");
            }
            int i = 0;
            while (i < PREDEFINED_NAMES.length && !result) {
                if (name.equals(PREDEFINED_NAMES[i])) {
                    result = true;
                }
                ++i;
            }
            if (!result) {
                String msg = "Invalid value for animation name: " + name;
                throw new IllegalArgumentException(msg);
            }
        }

        private static void checkTimingFunction(String timingFunction) {
            boolean result = false;
            if (timingFunction == null) {
                throw new NullPointerException("null argument");
            }
            int i = 0;
            while (i < PREDEFINED_TIMING_FUNCTIONS.length && !result) {
                if (timingFunction.equals(PREDEFINED_TIMING_FUNCTIONS[i])) {
                    result = true;
                }
                ++i;
            }
            if (!result) {
                String msg = "Invalid value for animation timing function: " + timingFunction;
                throw new IllegalArgumentException(msg);
            }
        }

        public int hashCode() {
            int result = 3;
            result = 31 * result + this.duration;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.timingFunction == null ? 0 : this.timingFunction.hashCode());
            return result;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof Animation) {
                Animation other = (Animation)object;
                return this.duration == other.duration && (this.name == null ? other.name == null : this.name.equals(other.name)) && (this.timingFunction == null ? other.timingFunction == null : this.timingFunction.equals(other.timingFunction));
            }
            return false;
        }
    }
}

