/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.graphics;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.rap.rwt.internal.util.ParamCheck;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.internal.graphics.InternalImage;

final class ImageDataCache {
    private static final int MAX_DATA_SIZE = 1024;
    private final Map<InternalImage, ImageData> cache;
    private final Object cacheLock = new Object();

    ImageDataCache() {
        this.cache = new HashMap<InternalImage, ImageData>(25);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ImageData getImageData(InternalImage internalImage) {
        ImageData cached;
        ParamCheck.notNull(internalImage, "internalImage");
        Object object = this.cacheLock;
        synchronized (object) {
            cached = this.cache.get(internalImage);
        }
        return cached != null ? (ImageData)cached.clone() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putImageData(InternalImage internalImage, ImageData imageData) {
        ParamCheck.notNull(internalImage, "internalImage");
        ParamCheck.notNull(imageData, "imageData");
        if (imageData.data.length <= 1024) {
            Object object = this.cacheLock;
            synchronized (object) {
                this.cache.put(internalImage, (ImageData)imageData.clone());
            }
        }
    }
}

