/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.examples.pages;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.rap.examples.ExampleUtil;
import org.eclipse.rap.examples.IExamplePage;
import org.eclipse.rap.examples.pages.internal.ImageUtil;
import org.eclipse.rap.rwt.SingletonUtil;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class TreeViewerExample
implements IExamplePage {
    private static final int EDITOR_ACTIVATE = 58;
    private static final int MODERN_STYLE = 0;
    private static final int TABLE_STYLE = 1;
    private TreeViewer currentViewer;
    private TreeViewer simpleTree;
    private TreeViewer complexTree;
    private int newItem;

    public void createControl(Composite parent) {
        parent.setLayout((Layout)ExampleUtil.createMainLayout((int)2));
        this.createTopLeft(parent);
        this.createTopRight(parent);
        this.createFooter(parent);
        this.setFocus();
    }

    private void createTopLeft(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)ExampleUtil.createFillData());
        composite.setLayout((Layout)ExampleUtil.createFillLayout((boolean)true));
        this.simpleTree = this.createSimpleTree(composite);
    }

    private void createTopRight(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)ExampleUtil.createFillData());
        composite.setLayout((Layout)ExampleUtil.createFillLayout((boolean)true));
        this.complexTree = this.createComplexTree(composite);
    }

    private void createFooter(Composite parent) {
        Composite footerComp = new Composite(parent, 0);
        footerComp.setLayout((Layout)ExampleUtil.createRowLayout((int)256, (boolean)true));
        this.createControlButtons(footerComp);
    }

    private void setFocus() {
        Tree tree = this.simpleTree.getTree();
        tree.forceFocus();
        tree.select(tree.getItem(0));
    }

    private void createControlButtons(Composite parent) {
        Button newButton = new Button(parent, 8);
        newButton.setText("New Item");
        newButton.addSelectionListener((SelectionListener)new NewButtonSelectionHandler());
        Button removeButton = new Button(parent, 8);
        removeButton.setText("Remove Item(s)");
        removeButton.addSelectionListener((SelectionListener)new RemoveButtonSelectionHandler());
    }

    private TreeViewer createSimpleTree(Composite parent) {
        Tree tree = new Tree(parent, 67586);
        TreeViewer result = new TreeViewer(tree);
        result.setContentProvider((IContentProvider)new TreeContentProvider());
        TreeLabelProvider labelProvider = new TreeLabelProvider((Device)parent.getDisplay(), 0);
        result.setLabelProvider((IBaseLabelProvider)labelProvider);
        result.setInput((Object)TreeViewerExample.createModel());
        result.expandAll();
        tree.addFocusListener((FocusListener)new TreeFocusGainedHandler());
        TreeViewerExample.addDNDSupport(result);
        TreeViewerExample.addCellEditor(result);
        TreeViewerExample.addToolTipSupport(result);
        return result;
    }

    private TreeViewer createComplexTree(Composite parent) {
        int style = 67618;
        Tree tree = new Tree(parent, style);
        TreeViewerExample.createColumn(tree, "City", 16384, 185);
        TreeViewerExample.createColumn(tree, "Timezone", 0x1000000, 85);
        TreeViewerExample.createColumn(tree, "Offset", 0x1000000, 65);
        tree.setLinesVisible(true);
        tree.setHeaderVisible(true);
        CheckboxTreeViewer result = new CheckboxTreeViewer(tree);
        result.addCheckStateListener((ICheckStateListener)new TreeCheckStateListener(result));
        result.setContentProvider((IContentProvider)new TreeContentProvider());
        TreeLabelProvider labelProvider = new TreeLabelProvider((Device)parent.getDisplay(), 1);
        result.setLabelProvider((IBaseLabelProvider)labelProvider);
        result.setInput((Object)TreeViewerExample.createModel());
        result.expandAll();
        tree.addFocusListener((FocusListener)new TreeFocusGainedHandler());
        TreeViewerExample.addDNDSupport((TreeViewer)result);
        TreeViewerExample.addCellEditor((TreeViewer)result);
        TreeViewerExample.addToolTipSupport((TreeViewer)result);
        return result;
    }

    private static TreeColumn createColumn(Tree parent, String name, int style, int width) {
        TreeColumn result = new TreeColumn(parent, style);
        result.setText(name);
        result.setWidth(width);
        result.setMoveable(true);
        result.setResizable(true);
        return result;
    }

    private static void addDNDSupport(TreeViewer viewer) {
        Transfer[] types = new Transfer[]{TreeObjectTransfer.getInstance()};
        TreeDragListener dragListener = new TreeDragListener(viewer);
        viewer.addDragSupport(2, types, (DragSourceListener)dragListener);
        TreeDropListener dropListener = new TreeDropListener(viewer);
        viewer.addDropSupport(2, types, (DropTargetListener)dropListener);
    }

    private static void addCellEditor(TreeViewer viewer) {
        CellEditor[] editors = new CellEditor[]{new TextCellEditor((Composite)viewer.getTree()), new TextCellEditor((Composite)viewer.getTree()), new TextCellEditor((Composite)viewer.getTree())};
        viewer.setCellEditors(editors);
        viewer.setCellModifier((ICellModifier)new CellModifier(viewer));
        String[] columnProperties = new String[]{"Name", "Timezone", "Offset"};
        viewer.setColumnProperties(columnProperties);
        CellEditorActivationStrategy activationStrategy = new CellEditorActivationStrategy((ColumnViewer)viewer);
        TreeViewerEditor.create((TreeViewer)viewer, (ColumnViewerEditorActivationStrategy)activationStrategy, (int)58);
    }

    private static void addToolTipSupport(TreeViewer viewer) {
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)viewer);
    }

    private static TreeObject createModel() {
        TreeObject result = new TreeObject("");
        TreeObject asia = new TreeObject("Asia");
        result.addChild(asia);
        asia.addChild(new City("Hong Kong", "HKT", 8));
        asia.addChild(new City("Tokyo", "JST", 9));
        TreeObject europe = new TreeObject("Europe");
        result.addChild(europe);
        europe.addChild(new City("Lisbon", "WET", 0));
        europe.addChild(new City("Berlin", "CET", 1));
        europe.addChild(new City("Sofia", "EET", 2));
        europe.addChild(new City("Moscow", "MT", 3));
        TreeObject northAmerica = new TreeObject("North America");
        result.addChild(northAmerica);
        northAmerica.addChild(new City("New York", "EST", -5));
        northAmerica.addChild(new City("Chicago", "CST", -6));
        northAmerica.addChild(new City("Los Angeles", "PST", -8));
        northAmerica.addChild(new City("Anchorage", "AKST", -9));
        return result;
    }

    private static final class CellEditorActivationStrategy
    extends ColumnViewerEditorActivationStrategy {
        CellEditorActivationStrategy(ColumnViewer viewer) {
            super(viewer);
        }

        protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
            boolean isProgrammatic;
            boolean isTraversal = event.eventType == 5;
            boolean isDoubleClick = event.eventType == 3;
            boolean bl = isProgrammatic = event.eventType == 4;
            return isTraversal || isDoubleClick || isProgrammatic;
        }
    }

    private static final class CellModifier
    implements ICellModifier {
        private final TreeViewer viewer;

        CellModifier(TreeViewer viewer) {
            this.viewer = viewer;
        }

        public boolean canModify(Object element, String property) {
            return element instanceof City || property.equals("Name");
        }

        public Object getValue(Object element, String property) {
            String result = "";
            TreeObject treeObject = (TreeObject)element;
            if (property.equals("Name")) {
                result = treeObject.getTitle();
            } else if (property.equals("Timezone")) {
                City city = (City)treeObject;
                result = city.getTimeZone();
            } else if (property.equals("Offset")) {
                City city = (City)treeObject;
                result = String.valueOf(city.getOffset());
            } else {
                throw new IllegalArgumentException("Unkown property " + property);
            }
            return result;
        }

        public void modify(Object element, String property, Object value) {
            TreeObject treeObject = element instanceof Item ? (TreeObject)((Item)element).getData() : (TreeObject)element;
            String string = (String)value;
            if (property.equals("Name")) {
                treeObject.setName(string);
            } else if (property.equals("Timezone")) {
                City city = (City)treeObject;
                city.setTimeZone(string);
            } else if (property.equals("Offset")) {
                City city = (City)treeObject;
                try {
                    city.setOffset(Integer.parseInt(string));
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                throw new IllegalArgumentException("Unkown property " + property);
            }
            this.viewer.update((Object)treeObject, new String[]{property});
        }
    }

    private static class City
    extends TreeObject {
        private String timezone;
        private int offset;

        public City(String name, String timezone, int offset) {
            super(name);
            this.setTimeZone(timezone);
            this.setOffset(offset);
        }

        private void setOffset(int offset) {
            this.offset = offset;
        }

        public void setTimeZone(String tz) {
            this.timezone = tz;
        }

        private int getOffset() {
            return this.offset;
        }

        public String getTimeZone() {
            return this.timezone;
        }
    }

    private final class NewButtonSelectionHandler
    extends SelectionAdapter {
        private NewButtonSelectionHandler() {
        }

        public void widgetSelected(SelectionEvent event) {
            if (TreeViewerExample.this.currentViewer != null && !TreeViewerExample.this.currentViewer.getSelection().isEmpty()) {
                ITreeSelection sel = (ITreeSelection)TreeViewerExample.this.currentViewer.getSelection();
                TreeObject obj = (TreeObject)sel.getFirstElement();
                ++TreeViewerExample.this.newItem;
                City newObject = new City("New Item " + TreeViewerExample.this.newItem, "", 0);
                obj.addChild(newObject);
                TreeViewerExample.this.currentViewer.expandToLevel((Object)obj, 1);
                TreeViewerExample.this.currentViewer.refresh();
                TreeViewerExample.this.currentViewer.setSelection((ISelection)new StructuredSelection((Object)newObject));
                TreeViewerExample.this.currentViewer.getTree().forceFocus();
            }
        }
    }

    private final class RemoveButtonSelectionHandler
    extends SelectionAdapter {
        private RemoveButtonSelectionHandler() {
        }

        public void widgetSelected(SelectionEvent event) {
            if (TreeViewerExample.this.currentViewer != null && !TreeViewerExample.this.currentViewer.getSelection().isEmpty()) {
                ITreeSelection sel = (ITreeSelection)TreeViewerExample.this.currentViewer.getSelection();
                Iterator iterator = sel.iterator();
                TreeObject parent = null;
                while (iterator.hasNext()) {
                    TreeObject obj = (TreeObject)iterator.next();
                    parent = obj.getParent();
                    if (parent == null) continue;
                    parent.removeChild(obj);
                }
                if (parent != null) {
                    TreeObject newSel = null;
                    if (parent.getParent() == null) {
                        TreeObject[] children = parent.getChildren();
                        if (children.length > 0) {
                            newSel = children[0];
                        }
                    } else {
                        newSel = parent;
                    }
                    if (newSel != null) {
                        TreeViewerExample.this.currentViewer.setSelection((ISelection)new StructuredSelection((Object)newSel));
                    }
                }
                TreeViewerExample.this.currentViewer.refresh();
                TreeViewerExample.this.currentViewer.getTree().forceFocus();
            }
        }
    }

    private static class TreeCheckStateListener
    implements ICheckStateListener {
        private final CheckboxTreeViewer viewer;

        TreeCheckStateListener(CheckboxTreeViewer viewer) {
            this.viewer = viewer;
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            TreeObject treeObject = (TreeObject)event.getElement();
            boolean checked = event.getChecked();
            this.updateChildren(checked, treeObject);
            this.updateParent(treeObject);
        }

        private void updateParent(TreeObject treeObject) {
            TreeObject parent = treeObject.getParent();
            if (parent != null) {
                boolean parentChecked = true;
                TreeObject[] children = parent.getChildren();
                int i = 0;
                while (parentChecked && i < children.length) {
                    TreeObject child = children[i];
                    if (!this.viewer.getChecked((Object)child)) {
                        parentChecked = false;
                    }
                    ++i;
                }
                this.viewer.setChecked((Object)parent, parentChecked);
                this.updateParent(parent);
            }
        }

        private void updateChildren(boolean checked, TreeObject parent) {
            TreeObject[] children = parent.getChildren();
            int i = 0;
            while (i < children.length) {
                TreeObject treeObject = children[i];
                this.viewer.setChecked((Object)treeObject, checked);
                if (treeObject.hasChildren()) {
                    this.updateChildren(checked, treeObject);
                }
                ++i;
            }
        }
    }

    private static class TreeContentProvider
    implements ITreeContentProvider {
        private TreeContentProvider() {
        }

        public Object[] getElements(Object parent) {
            return this.getChildren(parent);
        }

        public Object getParent(Object child) {
            TreeObject result = null;
            if (child instanceof City) {
                result = ((City)child).getParent();
            }
            return result;
        }

        public Object[] getChildren(Object parent) {
            Object[] result = new Object[]{};
            if (parent instanceof TreeObject) {
                result = ((TreeObject)parent).getChildren();
            }
            return result;
        }

        public boolean hasChildren(Object parent) {
            boolean result = false;
            if (parent instanceof TreeObject) {
                result = ((TreeObject)parent).hasChildren();
            }
            return result;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    private static class TreeDragListener
    extends DragSourceAdapter {
        private final TreeViewer viewer;
        private Object dragData;

        TreeDragListener(TreeViewer viewer) {
            this.viewer = viewer;
        }

        public void dragStart(DragSourceEvent event) {
            this.dragData = this.getTreeObject(event.x, event.y);
        }

        public void dragSetData(DragSourceEvent event) {
            event.data = this.dragData;
        }

        public void dragFinished(DragSourceEvent event) {
            this.viewer.refresh();
        }

        private TreeObject getTreeObject(int x, int y) {
            TreeObject result = null;
            ViewerCell cell = this.viewer.getCell(new Point(x, y));
            if (cell != null) {
                result = (TreeObject)cell.getElement();
            }
            return result;
        }
    }

    private static class TreeDropListener
    extends DropTargetAdapter {
        private final TreeViewer viewer;

        public TreeDropListener(TreeViewer viewer) {
            this.viewer = viewer;
        }

        public void dragEnter(DropTargetEvent event) {
            event.feedback = 25;
        }

        public void drop(DropTargetEvent event) {
            if (event.data == null || event.item == null) {
                event.detail = 0;
            } else {
                TreeObject draggedObject = (TreeObject)event.data;
                TreeObject targetObject = (TreeObject)event.item.getData();
                if (TreeDropListener.isValidDrop(draggedObject, targetObject)) {
                    draggedObject.getParent().removeChild(draggedObject);
                    targetObject.addChild(draggedObject);
                    this.viewer.refresh();
                }
            }
        }

        private static boolean isValidDrop(TreeObject draggedObject, TreeObject targetObject) {
            boolean result = false;
            if (draggedObject != null && targetObject != null) {
                result = true;
                TreeObject current = targetObject;
                while (current != null && result) {
                    result = current != draggedObject;
                    current = current.getParent();
                }
            }
            return result;
        }
    }

    private final class TreeFocusGainedHandler
    extends FocusAdapter {
        private TreeFocusGainedHandler() {
        }

        public void focusGained(FocusEvent event) {
            TreeViewerExample.this.currentViewer = null;
            Tree currentTree = (Tree)event.widget;
            if (TreeViewerExample.this.simpleTree.getTree() == currentTree) {
                TreeViewerExample.this.currentViewer = TreeViewerExample.this.simpleTree;
            } else if (TreeViewerExample.this.complexTree.getTree() == currentTree) {
                TreeViewerExample.this.currentViewer = TreeViewerExample.this.complexTree;
            }
        }
    }

    private static final class TreeLabelProvider
    extends CellLabelProvider {
        private static final String ICON_GREENDOT = "greendot.gif";
        private static final String ICON_WORLD = "world.gif";
        private static final String ICON_EARTH = "earth-icon.png";
        private static final int COLUMN_TEXT = 0;
        private static final int COLUMN_OFFSET = 2;
        private static final int COLUMN_TIMEZONE = 1;
        private final Device device;
        private final Image continentImage;
        private final Image cityImage;
        private final Font cityFont;
        private final Font continentFont;
        private final Color timezoneTextColor;
        private final Color offsetTextColor;
        private final int style;

        TreeLabelProvider(Device device, int style) {
            this.device = device;
            this.style = style;
            this.cityFont = this.createFont("Times New Roman", 13, 0);
            this.continentFont = this.createFont("Arial", 14, 2);
            this.timezoneTextColor = new Color(device, 239, 41, 41);
            this.offsetTextColor = new Color(device, 252, 175, 62);
            if (style == 0) {
                this.continentImage = ImageUtil.getImage(device, ICON_EARTH);
                this.cityImage = ImageUtil.getImage(device, ICON_GREENDOT);
            } else {
                this.continentImage = ImageUtil.getImage(device, ICON_WORLD);
                this.cityImage = ImageUtil.getImage(device, ICON_GREENDOT);
            }
        }

        public void update(ViewerCell cell) {
            TreeObject treeObject = (TreeObject)cell.getElement();
            int columnIndex = cell.getColumnIndex();
            switch (columnIndex) {
                case 0: {
                    this.updateName(cell, treeObject);
                    break;
                }
                case 1: {
                    this.updateTimeZone(cell, treeObject);
                    break;
                }
                case 2: {
                    this.updateOffset(cell, treeObject);
                }
            }
        }

        public String getToolTipText(Object element) {
            Object result = "";
            if (element instanceof City) {
                City city = (City)element;
                String name = city.getTitle();
                String timeZone = city.getTimeZone();
                String utcOffset = TreeLabelProvider.getUTCOffset(city);
                result = name + " (" + timeZone + ", " + utcOffset + ")";
            }
            return result;
        }

        private void updateName(ViewerCell cell, TreeObject treeObject) {
            cell.setText(treeObject.name);
            if (this.style == 0) {
                if (treeObject instanceof City) {
                    cell.setFont(this.cityFont);
                } else {
                    cell.setFont(this.continentFont);
                }
            }
            cell.setImage(treeObject instanceof City ? this.cityImage : this.continentImage);
        }

        private void updateTimeZone(ViewerCell cell, TreeObject treeObject) {
            if (treeObject instanceof City) {
                City city = (City)treeObject;
                cell.setText(city.getTimeZone());
                if (this.style == 1) {
                    cell.setForeground(this.timezoneTextColor);
                }
            }
        }

        private void updateOffset(ViewerCell cell, TreeObject treeObject) {
            if (treeObject instanceof City) {
                if (this.style == 1) {
                    cell.setForeground(this.offsetTextColor);
                }
                City city = (City)treeObject;
                cell.setText(TreeLabelProvider.getUTCOffset(city));
            }
        }

        private Font createFont(String name, int size, int style) {
            FontData fontData = new FontData(name, size, style);
            return new Font(this.device, fontData);
        }

        private static String getUTCOffset(City city) {
            String sign = city.getOffset() >= 0 ? "-" : "";
            return "UTC " + sign + String.valueOf(city.getOffset());
        }
    }

    private static class TreeObject {
        private final List<TreeObject> children;
        private String name;
        private TreeObject parent;

        public TreeObject(String name) {
            this.setName(name);
            this.children = new ArrayList<TreeObject>();
        }

        public void setParent(TreeObject parent) {
            this.parent = parent;
        }

        public TreeObject getParent() {
            return this.parent;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getTitle() {
            return this.name;
        }

        public void addChild(TreeObject child) {
            this.children.add(child);
            child.setParent(this);
        }

        public void removeChild(TreeObject child) {
            this.children.remove(child);
            child.setParent(null);
        }

        public TreeObject[] getChildren() {
            TreeObject[] result = new TreeObject[this.children.size()];
            this.children.toArray(result);
            return result;
        }

        public boolean hasChildren() {
            return this.children.size() > 0;
        }

        public String toString() {
            return this.name;
        }
    }

    private static class TreeObjectTransfer
    extends Transfer {
        private static final String TYPE_NAME = "treeObject";
        private static final int TYPE_ID = TreeObjectTransfer.registerType((String)"treeObject");

        private TreeObjectTransfer() {
        }

        public static TreeObjectTransfer getInstance() {
            return (TreeObjectTransfer)((Object)SingletonUtil.getSessionInstance(TreeObjectTransfer.class));
        }

        protected int[] getTypeIds() {
            return new int[]{TYPE_ID};
        }

        protected String[] getTypeNames() {
            return new String[]{TYPE_NAME};
        }

        public TransferData[] getSupportedTypes() {
            int[] types = this.getTypeIds();
            TransferData[] result = new TransferData[types.length];
            int i = 0;
            while (i < types.length) {
                result[i] = new TransferData();
                result[i].type = types[i];
                ++i;
            }
            return result;
        }

        public boolean isSupportedType(TransferData transferData) {
            boolean result = false;
            if (transferData != null) {
                int[] types = this.getTypeIds();
                int i = 0;
                while (!result && i < types.length) {
                    if (transferData.type == types[i]) {
                        result = true;
                    }
                    ++i;
                }
            }
            return result;
        }

        public void javaToNative(Object object, TransferData transferData) {
            transferData.data = object;
        }

        public Object nativeToJava(TransferData transferData) {
            return transferData.data;
        }
    }
}

